/***********************************************************************************
* @Archivo javascript para el manejo de pantalla del inicio session
* @fecha de creacion: 07/08/2008
* @autor: Ing. Gusmary Balza
*************************************************************
* @fecha modificacion:
* @descripcion:
* @autor:
***********************************************************************************/

ruta  = 'controlador/sss/sigesp_ctr_sss_inicio.php';  
dsbasedatos = '';
dsempresa = '';
var panel = '';
barraherramienta    = false;
Ext.onReady
(
	function()
	{	
		Ext.QuickTips.init();
		Ext.Ajax.timeout=36000000;
		//Cargar los datos de las base de datos para asociarlos al combo.
		var datosNuevo={'raiz':[{'codbasedatos':'db','basedatos':'Esp ere...'}]};
		
		record = Ext.data.Record.create([
			{name: 'codbasedatos'},     
			{name: 'basedatos'}
		]);					
		dsbasedatos =  new Ext.data.Store({
				proxy: new Ext.data.MemoryProxy(datosNuevo),
				reader: new Ext.data.JsonReader(
				{
					root: 'raiz',               
					id: 'id'   
				},
				record
				),
				data: datosNuevo			
			 });		
		
		//Cargar los datos de las empresas para asociarlos al combo. 
		var datosEmpresa={'raiz':[{'codemp':'0001','nombre':'E sper e...'}]};
		
		record = Ext.data.Record.create([
			{name: 'codemp'},     
			{name: 'nombre'}
		]);					
		dsempresa =  new Ext.data.Store({
				proxy: new Ext.data.MemoryProxy(datosEmpresa),
				reader: new Ext.data.JsonReader(
				{
					root: 'raiz',               
					id: 'id'   
				},
				record
				),
				data: datosEmpresa			
			 });
	

		Ext.QuickTips.init();
		// turn on validation errors beside the field globally
		Ext.form.Field.prototype.msgTarget = 'side';

		Xpos=((screen.width/2)-(350/2)); 
		Ypos=((screen.height/2)-(470/2));
		
		var password = new Ext.form.TextField({
			fieldLabel:'Contrasea',
			name:'contrasea',
			inputType:'password',
			id:'txtpasusuario',
			width:170,
			enableKeyEvents:true,
		    listeners:{
		    	'keypress':function(Obj,e)
		    	{
					var whichCode = e.keyCode; 
			        if (whichCode == 13)  
			     	{					      		
			      		irAceptar();				      
			     	}
		   		}				   
		   	}
		});

		Ypos+=100;
		//Panel con los componentes del formulario
		panel = new Ext.FormPanel({
        //labelWidth: 90,
		height: 300,
		width: 450,
	   	title: 'Parametros de Conexion',
		bodyStyle:'padding:10px 10px 0',
		style:'position:absolute;top:'+Ypos+'px;left:'+Xpos+'px',
		items:[{
				xtype:'fieldset',
				title:'Datos de la Empresa',
				id:'fsinicio',
				autoHeight:true,
				items:[{
					xtype:'combo',
					fieldLabel:'Base de Datos',
					name:'base de datos',
					id:'cmbbasedatos',
					emptyText:'Seleccione',
					displayField:'basedatos',
					valueField:'basedatos',
					typeAhead: true,
					mode: 'local',
					triggerAction: 'all',
					store: dsbasedatos,
					width:250
				  },{
					xtype:'combo',
					fieldLabel:'Empresa',
					name:'empresa',
					id:'cmbempresa',
					emptyText:'Seleccione',
					displayField:'nombre',
					valueField:'codemp',
					typeAhead: true,
					mode: 'local',
					triggerAction: 'all',
					store: dsempresa,
					listWidth:250, 
					width:250,
		        	listeners:{
								'blur':function(objeto)
								{
									codemp = objeto.getValue();
									irSession(codemp);
								}
						}				
				}]
			  },{
				xtype:'fieldset',
				id:'fsusuario',
				title:'Datos del Usuario',
			  	autoHeight:true,
				items:[{
					xtype:'textfield',
					fieldLabel:'Usuario',
					name:'usuario',
					id:'txtcodusuario',
					width:170
				  },
				  password,
				  {
					xtype: 'virtualkeyboard',
					keyboardTarget: password,
					language: 'Spanish-SP',
					languageSelection: false
				}]
			  },{
				buttons: [{
            		text: 'Aceptar',
					style: 'position:absolute;left:70px',
					handler: irAceptar
     			},{
            		text: 'Cancelar',
					style: 'position:absolute;left:170px',
					handler: irCancelar
       		 	}]
			  }]
		});
		panel.render(document.body);		
		irBasedatos();	


/***********************************************************************************
* @Funcion para encriptar la contrasea del usuario. 
* @parametros: 
* @retorno:
* @fecha de creacion: 01/08/2008.
* @autor: Ing. Gusmary Balza
************************************************************************************
* @fecha modificacion:
* @descripcion:
* @autor:
***********************************************************************************/		
	function encriptar()
	{			
		if (validarObjetos('txtpasusuario','50','novacio')!='0')
		{
			var pasusuario = panel.getComponent('fsusuario').getComponent('txtpasusuario').getValue();
			pasusuario = 'sigesp'+pasusuario;
			panel.getComponent('fsusuario').getComponent('txtpasusuario').setValue(b64_sha1(pasusuario));
		}
	}
		

/***********************************************************************************
* @Funcion para llenar el combo de base de datos.     
* @parametros: 
* @retorno:
* @fecha de creacion: 31/07/2008.
* @autor: Ing. Yesenia Moreno de Lang.
************************************************************************************
* @fecha modificacion:
* @descripcion:
* @autor:
***********************************************************************************/		
	function irBasedatos()
	{
		var objdata ={'operacion': 'obtenerbd'};
		
		objdata=JSON.stringify(objdata);
		
		parametros = 'objdata='+objdata; 
		Ext.Ajax.request({
			url : ruta,
			params : parametros,
			method: 'POST',
			success: function (resultad,request)
			{
				datos = resultad.responseText;
				var datajson = eval('(' + datos + ')');
				if (datajson.raiz!=null)
				{
					dsbasedatos.loadData(datajson);
				}
			},
			failure: function ( result, request)
			{ 
				Ext.MessageBox.alert('Error', result.responseText); 
			}
		});	
		panel.getComponent('fsinicio').getComponent('cmbbasedatos').addListener('select',buscarEmpresas);
	}
	
	
/***********************************************************************************
* @Funcion para buscar las empresas de acuerdo a la base de datos seleccionada.   
* @parametros: 
* @retorno:
* @fecha de creacion: 01/08/2008.
* @autor: Ing. Gusmary Balza.
************************************************************************************
* @fecha modificacion:
* @descripcion:
* @autor:
***********************************************************************************/		
	function buscarEmpresas()
	{
		valorBd=panel.getComponent('fsinicio').getComponent('cmbbasedatos').getValue();
		panel.getComponent('fsinicio').getComponent('cmbempresa').setValue('');
		panel.getComponent('fsusuario').getComponent('txtcodusuario').setValue('');
		panel.getComponent('fsusuario').getComponent('txtpasusuario').setValue('');
		irEmpresa(valorBd);	
	}
	
	
/***********************************************************************************
* @Funcion para llenar el combo de las empresas.     
* @parametros: 
* @retorno:
* @fecha de creacion: 01/08/2008.
* @autor: Ing. Gusmary Balza.
************************************************************************************
* @fecha modificacion:
* @descripcion:
* @autor:
***********************************************************************************/		
	function irEmpresa(bd)
	{		
		var objdata ={'operacion': 'obtenerempresa','basedatos':bd};		
		objdata=JSON.stringify(objdata);		
		parametros = 'objdata='+objdata; 
		Ext.Ajax.request({
			url : ruta,
			params : parametros,
			method: 'POST',
			success: function (resultad,request)
			{
				datos = resultad.responseText;
				var datajson = eval('(' + datos + ')');
				if (datajson.raiz!=null)
				{
					dsempresa.loadData(datajson);
				}
			},
			failure: function ( result, request)
			{ 
				Ext.MessageBox.alert('Error', result.responseText); 
			}
		});	 
	}

/***********************************************************************************
* @Funcion para llenar las variables de session de la empresa     
* @parametros: 
* @retorno:
* @fecha de creacion: 10/11/2017.
* @autor: Ing. Yesenia Moreno.
************************************************************************************
* @fecha modificacion:
* @descripcion:
* @autor:
***********************************************************************************/		
	function irSession(codemp)
	{		
		var objdata ={'operacion': 'cargarsession','basedatos':panel.getComponent('fsinicio').getComponent('cmbbasedatos').getValue(),'empresa':codemp};		
		objdata=JSON.stringify(objdata);		
		parametros = 'objdata='+objdata; 
		Ext.Ajax.request({
			url : ruta,
			params : parametros,
			method: 'POST',
			success: function (resultad,request)
			{
				panel.getComponent('fsusuario').getComponent('txtcodusuario').setValue('');
				panel.getComponent('fsusuario').getComponent('txtpasusuario').setValue('');
				panel.getComponent('fsusuario').getComponent('txtcodusuario').focus(true,true);
			},
			failure: function ( result, request)
			{ 
				Ext.MessageBox.alert('Error', result.responseText); 
			}
		});	 
	}


/***********************************************************************************
* @Funcion para limpiar todos los campos.    
* @parametros: 
* @retorno:
* @fecha de creacion: 01/08/2008.
* @autor: Ing. Gusmary Balza.
************************************************************************************
* @fecha modificacion:
* @descripcion:
* @autor:
***********************************************************************************/		
	function irCancelar()
	{
		panel.getComponent('fsinicio').getComponent('cmbbasedatos').setValue('');
		panel.getComponent('fsinicio').getComponent('cmbempresa').setValue('');
		panel.getComponent('fsusuario').getComponent('txtcodusuario').setValue('');
		panel.getComponent('fsusuario').getComponent('txtpasusuario').setValue('');
	}


/***********************************************************************************
* @Funcion para iniciar la sesion.     
* @parametros: 
* @retorno:
* @fecha de creacion: 01/08/2008.
* @autor: Ing. Gusmary Balza.
************************************************************************************
* @fecha modificacion:
* @descripcion:
* @autor:
***********************************************************************************/		
	function irAceptar()
	{
		encriptar();
		if ((validarObjetos('cmbbasedatos','100','novacio')!='0') && (validarObjetos('cmbempresa','100','novacio')!='0') && (validarObjetos('txtcodusuario','20','novacio|alfanumerico')!='0'))
		{		
			var objdata ={
				'operacion': 'iniciarsesion', 
				'basedatos': panel.getComponent('fsinicio').getComponent('cmbbasedatos').getValue(), 
				'codempresa': panel.getComponent('fsinicio').getComponent('cmbempresa').getValue(), 
				'codusuario': panel.getComponent('fsusuario').getComponent('txtcodusuario').getValue(),
				'pasusuario': panel.getComponent('fsusuario').getComponent('txtpasusuario').getValue()
			};
			objdata=JSON.stringify(objdata);		
			parametros = 'objdata='+objdata; 
			Ext.Ajax.request({
				url : ruta,
				params : parametros,
				method: 'POST',
				success: function (resultad,request)
				{
					datos = resultad.responseText;
					var dataJson= eval('(' + datos + ')');
					if (dataJson.raiz.valido==true)
					{
						irCancelar();
						ancho=screen.width-50;
						alto=screen.height-50;
						Xpos=((screen.width - ancho)/2); 
						Ypos=((screen.height - alto) /2);
						if(dataJson.raiz.iniciosession==1)
						{
							ventana=window.open("escritorio.html" , "SIGESP" , "menubar=0,toolbar=0,scrollbars=1,resizable=0,width="+ancho+",height="+alto+",left="+Xpos+",top="+Ypos+"");
						}
						else
						{
							ventana=window.open("vista/sss/sigesp_vis_sss_cambiopassword.html" , "SIGESP" , "menubar=0,toolbar=0,scrollbars=1,resizable=0,width="+ancho+",height="+alto+",left="+Xpos+",top="+Ypos+"");
						}
					}
					else
					{
						Ext.MessageBox.alert('Mensaje',dataJson.raiz.mensaje);
					}
				},
				failure: function (result,request) 
				{ 
					Ext.MessageBox.alert('Error', 'No se pudo iniciar sesion.'); 
				}					
			});	 
		}
	}
});	//fin del function principal
