/***********************************************************************************
* @Archivo javascript para el catlogo de sistemas.
* @fecha de creacion: 09/07/2008.
* @autor: Ing. Gusmary Balza
*************************************************************
* @fecha modificacion:
* @descripcion:
* @autor:
***********************************************************************************/
var datos                = null;
var gridSistema          = null;
var ventanaSistema       = null;
var iniciargrid          = false;
var parametros           = '';
var rutaSistema          = '../../controlador/sss/sigesp_ctr_sss_sistema.php';

/***********************************************************************************
* @Funcion genrica para el uso del catlogo de sistemas
* @parametros: 
* @retorno: 
* @fecha de creacion: 15/08/2008. 
* @autor: Ing. Gusmary Balza. 
************************************************************************************
* @fecha modificacion:
* @descripcion:
* @autor:
***********************************************************************************/
	function catalogoSistema()
	{	
		this.mostrarCatalogoSistema = mostrarCatalogoSistema;
	}


/***********************************************************************************
* @Funcion que acualiza el catalogo para buscar por determinado campo
* @parametros: criterio: campo por el que se actualiza
*			   cadena: campo a actualizar
* @retorno: 
* @fecha de creacion: 15/08/2008. 
* @autor: Ing. Gusmary Balza. 
************************************************************************************
* @fecha modificacion:
* @descripcion:
* @autor:
***********************************************************************************/
	function actualizarDataSistema(criterio,cadena)
	{
		var myJSONObject ={
			'oper': 'catalogo',
			'cadena': cadena,
			'criterio': criterio,
			'codsis':'',
			'nomsis':'',
			'sistema': siscatSistema,
			'vista': viscatSistema
		};
		objdata=JSON.stringify(myJSONObject);
		parametros = 'objdata='+objdata; 
		Ext.Ajax.request({
			url : rutaSistema,
			params : parametros,
			method: 'POST',
			success: function ( resultado, request )
			{ 
				datos = resultado.responseText;
				if (datos!='')
				{
					var myObject = eval('(' + datos + ')');
					if(myObject.raiz[0].valido==true)
					{
						gridSistema.store.loadData(myObject);
					}
					else
					{
						Ext.MessageBox.alert('Error', myObject.raiz[0].mensaje+' Al cargar los sistemas.');
					}
				}
			}
		});
	}


/***********************************************************************************
* @*Obtener el valor de los caracteres de la caja texto
* @parmetros: obj --> caja de texto.
* @retorno: 
* @fecha de creacion: 21/05/2008
* @autor: Ing. Gusmary Balza. 
************************************************************************************
* @fecha modificacion:
* @descripcion:
* @autor:
***********************************************************************************/	
	function agregarKeyPress(Obj)
	{
		Ext.form.TextField.superclass.initEvents.call(Obj);
		if(Obj.validationEvent == 'keyup')
		{
			Obj.validationTask = new Ext.util.DelayedTask(Obj.validate, Obj);
			Obj.el.on('keyup', Obj.filterValidation, Obj);
		}
		else if(Obj.validationEvent !== false)
		{
			Obj.el.on(Obj.validationEvent, Obj.validate, Obj, {buffer: Obj.validationDelay});
		}
		if(Obj.selectOnFocus || Obj.emptyText)
		{
			Obj.on('focus', Obj.preFocus, Obj);
			if(Obj.emptyText)
			{
				Obj.on('blur', Obj.postBlur, Obj);
				Obj.applyEmptyText();
			}
		}
		if(Obj.maskRe || (Obj.vtype && Obj.disableKeyFilter !== true && (Obj.maskRe = Ext.form.VTypes[Obj.vtype+'Mask']))){
			Obj.el.on('keypress', Obj.filterKeys, Obj);
		}
		if(Obj.grow)
		{
			Obj.el.on('keyup', Obj.onKeyUp,  Obj, {buffer:50});
			Obj.el.on('click', Obj.autoSize,  Obj);
		}
		Obj.el.on('keyup', Obj.changeCheck, Obj);
	}
	
	
/***********************************************************************************
* @Funcion que carga los usuarios del sistema
* @parmetros: 
* @retorno: 
* @fecha de creacion: 21/05/2008
* @autor: Ing. Gusmary Balza. 
************************************************************************************
* @fecha modificacion:
* @descripcion:
* @autor:
***********************************************************************************/	
	function cargarSistemas()
	{
		codsis = Ext.getCmp('txtcodsistema').getValue();
		var objdata ={
				'oper': 'catalogodetalle',
				'codsis': codsis,	
				'sistema': siscatSistema,
				'vista': viscatSistema
		};
		objdata=JSON.stringify(objdata);
		parametros = 'objdata='+objdata;
		Ext.Ajax.request({
			url : rutaSistema,
			params : parametros,
			method: 'POST',
			success: function (resultado,request)
			{
				datos = resultado.responseText;
				if (datos!='')
				{
					var myObject = eval('(' + datos + ')');
					if(myObject.raiz[0].valido==true)
					{
						gridUsu.store.loadData(myObject);
					}
					else
					{
						Ext.MessageBox.alert('Error', myObject.raiz[0].mensaje+' Al cargar los usuarios.');
					}
				}
			}
		});
	}
/******************************************************************************
* @Funcion para insertar el registro seleccionado de la grid del catalgo 
* a la grid del formulario.
* @fecha de creacion: 19/08/2008
* @autor: Gusmary Balza
******************************************************************************
* @fecha modificacion:
* @descripcion:
* @autor:
********************************************************************************/
	function pasarDatosGridSistema()
	{
		p = new RecordDefSis
		({
		'codsis':'',
		'nomsis':''
		});
		gridSist.store.insert(0,p);
		p.set('codsis',gridSistema.getSelectionModel().getSelected().get('codsis'));
		p.set('nomsis',gridSistema.getSelectionModel().getSelected().get('nomsis'));
	}


/***********************************************************************************
* @Funcion para validar que el registro seleccionado dela grid del catalogo 
* no exista en la grid del formulario
* @parmetros: 
* @retorno: true si el registro ya est.
* @fecha de creacion: 19/08/2008
* @autor: Ing. Gusmary Balza. 
************************************************************************************
* @fecha modificacion:
* @descripcion:
* @autor:
***********************************************************************************/
	function validarExistenciaSistema()
	{
		codSistemaCat  = gridSistema.getSelectionModel().getSelected().get('codsis');
		cantSistemas   = gridSist.store.getCount()-1;
		arrAuxSistemas = gridSist.store.getRange(0,cantSistemas);
		for (i=0; i<=arrAuxSistemas.length-1; i++)
		{
			if (arrAuxSistemas[i].get('codsis')==codSistemaCat)
			{
				return true;
			}
		}
	}


/***********************************************************************************
* @Funcion que busca el listado de sistemas.
* @parmetros: form: id del formulario, 
* fieldset: id del fieldset,
* array: arreglo con los campos del formulario
* arrayRecord: arreglo con los campos de la base de datos.
* @fecha de creacion: 08/08/2008
* @autor: Ing. Gusmary Balza. 
************************************************************************************
* @fecha modificacion: 
* @autor: 
* @descripcion: 
***********************************************************************************/
	function mostrarCatalogoSistema(arrTxt, arrValores)
	{
		var objdata ={
			'oper': 'catalogo', 
			'codsis': '', 
			'nomsis': '',
			'sistema': siscatSistema,
			'vista': viscatSistema
		};
		objdata=JSON.stringify(objdata);
		parametros = 'objdata='+objdata;
		Ext.Ajax.request({
		url : rutaSistema,
		params : parametros,
		method: 'POST',
		success: function ( resultado, request ) 
		{ 
			datos = resultado.responseText;
			var myObject = eval('(' + datos + ')');
			if(myObject.raiz[0].valido==true)
			{
				var RecordDef = Ext.data.Record.create([
				{name: 'codsis'},    
				{name: 'nomsis'}
				]);
		    
				gridSistema = new Ext.grid.GridPanel({
					width:500,
					autoScroll:true,
		            border:true,
		            ds: new Ext.data.Store({
					proxy: new Ext.data.MemoryProxy(myObject),
					reader: new Ext.data.JsonReader({
					    root: 'raiz',               
					    id: 'id'   
		                },
					RecordDef
					),
					data: myObject
		            }),
		            cm: new Ext.grid.ColumnModel([
						{header: 'Codigo', width: 30, sortable: true,   dataIndex: 'codsis'},
		                {header: 'Nombre', width: 50, sortable: true, dataIndex: 'nomsis'},
					]),
		            viewConfig: {
		                            forceFit:true
		                        },
					autoHeight:true,
					stripeRows: true
				});
				
				var panelSistema = new Ext.FormPanel({
					labelWidth: 75,
					frame:true,
					title: 'Bsqueda',
					bodyStyle:'padding:5px 5px 0',
					width: 350,
					height:120,
					defaults: {width: 230},
					defaultType: 'textfield',
					items: [{
						fieldLabel: 'Codigo',
						name: 'codigo',
						id:'codigo',
						width:50,
						changeCheck: function()
						{
							  var v = this.getValue();
							  actualizarDataSistema('codsis',v);
							  if (String(v) !== String(this.startValue))
							  {
								  this.fireEvent('change', this, v, this.startValue);
							  } 
						},
						initEvents : function()
						{
							agregarKeyPress(this);
						}
					},{
						fieldLabel: 'Nombre',
						name: 'nomb',
						id:'nomb',
						changeCheck: function()
						{
							var v = this.getValue();
							actualizarDataSistema('nomsis',v);
							if (String(v) !== String(this.startValue))
							{
								this.fireEvent('change', this, v, this.startValue);
							} 
						},
						initEvents : function()
						{
							agregarKeyPress(this);
						}
					}]
				});
				ventanaSistema = new Ext.Window(
				{
					title: 'Cat&aacute;logo de Sistemas',
			    	autoScroll:true,
	                width:500,
	                height:400,
	                modal: true,
	                closeAction:'hide',
	                plain: false,
	                items:[panelSistema,gridSistema],
	                buttons: [{
	                	text:'Aceptar',  
	                    handler: function()
						{                     	
							if ((pantalla=='sistema') || (pantalla=='permisos') || (pantalla=='enviocorreo'))
							{
								for (i=0;i<arrTxt.length;i++)
								{
									Ext.getCmp(arrTxt[i]).setValue(gridSistema.getSelectionModel().getSelected().get(arrValores[i]));
								}
								if (pantalla=='sistema')
								{
									cargarSistemas();
								}	 
							}
							else
							{
								if (validarExistenciaSistema()==true)
								{
									Ext.Msg.alert('Mensaje','Registro ya agregado');	
								}
								else
								{
									pasarDatosGridSistema();										
								}
							}
							panelSistema.destroy();
							ventanaSistema.destroy();
						}
						},{
	                     text: 'Salir',
	                     handler: function()
	                     {
	                      	panelSistema.destroy();
							ventanaSistema.destroy();
	                     }
					}]
				});
		        ventanaSistema.show();
				if(!iniciargrid)
				{
					gridSistema.render('miGrid');
		            iniciargrid=false;
		        }
		        gridSistema.getSelectionModel().selectFirstRow();
		    }
		    else
		    {
				Ext.MessageBox.alert('Error', myObject.raiz[0].mensaje);
				close();
		    }
	        },
	        failure: function ( resultado, request)
			{ 
				Ext.MessageBox.alert('Error', resultado.responseText); 
	        }
	   });
	}
