/**
 * 
 */
var fromComprobantePresupuestario = null; //varibale para almacenar la instacia de objeto de formulario 
var gridDetPresupuestario = null;
var gridDetContables = null;
var gridComprobante = null;
var Actualizar = null;
var cmboperacion = null;
var frmTotalContable = null;
var frmTotalPresupuesto = null;
var operacion = true;
var contador = 0;
barraherramienta    = true;

Ext.onReady(function() {
	Ext.BLANK_IMAGE_URL = '../../base/librerias/js/ext/resources/images/default/s.gif';

	//-------------------------------------------------------------------------------------------------------------------------	

	//componente catalogo de proveedores
	var reCatProveedor = Ext.data.Record.create([
	                                             {name: 'cod_pro'}, //campo obligatorio                             
	                                             {name: 'nompro'},  //campo obligatorio
	                                             {name: 'dirpro'},  //campo obligatorio
	                                             {name: 'rifpro'}   //campo obligatorio
	                                             ]);

	var comcampocatproveedor = new com.sigesp.vista.comCatalogoProveedor({
		idComponente:'spiprouno',
		reCatalogo: reCatProveedor,
		rutacontrolador:'../../controlador/rpc/sigesp_ctr_rpc_comcatproveedor.php',
		parametros: "ObjSon={'operacion': 'buscarProveedores'",
		soloCatalogo: true,
		arrSetCampo:[{campo:'cod_pro',valor:'cod_pro'},
		             {campo:'nompro',valor:'nompro'}],
		             numFiltroNoVacio: 1
	});

	//componente catalogo de beneficiarios
	var reCatBeneficiario = Ext.data.Record.create([
	                                                {name: 'ced_bene'}, //campo obligatorio                             
	                                                {name: 'nombene'},  //campo obligatorio
	                                                {name: 'apebene'},  //campo obligatorio
	                                                {name: 'dirbene'}   //campo obligatorio
	                                                ]);

	var comcampocatbeneficiario = new com.sigesp.vista.comCatalogoBeneficiario({
		idComponente:'spibenuno',
		reCatalogo: reCatBeneficiario,
		rutacontrolador:'../../controlador/rpc/sigesp_ctr_rpc_comcatbeneficiario.php',
		parametros: "ObjSon={'operacion': 'buscarBeneficiarios'",
		soloCatalogo: true,
		arrSetCampo:[{campo:'cod_pro',valor:'ced_bene'},
		             {campo:'nompro',valor:'nombene'}],
		             numFiltroNoVacio: 1
	});

	//creando store para el combo destino
	var destino = [
	               ['Proveedor','P'],
	               ['Beneficiario','B'],
	               ['Ninguno','-']
	               ]; 

	var stdestino = new Ext.data.SimpleStore({
		fields : [ 'etiqueta', 'valor' ],
		data : destino
	});
	//fin creando store para el combo destino 

	//creando objeto combo destino
	var cmbdestino = new Ext.form.ComboBox({
		store : stdestino,
		fieldLabel : 'Destino ',
		labelSeparator : '',
		editable : false,
		displayField : 'etiqueta',
		valueField : 'valor',
		id : 'tipo_destino',
		binding:true,
		hiddenvalue:'',
		defaultvalue:'-',
		allowBlank:true,
		width:130,
		typeAhead: true,
		emptyText:'Seleccione',
		triggerAction:'all',
		forceselection:true,
		binding:true,
		mode:'local',
		listeners: {
			'select': function(valor){
				if(valor.getValue()=="P") {
					comcampocatproveedor.mostrarVentana();
				}
				else if(valor.getValue()=="B"){
					comcampocatbeneficiario.mostrarVentana();
				}
				else{
					Ext.getCmp('cod_pro').setValue('----------');
				}
					
			}
		}
	});
	/*

	//-----------------------------------------------------------------------------------------------
*/
	//creando datastore y columnmodel para la grid de los detalles contables
	var reDetPresupuestario = Ext.data.Record.create([
                      {name: 'spi_cuenta'},
                      {name: 'ctaban'},
                      {name: 'codban'},
                      {name: 'sc_cuenta'},
                      {name: 'status'},
                      {name: 'codestpro1'},
                      {name: 'codestpro2'},
                      {name: 'codestpro3'},
                      {name: 'codestpro4'},
                      {name: 'codestpro5'},
                      {name: 'estcla'},
                      {name: 'operacion'},
                      {name: 'procede_doc'},
                      {name: 'documento'},
                      {name: 'descripcion'},
                      {name: 'monto'},
                      {name: 'codestpro'},
                      {name: 'codfuefin'}
                      ]);

	var dsDetPresupuestario =  new Ext.data.Store({
		reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reDetPresupuestario)
	});

	var cmDetPresupuestario = new Ext.grid.ColumnModel([
            new Ext.grid.CheckboxSelectionModel(),
            {header: "<CENTER>Cuenta</CENTER>", width: 50, align: 'center', sortable: true, dataIndex: 'spi_cuenta'},
       //     {header: "<CENTER>Programatico</CENTER>", width: 50, sortable: true, dataIndex: 'codestpro'},
       //     {header: "<CENTER>Fuente <br> Financiamiento</CENTER>", width: 50, sortable: true, dataIndex: 'codfuefin'},
            {header: "<CENTER>Documento</CENTER>", width: 70, sortable: true, dataIndex: 'documento', align: 'center'},
            {header: "<CENTER>Descripcion</CENTER>", type: 'float', width: 70, align: 'center', sortable: true, dataIndex: 'descripcion'},
            {header: "<CENTER>Procede</CENTER>", width: 30, sortable: true, dataIndex: 'procede_doc', align: 'center'},
            {header: "<CENTER>Operacion</CENTER>", type: 'float', width: 40, align: 'center', sortable: true, dataIndex: 'operacion'},
            {header: "<CENTER>Monto</CENTER>", type: 'float', width: 40, align: 'right', sortable: true, dataIndex: 'monto'}

            ]);
	//fin del datastore y columnmodel para la grid de bienes

	//creando grid para los detalles de bienes
	gridDetPresupuestario = new Ext.grid.EditorGridPanel({
		width:785,
		height:200,
		frame:true,
		title:"<H1 align='center'>Detalle Presupuestario</H1>",
		sm:new Ext.grid.CheckboxSelectionModel({singleSelect:false}),
		style: 'position:absolute;left:10px;top:210px',
		autoScroll:true,
		border:true,
		ds: dsDetPresupuestario,
		cm: cmDetPresupuestario,
		stripeRows: true,
		viewConfig: {forceFit:true},
		tbar:[{
				text:'Agregar Detalle Ingresos',
				tooltip:'Agregar Cuenta',
				iconCls:'agregar',
				id: 'btagrebie',
				handler: function(){
					if(Ext.getCmp('comprobante').getValue()=='' || Ext.getCmp('descripcion').getValue()==''){  //|| Ext.getCmp('operaciones').getValue()==''
						Ext.Msg.show({
							title:'Mensaje',
							msg: 'Debe llenar los campos Operacion, Comprobante, y Descripcion!!!',
							buttons: Ext.Msg.OK,
							icon: Ext.MessageBox.INFO
						});
					}
					else{
						contador++;
						AgregarPresupuesto(contador);
					}
				}
				},
				{
				text:'Eliminar Detalle Presupuestario',
				tooltip:'Eliminar Detalle',
				iconCls:'remover',
				id:'btelibie',
				handler: function(){
					arreglo = gridDetPresupuestario.getSelectionModel().getSelections();
					arregloCon = gridDetContables.getStore();
					if(arreglo.length >0){
						for(var i = arreglo.length - 1; i >= 0; i--){
							for(var j=arregloCon.getCount()-1; j>=0; j--){
								if(arregloCon.getAt(j).get('sc_cuenta')==arreglo[i].get('sc_cuenta')){
									if(arregloCon.getAt(j).get('monto')==arreglo[i].get('monto')){
									gridDetContables.getStore().remove(arregloCon.getAt(j));
								}
								else{
									var monto = parseFloat(ue_formato_operaciones(arreglo[i].get('monto')));
									var montoaux = parseFloat(ue_formato_operaciones(arregloCon.getAt(j).get('monto')));
									var total = monto-montoaux;
									total = abs(total);
									arreglo[i].set('monto',formatoNumericoMostrar(total,2,'.',',','','','-',''));
								}
								acumularTotales();
								}
							}
							gridDetPresupuestario.getStore().remove(arreglo[i]);
						}
					}
					else{
						Ext.Msg.show({
							title:'Mensaje',
							msg: 'Debe seleccionar el registro a Eliminar!!!',
							buttons: Ext.Msg.OK,
							icon: Ext.MessageBox.INFO
						});
					}
				acumularTotalIngreso(gridDetPresupuestario,'totalpre');
			}
		}]
	});

	//-----------------------------------------------------------------------------------------------

	//creando datastore y columnmodel para la grid de los detalles contables
	var reDetContables = Ext.data.Record.create([
                         {name: 'codban'},
                         {name: 'ctaban'},
                         {name: 'sc_cuenta'},
                         {name: 'status'},
                         {name: 'procede_doc'},
                         {name: 'documento'},
                         {name: 'descripcion'},
                         {name: 'monto'},
                         {name: 'operacion'}
                         ]);

	var dsDetContables =  new Ext.data.Store({
		reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reDetContables)
	});

	var cmDetContables = new Ext.grid.ColumnModel([
                   new Ext.grid.CheckboxSelectionModel(),
                   {header: "<CENTER>Cuenta</CENTER>", width: 60, align: 'center', sortable: true, dataIndex: 'sc_cuenta'},
                   {header: "<CENTER>Documento</CENTER>", width: 40, sortable: true, dataIndex: 'documento', align: 'center'},
                   {header: "<CENTER>Descripcion</CENTER>", width: 80, sortable: true, dataIndex: 'descripcion'},
                   {header: "<CENTER>Procede</CENTER>", width: 30, sortable: true, dataIndex: 'procede_doc', align: 'center'},
                   {header: "<CENTER>Operacion</CENTER>", width: 40, align: 'center', sortable: true, dataIndex: 'operacion', renderer: MostrarOperacion},
                   {header: "<CENTER>Monto</CENTER>", width: 40, align: 'right', sortable: true, dataIndex: 'monto'}
                   ]);
	//fin del datastore y columnmodel para la grid de bienes

	//creando grid para los detalles de bienes
	gridDetContables = new Ext.grid.EditorGridPanel({
		width:785,
		height:200,
		frame:true,
		title:"<H1 align='center'>Detalle Contable</H1>",
		sm:new Ext.grid.CheckboxSelectionModel({singleSelect:false}),
		style: 'position:absolute;left:10px;top:475px',
		autoScroll:true,
		border:true,
		ds: dsDetContables,
		cm: cmDetContables,
		stripeRows: true,
		viewConfig: {forceFit:true},
		tbar:[{
				text:'Agregar Detalle Contable',
				tooltip:'Agregar Cuenta',
				iconCls:'agregar',
				id: 'btagrebie',
				handler: function(){
					if(Ext.getCmp('comprobante').getValue()=='' || Ext.getCmp('descripcion').getValue()==''){ // || Ext.getCmp('operaciones').getValue()==''
						Ext.Msg.show({
							title:'Mensaje',
							msg: 'Debe llenar los campos Operacion, Comprobante, y Descripcion!!!',
							buttons: Ext.Msg.OK,
							icon: Ext.MessageBox.INFO
						});
					}
					else{
						contador++;
						AgregarCuentas(contador,gridDetContables,'SPICMP');
					}
				}
				},
				{
				text:'Eliminar Detalle Contable',
				tooltip:'Eliminar Detalle',
				iconCls:'remover',
				id:'btelibie',
				handler: function(){
					arreglo = gridDetContables.getSelectionModel().getSelections();
					arregloPre = gridDetPresupuestario.getStore();
					if(arreglo.length >0){
						for(var i = arreglo.length - 1; i >= 0; i--){
							for(var j=arregloPre.getCount()-1; j>=0; j--){
								if(arregloPre.getAt(j).get('sc_cuenta')==arreglo[i].get('sc_cuenta')){
									gridDetPresupuestario.getStore().remove(arregloPre.getAt(j));
								}
								acumularTotalIngreso(gridDetPresupuestario,'totalpre');
							}
							gridDetContables.getStore().remove(arreglo[i]);
						}
					}
					else{
						Ext.Msg.show({
							title:'Mensaje',
						msg: 'Debe seleccionar el registro a Eliminar!!!',
						buttons: Ext.Msg.OK,
						icon: Ext.MessageBox.INFO
						});
					}
				acumularTotales();
				}
			}]
	});

	//-------------------------------------------------------------------------------------------------------------------------	

	//Creando el formulario de los totales contables 
	frmTotalContable = new Ext.form.FieldSet({
		width: 295,
		height: 98,
		style: 'position:absolute;left:500px;top:690px',
		frame: true,
		autoScroll:false,
		cls :'fondo',
		items: [{
				layout:"column",
				border:false,
				items: [{
						layout:"form",
						border:false,
						laberWidth: 120,
						items: [{
								xtype:"textfield",
								fieldLabel: 'Total Debe',
								labelSeparator:'',
								readOnly:true,
								id:'totaldeb',
								width:150
							}]
						}]
				},
				{
				layout:"column",
				border:false,
				items: [{
						layout:"form",
						border:false,
						laberWidth: 120,
						items: [{												
								xtype:"textfield",
								fieldLabel: 'Total Haber',
								readOnly:true,
								labelSeparator:'',
								id:'totalhab',
								width:150
							}]
						}]
				},
				{
				layout:"column",
				border:false,
				items: [{
						layout:"form",
						border:false,
						laberWidth: 120,
						items: [{
								xtype:"textfield",
								fieldLabel: 'Diferencia',
								readOnly:true,
								labelSeparator:'',
								id:'diferencia',
								width:150
							}]

						}]
				}]
	});
	//fin creando formulario de totales

	//-------------------------------------------------------------------------------------------------------------------------	

	//Creando el formulario del total de ingreso
	frmTotalPresupuesto = new Ext.form.FieldSet({
		width: 295,
		height: 45,
		style: 'position:absolute;left:500px;top:420px',
		frame: true,
		autoScroll:false,
		cls :'fondo',
		items: [{
				layout:"column",
				border:false,
				items: [{
						layout:"form",
						border:false,
						labelWidth:120,
						items: [{
								xtype:"textfield",
								fieldLabel: 'Total Ingresos',
								labelSeparator:'',
								readOnly:true,
								id:'totalpre',
								value: '',
								width:135,
								allowBlank:true,
								binding:true,
								defaultvalue:'0',
								hiddenvalue:'',
							}]
						}]
				}]
	});
	//fin creando formulario de totales

	//-------------------------------------------------------------------------------------------------------------------------	

	//Creando formulario principal 
	var Xpos = ((screen.width/2)-(430));
	var Ypos = ((screen.height/2)-(650/2));
	fromComprobantePresupuestario = new Ext.FormPanel({
		title: "<H1 align='center'>Comprobante Presupuestario de Ingresos</H1>",
		applyTo: 'formComprobantePresupuestario',
		width: 835,
		height: 500,
		style: 'position:absolute;top:'+Ypos+'px;left:'+Xpos+'px',  //'position:absolute;margin-left:'+Xpos+'px;margin-top:45px;',
		frame: true,
		autoScroll:true,
		items: [frmTotalPresupuesto,
		        {
				xtype:"fieldset", 
				title:'Datos del Comprobante',
				style: 'position:absolute;left:10px;top:5px',
				border:true,
				width: 785,
				cls :'fondo',
				height: 195,
				items: [{
						layout: "column",
						defaults: {border: false},
						style: 'position:absolute;left:15px;top:20px',
						items: [{
								layout: "form",
								border: false,
								labelWidth: 100,
								items: [{
										xtype: 'textfield',
										labelSeparator :'',
										fieldLabel: 'Procedencia',
										id: 'procede',
										value: 'SPICMP',
										readOnly: true,
										allowBlank:false,
										width:100,
										binding:true,
										defaultvalue:'',
										hiddenvalue:'',
									}]
								}]
						},
						{
						layout:"column",
						defaults: {border: false},
						style: 'position:absolute;left:550px;top:20px',
						border:false,
						items:[{
								layout:"form",
								border:false,
								labelWidth:50,
								items:[{
										xtype:"datefield",
										labelSeparator :'',
										fieldLabel:"Fecha",
										name:'Fecha',
										id:'fecha',
										allowBlank:false,
										width:100,
										binding:true,
										defaultvalue:'1900-01-01',
										hiddenvalue:'',
										value: new Date().format('d-m-Y'),
										autoCreate: {tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789/');"}
									}]
								}]
						},
						{
						layout:"column",
						defaults: {border: false},
						style: 'position:absolute;left:15px;top:50px',
						border:false,
						items:[{
								layout:"form",
								border:false,
								labelWidth:100,
								items:[{
										xtype: 'textfield',
										labelSeparator :'',
										fieldLabel: 'Comprobante',
										id: 'comprobante',
										autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '15', onkeypress: "return keyRestrict(event,'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789');"},
										width: 150,
										formatonumerico:false,
										binding:true,
										hiddenvalue:'',
										defaultvalue:'',
										allowBlank:false,
										listeners:{
											'blur' : function(campo)
											{
												llenarCampoNumdoc(campo.getValue());
											}
										}
									}]
								}]
						},
						{
						layout:"column",
						defaults: {border: false},
						style: 'position:absolute;left:15px;top:80px',
						border:false,
						items:[{
								layout:"form",
								border:false,
								labelWidth:100,
								items:[{
										xtype: 'textarea',
										labelSeparator :'',
										fieldLabel: 'Descripci&#243;n',
										id: 'descripcion',
										width: 600,
										row: 2,
										binding:true,
										hiddenvalue:'',
										defaultvalue:'',
										allowBlank:false,
										autoCreate: {tag: 'textarea', type: 'text', size: '100', onkeypress: "return keyRestrict(event,'abcdefghijklmnopqrstuvwxyz ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.;,!@%&/\()?-+*[]{}');"},
									}]
							}]
						},
						{
						layout: "column",
						defaults: {border: false},
						style: 'position:absolute;left:15px;top:140px',
						items: [{
								layout: "form",
								border: true,
								labelWidth: 100,
								items: [cmbdestino]
								},
								{
								layout: "form",
								border: false,
								labelWidth: 10,
								items: [{
										xtype: 'textfield',
										fieldLabel: '',
										labelSeparator :'',
										id: 'cod_pro',
										disabled:true,
										binding:true,
										hiddenvalue:'',
										defaultvalue:'----------',
										allowBlank:true,
										width: 130
									}]
								},
								{
								layout: "form",
								border: false,
								labelWidth: 10,
								items: [{
										xtype: 'textfield',
										fieldLabel: '',
										labelSeparator :'',
										id: 'nompro',
										disabled:true,
										binding:true,
										hiddenvalue:'',
										defaultvalue:'Ninguno',
										allowBlank:true,
										width: 310
									}]
								}]
						},
						{
						xtype: 'hidden',
						id: 'ctaban',
						binding:true,
						hiddenvalue:'',
						defaultvalue:'-------------------------'
						},
						{
						xtype: 'hidden',
						id: 'codban',
						binding:true,
						hiddenvalue:'',
						defaultvalue:'---'
						},
						{
						xtype: 'hidden',
						id: 'codfuefin',
						binding:true,
						hiddenvalue:'',
						defaultvalue:'--'
						}]
		        },gridDetPresupuestario,gridDetContables,frmTotalContable]
	});	

}); //fin creando formulario principal con parametros de busqueda y grid de modificaciones

//-------------------------------------------------------------------------------------------------------------------------	

//Funcion que llama al catalogo de comprobante presupuestario
function irBuscar(){
	CatalogoComprobante();
}

//-------------------------------------------------------------------------------------------------------------------------		 

//Funcion que guardar el comprobante presupuestario
function irGuardar(){
	if(Ext.getCmp('procede').getValue()!='SPICMP'){
		Ext.Msg.show({
			title:'Mensaje',
			msg: 'No puede editar un comprobante, que no fue generado por este modulo !!!',
			buttons: Ext.Msg.OK,
			icon: Ext.MessageBox.INFO
		});
	}
	else{
		if (Ext.getCmp('comprobante').getValue()!='' && Ext.getCmp('descripcion').getValue()!=''){
		var cadjson = '';
		var valido = true;
		var aux = formatoNumericoMostrar(0,2,'.',',','','','-','');
		var montotpre = 0;
		var montotcon = 0;
		gridDetPresupuestario.store.each(function (reDetPre){
			var monto = parseFloat(ue_formato_operaciones(reDetPre.get('monto')));
			monto = Math.abs(monto);
			montotpre += monto;
		})
		gridDetContables.store.each(function (reDetCon){
			if(reDetCon.get('operacion')=='D'){
				var monto = parseFloat(ue_formato_operaciones(reDetCon.get('monto')));
				montotcon += monto;
			}
		})
		if(gridDetContables.store.getCount()>0){
			if(montotpre!=montotcon){
				Ext.Msg.show({
					title:'Mensaje',
					msg: 'Asiento Contable Descuadrado !!!',
					buttons: Ext.Msg.OK,
					icon: Ext.MessageBox.ERROR
				});
				valido = false;
			}
		}
		if(valido){
			if(gridDetContables.store.getCount()>0){
				if(Ext.getCmp('diferencia').getValue()!=aux){
					Ext.Msg.show({
						title:'Mensaje',
						msg: 'Asiento Contable Descuadrado !!!',
						buttons: Ext.Msg.OK,
						icon: Ext.MessageBox.ERROR
					});
					valido = false;
				}
			}
		}
		var evento = 'INSERT';
		if(Actualizar!=null){
			var evento = 'UPDATE';
		}
		cadjson = "{'operacion':'guardar','codsis':'"+sistema+"','nomven':'"+vista+"','evento':'"+evento+"',"+getJsonFormulario(fromComprobantePresupuestario);
		cadjson += ",'detallesPresupuestario':[";	
		if(valido) {
			var numDetalle = 0;
			gridDetPresupuestario.store.each(function (reDetPre){
				if(numDetalle==0){
					cadjson +="{'spi_cuenta':'"+reDetPre.get('spi_cuenta')+"','procede_doc':'"+reDetPre.get('procede_doc')+"'," +
					"'documento':'"+reDetPre.get('documento')+"','operacion':'"+reDetPre.get('operacion')+"'," +
					"'codfuefin':'"+"-------------------------"+"','codestpro1':'"+"-------------------------"+"'," +
					"'codestpro2':'"+"-------------------------"+"','codestpro3':'"+"-------------------------"+"'," +
					"'codestpro4':'"+"-------------------------"+"','codestpro5':'"+"-------------------------"+"'," +
					"'estcla':'"+"-"+"','descripcion':'"+reDetPre.get('descripcion')+"'," +
					"'monto':'"+reDetPre.get('monto')+"'}";
				}
				else{
					cadjson +=",{'spi_cuenta':'"+reDetPre.get('spi_cuenta')+"','procede_doc':'"+reDetPre.get('procede_doc')+"'," +
					"'documento':'"+reDetPre.get('documento')+"','operacion':'"+reDetPre.get('operacion')+"'," +
					"'codfuefin':'"+"-------------------------"+"','codestpro1':'"+"-------------------------"+"'," +
					"'codestpro2':'"+"-------------------------"+"','codestpro3':'"+"-------------------------"+"'," +
					"'codestpro4':'"+"-------------------------"+"','codestpro5':'"+"-------------------------"+"'," +
					"'estcla':'"+"-"+"','descripcion':'"+reDetPre.get('descripcion')+"'," +
					"'monto':'"+reDetPre.get('monto')+"'}";
				}
				numDetalle++;
			});
			cadjson += "],'detallesContable':[";
			var numDetalle = 0;
			if(gridDetContables.store.getCount()>0){
				gridDetContables.store.each(function (reDetCon){
					if(numDetalle==0){
						cadjson +="{'sc_cuenta':'"+reDetCon.get('sc_cuenta')+"','procede_doc':'"+reDetCon.get('procede_doc')+"'," +
						"'documento':'"+reDetCon.get('documento')+"','debhab':'"+reDetCon.get('operacion')+"'," +
						"'descripcion':'"+reDetCon.get('descripcion')+"','monto':'"+reDetCon.get('monto')+"'}";
					}
					else{
						cadjson +=",{'sc_cuenta':'"+reDetCon.get('sc_cuenta')+"','procede_doc':'"+reDetCon.get('procede_doc')+"'," +
						"'documento':'"+reDetCon.get('documento')+"','debhab':'"+reDetCon.get('operacion')+"'," +
						"'descripcion':'"+reDetCon.get('descripcion')+"','monto':'"+reDetCon.get('monto')+"'}";
					}
					numDetalle++;
				});
			}
		}
		cadjson += "]}";
		if(valido){
			obtenerMensaje('procesar','','Procesando Informacion');
			try{
				var objjson = Ext.util.JSON.decode(cadjson);
				if(typeof(objjson) == 'object'){
					var parametros = 'ObjSon=' + cadjson;
					Ext.Ajax.request({
						url : '../../controlador/spi/sigesp_ctr_spi_comprobante.php',
						params : parametros,
						method: 'POST',
						success: function ( result, request){
							datos = result.responseText;
							Ext.Msg.hide();
							var datajson = eval('(' + datos + ')');
							if(datajson.raiz.valido==true)
							{	
								Ext.MessageBox.alert('Mensaje', datajson.raiz.mensaje);
								irNuevo();
							}
							else
							{
								Ext.MessageBox.alert('Error', datajson.raiz.mensaje);
							}
						}
					});
				}
			}	
			catch(e){
				alert('Verifique los datos, esta insertando caracteres invalidos '+e);
			}
		}
	}
	}
}

//-------------------------------------------------------------------------------------------------------------------------		 

//Funcion que limpia la pantalla para generar un nuevo comprobante presupuestario
function irNuevo(){
	limpiarFormulario(fromComprobantePresupuestario);
	gridDetPresupuestario.store.removeAll();
	gridDetContables.store.removeAll();
//	gridDetContables.hide();
	limpiarFormulario(frmTotalContable);
//	frmTotalContable.hide();
}

//-------------------------------------------------------------------------------------------------------------------------		 

//Funcion que elimina el comprobante presupuestario
function irEliminar(){
	if(Ext.getCmp('procede').getValue()!='SPICMP'){
		Ext.Msg.show({
			title:'Mensaje',
			msg: 'No puede editar un comprobante, que no fue generado por este modulo !!!',
			buttons: Ext.Msg.OK,
			icon: Ext.MessageBox.INFO
		});
	}
	else{
		var aux = formatoNumericoMostrar(0,2,'.',',','','','-','');
		var valido = true;
		function respuesta(btn){
			if(btn=='yes'){
				obtenerMensaje('procesar','','Procesando Informacion');
				var cadjson = "{'operacion':'eliminar','codsis':'"+sistema+"','nomven':'"+vista+"',"+getJsonFormulario(fromComprobantePresupuestario);
				cadjson += "}";
				if(valido){
					try{
						var objjson = Ext.util.JSON.decode(cadjson);
						if(typeof(objjson) == 'object'){
							var parametros = 'ObjSon=' + cadjson;
							Ext.Ajax.request({
								url : '../../controlador/spi/sigesp_ctr_spi_comprobante.php',
								params : parametros,
								method: 'POST',
								success: function ( result, request){
									datos = result.responseText;
									Ext.Msg.hide();
									var datajson = eval('(' + datos + ')');
									if(datajson.raiz.valido==true)
									{	
										Ext.MessageBox.alert('Mensaje', datajson.raiz.mensaje);
										irNuevo();
									}
									else
									{
										Ext.MessageBox.alert('Error', datajson.raiz.mensaje);
									}
								}
							});
						}
					}	
					catch(e){
						alert('Verifique los datos, esta insertando caracteres invalidos '+e);
					}
				}
			}
		}	
		if(Actualizar){
			Ext.MessageBox.confirm('Confirmar', '&#191;Desea eliminar este registro&#63;', respuesta); 
		}
		else{
			Ext.Msg.show({
				title:'Mensaje',
				msg: 'El registro debe estar guardado para poder eliminarlo, verifique por favor',
				buttons: Ext.Msg.OK,
				icon: Ext.MessageBox.ERROR
			}); 
		}
	}
}

//-------------------------------------------------------------------------------------------------------------------------		 

//Funcion que acumula los totales de la grid de detalle contable
function acumularTotales()
{
	var totaldebe = 0;
	var totalhaber = 0;

	gridDetContables.store.each(function (reDetCon){
		if(reDetCon.get('operacion')=='D'){
			montodebe = parseFloat(ue_formato_operaciones(reDetCon.get('monto')));
			totaldebe = totaldebe+montodebe;
		}
		else if(reDetCon.get('operacion')=='H'){
			montohaber = parseFloat(ue_formato_operaciones(reDetCon.get('monto')));
			totalhaber = totalhaber+montohaber;
		}
	})

	resta=totaldebe-totalhaber;
	Ext.getCmp('totaldeb').setValue(formatoNumericoMostrar(totaldebe,2,'.',',','','','-',''));
	Ext.getCmp('totalhab').setValue(formatoNumericoMostrar(totalhaber,2,'.',',','','','-',''));
	Ext.getCmp('diferencia').setValue(formatoNumericoMostrar(resta,2,'.',',','','','-',''));
}

//-------------------------------------------------------------------------------------------------------------------------		 

function acumularTotalIngreso(grid,campo){
	var monto = 0;
	var montotal = 0;
	grid.store.each(function (reDet){
		var monto = reDet.get('monto');
		monto = parseFloat(ue_formato_operaciones(monto));
		montotal += monto; 
		monto = 0;
	}); //totalpresupuesto
	Ext.getCmp(campo).setValue(formatoNumericoMostrar(montotal,2,'.',',','','','-',''));
}

//-------------------------------------------------------------------------------------------------------------------------		 

//Funcion que retorna la descripcion de la operacion del comprobante
function MostrarOperacion(valor){
	if(valor=='D'){
		return 'Debe';
	}
	else if(valor=='H'){
		return 'Haber';
	}
}

//-------------------------------------------------------------------------------------------------------------------------	

//Funcion que valida si el comprobante y la descripcion estan llenos para poder agregar los detalles contables
function validarDocumentoDescripcion(){
	var documentoOk = true;
	if(Ext.getCmp('comprobante').getValue()=='' || Ext.getCmp('descripcion').getValue()==''){
		documentoOk = false;
	}
	return documentoOk;
}

//----------------------------------------------------------------------------------------------------------------------------------

//Funcion que completa el comprbante con ceros para alcanzar la longitud maxima
function llenarCampoNumdoc(campo)
{
	var myJSONObject = {
			"operacion" :'llenar_documento',
			"numdoc"    : campo
	};
	var ObjSon= JSON.stringify(myJSONObject);
	var parametros ='ObjSon='+ObjSon;
	Ext.Ajax.request({
		url: '../../controlador/scg/sigesp_ctr_scg_comprobante_contable.php',
		params: parametros,
		method: 'POST',
		success: function ( result, request ) 
		{ 
			var numdoc = result.responseText;
			if (numdoc.length != 0)
			{
				Ext.getCmp('comprobante').setValue(numdoc);
			}
		}
	});
}

//----------------------------------------------------------------------------------------------------------------------------------

//Funcion que completa el comprbante con ceros para alcanzar la longitud maxima
function CatalogoComprobante()
{
	//componente catalogo de proveedores
	var reCatProv = Ext.data.Record.create([
	                                        {name: 'cod_pro'}, //campo obligatorio                             
	                                        {name: 'nompro'},  //campo obligatorio
	                                        {name: 'dirpro'},  //campo obligatorio
	                                        {name: 'rifpro'}   //campo obligatorio
	                                        ]);

	var comcampocatprov = new com.sigesp.vista.comCatalogoProveedor({
		idComponente:'spiprodos',
		reCatalogo: reCatProv,
		rutacontrolador:'../../controlador/rpc/sigesp_ctr_rpc_comcatproveedor.php',
		parametros: "ObjSon={'operacion': 'buscarProveedores'",
		soloCatalogo: true,
		arrSetCampo:[{campo:'catcodpro',valor:'cod_pro'},
		             {campo:'catnom_pro',valor:'nompro'}],
		             numFiltroNoVacio: 1
	});

	//componente catalogo de beneficiarios
	var reCatBene = Ext.data.Record.create([
	                                        {name: 'ced_bene'}, //campo obligatorio                             
	                                        {name: 'nombene'},  //campo obligatorio
	                                        {name: 'apebene'},  //campo obligatorio
	                                        {name: 'dirbene'}   //campo obligatorio
	                                        ]);

	var comcampocatbene = new com.sigesp.vista.comCatalogoBeneficiario({
		idComponente:'spibendos',
		reCatalogo: reCatBene,
		rutacontrolador:'../../controlador/rpc/sigesp_ctr_rpc_comcatbeneficiario.php',
		parametros: "ObjSon={'operacion': 'buscarBeneficiarios'",
		soloCatalogo: true,
		arrSetCampo:[{campo:'catcodpro',valor:'ced_bene'},
		             {campo:'catnom_pro',valor:'nombene'}],
		             numFiltroNoVacio: 1
	});

	//creando store para el combo destino
	var destinoProBen = [
	                     ['Proveedor','P'],
	                     ['Beneficiario','B']
	                     ]; 

	var stdestinoProBen = new Ext.data.SimpleStore({
		fields : [ 'etiqueta', 'valor' ],
		data : destinoProBen
	});
	//fin creando store para el combo destino 

	//creando objeto combo destino
	var cmbdestinoProBen = new Ext.form.ComboBox({
		store : stdestinoProBen,
		fieldLabel : 'Tipo ',
		labelSeparator : '',
		editable : false,
		displayField : 'etiqueta',
		valueField : 'valor',
		id : 'combodestino',
		binding:true,
		hiddenvalue:'',
		defaultvalue:'-',
		allowBlank:false,
		width:130,
		typeAhead: true,
		emptyText:'Seleccione',
		triggerAction:'all',
		forceselection:true,
		binding:true,
		mode:'local',
		listeners: {
			'select': function(valor){
				if(valor.getValue()=="P") {
					comcampocatprov.mostrarVentana();
				}
				else{
					comcampocatbene.mostrarVentana();
				}
			}
		}
	});

	//Creacion del combo procedencia
	var reProcedencia = Ext.data.Record.create([
	                                            {name: 'procede'},
	                                            {name: 'desproc'}
	                                            ]);

	dsProcedencia =  new Ext.data.Store({
		reader: new Ext.data.JsonReader({root: 'raiz',id: "procede"},reProcedencia)			
	});

	CmbProcedencia = new Ext.form.ComboBox({
		store: dsProcedencia,
		labelSeparator :'',
		fieldLabel:'Procedencia',
		displayField:'desproc',
		valueField:'procede',
		name: 'procedencia',
		width:350,
		listWidth: 350, 
		id:'procedencia',
		typeAhead: true,
		binding:true,
		defaultvalue:'---',
		emptyText:'----Seleccione----',
		allowBlank:true,
		selectOnFocus:true,
		mode:'local',
		triggerAction:'all',
		valor:''
	});
	//Fin combo procedencia

	//creando datastore y columnmodel para la grid de los comprobantes contables
	var reComprobante = Ext.data.Record.create([
	                                            {name: 'comprobante'},
	                                            {name: 'procede'},
	                                            {name: 'descripcion'},
	                                            {name: 'fecha'},
	                                            {name: 'codban'},
	                                            {name: 'ctaban'},
	                                            {name: 'tipo_destino'},
	                                            {name: 'cod_pro'},
	                                            {name: 'ced_bene'},
	                                            {name: 'total'}
	                                            ]);

	var dsComprobante =  new Ext.data.Store({
		reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reComprobante)
	});

	var cmComprobante = new Ext.grid.ColumnModel([
	                                              {header: "<CENTER>Comprobante</CENTER>", width: 60, align: 'center', sortable: true, dataIndex: 'comprobante'},
	                                              {header: "<CENTER>Descripcion</CENTER>", width: 60, sortable: true, dataIndex: 'descripcion'},
	                                              {header: "<CENTER>Procede</CENTER>", width: 30, sortable: true, dataIndex: 'procede', align: 'center'},
	                                              {header: "<CENTER>Fecha</CENTER>", width: 30, sortable: true, dataIndex: 'fecha', align: 'center'},
	                                              {header: "<CENTER>Proveedor</CENTER>", type: 'float', width: 40, align: 'center', sortable: true, dataIndex: 'cod_pro'},
	                                              {header: "<CENTER>Beneficiario</CENTER>", type: 'float', width: 40, align: 'right', sortable: true, dataIndex: 'ced_bene'},
	                                              {header: "<CENTER>Monto</CENTER>", type: 'float', width: 40, align: 'right', sortable: true, dataIndex: 'total'},
	                                              ]);
	//fin del datastore y columnmodel para la grid de bienes

	//creando grid para los detalles de bienes
	gridComprobante = new Ext.grid.GridPanel({
		width:780,
		height:250,
		frame:true,
		title:"",
		style: 'position:absolute;left:0px;top:160px',
		autoScroll:true,
		border:true,
		ds: dsComprobante,
		cm: cmComprobante,
		stripeRows: true,
		viewConfig: {forceFit:true}
	});

	//Metodo que realiza cambios despues de editar la grid de los comprobantes
	gridComprobante.on({
		'rowdblclick': {
			fn: function(grid, numFila, evento){
				var registro = grid.getStore().getAt(numFila);
				aceptar(registro);
			}
		}
	});

	var	formVentanaCatalogo = new Ext.FormPanel({
		width: 830,
		height: 480,
		style: 'position:absolute;left:5px;top:10px',
		frame: true,
		autoScroll:false,
		items: [{
				xtype:"fieldset", 
				title:'Datos del Comprobante',
				style: 'position:absolute;left:15px;top:10px',
				border:true,
				cls: 'fondo',
				width: 780,
				height: 150,
				items:[{
						layout: "column",
						defaults: {border: false},
						style: 'position:absolute;left:15px;top:20px',
						items: [{
								layout: "form",
								border: false,
								labelWidth: 100,
								items: [{
										xtype: 'textfield',
										labelSeparator :'',
										fieldLabel: 'Comprobante',
										id: 'numcomprobante',									
										width: 170,
										autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '15', onkeypress: "return keyRestrict(event,'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789');"},
										changeCheck: function(){
											var textvalor = this.getValue();
											dsComprobante.filter('comprobante',textvalor,true);
											if(String(textvalor) !== String(this.startValue)){
												this.fireEvent('change', this, textvalor, this.startValue);
											} 
										}, 
										initEvents: function(){
											AgregarKeyPress(this);
										}
									}]
								}]
						},
						{
						layout: "column",
						defaults: {border: false},
						style: 'position:absolute;left:15px;top:80px',
						items: [{
								layout: "form",
								border: true,
								labelWidth: 100,
								items: [cmbdestinoProBen]
								},
								{
								layout: "form",
								border: false,
								labelWidth: 10,
								items: [{
										xtype: 'textfield',
										fieldLabel: '',
										labelSeparator :'',
										id: 'catcodpro',
										disabled:true,
										binding:true,
										hiddenvalue:'',
										defaultvalue:'----------',
										allowBlank:true,
										width: 130
									}]
								},
								{
								layout: "form",
								border: false,
								labelWidth: 10,
								items: [{
										xtype: 'textfield',
										fieldLabel: '',
										labelSeparator :'',
										id: 'catnom_pro',
										disabled:true,
										binding:true,
										hiddenvalue:'',
										defaultvalue:'Ninguno',
										allowBlank:true,
										width: 310
									}]
								}]
						},
						{
						layout:"column",
						defaults: {border: false},
						style: 'position:absolute;left:15px;top:50px',  //520/20
						border:false,
						items:[{
								layout:"form",
								border:false,
								labelWidth:100,
								items:[{
										xtype:"datefield",
										labelSeparator :'',
										fieldLabel:"Fecha Desde",
										name:'Fecha',
										id:'fecdesde',
										allowBlank:false,
										width:130,
										binding:true,
										defaultvalue:'1900-01-01',
										hiddenvalue:'',
										value: new Date().format('01-m-Y'),
										autoCreate: {tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789/');"}
									}]
							}]
						},
						{
						layout:"column",
						defaults: {border: false},
						style: 'position:absolute;left:300px;top:50px', //520/50
						border:false,
						items:[{
								layout:"form",
								border:false,
								labelWidth:50,
								items:[{
										xtype:"datefield",
										labelSeparator :'',
										fieldLabel:"Hasta",
										name:'Fecha',
										id:'fechasta',
										allowBlank:false,
										width:130,
										binding:true,
										defaultvalue:'1900-01-01',
										hiddenvalue:'',
										value: new Date().format('d-m-Y'),
										autoCreate: {tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789/');"}
									}]
								}]
						},gridComprobante,
						{
						layout:"column",
						defaults: {border: false},
						style: 'position:absolute;left:670px;top:115px', 
						border:false,
						items:[{
								layout:"form",
								border:false,
								items:[{
										xtype: 'button',
										fieldLabel: '',
										id: 'btagregar',
										text: 'Buscar',
										iconCls: 'menubuscar',
										handler: function(){
											if(Ext.getCmp('fecdesde').getValue().format('Y-m-d')<=Ext.getCmp('fechasta').getValue().format('Y-m-d')){
												obtenerMensaje('procesar','','Buscando Datos');
				
												//Buscar ordenes de compra
												var JSONObject = {
														'operacion'   : 'buscarComprobantesPresupuestarios',
														'comprobante' : Ext.getCmp('numcomprobante').getValue(),
														'procede'     : Ext.getCmp('procedencia').getValue(),
														'tipo'        : Ext.getCmp('combodestino').getValue(),
														'provben'     : Ext.getCmp('catcodpro').getValue(),
														'fecdesde'    : Ext.getCmp('fecdesde').getValue().format('Y-m-d'),
														'fechasta'    : Ext.getCmp('fechasta').getValue().format('Y-m-d'),
												}
				
												var ObjSon = JSON.stringify(JSONObject);
												var parametros = 'ObjSon='+ObjSon; 
												Ext.Ajax.request({
													url : '../../controlador/spi/sigesp_ctr_spi_comprobante.php',
													params : parametros,
													method: 'POST',
													success: function ( resultado, request){
														Ext.Msg.hide();
														var datos = resultado.responseText;
														var objCmp = eval('(' + datos + ')');
														if(objCmp!=''){
															if(objCmp!='0'){
																if(objCmp.raiz == null || objCmp.raiz ==''){
																	Ext.MessageBox.show({
																		title:'Advertencia',
																		msg:'No existen datos para mostrar',
																		buttons: Ext.Msg.OK,
																		icon: Ext.MessageBox.WARNING
																	});
																	gridComprobante.store.removeAll();
																}
																else{
																	gridComprobante.store.loadData(objCmp);
																}
															}
															else{
																Ext.MessageBox.show({
																	title:'Advertencia',
																	msg:'',
																	buttons: Ext.Msg.OK,
																	icon: Ext.MessageBox.WARNING
																});
															}
														}
													}//fin del success	
												});//fin del ajax request
											}
											else{
												Ext.MessageBox.show({
													title:'Mensaje',
													msg:'El rango de fechas no es correcto !!!',
													buttons: Ext.Msg.OK,
													icon: Ext.MessageBox.WARNING
												});
											}
										}
									}]
								}]
						},
						{
						layout:"column",
						defaults:{border: false},
						style:'position:absolute;left:600px;top:420px', 
						border:false,
						items:[{
								buttons: [{
									text:'Aceptar',  
									handler: function()
									{
										
										var registro = gridComprobante.getSelectionModel().getSelected();	
										aceptar(registro);
									}
								},
								{
									text: 'Salir',
									handler: function()
									{
										ventanaEstructura.destroy();
									}
								}]
							}]
						}]
			}]
	});

	var ventanaEstructura = new Ext.Window({
		width:850, 
		height:520,
		closable:true,
		border:false,
		modal: true,
		frame:true,
		title:"<H1 align='center'>Cat&#225;logo de Comprobantes</H1>",
		items:[formVentanaCatalogo], 
	});

	ventanaEstructura.show();

	//function que setea los datos en el formulario principal
	function aceptar(registro)
	{
//		var operacion = trim(Ext.getCmp('cmboperacion').getValue());
		gridDetContables.store.removeAll();
		limpiarFormulario(frmTotalContable);
		setDataFrom(fromComprobantePresupuestario,registro);
		Actualizar=true;
		buscarDetallesPresupuestarios(registro);
		 buscarDetallesContables(registro);
		
//		Ext.getCmp('totalpre').setValue(registro.get('total'));
		gridComprobante.destroy();
		ventanaEstructura.destroy();
	}

	function buscarDetallesPresupuestarios(registro)
	{
		var reDetPre = Ext.data.Record.create([
                   {name: 'spi_cuenta'},
                   {name: 'codestpro1'},
                   {name: 'codestpro2'},
                   {name: 'codestpro3'},
                   {name: 'codestpro4'},
                   {name: 'codestpro5'},
                   {name: 'estcla'},
                   {name: 'operacion'},
                   {name: 'procede_doc'},
                   {name: 'documento'},
                   {name: 'descripcion'},
                   {name: 'monto'},
                   {name: 'codestpro'},
                   {name: 'codfuefin'}
                   ]);
		obtenerMensaje('procesar','','Buscando Datos');
		//Buscar los detalles contables
		var JSONObject = {
				'operacion'   : 'buscarDetallesPresupuestario',
				'comprobante' : registro.get('comprobante'),
				'procede'     : registro.get('procede'),
				'fecha'       : registro.get('fecha'),
				'codban'      : registro.get('codban'),
				'ctaban'      : registro.get('ctaban')
		}
		var ObjjSon=Ext.util.JSON.encode(JSONObject);
		var parametros ='ObjSon='+ObjjSon;
		Ext.Ajax.request({
			url: '../../controlador/spi/sigesp_ctr_spi_comprobante.php',
			params: parametros,
			method: 'POST',
			success: function ( result, request ) { 
				Ext.Msg.hide();
				var resultado = result.responseText;
				var objDatos = eval('(' + resultado + ')');
				var datos = objDatos.raiz;
				if (objDatos != ""){
					var codigo = '';
					var total = 0;
					var monto = 0;
					gridDetPresupuestario.store.removeAll();
					for(var j = 0; j < datos.length; j++){
						var detpreInt = new reDetPre({
							'spi_cuenta' :datos[j].spi_cuenta,
							'operacion'  :datos[j].operacion,
							'procede_doc':datos[j].procede_doc,
							'codestpro1' :datos[j].codestpro1,
							'codestpro2' :datos[j].codestpro2,
							'codestpro3' :datos[j].codestpro3,
							'codestpro4' :datos[j].codestpro4,
							'codestpro5' :datos[j].codestpro5,
							'estcla'     :datos[j].estcla,
							'codestpro'  :datos[j].codestpro,
							'documento'  :datos[j].documento,
							'descripcion':datos[j].descripcion,
							'monto'      :datos[j].monto,
							'codfuefin'  :datos[j].codfuefin
						});
						gridDetPresupuestario.store.insert(0,detpreInt);
						monto = parseFloat(ue_formato_operaciones(datos[j].monto));
				
						total += monto;
					
					}
					Ext.getCmp('totalpre').setValue(formatoNumericoMostrar(total,2,'.',',','','','-',''));
				}
			},
			failure: function ( result, request){ 
				Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
			}//fin del success
		});//fin del ajax request
	}
	
	//------------------------------------------------------------------------------------------------------

	function buscarDetallesContables(registro)
	{	gridDetContables.store.removeAll();
    	limpiarFormulario(frmTotalContable);
		var reDetCon = Ext.data.Record.create([
                       {name: 'sc_cuenta'},
                       {name: 'procede_doc'},
                       {name: 'documento'},
                       {name: 'descripcion'},
                       {name: 'monto'},
                       {name: 'debhab'}
                       ]);
		obtenerMensaje('procesar','','Buscando Datos');
		//Buscar los detalles contables
		var JSONObject = {
				'operacion'   : 'buscarDetallesContables',
				'comprobante' : registro.get('comprobante'),
				'procede'     : registro.get('procede'),
				'fecha'       : registro.get('fecha'),
				'codban'      : registro.get('codban'),
				'ctaban'      : registro.get('ctaban')
		}
		var ObjjSon=Ext.util.JSON.encode(JSONObject);
		var parametros ='ObjSon='+ObjjSon;
		Ext.Ajax.request({
			url: '../../controlador/spi/sigesp_ctr_spi_comprobante.php',
			params: parametros,
			method: 'POST',
			success: function ( result, request ) { 
				Ext.Msg.hide();
				var resultado = result.responseText;
				var objDatos = eval('(' + resultado + ')');
				var datos = objDatos.raiz;
				if (objDatos != ""){
					fromComprobantePresupuestario.add(gridDetContables);
					fromComprobantePresupuestario.add(frmTotalContable);
					gridDetContables.show();
					frmTotalContable.show();
					fromComprobantePresupuestario.doLayout();
					var montodeb = 0;
					var montohab = 0;
					for(var j = 0; j < datos.length; j++){
						var detconInt = new reDetCon({
							'sc_cuenta'  :datos[j].sc_cuenta,
							'operacion'  :datos[j].debhab,
							'procede_doc':datos[j].procede_doc,
							'documento'  :datos[j].documento,
							'descripcion':datos[j].descripcion,
							'monto'      :datos[j].monto,
						});
						if(datos[j].debhab=='D'){
							var monto = parseFloat(datos[j].monto);
							montodeb += monto; 
						}
						else{
							var monto = parseFloat(datos[j].monto);
							montohab += monto; 
						}
						gridDetContables.store.insert(0,detconInt);
					}
					acumularTotales();
				}
				else{
					gridDetContables.store.removeAll();
					gridDetContables.hide();
					limpiarFormulario(frmTotalContable);
					frmTotalContable.hide();
				}
			},
			failure: function ( result, request){ 
				Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
			}//fin del success
		});//fin del ajax request
	}
}

//----------------------------------------------------------------------------------------------------------------------------------

//INICIO DEL FORMULARIO AGREGAR PRESUPUESTO//
/*function AgregarPresupuesto()
{
//	Creacion del combo procedencia
	 var reProcedencia = Ext.data.Record.create([
	          {name: 'operacion'},
	          {name: 'denominacion'}
	     ]);

	 var dsProcedencia =  new Ext.data.Store({
	  reader: new Ext.data.JsonReader({root: 'raiz',id: "operacion"},reProcedencia)   
	 });
	 
	 var cmboperacion = new Ext.form.ComboBox({
	  store: dsProcedencia,
	  labelSeparator :'',
	  fieldLabel:'Operacion',
	  displayField:'denominacion',
	  valueField:'operacion',
	  name: 'Operacion',
	  width:350,
	  listWidth: 350, 
	  id:'cmboperacion',
	  typeAhead: true,
	  binding:true,
	  defaultvalue:'',
	  emptyText:'----Seleccione----',
	  allowBlank:true,
	  selectOnFocus:true,
	  mode:'local',
	  triggerAction:'all',
	  valor:''
	 });
 var myJSONObject ={
	   "operacion": 'buscarOperacion',
}; 
var ObjSon=JSON.stringify(myJSONObject);
var parametros = 'ObjSon='+ObjSon; 
Ext.Ajax.request({
 url : '../../controlador/spi/sigesp_ctr_spi_comprobante.php',
 params : parametros,
 method: 'POST',
 success: function (resultado, request) { 
  var datosest = resultado.responseText;
  if(datosest!='')
  {
   var DatosEst = eval('(' + datosest + ')');
  }
  dsProcedencia.loadData(DatosEst);
 }//fin del success
});//fin del ajax request

/*
var operacion = [['Cobrado','COB'],
                 ['Cobrado y Devengado','CD'],
                 ['Devengado','DEV']
]; // Arreglo que contiene los Documentos que se pueden controlar

var stoperacion = new Ext.data.SimpleStore({
	fields : ['etiqueta','valor'],
	data : operacion
});
//fin creando store para el combo operacion

//creando objeto combo operacion
var cmboperacion = new Ext.form.ComboBox({
	store : stoperacion,
	fieldLabel : 'Operaci&#243;n',
	labelSeparator : '',
	editable : false,
	emptyText:'--- Seleccione ---',
	displayField : 'etiqueta',
	valueField : 'valor',
	id : 'codoperacion', // falta colocar el campo id correctamente
	width : 150,
	typeAhead : true,
	triggerAction : 'all',
	forceselection : true,
	binding : true,
	mode : 'local'
});

	//Creacion del formulario de agregar presupuesto

//-------------------------------------------------------------------------------------------------------------------------

var unidad_ejecutora = Ext.data.Record.create([
		{name: 'spi_cuenta'},
		{name: 'denominacion'},
		{name: 'sc_cuenta'}
		
	]);
	
	var dsUnidadEjecutora =  new Ext.data.Store({
	    reader: new Ext.data.JsonReader({
		root: 'raiz',             
		id: "id"},unidad_ejecutora)
	});
						
	var cmcatUnidadEjecutora = new Ext.grid.ColumnModel([
      {header: "Codigo", width: 20, sortable: true,   dataIndex: 'spi_cuenta'},
      {header: "Denominacion", width: 40, sortable: true, dataIndex: 'denominacion'}
	]);
	//componente campocatalogo para el campo cuentas contables
	
	comcampocatUnidadEjecutora = new com.sigesp.vista.comCampoCatalogo({
			titvencat: "<H1 align='center'>Cat&#225;logo de cuentas</H1>",
			anchoformbus: 450,
			altoformbus:100,
			anchogrid: 450,
			altogrid: 400,
			anchoven: 500,
			altoven: 400,
			anchofieldset: 850,
			datosgridcat: dsUnidadEjecutora,
			colmodelocat: cmcatUnidadEjecutora,
			rutacontrolador:'../../controlador/spi/sigesp_ctr_spi_comprobante',
			parametros: "ObjSon={'operacion': 'buscarCtas'}",
			arrfiltro:[{etiqueta:'Codigo',id:'codicuentad',valor:'spi_cuenta',longitud:'10'},
					   {etiqueta:'Denominacion',id:'descuentad',valor:'denominacion',longitud:'10'}],
			posicion:'position:absolute;left:6px;top:95px',
			tittxt:'Cuenta',
			idtxt:'spi_cuenta',
			campovalue:'spi_cuenta',
			anchoetiquetatext:215,
			anchotext:120,
			anchocoltext:0.42,
			idlabel:'denominacion',
			labelvalue:'denominacion',
			anchocoletiqueta:0.50,
			anchoetiqueta:350,
			tipbus:'L',
			binding:'C',
			hiddenvalue:'',
			defaultvalue:'',
			allowblank:false,
			datosocultos:1,
			camposocultos:['sc_cuenta']
	});

//-------------------------------------------------------------------------------------------------------------------------	

	var frmAgregarPresupuesto = new Ext.FormPanel({
		width: 870,
		height: 220, 
		style: 'position:absolute;left:5px;top:0px',
		frame: true,
		autoScroll:false,
		items:[{
			xtype:"fieldset", 
			title:'Datos del Documento',
			border:true,
			width: 850,
			height: 200,
			cls: 'fondo',
			items:[{
				style:'position:absolute;left:15px;top:15px',
				layout:"column",
				defaults:{border: false},
				items: [{
					layout:"form",
					border:false,
					labelWidth:215,
					items: [{
						xtype:'textfield',
						labelSeparator:'',
						fieldLabel:'Documento',
						name:'docingreso',
						id:'agrdocingreso',	
						autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '15', onkeypress: "return keyRestrict(event,'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789');"},
						width: 185,
						value:Ext.getCmp('comprobante').getValue(),
					}]
				}]
			},
			{
				style:'position:absolute;left:15px;top:45px',
				layout:"column",
				defaults:{border: false},
				items: [{
					layout:"form",
					border:false,
					labelWidth:215,
					items: [{
						xtype:'textfield',
						labelSeparator:'',
						fieldLabel:'Descripci&#243;n',
						autoCreate: {tag: 'input', type: 'text', size: '100', onkeypress: "return keyRestrict(event,'abcdefghijklmnopqrstuvwxyz ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.;,!@%&/\()?-+*[]{}');"},
						name:'desingreso',
						id:'catdesingreso',									
						width: 600,
						value:Ext.getCmp('descripcion').getValue(),
					}]
				}]
			},
			{
				style:'position:absolute;left:15px;top:75px',
				layout:"column",
				defaults:{border: false},
				items: [{
					layout:"form",
					border:false,
					labelWidth:215,
					items: [{
						xtype:'textfield',
						labelSeparator:'',
						fieldLabel:'Procedencia',
						name:'proingreso',
						id:'catproingreso',										
						width: 185,
						readOnly:true,
						value:'SPICMP'
					}]
				}]
			},{
			     xtype: 'hidden',
			     id: 'sc_cuenta',
			     binding:true,
			     hiddenvalue:'',
			     defaultvalue:''
			    },
/*			{
				style:'position:absolute;left:15px;top:105px',
				layout:"column",
				defaults:{border: false},
				items: [{
					layout:"form",
					border:false,
					labelWidth:215,
					items: [{
						xtype:'textfield',
						labelSeparator:'',
						fieldLabel:'Cuenta',
						name:'cuenta',
						id:'ctacmp',										
						width: 185,
						readOnly:true,
		//				value:Ext.getCmp('cuenta').getValue()
					}]
				}]
			},
			{
				xtype: 'hidden',
				id: 'sc_cuenta',
				binding:true,
				hiddenvalue:'',
				defaultvalue:''
			},{style:'position:absolute;left:15px;top:135px',
				layout:"column",
				defaults:{border: false},
				items: [{
					layout:"form",
					border:false,
					labelWidth:215,
					items: [cmboperacion]
				}]
				},
			{
				style:'position:absolute;left:15px;top:165px',
				layout:"column",
				defaults:{border: false},
				items: [{
					layout:"form",
					border:false,
					labelWidth:215,
					items: [{
						xtype:'textfield',
						labelSeparator:'',
						fieldLabel:'Monto',
						name:'moningreso',
						id:'catmoningreso',											
						width: 185,
						autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '100', onkeypress: "return keyRestrict(event,'0123456789.-');"},
						listeners:{
							'blur':function(objeto)
							{
								var numero = objeto.getValue();
								valor = formatoNumericoMostrar(objeto.getValue(),2,'.',',','','','-','');
								objeto.setValue(valor);
							},
							'focus':function(objeto)
							{
								var numero = formatoNumericoEdicion(objeto.getValue());
								objeto.setValue(numero);
							}
						}
					}]
				}]
			}]
		},comcampocatUnidadEjecutora.fieldsetCatalogo]  
	});

	var ventanaAgregarPresupuesto = new Ext.Window({
		title: "<H1 align='center'>Entrada de Comprobante de Ingresos</H1>",
		width:880,
		height:300, 
		modal: true,
		closable:false,
		plain: false,
		frame:true,
		items:[frmAgregarPresupuesto],
		buttons: [{
			text:'Aceptar',  
			handler: function(){
	//			var arrCodigos = fieldSetEstOrigen.obtenerArrayEstructura();
	//			var estructura = fieldSetEstOrigen.obtenerEstructuraFormato();
				if(Ext.getCmp('agrdocingreso').getValue()=='' || Ext.getCmp('catdesingreso').getValue()=='' ||
						Ext.getCmp('catmoningreso').getValue()==''	|| Ext.getCmp('spi_cuenta').getValue()==''){
					Ext.Msg.show({
						title:'Mensaje',
						msg:'Debe completar todos los datos',
						buttons: Ext.Msg.OK,
						icon: Ext.MessageBox.INFO
					});
				}
				else{
					var reDetGas = Ext.data.Record.create([
					                                       {name: 'sc_cuenta'}, 
					                                       {name: 'spi_cuenta'},
					                                       {name: 'denominacion'},
					                                       {name: 'procede'},
					                                       {name: 'operacion'},
					                                       {name: 'documento'},
					                                       {name: 'monto'},
					                                       ]);
					var detgasInt = new reDetGas({
						'sc_cuenta':Ext.getCmp('sc_cuenta').getValue(),
//						'codfuefin':arrCodigos[6],
						'spi_cuenta':Ext.getCmp('spi_cuenta').getValue(),
						'documento':Ext.getCmp('agrdocingreso').getValue(),
						'descripcion':Ext.getCmp('catdesingreso').getValue(),
						'procede_doc':Ext.getCmp('catproingreso').getValue(),
						'operacion':cmboperacion.getValue(),
						'monto':Ext.getCmp('catmoningreso').getValue(),
/*						'codestpro':estructura,
						'codestpro1':arrCodigos[0],
						'codestpro2':arrCodigos[1],
						'codestpro3':arrCodigos[2],
						'codestpro4':arrCodigos[3],
						'codestpro5':arrCodigos[4],
						'estcla':arrCodigos[5],
					});
					if(gridDetPresupuestario.getStore().getCount()==0){
						gridDetPresupuestario.store.insert(0,detgasInt);
					}
					else{///////////////
							var existe=false;
							gridDetPresupuestario.store.each(function (reDetGas){
								if(reDetGas.get('spi_cuenta')==Ext.getCmp('spi_cuenta').getValue() && 
										Ext.getCmp('cmboperacion').getValue()==reDetGas.get('operacion')){
										Ext.MessageBox.alert('Error', 'El Detalle presupuestario ya existe!');
									existe=true;
								}
							})
							if(!existe){
								gridDetPresupuestario.store.insert(0,detconInt);
							}
						}
					var reDetCon = Ext.data.Record.create([
					                                       {name: 'codban'},
					                                       {name: 'ctaban'},
					                                       {name: 'canart'},
					                                       {name: 'sc_cuenta'},
					                                       {name: 'status'},
					                                       {name: 'procede_doc'},
					                                       {name: 'documento'},
					                                       {name: 'descripcion'},
					                                       {name: 'monto'},
					                                       {name: 'debhab'}
					                                       ]);
					var campo = trim(Ext.getCmp('cmboperacion').getValue());
					if(campo=='DC' || campo=='DEV'){
						var montocont = Ext.getCmp('catmoningreso').getValue();
						var operacion = 'H';
										
						var detconInt = new reDetCon({
							'sc_cuenta':Ext.getCmp('sc_cuenta').getValue(),
							'documento':Ext.getCmp('agrdocingreso').getValue(),
							'descripcion':Ext.getCmp('catdesingreso').getValue(),
							'procede_doc':Ext.getCmp('catproingreso').getValue(),
							'operacion':operacion,
							'monto':montocont,
						});
						if(gridDetContables.getStore().getCount()==0){
							gridDetContables.store.insert(0,detconInt);
						}
						else{
							var existe=false;
							gridDetContables.store.each(function (reDetCon){
								if(reDetCon.get('sc_cuenta')==Ext.getCmp('sc_cuenta').getValue() && operacion==reDetCon.get('operacion')){
									var total = parseFloat(reDetCon.get('monto'));
									reDetCon.set('monto',formatoNumericoMostrar(total+montocont,2,'.',',','','','-',''));  
									existe=true;
								}
							})
							if(!existe){
								gridDetContables.store.insert(0,detconInt);
							}
						}
						acumularTotales();
					}
					
					acumularTotalIngreso(gridDetPresupuestario,'totalpre');
					ventanaAgregarPresupuesto.close();
				}	
			}
		},{
			text: 'Salir',
			handler:function(){
				ventanaAgregarPresupuesto.close();
			}
		}]
	});
	ventanaAgregarPresupuesto.show();
}*/
//FIN DEL FORMULARIO AGREGAR PRESUPUESTO//

