/**
 * 
 */
var fromComprobanteRectificaciones = null; //varibale para almacenar la instacia de objeto de formulario 
var gridDetPresupuestario = null;
var gridDetCuentas = null;
var gridComprobante = null;
var Actualizar = null;
var contador = 0;
var frmTotalContable = null;
var frmTotalPresupuesto = null;
barraherramienta    = true;

Ext.onReady(function() {
	Ext.BLANK_IMAGE_URL = '../../base/librerias/js/ext/resources/images/default/s.gif';
	
	//-----------------------------------------------------------------------------------------------
	
	//creando datastore y columnmodel para la grid de los detalles presupuestarios
	var reDetPresupuestario = Ext.data.Record.create([
	    {name: 'spi_cuenta'},
		{name: 'ctaban'},
		{name: 'codban'},
	    {name: 'sc_cuenta'},
	    {name: 'status'},
	    {name: 'operacion'},
	    {name: 'procede_doc'},
	    {name: 'documento'},
	    {name: 'descripcion'},
	    {name: 'monto'},
		{name: 'codestpro'},
		{name: 'codfuefin'}
	]);
	
	var dsDetPresupuestario =  new Ext.data.Store({
		reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reDetPresupuestario)
	});
						
	var cmDetPresupuestario = new Ext.grid.ColumnModel([
	    new Ext.grid.CheckboxSelectionModel(),
        {header: "<CENTER>Cuenta</CENTER>", width: 50, align: 'center', sortable: true, dataIndex: 'spi_cuenta'},
        {header: "<CENTER>Documento</CENTER>", width: 70, sortable: true, dataIndex: 'documento', align: 'center'},
	    {header: "<CENTER>Descripcion</CENTER>", type: 'float', width: 40, align: 'center', sortable: true, dataIndex: 'descripcion'},
		{header: "<CENTER>Procede</CENTER>", width: 30, sortable: true, dataIndex: 'procede_doc', align: 'center'},
		{header: "<CENTER>Operacion</CENTER>", type: 'float', width: 40, align: 'center', sortable: true, dataIndex: 'operacion'},
		{header: "<CENTER>Monto</CENTER>", type: 'float', width: 40, align: 'right', sortable: true, dataIndex: 'monto'}
	]);
	//fin del datastore y columnmodel para la grid de los detalles presupuestarios
	
	//creando grid para los detalles presupuestarios
	gridDetPresupuestario = new Ext.grid.EditorGridPanel({
 		width:800,
 		height:200,
		frame:true,
		title:"<H1 align='center'>Detalles Presupuestarios</H1>",
		sm:new Ext.grid.CheckboxSelectionModel({singleSelect:false}),
		style: 'position:absolute;left:10px;top:200px',
		autoScroll:true,
 		border:true,
 		ds: dsDetPresupuestario,
	   	cm: cmDetPresupuestario,
	   	stripeRows: true,
	  	viewConfig: {forceFit:true},
	  	tbar:[{
	        text:'Agregar detalle Ingresos',
	        tooltip:'Agregar',
	        iconCls:'agregar',
	        id: 'btagrebie',
	        handler: function(){
				if(Ext.getCmp('comprobante').getValue()==''){
					Ext.Msg.show({
						title:'Mensaje',
						msg: 'Debe llenar el campo Comprobante !!!',
						buttons: Ext.Msg.OK,
						icon: Ext.MessageBox.INFO
					});
				}
				else{
					contador++;
					AgregarPresupuesto(contador);
				}
			}
	  		},{
			text:'Eliminar',
			tooltip:'Eliminar',
			iconCls:'remover',
			id:'btelibie',
			handler: function(){
				arreglo = gridDetPresupuestario.getSelectionModel().getSelections();
				if(arreglo.length >0){
					for(var i = arreglo.length - 1; i >= 0; i--){
						gridDetPresupuestario.getStore().remove(arreglo[i]);
					}
				}
				else{
					Ext.Msg.show({
						title:'Mensaje',
						msg: 'Debe seleccionar el registro a Eliminar!!!',
						buttons: Ext.Msg.OK,
						icon: Ext.MessageBox.INFO
					});
				}
				acumularTotalIngreso(gridDetPresupuestario,'totalpre');
			}
		}]
	});
	
	//-------------------------------------------------------------------------------------------------------------------------	
	
	//componente catalogo de proveedores
	var reCatProveedor = Ext.data.Record.create([
		{name: 'cod_pro'}, //campo obligatorio                             
		{name: 'nompro'},  //campo obligatorio
		{name: 'dirpro'},  //campo obligatorio
		{name: 'rifpro'}   //campo obligatorio
	]);

	var comcampocatproveedor = new com.sigesp.vista.comCatalogoProveedor({
		idComponente:'spgprouno',
		reCatalogo: reCatProveedor,
		rutacontrolador:'../../controlador/rpc/sigesp_ctr_rpc_comcatproveedor.php',
		parametros: "ObjSon={'operacion': 'buscarProveedores'",
		soloCatalogo: true,
		arrSetCampo:[{campo:'cod_pro',valor:'cod_pro'},
				     {campo:'nompro',valor:'nompro'}],
		numFiltroNoVacio: 1
	});
	
	//-------------------------------------------------------------------------------------------------------------------------	

	//componente catalogo de beneficiarios
	var reCatBeneficiario = Ext.data.Record.create([
		{name: 'ced_bene'}, //campo obligatorio                             
		{name: 'nombene'},  //campo obligatorio
		{name: 'apebene'},  //campo obligatorio
		{name: 'dirbene'}   //campo obligatorio
	]);

	var comcampocatbeneficiario = new com.sigesp.vista.comCatalogoBeneficiario({
		idComponente:'spgbenuno',
		reCatalogo: reCatBeneficiario,
		rutacontrolador:'../../controlador/rpc/sigesp_ctr_rpc_comcatbeneficiario.php',
		parametros: "ObjSon={'operacion': 'buscarBeneficiarios'",
		soloCatalogo: true,
		arrSetCampo:[{campo:'cod_pro',valor:'ced_bene'},
				     {campo:'nompro',valor:'nombene'}],
		numFiltroNoVacio: 1
	});
	
	//-------------------------------------------------------------------------------------------------------------------------	

	//creando store para el combo destino
	var destino = [['Proveedor','P'],
	               ['Beneficiario','B']
	]; 

	var stdestino = new Ext.data.SimpleStore({
		fields : [ 'etiqueta', 'valor' ],
		data : destino
	});
	//fin creando store para el combo destino 

	//creando objeto combo destino
	var cmbdestino = new Ext.form.ComboBox({
		store : stdestino,
		fieldLabel : 'Destino ',
		labelSeparator : '',
		editable : false,
		displayField : 'etiqueta',
		valueField : 'valor',
		id : 'tipo_destino',
		binding:true,
		hiddenvalue:'',
		defaultvalue:'-',
		allowBlank:true,
		width:130,
		typeAhead: true,
		emptyText:'Seleccione',
		triggerAction:'all',
		forceselection:true,
		binding:true,
		mode:'local',
		listeners: {
			'select': function(valor){
				if(valor.getValue()=="P") {
					comcampocatproveedor.mostrarVentana();
				}
				else{
					comcampocatbeneficiario.mostrarVentana();
				}
			}
		}
	});
	
	//-----------------------------------------------------------------------------------------------
	
	//creando datastore y columnmodel para la grid de los detalles contables
	var reDetCuentas = Ext.data.Record.create([
		{name: 'ctaban'},
		{name: 'codban'},
	    {name: 'sc_cuenta'},
	    {name: 'status'},
	    {name: 'operacion'},
	    {name: 'procede_doc'},
	    {name: 'documento'},
	    {name: 'descripcion'},
	    {name: 'monto'},
		{name: 'codestpro'},
		{name: 'codfuefin'}
	]);
	
	var dsDetCuentas =  new Ext.data.Store({
		reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reDetCuentas)
	});
						
	var cmDetCuentas = new Ext.grid.ColumnModel([
	    new Ext.grid.CheckboxSelectionModel(),
	    {header: "<CENTER>Cuenta</CENTER>", width: 50, align: 'center', sortable: true, dataIndex: 'sc_cuenta'},
        {header: "<CENTER>Documento</CENTER>", width: 70, sortable: true, dataIndex: 'documento', align: 'center'},
	    {header: "<CENTER>Descripcion</CENTER>", type: 'float', width: 40, align: 'center', sortable: true, dataIndex: 'descripcion'},
		{header: "<CENTER>Procede</CENTER>", width: 30, sortable: true, dataIndex: 'procede_doc', align: 'center'},
		{header: "<CENTER>D/H</CENTER>", type: 'float', width: 40, align: 'center', sortable: true, dataIndex: 'operacion', renderer: MostrarOperacion},
		{header: "<CENTER>Monto</CENTER>", type: 'float', width: 40, align: 'right', sortable: true, dataIndex: 'monto'}
	]);
	//fin del datastore y columnmodel para la grid de los detalles contables
	
	//creando grid para los detalles contables
	gridDetCuentas = new Ext.grid.EditorGridPanel({
 		width:800,
 		height:200,
		frame:true,
		title:"<H1 align='center'>Detalles Contable</H1>",
		sm:new Ext.grid.CheckboxSelectionModel({singleSelect:false}),
		style: 'position:absolute;left:10px;top:465px',
		autoScroll:true,
 		border:true,
 		ds: dsDetCuentas,
   		cm: cmDetCuentas,
   		stripeRows: true,
  		viewConfig: {forceFit:true},
		tbar:[{
	        text:'Agregar detalle Contable',
	        tooltip:'Agregar',
	        iconCls:'agregar',
	        id: 'btagrebie',
	        handler: function(){
				if(Ext.getCmp('comprobante').getValue()==''){
					Ext.Msg.show({
						title:'Mensaje',
						msg: 'Debe llenar el campo Comprobante !!!',
						buttons: Ext.Msg.OK,
						icon: Ext.MessageBox.INFO
					});
				}
				else{
					contador++;
					AgregarCuentas(contador,gridDetCuentas,'SPIAUM');
				}
			}
		},
		{
			text:'Eliminar',
			tooltip:'Eliminar',
			iconCls:'remover',
			id:'btelibie',
			handler: function(){
				arreglo = gridDetCuentas.getSelectionModel().getSelections();
				if(arreglo.length >0){
					for(var i = arreglo.length - 1; i >= 0; i--){
						gridDetCuentas.getStore().remove(arreglo[i]);
					}
				}
				else{
					Ext.Msg.show({
						title:'Mensaje',
						msg: 'Debe seleccionar el registro a Eliminar!!!',
						buttons: Ext.Msg.OK,
						icon: Ext.MessageBox.INFO
					});
				}
				acumularTotales();
			}
		}]
	});
	
	//-------------------------------------------------------------------------------------------------------------------------	

	//Creando el formulario de los totales presupuestarios 
	frmTotalCuentasRec = new Ext.form.FieldSet({
		width: 310,
		height: 45,
		style: 'position:absolute;left:500px;top:410px',
		frame: true,
		autoScroll:false,
		cls :'fondo',
		items: [{
				layout:"column",
				border:false,
				items: [{
						layout:"form",
						border:false,
						labelWidth:120,
						items: [{
								xtype:"textfield",
								fieldLabel: 'Total Ingresos',
								labelSeparator:'',
								readOnly:true,
								id:'totalpre',
								width:150,
								allowBlank:true,
								binding:true,
								defaultvalue:'0',
								hiddenvalue:'',
							}]
						}]
				}]
	});
	//fin creando formulario de totales presupuestarios
	
	//-------------------------------------------------------------------------------------------------------------------------	

	//Creando el formulario de los totales contables 
	 frmTotalOtrasCuentas = new Ext.form.FieldSet({
		width: 310,
		height: 97,
		style: 'position:absolute;left:500px;top:675px',
		frame: true,
		autoScroll:false,
		cls :'fondo',
		items: [{
				layout:"column",
				border:false,
				items: [{
						layout:"form",
						border:false,
						laberWidth: 120,
						items: [{
								xtype:"textfield",
								fieldLabel: 'Total Debe',
								labelSeparator:'',
								readOnly:true,
								id:'totaldeb',
								width:150
							}]
						}]
				},
				{
				layout:"column",
				border:false,
				items: [{
						layout:"form",
						border:false,
						laberWidth: 120,
						items: [{												
								xtype:"textfield",
								fieldLabel: 'Total Haber',
								readOnly:true,
								labelSeparator:'',
								id:'totalhab',
								width:150
							}]
						}]
				},
				{
				layout:"column",
				border:false,
				items: [{
						layout:"form",
						border:false,
						laberWidth: 120,
						items: [{
								xtype:"textfield",
								fieldLabel: 'Diferencia',
								readOnly:true,
								labelSeparator:'',
								id:'diferencia',
								width:150
							}]

						}]
				}]
	});
	//fin creando formulario de totales contables
	
	//-------------------------------------------------------------------------------------------------------------------------	
	
	//Creando formulario principal 
	var Xpos = ((screen.width/2)-(430));
	var Ypos = ((screen.height/2)-(650/2));
	fromComprobanteRectificaciones = new Ext.FormPanel({
		title: "<H1 align='center'>Comprobante Presupuestario de Aumento</H1>",
		applyTo: 'formulario',
		width: 845,
		height: 500,
		style: 'position:absolute;top:'+Ypos+'px;left:'+Xpos+'px', 
		frame: true,
		autoScroll:true,
		items: [{
				xtype:"fieldset", 
			    title:'Datos del Comprobante',
			    style: 'position:absolute;left:10px;top:5px',
			    border:true,
			    width: 800,
			    cls :'fondo',
			    height: 185,
			    items: [{
						layout: "column",
						defaults: {border: false},
						style: 'position:absolute;left:15px;top:20px',
						items: [{
								layout: "form",
								border: false,
								labelWidth: 100,
								items: [{
										xtype: 'textfield',
										labelSeparator :'',
										fieldLabel: 'Procedencia',
										id: 'procede',
										value: "SPIAUM",
										readOnly: true,
										allowBlank:false,
										width:100,
										binding:true,
										defaultvalue:'',
										hiddenvalue:'',
									}]
								}]
			    		},
			    		{
				    	layout:"column",
					    defaults: {border: false},
					    style: 'position:absolute;left:550px;top:20px',
					    border:false,
						items:[{
								layout:"form",
								border:false,
								labelWidth:50,
								items:[{
										xtype:"datefield",
										labelSeparator :'',
										fieldLabel:"Fecha",
										name:'Fecha',
										id:'fecha',
										allowBlank:false,
										width:100,
										binding:true,
										defaultvalue:'1900-01-01',
										hiddenvalue:'',
										value: new Date().format('d-m-Y'),
										autoCreate: {tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789/');"}
									}]
								}]
			    		},
			    		{
				    	layout:"column",
					    defaults: {border: false},
					    style: 'position:absolute;left:15px;top:50px',
					    border:false,
					    items:[{
						    	layout:"form",
							    border:false,
								labelWidth:100,
								items:[{
										xtype: 'textfield',
										labelSeparator :'',
										fieldLabel: 'Comprobante',
										id: 'comprobante',
										autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '15', onkeypress: "return keyRestrict(event,'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789');"},
										width: 150,
										formatonumerico:false,
										binding:true,
										hiddenvalue:'',
										defaultvalue:'',
										allowBlank:false,
										listeners:{
											'blur' : function(campo)
											{
												llenarCampoNumdoc(campo.getValue());
											}
										}
								  }]
					    	}]
			    		},
			    		{
				    	  layout:"column",
				    	  defaults: {border: false},
				    	  style: 'position:absolute;left:15px;top:80px',
				    	  border:false,
				    	  items:[{
					    		  layout:"form",
					    		  border:false,
					    		  labelWidth:100,
					    		  items:[{
						    			  xtype: 'textarea',
						    			  labelSeparator :'',
						    			  fieldLabel: 'Descripci&#243;n',
						    			  id: 'descripcion',
						    			  width: 600,
						    			  row: 2,
						    			  binding:true,
						    			  hiddenvalue:'',
						    			  defaultvalue:'',
						    			  allowBlank:false,
						    			  autoCreate: {tag: 'textarea', type: 'text', size: '100', onkeypress: "return keyRestrict(event,'abcdefghijklmnopqrstuvwxyz ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.;,!@%&/\()?-+*[]{}');"},
						    		  }]
				    	  		}]
			    		},
			    		{
						layout: "column",
						defaults: {border: false},
						style: 'position:absolute;left:15px;top:140px',
						items: [{
								layout: "form",
								border: true,
								labelWidth: 100,
								items: [cmbdestino]
								},
								{
								layout: "form",
								border: false,
								labelWidth: 10,
								items: [{
										xtype: 'textfield',
										fieldLabel: '',
										labelSeparator :'',
										id: 'cod_pro',
										disabled:true,
										binding:true,
										hiddenvalue:'',
										defaultvalue:'----------',
										allowBlank:true,
										width: 130
									}]
								},
								{
								layout: "form",
								border: false,
								labelWidth: 10,
								items: [{
										xtype: 'textfield',
										fieldLabel: '',
										labelSeparator :'',
										id: 'nompro',
										disabled:true,
										binding:true,
										hiddenvalue:'',
										defaultvalue:'Ninguno',
										allowBlank:true,
										width: 310
									}]
								}]
			    		}]
		},
		gridDetPresupuestario,
		gridDetCuentas,
		frmTotalCuentasRec,
		frmTotalOtrasCuentas]
	});	
	buscarNumeroComprobante();
}); //fin creando formulario principal con parametros de busqueda y grid de modificaciones
	
	//-------------------------------------------------------------------------------------------------------------------------	

	//Funcion que busca el siguiente numero de comprobante de aumento que corresponde
	function buscarNumeroComprobante()
	{
		var myJSONObject =
		{
			'operacion'   : 'buscarUltNumCom',
			'procede'     : 'SPIAUM',
		};	
		var ObjSon=Ext.util.JSON.encode(myJSONObject);
		var parametros ='ObjSon='+ObjSon;
		Ext.Ajax.request(
		{
			url: '../../controlador/spi/sigesp_ctr_spi_mod_presupuestaria.php',
			params: parametros,
			method: 'POST',
			success: function (result, request)
			{
				valor = result.responseText;	
				comprobante = Ext.util.Format.substr(valor,14,1);
				comprobante = parseFloat(comprobante);
				comprobante = llenarCampoNumdoc(comprobante+1);
				Ext.getCmp('comprobante').setValue(comprobante);
			},
			failure: function (result, request){ 
				Ext.MessageBox.alert('Error', 'error al accesar al sistema.'); 
			}
		});
	}

	//-------------------------------------------------------------------------------------------------------------------------	

	//Funcion que llama al catalogo de comprobante de rectificaciones
	function irBuscar(){
		CatalogoComprobante();
	}
	
	//-------------------------------------------------------------------------------------------------------------------------	
	
	//Funcion que imprime el comprobante de rectificaciones
	function irImprimir()
	{
		var myJSONObject =
		{
			'operacion'   : 'buscarFormato',
			'sistema'	  : 'SPG',
			'seccion'     : 'REPORTE',
			'variable'    : 'MODIFICACION_PRESUPUESTARIA_TRASPASO',
			'valor'		  : 'sigesp_spg_rpp_sol_mod_pre_forma0301.php',
			'tipo'		  : 'C'
		};	
		var ObjSon=Ext.util.JSON.encode(myJSONObject);
		var parametros ='ObjSon='+ObjSon;
		Ext.Ajax.request(
		{
			url: '../../controlador/spg/sigesp_ctr_spg_mod_comprobante.php',
			params: parametros,
			method: 'POST',
			success: function (result, request)
			{ 
				formato = result.responseText;	
				if(Actualizar){
					comprobante = Ext.getCmp('comprobante').getValue();
					procede = Ext.getCmp('procede').getValue();
					fecha = Ext.getCmp('fecha').getValue().format('Y/m/d');
					pagina = "reportes/"+formato+"?comprobante="+comprobante+"&procede="+procede+"&fecha="+fecha;
				    window.open(pagina,"catalogo","menubar=no,toolbar=no,scrollbars=yes,width=800,height=600,resizable=yes,location=no");
				}
			},
			failure: function (result, request){ 
				Ext.MessageBox.alert('Error', 'error al accesar al sistema.'); 
			}
		})
	}
	
	//-------------------------------------------------------------------------------------------------------------------------		 

	//Funcion que guardar el comprobante de rectificaciones
	function irGuardar(){
		if(Ext.getCmp('procede').getValue()!='SPIAUM'){
			Ext.Msg.show({
				title:'Mensaje',
				msg: 'No puede editar un comprobante, que no fue generado por este modulo !!!',
				buttons: Ext.Msg.OK,
				icon: Ext.MessageBox.INFO
			});
		}
		else{
			var cadjson = '';
		    var valido = true;
		    var evento = 'INSERT';
		    var aux = formatoNumericoMostrar(0,2,'.',',','','','-','');
		    var monto = Ext.getCmp('totalpre').getValue();
		    if(Actualizar!=null){
		    	var evento = 'UPDATE';
		    }
		    if(Ext.getCmp('diferencia').getValue()!=aux && Ext.getCmp('diferencia').getValue()!=''){
		    	Ext.Msg.show({
					title:'Mensaje',
					msg: 'Comprobante descuadrado !!!',
					buttons: Ext.Msg.OK,
					icon: Ext.MessageBox.INFO
				});
		    	valido=false;
		    }
	        cadjson = "{'operacion':'guardar','codsis':'"+sistema+"','nomven':'"+vista+"','evento':'"+evento+"',"+getJsonFormulario(fromComprobanteRectificaciones);
	        cadjson += ",monto:'"+monto+"','detallesPresupuestario':[";	
	        if(valido) {
	        	var numDetalle = 0;
	        	if(gridDetPresupuestario.getStore().getCount()!=0){
	        		gridDetPresupuestario.store.each(function (reDetPre){
		    			if(numDetalle==0){
		    			    cadjson +="{'spi_cuenta':'"+reDetPre.get('spi_cuenta')+"','procede_doc':'"+reDetPre.get('procede_doc')+"'," +
		    			    		   "'documento':'"+reDetPre.get('documento')+"','operacion':'"+reDetPre.get('operacion')+"'," +
		    			    		   "'descripcion':'"+reDetPre.get('descripcion')+"','monto':'"+reDetPre.get('monto')+"'}";
		    			}
		    			else{
		    				cadjson +=",{'spi_cuenta':'"+reDetPre.get('spi_cuenta')+"','procede_doc':'"+reDetPre.get('procede_doc')+"'," +
		    			    		   "'documento':'"+reDetPre.get('documento')+"','operacion':'"+reDetPre.get('operacion')+"'," +
		    			    		   "'descripcion':'"+reDetPre.get('descripcion')+"','monto':'"+reDetPre.get('monto')+"'}";
		    			}
		    			numDetalle++;
		    		});
	        	}
	        	cadjson += "],'detallesContable':[";	
	        	if(gridDetCuentas.getStore().getCount()!=0){
	        		numDetalle = 0;
	        		gridDetCuentas.store.each(function (reDetPre){
	        			if(numDetalle==0){
	        				cadjson +="{'sc_cuenta':'"+reDetPre.get('sc_cuenta')+"','procede_doc':'"+reDetPre.get('procede_doc')+"'," +
				    				   "'documento':'"+reDetPre.get('documento')+"','operacion':'"+reDetPre.get('operacion')+"'," +
				    				   "'descripcion':'"+reDetPre.get('descripcion')+"','monto':'"+reDetPre.get('monto')+"'}";
	        			}
	        			else{
	        				cadjson +=",{'sc_cuenta':'"+reDetPre.get('sc_cuenta')+"','procede_doc':'"+reDetPre.get('procede_doc')+"'," +
				    					"'documento':'"+reDetPre.get('documento')+"','operacion':'"+reDetPre.get('operacion')+"'," +
				    					"'descripcion':'"+reDetPre.get('descripcion')+"','monto':'"+reDetPre.get('monto')+"'}";
	        			}
		    			numDetalle++;
		    		});
	        	}
	        }
	        cadjson += "]}";
	        if(valido){
	        	obtenerMensaje('procesar','','Procesando Informacion');
	        	try{
	        		var objjson = Ext.util.JSON.decode(cadjson);
	        		if(typeof(objjson) == 'object'){
	        			var parametros = 'ObjSon=' + cadjson;
	        			Ext.Ajax.request({
	        				url : '../../controlador/spi/sigesp_ctr_spi_mod_presupuestaria.php',
	        				params : parametros,
	        				method: 'POST',
	        				success: function ( result, request){
		        				datos = result.responseText;
								Ext.Msg.hide();
								var datajson = eval('(' + datos + ')');
								if(datajson.raiz.valido==true)
								{	
									Ext.MessageBox.alert('Mensaje', datajson.raiz.mensaje);
									irNuevo();
								}
								else
								{
									Ext.MessageBox.alert('Error', datajson.raiz.mensaje);
								}
	        		    	}
	        			});
	        		}
	        	}	
	        	catch(e){
	        		alert('Verifique los datos, esta insertando caracteres invalidos '+e);
	        	}
	        }
		}
	}
	
	//-------------------------------------------------------------------------------------------------------------------------		 

	//Funcion que limpia la pantalla para generar un nuevo comprobante de rectificaciones
	function irNuevo(){
		limpiarFormulario(fromComprobanteRectificaciones);
		gridDetPresupuestario.store.removeAll();
		gridDetCuentas.store.removeAll();
		limpiarFormulario(frmTotalCuentasRec);
		limpiarFormulario(frmTotalOtrasCuentas);
		buscarNumeroComprobante();
	}
	
	//-------------------------------------------------------------------------------------------------------------------------		 

	//Funcion que elimina el comprobante de rectificaciones
	function irEliminar(){
		if(Ext.getCmp('procede').getValue()!='SPIAUM'){
			Ext.Msg.show({
				title:'Mensaje',
				msg: 'No puede editar un comprobante, que no fue generado por este modulo !!!',
				buttons: Ext.Msg.OK,
				icon: Ext.MessageBox.INFO
			});
		}
		else{
			var valido = true;
			function respuesta(btn){
				if(btn=='yes'){
					obtenerMensaje('procesar','','Procesando Informacion');
					var cadjson = "{'operacion':'eliminar','codsis':'"+sistema+"','nomven':'"+vista+"',"+getJsonFormulario(fromComprobanteRectificaciones);
					cadjson += "}";
			        if(valido){
			        	try{
			        		var objjson = Ext.util.JSON.decode(cadjson);
			        		if(typeof(objjson) == 'object'){
			        			var parametros = 'ObjSon=' + cadjson;
			        			Ext.Ajax.request({
			        				url : '../../controlador/spi/sigesp_ctr_spi_mod_presupuestaria.php',
			        				params : parametros,
			        				method: 'POST',
			        				success: function ( result, request){
				        				datos = result.responseText;
										Ext.Msg.hide();
										var datajson = eval('(' + datos + ')');
										if(datajson.raiz.valido==true)
										{	
											Ext.MessageBox.alert('Mensaje', datajson.raiz.mensaje);
											irNuevo();
										}
										else
										{
											Ext.MessageBox.alert('Error', datajson.raiz.mensaje);
										}
			        		    	}
			        			});
			        		}
			        	}	
			        	catch(e){
			        		alert('Verifique los datos, esta insertando caracteres invalidos '+e);
			        	}
			        }
				}
			}	
			if(Actualizar){
				Ext.MessageBox.confirm('Confirmar', '&#191;Desea eliminar este registro&#63;', respuesta); 
			}
			else{
				Ext.Msg.show({
					title:'Mensaje',
					msg: 'El registro debe estar guardado para poder eliminarlo, verifique por favor',
					buttons: Ext.Msg.OK,
					icon: Ext.MessageBox.ERROR
				}); 
			}
		}
	}
	
	//-------------------------------------------------------------------------------------------------------------------------		 

	function acumularTotalIngreso(grid,campo){
		var monto = 0;
		var montotal = 0;
		grid.store.each(function (reDet){
			var monto = reDet.get('monto');
			monto = parseFloat(ue_formato_operaciones(monto));
			montotal += monto; 
			monto = 0;
	    }); //totalpresupuesto
		Ext.getCmp(campo).setValue(formatoNumericoMostrar(montotal,2,'.',',','','','-',''));
	}
	
	//-------------------------------------------------------------------------------------------------------------------------		 

	//Funcion que retorna la descripcion de la operacion del comprobante
	function MostrarOperacion(valor){
		if(valor=='D'){
			return 'Debe';
		}
		else if(valor=='H'){
			return 'Haber';
		}
	}
	
	//----------------------------------------------------------------------------------------------------------------------------------
	
	//Funcion que completa el comprbante con ceros para alcanzar la longitud maxima
	function llenarCampoNumdoc(campo)
	{
		var myJSONObject = {
				"operacion" :'llenar_documento',
				"numdoc"    : campo
		};
		var ObjSon= JSON.stringify(myJSONObject);
		var parametros ='ObjSon='+ObjSon;
		Ext.Ajax.request({
			url: '../../controlador/scg/sigesp_ctr_scg_comprobante_contable.php',
			params: parametros,
			method: 'POST',
			success: function ( result, request ) 
			{ 
	    		var numdoc = result.responseText;
	    		if (numdoc.length != 0)
	    		{
	    			Ext.getCmp('comprobante').setValue(numdoc);
	    		}
			}
		});
	}

	//----------------------------------------------------------------------------------------------------------------------------------
	
	//Funcion que completa el comprbante con ceros para alcanzar la longitud maxima
	function CatalogoComprobante()
	{
		//creando datastore y columnmodel para la grid de los comprobantes contables
		var reComprobante = Ext.data.Record.create([
		    {name: 'comprobante'},
			{name: 'procede'},
			{name: 'descripcion'},
		    {name: 'fecha'},
		    {name: 'coduac'},
		    {name: 'codban'},
		    {name: 'ctaban'},
		    {name: 'tipo_destino'},
		    {name: 'cod_pro'},
		    {name: 'ced_bene'},
		    {name: 'total'}
		]);
		
		var dsComprobante =  new Ext.data.Store({
			reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reComprobante)
		});
							
		var cmComprobante = new Ext.grid.ColumnModel([
	        {header: "<CENTER>Comprobante</CENTER>", width: 60, align: 'center', sortable: true, dataIndex: 'comprobante'},
	        {header: "<CENTER>Descripcion</CENTER>", width: 60, sortable: true, dataIndex: 'descripcion'},
	        {header: "<CENTER>Procede</CENTER>", width: 30, sortable: true, dataIndex: 'procede', align: 'center'},
			{header: "<CENTER>Fecha</CENTER>", width: 30, sortable: true, dataIndex: 'fecha', align: 'center'},
			{header: "<CENTER>Proveedor</CENTER>", type: 'float', width: 40, align: 'center', sortable: true, dataIndex: 'cod_pro'},
			{header: "<CENTER>Beneficiario</CENTER>", type: 'float', width: 40, align: 'right', sortable: true, dataIndex: 'ced_bene'},
			{header: "<CENTER>Monto</CENTER>", type: 'float', width: 40, align: 'right', sortable: true, dataIndex: 'total'},
		]);
		//fin del datastore y columnmodel para la grid de bienes
		
		//creando grid para los detalles de bienes
		gridComprobante = new Ext.grid.GridPanel({
	 		width:780,
	 		height:250,
			frame:true,
			title:"",
			style: 'position:absolute;left:0px;top:130px',
			autoScroll:true,
	 		border:true,
	 		ds: dsComprobante,
	   		cm: cmComprobante,
	   		stripeRows: true,
	  		viewConfig: {forceFit:true}
		});
		
		//Metodo que realiza cambios despues de editar la grid de los comprobantes
		gridComprobante.on({
			'rowdblclick': {
				fn: function(grid, numFila, evento){
					var registro = grid.getStore().getAt(numFila);
					aceptar(registro);
	 		    }
			}
		});
		
		var	formVentanaCatalogo = new Ext.FormPanel({
			width: 830,
			height: 450,
			style: 'position:absolute;left:5px;top:10px',
			frame: true,
			autoScroll:false,
			items: [{
					xtype:"fieldset", 
					title:'Datos del Comprobante',
					style: 'position:absolute;left:15px;top:10px',
					border:true,
					cls: 'fondo',
					width: 780,
					height: 120,
					items:[{
							layout: "column",
							defaults: {border: false},
							style: 'position:absolute;left:15px;top:20px',
							items: [{
									layout: "form",
									border: false,
									labelWidth: 100,
									items: [{
											xtype: 'textfield',
											labelSeparator :'',
											fieldLabel: 'Comprobante',
											id: 'numcomprobante',									
											width: 170,
											autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '15', onkeypress: "return keyRestrict(event,'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789');"},
											changeCheck: function(){
												var textvalor = this.getValue();
												dsComprobante.filter('comprobante',textvalor,true);
												if(String(textvalor) !== String(this.startValue)){
													this.fireEvent('change', this, textvalor, this.startValue);
												} 
											}, 
											initEvents: function(){
												AgregarKeyPress(this);
											}
										}]
									}]
							},
							{
							layout:"column",
							defaults: {border: false},
							style: 'position:absolute;left:15px;top:50px',  //520/20
							border:false,
							items:[{
									layout:"form",
									border:false,
									labelWidth:100,
									items:[{
											xtype: 'textfield',
											fieldLabel: 'Procedencia',
											labelSeparator :'',
											id: 'procedencia',
											readOnly:true,
											width: 170,
											value:'SPIAUM'
										}]
								}]
							},
							{
					    	layout:"column",
						    defaults: {border: false},
						    style: 'position:absolute;left:450px;top:20px',  //520/20
						    border:false,
							items:[{
									layout:"form",
									border:false,
									labelWidth:100,
									items:[{
											xtype:"datefield",
											labelSeparator :'',
											fieldLabel:"Fecha Desde",
											name:'Fecha',
											id:'fecdesde',
											allowBlank:false,
											width:100,
											binding:true,
											defaultvalue:'1900-01-01',
											hiddenvalue:'',
											value: new Date().format('01-m-Y'),
											autoCreate: {tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789/');"}
										}]
									}]
							},
							{
					    	layout:"column",
						    defaults: {border: false},
						    style: 'position:absolute;left:450px;top:50px', //520/50
						    border:false,
							items:[{
									layout:"form",
									border:false,
									labelWidth:100,
									items:[{
											xtype:"datefield",
											labelSeparator :'',
											fieldLabel:"Hasta",
											name:'Fecha',
											id:'fechasta',
											allowBlank:false,
											width:100,
											binding:true,
											defaultvalue:'1900-01-01',
											hiddenvalue:'',
											value: new Date().format('d-m-Y'),
											autoCreate: {tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789/');"}
										}]
									}]
							},gridComprobante,
							{
							layout:"column",
							defaults: {border: false},
							style: 'position:absolute;left:670px;top:85px', 
							border:false,
							items:[{
									layout:"form",
									border:false,
									items:[{
											xtype: 'button',
											fieldLabel: '',
											id: 'btagregar',
											text: 'Buscar',
											iconCls: 'menubuscar',
											handler: function(){
												if(Ext.getCmp('fecdesde').getValue().format('Y-m-d')<=Ext.getCmp('fechasta').getValue().format('Y-m-d')){
													obtenerMensaje('procesar','','Buscando Datos');
								   					
							   						//Buscar ordenes de compra
									   				var JSONObject = {
									   					'operacion'   : 'buscarComprobante',
									   					'comprobante' : Ext.getCmp('numcomprobante').getValue(),
									   					'procede'     : 'SPIAUM',
									   					'fecdes'      : Ext.getCmp('fecdesde').getValue().format('Y-m-d'),
									   					'fechas'      : Ext.getCmp('fechasta').getValue().format('Y-m-d'),
									   				}
									   				
									   				var ObjSon = JSON.stringify(JSONObject);
									   				var parametros = 'ObjSon='+ObjSon; 
									   				Ext.Ajax.request({
									   					url : '../../controlador/spi/sigesp_ctr_spi_mod_presupuestaria.php',
									   					params : parametros,
									   					method: 'POST',
									   					success: function ( resultado, request){
									   						Ext.Msg.hide();
									   						var datos = resultado.responseText;
									   						var objCmp = eval('(' + datos + ')');
									   						if(objCmp!=''){
									   							if(objCmp!='0'){
									   								if(objCmp.raiz == null || objCmp.raiz ==''){
									   									Ext.MessageBox.show({
														 					title:'Advertencia',
														 					msg:'No existen datos para mostrar',
														 					buttons: Ext.Msg.OK,
														 					icon: Ext.MessageBox.WARNING
														 				});
																		gridComprobante.store.removeAll();
																	}
																	else{
									   									gridComprobante.store.loadData(objCmp);
																	}
									   							}
									   							else{
									   								Ext.MessageBox.show({
														 				title:'Advertencia',
														 				msg:'',
														 				buttons: Ext.Msg.OK,
														 				icon: Ext.MessageBox.WARNING
														 			});
									   							}
									   						}
									   					}//fin del success	
									   				});//fin del ajax request
												}
												else{
									Ext.MessageBox.show({
						 				title:'Mensaje',
						 				msg:'El rango de fechas no es correcto !!!',
						 				buttons: Ext.Msg.OK,
						 				icon: Ext.MessageBox.WARNING
						 			});
								}
							}
						}]
					}]
				},
				{
				layout:"column",
				defaults:{border: false},
				style:'position:absolute;left:600px;top:390px', 
				border:false,
				items:[{
						buttons: [{
							text:'Aceptar',  
							handler: function()
							{
								var registro = gridComprobante.getSelectionModel().getSelected();	
							    aceptar(registro);
							}
						},
						{
							text: 'Salir',
							handler: function()
							{
								ventanaEstructura.destroy();
							}
						}]
					}]
				}]
			}]
		});
		
	    var ventanaEstructura = new Ext.Window({
	    	width:840, 
	        height:490,
	        closable:false,
	    	border:false,
	    	modal: true,
	    	frame:true,
	    	title:"<H1 align='center'>Cat&#225;logo de Comprobante de Creditos/Ingreso Adicional</H1>",
	    	items:[formVentanaCatalogo], 
	    });
	    
	    ventanaEstructura.show();
	    
	    //function que setea los datos en el formulario principal
	    function aceptar(registro)
	    {
	    	setDataFrom(fromComprobanteRectificaciones,registro);
	    	Actualizar=true;
	    	buscarDetallesPresupuestarios(registro);
	    	buscarDetallesContables(registro);
			gridComprobante.destroy();
			ventanaEstructura.destroy();
	    }
	    
	    function buscarDetallesPresupuestarios(registro)
	    {
	    	var reDetPre = Ext.data.Record.create([
	    	    {name: 'spi_cuenta'},
	    	    {name: 'operacion'},
	    	    {name: 'procede_doc'},
	    	    {name: 'documento'},
	    	    {name: 'descripcion'},
	    	    {name: 'monto'},
	    	]);
	    	obtenerMensaje('procesar','','Buscando Datos');
			//Buscar los detalles contables
			var JSONObject = {
				'operacion'   : 'buscarDtComprobante',
				'comprobante' : registro.get('comprobante'),
				'procede'     : registro.get('procede'),
				'fecha'       : registro.get('fecha')
			}
			var ObjjSon=Ext.util.JSON.encode(JSONObject);
  			var parametros ='ObjSon='+ObjjSon;
  			Ext.Ajax.request({
  				url: '../../controlador/spi/sigesp_ctr_spi_mod_presupuestaria.php',
  				params: parametros,
  				method: 'POST',
  				success: function ( result, request ) { 
					Ext.Msg.hide();
					var resultado = result.responseText;
					var objDatos = eval('(' + resultado + ')');
					var datos = objDatos.raiz;
					if (datos != ""){
						gridDetPresupuestario.store.removeAll();
						for(var j = 0; j < datos.length; j++){
							var detpreInt = new reDetPre({
								'spi_cuenta' :datos[j].spi_cuenta,
								'operacion'  :datos[j].operacion,
								'procede_doc':datos[j].procede_doc,
							    'documento'  :datos[j].documento,
							    'descripcion':datos[j].descripcion,
							    'monto'      :datos[j].monto,
							});
							gridDetPresupuestario.store.insert(0,detpreInt);
						}
						acumularTotalIngreso(gridDetPresupuestario,'totalpre');
					}
				},
  				failure: function ( result, request){ 
  						Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
  				}//fin del success
  			});//fin del ajax request
	    }
	    
	    function buscarDetallesContables(registro)
	    {
	    	var reDetCon = Ext.data.Record.create([
	    	    {name: 'sc_cuenta'},
			    {name: 'status'},
			    {name: 'debhab'},
			    {name: 'procede_doc'},
			    {name: 'documento'},
			    {name: 'descripcion'},
			    {name: 'monto'},
	    	]);
	    	obtenerMensaje('procesar','','Buscando Datos');
			//Buscar los detalles contables
			var JSONObject = {
				'operacion'   : 'buscarDtContable',
				'comprobante' : registro.get('comprobante'),
				'procede'     : registro.get('procede'),
				'fecha'       : registro.get('fecha')
			}
			var ObjjSon=Ext.util.JSON.encode(JSONObject);
  			var parametros ='ObjSon='+ObjjSon;
  			Ext.Ajax.request({
  				url: '../../controlador/spi/sigesp_ctr_spi_mod_presupuestaria.php',
  				params: parametros,
  				method: 'POST',
  				success: function ( result, request ) { 
					Ext.Msg.hide();
					var resultado = result.responseText;
					var objDatos = eval('(' + resultado + ')');
					var datos = objDatos.raiz;
					if (datos != ""){
						gridDetCuentas.store.removeAll();
						for(var j = 0; j < datos.length; j++){
							var detconInt = new reDetCon({
								'sc_cuenta'  :datos[j].sc_cuenta,
								'operacion'  :datos[j].debhab,
								'procede_doc':datos[j].procede_doc,
							    'documento'  :datos[j].documento,
							    'descripcion':datos[j].descripcion,
							    'monto'      :datos[j].monto,
							});
							gridDetCuentas.store.insert(0,detconInt);
						}
						acumularTotales();
					}
				},
  				failure: function ( result, request){ 
  						Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
  				}//fin del success
  			});//fin del ajax request
	    }
	}
	
	//----------------------------------------------------------------------------------------------------------------------------------	

	function MostrarOperacion(valor){
		if(valor=='D'){
			return 'Debe';
		}
		else if(valor=='H'){
			return 'Haber';
		}
	}
	
	//----------------------------------------------------------------------------------------------------------------------------------	
	
	//Funcion que acumula los totales de la grid de detalle contable
	function acumularTotales()
	{
		var totaldebe = 0;
		var totalhaber = 0;
		
		gridDetCuentas.store.each(function (reDetCon){
			if(reDetCon.get('operacion')=='D'){
				montodebe = parseFloat(ue_formato_operaciones(reDetCon.get('monto')));
				totaldebe = totaldebe+montodebe;
			}
			else if(reDetCon.get('operacion')=='H'){
				montohaber = parseFloat(ue_formato_operaciones(reDetCon.get('monto')));
				totalhaber = totalhaber+montohaber;
			}
		})
		
		resta=totaldebe-totalhaber;
		Ext.getCmp('totaldeb').setValue(formatoNumericoMostrar(totaldebe,2,'.',',','','','-',''));
		Ext.getCmp('totalhab').setValue(formatoNumericoMostrar(totalhaber,2,'.',',','','','-',''));
		Ext.getCmp('diferencia').setValue(formatoNumericoMostrar(resta,2,'.',',','','','-',''));
	}
    
