barraherramienta = true;
var gridCuenta = null;
var	fromSPIAPE = null;
var cargo = true;
var entro=false;
 
Ext.onReady(function(){
	Ext.QuickTips.init();
	Ext.BLANK_IMAGE_URL = '../../base/librerias/js/ext/resources/images/default/s.gif';
	
	//-------------------------------------------------------------------------------------------------------------------------	

	//Combo distribucion para la grid de cuentas
	var reDistribucion = [ ['Manual','M'],
                           ['Automatico','A']]; 
	// Arreglo que contiene los Documentos que se pueden controlar

    var dsDistribucion = new Ext.data.SimpleStore({
             fields: ['den', 'cod'],
             data : reDistribucion // Se asocian los documentos disponibles
    });
	                                        
    var cmbDistribucion = new Ext.form.ComboBox({  
	    	 store: dsDistribucion,
	    	 fieldLabel:'',
	    	 displayField:'den',
	    	 valueField:'cod',
	         name:'distribucion',
	         id:'distribucion',
	         forceSelection: true,
	         typeAhead: true,
	         mode: 'local',
	         binding:true,
	         emptyText:'Automatico',
	         triggerAction: 'all',
	         listeners: {
	 			'select': function(valor){
    				var arrRegistro = gridCuenta.getSelectionModel().getSelections();
    				var numaux = formatoNumericoMostrar(0,2,'.',',','','','-','');
    				registro = arrRegistro[0];
    				if(registro.get('previsto')!=''){
    					if(valor.getValue()=="A") {
    						registro.set('tipo','1');
    						if(Ext.getCmp('estmodape').getValue()=='0'){
    							distribucionMensual(registro);
    							registro.set('estdis','S');
    							Ext.MessageBox.show({
        	 						title:'Mensaje',
        	 						msg:'El Monto Asignado ha sido distribuido en partes iguales para los 12 Meses del Ao',
        	 						buttons: Ext.Msg.OK,
        	 						icon: Ext.MessageBox.INFO
        	 					});
    						}
    						else{
    							distribucionTrimestral(registro);
    							registro.set('estdis','S');
    							Ext.MessageBox.show({
        	 						title:'Mensaje',
        	 						msg:'El Monto Asignado ha sido distribuido en partes iguales para los IV Trimestres del Ao',
        	 						buttons: Ext.Msg.OK,
        	 						icon: Ext.MessageBox.INFO
        	 					});
    						}
    	 				}
    	 				else if(valor.getValue()=="M"){
    	 					registro.set('tipo','3');
    	 					if(Ext.getCmp('estmodape').getValue()=='0'){
    	 						CatalogoDistribucionMensual(registro.get('spi_cuenta'),registro.get('denominacion'),registro.get('previsto'),registro);
    	 					}
    	 					else{
    	 						CatalogoDistribucionTrimestral(registro.get('spi_cuenta'),registro.get('denominacion'),registro.get('previsto'),registro);
    	 					}
    	 				}
    				}
    				else{
    					Ext.MessageBox.show({
     						title:'Mensaje',
     						msg:'Debe asignar un Monto Previsto !!!',
     						buttons: Ext.Msg.OK,
     						icon: Ext.MessageBox.INFO
     					});
    					valor.setValue('1');
    				}
	 			}
	 		}
	});
    
	//-------------------------------------------------------------------------------------------------------------------------	
	
	var reCuenta = Ext.data.Record.create([
		{name: 'spi_cuenta'},                      
        {name: 'denominacion'},
        {name: 'asignado'},
        {name: 'previsto'},
        {name: 'status'},
        {name: 'enero'},
        {name: 'febrero'},
        {name: 'marzo'},
        {name: 'abril'},
        {name: 'mayo'},
        {name: 'junio'},
        {name: 'julio'},
        {name: 'agosto'},
        {name: 'septiembre'},
        {name: 'octubre'}, 
        {name: 'noviembre'},
        {name: 'diciembre'},
        {name: 'estdis'},
        {name: 'estdisfuefin'},
        {name: 'cadena'},
        {name: 'pordistribuir'},
        {name: 'tipo'}
    ]);
  	
  	var dsCuenta =  new Ext.data.Store({
  		reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reCuenta)
  	});
  						
  	var cmCuenta = new Ext.grid.ColumnModel([
  		new Ext.grid.CheckboxSelectionModel(),
  		  {header: "<CENTER>Cuenta</CENTER>", width:60, sortable: true, dataIndex: 'spi_cuenta'},
          {header: "<CENTER>Denominacion</CENTER>", width: 100, sortable: true, dataIndex: 'denominacion'},
          {header: "<CENTER>Monto<br>Previsto</CENTER>", width: 50, align: 'center', sortable: true, dataIndex: 'previsto',editor: new Ext.form.TextField({allowBlank: false,
    	  autoCreate: {tag: 'input', type: 'text', size: '15', autocomplete: 'off', maxlength: '15', onkeypress: "return keyRestrict(event,'0123456789.');"},
        	  listeners:{
				'blur':function(objeto){
					var numero = objeto.getValue();
					valor = formatoNumericoMostrar(objeto.getValue(),2,'.',',','','','-','');
					objeto.setValue(valor);
				},
				'specialKey':function(objeto){
					var numero = objeto.getValue();
					valor = formatoNumericoMostrar(objeto.getValue(),2,'.',',','','','-','');
					objeto.setValue(valor);
				},
				'focus':function(objeto){
					var numero = formatoNumericoEdicion(objeto.getValue());
					objeto.setValue(numero);
				}
		  	}
    	  })
          },
          {header: "<CENTER>Distribucion</CENTER>", width: 50, sortable: true, dataIndex: 'distribuir',editor: cmbDistribucion, renderer: MostrarDistribucion},
    ]);
                  	
	gridCuenta = new Ext.grid.EditorGridPanel({
    	width:850,
 		height:300,
		frame:true,
		title:"<H1 align='center'>APERTURA</H1>",
		autoScroll:true,
   		border:true,
   		ds: dsCuenta,
     	cm: cmCuenta,
		sm:new Ext.grid.CheckboxSelectionModel({singleSelect:true}),
     	stripeRows: true,
    	viewConfig: {forceFit:true},
	});
	
	//-------------------------------------------------------------------------------------------------------------------------	

	//Creando el formulario principal
	var Xpos = ((screen.width/2)-(440));
  	fromSPIAPE = new Ext.FormPanel({
  		title: "<H1 align='center'>Apertura de Cuentas</H1>",
  		width: 865,
		height: 460,
		applyTo: 'formulario',
		style:'position:absolute;margin-left:'+Xpos+'px;margin-top:15px;',
		frame: true,
		autoScroll:false,
		items: [{
				xtype:"fieldset", 
				title:'',
				border:true,
				width: 850,
				height: 90,
				cls: 'fondo',
				items:[{
						layout:"column",
						defaults:{border: false},
						items: [{
								layout:"form",
								border:false,
								labelWidth:170,
								items: [{
										xtype: 'textfield',
										labelSeparator :'',
										fieldLabel: 'Periodo',
										id: 'periodo',
										readOnly:true,
										width: 90,
										value: new Date().format('Y'),
									}]
								}]
						},
						{
						layout: "column",
						defaults: {border: false},
						items: [{
								layout: "form",
								border: false,
								labelWidth: 170,
								items: [{
										xtype: 'checkbox',
										labelSeparator :'',
										boxLabel:'Mensual',
										fieldLabel: 'Modalidad de la Apertura',
										id: 'estmodapemen',
										readOnly:true,
										inputValue:1,
										binding:true,
										hiddenvalue:'',
										defaultvalue:'0',
										allowBlank:true
									}]
								},
								{
								layout: "form",
								border: false,
								labelWidth: 50,
								items: [{
										xtype: 'checkbox',
										labelSeparator :'',
										boxLabel:'Trimestral',
										fieldLabel: '',
										readOnly:true,
										id: 'estmodapetri',
										inputValue:1,
										binding:true,
										hiddenvalue:'',
										defaultvalue:'0',
										allowBlank:true
									}]
								}]
						},
						{
						xtype: 'hidden',
						id: 'numniv',
						binding:true,
						defaultvalue:'',
						allowBlank:true
						},
						{
						xtype: 'hidden',
						id: 'estmodape',
						binding:true,
						defaultvalue:'',
						allowBlank:true
						},
						{
						xtype: 'hidden',
						id: 'estpreing',
						binding:true,
						defaultvalue:'',
						allowBlank:true
						}]
			},gridCuenta]
  	})
  	verificarEstatus();
  	cargarCuentas();
}); //fin del formulario principal

//-------------------------------------------------------------------------------------------------------------------------	

function MostrarDistribucion(valor)
{	
	if(valor=='M'){
		return "Manual";
	}
	else{
		return "Automatico";
	}
}

function cargarCuentas()
{
	var myJSONObject = {
		"operacion":"buscarCuentasApertura" 
	};
				
	var ObjSon=Ext.util.JSON.encode(myJSONObject);
	var parametros ='ObjSon='+ObjSon;
	Ext.Ajax.request({
		url: '../../controlador/spi/sigesp_ctr_spi_apertura.php',
		params: parametros,
		method: 'POST',
		success: function ( result, request ) { 
			Ext.Msg.hide();
			var datos = result.responseText;
			var objeto = eval('(' + datos + ')');
			if(objeto!=''){
				if(objeto.raiz == null || objeto.raiz ==''){
					Ext.MessageBox.show({
						title:'Advertencia',
						msg:'No existen datos para mostrar !!!',
						buttons: Ext.Msg.OK,
						icon: Ext.MessageBox.WARNING
	 				});
				}
				else{
					gridCuenta.store.loadData(objeto);
				}
			}
		},
		failure: function ( result, request){ 
				Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
		}
	});	
}

function verificarEstatus()
{
	var myJSONObject = {
		"operacion":"verificar_estatus" 
	};
			
	var ObjSon=Ext.util.JSON.encode(myJSONObject);
	var parametros ='ObjSon='+ObjSon;
	Ext.Ajax.request({
		url: '../../controlador/spg/sigesp_ctr_spg_apertura.php',
		params: parametros,
		method: 'POST',
		success: function ( result, request ) { 
			var datos = result.responseText;
			var datajson = eval('(' + datos + ')');
			if(datajson!="")
			{
				Ext.getCmp('estmodape').setValue(datajson.raiz.estmodape);
				if(datajson.raiz.estmodape=="0"){
					Ext.getCmp('estmodapemen').setValue(true);
				}
				else{
					Ext.getCmp('estmodapetri').setValue(true);
				}
				Ext.getCmp('numniv').setValue(datajson.raiz.numniv);
				Ext.getCmp('estpreing').setValue(datajson.raiz.estpreing);
			}
		},
		failure: function ( result, request){ 
				Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
		}
	});		
}

function irCancelar(){
	limpiarFormulario(fromSPIAPE);
	gridCuenta.store.removeAll();
	verificarEstatus();
  	cargarCuentas();
}

function irGuardar()
{
	var valido=true;
	var aux = formatoNumericoMostrar(0,2,'.',',','','','-','');
	if(valido){
		Distribuir();
		if(!entro){
			periodo = Ext.getCmp('periodo').getValue();
			var valido = true;
			cadenajson = "{'operacion':'guardar','codsis':'"+sistema+"','nomven':'"+vista+"','periodo':'"+periodo+"','arrDetalle':[";
			var numdet = 0;
			gridCuenta.store.each(function (reDet){
				if(numdet==0){
					cadenajson += "{'spi_cuenta':'"+reDet.get('spi_cuenta')+"','denominacion':'"+trim(reDet.get('denominacion'))+"'," +
				       			   "'monto':'"+reDet.get('previsto')+"','enero':'"+reDet.get('enero')+"'," +
					               "'febrero':'"+reDet.get('febrero')+"','marzo':'"+reDet.get('marzo')+"'," +
		                           "'abril':'"+reDet.get('abril')+"','mayo':'"+reDet.get('mayo')+"'," +
		                           "'junio':'"+reDet.get('junio')+"','julio':'"+reDet.get('julio')+"'," +
		                           "'agosto':'"+reDet.get('agosto')+"','septiembre':'"+reDet.get('septiembre')+"'," +
		                           "'octubre':'"+reDet.get('octubre')+"','noviembre':'"+reDet.get('noviembre')+"'," +
		                           "'diciembre':'"+reDet.get('diciembre')+"','distribuir':'"+reDet.get('tipo')+"'}";
				}
				else{
					cadenajson += ",{'spi_cuenta':'"+reDet.get('spi_cuenta')+"','denominacion':'"+trim(reDet.get('denominacion'))+"'," +
				       			   "'monto':'"+reDet.get('previsto')+"','enero':'"+reDet.get('enero')+"'," +
					               "'febrero':'"+reDet.get('febrero')+"','marzo':'"+reDet.get('marzo')+"'," +
		                           "'abril':'"+reDet.get('abril')+"','mayo':'"+reDet.get('mayo')+"'," +
		                           "'junio':'"+reDet.get('junio')+"','julio':'"+reDet.get('julio')+"'," +
		                           "'agosto':'"+reDet.get('agosto')+"','septiembre':'"+reDet.get('septiembre')+"'," +
		                           "'octubre':'"+reDet.get('octubre')+"','noviembre':'"+reDet.get('noviembre')+"'," +
		                           "'diciembre':'"+reDet.get('diciembre')+"','distribuir':'"+reDet.get('tipo')+"'}";
				}
				numdet++;
			})
			cadenajson += "]}";
			
			if(valido){
				obtenerMensaje('procesar','','Procesando Informacion');
		    	try{
		    		var objjson = Ext.util.JSON.decode(cadenajson);
		    		if(typeof(objjson) == 'object'){
		    			var parametros = 'ObjSon=' + cadenajson;
		    			Ext.Ajax.request({
		    				url : '../../controlador/spi/sigesp_ctr_spi_apertura.php',
		    				params : parametros,
		    				method: 'POST',
		    				success: function ( result, request){
		        				datos = result.responseText;
								Ext.Msg.hide();
								var datajson = eval('(' + datos + ')');
								if(datajson.raiz.valido==true)
								{	
									Ext.MessageBox.alert('Mensaje', datajson.raiz.mensaje);
									irCancelar();
								}
								else
								{
									Ext.MessageBox.alert('Error', datajson.raiz.mensaje);
								}
		    		    	}
		    			});
		    		}
		    	}	
		    	catch(e){
		    		alert('Verifique los datos, esta insertando caracteres invalidos '+e);
		    	}
			}
			else{
				Ext.MessageBox.show({
					title:'Mensaje',
					msg:mensaje,
					buttons: Ext.Msg.OK,
					icon: Ext.MessageBox.INFO
				});
			}
		}
	}
}

function distribucionMensual(registro)
{
	var asignado = parseFloat(ue_formato_operaciones(registro.get('previsto')));
	var division = (asignado/12);
	division_aux=redondear2(division); //ojo con la funcion
	if(!verificarDistAuto(division_aux,asignado))
	{
		division=redondear3(division);
	}
	else
	{
		division=redondear2(division);
	}
	asignado=redondear2(asignado);
	suma_diciembre=redondear2(division*12);
	mes12=(asignado-suma_diciembre);
	mes12=redondear2(mes12);
	if(mes12>=0)
	{
		diciembre=division+mes12;
	} 			
	else
	{
		diciembre=division+mes12;
	}
	total=(division*11);
	total_general=total+diciembre;
	total_general=redondear2(total_general);
	resto=(asignado-total_general);
	resto=redondear2(resto);
	diciembre=diciembre+resto;
	distribuido=(division*11)+diciembre;
	pordistribuir=asignado-distribuido;
	pordistribuir=formatoNumericoMostrar(pordistribuir,2,'.',',','','','-','');
	division=formatoNumericoMostrar(division,2,'.',',','','','-','');
	diciembre=formatoNumericoMostrar(diciembre,2,'.',',','','','-','');
	registro.set('pordistribuir',pordistribuir);
	registro.set('enero',division);
	registro.set('febrero',division);
	registro.set('marzo',division);
	registro.set('abril',division);
	registro.set('mayo',division);
	registro.set('junio',division);
	registro.set('julio',division);
	registro.set('agosto',division);
	registro.set('septiembre',division);
	registro.set('octubre',division);
	registro.set('noviembre',division);
	registro.set('diciembre',diciembre);
	registro.set('tipo','1');
}

function verificarDistAuto(monto,asignado)
{
	var total = 0;
	var ok = true;
	for(i=1;i<=12;i++)
	{
		total += monto;
		if((total>asignado)&&(i<12))
		{
			ok = false
			break;
		}
	}
	return ok;
}

function redondear2(numero)
{
	numero2='';
	numero=parseFloat(numero);
	numero=Math.ceil(numero*10)/10
	AuxString = numero.toString();
	if(AuxString.indexOf('.')>=0)
	{
		AuxArr=AuxString.split('.');
		if(AuxArr[1]>=5)
		{
			numero=Math.ceil(numero);
		}
		else
		{ 
			numero=Math.floor(numero);
		}
	} 
	return numero;
}

function redondear3(numero)
{
	numero2='';
	numero=parseFloat(numero);
	numero=Math.ceil(numero*10)/10
	AuxString = numero.toString();
	if(AuxString.indexOf('.')>=0)
	{
		AuxArr=AuxString.split('.');
		if(AuxArr[1]>5)
		{
			numero=Math.ceil(numero);
		}
		else
		{ 
			numero=Math.floor(numero);
		}
	} 
	return numero;
}

function distribucionTrimestral(registro)
{
	var aux = formatoNumericoMostrar(0,2,'.',',','','','-','');
	var asignado = parseFloat(ue_formato_operaciones(registro.get('previsto')));
	var division = (asignado/4);
	var division_aux=redondear2(division);
	if(!verificarDistAuto(division_aux,asignado))
	{
		division=redondear3(division);
	}
	else
	{
		division=redondear2(division);
	}
	asignado=redondear2(asignado);
	suma_diciembre=redondear2(division*4);
	mes12=(asignado-suma_diciembre);
	mes12=redondear2(mes12);
	if(mes12>=0)
	{
		diciembre=division+mes12;
	} 			
	else
	{
		diciembre=division+mes12;
	}
	total=(division*3);
	total_general=total+diciembre;
	total_general=redondear2(total_general);
	resto=(asignado-total_general);
	resto=redondear2(resto);
	diciembre=diciembre+resto;
	division=formatoNumericoMostrar(division,2,'.',',','','','-','');
	diciembre=formatoNumericoMostrar(diciembre,2,'.',',','','','-','');
	registro.set('enero',aux);
	registro.set('febrero',aux);
	registro.set('marzo',division);
	registro.set('abril',aux);
	registro.set('mayo',aux);
	registro.set('junio',division);
	registro.set('julio',aux);
	registro.set('agosto',aux);
	registro.set('septiembre',division);
	registro.set('octubre',aux);
	registro.set('noviembre',aux);
	registro.set('diciembre',diciembre);
	registro.set('tipo','1');
}

function Distribuir()
{
	var aux = formatoNumericoMostrar(0,2,'.',',','','','-','');
	gridCuenta.store.each(function (reDet){
		if(reDet.get('previsto')!=''){
			if(Ext.getCmp('estmodape').getValue()=='0'){
				distribucionMensual(reDet);
				if(reDet.get('pordistribuir')!=aux){
					Ext.MessageBox.show({
						title:'Mensaje',
						msg:'La Distribucion no cuadra con lo asignado. Por Favor revise la cuenta '+reDet.get('spg_cuenta')+' Con una diferencia de '+reDet.get('pordistribuir'),
						buttons: Ext.Msg.OK,
						icon: Ext.MessageBox.INFO
					});
					entro=true
				}
			}
			else{
				distribucionTrimestral(reDet);
			}
		}
		else{
			Ext.MessageBox.show({
				title:'Mensaje',
				msg:'Debe asignar un Monto Previsto !!!',
				buttons: Ext.Msg.OK,
				icon: Ext.MessageBox.INFO
			});
			entro=true
		}
	})
}