
function CatalogoDistribucionTrimestral(cuenta,denominacion,monto){
  
	//Creacion del formulario del catalogo bienes
	var formVentanaCatalogo = new Ext.FormPanel({
		width: 680,
		height: 310,
		frame:true,
		autoScroll:false,
		items: [{
			xtype:"fieldset", 
		    title:'Datos de la Cuenta',
			border:true,
			width: 650,
			cls: 'fondo',
			height: 120,
			items:[{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:20px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Cuenta',
						name: 'cuenta',
						id: 'cuenta',									
						width: 150,
						readOnly:true,
						value:cuenta
					}]
				}]
     		},
     		{
     			layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:50px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Denominacion',
						name: 'denominacion',
						id: 'denominacion',
						width: 450,
						readOnly:true,
						value:denominacion
					}]
				}]
     		},
     		{
     			layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:80px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Monto Asignado',
						name: 'monasig',
						id: 'monto',
						width: 150,
						readOnly:true,
						value:monto
					}]
				}]
     		}]  
    	},
    	{
    		
    		xtype:"fieldset", 
		    title:'Asignacion',
			border:true,
			width: 650,
			cls: 'fondo',
			height: 150,
			items:[{
	 			layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:150px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Trimestre I',
						name: 'marzo',
						id: 'marzo',
						width: 150,
						autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '100', onkeypress: "return keyRestrict(event,'0123456789.');"},
						listeners:{
							'blur':function(objeto)
							{
								var numero = objeto.getValue();
								valor = formatoNumericoMostrar(objeto.getValue(),2,'.',',','','','-','');
								objeto.setValue(valor);
								validarMonto(objeto,'I');
							},
							'focus':function(objeto)
							{
								var numero = formatoNumericoEdicion(objeto.getValue());
								objeto.setValue(numero);
							}
						}
					}]
				}]
	 		},
	 		{
	 			layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:180px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Trimestre III',
						name: 'junio',
						id: 'junio',
						width: 150,
						autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '100', onkeypress: "return keyRestrict(event,'0123456789.');"},
						listeners:{
							'blur':function(objeto)
							{
								var numero = objeto.getValue();
								valor = formatoNumericoMostrar(objeto.getValue(),2,'.',',','','','-','');
								objeto.setValue(valor);
								validarMonto(objeto,'III')
							},
							'focus':function(objeto)
							{
								var numero = formatoNumericoEdicion(objeto.getValue());
								objeto.setValue(numero);
							}
						}
					}]
				}]
	 		},
	 		{
	 			layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:350px;top:150px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Trimestre II',
						name: 'septiembre',
						id: 'septiembre',
						width: 150,
						autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '100', onkeypress: "return keyRestrict(event,'0123456789.');"},
						listeners:{
							'blur':function(objeto)
							{
								var numero = objeto.getValue();
								valor = formatoNumericoMostrar(objeto.getValue(),2,'.',',','','','-','');
								objeto.setValue(valor);
								validarMonto(objeto,'II')
							},
							'focus':function(objeto)
							{
								var numero = formatoNumericoEdicion(objeto.getValue());
								objeto.setValue(numero);
							}
						}
					}]
				}]
	 		},
	 		{
	 			layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:350px;top:180px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Trimestre IV',
						name: 'diciembre',
						id: 'diciembre',
						width: 150,
						autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '100', onkeypress: "return keyRestrict(event,'0123456789.');"},
						listeners:{
							'blur':function(objeto)
							{
								var numero = objeto.getValue();
								valor = formatoNumericoMostrar(objeto.getValue(),2,'.',',','','','-','');
								objeto.setValue(valor);
								validarMonto(objeto,'IV')
							},
							'focus':function(objeto)
							{
								var numero = formatoNumericoEdicion(objeto.getValue());
								objeto.setValue(numero);
							}
						}
					}]
				}]
	 		},
	 		{
	 			layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:210px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Total Distribuido',
						name: 'montodis',
						id: 'mondis',
						width: 150,
						readOnly: true,
					}]
				}]
	 		},{
	 			layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:350px;top:210px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Por Distribuir',
						name: 'montopordis',
						id: 'monpordis',
						width: 150,
						readOnly:true,
					}]
				}]
	 		}]
    	}]   
	});
	//fin del formulario 
	//-------------------------------------------------------------------------------------------------------------	
	
	//Creando la ventana del catalogo bienes
	var ventana = new Ext.Window({
		title: "<H1 align='center'>Asignacion Trimestral</H1>",
        width:680,
        height:380,
        modal: false,
        closable:false,
        plain: false,
        frame:true,
        items:[formVentanaCatalogo],
		buttons: [{
			text:'Aceptar',  
			handler: function(){
				var aux = formatoNumericoMostrar(0,2,'.',',','','','-','');
				if(Ext.getCmp('monpordis').getValue()!=aux){
					Ext.MessageBox.show({
						title:'Mensaje',
						msg:'La Distribucion no cuadra con lo asignado, por favor revise los montos !!!',
						buttons: Ext.Msg.OK,
						icon: Ext.MessageBox.INFO
					});
				}
				else{
					registro.set('estdis','S');
					registro.set('enero',aux);
					registro.set('febrero',aux);
					registro.set('marzo',Ext.getCmp('marzo').getValue());
					registro.set('abril',aux);
					registro.set('mayo',aux);
					registro.set('junio',Ext.getCmp('junio').getValue());
					registro.set('julio',aux);
					registro.set('agosto',aux);
					registro.set('septiembre',Ext.getCmp('septiembre').getValue());
					registro.set('octubre',aux);
					registro.set('noviembre',aux);
					registro.set('diciembre',Ext.getCmp('diciembre').getValue());
					ventana.destroy();
				}
			}
		},{
	   		text: 'Salir',
   			handler:function(){
   				ventana.destroy();
   		    }
   		}]
	});
	
	distribucion();
	ventana.show();
	
	function distribucion()
	{
		var asignado = parseFloat(ue_formato_operaciones(monto));
		var division = (asignado/4);
		//var division = parseFloat(ue_formato_operaciones((asignado/4)));
		var division_aux=redondear2(division);
		if(!verificarDistAuto(division_aux,asignado))
		{
			division=redondear3(division);
		}
		else
		{
			division=redondear2(division);
		}
		asignado=redondear2(asignado);
		suma_diciembre=redondear2(division*4);
		mes12=(asignado-suma_diciembre);
		mes12=redondear2(mes12);
		if(mes12>=0)
		{
			diciembre=division+mes12;
		} 			
		else
		{
			diciembre=division+mes12;
		}
		total=(division*3);
		total_general=total+diciembre;
		total_general=redondear2(total_general);
		resto=(asignado-total_general);
		resto=redondear2(resto);
		diciembre=diciembre+resto;
		division=formatoNumericoMostrar(division,2,'.',',','','','-','');
		diciembre=formatoNumericoMostrar(diciembre,2,'.',',','','','-','');
		Ext.getCmp('marzo').setValue(division);
		Ext.getCmp('junio').setValue(division);
		Ext.getCmp('septiembre').setValue(division);
		Ext.getCmp('diciembre').setValue(diciembre);
		distribuido=(division*3)+diciembre;
		pordistribuir=asignado-distribuido;
		Ext.getCmp('mondis').setValue(formatoNumericoMostrar(distribuido,2,'.',',','','','-',''));
		Ext.getCmp('monpordis').setValue(formatoNumericoMostrar(pordistribuir,2,'.',',','','','-',''));
	}
	
	function redondear2(numero)
	{
		numero2='';
		numero=parseFloat(numero);
		numero=Math.ceil(numero*10)/10
		AuxString = numero.toString();
		if(AuxString.indexOf('.')>=0)
		{
			AuxArr=AuxString.split('.');
			if(AuxArr[1]>=5)
			{
				numero=Math.ceil(numero);
			}
			else
			{ 
				numero=Math.floor(numero);
			}
		} 
		return numero;
	}

	function redondear3(numero)
	{
		numero2='';
		numero=parseFloat(numero);
		numero=Math.ceil(numero*10)/10
		AuxString = numero.toString();
		if(AuxString.indexOf('.')>=0)
		{
			AuxArr=AuxString.split('.');
			if(AuxArr[1]>5)
			{
				numero=Math.ceil(numero);
			}
			else
			{ 
				numero=Math.floor(numero);
			}
		} 
		return numero;
	}
	
	function verificarDistAuto(monto,asignado)
	{
		var total = 0;
		var ok = true;
		for(i=1;i<=4;i++)
		{
			total += monto;
			if((total>asignado)&&(i<4))
			{
				ok = false
				break;
			}
		}
		return ok;
	}
	
	function validarMonto(objeto,valor)
	{
		monto=parseFloat(ue_formato_operaciones(monto));
		monto_aux=parseFloat(ue_formato_operaciones(objeto.getValue()));
		if(monto_aux>monto){
			Ext.MessageBox.show({
				title:'Mensaje',
				msg:'El monto para el Trimestre '+valor+' debe ser menor al Monto Asignado de la Cuenta !!!',
				buttons: Ext.Msg.OK,
				icon: Ext.MessageBox.INFO
			});
			objeto.setValue(formatoNumericoMostrar(0,2,'.',',','','','-',''));
		}
		else{
			total=acumularMonto();
			if(total>monto){
				Ext.MessageBox.show({
					title:'Mensaje',
					msg:'El acumulado de la distribucion debe ser menor al Monto Asignado de la Cuenta !!!',
					buttons: Ext.Msg.OK,
					icon: Ext.MessageBox.INFO
				});
				objeto.setValue(formatoNumericoMostrar(0,2,'.',',','','','-',''));
			}
			resta=monto-total;
			Ext.getCmp('mondis').setValue(formatoNumericoMostrar(total,2,'.',',','','','-',''));
			Ext.getCmp('monpordis').setValue(formatoNumericoMostrar(resta,2,'.',',','','','-',''));
		}
	}
	
	function acumularMonto()
	{
		montomar=parseFloat(ue_formato_operaciones(Ext.getCmp('marzo').getValue()));
		montojun=parseFloat(ue_formato_operaciones(Ext.getCmp('junio').getValue()));
		montosep=parseFloat(ue_formato_operaciones(Ext.getCmp('septiembre').getValue()));
		montodic=parseFloat(ue_formato_operaciones(Ext.getCmp('diciembre').getValue()));
		total=montomar+montojun+montosep+montodic;
		return total;
	}
}	


