
function CatalogoDistribucionMensual(cuenta,denominacion,monto,registro){
	
	//Creacion del formulario del catalogo bienes
	var formVentanaCatalogo = new Ext.FormPanel({
		width: 680,
		height: 430,
		frame:true,
		autoScroll:false,
		items: [{
			xtype:"fieldset", 
		    title:'Datos de la Cuenta',
			border:true,
			width: 650,
			cls: 'fondo',
			height: 120,
			items:[{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:20px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Cuenta',
						name: 'cuenta',
						id: 'cuenta',									
						width: 150,
						readOnly:true,
						value:cuenta
					}]
				}]
     		},
     		{
     			layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:50px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Denominacion',
						name: 'denominacion',
						id: 'denominacion',
						width: 450,
						readOnly:true,
						value:denominacion
					}]
				}]
     		},
     		{
     			layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:80px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Monto Asignado',
						name: 'monasig',
						id: 'monto',
						width: 150,
						readOnly:true,
						value:monto
					}]
				}]
     		}]  
    	},
    	{
    		
    		xtype:"fieldset", 
		    title:'Asignacion',
			border:true,
			width: 650,
			cls: 'fondo',
			height: 280,
			items:[{
	 			layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:150px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Enero',
						name: 'monto',
						id: 'enero',
						width: 150,
						autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '100', onkeypress: "return keyRestrict(event,'0123456789.');"},
						listeners:{
							'blur':function(objeto)
							{
								var numero = objeto.getValue();
								valor = formatoNumericoMostrar(objeto.getValue(),2,'.',',','','','-','');
								objeto.setValue(valor);
								validarMonto(objeto,'Enero');
							},
							'focus':function(objeto)
							{
								var numero = formatoNumericoEdicion(objeto.getValue());
								objeto.setValue(numero);
							}
						}
					}]
				}]
	 		},
	 		{
	 			layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:180px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Febrero',
						name: 'monto',
						id: 'febrero',
						width: 150,
						autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '100', onkeypress: "return keyRestrict(event,'0123456789.');"},
						listeners:{
							'blur':function(objeto)
							{
								var numero = objeto.getValue();
								valor = formatoNumericoMostrar(objeto.getValue(),2,'.',',','','','-','');
								objeto.setValue(valor);
								validarMonto(objeto,'Febrero');
							},
							'focus':function(objeto)
							{
								var numero = formatoNumericoEdicion(objeto.getValue());
								objeto.setValue(numero);
							}
						}
					}]
				}]
	 		},{
	 			layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:210px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Marzo',
						name: 'monto',
						id: 'marzo',
						width: 150,
						autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '100', onkeypress: "return keyRestrict(event,'0123456789.');"},
						listeners:{
							'blur':function(objeto)
							{
								var numero = objeto.getValue();
								valor = formatoNumericoMostrar(objeto.getValue(),2,'.',',','','','-','');
								objeto.setValue(valor);
								validarMonto(objeto,'Marzo');
							},
							'focus':function(objeto)
							{
								var numero = formatoNumericoEdicion(objeto.getValue());
								objeto.setValue(numero);
							}
						}
					}]
				}]
	 		},
	 		{
	 			layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:240px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Abril',
						name: 'monto',
						id: 'abril',
						width: 150,
						autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '100', onkeypress: "return keyRestrict(event,'0123456789.');"},
						listeners:{
							'blur':function(objeto)
							{
								var numero = objeto.getValue();
								valor = formatoNumericoMostrar(objeto.getValue(),2,'.',',','','','-','');
								objeto.setValue(valor);
								validarMonto(objeto,'Abril');
							},
							'focus':function(objeto)
							{
								var numero = formatoNumericoEdicion(objeto.getValue());
								objeto.setValue(numero);
							}
						}
					}]
				}]
	 		},{
	 			layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:270px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Mayo',
						name: 'monto',
						id: 'mayo',
						width: 150,
						autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '100', onkeypress: "return keyRestrict(event,'0123456789.');"},
						listeners:{
							'blur':function(objeto)
							{
								var numero = objeto.getValue();
								valor = formatoNumericoMostrar(objeto.getValue(),2,'.',',','','','-','');
								objeto.setValue(valor);
								validarMonto(objeto,'Mayo');
							},
							'focus':function(objeto)
							{
								var numero = formatoNumericoEdicion(objeto.getValue());
								objeto.setValue(numero);
							}
						}
					}]
				}]
	 		},
	 		{
	 			layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:300px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Junio',
						name: 'monto',
						id: 'junio',
						width: 150,
						autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '100', onkeypress: "return keyRestrict(event,'0123456789.');"},
						listeners:{
							'blur':function(objeto)
							{
								var numero = objeto.getValue();
								valor = formatoNumericoMostrar(objeto.getValue(),2,'.',',','','','-','');
								objeto.setValue(valor);
								validarMonto(objeto,'Junio');
							},
							'focus':function(objeto)
							{
								var numero = formatoNumericoEdicion(objeto.getValue());
								objeto.setValue(numero);
							}
						}
					}]
				}]
	 		},{
	 			layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:350px;top:150px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Julio',
						name: 'monto',
						id: 'julio',
						width: 150,
						autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '100', onkeypress: "return keyRestrict(event,'0123456789.');"},
						listeners:{
							'blur':function(objeto)
							{
								var numero = objeto.getValue();
								valor = formatoNumericoMostrar(objeto.getValue(),2,'.',',','','','-','');
								objeto.setValue(valor);
								validarMonto(objeto,'Julio');
							},
							'focus':function(objeto)
							{
								var numero = formatoNumericoEdicion(objeto.getValue());
								objeto.setValue(numero);
							}
						}
					}]
				}]
	 		},
	 		{
	 			layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:350px;top:180px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Agosto',
						name: 'monto',
						id: 'agosto',
						width: 150,
						autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '100', onkeypress: "return keyRestrict(event,'0123456789.');"},
						listeners:{
							'blur':function(objeto)
							{
								var numero = objeto.getValue();
								valor = formatoNumericoMostrar(objeto.getValue(),2,'.',',','','','-','');
								objeto.setValue(valor);
								validarMonto(objeto,'Agosto');
							},
							'focus':function(objeto)
							{
								var numero = formatoNumericoEdicion(objeto.getValue());
								objeto.setValue(numero);
							}
						}
					}]
				}]
	 		},{
	 			layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:350px;top:210px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Septiembre',
						name: 'monto',
						id: 'septiembre',
						width: 150,
						autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '100', onkeypress: "return keyRestrict(event,'0123456789.');"},
						listeners:{
							'blur':function(objeto)
							{
								var numero = objeto.getValue();
								valor = formatoNumericoMostrar(objeto.getValue(),2,'.',',','','','-','');
								objeto.setValue(valor);
								validarMonto(objeto,'Septiembre');
							},
							'focus':function(objeto)
							{
								var numero = formatoNumericoEdicion(objeto.getValue());
								objeto.setValue(numero);
							}
						}
					}]
				}]
	 		},
	 		{
	 			layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:350px;top:240px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Octubre',
						name: 'monto',
						id: 'octubre',
						width: 150,
						autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '100', onkeypress: "return keyRestrict(event,'0123456789.');"},
						listeners:{
							'blur':function(objeto)
							{
								var numero = objeto.getValue();
								valor = formatoNumericoMostrar(objeto.getValue(),2,'.',',','','','-','');
								objeto.setValue(valor);
								validarMonto(objeto,'Octubre');
							},
							'focus':function(objeto)
							{
								var numero = formatoNumericoEdicion(objeto.getValue());
								objeto.setValue(numero);
							}
						}
					}]
				}]
	 		},{
	 			layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:350px;top:270px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Noviembre',
						name: 'monto',
						id: 'noviembre',
						width: 150,
						autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '100', onkeypress: "return keyRestrict(event,'0123456789.');"},
						listeners:{
							'blur':function(objeto)
							{
								var numero = objeto.getValue();
								valor = formatoNumericoMostrar(objeto.getValue(),2,'.',',','','','-','');
								objeto.setValue(valor);
								validarMonto(objeto,'Noviembre');
							},
							'focus':function(objeto)
							{
								var numero = formatoNumericoEdicion(objeto.getValue());
								objeto.setValue(numero);
							}
						}
					}]
				}]
	 		},
	 		{
	 			layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:350px;top:300px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Diciembre',
						name: 'monto',
						id: 'diciembre',
						width: 150,
						autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '100', onkeypress: "return keyRestrict(event,'0123456789.');"},
						listeners:{
							'blur':function(objeto)
							{
								var numero = objeto.getValue();
								valor = formatoNumericoMostrar(objeto.getValue(),2,'.',',','','','-','');
								objeto.setValue(valor);
								validarMonto(objeto,'Diciembre');
							},
							'focus':function(objeto)
							{
								var numero = formatoNumericoEdicion(objeto.getValue());
								objeto.setValue(numero);
							}
						}
					}]
				}]
	 		},
	 		{
	 			layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:330px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Total Distribuido',
						name: 'monto',
						id: 'mondis',
						width: 150,
						readOnly: true,
					}]
				}]
	 		},{
	 			layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:350px;top:330px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Por Distribuir',
						name: 'monto',
						id: 'monpordis',
						width: 150,
						readOnly:true,
					}]
				}]
	 		}]
    	}]   
	});
	//fin del formulario 
	//-------------------------------------------------------------------------------------------------------------	
	
	//Creando la ventana del catalogo bienes
	var ventana = new Ext.Window({
		title: "<H1 align='center'>Asignacion Manual</H1>",
        width:680,
        height:500,
        modal: false,
        closable:false,
        plain: false,
        frame:true,
        items:[formVentanaCatalogo],
		buttons: [{
			text:'Aceptar',  
			handler: function(){
				var aux = formatoNumericoMostrar(0,2,'.',',','','','-','');
				if(Ext.getCmp('monpordis').getValue()!=aux){
					Ext.MessageBox.show({
						title:'Mensaje',
						msg:'La Distribucion no cuadra con lo asignado, por favor revise los montos !!!',
						buttons: Ext.Msg.OK,
						icon: Ext.MessageBox.INFO
					});
				}
				else{
					registro.set('estdis','S');
					registro.set('enero',Ext.getCmp('enero').getValue());
					registro.set('febrero',Ext.getCmp('febrero').getValue());
					registro.set('marzo',Ext.getCmp('marzo').getValue());
					registro.set('abril',Ext.getCmp('abril').getValue());
					registro.set('mayo',Ext.getCmp('mayo').getValue());
					registro.set('junio',Ext.getCmp('junio').getValue());
					registro.set('julio',Ext.getCmp('julio').getValue());
					registro.set('agosto',Ext.getCmp('agosto').getValue());
					registro.set('septiembre',Ext.getCmp('septiembre').getValue());
					registro.set('octubre',Ext.getCmp('octubre').getValue());
					registro.set('noviembre',Ext.getCmp('noviembre').getValue());
					registro.set('diciembre',Ext.getCmp('diciembre').getValue());
					ventana.destroy();
				}
			}
		},{
	   		text: 'Salir',
   			handler:function(){
   				ventana.destroy();
   		    }
   		}]
	});
	ventana.show();
	distribucion();

	function distribucion()
	{
		var asignado = parseFloat(ue_formato_operaciones(monto));
//		var division = parseFloat(ue_formato_operaciones((asignado/12)));
		var division = (asignado/12);
		if(empresa["estspgdecimal"]==0){
			division_aux=redondear2(division); //ojo con la funcion
			if(!verificarDistAuto(division_aux,asignado))
			{
				division=redondear3(division);
			}
			else
			{
				division=redondear2(division);
			}
			asignado=redondear2(asignado);
			suma_diciembre=redondear2(division*12);
			mes12=(asignado-suma_diciembre);
			mes12=redondear2(mes12);
			if(mes12>=0)
			{
				diciembre=division+mes12;
			} 			
			else
			{
				diciembre=division+mes12;
			}
			total=(division*11);
			total_general=total+diciembre;
			total_general=redondear2(total_general);
			resto=(asignado-total_general);
			resto=redondear2(resto);
			diciembre=diciembre+resto;
		}
		else{
	   		mes=division;
	   		diciembre=mes+(asignado-(mes*12));
		}
		distribuido=(division*11)+diciembre;
		pordistribuir=asignado-distribuido;
		division=formatoNumericoMostrar(division,2,'.',',','','','-','');
		diciembre=formatoNumericoMostrar(diciembre,2,'.',',','','','-','');
		Ext.getCmp('enero').setValue(division);
		Ext.getCmp('febrero').setValue(division);
		Ext.getCmp('marzo').setValue(division);
		Ext.getCmp('abril').setValue(division);
		Ext.getCmp('mayo').setValue(division);
		Ext.getCmp('junio').setValue(division);
		Ext.getCmp('julio').setValue(division);
		Ext.getCmp('agosto').setValue(division);
		Ext.getCmp('septiembre').setValue(division);
		Ext.getCmp('octubre').setValue(division);
		Ext.getCmp('noviembre').setValue(division);
		Ext.getCmp('diciembre').setValue(diciembre);
		Ext.getCmp('mondis').setValue(formatoNumericoMostrar(distribuido,2,'.',',','','','-',''));
		Ext.getCmp('monpordis').setValue(formatoNumericoMostrar(pordistribuir,2,'.',',','','','-',''));
	}
	
	function verificarDistAuto(monto,asignado)
	{
		var total = 0;
		var ok = true;
		for(i=1;i<=12;i++)
		{
			total += monto;
			if((total>asignado)&&(i<12))
			{
				ok = false
				break;
			}
		}
		return ok;
	}
	
	function redondear2(numero)
	{
		numero2='';
		numero=parseFloat(numero);
		numero=Math.ceil(numero*10)/10
		AuxString = numero.toString();
		if(AuxString.indexOf('.')>=0)
		{
			AuxArr=AuxString.split('.');
			if(AuxArr[1]>=5)
			{
				numero=Math.ceil(numero);
			}
			else
			{ 
				numero=Math.floor(numero);
			}
		} 
		return numero;
	}

	function redondear3(numero)
	{
		numero2='';
		numero=parseFloat(numero);
		numero=Math.ceil(numero*10)/10
		AuxString = numero.toString();
		if(AuxString.indexOf('.')>=0)
		{
			AuxArr=AuxString.split('.');
			if(AuxArr[1]>5)
			{
				numero=Math.ceil(numero);
			}
			else
			{ 
				numero=Math.floor(numero);
			}
		} 
		return numero;
	}
	
	function validarMonto(objeto,valor)
	{
		monto=parseFloat(ue_formato_operaciones(monto));
		monto_aux=parseFloat(ue_formato_operaciones(objeto.getValue()));
		if(monto_aux>monto){
			Ext.MessageBox.show({
				title:'Mensaje',
				msg:'El monto para el Mes '+valor+' debe ser menor al Monto Asignado de la Cuenta !!!',
				buttons: Ext.Msg.OK,
				icon: Ext.MessageBox.INFO
			});
			objeto.setValue(formatoNumericoMostrar(0,2,'.',',','','','-',''));
		}
		else{
			total=acumularMonto();
			if(total>monto){
				Ext.MessageBox.show({
					title:'Mensaje',
					msg:'El acumulado de la distribucion debe ser menor al Monto Asignado de la Cuenta !!!',
					buttons: Ext.Msg.OK,
					icon: Ext.MessageBox.INFO
				});
				objeto.setValue(formatoNumericoMostrar(0,2,'.',',','','','-',''));
			}
			resta=monto-total;
			Ext.getCmp('mondis').setValue(formatoNumericoMostrar(total,2,'.',',','','','-',''));
			Ext.getCmp('monpordis').setValue(formatoNumericoMostrar(resta,2,'.',',','','','-',''));
		}
	}
	
	function acumularMonto()
	{
		montoene=parseFloat(ue_formato_operaciones(Ext.getCmp('enero').getValue()));
		montofeb=parseFloat(ue_formato_operaciones(Ext.getCmp('febrero').getValue()));
		montomar=parseFloat(ue_formato_operaciones(Ext.getCmp('marzo').getValue()));
		montoabr=parseFloat(ue_formato_operaciones(Ext.getCmp('abril').getValue()));
		montomay=parseFloat(ue_formato_operaciones(Ext.getCmp('mayo').getValue()));
		montojun=parseFloat(ue_formato_operaciones(Ext.getCmp('junio').getValue()));
		montojul=parseFloat(ue_formato_operaciones(Ext.getCmp('julio').getValue()));
		montoago=parseFloat(ue_formato_operaciones(Ext.getCmp('agosto').getValue()));
		montosep=parseFloat(ue_formato_operaciones(Ext.getCmp('septiembre').getValue()));
		montooct=parseFloat(ue_formato_operaciones(Ext.getCmp('octubre').getValue()));
		montonov=parseFloat(ue_formato_operaciones(Ext.getCmp('noviembre').getValue()));
		montodic=parseFloat(ue_formato_operaciones(Ext.getCmp('diciembre').getValue()));
		total=montoene+montofeb+montomar+montoabr+montomay+montojun+montojul+montoago+montosep+montooct+montonov+montodic;
		return total;
	}
}	


