<?php
    session_start();   
	header("Pragma: public");
	header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
	header("Cache-Control: private",false);
	if(!array_key_exists("la_logusr",$_SESSION))
	{
		print "<script language=JavaScript>";
		print "close();";
		print "</script>";		
	}
	//--------------------------------------------------------------------------------------------------------------------------------
	function uf_print_encabezado_pagina($as_titulo,$as_moneda,$as_trimestre,$ldt_fecdes,$ldt_fechas,$io_pdf)
	{
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_encabezadopagina
		//		    Acess: private 
		//	    Arguments: as_titulo // Ttulo del Reporte
		//                 $as_moneda // Moneda
		//	    		   as_trimestre // Nro. del Trimestre
		//	    		   io_pdf // Instancia de objeto pdf
		//    Description: funcion que imprime los encabezados por pgina
		//	   Creado Por: Ing. Arnaldo Surez
		// Fecha Creacion: 29/10/2008
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
		$io_encabezado=$io_pdf->openObject();
		$io_pdf->saveState();
		$io_pdf->addText(20,560,7,"<b>REPBLICA BOLIVARIANA DE VENEZUELA<b>");
		$io_pdf->addJpegFromFile('../../../shared/imagebank/'.$_SESSION["ls_logo"],25,500,$_SESSION["ls_width"],$_SESSION["ls_height"]); // Agregar Logo
		$io_pdf->line(9,430,9,465);  // Lnea izquierda partida
		$io_pdf->line(9,465,1000,465); // Linea SUBPARTIDA, COMPROMISO, CAUSADO Y PAGADO
		$io_pdf->line(120,430,120,465);  // Lnea entre partida y Asignacin anual
		$io_pdf->line(255,430,255,465);  // Lnea entre Asignacin anual y Modificaciones presupuestarias
		$io_pdf->line(425,430,425,465);  // Linea entre Modificaciones presupuestarias y Crditos adicionales
		$io_pdf->line(540,430,540,465);  // Linea entre Crditos adicionales e Incorporaciones
		$io_pdf->line(630,430,630,465);  // Linea entre Incorporaciones y Presupuesto actualizado
		$io_pdf->line(755,430,755,465);  // Linea entre Presupuesto actualizado y Gastos efectuados
		$io_pdf->line(830,430,830,465);  // Linea entre Gastos efectuados y Disponibilidad
		$io_pdf->line(900,430,900,465);  // Lnea entre Disponibilidad y Fuente
		$io_pdf->line(1000,430,1000,465);  // Lnea Final
		
		$io_pdf->addText(50,445,7,"PARTIDA");
		$io_pdf->addText(152,445,7,"ASIGNACIN ANUAL");
		$io_pdf->addText(275,453,7,"MODIFICACIONES PRESUPUESTARIAS");
		$io_pdf->line(256,448,424,448); // Linea inferior Modificaciones presupiestarias
		$io_pdf->addText(275,438,7,"AUMENTO");
		$io_pdf->line(340,430,340,448);  // linea divisoria Aumento - Disminucin
		$io_pdf->addText(360,438,7,"DISMINUCIN");
		$io_pdf->addText(440,445,7,"CRDITOS ADICIONALES");
		$io_pdf->addText(550,450,7,"INCORPORACIONES");
		$io_pdf->addText(549,440,7,"INGRESOS PROPIOS");
		$io_pdf->addText(640,445,7,"PRESUPUESTO ACTUALIZADO");
		$io_pdf->addText(780,450,7,"GASTOS");
		$io_pdf->addText(770,440,7,"EFECTUADOS");
		$io_pdf->addText(837,445,7,"DISPONIBILIDAD");
		$io_pdf->addText(905,455,6,"FUENTE DE FINANCIAMIENTO");
		$io_pdf->addText(905,445,6,"CORRESPONDIENTE A LA");
		$io_pdf->addText(905,435,6,"DISPONIBILIDAD");
		
		$li_tm=$io_pdf->getTextWidth(16,$as_titulo);
		$tm=505-($li_tm/2);
		$io_pdf->addText($tm,500,16,$as_titulo); // Agregar el ttulo
		
		$li_tm=$io_pdf->getTextWidth(16,$as_moneda);
		$tm=490-($li_tm/2);
		$io_pdf->addText($tm,485,10,$as_moneda); // Agregar el ttulo
		
		$io_pdf->restoreState();
		$io_pdf->closeObject();
		$io_pdf->addObject($io_encabezado,'all');
		
	}// end function uf_print_encabezadopagina
	//--------------------------------------------------------------------------------------------------------------------------------
	
	//--------------------------------------------------------------------------------------------------------------------------------
	function uf_print_titulo_reporte($io_encabezado,$as_programatica,$ai_ano,$as_mes,$as_denestpro,$ld_total_pagos_mensual,$io_pdf)
	{
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_encabezadopagina
		//		    Acess: private 
		//	    Arguments: as_titulo // Ttulo del Reporte
		//	    		   as_periodo_comp // Descripcion del periodo del comprobante
		//	    		   as_fecha_comp // Descripcion del Periodo de la fecha del comprobante 
		//	    		   io_pdf // Instancia de objeto pdf
		//    Description: funcion que imprime los encabezados por pgina
		//	   Creado Por: Ing. Arnaldo Surez
		// Fecha Creacion: 14/10/2008 
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
		$io_pdf->saveState();
		$io_pdf->ezSetY(570);
		$ls_codemp=$_SESSION["la_empresa"]["codemp"];
		$ls_nombre=$_SESSION["la_empresa"]["nombre"];
		$ls_nomorgads=$_SESSION["la_empresa"]["nomorgads"];
		$ls_codasiona   = $_SESSION['la_empresa']['codasiona'];
		
		$io_pdf->addText(900,560,7,"<b>Memoria y Cuenta ".$ai_ano."</b>");
		$la_data=array(array('name'=>'                               <b>RESUMEN DE LA EJECUCIN PRESUPUESTARIA Y FINANCIERA</b>'),
					   array('name'=>'                                                                         <b>AO   </b>'.'<b>'.$ai_ano."</b>"                    ),
					   array('name'=>'                                                                               <b>(Bs)</b>'                    ));
		$la_columna=array('name'=>'','name'=>'','name'=>'');
		$la_config =array('showHeadings'=>0,     // Mostrar encabezados
						 'fontSize' => 12,       // Tamao de Letras
						 'titleFontSize' => 12, // Tamao de Letras de los ttulos
						 'showLines'=>0,        // Mostrar Lneas
						 'shaded'=>0,           // Sombra entre lneas
						 'xPos'=>665,//65
						 'shadeCol2'=>array(0.9,0.9,0.9), // Color de la sombra
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'width'=>900, // Ancho de la tabla
						 'maxWidth'=>900);
		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);
		$io_pdf->restoreState();
		$io_pdf->closeObject();
		$io_pdf->addObject($io_encabezado,'all');
		
	}// end function uf_print_encabezadopagina
	//--------------------------------------------------------------------------------------------------------------------------------

	//--------------------------------------------------------------------------------------------------------------------------------
	function uf_print_detalle($la_data,$io_pdf)
	{
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_detalle
		//		    Acess: private 
		//	    Arguments: la_data // arreglo de informacion
		//	   			   io_pdf // Objeto PDF
		//    Description: funcion que imprime el detalle
		//	   Creado Por: Ing. Arnaldo Surez
		// Fecha Creacion: 28/10/2006 
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
		
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 6, // Tamao de Letras
						 'titleFontSize' => 7,  // Tamao de Letras de los ttulos
						 'showLines'=>2, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'colGap'=>0, // separacion entre tablas
						 'width'=>989, // Ancho de la tabla
						 'maxWidth'=>989, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array(	 'codigo'=>array('justification'=>'left','width'=>111),
										 'asignado'=>array('justification'=>'right','width'=>135),
										 'aumento'=>array('justification'=>'right','width'=>85),
										 'disminucion'=>array('justification'=>'right','width'=>85),
										 'credito'=>array('justification'=>'right','width'=>115),
										 'ingresos'=>array('justification'=>'right','width'=>90),
										 'presup_act'=>array('justification'=>'right','width'=>125),
										 'gastos'=>array('justification'=>'right','width'=>75),
										 'disponibilidad'=>array('justification'=>'right','width'=>70),
										 'fuente'=>array('justification'=>'center','width'=>100))); // Justificacion y ancho de la columna
										 
		$la_columnas=array(  'codigo'=>'',
							'asignado'=>'',
							'aumento'=>'',
							'disminucion'=>'',
							'credito'=>'',
							'ingresos'=>'',
							'presup_act'=>'',
							'gastos'=>'',
							'disponibilidad'=>'',
							'fuente'=>'');
		$io_pdf->ezTable($la_data,$la_columnas,'',$la_config);
	}// end function uf_print_detalle
	//--------------------------------------------------------------------------------------------------------------------------------

	//--------------------------------------------------------------------------------------------------------------------------------
	function uf_print_pie_cabecera($la_data_tot,$io_pdf)
	{
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function : uf_print_pie_cabecera
		//		    Acess : private 
		//	    Arguments : ad_total // Total General
		//    Description : funcion que imprime el fin de la cabecera de cada pgina
		//	   Creado Por: Ing. Arnaldo USrez
		// Fecha Creacion: 10/06/2008 
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 7, // Tamao de Letras
						 'titleFontSize' => 7,  // Tamao de Letras de los ttulos
						 'showLines'=>2, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'colGap'=>0, // separacion entre tablas
						 'width'=>990, // Ancho de la tabla
						 'maxWidth'=>990, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array(	 'totales'=>array('justification'=>'left','width'=>111),
										 'total_asignado'=>array('justification'=>'right','width'=>135),
										 'total_aumento'=>array('justification'=>'right','width'=>85),
										 'total_disminucion'=>array('justification'=>'right','width'=>85),
										 'total_credito'=>array('justification'=>'right','width'=>115),
										 'total_ingreso'=>array('justification'=>'right','width'=>90),
										 'total_presupact'=>array('justification'=>'right','width'=>125),
										 'total_gastos'=>array('justification'=>'right','width'=>75),
										 'total_disponible'=>array('justification'=>'right','width'=>70),
										 'fuente'=>array('justification'=>'center','width'=>100))); // Justificacion y ancho de la columna
		$la_columnas=array(  'totales'=>'',
							'total_asignado'=>'',
							'total_aumento'=>'',
							'total_disminucion'=>'',
							'total_credito'=>'',
							'total_ingreso'=>'',
							'total_presupact'=>'',
							'total_gastos'=>'',
							'total_disponible'=>'',
							'fuente'=>'');
		$io_pdf->ezTable($la_data_tot,$la_columnas,'',$la_config);
	}// end function uf_print_pie_cabecera
	//--------------------------------------------------------------------------------------------------------------------------------
		require_once("../../../shared/ezpdf/class.ezpdf.php");
		
		require_once("../../../shared/class_folder/class_funciones.php");
		$io_funciones=new class_funciones();	
		require_once("sigesp_spg_funciones_reportes.php");
		$io_function_report=new sigesp_spg_funciones_reportes();	
		require_once("../../../shared/class_folder/class_fecha.php");
		$io_fecha = new class_fecha();
//-----------------------------------------------------------------------------------------------------------------------------
		global $la_data_tot;
		require_once("sigesp_spg_class_estado_eje_pre.php");
		$io_report = new sigesp_spg_class_reportes_instructivo_06();
		 
	//--------------------------------------------------  Parmetros para Filtar el Reporte  -----------------------------------------
		$ldt_periodo=$_SESSION["la_empresa"]["periodo"];
		$li_ano=substr($ldt_periodo,0,4);
		$li_estmodest=$_SESSION["la_empresa"]["estmodest"];

		$ls_cmbmes=$_GET["mes"];
		$ls_tipo=$_GET["tipo"];
		switch($ls_cmbmes)
		{
		 case '01': $ls_mes = "ENERO";
		 break;
		 
		 case '02': $ls_mes = "FEBRERO";
		 break;
		 
		 case '03': $ls_mes = "MARZO";
		 break;
		 
		 case '04': $ls_mes = "ABRIL";
		 break;
		 
		 case '05': $ls_mes = "MAYO";
		 break;
		 
		 case '06': $ls_mes = "JUNIO";
		 break;
		 
		 case '07': $ls_mes = "JULIO";
		 break;
		 
		 case '08': $ls_mes = "AGOSTO";
		 break;
		 
		 case '09': $ls_mes = "SEPTIEMBRE";
		 break;
		 
		 case '10': $ls_mes = "OCTUBRE";
		 break;
		 
		 case '11': $ls_mes = "NOVIEMBRE";
		 break;
		 
		 case '12': $ls_mes = "DICIEMBRE";
		 break;
		
		}
		$li_mesdes=substr($ls_cmbmes,0,2);
		$ldt_fecdes=$li_ano."-".$ls_cmbmes."-01";
		$li_meshas=substr($ls_cmbmes,2,2);
		$ldt_ult_dia=$io_fecha->uf_last_day($ls_cmbmes,$li_ano);
		$fechas=$ldt_ult_dia;
		$ldt_fechas=$io_funciones->uf_convertirdatetobd($fechas);	
		
//----------------------------------------------------  Parmetros del encabezado  ---------------------------------------------
		$ls_titulo=" ";       
//--------------------------------------------------------------------------------------------------------------------------------
   
     $lb_valido=$io_report->uf_spg_reporte_detalle_resumen_ejecucion_fin_pre($ls_cmbmes,$li_ano);

	 if($lb_valido==false) // Existe algn error o no hay registros
	 {
		print("<script language=JavaScript>");
		print(" alert('No hay nada que Reportar');"); 
		print(" close();");
		print("</script>");
	 }
	 else // Imprimimos el reporte
	 {
	    error_reporting(E_ALL);
		set_time_limit(1800);
		$io_pdf=new Cezpdf('LEGAL','landscape'); // Instancia de la clase PDF
		$io_pdf->selectFont('../../../shared/ezpdf/fonts/Helvetica.afm'); // Seleccionamos el tipo de letra
		uf_print_encabezado_pagina($ls_titulo,"",$ls_mes,$ldt_fecdes,$ldt_fechas,$io_pdf); // Imprimimos el encabezado de la pgina
		$io_pdf->transaction('start'); // Iniciamos la transaccion
		$thisPageNum=$io_pdf->ezPageCount;
		$li_tot=$io_report->dts_reporte->getRowCount("codigo");
	    	$ld_total_gasto_mensual   = 0;
		$thisPageNum=$io_pdf->ezPageCount;
		$la_data='';
		$ls_total_asignado="0";
		$ls_total_aumento="0";
		$ls_total_disminucion="0";
		$ls_total_credito="0";
		$ls_total_ingreso="0";
		$ls_total_presupact="0";
		$ls_total_gastos="0";
		$ls_total_disponible="0";

		for($z=1;$z<=$li_tot;$z++)
		{		
			$ls_spg_cuenta = "";
	        	$ls_partida="";
			$ls_generica="";
			$ls_especifica="";
			$ls_subesp="";
			$ls_denominacion="";
	        	$partida="";
			$ls_asignado="0";
			$ls_aumento="0";
			$ls_disminucion="0";
			$ls_credito="0";
			$ls_ingreso="0";
			$ls_gastos="0";
			$ls_presupact="0";
			$ls_disponible="0";
			$ls_fuente="";
			

				  $ls_spg_cuenta             = trim($io_report->dts_reporte->data["codigo"][$z]);
				  $arrResultado=$io_function_report->uf_get_spg_cuenta($ls_spg_cuenta,$ls_partida,$ls_generica,$ls_especifica,$ls_subesp);
//INICIO DETALLES REPORTE
//DETALLE CODIGO PRESUPUESTARIO
				  $ls_partida=$arrResultado['as_spg_partida'];
				  $ls_generica=$arrResultado['as_spg_generica'];
				  $ls_especifica=$arrResultado['as_spg_especifica'];
				  $ls_subesp=$arrResultado['as_spg_subesp'];
//DENOMINACION 
				  $ls_denominacion           	= trim($io_report->dts_reporte->data["denominacion"][$z]);
//PARTIDA
				  $partida 	= substr($ls_partida,0,1).'.'.substr($ls_partida,1,2).'.'.$ls_generica.'.'.$ls_especifica.'.'.$ls_subesp.' "'.$ls_denominacion.'"';
//ASIGNADO - MODIFICACIONES - AUMENTO - DISMINUCION - CREDITO
				  $ls_asignado           	= abs(trim($io_report->dts_reporte->data["asignado"][$z]));
				  $ls_aumento           	= abs(trim($io_report->dts_reporte->data["aumento"][$z]));
				  $ls_disminucion           	= abs(trim($io_report->dts_reporte->data["disminucion"][$z]));
				  $ls_credito           	= abs(trim($io_report->dts_reporte->data["credito"][$z]));
				  $ls_ingreso			= abs($ls_ingreso);
//PRESUPUESTO ACTUALIZADO
				  $ls_presupact			= abs($ls_asignado+$ls_aumento+$ls_credito+$ls_ingreso-$ls_disminucion);
//GASTOS
				  $ls_gastos			= abs(trim($io_report->dts_reporte->data["gasto"][$z]));
//DISPONIBILIDAD
				  $ls_disponible		= abs($ls_presupact-$ls_gastos);
//FUENTE DE FINANCIAMIENTO
				  $ls_fuente			= trim($io_report->dts_reporte->data["fuente"][$z]);
//FIN DETALLES REPORTE
				  
//TOTALES GENERALES REPORTE
				$ls_total_asignado	=	abs($ls_total_asignado+$ls_asignado);
				$ls_total_aumento	=	abs($ls_total_aumento+$ls_aumento);
				$ls_total_disminucion	=	abs($ls_total_disminucion+$ls_disminucion);
				$ls_total_credito	=	abs($ls_total_credito+$ls_credito);
				$ls_total_ingreso	=	abs($ls_total_ingreso+$ls_ingreso);
				$ls_total_presupact	=	abs($ls_total_presupact+$ls_presupact);
				$ls_total_gastos	=	abs($ls_total_gastos+$ls_gastos);
				$ls_total_disponible	=	abs($ls_total_disponible+$ls_disponible);
//FIN TOTALES GENERALES REPORTE

//FORMATO MONTOS
				  $ls_asignado	   		= number_format(abs($ls_asignado),2,",",".");
				  $ls_aumento	   		= number_format(abs($ls_aumento),2,",",".");
				  $ls_disminucion	   	= number_format(abs($ls_disminucion),2,",",".");
				  $ls_credito	   		= number_format(abs($ls_credito),2,",",".");
				  $ls_ingreso	   		= number_format(abs($ls_ingreso),2,",",".");
				  $ls_gastos	   		= number_format(abs($ls_gastos),2,",",".");
				  $ls_presupact	   		= number_format(abs($ls_presupact),2,",",".");
				  $ls_disponible	   	= number_format(abs($ls_disponible),2,",",".");
				
				  $la_data[$z]=array('codigo'=>$partida,
									 'asignado'=>$ls_asignado,
									 'aumento'=>$ls_aumento,
									 'disminucion'=>$ls_disminucion,
									 'credito'=>$ls_credito,
									 'ingresos'=>$ls_ingreso,
									 'presup_act'=>$ls_presupact,
									 'gastos'=>$ls_gastos,
									 'disponibilidad'=>$ls_disponible,
									 'fuente'=>$ls_fuente);
			}//for
			$ls_total_asignado	   	= number_format(abs($ls_total_asignado),2,",",".");
			$ls_total_aumento	   	= number_format(abs($ls_total_aumento),2,",",".");
			$ls_total_disminucion	   	= number_format(abs($ls_total_disminucion),2,",",".");
			$ls_total_credito	   	= number_format(abs($ls_total_credito),2,",",".");
			$ls_total_ingreso	   	= number_format(abs($ls_total_ingreso),2,",",".");
			$ls_total_presupact	   	= number_format(abs($ls_total_presupact),2,",",".");
			$ls_total_gastos	   	= number_format(abs($ls_total_gastos),2,",",".");
			$ls_total_disponible	   	= number_format(abs($ls_total_disponible),2,",",".");
			$la_data_tot[1]=array(	 'totales'=>"                           TOTALES",
							'total_asignado'=>$ls_total_asignado,
							'total_aumento'=>$ls_total_aumento,
							'total_disminucion'=>$ls_total_disminucion,
							'total_credito'=>$ls_total_credito,
							'total_ingreso'=>$ls_total_ingreso,
							'total_presupact'=>$ls_total_presupact,
							'total_gastos'=>$ls_total_gastos,
							'total_disponible'=>$ls_total_disponible,
							'fuente'=>'');

            		$io_encabezado=$io_pdf->openObject();
			uf_print_titulo_reporte($io_encabezado,"",$li_ano,$ls_mes,"","",$io_pdf);
			$io_pdf->ezSetCmMargins(6.4,3,3,3);
			if(count($la_data)>0)
			{
				uf_print_detalle($la_data,$io_pdf); // Imprimimos el detalle 
				uf_print_pie_cabecera($la_data_tot,$io_pdf);
			}
			unset($la_data);
			unset($la_data_tot);		
		$io_pdf->ezStopPageNumbers(1,1);
		if (isset($d) && $d)
		{
			$ls_pdfcode = $io_pdf->ezOutput(1);
			$ls_pdfcode = str_replace("\n","\n<br>",htmlspecialchars($ls_pdfcode));
			echo '<html><body>';
			echo trim($ls_pdfcode);
			echo '</body></html>';
		}
		else
			
		{
			$io_pdf->ezStream();
		}
		unset($io_pdf);
	}//else
	unset($io_report);
	unset($io_funciones);
?> 
