<?php
    session_start();   
	header("Pragma: public");
	header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
	header("Cache-Control: private",false);
	if(!array_key_exists("la_logusr",$_SESSION))
	{
		print "<script language=JavaScript>";
		print "close();";
		print "</script>";		
	}
	//--------------------------------------------------------------------------------------------------------------------------------
	function uf_print_encabezado_pagina($as_titulo,$as_moneda,$as_trimestre,$ldt_fecdes,$ldt_fechas,$io_pdf)
	{
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_encabezadopagina
		//		    Acess: private 
		//	    Arguments: as_titulo // Ttulo del Reporte
		//                 $as_moneda // Moneda
		//	    		   as_trimestre // Nro. del Trimestre
		//	    		   io_pdf // Instancia de objeto pdf
		//    Description: funcion que imprime los encabezados por pgina
		//	   Creado Por: Ing. Arnaldo Surez
		// Fecha Creacion: 29/10/2008
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
		$io_encabezado=$io_pdf->openObject();
		$io_pdf->saveState();
		$io_pdf->addText(20,560,7,"<b>REPBLICA BOLIVARIANA DE VENEZUELA<b>");
		$io_pdf->addJpegFromFile('../../../shared/imagebank/'.$_SESSION["ls_logo"],25,500,$_SESSION["ls_width"],$_SESSION["ls_height"]); // Agregar Logo
		$io_pdf->line(9,380,9,415);  // Lnea izquierda cdigo cuenta presupuestaria
		$io_pdf->line(9,415,1000,415); // Linea SUBPARTIDA, COMPROMISO, CAUSADO Y PAGADO
		$io_pdf->line(35,380,35,415);  // Linea entre Denominacion y Partida
		$io_pdf->line(55,380,55,415);  // Partida
		$io_pdf->line(75,380,75,415);  // Generica
		$io_pdf->line(110,380,110,415);  // Especfica
		$io_pdf->line(120,380,120,415);  // SubEspecfica
		$io_pdf->line(285,380,285,415);  // linea derecha Denominacion
		$io_pdf->line(425,380,425,415);  // Linea derecha Asignacion inicial anual
		$io_pdf->line(540,380,540,415);  // Linea derecha fondos recibidos en el mes
		$io_pdf->line(755,380,755,415);  // Linea derecha Pagos
		$io_pdf->line(900,380,900,415);  // Pagado Ejecutado Acumulado Mensual
		$io_pdf->line(1000,380,1000,415);  // Pagado Ejecutado Acumulado Mensual
		
		$io_pdf->addText(20,440,7,"<b>CUENTADANTE:<b>");
		$io_pdf->line(75,440,240,440);  // Lnea programa
		$io_pdf->addText(250,440,7,"<b>ORDENES DE PAGO:<b>");
		$io_pdf->line(330,440,440,440);  // Lnea rdenes de pago
		$io_pdf->addText(450,440,7,"<b>FECHA:<b>");
		$io_pdf->addText(510,442,9,substr($ldt_fechas,8,2).'/'.substr($ldt_fechas,5,2).'/'.substr($ldt_fechas,0,4));
		$io_pdf->line(490,440,740,440);  // Recuadro fecha
		$io_pdf->addText(15,390,6,"PART");
		$io_pdf->addText(40,390,6,"GEN");
		$io_pdf->addText(60,390,6,"ESP");
		$io_pdf->addText(80,390,6,"SUB-ESP");
		$io_pdf->addText(162,395,7,"DENOMINACION");
		// DATOS DOCUMENTOS
		$io_pdf->addText(338,403,7,"COMPROBANTE");
		$io_pdf->line(286,398,424,398); // Linea inferior comprobante
		$io_pdf->addText(315,388,7,"NMERO");
		$io_pdf->line(370,380,370,398);  // linea divisoria nmero - fecha
		$io_pdf->addText(380,388,6,"FECHA");
		$io_pdf->addText(465,403,7,"CHEQUE");
		$io_pdf->line(425,398,540,398); // Linea inferior cheque
		$io_pdf->addText(440,388,7,"NMERO");
		$io_pdf->line(490,380,490,398);  // linea divisoria nmero - fecha
		$io_pdf->addText(505,388,6,"FECHA");
		$io_pdf->addText(630,395,7,"CONCEPTO");
		$io_pdf->addText(805,395,7,"BENEFICIARIO");
		$io_pdf->addText(942,395,6,"MONTO BS.");
		$io_pdf->rectangle(8,422,992,59);
		
		$li_tm=$io_pdf->getTextWidth(16,$as_titulo);
		$tm=505-($li_tm/2);
		$io_pdf->addText($tm,500,16,$as_titulo); // Agregar el ttulo
		
		$li_tm=$io_pdf->getTextWidth(16,$as_moneda);
		$tm=490-($li_tm/2);
		$io_pdf->addText($tm,485,10,$as_moneda); // Agregar el ttulo
		
		$io_pdf->restoreState();
		$io_pdf->closeObject();
		$io_pdf->addObject($io_encabezado,'all');
		
	}// end function uf_print_encabezadopagina
	//--------------------------------------------------------------------------------------------------------------------------------
	
	//--------------------------------------------------------------------------------------------------------------------------------
	function uf_print_titulo_reporte($io_encabezado,$as_programatica,$ai_ano,$as_mes,$as_denestpro,$ld_total_pagos_mensual,$io_pdf)
	{
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_encabezadopagina
		//		    Acess: private 
		//	    Arguments: as_titulo // Ttulo del Reporte
		//	    		   as_periodo_comp // Descripcion del periodo del comprobante
		//	    		   as_fecha_comp // Descripcion del Periodo de la fecha del comprobante 
		//	    		   io_pdf // Instancia de objeto pdf
		//    Description: funcion que imprime los encabezados por pgina
		//	   Creado Por: Ing. Arnaldo Surez
		// Fecha Creacion: 14/10/2008 
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
		$io_pdf->addText(750,440,7,"<b>PROGRAMA:<b>");
		$io_pdf->line(800,438,990,438);  // Lnea monto
		$io_pdf->saveState();
		$io_pdf->ezSetY(570);
		$ls_codemp=$_SESSION["la_empresa"]["codemp"];
		$ls_nombre=$_SESSION["la_empresa"]["nombre"];
		$ls_nomorgads=$_SESSION["la_empresa"]["nomorgads"];
		$ls_codasiona   = $_SESSION['la_empresa']['codasiona'];
		
		$la_data=array(array('name'=>'<b>DEPENDENCIA U ORGANISMO  (   </b>'.'<b>'.$ls_codasiona.' - '.$ls_nombre.'</b>)'),
				array('name'=>'                               <b>RELACIN DE GASTOS</b>'),
					   array('name'=>'                               <b>MES RENDIDO:    </b>'.'<b>'.$as_mes."                    AO: ".$ai_ano.'</b>'));
		$la_columna=array('name'=>'','name'=>'','name'=>'');
		$la_config =array('showHeadings'=>0,     // Mostrar encabezados
						 'fontSize' => 12,       // Tamao de Letras
						 'titleFontSize' => 12, // Tamao de Letras de los ttulos
						 'showLines'=>0,        // Mostrar Lneas
						 'shaded'=>0,           // Sombra entre lneas
						 'xPos'=>665,//65
						 'shadeCol2'=>array(0.9,0.9,0.9), // Color de la sombra
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'width'=>900, // Ancho de la tabla
						 'maxWidth'=>900);
		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);
		$io_pdf->restoreState();
		$io_pdf->closeObject();
		$io_pdf->addObject($io_encabezado,'all');
		
	}// end function uf_print_encabezadopagina
	//--------------------------------------------------------------------------------------------------------------------------------

	//--------------------------------------------------------------------------------------------------------------------------------
	function uf_print_detalle($la_data,$io_pdf)
	{
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_detalle
		//		    Acess: private 
		//	    Arguments: la_data // arreglo de informacion
		//	   			   io_pdf // Objeto PDF
		//    Description: funcion que imprime el detalle
		//	   Creado Por: Ing. Arnaldo Surez
		// Fecha Creacion: 28/10/2006 
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
		
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 6, // Tamao de Letras
						 'titleFontSize' => 7,  // Tamao de Letras de los ttulos
						 'showLines'=>2, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'colGap'=>0, // separacion entre tablas
						 'width'=>989, // Ancho de la tabla
						 'maxWidth'=>989, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array(	 'partida'=>array('justification'=>'center','width'=>26),
										 'generica'=>array('justification'=>'center','width'=>20),
										 'especifica'=>array('justification'=>'center','width'=>20),
										 'subespecifica'=>array('justification'=>'center','width'=>35),
										 'fuente'=>array('justification'=>'center','width'=>10),
										 'denominacion'=>array('justification'=>'left','width'=>165),
										 'comprobante'=>array('justification'=>'center','width'=>85),
										 'fecha'=>array('justification'=>'center','width'=>55),
										 'cheque'=>array('justification'=>'right','width'=>65),
										 'fecha_cheque'=>array('justification'=>'right','width'=>50),
										 'descripcion'=>array('justification'=>'left','width'=>215),
										 'proveedor'=>array('justification'=>'left','width'=>145),
										 'monto'=>array('justification'=>'right','width'=>100))); // Justificacion y ancho de la columna
										 
		$la_columnas=array(  'partida'=>'',
							 'generica'=>'',
							 'especifica'=>'',
							 'subespecifica'=>'',
							 'fuente'=>'',
							 'denominacion'=>'',
							 'comprobante'=>'',
							 'fecha'=>'',
							 'cheque'=>'',
							 'fecha_cheque'=>'',
							 'descripcion'=>'',
							 'proveedor'=>'',
							 'monto'=>'');
		$io_pdf->ezTable($la_data,$la_columnas,'',$la_config);
	}// end function uf_print_detalle
	//--------------------------------------------------------------------------------------------------------------------------------

	//--------------------------------------------------------------------------------------------------------------------------------
	function uf_print_pie_cabecera($la_data_tot,$io_pdf)
	{
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function : uf_print_pie_cabecera
		//		    Acess : private 
		//	    Arguments : ad_total // Total General
		//    Description : funcion que imprime el fin de la cabecera de cada pgina
		//	   Creado Por: Ing. Arnaldo USrez
		// Fecha Creacion: 10/06/2008 
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 9, // Tamao de Letras
						 'titleFontSize' => 7,  // Tamao de Letras de los ttulos
						 'showLines'=>2, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'colGap'=>0, // separacion entre tablas
						 'width'=>990, // Ancho de la tabla
						 'maxWidth'=>990, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array(  'totales'=>array('justification'=>'center','width'=>891), // Justificacion y ancho de la columna
						 			     'total_gasto_mensual'=>array('justification'=>'right','width'=>99)));
		$la_columnas=array(  'totales'=>'',
						   	 'total_gasto_mensual'=>'');
		$io_pdf->ezTable($la_data_tot,$la_columnas,'',$la_config);
		//RECTANGULO OBSERVACIONES, FIRMAS Y SELLOS
		$io_pdf->rectangle(8,42,490,79);
		$io_pdf->addText(12,110,7,"<b>ELABORACIN:</b>");
		$io_pdf->addText(12,100,7,"<b>NOMBRES Y APELLIDOS:</b>");
		$io_pdf->line(180,65,475,65); // Linea firma y sello elaboracin
		$io_pdf->addText(300,57,7,"<b>FIRMA Y SELLO</b>");
		$io_pdf->rectangle(510,42,488,79);
		$io_pdf->addText(514,110,7,"<b>COMFORMACIN:</b>");
		$io_pdf->line(694,65,989,65); // Linea firma y sello elaboracin
		$io_pdf->addText(800,57,7,"<b>FIRMA Y SELLO</b>");
		$io_pdf->addText(800,50,7,"<b>CUENTADANTE</b>");
		//FIN RECTANGULO OBSERVACIONES, FIRMAS Y SELLOS
	}// end function uf_print_pie_cabecera
	//--------------------------------------------------------------------------------------------------------------------------------
		require_once("../../../shared/ezpdf/class.ezpdf.php");
		
		require_once("../../../shared/class_folder/class_funciones.php");
		$io_funciones=new class_funciones();	
		require_once("sigesp_spg_funciones_reportes.php");
		$io_function_report=new sigesp_spg_funciones_reportes();	
		require_once("../../../shared/class_folder/class_fecha.php");
		$io_fecha = new class_fecha();
//-----------------------------------------------------------------------------------------------------------------------------
		global $la_data_tot;
		require_once("sigesp_spg_class_estado_eje_pre.php");
		$io_report = new sigesp_spg_class_reportes_instructivo_06();
		 
	//--------------------------------------------------  Parmetros para Filtar el Reporte  -----------------------------------------
		$ldt_periodo=$_SESSION["la_empresa"]["periodo"];
		$li_ano=substr($ldt_periodo,0,4);
		$li_estmodest=$_SESSION["la_empresa"]["estmodest"];

		$ls_cmbmes=$_GET["mes"];
		$ls_tipo=$_GET["tipo"];
		switch($ls_cmbmes)
		{
		 case '01': $ls_mes = "ENERO";
		 break;
		 
		 case '02': $ls_mes = "FEBRERO";
		 break;
		 
		 case '03': $ls_mes = "MARZO";
		 break;
		 
		 case '04': $ls_mes = "ABRIL";
		 break;
		 
		 case '05': $ls_mes = "MAYO";
		 break;
		 
		 case '06': $ls_mes = "JUNIO";
		 break;
		 
		 case '07': $ls_mes = "JULIO";
		 break;
		 
		 case '08': $ls_mes = "AGOSTO";
		 break;
		 
		 case '09': $ls_mes = "SEPTIEMBRE";
		 break;
		 
		 case '10': $ls_mes = "OCTUBRE";
		 break;
		 
		 case '11': $ls_mes = "NOVIEMBRE";
		 break;
		 
		 case '12': $ls_mes = "DICIEMBRE";
		 break;
		
		}
		$li_mesdes=substr($ls_cmbmes,0,2);
		$ldt_fecdes=$li_ano."-".$ls_cmbmes."-01";
		$li_meshas=substr($ls_cmbmes,2,2);
		$ldt_ult_dia=$io_fecha->uf_last_day($ls_cmbmes,$li_ano);
		$fechas=$ldt_ult_dia;
		$ldt_fechas=$io_funciones->uf_convertirdatetobd($fechas);	
		
//----------------------------------------------------  Parmetros del encabezado  ---------------------------------------------
		$ls_titulo=" ";       
//--------------------------------------------------------------------------------------------------------------------------------
   
     $lb_valido=$io_report->uf_spg_reporte_detalle_relacion_gastos($ls_cmbmes,$li_ano);

	 if($lb_valido==false) // Existe algn error o no hay registros
	 {
		print("<script language=JavaScript>");
		print(" alert('No hay nada que Reportar');"); 
		print(" close();");
		print("</script>");
	 }
	 else // Imprimimos el reporte
	 {
	    error_reporting(E_ALL);
		set_time_limit(1800);
		$io_pdf=new Cezpdf('LEGAL','landscape'); // Instancia de la clase PDF
		$io_pdf->selectFont('../../../shared/ezpdf/fonts/Helvetica.afm'); // Seleccionamos el tipo de letra
		uf_print_encabezado_pagina($ls_titulo,"",$ls_mes,$ldt_fecdes,$ldt_fechas,$io_pdf); // Imprimimos el encabezado de la pgina
		$io_pdf->transaction('start'); // Iniciamos la transaccion
		$thisPageNum=$io_pdf->ezPageCount;
		$li_tot=$io_report->dts_reporte->getRowCount("codigo");
	    	$ld_total_gasto_mensual   = 0;
		$thisPageNum=$io_pdf->ezPageCount;
		$la_data='';


		for($z=1;$z<=$li_tot;$z++)
		{		
			
			$ls_codigo="";
			$ls_spg_cuenta = "";
	        	$ls_partida="";
			$ls_generica="";
			$ls_especifica="";
			$ls_subesp="";
			$ls_denominacion="";
			$ls_comprobante="";
			$ls_fecha="";
			$ls_cheque="";
			$ls_fecha_cheque="";
			$ls_descripcion="";
			$ls_proveedor="";
			$ls_beneficiario="";
			$ld_monto_gasto="";
			

				  $ls_spg_cuenta             = trim($io_report->dts_reporte->data["codigo"][$z]);
				  $arrResultado=$io_function_report->uf_get_spg_cuenta($ls_spg_cuenta,$ls_partida,$ls_generica,$ls_especifica,$ls_subesp);
//INICIO DETALLES REPORTE
//DETALLE CODIGO PRESUPUESTARIO
				  $ls_partida=$arrResultado['as_spg_partida'];
				  $ls_generica=$arrResultado['as_spg_generica'];
				  $ls_especifica=$arrResultado['as_spg_especifica'];
				  $ls_subesp=$arrResultado['as_spg_subesp'];
//DENOMINACION 
				  $ls_denominacion           	= trim($io_report->dts_reporte->data["denominacion"][$z]);
//NMERO COMPROBANTE Y FECHA 
				  $ls_comprobante           	= trim($io_report->dts_reporte->data["comprobante"][$z]);
				  $ls_fecha           		= trim($io_report->dts_reporte->data["fecha"][$z]);
				  $ld_fecha 			= substr($ls_fecha,8,2).'/'.substr($ls_fecha,5,2).'/'.substr($ls_fecha,0,4);
//DESCRIPCION
				  $ls_descripcion           	= trim($io_report->dts_reporte->data["descripcion"][$z]);
//PROVEEDOR O BENEFICIARIO
				  $ls_proveedor           	= trim($io_report->dts_reporte->data["proveedor"][$z]);
				  $ls_beneficiario           	= trim($io_report->dts_reporte->data["beneficiario"][$z]);
//MONTO DEL GASTO
				  $ld_monto_gasto  	     	= $io_report->dts_reporte->data["monto"][$z];
//FIN DETALLES REPORTE
				  
//TOTALES GENERALES REPORTE
				   $ld_total_gasto_mensual   = $ld_total_gasto_mensual + $ld_monto_gasto;
//FIN TOTALES GENERALES REPORTE

				  $ld_monto_gasto	   = number_format($ld_monto_gasto,2,",",".");
				
				  $la_data[$z]=array('codigo'=>$ls_spg_cuenta,
									 'denominacion'=>$ls_denominacion,
									 'partida'=>$ls_partida,
									 'generica'=>$ls_generica,
									 'especifica'=>$ls_especifica,
									 'subespecifica'=>$ls_subesp,
									 'fuente'=>'',
									 'denominacion'=>$ls_denominacion,
									 'comprobante'=>$ls_comprobante,
									 'fecha'=>$ld_fecha,
									 'cheque'=>$ls_cheque,
									 'fecha_cheque'=>$ls_fecha_cheque,
									 'descripcion'=>$ls_descripcion,
									 'proveedor'=>$ls_proveedor,
									 'beneficiario'=>$ls_beneficiario,
									 'monto'=>$ld_monto_gasto);
					  							 						   
			}//for
			$ld_total_gasto_mensual   = number_format($ld_total_gasto_mensual,2,",",".");
			$la_data_tot[1]=array(	 'totales'=>"TOTALES",
								  	 'total_gasto_mensual'=>$ld_total_gasto_mensual);

            $io_encabezado=$io_pdf->openObject();
			uf_print_titulo_reporte($io_encabezado,"",$li_ano,$ls_mes,"",$ld_total_gasto_mensual,$io_pdf);
			$io_pdf->ezSetCmMargins(8.1,3,3,3);
			if(count($la_data)>0)
			{
				uf_print_detalle($la_data,$io_pdf); // Imprimimos el detalle 
				uf_print_pie_cabecera($la_data_tot,$io_pdf);
			}
			unset($la_data);
			unset($la_data_tot);		
		$io_pdf->ezStopPageNumbers(1,1);
		if (isset($d) && $d)
		{
			$ls_pdfcode = $io_pdf->ezOutput(1);
			$ls_pdfcode = str_replace("\n","\n<br>",htmlspecialchars($ls_pdfcode));
			echo '<html><body>';
			echo trim($ls_pdfcode);
			echo '</body></html>';
		}
		else
			
		{
			$io_pdf->ezStream();
		}
		unset($io_pdf);
	}//else
	unset($io_report);
	unset($io_funciones);
?> 
