<?php
    session_start();   
	header("Pragma: public");
	header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
	header("Cache-Control: private",false);
	if(!array_key_exists("la_logusr",$_SESSION))
	{
		print "<script language=JavaScript>";
		print "close();";
		print "</script>";		
	}
	//--------------------------------------------------------------------------------------------------------------------------------
	function uf_print_encabezado_pagina($as_titulo,$as_moneda,$as_trimestre,$ldt_fecdes,$ldt_fechas,$io_pdf)
	{
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_encabezadopagina
		//		    Acess: private 
		//	    Arguments: as_titulo // Ttulo del Reporte
		//                 $as_moneda // Moneda
		//	    		   as_trimestre // Nro. del Trimestre
		//	    		   io_pdf // Instancia de objeto pdf
		//    Description: funcion que imprime los encabezados por pgina
		//	   Creado Por: Ing. Arnaldo Surez
		// Fecha Creacion: 29/10/2008
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
		$io_encabezado=$io_pdf->openObject();
		$io_pdf->saveState();
		$io_pdf->addJpegFromFile('../../../shared/imagebank/'.$_SESSION["ls_logo"],25,500,$_SESSION["ls_width"],$_SESSION["ls_height"]); // Agregar Logo
		$io_pdf->line(10,415,1000,415); // Linea SUBPARTIDA, COMPROMISO, CAUSADO Y PAGADO
		$io_pdf->line(35,380,35,400);  // Linea entre Denominacion y Partida
		$io_pdf->line(55,380,55,400);  // Partida
		$io_pdf->line(75,380,75,400);  // Generica
		$io_pdf->line(110,380,110,400);  // Especfica
		$io_pdf->line(120,380,120,415);  // SubEspecfica
		$io_pdf->line(220,380,220,415);    // Linea entre Denominacion y Asignacin inicial
		$io_pdf->line(265,380,265,415);  // Compromiso Programado Mensual
		$io_pdf->line(310,380,310,395);  // Compromiso Programado Acumulado Mensual
		$io_pdf->line(355,380,355,402);  // Compromiso Ejecutado Mensual
		$io_pdf->line(400,380,400,395);  // Compromiso Ejecutado Acumulado Mensual
		$io_pdf->line(440,380,440,415);  // % Compromiso Variacion Absoluta Mensual
		$io_pdf->line(480,380,480,415);  // % Compromiso Variacion Absoluta Acumulada
		$io_pdf->line(525,380,525,395);  // Causado Programado Mensual
		$io_pdf->line(570,380,570,415);  // Causado Programado Acumulado Mensual
		$io_pdf->line(615,380,615,415);  // Causado Ejecutado Mensual
		$io_pdf->line(660,380,660,395);  // Causado Ejecutado Acumulado Mensual
		$io_pdf->line(700,380,700,415);  // % Causado Variacion Absoluta Mensual
		$io_pdf->line(740,380,740,395);  // % Causado Variacion Absoluta Acumulada
		$io_pdf->line(785,380,785,415);  // Pagado Programado Mensual
		$io_pdf->line(830,380,830,395);  // Pagado Programado Acumulado Mensual
		$io_pdf->line(875,380,875,415);  // Pagado Ejecutado Mensual
		$io_pdf->line(920,380,920,395);  // Pagado Ejecutado Acumulado Mensual
		$io_pdf->line(960,380,960,415);  // % Pagado Variacion Absoluta Mensual
		
		
		$io_pdf->addText(20,440,7,"<b>1.-PROGRAMA:<b>");
		$io_pdf->line(75,440,240,440);  // Lnea programa
		$io_pdf->addText(250,440,7,"<b>2.-ORDENES DE PAGO:<b>");
		$io_pdf->line(330,440,440,440);  // Lnea rdenes de pago
		$io_pdf->addText(450,440,7,"<b>3.-FECHA:<b>");
		$ls_desde=(substr($ldt_fecdes,8,2)."-".substr($ldt_fecdes,5,2)."-".substr($ldt_fecdes,0,4));
		$ls_hasta=(substr($ldt_fechas,8,2)."-".substr($ldt_fechas,5,2)."-".substr($ldt_fechas,0,4));
		$io_pdf->addText(540,442,7,$ls_desde."                                  ".$ls_hasta);
		$io_pdf->addText(540,430,7,"DESDE                                         HASTA");
		$io_pdf->line(490,440,740,440);  // Recuadro fecha
		$io_pdf->line(490,440,490,460);  // Recuadro fecha
		$io_pdf->line(740,440,740,460);  // Recuadro fecha
		$io_pdf->addText(400,420,7,"<b>Modificaciones Presupuestarias Aprobadas/No Aprobadas<b>");
		$io_pdf->addText(860,420,7,"<b>HOJA No<b>");
		$io_pdf->line(895,420,990,420);  // Lnea nmero hoja
		$io_pdf->addText(20,405,7,"CODIGO PRESUPUESTARIO");
		$io_pdf->addText(142,395,7,"5.-DENOMINACION");
		$io_pdf->line(10,400,120,400); // Linea cdigo presupuestario inferior
		$io_pdf->addText(15,390,6,"PART");
		$io_pdf->addText(40,390,6,"GEN");
		$io_pdf->addText(60,390,6,"ESP");
		$io_pdf->addText(80,390,6,"SUB-ESP");
		// COMPROMISO
		$io_pdf->addText(221,405,6,"ASIGNACIN");
		$io_pdf->addText(227,395,6,"INICIAL");
		$io_pdf->addText(228,385,6,"ANUAL");
		$io_pdf->addText(280,405,7,"7.-MODIFICACIONES PRESUPUESTARIAS");
		$io_pdf->line(266,402,439,402); // Linea modificaciones presupuestarias inferior
		$io_pdf->addText(300,397,5,"7.1.-MES");
		$io_pdf->addText(380,397,5,"7.2.-ACUMULADO");
		$io_pdf->line(266,395,439,395); // Linea modificaciones presupuestarias inferior
		$io_pdf->addText(275,388,5,"AUMENTO");
		$io_pdf->addText(315,388,5,"DISMINUCIN");
		$io_pdf->addText(368,388,5,"AUMENTO");
		$io_pdf->addText(404,388,5,"DISMINUCIN");
		$io_pdf->addText(442,405,6,"8.-PRESUP.");
		$io_pdf->addText(442,395,5,"ACTUALIZADO");
		// CAUSADO
		$io_pdf->addText(483,405,5,"9.-INCREMENTOS O DEDUCCIONES");
		$io_pdf->addText(487,397,5,"DE LOS FONDOS DELEGADOS");
		$io_pdf->line(480,395,570,395); // Linea Incrementos o deducciones inferior
		$io_pdf->addText(495,388,5,"9.1.-MES");
		$io_pdf->addText(535,388,5,"9.2.-ACUM.");
		$io_pdf->addText(574,402,5,"10.-TOTAL");
		$io_pdf->addText(572,395,5,"PRESUPUESTO");
		$io_pdf->addText(573,388,5,"MAS O MENOS");
		$io_pdf->addText(622,400,7,"11.-COMPROMISOS");
		$io_pdf->line(615,395,700,395); // Linea Compromisos inferior
		$io_pdf->addText(620,388,6,"11.1.-MES");
		$io_pdf->addText(663,388,5,"11.2.-ACUM.");
		// PAGADO
		$io_pdf->addText(720,400,7,"12.-PAGOS");
		$io_pdf->line(700,395,785,395); // Linea Pagos inferior
		$io_pdf->addText(708,388,6,"12.1.-MES");
		$io_pdf->addText(750,388,5,"12.2.-ACUM.");
		$io_pdf->addText(810,400,7,"13.-DEUDA");
		$io_pdf->line(785,395,875,395); // Linea Deuda inferior
		$io_pdf->addText(790,388,6,"13.1.-MES");
		$io_pdf->addText(838,388,5,"13.2.-ACUM.");
		$io_pdf->addText(890,400,7,"14.-REINTEGRO");
		$io_pdf->line(875,395,960,395); // Linea Reintegro inferior
		$io_pdf->addText(880,388,6,"14.1.-MES");
		$io_pdf->addText(925,388,5,"14.2.-ACUM.");
		$io_pdf->addText(962,400,7,"15.-DISP.");
		$io_pdf->addText(962,390,7,"PRESUP.");
		$io_pdf->rectangle(10,382,990,78);
		
		$li_tm=$io_pdf->getTextWidth(16,$as_titulo);
		$tm=505-($li_tm/2);
		$io_pdf->addText($tm,500,16,$as_titulo); // Agregar el ttulo
		
		$li_tm=$io_pdf->getTextWidth(16,$as_moneda);
		$tm=490-($li_tm/2);
		$io_pdf->addText($tm,485,10,$as_moneda); // Agregar el ttulo
		
		$io_pdf->restoreState();
		$io_pdf->closeObject();
		$io_pdf->addObject($io_encabezado,'all');
		
	}// end function uf_print_encabezadopagina
	//--------------------------------------------------------------------------------------------------------------------------------
	
	//--------------------------------------------------------------------------------------------------------------------------------
	function uf_print_titulo_reporte($io_encabezado,$as_programatica,$ai_ano,$as_mes,$as_denestpro,$ld_total_compromisos_acum,$io_pdf)
	{
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_encabezadopagina
		//		    Acess: private 
		//	    Arguments: as_titulo // Ttulo del Reporte
		//	    		   as_periodo_comp // Descripcion del periodo del comprobante
		//	    		   as_fecha_comp // Descripcion del Periodo de la fecha del comprobante 
		//	    		   io_pdf // Instancia de objeto pdf
		//    Description: funcion que imprime los encabezados por pgina
		//	   Creado Por: Ing. Arnaldo Surez
		// Fecha Creacion: 14/10/2008 
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
		$io_pdf->addText(750,440,7,"<b>4.-MONTO DE LA(S) ORDEN(ES) DE PAGO:<b>                 ".$ld_total_compromisos_acum);
		$io_pdf->line(895,438,990,438);  // Lnea monto
		$io_pdf->saveState();
		$io_pdf->ezSetY(570);
		$ls_codemp=$_SESSION["la_empresa"]["codemp"];
		$ls_nombre=$_SESSION["la_empresa"]["nombre"];
		$ls_nomorgads=$_SESSION["la_empresa"]["nomorgads"];
		$ls_codasiona   = $_SESSION['la_empresa']['codasiona'];
		
		$la_data=array(array('name'=>'<b>DEPENDENCIA U ORGANISMO  (   </b>'.'<b>'.$ls_codasiona.' - '.$ls_nombre.'</b>)'),
				array('name'=>'                               <b>ESTADO DE LA EJECUCIN DEL PRESUPUESTO</b>'),
					   array('name'=>'                               <b>MES RENDIDO:    </b>'.'<b>'.$as_mes."                    AO: ".$ai_ano.'</b>'));
		$la_columna=array('name'=>'','name'=>'','name'=>'');
		$la_config =array('showHeadings'=>0,     // Mostrar encabezados
						 'fontSize' => 12,       // Tamao de Letras
						 'titleFontSize' => 12, // Tamao de Letras de los ttulos
						 'showLines'=>0,        // Mostrar Lneas
						 'shaded'=>0,           // Sombra entre lneas
						 'xPos'=>665,//65
						 'shadeCol2'=>array(0.9,0.9,0.9), // Color de la sombra
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'width'=>900, // Ancho de la tabla
						 'maxWidth'=>900);
		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);
		$io_pdf->restoreState();
		$io_pdf->closeObject();
		$io_pdf->addObject($io_encabezado,'all');
		
	}// end function uf_print_encabezadopagina
	//--------------------------------------------------------------------------------------------------------------------------------

	//--------------------------------------------------------------------------------------------------------------------------------
	function uf_print_detalle($la_data,$io_pdf)
	{
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_detalle
		//		    Acess: private 
		//	    Arguments: la_data // arreglo de informacion
		//	   			   io_pdf // Objeto PDF
		//    Description: funcion que imprime el detalle
		//	   Creado Por: Ing. Arnaldo Surez
		// Fecha Creacion: 28/10/2006 
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
		
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 5, // Tamao de Letras
						 'titleFontSize' => 7,  // Tamao de Letras de los ttulos
						 'showLines'=>2, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'colGap'=>0, // separacion entre tablas
						 'width'=>989, // Ancho de la tabla
						 'maxWidth'=>989, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array(	 'partida'=>array('justification'=>'center','width'=>25),
										 'generica'=>array('justification'=>'center','width'=>20),
										 'especifica'=>array('justification'=>'center','width'=>20),
										 'subespecifica'=>array('justification'=>'center','width'=>35),
										 'fuente'=>array('justification'=>'center','width'=>10),
										 'denominacion'=>array('justification'=>'left','width'=>100),
										 'asignado'=>array('justification'=>'right','width'=>45),
										 'comp_aum_mensual'=>array('justification'=>'right','width'=>45),
										 'comp_dis_mensual'=>array('justification'=>'right','width'=>45),
										 'comp_aum_acum'=>array('justification'=>'right','width'=>45),
										 'comp_dis_acum'=>array('justification'=>'right','width'=>40),
										 'comp_presup_actualizado'=>array('justification'=>'right','width'=>40),
										 'monto_mes'=>array('justification'=>'right','width'=>45),
										 'monto_acum'=>array('justification'=>'right','width'=>45),
										 'masmenos'=>array('justification'=>'right','width'=>45),
										 'comp_mes'=>array('justification'=>'right','width'=>45),
										 'comp_acum'=>array('justification'=>'right','width'=>40),
										 'caus_pago'=>array('justification'=>'right','width'=>40),
										 'acum_pago'=>array('justification'=>'right','width'=>45),
										 'deuda_mes'=>array('justification'=>'right','width'=>45),
										 'deuda_acum'=>array('justification'=>'right','width'=>45),
										 'reintegro_mes'=>array('justification'=>'right','width'=>45),
										 'reintegro_acum'=>array('justification'=>'right','width'=>40),
										 'disponibilidad_presup'=>array('justification'=>'right','width'=>40))); // Justificacion y ancho de la columna
										 
		$la_columnas=array(  'partida'=>'',
							 'generica'=>'',
							 'especifica'=>'',
							 'subespecifica'=>'',
							 'fuente'=>'',
							 'denominacion'=>'',
							 'asignado'=>'',
							 'comp_aum_mensual'=>'',
							 'comp_dis_mensual'=>'',
							 'comp_aum_acum'=>'',
							 'comp_dis_acum'=>'',
							 'comp_presup_actualizado'=>'',
							 'monto_mes'=>'',
							 'monto_acum'=>'',
							 'masmenos'=>'',
							 'comp_mes'=>'',
							 'comp_acum'=>'',
							 'caus_pago'=>'',
							 'acum_pago'=>'',
							 'deuda_mes'=>'',
							 'deuda_acum'=>'',
							 'reintegro_mes'=>'',
							 'reintegro_acum'=>'',
							 'disponibilidad_presup'=>'');
		$io_pdf->ezTable($la_data,$la_columnas,'',$la_config);
	}// end function uf_print_detalle
	//--------------------------------------------------------------------------------------------------------------------------------

	//--------------------------------------------------------------------------------------------------------------------------------
	function uf_print_pie_cabecera($la_data_tot,$io_pdf)
	{
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function : uf_print_pie_cabecera
		//		    Acess : private 
		//	    Arguments : ad_total // Total General
		//    Description : funcion que imprime el fin de la cabecera de cada pgina
		//	   Creado Por: Ing. Arnaldo USrez
		// Fecha Creacion: 10/06/2008 
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 5, // Tamao de Letras
						 'titleFontSize' => 7,  // Tamao de Letras de los ttulos
						 'showLines'=>2, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'colGap'=>0, // separacion entre tablas
						 'width'=>990, // Ancho de la tabla
						 'maxWidth'=>990, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array(  'totales'=>array('justification'=>'center','width'=>212), // Justificacion y ancho de la columna
						 			     'comp_prog_mensual'=>array('justification'=>'right','width'=>45),
										 'comp_prog_acum'=>array('justification'=>'right','width'=>45),
										 'comp_eje_mens'=>array('justification'=>'right','width'=>45),
										 'comp_eje_acum'=>array('justification'=>'right','width'=>45),
										 'comp_vari_abs_mens'=>array('justification'=>'right','width'=>40),
										 'comp_vari_abs_acum'=>array('justification'=>'right','width'=>40),
										 'caus_prog_mensual'=>array('justification'=>'right','width'=>45),
										 'caus_prog_acum'=>array('justification'=>'right','width'=>45),
										 'caus_eje_mens'=>array('justification'=>'right','width'=>45),
										 'caus_eje_acum'=>array('justification'=>'right','width'=>45),
										 'caus_vari_abs_mens'=>array('justification'=>'right','width'=>40),
										 'caus_vari_abs_acum'=>array('justification'=>'right','width'=>40),
										 'paga_prog_mensual'=>array('justification'=>'right','width'=>45),
										 'paga_prog_acum'=>array('justification'=>'right','width'=>45),
										 'paga_eje_mens'=>array('justification'=>'right','width'=>45),
										 'paga_eje_acum'=>array('justification'=>'right','width'=>45),
										 'paga_vari_abs_mens'=>array('justification'=>'right','width'=>40),
										 'paga_vari_abs_acum'=>array('justification'=>'right','width'=>40)));
		$la_columnas=array(  'totales'=>'',
						   	 'comp_prog_mensual'=>'',
							 'comp_prog_acum'=>'',
							 'comp_eje_mens'=>'',
							 'comp_eje_acum'=>'',
							 'comp_vari_abs_mens'=>'',
							 'comp_vari_abs_acum'=>'',
							 'caus_prog_mensual'=>'',
							 'caus_prog_acum'=>'',
							 'caus_eje_mens'=>'',
							 'caus_eje_acum'=>'',
							 'caus_vari_abs_mens'=>'',
							 'caus_vari_abs_acum'=>'',
							 'paga_prog_mensual'=>'',
							 'paga_prog_acum'=>'',
							 'paga_eje_mens'=>'',
							 'paga_eje_acum'=>'',
							 'paga_vari_abs_mens'=>'',
							 'paga_vari_abs_acum'=>'');
		$io_pdf->ezTable($la_data_tot,$la_columnas,'',$la_config);
	}// end function uf_print_pie_cabecera
	//--------------------------------------------------------------------------------------------------------------------------------
		require_once("../../../shared/ezpdf/class.ezpdf.php");
		
		require_once("../../../shared/class_folder/class_funciones.php");
		$io_funciones=new class_funciones();	
		require_once("sigesp_spg_funciones_reportes.php");
		$io_function_report=new sigesp_spg_funciones_reportes();	
		require_once("../../../shared/class_folder/class_fecha.php");
		$io_fecha = new class_fecha();
//-----------------------------------------------------------------------------------------------------------------------------
		global $la_data_tot;
		require_once("sigesp_spg_class_estado_eje_pre.php");
		$io_report = new sigesp_spg_class_reportes_instructivo_06();
		 
	//--------------------------------------------------  Parmetros para Filtar el Reporte  -----------------------------------------
		$ldt_periodo=$_SESSION["la_empresa"]["periodo"];
		$li_ano=substr($ldt_periodo,0,4);
		$li_estmodest=$_SESSION["la_empresa"]["estmodest"];

		$ls_cmbmes=$_GET["mes"];
		$ls_tipo=$_GET["tipo"];
		switch($ls_cmbmes)
		{
		 case '01': $ls_mes = "ENERO";
		 break;
		 
		 case '02': $ls_mes = "FEBRERO";
		 break;
		 
		 case '03': $ls_mes = "MARZO";
		 break;
		 
		 case '04': $ls_mes = "ABRIL";
		 break;
		 
		 case '05': $ls_mes = "MAYO";
		 break;
		 
		 case '06': $ls_mes = "JUNIO";
		 break;
		 
		 case '07': $ls_mes = "JULIO";
		 break;
		 
		 case '08': $ls_mes = "AGOSTO";
		 break;
		 
		 case '09': $ls_mes = "SEPTIEMBRE";
		 break;
		 
		 case '10': $ls_mes = "OCTUBRE";
		 break;
		 
		 case '11': $ls_mes = "NOVIEMBRE";
		 break;
		 
		 case '12': $ls_mes = "DICIEMBRE";
		 break;
		
		}
		$li_mesdes=substr($ls_cmbmes,0,2);
		$ldt_fecdes=$li_ano."-".$ls_cmbmes."-01";
		$li_meshas=substr($ls_cmbmes,2,2);
		$ldt_ult_dia=$io_fecha->uf_last_day($ls_cmbmes,$li_ano);
		$fechas=$ldt_ult_dia;
		$ldt_fechas=$io_funciones->uf_convertirdatetobd($fechas);	
		
//----------------------------------------------------  Parmetros del encabezado  ---------------------------------------------
		$ls_titulo=" ";       
//--------------------------------------------------------------------------------------------------------------------------------
   
     $lb_valido=$io_report->uf_spg_reporte_informacion_mensual_eje_pre($ldt_fecdes,$ldt_fechas,$ls_tipo);

	 if($lb_valido==false) // Existe algn error o no hay registros
	 {
		print("<script language=JavaScript>");
		print(" alert('No hay nada que Reportar');"); 
		print(" close();");
		print("</script>");
	 }
	 else // Imprimimos el reporte
	 {
	    error_reporting(E_ALL);
		set_time_limit(1800);
		$io_pdf=new Cezpdf('LEGAL','landscape'); // Instancia de la clase PDF
		$io_pdf->selectFont('../../../shared/ezpdf/fonts/Helvetica.afm'); // Seleccionamos el tipo de letra
		uf_print_encabezado_pagina($ls_titulo,"",$ls_mes,$ldt_fecdes,$ldt_fechas,$io_pdf); // Imprimimos el encabezado de la pgina
 	    $io_pdf->ezStartPageNumbers(970,425,10,'','',1); // Insertar el nmero de pgina
		$io_pdf->transaction('start'); // Iniciamos la transaccion
		$thisPageNum=$io_pdf->ezPageCount;
		$li_tot=$io_report->dts_reporte->getRowCount("codigo");
	    $ld_total_programado_mensual   = 0;
		$ld_total_modificaciones_aumento = 0;
		$ld_total_modificaciones_disminucion = 0;
		$ld_total_modificaciones_aum_acum = 0;
		$ld_total_modificaciones_dis_acum = 0;
		$ld_total_presupuesto_actualizado = 0;
		$ld_total_incre_deduc_mes = 0;
		$ld_total_incre_deduc_acum = 0;
		$ld_total_presupuesto_masmenos = 0;
		$ld_total_compromisos_mensual = 0;
		$ld_total_compromisos_acum = 0;
		$ld_total_pagos_mensual = 0;
		$ld_total_pagos_acum = 0;
		$ld_total_deuda_mensual = 0;
		$ld_total_deuda_acum = 0;
		$ld_total_reintegro_mensual = 0;
		$ld_total_reintegro_acum = 0;
		$ld_total_disponibilidad_presupuestaria = 0;
		$ls_mesdes = "";	
		$thisPageNum=$io_pdf->ezPageCount;
		$la_data='';
		for($z=1;$z<=$li_tot;$z++)
		{		
			
			$ls_codigo="";
			$ls_denominacion="";
			$ls_spg_cuenta = "";
	        $ls_partida="";
			$ls_generica="";
			$ls_especifica="";
			$ls_subesp="";
			$ls_status="";
			$ld_reintegro_mes   = 0;
			$ld_reintegro_acum  = 0;
			

				  $ls_codigo                 = trim($io_report->dts_reporte->data["codigo"][$z]);
				  $ls_spg_cuenta             = trim($io_report->dts_reporte->data["spg_cuenta"][$z]);
				  $arrResultado=$io_function_report->uf_get_spg_cuenta($ls_spg_cuenta,$ls_partida,$ls_generica,$ls_especifica,$ls_subesp);
				  $ls_status                 = trim($io_report->dts_reporte->data["status"][$z]);
//INICIO DETALLES REPORTE
//DETALLE CODIGO PRESUPUESTARIO
				  $ls_partida=$arrResultado['as_spg_partida'];
				  $ls_generica=$arrResultado['as_spg_generica'];
				  $ls_especifica=$arrResultado['as_spg_especifica'];
				  $ls_subesp=$arrResultado['as_spg_subesp'];
//DENOMINACION - ASIGNADO
				  $ls_denominacion           	= trim($io_report->dts_reporte->data["denominacion"][$z]);
				  $ls_asignado               	= trim($io_report->dts_reporte->data["asignado"][$z]);
//MODIFICACIONES PRESUPUESTARIAS -> AUMENTO - DISMINUCION (MENSUAL - ACUMULADO)
				  $ld_aumento_mensual        	= $io_report->dts_reporte->data["mod_pre_mes_aum"][$z];
				  $ld_disminucion_mensual    	= $io_report->dts_reporte->data["mod_pre_mes_dis"][$z];
				  $ld_aumento_mensual_acum      = $io_report->dts_reporte->data["mod_pre_acum_aum"][$z];
				  $ld_disminucion_mensual_acum 	= $io_report->dts_reporte->data["mod_pre_acum_dis"][$z];
//PRESUPUESTO ACTUALIZADO
				  $ld_presup_actualizado	= abs($ls_asignado+$ld_aumento_mensual_acum-$ld_disminucion_mensual_acum);
//INCREMENTO O DEDUCCIONES FONDOS DELEGADOS -> MENSUAL - ACUMULADO 
				  $ld_monto_mes		      	= $io_report->dts_reporte->data["monto_mes"][$z];
				  $ld_monto_acum	       	= $io_report->dts_reporte->data["monto_acum"][$z];
//TOTAL PRESUPUESTO MAS O MENOS
				  $ld_presup_masmenos		= abs($ld_presup_actualizado+$ld_monto_acum);
//COMPROMISOS -> MENSUAL - ACUMULADO
				  $ld_compromiso_mensual        = $io_report->dts_reporte->data["mod_pre_mes_com"][$z];
				  $ld_compromiso_acum        	= $io_report->dts_reporte->data["mod_pre_acum_com"][$z];
//PAGOS -> MENSUAL - ACUMULADO
				  $ld_pago_mensual    		= $io_report->dts_reporte->data["mod_pre_mes_pag"][$z];
				  $ld_pago_acum		     	= $io_report->dts_reporte->data["mod_pre_acum_pag"][$z];
//DEUDA -> MENSUAL - ACUMULADA
				  $ld_deuda_mes		       	= $ld_compromiso_mensual - $ld_pago_mensual;
				  $ld_deuda_acum	       	= $ld_compromiso_acum - $ld_pago_acum;
//DISPONIBILIDAD PRESUPUESTARIA
				  $ld_disp_presup  	     	= $ld_presup_masmenos-$ld_compromiso_acum;
//FIN DETALLES REPORTE
				  
//TOTALES GENERALES REPORTE
				   if ($ls_generica=='00' && $ls_especifica=='00' && $ls_subesp=='00')
				   	$ld_total_programado_mensual   = $ld_total_programado_mensual + $ls_asignado;
				   $ld_total_modificaciones_aumento = $ld_total_modificaciones_aumento + $ld_aumento_mensual;
				   $ld_total_modificaciones_disminucion = $ld_total_modificaciones_disminucion + $ld_disminucion_mensual;
				   $ld_total_modificaciones_aum_acum = $ld_total_modificaciones_aum_acum + $ld_aumento_mensual_acum;
				   $ld_total_modificaciones_dis_acum = $ld_total_modificaciones_dis_acum + $ld_disminucion_mensual_acum;
				   $ld_total_presupuesto_actualizado = $ld_total_programado_mensual + $ld_total_modificaciones_aum_acum - $ld_total_modificaciones_dis_acum;
				   $ld_total_incre_deduc_mes = $ld_total_incre_deduc_mes + $ld_monto_mes;
				   $ld_total_incre_deduc_acum = $ld_total_incre_deduc_acum + $ld_monto_acum;
				   $ld_total_presupuesto_masmenos = $ld_total_presupuesto_actualizado + $ld_total_incre_deduc_acum;
				   $ld_total_compromisos_mensual = $ld_total_compromisos_mensual + $ld_compromiso_mensual;
				   $ld_total_compromisos_acum = $ld_total_compromisos_acum + $ld_compromiso_acum;
				   $ld_total_pagos_mensual = $ld_total_pagos_mensual + $ld_pago_mensual;
				   $ld_total_pagos_acum = $ld_total_pagos_acum + $ld_pago_acum;
				   $ld_total_deuda_mensual = $ld_total_deuda_mensual + $ld_deuda_mes;
				   $ld_total_deuda_acum = $ld_total_deuda_acum + $ld_deuda_acum;
				   //LOS DOS SIGUIENTES RENGLONES NO SE CALCULAN POR FALTA DE USO 
				   $ld_total_reintegro_mensual = $ld_total_reintegro_mensual ;
				   $ld_total_reintegro_acum = $ld_total_reintegro_acum ;
				   $ld_total_disponibilidad_presupuestaria = $ld_total_presupuesto_masmenos - $ld_total_deuda_acum;
//FIN TOTALES GENERALES REPORTE

				  $ls_asignado		   = number_format($ls_asignado,2,",",".");
				  $ld_aumento_mensual	   = number_format($ld_aumento_mensual,2,",",".");
				  $ld_disminucion_mensual  = number_format($ld_disminucion_mensual,2,",",".");
				  $ld_aumento_mensual_acum = number_format($ld_aumento_mensual_acum,2,",",".");
				  $ld_disminucion_mensual_acum     = number_format($ld_disminucion_mensual_acum,2,",",".");
				  $ld_presup_actualizado   = number_format($ld_presup_actualizado,2,",",".");
				  $ld_monto_mes      	   = number_format($ld_monto_mes,2,",",".");
				  $ld_monto_acum      	   = number_format($ld_monto_acum,2,",",".");
				  $ld_presup_masmenos      = number_format($ld_presup_masmenos,2,",",".");
				  $ld_compromiso_mensual   = number_format($ld_compromiso_mensual,2,",",".");
				  $ld_compromiso_acum      = number_format($ld_compromiso_acum,2,",",".");
				  $ld_pago_mensual  	   = number_format($ld_pago_mensual,2,",",".");
				  $ld_pago_acum      	   = number_format($ld_pago_acum,2,",",".");
				  $ld_deuda_mes      	   = number_format($ld_deuda_mes,2,",",".");
				  $ld_deuda_acum      	   = number_format($ld_deuda_acum,2,",",".");
				  $ld_reintegro_mes    	   = number_format($ld_reintegro_mes,2,",",".");
				  $ld_reintegro_acum   	   = number_format($ld_reintegro_acum,2,",",".");
				  $ld_disp_presup      	   = number_format($ld_disp_presup,2,",",".");
				
				  $la_data[$z]=array('codigo'=>$ls_codigo,
									 'denominacion'=>$ls_denominacion,
									 'partida'=>$ls_partida,
									 'generica'=>$ls_generica,
									 'especifica'=>$ls_especifica,
									 'subespecifica'=>$ls_subesp,
									 'fuente'=>'',
									 'asignado'=>$ls_asignado,
									 'comp_aum_mensual'=>$ld_aumento_mensual,
									 'comp_dis_mensual'=>$ld_disminucion_mensual,
									 'comp_aum_acum'=>$ld_aumento_mensual_acum,
									 'comp_dis_acum'=>$ld_disminucion_mensual_acum,
									 'comp_presup_actualizado'=>$ld_presup_actualizado,
									 'monto_mes'=>$ld_monto_mes,
									 'monto_acum'=>$ld_monto_acum,
									 'masmenos'=>$ld_presup_masmenos,
									 'comp_mes'=>$ld_compromiso_mensual,
									 'comp_acum'=>$ld_compromiso_acum,
									 'caus_pago'=>$ld_pago_mensual,
									 'acum_pago'=>$ld_pago_acum,
									 'deuda_mes'=>$ld_deuda_mes,
									 'deuda_acum'=>$ld_deuda_acum,
									 'reintegro_mes'=>$ld_reintegro_mes,
									 'reintegro_acum'=>$ld_reintegro_acum,
									 'disponibilidad_presup'=>$ld_disp_presup);
					  							 						   
			}//for
			  $ld_total_programado_mensual   = number_format($ld_total_programado_mensual,2,",",".");
			  $ld_total_modificaciones_aumento = number_format($ld_total_modificaciones_aumento,2,",",".");
			  $ld_total_modificaciones_disminucion = number_format($ld_total_modificaciones_disminucion,2,",",".");
			  $ld_total_modificaciones_aum_acum = number_format($ld_total_modificaciones_aum_acum,2,",",".");
			  $ld_total_modificaciones_dis_acum = number_format($ld_total_modificaciones_dis_acum,2,",",".");
			  $ld_total_presupuesto_actualizado   = number_format($ld_total_presupuesto_actualizado,2,",",".");
			  $ld_total_incre_deduc_mes   = number_format($ld_total_incre_deduc_mes,2,",",".");
			  $ld_total_incre_deduc_acum   = number_format($ld_total_incre_deduc_acum,2,",",".");
			  $ld_total_presupuesto_masmenos   = number_format($ld_total_presupuesto_masmenos,2,",",".");
			  $ld_total_compromisos_mensual   = number_format($ld_total_compromisos_mensual,2,",",".");
			  $ld_total_compromisos_acum   = number_format($ld_total_compromisos_acum,2,",",".");
			  $ld_total_pagos_mensual   = number_format($ld_total_pagos_mensual,2,",",".");
			  $ld_total_pagos_acum   = number_format($ld_total_pagos_acum,2,",",".");
			  $ld_total_deuda_mensual   = number_format($ld_total_deuda_mensual,2,",",".");
			  $ld_total_deuda_acum   = number_format($ld_total_deuda_acum,2,",",".");
			  $ld_total_reintegro_mensual   = number_format($ld_total_reintegro_mensual,2,",",".");
			  $ld_total_reintegro_acum   = number_format($ld_total_reintegro_acum,2,",",".");
			  $ld_total_disponibilidad_presupuestaria = number_format($ld_total_disponibilidad_presupuestaria,2,",",".");
			
			$la_data_tot[1]=array(	 'totales'=>"TOTALES",
								  	 'comp_prog_mensual'=>$ld_total_programado_mensual,
									 'comp_prog_acum'=>$ld_total_modificaciones_aumento,
									 'comp_eje_mens'=>$ld_total_modificaciones_disminucion,
									 'comp_eje_acum'=>$ld_total_modificaciones_aum_acum,
									 'comp_vari_abs_mens'=>$ld_total_modificaciones_dis_acum,
									 'comp_vari_abs_acum'=>$ld_total_presupuesto_actualizado,
									 'caus_prog_mensual'=>$ld_total_incre_deduc_mes,
									 'caus_prog_acum'=>$ld_total_incre_deduc_acum,
									 'caus_eje_mens'=>$ld_total_presupuesto_masmenos,
									 'caus_eje_acum'=>$ld_total_compromisos_mensual,
									 'caus_vari_abs_mens'=>$ld_total_compromisos_acum,
									 'caus_vari_abs_acum'=>$ld_total_pagos_mensual,
									 'paga_prog_mensual'=>$ld_total_pagos_acum,
									 'paga_prog_acum'=>$ld_total_deuda_mensual,
									 'paga_eje_mens'=>$ld_total_deuda_acum,
									 'paga_eje_acum'=>$ld_total_reintegro_mensual,
									 'paga_vari_abs_mens'=>$ld_total_reintegro_acum,
									 'paga_vari_abs_acum'=>$ld_total_disponibilidad_presupuestaria);

            $io_encabezado=$io_pdf->openObject();
			uf_print_titulo_reporte($io_encabezado,"",$li_ano,$ls_mes,"",$ld_total_compromisos_acum,$io_pdf);
			$io_pdf->ezSetCmMargins(8.1,3,3,3);
			if(count($la_data)>0)
			{
				uf_print_detalle($la_data,$io_pdf); // Imprimimos el detalle 
				uf_print_pie_cabecera($la_data_tot,$io_pdf);
			}
			unset($la_data);
			unset($la_data_tot);		
		$io_pdf->ezStopPageNumbers(1,1);
		if (isset($d) && $d)
		{
			$ls_pdfcode = $io_pdf->ezOutput(1);
			$ls_pdfcode = str_replace("\n","\n<br>",htmlspecialchars($ls_pdfcode));
			echo '<html><body>';
			echo trim($ls_pdfcode);
			echo '</body></html>';
		}
		else
			
		{
			$io_pdf->ezStream();
		}
		unset($io_pdf);
	}//else
	unset($io_report);
	unset($io_funciones);
?> 
