<?php
    session_start();   
	header("Pragma: public");
	header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
	header("Cache-Control: private",false);
	if(!array_key_exists("la_logusr",$_SESSION))
	{
		print "<script language=JavaScript>";
		print "close();";
		print "</script>";		
	}
	//--------------------------------------------------------------------------------------------------------------------------------
	function uf_print_encabezado_pagina($as_titulo,$as_moneda,$as_trimestre,$ldt_fecdes,$ldt_fechas,$io_pdf)
	{
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_encabezadopagina
		//		    Acess: private 
		//	    Arguments: as_titulo // Ttulo del Reporte
		//                 $as_moneda // Moneda
		//	    		   as_trimestre // Nro. del Trimestre
		//	    		   io_pdf // Instancia de objeto pdf
		//    Description: funcion que imprime los encabezados por pgina
		//	   Creado Por: Ing. Arnaldo Surez
		// Fecha Creacion: 29/10/2008
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
		$io_encabezado=$io_pdf->openObject();
		$io_pdf->saveState();
		$io_pdf->addText(20,560,7,"<b>REPBLICA BOLIVARIANA DE VENEZUELA<b>");
		$io_pdf->addJpegFromFile('../../../shared/imagebank/'.$_SESSION["ls_logo"],25,500,$_SESSION["ls_width"],$_SESSION["ls_height"]); // Agregar Logo
		$io_pdf->line(9,415,1000,415); // Linea SUBPARTIDA, COMPROMISO, CAUSADO Y PAGADO
		$io_pdf->line(35,380,35,400);  // Linea entre Denominacion y Partida
		$io_pdf->line(55,380,55,400);  // Partida
		$io_pdf->line(75,380,75,400);  // Generica
		$io_pdf->line(110,380,110,400);  // Especfica
		$io_pdf->line(120,380,120,415);  // SubEspecfica
		$io_pdf->line(285,380,285,415);  // linea derecha Denominacion
		$io_pdf->line(405,380,405,415);  // Linea derecha Asignacion inicial anual
		$io_pdf->line(540,380,540,415);  // Linea derecha fondos recibidos en el mes
		$io_pdf->line(670,380,670,415);  // Linea derecha Saldo actual o acumulado
		$io_pdf->line(712,380,712,395);  // Linea pagos mes - acum
		$io_pdf->line(755,380,755,415);  // Linea derecha Pagos
		$io_pdf->line(800,380,800,395);  // Linea Reintegros mes planilla - monto
		$io_pdf->line(845,380,845,404);  // Linea derecha Reintegros MES
		$io_pdf->line(900,380,900,415);  // Pagado Ejecutado Acumulado Mensual
		
		$io_pdf->addText(20,440,7,"<b>1.-PROGRAMA:<b>");
		$io_pdf->line(75,440,240,440);  // Lnea programa
		$io_pdf->addText(250,440,7,"<b>2.-ORDENES DE PAGO:<b>");
		$io_pdf->line(330,440,440,440);  // Lnea rdenes de pago
		$io_pdf->addText(450,440,7,"<b>3.-FECHA:<b>");
		$io_pdf->addText(510,442,7,substr($ldt_fecdes,8,2));
		$io_pdf->addText(550,442,7,substr($ldt_fecdes,5,2));
		$io_pdf->addText(590,442,7,substr($ldt_fecdes,0,4));
		$io_pdf->addText(635,442,7,substr($ldt_fechas,8,2));
		$io_pdf->addText(675,442,7,substr($ldt_fechas,5,2));
		$io_pdf->addText(715,442,7,substr($ldt_fechas,0,4));
		$io_pdf->addText(540,430,7,"DESDE                                                    HASTA");
		$io_pdf->line(490,440,740,440);  // Recuadro fecha
		$io_pdf->line(490,440,490,460);  // Recuadro fecha
		$io_pdf->line(532,440,532,460);  // Recuadro fecha
		$io_pdf->line(574,440,574,460);  // Recuadro fecha
		$io_pdf->line(615,440,615,460);  // Recuadro fecha
		$io_pdf->line(657,440,657,460);  // Recuadro fecha
		$io_pdf->line(699,440,699,460);  // Recuadro fecha
		$io_pdf->line(740,440,740,460);  // Recuadro fecha
		$io_pdf->addText(60,420,7,"<b>BANCO:<b>");
		$io_pdf->line(90,420,400,420);  // Lnea nombre banco
		$io_pdf->addText(420,420,7,"<b>No. CTA. CTE.:<b>");
		$io_pdf->line(475,420,740,420);  // Lnea nmero cuenta
		$io_pdf->addText(860,420,7,"<b>HOJA No<b>");
		$io_pdf->line(895,420,990,420);  // Lnea nmero hoja
		$io_pdf->addText(20,405,7,"CODIGO PRESUPUESTARIO");
		$io_pdf->line(9,400,120,400); // Linea cdigo presupuestario inferior
		$io_pdf->addText(15,390,6,"PART");
		$io_pdf->addText(40,390,6,"GEN");
		$io_pdf->addText(60,390,6,"ESP");
		$io_pdf->addText(80,390,6,"SUB-ESP");
		$io_pdf->addText(162,395,7,"5.-DENOMINACION");
		// INGRESOS
		$io_pdf->addText(295,395,7,"6.-ASIGNACIN INICIAL ANUAL");
		$io_pdf->addText(415,395,7,"7.-FONDOS RECIBIDOS EN EL MES");
		$io_pdf->addText(550,395,7,"8.-SALDO ACTUAL O ACUMULADO");
		// PAGADO
		$io_pdf->addText(692,400,7,"9.-PAGOS");
		$io_pdf->line(670,395,755,395); // Linea Pagos inferior
		$io_pdf->addText(678,388,6,"9.1.-MES");
		$io_pdf->addText(718,388,6,"9.2.-ACUM.");
		//REINTEGROS
		$io_pdf->addText(805,408,6,"10.-REINTEGROS");
		$io_pdf->line(755,404,900,404); // Linea Reintegro inferior
		$io_pdf->addText(792,398,6,"MES");
		$io_pdf->line(755,395,845,395); // Linea Reintegro inferior
		$io_pdf->addText(760,388,5,"No. PLANILLA");
		$io_pdf->addText(805,388,5,"10.1.-MONTO");
		$io_pdf->addText(845,390,6,"10.2.-ACUMULADO");
		$io_pdf->addText(902,395,6,"11.-DISPONIBILIDAD DEL FONDO");
		$io_pdf->rectangle(8,382,992,79);
		
		$li_tm=$io_pdf->getTextWidth(16,$as_titulo);
		$tm=505-($li_tm/2);
		$io_pdf->addText($tm,500,16,$as_titulo); // Agregar el ttulo
		
		$li_tm=$io_pdf->getTextWidth(16,$as_moneda);
		$tm=490-($li_tm/2);
		$io_pdf->addText($tm,485,10,$as_moneda); // Agregar el ttulo
		
		$io_pdf->restoreState();
		$io_pdf->closeObject();
		$io_pdf->addObject($io_encabezado,'all');
		
	}// end function uf_print_encabezadopagina
	//--------------------------------------------------------------------------------------------------------------------------------
	
	//--------------------------------------------------------------------------------------------------------------------------------
	function uf_print_titulo_reporte($io_encabezado,$as_programatica,$ai_ano,$as_mes,$as_denestpro,$ld_total_pagos_mensual,$io_pdf)
	{
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_encabezadopagina
		//		    Acess: private 
		//	    Arguments: as_titulo // Ttulo del Reporte
		//	    		   as_periodo_comp // Descripcion del periodo del comprobante
		//	    		   as_fecha_comp // Descripcion del Periodo de la fecha del comprobante 
		//	    		   io_pdf // Instancia de objeto pdf
		//    Description: funcion que imprime los encabezados por pgina
		//	   Creado Por: Ing. Arnaldo Surez
		// Fecha Creacion: 14/10/2008 
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
		$io_pdf->addText(750,440,7,"<b>4.-MONTO DE LA(S) ORDEN(ES) DE PAGO:<b>                 ".$ld_total_pagos_mensual);
		$io_pdf->line(895,438,990,438);  // Lnea monto
		$io_pdf->saveState();
		$io_pdf->ezSetY(570);
		$ls_codemp=$_SESSION["la_empresa"]["codemp"];
		$ls_nombre=$_SESSION["la_empresa"]["nombre"];
		$ls_nomorgads=$_SESSION["la_empresa"]["nomorgads"];
		$ls_codasiona   = $_SESSION['la_empresa']['codasiona'];
		
		$la_data=array(array('name'=>'<b>DEPENDENCIA U ORGANISMO  (   </b>'.'<b>'.$ls_codasiona.' - '.$ls_nombre.'</b>)'),
				array('name'=>'                               <b>ESTADO DE LA EJECUCIN FINANCIERA</b>'),
					   array('name'=>'                               <b>MES RENDIDO:    </b>'.'<b>'.$as_mes."                    AO: ".$ai_ano.'</b>'));
		$la_columna=array('name'=>'','name'=>'','name'=>'');
		$la_config =array('showHeadings'=>0,     // Mostrar encabezados
						 'fontSize' => 12,       // Tamao de Letras
						 'titleFontSize' => 12, // Tamao de Letras de los ttulos
						 'showLines'=>0,        // Mostrar Lneas
						 'shaded'=>0,           // Sombra entre lneas
						 'xPos'=>665,//65
						 'shadeCol2'=>array(0.9,0.9,0.9), // Color de la sombra
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'width'=>900, // Ancho de la tabla
						 'maxWidth'=>900);
		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);
		$io_pdf->restoreState();
		$io_pdf->closeObject();
		$io_pdf->addObject($io_encabezado,'all');
		
	}// end function uf_print_encabezadopagina
	//--------------------------------------------------------------------------------------------------------------------------------

	//--------------------------------------------------------------------------------------------------------------------------------
	function uf_print_detalle($la_data,$io_pdf)
	{
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_detalle
		//		    Acess: private 
		//	    Arguments: la_data // arreglo de informacion
		//	   			   io_pdf // Objeto PDF
		//    Description: funcion que imprime el detalle
		//	   Creado Por: Ing. Arnaldo Surez
		// Fecha Creacion: 28/10/2006 
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
		
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 5, // Tamao de Letras
						 'titleFontSize' => 7,  // Tamao de Letras de los ttulos
						 'showLines'=>2, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'colGap'=>0, // separacion entre tablas
						 'width'=>989, // Ancho de la tabla
						 'maxWidth'=>989, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array(	 'partida'=>array('justification'=>'center','width'=>26),
										 'generica'=>array('justification'=>'center','width'=>20),
										 'especifica'=>array('justification'=>'center','width'=>20),
										 'subespecifica'=>array('justification'=>'center','width'=>35),
										 'fuente'=>array('justification'=>'center','width'=>10),
										 'denominacion'=>array('justification'=>'left','width'=>165),
										 'asignado'=>array('justification'=>'right','width'=>120),
										 'fondos_mes'=>array('justification'=>'right','width'=>135),
										 'comp_presup_actualizado'=>array('justification'=>'right','width'=>130),
										 'caus_pago'=>array('justification'=>'right','width'=>42),
										 'acum_pago'=>array('justification'=>'right','width'=>43),
										 'planilla'=>array('justification'=>'right','width'=>45),
										 'reintegro_mes'=>array('justification'=>'right','width'=>45),
										 'reintegro_acum'=>array('justification'=>'right','width'=>55),
										 'disponibilidad_presup'=>array('justification'=>'right','width'=>99))); // Justificacion y ancho de la columna
										 
		$la_columnas=array(  'partida'=>'',
							 'generica'=>'',
							 'especifica'=>'',
							 'subespecifica'=>'',
							 'fuente'=>'',
							 'denominacion'=>'',
							 'asignado'=>'',
							 'fondos_mes'=>'',
							 'comp_presup_actualizado'=>'',
							 'caus_pago'=>'',
							 'acum_pago'=>'',
							 'planilla'=>'',
							 'reintegro_mes'=>'',
							 'reintegro_acum'=>'',
							 'disponibilidad_presup'=>'');
		$io_pdf->ezTable($la_data,$la_columnas,'',$la_config);
	}// end function uf_print_detalle
	//--------------------------------------------------------------------------------------------------------------------------------

	//--------------------------------------------------------------------------------------------------------------------------------
	function uf_print_pie_cabecera($la_data_tot,$io_pdf)
	{
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function : uf_print_pie_cabecera
		//		    Acess : private 
		//	    Arguments : ad_total // Total General
		//    Description : funcion que imprime el fin de la cabecera de cada pgina
		//	   Creado Por: Ing. Arnaldo USrez
		// Fecha Creacion: 10/06/2008 
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 5, // Tamao de Letras
						 'titleFontSize' => 7,  // Tamao de Letras de los ttulos
						 'showLines'=>2, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'colGap'=>0, // separacion entre tablas
						 'width'=>990, // Ancho de la tabla
						 'maxWidth'=>990, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array(  'totales'=>array('justification'=>'center','width'=>276), // Justificacion y ancho de la columna
						 			     'comp_prog_mensual'=>array('justification'=>'right','width'=>120),
										 'comp_prog_acum'=>array('justification'=>'right','width'=>135),
										 'comp_vari_abs_acum'=>array('justification'=>'right','width'=>130),
										 'caus_vari_abs_acum'=>array('justification'=>'right','width'=>42),
										 'paga_prog_mensual'=>array('justification'=>'right','width'=>43),
										 'planilla'=>array('justification'=>'right','width'=>45),
										 'paga_eje_acum'=>array('justification'=>'right','width'=>45),
										 'paga_vari_abs_mens'=>array('justification'=>'right','width'=>55),
										 'paga_vari_abs_acum'=>array('justification'=>'right','width'=>99)));
		$la_columnas=array(  'totales'=>'',
						   	 'comp_prog_mensual'=>'',
							 'comp_prog_acum'=>'',
							 'comp_vari_abs_acum'=>'',
							 'caus_vari_abs_acum'=>'',
							 'paga_prog_mensual'=>'',
							 'planilla'=>'',
							 'paga_eje_acum'=>'',
							 'paga_vari_abs_mens'=>'',
							 'paga_vari_abs_acum'=>'');
		$io_pdf->ezTable($la_data_tot,$la_columnas,'',$la_config);
		//RECTANGULO OBSERVACIONES, FIRMAS Y SELLOS
		$io_pdf->rectangle(8,82,992,79);
		$io_pdf->addText(12,150,6,"<b>OBSERVACIONES:</b>");
		$io_pdf->line(500,82,500,161);  // Linea derecha observaciones
		$io_pdf->addText(512,150,6,"<b>ELABORACIN:</b>");
		$io_pdf->addText(512,140,6,"<b>NOMBRES Y APELLIDOS:</b>");
		$io_pdf->line(655,95,795,95); // Linea firma y sello elaboracin
		$io_pdf->addText(700,88,6,"<b>FIRMA Y SELLO:</b>");
		$io_pdf->line(800,82,800,161);  // Linea derecha elaboracin
		$io_pdf->addText(812,150,6,"<b>CUENTADANTE:</b>");
		$io_pdf->addText(812,140,6,"<b>NOMBRES Y APELLIDOS:</b>");
		$io_pdf->line(890,95,995,95); // Linea firma y sello cuentadante
		$io_pdf->addText(920,88,6,"<b>FIRMA Y SELLO:</b>");
		//FIN RECTANGULO OBSERVACIONES, FIRMAS Y SELLOS
	}// end function uf_print_pie_cabecera
	//--------------------------------------------------------------------------------------------------------------------------------
		require_once("../../../shared/ezpdf/class.ezpdf.php");
		
		require_once("../../../shared/class_folder/class_funciones.php");
		$io_funciones=new class_funciones();	
		require_once("sigesp_spg_funciones_reportes.php");
		$io_function_report=new sigesp_spg_funciones_reportes();	
		require_once("../../../shared/class_folder/class_fecha.php");
		$io_fecha = new class_fecha();
//-----------------------------------------------------------------------------------------------------------------------------
		global $la_data_tot;
		require_once("sigesp_spg_class_estado_eje_pre.php");
		$io_report = new sigesp_spg_class_reportes_instructivo_06();
		 
	//--------------------------------------------------  Parmetros para Filtar el Reporte  -----------------------------------------
		$ldt_periodo=$_SESSION["la_empresa"]["periodo"];
		$li_ano=substr($ldt_periodo,0,4);
		$li_estmodest=$_SESSION["la_empresa"]["estmodest"];

		$ls_cmbmes=$_GET["mes"];
		$ls_tipo=$_GET["tipo"];
		switch($ls_cmbmes)
		{
		 case '01': $ls_mes = "ENERO";
		 break;
		 
		 case '02': $ls_mes = "FEBRERO";
		 break;
		 
		 case '03': $ls_mes = "MARZO";
		 break;
		 
		 case '04': $ls_mes = "ABRIL";
		 break;
		 
		 case '05': $ls_mes = "MAYO";
		 break;
		 
		 case '06': $ls_mes = "JUNIO";
		 break;
		 
		 case '07': $ls_mes = "JULIO";
		 break;
		 
		 case '08': $ls_mes = "AGOSTO";
		 break;
		 
		 case '09': $ls_mes = "SEPTIEMBRE";
		 break;
		 
		 case '10': $ls_mes = "OCTUBRE";
		 break;
		 
		 case '11': $ls_mes = "NOVIEMBRE";
		 break;
		 
		 case '12': $ls_mes = "DICIEMBRE";
		 break;
		
		}
		$li_mesdes=substr($ls_cmbmes,0,2);
		$ldt_fecdes=$li_ano."-".$ls_cmbmes."-01";
		$li_meshas=substr($ls_cmbmes,2,2);
		$ldt_ult_dia=$io_fecha->uf_last_day($ls_cmbmes,$li_ano);
		$fechas=$ldt_ult_dia;
		$ldt_fechas=$io_funciones->uf_convertirdatetobd($fechas);	
		
//----------------------------------------------------  Parmetros del encabezado  ---------------------------------------------
		$ls_titulo=" ";       
//--------------------------------------------------------------------------------------------------------------------------------
   
     $lb_valido=$io_report->uf_spg_reporte_informacion_mensual_eje_pre($ldt_fecdes,$ldt_fechas,$ls_tipo);

	 if($lb_valido==false) // Existe algn error o no hay registros
	 {
		print("<script language=JavaScript>");
		print(" alert('No hay nada que Reportar');"); 
		print(" close();");
		print("</script>");
	 }
	 else // Imprimimos el reporte
	 {
	    error_reporting(E_ALL);
		set_time_limit(1800);
		$io_pdf=new Cezpdf('LEGAL','landscape'); // Instancia de la clase PDF
		$io_pdf->selectFont('../../../shared/ezpdf/fonts/Helvetica.afm'); // Seleccionamos el tipo de letra
		uf_print_encabezado_pagina($ls_titulo,"",$ls_mes,$ldt_fecdes,$ldt_fechas,$io_pdf); // Imprimimos el encabezado de la pgina
 	    $io_pdf->ezStartPageNumbers(970,425,10,'','',1); // Insertar el nmero de pgina
		$io_pdf->transaction('start'); // Iniciamos la transaccion
		$thisPageNum=$io_pdf->ezPageCount;
		$li_tot=$io_report->dts_reporte->getRowCount("codigo");
	    	$ld_total_programado_mensual   = 0;
		$ld_total_modificaciones_aumento = 0;
		$ld_total_presupuesto_actualizado = 0;
		$ld_total_pagos_mensual = 0;
		$ld_total_pagos_acum = 0;
		$ld_total_reintegro_mensual = 0;
		$ld_planilla='';
		$ld_total_reintegro_acum = 0;
		$ld_total_disponibilidad_presupuestaria = 0;
		$ls_mesdes = "";	
		$thisPageNum=$io_pdf->ezPageCount;
		$la_data='';
		for($z=1;$z<=$li_tot;$z++)
		{		
			
			$ls_codigo="";
			$ls_spg_cuenta = "";
			$ls_status="";
	        	$ls_partida="";
			$ls_generica="";
			$ls_especifica="";
			$ls_subesp="";
			$ls_denominacion="";
			$ld_reintegro_mes   = 0;
			$ld_reintegro_acum  = 0;
			

				  $ls_codigo                 = trim($io_report->dts_reporte->data["codigo"][$z]);
				  $ls_spg_cuenta             = trim($io_report->dts_reporte->data["spg_cuenta"][$z]);
				  $arrResultado=$io_function_report->uf_get_spg_cuenta($ls_spg_cuenta,$ls_partida,$ls_generica,$ls_especifica,$ls_subesp);
				  $ls_status                 = trim($io_report->dts_reporte->data["status"][$z]);
//INICIO DETALLES REPORTE
//DETALLE CODIGO PRESUPUESTARIO
				  $ls_partida=$arrResultado['as_spg_partida'];
				  $ls_generica=$arrResultado['as_spg_generica'];
				  $ls_especifica=$arrResultado['as_spg_especifica'];
				  $ls_subesp=$arrResultado['as_spg_subesp'];
//DENOMINACION - ASIGNADO INICIAL
				  $ls_denominacion           	= trim($io_report->dts_reporte->data["denominacion"][$z]);
				  $ls_asignado               	= trim($io_report->dts_reporte->data["asignado"][$z]);
//MODIFICACIONES PRESUPUESTARIAS -> AUMENTO MENSUAL
				  $ld_aumento_mensual        	= $io_report->dts_reporte->data["mod_pre_mes_aum"][$z];
//FONDOS RECIBIDOS EN EL MES
				  $ld_fondos_mes		= abs($ld_aumento_mensual);
//INCREMENTO O DEDUCCIONES FONDOS DELEGADOS -> MENSUAL - ACUMULADO 
				  $ld_monto_acum	       	= $io_report->dts_reporte->data["monto_acum"][$z];
//SALDO ACTUAL O ACUMULADO
				  $ld_presup_actualizado	= abs($ls_asignado+$ld_monto_acum);
//PAGOS -> MENSUAL - ACUMULADO
				  $ld_pago_mensual    		= $io_report->dts_reporte->data["mod_pre_mes_pag"][$z];
				  $ld_pago_acum		     	= $io_report->dts_reporte->data["mod_pre_acum_pag"][$z];
//COMPROMISOS -> ACUMULADO
				  $ld_compromiso_acum        	= $io_report->dts_reporte->data["mod_pre_acum_com"][$z];
//DISPONIBILIDAD PRESUPUESTARIA
				  $ld_disp_presup  	     	= $ld_presup_actualizado-$ld_compromiso_acum;
//FIN DETALLES REPORTE
				  
//TOTALES GENERALES REPORTE
				   if ($ls_generica=='00' && $ls_especifica=='00' && $ls_subesp=='00')
				   	$ld_total_programado_mensual   = $ld_total_programado_mensual + $ls_asignado;
				   $ld_total_modificaciones_aumento = $ld_total_modificaciones_aumento + $ld_fondos_mes;
				   $ld_total_presupuesto_actualizado = $ld_total_programado_mensual + $ld_total_modificaciones_aumento;
				   $ld_total_pagos_mensual = $ld_total_pagos_mensual + $ld_pago_mensual;
				   $ld_total_pagos_acum = $ld_total_pagos_acum + $ld_pago_acum;
				   //LOS DOS SIGUIENTES RENGLONES NO SE CALCULAN POR FALTA DE USO 
				   $ld_total_reintegro_mensual = $ld_total_reintegro_mensual ;
				   $ld_total_reintegro_acum = $ld_total_reintegro_acum ;
				   $ld_total_disponibilidad_presupuestaria = $ld_total_presupuesto_actualizado - $ld_total_pagos_acum;
//FIN TOTALES GENERALES REPORTE

				  $ls_asignado		   = number_format($ls_asignado,2,",",".");
				  $ld_fondos_mes      	   = number_format($ld_fondos_mes,2,",",".");
				  $ld_presup_actualizado   = number_format($ld_presup_actualizado,2,",",".");
				  $ld_pago_mensual  	   = number_format($ld_pago_mensual,2,",",".");
				  $ld_pago_acum      	   = number_format($ld_pago_acum,2,",",".");
				  $ld_reintegro_mes    	   = number_format($ld_reintegro_mes,2,",",".");
				  $ld_reintegro_acum   	   = number_format($ld_reintegro_acum,2,",",".");
				  $ld_disp_presup      	   = number_format($ld_disp_presup,2,",",".");
				
				  $la_data[$z]=array('codigo'=>$ls_codigo,
									 'denominacion'=>$ls_denominacion,
									 'partida'=>$ls_partida,
									 'generica'=>$ls_generica,
									 'especifica'=>$ls_especifica,
									 'subespecifica'=>$ls_subesp,
									 'fuente'=>'',
									 'asignado'=>$ls_asignado,
									 'fondos_mes'=>$ld_fondos_mes,
									 'comp_presup_actualizado'=>$ld_presup_actualizado,
									 'caus_pago'=>$ld_pago_mensual,
									 'acum_pago'=>$ld_pago_acum,
									 'planilla'=>$ld_planilla,
									 'reintegro_mes'=>$ld_reintegro_mes,
									 'reintegro_acum'=>$ld_reintegro_acum,
									 'disponibilidad_presup'=>$ld_disp_presup);
					  							 						   
			}//for
			  $ld_total_programado_mensual   = number_format($ld_total_programado_mensual,2,",",".");
			  $ld_total_modificaciones_aumento = number_format($ld_total_modificaciones_aumento,2,",",".");
			  $ld_total_presupuesto_actualizado   = number_format($ld_total_presupuesto_actualizado,2,",",".");
			  $ld_total_pagos_mensual   = number_format($ld_total_pagos_mensual,2,",",".");
			  $ld_total_pagos_acum   = number_format($ld_total_pagos_acum,2,",",".");
			  $ld_total_reintegro_mensual   = number_format($ld_total_reintegro_mensual,2,",",".");
			  $ld_total_reintegro_acum   = number_format($ld_total_reintegro_acum,2,",",".");
			  $ld_total_disponibilidad_presupuestaria = number_format($ld_total_disponibilidad_presupuestaria,2,",",".");
			
			$la_data_tot[1]=array(	 'totales'=>"TOTALES",
								  	 'comp_prog_mensual'=>$ld_total_programado_mensual,
									 'comp_prog_acum'=>$ld_total_modificaciones_aumento,
									 'comp_vari_abs_acum'=>$ld_total_presupuesto_actualizado,
									 'caus_vari_abs_acum'=>$ld_total_pagos_mensual,
									 'paga_prog_mensual'=>$ld_total_pagos_acum,
									 'planilla'=>$ld_planilla,
									 'paga_eje_acum'=>$ld_total_reintegro_mensual,
									 'paga_vari_abs_mens'=>$ld_total_reintegro_acum,
									 'paga_vari_abs_acum'=>$ld_total_disponibilidad_presupuestaria);

            $io_encabezado=$io_pdf->openObject();
			uf_print_titulo_reporte($io_encabezado,"",$li_ano,$ls_mes,"",$ld_total_pagos_mensual,$io_pdf);
			$io_pdf->ezSetCmMargins(8.1,3,3,3);
			if(count($la_data)>0)
			{
				uf_print_detalle($la_data,$io_pdf); // Imprimimos el detalle 
				uf_print_pie_cabecera($la_data_tot,$io_pdf);
			}
			unset($la_data);
			unset($la_data_tot);		
		$io_pdf->ezStopPageNumbers(1,1);
		if (isset($d) && $d)
		{
			$ls_pdfcode = $io_pdf->ezOutput(1);
			$ls_pdfcode = str_replace("\n","\n<br>",htmlspecialchars($ls_pdfcode));
			echo '<html><body>';
			echo trim($ls_pdfcode);
			echo '</body></html>';
		}
		else
			
		{
			$io_pdf->ezStream();
		}
		unset($io_pdf);
	}//else
	unset($io_report);
	unset($io_funciones);
?> 
