<?php
    session_start();
	header("Pragma: public");
	header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
	header("Cache-Control: private",false);
	if(!array_key_exists("la_logusr",$_SESSION))
	{
		print "<script language=JavaScript>";
		print "close();";
		print "</script>";		
	}
//--------------------------------------------------------------------------------------------------------------------------------
	function uf_print_encabezado_pagina($as_titulo,$io_pdf)
	{
	////////////////////////////////////////////////////////////////////////////////////////////////////////
	//       Function: uf_print_encabezadopagina
	//		    Acess: private
	//	    Arguments: as_titulo // Ttulo del Reporte
	//	    		   as_periodo_comp // Descripcion del periodo del comprobante
	//	    		   as_fecha_comp // Descripcion del Periodo de la fecha del comprobante
	//	    		   io_pdf // Instancia de objeto pdf
	//    Description: funcion que imprime los encabezados por pgina
	//	   Creado Por: Ing.Yozelin Barragn
	// Fecha Creacion: 12/09/2006
	////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
	$io_encabezado=$io_pdf->openObject();
	$io_pdf->saveState();
	$io_pdf->line(10,30,1000,30);
	// Agregar Logo
	$io_pdf->addJpegFromFile('../../../shared/imagebank/'.$_SESSION["ls_logo"],10,530,$_SESSION["ls_width"],$_SESSION["ls_height"]);    
	$li_tm=$io_pdf->getTextWidth(12,$as_titulo);
	$tm=505-($li_tm/2);
	$io_pdf->addText($tm,550,12,$as_titulo); // Agregar el ttulo
	$io_pdf->addText(900,560,10,$_SESSION["ls_database"]);// Agrerar el nombre de la base de datos actual
	$io_pdf->addText(900,550,10,date("d/m/Y")); // Agregar la Fecha
	$io_pdf->addText(900,540,10,date("h:i a")); // Agregar la hora
	$io_pdf->restoreState();
	$io_pdf->closeObject();
	$io_pdf->addObject($io_encabezado,'all');
	}// end function uf_print_encabezadopagina
	//--------------------------------------------------------------------------------------------------------------------------------

	//--------------------------------------------------------------------------------------------------------------------------------
	function uf_print_cabecera($io_cabecera,$as_programatica,$as_denestpro,$io_pdf)
	{
		////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_cabecera
		//		   Access: privates
		//	    Arguments: as_programatica // programatica del comprobante
		//	    		   as_denestpro5 // denominacion de la programatica del comprobante
		//	    		   io_pdf // Objeto PDF
		//    Description: funcion que imprime la cabecera de cada pgina
		//	   Creado Por: Ing.Yozelin Barragn
	    // Fecha Creacion: 12/09/2006
		/////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
		$io_pdf->saveState();
		$io_pdf->ezSetY(540);
		if ($_SESSION["la_empresa"]["estmodest"] == 2)
		{
			$la_data=array(array('name'=>'<b>Programatica</b> '.$as_programatica.''),
						   array('name'=>'<b></b>'.$as_denestpro.''));
			$la_columna=array('name'=>'');
			$la_config=array('showHeadings'=>0, // Mostrar encabezados
							 'fontSize' => 7, // Tamao de Letras
							 'showLines'=>0, // Mostrar Lneas
							 'shaded'=>0, // Sombra entre lneas
							 'shadeCol'=>array(0.9,0.9,0.9),
							 'shadeCo2'=>array(0.9,0.9,0.9),
							 //'textCol' =>array(0.1,0.1,0.1) , // color del texto
							 'colGap'=>0.5, // separacion entre tablas
							 'xOrientation'=>'center', // Orientacion de la tabla
							 'xPos'=>280, // Orientacion de la tabla
							 'width'=>850, // Ancho de la tabla
							 'maxWidth'=>850); // Ancho Mximo de la tabla
			$io_pdf->ezTable($la_data,$la_columna,'',$la_config);
			$io_pdf->restoreState();
			$io_pdf->closeObject();
			$io_pdf->addObject($io_cabecera,'all');					 			
		}
		else
		{
			 $ls_loncodestpro1 = $_SESSION["la_empresa"]["loncodestpro1"];
			 $ls_loncodestpro2 = $_SESSION["la_empresa"]["loncodestpro2"];
			 $ls_loncodestpro3 = $_SESSION["la_empresa"]["loncodestpro3"];
			 
			 $la_datatit=array(array('name'=>'<b>ESTRUCTURA PRESUPUESTARIA </b>'));
			 
			 $la_columnatit=array('name'=>'');
			 
			 $la_configtit=array('showHeadings'=>0, // Mostrar encabezados
							 'showLines'=>0, // Mostrar Lneas
							 'shaded'=>0, // Sombra entre lneas
							 'fontSize' => 7, // Tamao de Letras
							 'shadeCol'=>array(0.9,0.9,0.9), // Color de la sombra
							 'shadeCol2'=>array(0.9,0.9,0.9), // Color de la sombra
							 'xOrientation'=>'center', // Orientacion de la tabla
							 'xPos'=>280, // Orientacion de la tabla
							 'width'=>850, // Ancho de la tabla
							 'maxWidth'=>850);// Ancho Mximo de la tabla
			 
			 $io_pdf->ezTable($la_datatit,$la_columnatit,'',$la_configtit);	
			 
			 $la_data=array(array('name'=>substr($as_programatica,0,$ls_loncodestpro1).'</b>','name2'=>$as_denestpro[0]),
							array('name'=>substr($as_programatica,$ls_loncodestpro1,$ls_loncodestpro2),'name2'=>$as_denestpro[1]),
							array('name'=>substr($as_programatica,$ls_loncodestpro1+$ls_loncodestpro2,$ls_loncodestpro3),'name2'=>$as_denestpro[2]));
							
			 $la_columna=array('name'=>'','name2'=>'');
			 $la_config=array('showHeadings'=>0, // Mostrar encabezados
							 'showLines'=>0, // Mostrar Lneas
							 'shaded'=>0, // Sombra entre lneas
							 'fontSize' => 7, // Tamao de Letras
							 'shadeCol'=>array(0.9,0.9,0.9), // Color de la sombra
							 'shadeCol2'=>array(0.9,0.9,0.9), // Color de la sombra
							 'xOrientation'=>'center', // Orientacion de la tabla
							 'xPos'=>280, // Orientacion de la tabla
							 'width'=>850, // Ancho de la tabla
							 'maxWidth'=>850,// Ancho Mximo de la tabla
							 'cols'=>array('name'=>array('justification'=>'right','width'=>250), // Justificacion y ancho de la columna
										   'name2'=>array('justification'=>'left','width'=>600))); // Justificacion y ancho de la columna
			 $io_pdf->ezTable($la_data,$la_columna,'',$la_config);
			 $io_pdf->restoreState();
			 $io_pdf->closeObject();
			 $io_pdf->addObject($io_cabecera,'all');									   
		}			   
	}// end function uf_print_cabecera
	//--------------------------------------------------------------------------------------------------------------------------------

	//--------------------------------------------------------------------------------------------------------------------------------
	function uf_print_cabecera_detalle($io_encabezado,$io_pdf)
	{
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_cabecera_detalle
		//		    Acess: private
		//	    Arguments: la_data // arreglo de informacion
		//	   			   io_pdf // Objeto PDF
		//    Description: funcion que imprime el detalle
		//	   Creado Por: Ing.Yozelin Barragn
	    // Fecha Creacion: 12/09/2006
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
		$io_pdf->saveState();
		$la_data=array(array('cuenta'=>'<b>Cuenta</b>','denominacion'=>'<b>Denominacion</b>','trimestrei'=>'<b>I TRIMESTRE</b>',
		                     'trimestreii'=>'<b>II TRIMESTRE</b>','trimestreiii'=>'<b> III TRIMESTRE</b>','trimestreiv'=>'<b>IV TRIMESTRE</b>','total'=>'<b>TOTAL</b>',));
		$la_columnas=array('cuenta'=>'','denominacion'=>'','trimestrei'=>'','trimestreii'=>'','trimestreiii'=>'','trimestreiv'=>'',
						   'total'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 7, // Tamao de Letras
						 'titleFontSize' => 7,  // Tamao de Letras de los ttulos
						 'showLines'=>1, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'shadeCol'=>array(0.4,0.7,0.1),
						 'colGap'=>0.5, // separacion entre tablas
						 'width'=>990, // Ancho de la tabla
						 'maxWidth'=>990, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'xPos'=>502, // Orientacion de la tabla
					     'cols'=>array('cuenta'=>array('justification'=>'center','width'=>140), // Justificacion y ancho de la 
								       'denominacion'=>array('justification'=>'center','width'=>300), // Justificacion y ancho 
								       'trimestrei'=>array('justification'=>'center','width'=>110), // Justificacion y ancho de la columna
								       'trimestreii'=>array('justification'=>'center','width'=>110), // Justificacion y ancho de la 
								       'trimestreiii'=>array('justification'=>'center','width'=>110), // Justificacion y ancho de la columna
								       'trimestreiv'=>array('justification'=>'center','width'=>110), // Justificacion y ancho de la columna
								       'total'=>array('justification'=>'center','width'=>110))); // Justificacion y ancho 
	
		$io_pdf->ezTable($la_data,$la_columnas,'',$la_config);
		$io_pdf->restoreState();
		$io_pdf->closeObject();
		$io_pdf->addObject($io_encabezado,'all');
	}// end function uf_print_cabecera_detalle
	//--------------------------------------------------------------------------------------------------------------------------------

	//--------------------------------------------------------------------------------------------------------------------------------
	function uf_print_detalle($la_data,$io_pdf)
	{
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//       Function: uf_print_detalle
	//		    Acess: private
	//	    Arguments: la_data // arreglo de informacion
	//	   			   io_pdf // Objeto PDF
	//    Description: funcion que imprime el detalle
	//	   Creado Por: Ing.Yozelin Barragn
	// Fecha Creacion: 12/09/2006
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;

	$la_config=array('showHeadings'=>0, // Mostrar encabezados
					 'fontSize' => 7, // Tamao de Letras
					 'titleFontSize' => 7,  // Tamao de Letras de los ttulos
					 'showLines'=>0, // Mostrar Lneas
					 'shaded'=>0, // Sombra entre lneas
					 'colGap'=>0.5, // separacion entre tablas
					 'width'=>990, // Ancho de la tabla
					 'maxWidth'=>990, // Ancho Mximo de la tabla
					 'xOrientation'=>'center', // Orientacion de la tabla
					 'xPos'=>502, // Orientacion de la tabla
					 'cols'=>array('cuenta'=>array('justification'=>'center','width'=>140), // Justificacion y ancho de la columna
								   'denominacion'=>array('justification'=>'left','width'=>300), // Justificacion y ancho 
								   'trimestrei'=>array('justification'=>'right','width'=>110), // Justificacion y ancho de la columna
								   'trimestreii'=>array('justification'=>'right','width'=>110), // Justificacion y ancho de la columna
								   'trimestreiii'=>array('justification'=>'right','width'=>110), // Justificacion y ancho de la columna
								   'trimestreiv'=>array('justification'=>'right','width'=>110), // Justificacion y ancho de la columna
								   'total'=>array('justification'=>'right','width'=>110))); // Justificacion y ancho 
	
	$la_columnas=array('cuenta'=>'<b>Cuenta</b>',
					   'denominacion'=>'<b>Denominacion</b>',
					   'trimestrei'=>'<b>I TRIMESTRE</b>',
					   'trimestreii'=>'<b>II TRIMESTRE</b>',
					   'trimestreiii'=>'<b>III TRIMESTRE</b>',
					   'trimestreiv'=>'<b>IV TRIMESTRE</b>',
					   'total'=>'<b>Totalr</b>');
	$io_pdf->ezTable($la_data,$la_columnas,'',$la_config);
	}// end function uf_print_detalle
	//--------------------------------------------------------------------------------------------------------------------------------

	//--------------------------------------------------------------------------------------------------------------------------------
	function uf_print_pie_cabecera($la_data_tot,$io_pie_pagina,$io_pdf)
	{
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//       Function : uf_print_pie_cabecera
	//		    Acess : private 
	//	    Arguments : ad_total // Total General
	//    Description : funcion que imprime el fin de la cabecera de cada pgina
	//	   Creado Por:  Ing. Yozelin Barragn
	// Fecha Creacion:  12/09/2006
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
	$io_pdf->saveState();
	$la_data=array(array('name'=>'___________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________'));
	$la_columna=array('name'=>'');
	$la_config=array('showHeadings'=>0, // Mostrar encabezados
					 'fontSize' => 7, // Tamao de Letras
					 'showLines'=>0, // Mostrar Lneas
					 'shaded'=>0, // Sombra entre lneas
					 'xOrientation'=>'center', // Orientacion de la tabla
					 'width'=>990,//Ancho de la tabla
					 'xPos'=>510, // Orientacion de la tabla
					 'maxWidth'=>990); // Ancho Mximo de la tabla
	$io_pdf->ezTable($la_data,$la_columna,'',$la_config);	
	$la_config=array('showHeadings'=>0, // Mostrar encabezados
				 'fontSize' => 7, // Tamao de Letras
				 'titleFontSize' => 7,  // Tamao de Letras de los ttulos
				 'showLines'=>0, // Mostrar Lneas
				 'shaded'=>0, // Sombra entre lneas
				 'colGap'=>0.5, // separacion entre tablas
				 'width'=>990, // Ancho de la tabla
				 'maxWidth'=>990, // Ancho Mximo de la tabla
				 'xOrientation'=>'center', // Orientacion de la tabla
				 'xPos'=>502, // Orientacion de la tabla
				 'cols'=>array('totalgeneral'=>array('justification'=>'center','width'=>440), // Justificacion y ancho de la 
							   'trimestrei'=>array('justification'=>'right','width'=>110), // Justificacion y ancho de la columna
							   'trimestreii'=>array('justification'=>'right','width'=>110), // Justificacion y ancho de la columna
							   'trimestreiii'=>array('justification'=>'right','width'=>110), // Justificacion y ancho de la columna
							   'trimestreiv'=>array('justification'=>'right','width'=>110), // Justificacion y ancho de la columna
							   'total'=>array('justification'=>'right','width'=>110))); // Justificacion y ancho 
		
	$la_columnas=array('totalgeneral'=>'',
					   'trimestrei'=>'',
					   'trimestreii'=>'',
					   'trimestreiii'=>'',
					   'trimestreiv'=>'',
					   'total'=>'');
	$io_pdf->ezTable($la_data_tot,$la_columnas,'',$la_config);
	$io_pdf->restoreState();
	$io_pdf->closeObject();
	$io_pdf->addObject($io_pie_pagina,'all');
  }// end function uf_print_pie_cabecera
//-----------------------------------------------------------------------------------------------------------------------------
		require_once("../../../shared/ezpdf/class.ezpdf.php");
		require_once("sigesp_spg_funciones_reportes.php");
		$io_function_report = new sigesp_spg_funciones_reportes();
		require_once("../../../shared/class_folder/class_funciones.php");
		$io_funciones=new class_funciones();
		require_once("../../../shared/class_folder/class_fecha.php");
		$io_fecha = new class_fecha();
//-----------------------------------------------------------------------------------------------------------------------------
		require_once("sigesp_spg_reportes_class.php");
		$io_report = new sigesp_spg_reportes_class();
//------------------------------------------------------------------------------------------------------------------------------		

//--------------------------------------------------  Parmetros para Filtar el Reporte  ------------------------------------
		$li_estmodest       = $_SESSION["la_empresa"]["estmodest"];
		$ls_codestpro1_min  = $_GET["codestpro1"];
		$ls_codestpro2_min  = $_GET["codestpro2"];
		$ls_codestpro3_min  = $_GET["codestpro3"];
		$ls_codestpro1h_max = $_GET["codestpro1h"];
		$ls_codestpro2h_max = $_GET["codestpro2h"];
		$ls_codestpro3h_max = $_GET["codestpro3h"];
	    $ls_estclades       = $_GET["estclades"];
	    $ls_estclahas       = $_GET["estclahas"];
		$ls_cuentades       = $_GET["txtcuentades"];
	    $ls_cuentahas       = $_GET["txtcuentahas"];
		if($li_estmodest==1)
		{
			$ls_codestpro4_min =  "0000000000000000000000000";
			$ls_codestpro5_min =  "0000000000000000000000000";
			$ls_codestpro4h_max = "0000000000000000000000000";
			$ls_codestpro5h_max = "0000000000000000000000000";
			if(($ls_codestpro1_min=="")&&($ls_codestpro2_min=="")&&($ls_codestpro3_min==""))
			{
				$arrResultado=$io_function_report->uf_spg_reporte_select_min_programatica($ls_codestpro1_min,$ls_codestpro2_min,
			                                                                 			  $ls_codestpro3_min,$ls_codestpro4_min,$ls_codestpro5_min,$ls_estclades);				
				$ls_codestpro1_min=$arrResultado['as_codestpro1'];
				$ls_codestpro2_min=$arrResultado['as_codestpro2'];
				$ls_codestpro3_min=$arrResultado['as_codestpro3'];
				$ls_codestpro4_min=$arrResultado['as_codestpro4'];
				$ls_codestpro5_min=$arrResultado['as_codestpro5'];
				$ls_estclades=$arrResultado['as_estclades'];
				$lb_valido= $arrResultado['lb_valido'];
				if($lb_valido)
				{
					$ls_codestpro1  = trim($ls_codestpro1_min);
					$ls_codestpro2  = trim($ls_codestpro2_min);
					$ls_codestpro3  = trim($ls_codestpro3_min);
					$ls_codestpro4  = trim($ls_codestpro4_min);
					$ls_codestpro5  = trim($ls_codestpro5_min);
			  }
			}
			else
			{
					$ls_codestpro1  = $ls_codestpro1_min;
					$ls_codestpro2  = $ls_codestpro2_min;
					$ls_codestpro3  = $ls_codestpro3_min;
					$ls_codestpro4  = $ls_codestpro4_min;
					$ls_codestpro5  = $ls_codestpro5_min;
			}
			if(($ls_codestpro1h_max=="")&&($ls_codestpro2h_max=="")&&($ls_codestpro3h_max==""))
			{
				$arrResultado=$io_function_report->uf_spg_reporte_select_max_programatica($ls_codestpro1h_max,$ls_codestpro2h_max,
																			 $ls_codestpro3h_max,$ls_codestpro4h_max,
																			 $ls_codestpro5h_max,$ls_estclahas);
				$ls_codestpro1h_max=$arrResultado['as_codestpro1'];
				$ls_codestpro2h_max=$arrResultado['as_codestpro2'];
				$ls_codestpro3h_max=$arrResultado['as_codestpro3'];
				$ls_codestpro4h_max=$arrResultado['as_codestpro4'];
				$ls_codestpro5h_max=$arrResultado['as_codestpro5'];
				$ls_estclahas=$arrResultado['as_estclahas'];
				$lb_valido=$arrResultado['lb_valido'];
				if($lb_valido)
				{
					$ls_codestpro1h  = $ls_codestpro1h_max;
					$ls_codestpro2h  = $ls_codestpro2h_max;
					$ls_codestpro3h  = $ls_codestpro3h_max;
					$ls_codestpro4h  = $ls_codestpro4h_max;
					$ls_codestpro5h  = $ls_codestpro5h_max;
				  }
			}
			else
			{
				$ls_codestpro1h  = $ls_codestpro1h_max;
				$ls_codestpro2h  = $ls_codestpro2h_max;
				$ls_codestpro3h  = $ls_codestpro3h_max;
				$ls_codestpro4h  = $ls_codestpro4h_max;
				$ls_codestpro5h  = $ls_codestpro5h_max;
			}
		}
		elseif($li_estmodest==2)
		{
			$ls_codestpro4_min = $_GET["codestpro4"];
			$ls_codestpro5_min = $_GET["codestpro5"];
			$ls_codestpro4h_max = $_GET["codestpro4h"];
			$ls_codestpro5h_max = $_GET["codestpro5h"];
			if(($ls_codestpro1_min=="")&&($ls_codestpro2_min=="")&&($ls_codestpro3_min=="")&&($ls_codestpro4_min=="")&&
			   ($ls_codestpro5_min==""))
			{
				$arrResultado=$io_function_report->uf_spg_reporte_select_min_programatica($ls_codestpro1_min,$ls_codestpro2_min,
			                                                                 			  $ls_codestpro3_min,$ls_codestpro4_min,$ls_codestpro5_min,$ls_estclades);				
				$ls_codestpro1_min=$arrResultado['as_codestpro1'];
				$ls_codestpro2_min=$arrResultado['as_codestpro2'];
				$ls_codestpro3_min=$arrResultado['as_codestpro3'];
				$ls_codestpro4_min=$arrResultado['as_codestpro4'];
				$ls_codestpro5_min=$arrResultado['as_codestpro5'];
				$ls_estclades=$arrResultado['as_estclades'];
				$lb_valido= $arrResultado['lb_valido'];
				if($lb_valido)
				{
					$ls_codestpro1  = $ls_codestpro1_min;
					$ls_codestpro2  = $ls_codestpro2_min;
					$ls_codestpro3  = $ls_codestpro3_min;
					$ls_codestpro4  = $ls_codestpro4_min;
					$ls_codestpro5  = $ls_codestpro5_min;
			  }
			}
			else
			{
					$ls_codestpro1  = $ls_codestpro1_min;
					$ls_codestpro2  = $ls_codestpro2_min;
					$ls_codestpro3  = $ls_codestpro3_min;
					$ls_codestpro4  = $ls_codestpro4_min;
					$ls_codestpro5  = $ls_codestpro5_min;
			}
			if(($ls_codestpro1h_max=="")&&($ls_codestpro2h_max=="")&&($ls_codestpro3h_max=="")&&($ls_codestpro4h_max=="")&&
			   ($ls_codestpro5h_max==""))
			{
				$arrResultado=$io_function_report->uf_spg_reporte_select_max_programatica($ls_codestpro1h_max,$ls_codestpro2h_max,
																			 $ls_codestpro3h_max,$ls_codestpro4h_max,
																			 $ls_codestpro5h_max,$ls_estclahas);
				$ls_codestpro1h_max=$arrResultado['as_codestpro1'];
				$ls_codestpro2h_max=$arrResultado['as_codestpro2'];
				$ls_codestpro3h_max=$arrResultado['as_codestpro3'];
				$ls_codestpro4h_max=$arrResultado['as_codestpro4'];
				$ls_codestpro5h_max=$arrResultado['as_codestpro5'];
				$ls_estclahas=$arrResultado['as_estclahas'];
				$lb_valido=$arrResultado['lb_valido'];
				if($lb_valido)
				{
					$ls_codestpro1h  = $ls_codestpro1h_max;
					$ls_codestpro2h  = $ls_codestpro2h_max;
					$ls_codestpro3h  = $ls_codestpro3h_max;
					$ls_codestpro4h  = $ls_codestpro4h_max;
					$ls_codestpro5h  = $ls_codestpro5h_max;
				  }
			}
			else
			{
				$ls_codestpro1h  = $ls_codestpro1h_max;
				$ls_codestpro2h  = $ls_codestpro2h_max;
				$ls_codestpro3h  = $ls_codestpro3h_max;
				$ls_codestpro4h  = $ls_codestpro4h_max;
				$ls_codestpro5h  = $ls_codestpro5h_max;
			}
		}	
	   $ls_codfuefindes=$_GET["txtcodfuefindes"];
	   $ls_codfuefinhas=$_GET["txtcodfuefinhas"];
	   if (($ls_codfuefindes=='')&&($ls_codfuefindes==''))
	   {
			$arrResultado=$io_function_report->uf_spg_select_fuentefinanciamiento($ls_minfuefin,$ls_maxfuefin);
			$ls_minfuefin=$arrResultado['as_minfuefin'];
			$ls_maxfuefin=$arrResultado['as_maxfuefin'];
			$lb_valido=$arrResultado['lb_valido'];
			if($lb_valido)
			{
		     $ls_codfuefindes=$ls_minfuefin;
		     $ls_codfuefinhas=$ls_maxfuefin;
		  } 
	   }
	   if ($ls_cuentades=='')
	   {
	    $ls_cuenta = "";
		   $arrResultado=$io_function_report->uf_spg_reporte_select_min_cuenta($ls_cuenta);
		   $ls_cuenta=$arrResultado['as_spg_cuenta'];
		   $lb_valido=$arrResultado['lb_valido'];
		   if($lb_valido)
		   {
			 $ls_cuentades = $ls_cuenta;
			}
	   }
	   
	   if ($ls_cuentahas=='')
	   {
	    $ls_cuenta = "";
		   $arrResultado=$io_function_report->uf_spg_reporte_select_max_cuenta($ls_cuenta);
		   $ls_cuenta=$arrResultado['as_spg_cuenta'];
		   $lb_valido=$arrResultado['lb_valido'];
		   if($lb_valido)
		   {
			 $ls_cuentahas = $ls_cuenta;
			}
	   }
	 /////////////////////////////////         SEGURIDAD               ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	 $ls_programatica_desde=$ls_codestpro1.$ls_codestpro2.$ls_codestpro3.$ls_codestpro4.$ls_codestpro5.$ls_estclades;
	 $ls_programatica_hasta=$ls_codestpro1h.$ls_codestpro2h.$ls_codestpro3h.$ls_codestpro4h.$ls_codestpro5h.$ls_estclahas;
	 
	 $ls_desc_event="Solicitud de Reporte Distribucion Trimestral del Presupuesto Desde la Programatica  ".$ls_programatica_desde." hasta ".$ls_programatica_hasta;
	 $io_function_report->uf_load_seguridad_reporte("SPG","sigesp_vis_spg_reporte_distribucion_mentri_presupuesto.php",$ls_desc_event);
	////////////////////////////////         SEGURIDAD               ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//----------------------------------------------------  Parmetros del encabezado  ----------------------------------------------
		$ls_titulo="<b> DISTRIBUCION TRIMESTRAL DEL PRESUPUESTO </b> "; 	
//--------------------------------------------------------------------------------------------------------------------------------
    // Cargar el dts_cab con los datos de la cabecera del reporte( Selecciono todos comprobantes )	
	$ls_codestpro1  = $io_funciones->uf_cerosizquierda($ls_codestpro1_min,25);
	$ls_codestpro2  = $io_funciones->uf_cerosizquierda($ls_codestpro2_min,25);
	$ls_codestpro3  = $io_funciones->uf_cerosizquierda($ls_codestpro3_min,25);
	$ls_codestpro4  = $io_funciones->uf_cerosizquierda($ls_codestpro4_min,25);
	$ls_codestpro5  = $io_funciones->uf_cerosizquierda($ls_codestpro5_min,25);
	
	$ls_codestpro1h  = $io_funciones->uf_cerosizquierda($ls_codestpro1h_max,25);
	$ls_codestpro2h  = $io_funciones->uf_cerosizquierda($ls_codestpro2h_max,25);
	$ls_codestpro3h  = $io_funciones->uf_cerosizquierda($ls_codestpro3h_max,25);
	$ls_codestpro4h  = $io_funciones->uf_cerosizquierda($ls_codestpro4h_max,25);
	$ls_codestpro5h  = $io_funciones->uf_cerosizquierda($ls_codestpro5h_max,25);
    $lb_valido=$io_report->uf_spg_reportes_comparados_distribucion_mensual_presupuesto($ls_codestpro1,$ls_codestpro2,
	                                                                                   $ls_codestpro3,$ls_codestpro4,
	                                                                                   $ls_codestpro5,$ls_codestpro1h,
	                                                                                   $ls_codestpro2h,$ls_codestpro3h,
																                       $ls_codestpro4h,$ls_codestpro5h,
																					   $ls_codfuefindes,$ls_codfuefinhas,
																					   $ls_estclades,$ls_estclahas,
																					   $ls_cuentades, $ls_cuentahas);
	 if($lb_valido==false) // Existe algn error o no hay registros
	 {
		print("<script language=JavaScript>");
		print(" alert('No hay nada que Reportar');"); 
		print(" close();");
		print("</script>");
	 }
	 else // Imprimimos el reporte
	 {
	    $io_pdf=new Cezpdf('LEGAL','landscape'); // Instancia de la clase PDF
		$io_pdf->selectFont('../../../shared/ezpdf/fonts/Helvetica.afm'); // Seleccionamos el tipo de letra
		$io_pdf->ezSetCmMargins(5.4,3,3,3); // Configuracion de los margenes en centmetros
		uf_print_encabezado_pagina($ls_titulo,$io_pdf); // Imprimimos el encabezado de la pgina
        $io_pdf->ezStartPageNumbers(980,40,10,'','',1); // Insertar el nmero de pgina
		$io_report->dts_reporte->group_noorder("programatica");
		$li_tot=$io_report->dts_reporte->getRowCount("spg_cuenta");
		$ld_total_trimestre_i=0;
		$ld_total_trimestre_ii=0;
		$ld_total_trimestre_iii=0;
		$ld_total_trimestre_iv=0;
		$ld_total_general_cuenta=0;
		
		$ls_loncodestpro1 = $_SESSION["la_empresa"]["loncodestpro1"];
		$ls_loncodestpro2 = $_SESSION["la_empresa"]["loncodestpro2"];
		$ls_loncodestpro3 = $_SESSION["la_empresa"]["loncodestpro3"];
		$ls_loncodestpro4 = $_SESSION["la_empresa"]["loncodestpro4"];
		$ls_loncodestpro5 = $_SESSION["la_empresa"]["loncodestpro5"];
		for($z=1;$z<=$li_tot;$z++)
		{
		    $li_tmp=($z+1);
			$thisPageNum=$io_pdf->ezPageCount;
			$ls_programatica=$io_report->dts_reporte->data["programatica"][$z];
			$ls_spg_cuenta=trim($io_report->dts_reporte->data["spg_cuenta"][$z]);
		    if ($z<$li_tot)
		    {
				$ls_programatica_next=$io_report->dts_reporte->data["programatica"][$li_tmp]; 
		    }
		    elseif($z=$li_tot)
		    {
				$ls_programatica_next='no_next';
		    }
			if(!empty($ls_programatica))
			{
				$ls_estcla=substr($ls_programatica,-1);
				$ls_codestpro1=substr($ls_programatica,0,25);
				$ls_denestpro1="";
				$arrResultado=$io_function_report->uf_spg_reporte_select_denestpro1($ls_codestpro1,$ls_denestpro1,$ls_estcla);
				$ls_denestpro1=$arrResultado['as_denestpro1'];
				$lb_valido=$arrResultado['lb_valido'];
				if($lb_valido)
				{
				  $ls_denestpro1=trim($ls_denestpro1);
				}
				$ls_codestpro2=substr($ls_programatica,25,25);
				if($lb_valido)
				{
				  $ls_denestpro2="";
				  $arrResultado=$io_function_report->uf_spg_reporte_select_denestpro2($ls_codestpro1,$ls_codestpro2,$ls_denestpro2,$ls_estcla);
				  $ls_denestpro2=$arrResultado['as_denestpro2'];
				  $lb_valido=$arrResultado['lb_valido'];
				  $ls_denestpro2=trim($ls_denestpro2);
				}
				$ls_codestpro3=substr($ls_programatica,50,25);
				if($lb_valido)
				{
				  $ls_denestpro3="";
				  $arrResultado=$io_function_report->uf_spg_reporte_select_denestpro3($ls_codestpro1,$ls_codestpro2,$ls_codestpro3,$ls_denestpro3,$ls_estcla);
				  $ls_denestpro3=$arrResultado['as_denestpro3'];
				  $lb_valido=$arrResultado['lb_valido'];
				  $ls_denestpro3=trim($ls_denestpro3);
				}
				if($li_estmodest==2)
				{
					$ls_codestpro4=substr($ls_programatica,75,25);
					if($lb_valido)
					{
					  $ls_denestpro4="";
					  $arrResultado=$io_function_report->uf_spg_reporte_select_denestpro4($ls_codestpro1,$ls_codestpro2,$ls_codestpro3,$ls_codestpro4,$ls_denestpro4,$ls_estcla);
					  $ls_denestpro4=$arrResultado['as_denestpro4'];
					  $lb_valido=$arrResultado['lb_valido'];
					  $ls_denestpro4=trim($ls_denestpro4);
					}
					$ls_codestpro5=substr($ls_programatica,100,25);
					if($lb_valido)
					{
					  $ls_denestpro5="";
					  $arrResultado=$io_function_report->uf_spg_reporte_select_denestpro5($ls_codestpro1,$ls_codestpro2,$ls_codestpro3,$ls_codestpro4,$ls_codestpro5,$ls_denestpro5,$ls_estcla);
					  $ls_denestpro5=$arrResultado['as_denestpro5'];
					  $lb_valido=$arrResultado['lb_valido'];
					  $ls_denestpro5=trim($ls_denestpro5);
					}
					$ls_denestpro_ant=trim($ls_denestpro1)." , ".trim($ls_denestpro2)." , ".trim($ls_denestpro3)." , ".trim($ls_denestpro4)." , ".trim($ls_denestpro5);
					$ls_programatica_ant=substr($ls_codestpro1,-$ls_loncodestpro1)."-".substr($ls_codestpro2,-$ls_loncodestpro2)."-".substr($ls_codestpro3,-$ls_loncodestpro3)."-".substr($ls_codestpro4,-$ls_loncodestpro4)."-".substr($ls_codestpro5,-$ls_loncodestpro5);
				}
				else
				{
					//$ls_denestpro_ant=$ls_denestpro1." , ".$ls_denestpro2." , ".$ls_denestpro3;
					$ls_denestpro_ant = array();
					$ls_denestpro_ant[0]=$ls_denestpro1;
					$ls_denestpro_ant[1]=$ls_denestpro2;
					$ls_denestpro_ant[2]=$ls_denestpro3;
					$ls_programatica_ant=substr($ls_codestpro1,-$ls_loncodestpro1).substr($ls_codestpro2,-$ls_loncodestpro2).substr($ls_codestpro3,-$ls_loncodestpro3);
				}
			}
			
			$ls_denominacion=trim($io_report->dts_reporte->data["denominacion"][$z]);
			$li_nivel=$io_report->dts_reporte->data["nivel"][$z];
			$ld_enero=$io_report->dts_reporte->data["enero"][$z];
			$ld_febrero=$io_report->dts_reporte->data["febrero"][$z];
			$ld_marzo=$io_report->dts_reporte->data["marzo"][$z];
			$ld_abril=$io_report->dts_reporte->data["abril"][$z];
			$ld_mayo=$io_report->dts_reporte->data["mayo"][$z];
			$ld_junio=$io_report->dts_reporte->data["junio"][$z];
			$ld_julio=$io_report->dts_reporte->data["julio"][$z];
			$ld_agosto=$io_report->dts_reporte->data["agosto"][$z];
			$ld_septiembre=$io_report->dts_reporte->data["septiembre"][$z];
			$ld_octubre=$io_report->dts_reporte->data["octubre"][$z];
			$ld_noviembre=$io_report->dts_reporte->data["noviembre"][$z];
			$ld_diciembre=$io_report->dts_reporte->data["diciembre"][$z];
		    $ls_status=$io_report->dts_reporte->data["status"][$z];  
			
			$ld_trimestre_i   = $ld_enero + $ld_febrero + $ld_marzo;
			$ld_trimestre_ii  = $ld_abril + $ld_mayo + $ld_junio;
			$ld_trimestre_iii = $ld_julio + $ld_agosto + $ld_septiembre;
			$ld_trimestre_iv  = $ld_octubre + $ld_noviembre + $ld_diciembre;
			
			$ld_total_cuenta=$ld_enero+$ld_febrero+$ld_marzo+$ld_abril+$ld_mayo+$ld_junio+$ld_julio+$ld_agosto+$ld_septiembre+$ld_octubre+$ld_noviembre+$ld_diciembre; 
			
			if ($ls_status=="C")
			{
				$ld_total_general_cuenta=$ld_total_general_cuenta+$ld_total_cuenta;
				$ld_total_trimestre_i = $ld_total_trimestre_i + $ld_trimestre_i;
				$ld_total_trimestre_ii = $ld_total_trimestre_ii + $ld_trimestre_ii;
				$ld_total_trimestre_iii = $ld_total_trimestre_iii + $ld_trimestre_iii;
				$ld_total_trimestre_iv = $ld_total_trimestre_iv + $ld_trimestre_iv;
			}				
			if (!empty($ls_programatica))
		    {
				$ld_total_cuenta=number_format($ld_total_cuenta,2,",",".");
				
			    $ld_trimestre_i   =number_format($ld_trimestre_i,2,",",".");
				$ld_trimestre_ii  =number_format($ld_trimestre_ii,2,",",".");
				$ld_trimestre_iii =number_format($ld_trimestre_iii,2,",",".");
				$ld_trimestre_iv  =number_format($ld_trimestre_iv,2,",",".");	
				
				 if ($ls_status=="S")
				 {
				 	$arrSaldos = $io_report->uf_calcular_saldo($ls_estcla, $ls_codestpro1, $ls_codestpro2, $ls_codestpro3, $ls_codestpro4, $ls_codestpro5, $ls_spg_cuenta, $li_nivel);
				 	$ld_trimestre_i = number_format($arrSaldos['enero']+$arrSaldos['febrero']+$arrSaldos['marzo'],2,",",".");
				 	$ld_trimestre_ii = number_format($arrSaldos['abril']+$arrSaldos['mayo']+$arrSaldos['junio'],2,",",".");
				 	$ld_trimestre_iii = number_format($arrSaldos['julio']+$arrSaldos['agosto']+$arrSaldos['septiembre'],2,",",".");
				 	$ld_trimestre_iv = number_format($arrSaldos['octubre']+$arrSaldos['noviembre']+$arrSaldos['diciembre'],2,",",".");
				 	$ld_total_cuenta = $arrSaldos['enero']+$arrSaldos['febrero']+$arrSaldos['marzo']+
				 	                   $arrSaldos['abril']+$arrSaldos['mayo']+$arrSaldos['junio']+
				 	                   $arrSaldos['julio']+$arrSaldos['agosto']+$arrSaldos['septiembre']+
				 	                   $arrSaldos['octubre']+$arrSaldos['noviembre']+$arrSaldos['diciembre'];
				 	$ld_total_cuenta = number_format($ld_total_cuenta,2,",",".");
				 	$ls_spg_cuenta='<b>'.$ls_spg_cuenta.'</b>';
					$ls_denominacion='<b>'.$ls_denominacion.'</b>';
					$ld_trimestre_i='<b>'.$ld_trimestre_i.'</b>';
					$ld_trimestre_ii='<b>'.$ld_trimestre_ii.'</b>';
					$ld_trimestre_iii='<b>'.$ld_trimestre_iii.'</b>';
					$ld_trimestre_iv='<b>'.$ld_trimestre_iv.'</b>';
					$ld_total_cuenta='<b>'.$ld_total_cuenta.'</b>';
				 }			
				$la_data[$z]=array('cuenta'=>$ls_spg_cuenta,'denominacion'=>$ls_denominacion,'trimestrei'=>$ld_trimestre_i,
				                   'trimestreii'=>$ld_trimestre_ii,'trimestreiii'=>$ld_trimestre_iii,
								   'trimestreiv'=>$ld_trimestre_iv,
								   'total'=>$ld_total_cuenta);
				
				$ld_trimestre_i    = str_replace('.','',$ld_trimestre_i);
				$ld_trimestre_i    = str_replace(',','.',$ld_trimestre_i);
				$ld_trimestre_ii   = str_replace('.','',$ld_trimestre_ii);
				$ld_trimestre_ii   = str_replace(',','.',$ld_trimestre_ii);
				$ld_trimestre_iii  = str_replace('.','',$ld_trimestre_iii);
				$ld_trimestre_iii  = str_replace(',','.',$ld_trimestre_iii);
				$ld_trimestre_iv   = str_replace('.','',$ld_trimestre_iv);
				$ld_trimestre_iv   = str_replace(',','.',$ld_trimestre_iv);

			}
			else
			{
				$ld_total_cuenta=number_format($ld_total_cuenta,2,",",".");
				
				$ld_trimestre_i   =number_format($ld_trimestre_i,2,",",".");
				$ld_trimestre_ii  =number_format($ld_trimestre_ii,2,",",".");
				$ld_trimestre_iii =number_format($ld_trimestre_iii,2,",",".");
				$ld_trimestre_iv  =number_format($ld_trimestre_iv,2,",",".");
				
				if ($ls_status=="S")
				 {
				 	$arrSaldos = $io_report->uf_calcular_saldo($ls_estcla, $ls_codestpro1, $ls_codestpro2, $ls_codestpro3, $ls_codestpro4, $ls_codestpro5, $ls_spg_cuenta, $li_nivel);
				 	$ld_trimestre_i = number_format($arrSaldos['enero']+$arrSaldos['febrero']+$arrSaldos['marzo'],2,",",".");
				 	$ld_trimestre_ii = number_format($arrSaldos['abril']+$arrSaldos['mayo']+$arrSaldos['junio'],2,",",".");
				 	$ld_trimestre_iii = number_format($arrSaldos['julio']+$arrSaldos['agosto']+$arrSaldos['septiembre'],2,",",".");
				 	$ld_trimestre_iv = number_format($arrSaldos['octubre']+$arrSaldos['noviembre']+$arrSaldos['diciembre'],2,",",".");
				 	$ld_total_cuenta = $arrSaldos['enero']+$arrSaldos['febrero']+$arrSaldos['marzo']+
				 	$arrSaldos['abril']+$arrSaldos['mayo']+$arrSaldos['junio']+
				 	$arrSaldos['julio']+$arrSaldos['agosto']+$arrSaldos['septiembre']+
				 	$arrSaldos['octubre']+$arrSaldos['noviembre']+$arrSaldos['diciembre'];
				 	$ld_total_cuenta = number_format($ld_total_cuenta,2,",",".");
				 	$ls_spg_cuenta='<b>'.$ls_spg_cuenta.'</b>';
					$ls_denominacion='<b>'.$ls_denominacion.'</b>';
					$ld_trimestre_i='<b>'.$ld_trimestre_i.'</b>';
					$ld_trimestre_ii='<b>'.$ld_trimestre_ii.'</b>';
					$ld_trimestre_iii='<b>'.$ld_trimestre_iii.'</b>';
					$ld_trimestre_iv='<b>'.$ld_trimestre_iv.'</b>';
					$ld_total_cuenta='<b>'.$ld_total_cuenta.'</b>';
				 }		
				
				$la_data[$z]=array('cuenta'=>$ls_spg_cuenta,'denominacion'=>$ls_denominacion,'trimestrei'=>$ld_trimestre_i,
				                   'trimestreii'=>$ld_trimestre_ii,'trimestreiii'=>$ld_trimestre_iii,
								   'trimestreiv'=>$ld_trimestre_iv,
								   'total'=>$ld_total_cuenta);
			   
				$ld_total_cuenta=str_replace('.','',$ld_total_cuenta);
				$ld_total_cuenta=str_replace(',','.',$ld_total_cuenta);
				
				$ld_trimestre_i    = str_replace('.','',$ld_trimestre_i);
				$ld_trimestre_i    = str_replace(',','.',$ld_trimestre_i);
				$ld_trimestre_ii   = str_replace('.','',$ld_trimestre_ii);
				$ld_trimestre_ii   = str_replace(',','.',$ld_trimestre_ii);
				$ld_trimestre_iii  = str_replace('.','',$ld_trimestre_iii);
				$ld_trimestre_iii  = str_replace(',','.',$ld_trimestre_iii);
				$ld_trimestre_iv   = str_replace('.','',$ld_trimestre_iv);
				$ld_trimestre_iv   = str_replace(',','.',$ld_trimestre_iv);
			}
			if (!empty($ls_programatica_next))
			{
				
				$ld_trimestre_i   =number_format($ld_trimestre_i,2,",",".");
				$ld_trimestre_ii  =number_format($ld_trimestre_ii,2,",",".");
				$ld_trimestre_iii =number_format($ld_trimestre_iii,2,",",".");
				$ld_trimestre_iv  =number_format($ld_trimestre_iv,2,",",".");
				
				if ($ls_status=="S")
				 {
				 	$arrSaldos = $io_report->uf_calcular_saldo($ls_estcla, $ls_codestpro1, $ls_codestpro2, $ls_codestpro3, $ls_codestpro4, $ls_codestpro5, $ls_spg_cuenta, $li_nivel);
				 	$ld_trimestre_i = number_format($arrSaldos['enero']+$arrSaldos['febrero']+$arrSaldos['marzo'],2,",",".");
				 	$ld_trimestre_ii = number_format($arrSaldos['abril']+$arrSaldos['mayo']+$arrSaldos['junio'],2,",",".");
				 	$ld_trimestre_iii = number_format($arrSaldos['julio']+$arrSaldos['agosto']+$arrSaldos['septiembre'],2,",",".");
				 	$ld_trimestre_iv = number_format($arrSaldos['octubre']+$arrSaldos['noviembre']+$arrSaldos['diciembre'],2,",",".");
				 	$ld_total_cuenta = $arrSaldos['enero']+$arrSaldos['febrero']+$arrSaldos['marzo']+
				 	$arrSaldos['abril']+$arrSaldos['mayo']+$arrSaldos['junio']+
				 	$arrSaldos['julio']+$arrSaldos['agosto']+$arrSaldos['septiembre']+
				 	$arrSaldos['octubre']+$arrSaldos['noviembre']+$arrSaldos['diciembre'];
				 	$ld_total_cuenta = number_format($ld_total_cuenta,2,",",".");
				 	$ls_spg_cuenta='<b>'.$ls_spg_cuenta.'</b>';
					$ls_denominacion='<b>'.$ls_denominacion.'</b>';
					$ld_trimestre_i='<b>'.$ld_trimestre_i.'</b>';
					$ld_trimestre_ii='<b>'.$ld_trimestre_ii.'</b>';
					$ld_trimestre_iii='<b>'.$ld_trimestre_iii.'</b>';
					$ld_trimestre_iv='<b>'.$ld_trimestre_iv.'</b>';
					$ld_total_cuenta='<b>'.$ld_total_cuenta.'</b>';
				 }						
				$la_data[$z]=array('cuenta'=>$ls_spg_cuenta,'denominacion'=>$ls_denominacion,'trimestrei'=>$ld_trimestre_i,
				                   'trimestreii'=>$ld_trimestre_ii,'trimestreiii'=>$ld_trimestre_iii,
								   'trimestreiv'=>$ld_trimestre_iv,'total'=>$ld_total_cuenta);
		        
				  /// Bolivar				 
				  $ld_total_general_cuenta=number_format($ld_total_general_cuenta,2,",",".");
				  
				  $ld_total_trimestre_i   = number_format($ld_total_trimestre_i,2,",",".");
			 	  $ld_total_trimestre_ii  = number_format($ld_total_trimestre_ii,2,",",".");
				  $ld_total_trimestre_iii = number_format($ld_total_trimestre_iii,2,",",".");
				  $ld_total_trimestre_iv  = number_format($ld_total_trimestre_iv,2,",",".");
				  
				  
				 if ($ls_status=="S")
				 {
				 	$arrSaldos = $io_report->uf_calcular_saldo($ls_estcla, $ls_codestpro1, $ls_codestpro2, $ls_codestpro3, $ls_codestpro4, $ls_codestpro5, $ls_spg_cuenta, $li_nivel);
				 	$ld_trimestre_i = number_format($arrSaldos['enero']+$arrSaldos['febrero']+$arrSaldos['marzo'],2,",",".");
				 	$ld_trimestre_ii = number_format($arrSaldos['abril']+$arrSaldos['mayo']+$arrSaldos['junio'],2,",",".");
				 	$ld_trimestre_iii = number_format($arrSaldos['julio']+$arrSaldos['agosto']+$arrSaldos['septiembre'],2,",",".");
				 	$ld_trimestre_iv = number_format($arrSaldos['octubre']+$arrSaldos['noviembre']+$arrSaldos['diciembre'],2,",",".");
				 	$ld_total_cuenta = $arrSaldos['enero']+$arrSaldos['febrero']+$arrSaldos['marzo']+
				 	$arrSaldos['abril']+$arrSaldos['mayo']+$arrSaldos['junio']+
				 	$arrSaldos['julio']+$arrSaldos['agosto']+$arrSaldos['septiembre']+
				 	$arrSaldos['octubre']+$arrSaldos['noviembre']+$arrSaldos['diciembre'];
				 	$ld_total_cuenta = number_format($ld_total_cuenta,2,",",".");
				 	$ls_spg_cuenta='<b>'.$ls_spg_cuenta.'</b>';
					$ls_denominacion='<b>'.$ls_denominacion.'</b>';
					$ld_trimestre_i='<b>'.$ld_trimestre_i.'</b>';
					$ld_trimestre_ii='<b>'.$ld_trimestre_ii.'</b>';
					$ld_trimestre_iii='<b>'.$ld_trimestre_iii.'</b>';
					$ld_trimestre_iv='<b>'.$ld_trimestre_iv.'</b>';
					$ld_total_cuenta='<b>'.$ld_total_cuenta.'</b>';
				 }		
				  $la_data_tot[$z]=array('totalgeneral'=>'<b>TOTAL Bs</b>','trimestrei'=>$ld_total_trimestre_i,'trimestreii'=>$ld_total_trimestre_ii,                                
										 'trimestreiii'=>$ld_total_trimestre_iii,'trimestreiv'=>$ld_total_trimestre_iv,
										 'total'=>$ld_total_general_cuenta);
										 
				$io_cabecera=$io_pdf->openObject();
			    uf_print_cabecera($io_cabecera,$ls_programatica_ant,$ls_denestpro_ant,$io_pdf);
				$io_encabezado=$io_pdf->openObject();
				uf_print_cabecera_detalle($io_encabezado,$io_pdf);
 				uf_print_detalle($la_data,$io_pdf); // Imprimimos el detalle 
				$io_pie_pagina=$io_pdf->openObject();
				uf_print_pie_cabecera($la_data_tot,$io_pie_pagina,$io_pdf);	
				$io_pdf->stopObject($io_pie_pagina);
				$io_pie_pagina=$io_pdf->openObject();
				$io_pdf->stopObject($io_cabecera);
				$io_pdf->stopObject($io_encabezado);
				$io_pdf->stopObject($io_pie_pagina);
			    if ((!empty($ls_programatica_next))&&($z<$li_tot))
				{
				 $io_pdf->ezNewPage(); // Insertar una nueva pgina
				} 
                $ld_total_general_cuenta=0;
			    unset($la_data);
			    unset($la_data_tot);
			}//if
	    }//for
		$io_pdf->ezStopPageNumbers(1,1);
		if (isset($d) && $d)
		{
			$ls_pdfcode = $io_pdf->ezOutput(1);
		  	$ls_pdfcode = str_replace("\n","\n<br>",htmlspecialchars($ls_pdfcode));
		  	echo '<html><body>';
		  	echo trim($ls_pdfcode);
		  	echo '</body></html>';
		}
		else
		{
			$io_pdf->ezStream();
		}
		unset($io_pdf);
	}
	unset($io_report);
	unset($io_funciones);
	unset($io_function_report);
	unset($io_fecha);
?> 