<?php
    session_start();   
	header("Pragma: public");
	header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
	header("Cache-Control: private",false);
	
	if(!array_key_exists("la_logusr",$_SESSION))
	{
		print "<script language=JavaScript>";
		print "close();";
		print "</script>";		
	}
  	//--------------------------------------------------------------------------------------------------------------------------------
	function uf_print_encabezado_pagina($as_titulo,$as_fecha,$io_pdf)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_encabezadopagina
		//		    Acess: private
		//	    Arguments: as_titulo // Ttulo del Reporte
		//	    		   as_periodo_comp // Descripcion del periodo del comprobante
		//	    		   as_fecha_comp // Descripcion del Periodo de la fecha del comprobante
		//	    		   io_pdf // Instancia de objeto pdf
		//    Description: funcion que imprime los encabezados por pgina
		//	   Creado Por: Ing.Yozelin Barragn
		// Fecha Creacion: 22/09/2006
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
		$io_encabezado=$io_pdf->openObject();
		$io_pdf->saveState();
		$io_pdf->line(10,40,578,40);
		$io_pdf->addJpegFromFile('../../../shared/imagebank/'.$_SESSION["ls_logo"],25,720,$_SESSION["ls_width"],$_SESSION["ls_height"]); // Agregar Logo
		$li_tm=$io_pdf->getTextWidth(11,$as_titulo);
		$tm=330-($li_tm/2);
		$io_pdf->addText($tm,730,10,$as_titulo); // Agregar el ttulo
		
		$li_tm=$io_pdf->getTextWidth(11,$as_fecha);
		$tm=330-($li_tm/2);
		$io_pdf->addText($tm,720,10,$as_fecha); // Agregar el ttulo
		$io_pdf->addText(500,740,9,$_SESSION["ls_database"]);// Agrerar el nombre de la base de datos actual
		$io_pdf->addText(500,730,9,date("d/m/Y")); // Agregar la Fecha
		$io_pdf->addText(500,720,9,date("h:i a")); // Agregar la hora
		$io_pdf->restoreState();
		$io_pdf->closeObject();
		$io_pdf->addObject($io_encabezado,'all');
	}// end function uf_print_encabezadopagina
	//--------------------------------------------------------------------------------------------------------------------------------

	//--------------------------------------------------------------------------------------------------------------------------------
	function uf_print_cabecera($as_cod_pro,$as_nomprobene,$as_tipo_destino,$io_pdf)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_cabecera
		//		   Access: privates
		//	    Arguments: as_programatica // programatica del comprobante
		//	    		   as_denestpro5 // denominacion de la programatica del comprobante
		//	    		   io_pdf // Objeto PDF
		//    Description: funcion que imprime la cabecera de cada pgina
		//	   Creado Por: Ing.Yozelin Barragn
		// Fecha Creacion: 22/09/2006
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
		$ls_codigo = $as_cod_pro;
		if($as_tipo_destino=="P")
		{
			$ls_titulo="Proveedor";
		}
		elseif($as_tipo_destino=="B"){
			$ls_titulo="Beneficiario";
		}
		else
		{
			$ls_titulo="Ninguno";
			$ls_codigo="----------";
		}
		$la_data=array(array('name'=>'<b>Codigo</b> '.$ls_codigo.''),
		               array('name'=>'<b>'.$ls_titulo.'</b> '.$as_nomprobene.'' ));
		$la_columna=array('name'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'showLines'=>0, // Mostrar Lneas
						 'fontSize' => 9, // Tamao de Letras
						 'shaded'=>2, // Sombra entre lneas
						 'shadeCol'=>array(0.9,0.9,0.9),
						 'shadeCol2'=>array(0.9,0.9,0.9), // Color de la sombra
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'xPos'=>305, // Orientacion de la tabla
						 'width'=>550, // Ancho de la tabla
						 'maxWidth'=>550); // Ancho Mximo de la tabla
		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);
	}// end function uf_print_cabecera
	//--------------------------------------------------------------------------------------------------------------------------------

	//--------------------------------------------------------------------------------------------------------------------------------
	function uf_print_detalle($la_data,$io_pdf)
	{
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_detalle
		//		    Acess: private
		//	    Arguments: la_data // arreglo de informacion
		//	   			   io_pdf // Objeto PDF
		//    Description: funcion que imprime el detalle
		//	   Creado Por: Ing.Yozelin Barragn
		// Fecha Creacion: 22/09/2006
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;

		$la_config=array('showHeadings'=>1, // Mostrar encabezados
						 'fontSize' => 9, // Tamao de Letras
						 'titleFontSize' => 9,  // Tamao de Letras de los ttulos
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'colGap'=>1, // separacion entre tablas
						 'width'=>550, // Ancho de la tabla
						 'maxWidth'=>550, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'xPos'=>305, // Orientacion de la tabla
						 'cols'=>array('cuenta'=>array('justification'=>'center','width'=>80), // Justificacion y ancho de la 
						               'comprobante'=>array('justification'=>'center','width'=>150), // Justificacion y ancho de la 
						 			   'fecha'=>array('justification'=>'center','width'=>80), // Justificacion y ancho de la 
						 			   'comprometido'=>array('justification'=>'right','width'=>120), // Justificacion 
						 			   'causado'=>array('justification'=>'right','width'=>60), // Justificacion y ancho de la 
									   'pagado'=>array('justification'=>'right','width'=>60))); // Justificacion y ancho de la 
		$la_columnas=array('cuenta'=>'<b>Cuenta</b>',
		                   'comprobante'=>'<b>Comprobante</b>',
						   'fecha'=>'<b>Fecha</b>',
						   'comprometido'=>'<b>Comprometido</b>',
						   'causado'=>'<b>Causado</b>',
						   'pagado'=>'<b>Pagado</b>');
		$io_pdf->ezTable($la_data,$la_columnas,'',$la_config);
	}// end function uf_print_detalle
	//--------------------------------------------------------------------------------------------------------------------------------

	//--------------------------------------------------------------------------------------------------------------------------------
	function uf_print_pie_cabecera($ad_totalcomprometer,$ad_totalcausado,$ad_totalpagado,$io_pdf,$as_titulo)
	{
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function : uf_print_pie_cabecera
		//		    Acess : private
		//	    Arguments : ad_total // Total General
		//    Description : funcion que imprime el fin de la cabecera de cada pgina
		//	   Creado Por: Ing.Yozelin Barragn
		// Fecha Creacion: 22/09/2006
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
		$la_datat=array(array('name'=>'___________________________________________________________________________________________________________'));
		$la_columna=array('name'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 9, // Tamao de Letras
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'xPos'=>305, // Orientacion de la tabla
						 'width'=>550); // Ancho Mximo de la tabla
		$io_pdf->ezTable($la_datat,$la_columna,'',$la_config);
		
		$la_data[]=array('cuenta'=>' ','comprobante'=>'','fecha'=>'<b>'.$as_titulo.'</b> ','comprometido'=>$ad_totalcomprometer,
		                 'causado'=>$ad_totalcausado,'pagado'=>$ad_totalpagado);
		$la_columnas=array('cuenta'=>' ','comprobante'=>'','fecha'=>'','comprometido'=>'','causado'=>'','pagado'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 9, // Tamao de Letras
						 'titleFontSize' => 9,  // Tamao de Letras de los ttulos
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'colGap'=>2, // separacion entre tablas
						 'width'=>550, // Ancho de la tabla
						 'maxWidth'=>550, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'xPos'=>305, // Orientacion de la tabla
						 'cols'=>array('cuenta'=>array('justification'=>'center','width'=>80), // Justificacion y ancho de la 
						               'comprobante'=>array('justification'=>'center','width'=>150), // Justificacion y ancho de  
						 			   'fecha'=>array('justification'=>'center','width'=>80), // Justificacion y ancho de la 
						 			   'comprometido'=>array('justification'=>'right','width'=>120), // Justificacion 
						 			   'causado'=>array('justification'=>'right','width'=>60), // Justificacion y ancho de la 
									   'pagado'=>array('justification'=>'right','width'=>60))); // Justificacion y ancho de la 
		$io_pdf->ezTable($la_data,$la_columnas,'',$la_config);
		$la_data=array(array('name'=>''));
		$la_columna=array('name'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>550, // Ancho Mximo de la tabla
						 'xOrientation'=>'center'); // Orientacion de la tabla
		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);
	}// end function uf_print_pie_cabecera
	//--------------------------------------------------------------------------------------------------------------------------------
		require_once("../../../shared/ezpdf/class.ezpdf.php");
        require_once("../../../shared/class_folder/class_funciones.php");
		require_once("sigesp_spg_funciones_reportes.php");
		require_once("../../../shared/class_folder/class_fecha.php");		
		$io_function_report = new sigesp_spg_funciones_reportes();
		$io_function        = new class_funciones() ;
		$io_fecha           = new class_fecha();
	
		require_once("sigesp_spg_class_compromiso_causado_parcial.php");
		$io_report = new sigesp_spg_class_compromiso_causado_parcial();
		
	//------------------------------------------------------------------------------------------------------------------------------		
	
	//--------------------------------------------------  Parmetros para Filtar el Reporte  --------------------------------------
		$li_estmodest = $_SESSION["la_empresa"]["estmodest"];
		$ls_tipprovbene = $_GET["tipprovbene"];
		$ls_codprovbene = $_GET["codprovbene"];
		$ls_procedencia = $_GET["procedencia"];
		$ldt_fecdes   = $_GET["txtfecdes"];
		$ldt_fechas   = $_GET["txtfechas"];	
	    $ls_fechades  = $io_function->uf_convertirfecmostrar($ldt_fecdes);
	    $ls_fechahas  = $io_function->uf_convertirfecmostrar($ldt_fechas);
	
	 /////////////////////////////////         SEGURIDAD               ///////////////////////////////////////////////////
	 $ls_desc_event="Solicitud de Reporte  Compromisos no Causados desde la  Fecha ".$ldt_fecdes."  hasta ".$ldt_fechas;
	 $io_function_report->uf_load_seguridad_reporte("SPG","sigesp_vis_spg_reporte_compromisos_no_causados.html",$ls_desc_event);
	////////////////////////////////         SEGURIDAD               //////////////////////////////////////////////////////
	//----------------------------------------------------  Parmetros del encabezado  ----------------------------------------------
		$ls_titulo="<b>COMPROMISOS NO CAUSADOS</b> "; 
		$ls_fecha="<b> DESDE  ".$ls_fechades."   HASTA LA FECHA  ".$ls_fechahas." </b>";      
	//--------------------------------------------------------------------------------------------------------------------------------
    // Cargar el dts_cab con los datos de la cabecera del reporte( Selecciono todos comprobantes )	
     $arrdatareporte    = array();	
     $data_compromisos  = $io_report->uf_obtener_compromisos($ldt_fecdes, $ldt_fechas);
	 $monto_suma=0;
     while(!$data_compromisos->EOF)
	 {
     	$procede            = $data_compromisos->fields['procede'];
     	$documento          = $data_compromisos->fields['documento'];
     	$spg_cuenta         = $data_compromisos->fields['spg_cuenta'];
     	$codestpro1         = $data_compromisos->fields['codestpro1'];
     	$estcla             = $data_compromisos->fields['estcla'];
     	$codestpro2         = $data_compromisos->fields['codestpro2'];
     	$codestpro3         = $data_compromisos->fields['codestpro3'];
     	$codestpro4         = $data_compromisos->fields['codestpro4'];
     	$codestpro5         = $data_compromisos->fields['codestpro5'];
     	$monto_comprometido = $data_compromisos->fields['monto'];            
     	
     	$resultado = $io_report->uf_buscar_causado( $procede, $documento, $spg_cuenta, $codestpro1, $estcla, $codestpro2, $codestpro3, $codestpro4, $codestpro5);
     	$data_causado = $resultado[1];
     	if((number_format($monto_comprometido, 2) > 0) && $resultado[0]==0)
		{
	     	$arrdatareporte [] = array('codigo'=>$data_compromisos->fields['codigo'],
	     		                           'nombre'=>$data_compromisos->fields['nombre'],
	     								   'tipo'=>$data_compromisos->fields['tipo_destino'],
	     								   'cuenta'=>$spg_cuenta,
	     								   'comprobante'=>$data_compromisos->fields['comprobante'],
	     								   'fecha'=>$io_function->uf_convertirfecmostrar($data_compromisos->fields['fecha']),
	     		 						   'comprometido'=>$monto_comprometido,
	     								   'causado'=>$resultado[0],
	     								   'pagado'=>$ld_total_pagado);
	    }
	    unset($resultado);
	    $data_compromisos->MoveNext();
     }
     unset($data_compromisos);
			
     if(empty($arrdatareporte)) // No hay registros
	 {
		print("<script language=JavaScript>");
		print(" alert('No hay nada que Reportar');"); 
		print(" close();");
		print("</script>");
	 }
	 else // Imprimimos el reporte
	 {
	    error_reporting(E_ALL);
		set_time_limit(1800);
		$io_pdf=new Cezpdf('LETTER','portrait'); // Instancia de la clase PDF
		$io_pdf->selectFont('../../../shared/ezpdf/fonts/Helvetica.afm'); // Seleccionamos el tipo de letra
		$io_pdf->ezSetCmMargins(3.5,3,3,3); // Configuracion de los margenes en centmetros
		uf_print_encabezado_pagina($ls_titulo,$ls_fecha,$io_pdf); // Imprimimos el encabezado de la pgina
		$io_pdf->ezStartPageNumbers(550,50,10,'','',1); // Insertar el nmero de pgina
		$ld_total_comprometer=0;
	    $ld_total_causado=0;
	    $ld_total_pagado=0;
		$ld_sub_total_comprometer=0;
		$ld_sub_total_causado=0;
		$ld_sub_total_pagado=0;
		
		$li_control        = 0;
		$li_causadoparcial = count($arrdatareporte);
		$ls_codprobene_ant = '';
		foreach ($arrdatareporte as $causadoparcial)
		{
			$ls_codprobene = $causadoparcial['codigo'];
			$ls_spg_cuenta = $causadoparcial['cuenta'];
			$ls_proc_comp  = $causadoparcial['comprobante'];
			$ldt_fecha     = $causadoparcial['fecha'];
			$ld_comprometer= $causadoparcial['comprometido'];
			$ld_causado    = $causadoparcial['causado'];
			$ld_pagado     = $causadoparcial['pagado'];
			
			$ld_total_comprometer     = $ld_total_comprometer + $ld_comprometer;
	   	 	$ld_total_causado         = $ld_total_causado + $ld_causado;
	    	$ld_total_pagado          = $ld_total_pagado  + $ld_pagado;
						
			if($ls_codprobene_ant == ''){
				$ls_codprobene_ant = $ls_codprobene;
				$ls_nomprobene     = $causadoparcial['nombre'];
				$ls_tipo_destino   = $causadoparcial['tipo'];
				uf_print_cabecera($ls_codprobene,$ls_nomprobene,$ls_tipo_destino,$io_pdf);
		
				$la_data[] = array('cuenta'=>$ls_spg_cuenta,'comprobante'=>$ls_proc_comp,'fecha'=>$ldt_fecha,
				               'comprometido'=>number_format($ld_comprometer,2,",","."),'causado'=>number_format($ld_causado,2,",","."),'pagado'=>number_format($ld_pagado,2,",","."));
				$ld_sub_total_comprometer = $ld_sub_total_comprometer + $ld_comprometer;
				$ld_sub_total_causado     = $ld_sub_total_causado + $ld_causado;
				$ld_sub_total_pagado      = $ld_sub_total_pagado + $ld_pagado;
			}
			else if($ls_codprobene_ant == $ls_codprobene){
				$la_data[] = array('cuenta'=>$ls_spg_cuenta,'comprobante'=>$ls_proc_comp,'fecha'=>$ldt_fecha,
				               'comprometido'=>number_format($ld_comprometer,2,",","."),'causado'=>number_format($ld_causado,2,",","."),'pagado'=>number_format($ld_pagado,2,",","."));
				$ld_sub_total_comprometer = $ld_sub_total_comprometer + $ld_comprometer;
				$ld_sub_total_causado     = $ld_sub_total_causado + $ld_causado;
				$ld_sub_total_pagado      = $ld_sub_total_pagado + $ld_pagado;
				$ls_codprobene_ant = $ls_codprobene;
			}
			else{
				uf_print_detalle($la_data,$io_pdf); // Imprimimos el detalle
				uf_print_pie_cabecera($ld_sub_total_comprometer,$ld_sub_total_causado,$ld_sub_total_pagado,$io_pdf,"Total Bs.");
				$ld_sub_total_comprometer = 0;
				$ld_sub_total_causado     = 0;
				$ld_sub_total_pagado      = 0;
				$ld_sub_total_comprometer = $ld_sub_total_comprometer + $ld_comprometer;
				$ld_sub_total_causado     = $ld_sub_total_causado + $ld_causado;
				$ld_sub_total_pagado      = $ld_sub_total_pagado + $ld_pagado;
				unset($la_data);
				
				//nuevo encabezado
				$ls_nomprobene     = $causadoparcial['nombre'];
				$ls_tipo_destino   = $causadoparcial['tipo'];
				uf_print_cabecera($ls_codprobene,$ls_nomprobene,$ls_tipo_destino,$io_pdf);
				$la_data[] = array('cuenta'=>$ls_spg_cuenta,'comprobante'=>$ls_proc_comp,'fecha'=>$ldt_fecha,
				               'comprometido'=>number_format($ld_comprometer,2,",","."),'causado'=>number_format($ld_causado,2,",","."),'pagado'=>number_format($ld_pagado,2,",","."));
				
				$ls_codprobene_ant = $ls_codprobene;
			}
			
			if($li_control+2>$li_causadoparcial){
				uf_print_detalle($la_data,$io_pdf); // Imprimimos el detalle
				uf_print_pie_cabecera($ld_sub_total_comprometer,$ld_sub_total_causado,$ld_sub_total_pagado,$io_pdf,"Total Bs.");
				uf_print_pie_cabecera($ld_total_comprometer,$ld_total_causado,$ld_total_pagado,$io_pdf,"Total General");
				unset($la_data);
			}
			
			$li_control++;
		}
		
			
		$io_pdf->ezStopPageNumbers(1,1);
		if (isset($d) && $d)
		{
			$ls_pdfcode = $io_pdf->ezOutput(1);
		  	$ls_pdfcode = str_replace("\n","\n<br>",htmlspecialchars($ls_pdfcode));
		  	echo '<html><body>';
		  	echo trim($ls_pdfcode);
		  	echo '</body></html>';
		}
		else
		{
			$io_pdf->ezStream();
		}
		unset($io_pdf);
	}
	
	unset($arrdatareporte);
	unset($la_data);
	unset($io_report);
	unset($io_funciones);
	unset($io_function_report);
	unset($io_fecha);
?> 