<?php
require_once('../../../shared/class_folder/tcpdf/tcpdf.php');
require_once("../../../shared/class_folder/class_datastore.php");;
require_once("../../../shared/class_folder/sigesp_include.php");
require_once("../../../shared/class_folder/class_funciones.php");
require_once("../../../shared/class_folder/class_sigesp_int.php");
$fun=new class_funciones() ;
$siginc=new sigesp_include();
$con=$siginc->uf_conectar();
$obj=new class_datastore();



class sigesp_spg_class_tcpdf extends TCPDF

{

	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	//////////  F U N C I O N E S    P A R A    E L    MA Y O R    A N A L I T I C O  //////////

	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//--------------------------------------------------------------------------------------------------------------------------------


	public function uf_print_titulos_campoext ($as_mostrar)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_titulos
		//		    Acess: private
		//    Description: funcion que imprime el detalle
		//	   Creado Por: Ing. Mara Beatriz Unda
		// Fecha Creacion: 13/08/08
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$this->SetFont("helvetica","B",7);
		if ($as_mostrar==0)
		{
			$w=array(16,28,28,65,23,23,23,27,25,23,23,23,23);
			$header=array('Fecha','Comprobante','Documento','Detalle','Asignado','Aumento','Disminucion','Monto Actualizado','Pre Comprometido','Comprometido','Causado','Pagado','Por Pagar');
		}
		else
		{
			$w=array(16,28,30,25,25,25,30,27,25,25,25,25);
			$header=array('Fecha','Comprobante','Documento','Asignado','Aumento','Disminucion','Monto Actualizado','Pre Comprometido','Comprometido','Causado','Pagado','Por Pagar');
		}

		for($i=0;$i<count($header);$i++)
		{

			if ($as_mostrar==0)
			{
				if ($i<=3)
				{

					$this->Cell($w[$i],6,$header[$i],'0',0,'L',0);

				}
				elseif ($i>3)
				{
					$this->Cell($w[$i],6,$header[$i],'0',0,'R',0);
				}
			}
			else
			{
				if ($i<=2)
				{

					$this->Cell($w[$i],6,$header[$i],'0',0,'L',0);

				}
				elseif ($i>2)
				{
					$this->Cell($w[$i],6,$header[$i],'0',0,'R',0);
				}
			}

		}

		$this->Ln();

	}// end function uf_print_titulos

	public function uf_print_titulos_procede ($as_mostrar)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_titulos
		//		    Acess: private
		//    Description: funcion que imprime el detalle
		//	   Creado Por: Ing. Mara Beatriz Unda
		// Fecha Creacion: 13/08/08
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$this->SetFont("helvetica","B",7);
		if ($as_mostrar==0)
		{
			$w=array(16,16,28,28,65,23,23,23,27,25,23,23,23,23);
			$header=array('Fecha','Procede','Comprobante','Documento','Detalle','Asignado','Aumento','Disminucion','Monto Actualizado','Pre Comprometido','Comprometido','Causado','Pagado','Por Pagar');
		}
		else
		{
			$w=array(16,16,28,30,25,25,25,30,27,25,25,25,25);
			$header=array('Fecha','Procede','Comprobante','Documento','Asignado','Aumento','Disminucion','Monto Actualizado','Pre Comprometido','Comprometido','Causado','Pagado','Por Pagar');
		}

		for($i=0;$i<count($header);$i++)
		{

			if ($as_mostrar==0)
			{
				if ($i<=3)
				{

					$this->Cell($w[$i],6,$header[$i],'0',0,'L',0);

				}
				elseif ($i>3)
				{
					$this->Cell($w[$i],6,$header[$i],'0',0,'R',0);
				}
			}
			else
			{
				if ($i<=2)
				{

					$this->Cell($w[$i],6,$header[$i],'0',0,'L',0);

				}
				elseif ($i>2)
				{
					$this->Cell($w[$i],6,$header[$i],'0',0,'R',0);
				}
			}

		}

		$this->Ln();

	}// end function uf_print_titulos






	public function uf_print_titulos_campoext2($as_mostrar)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_titulos
		//		    Acess: private
		//    Description: funcion que imprime el detalle
		//	   Creado Por: Ing. Mara Beatriz Unda
		// Fecha Creacion: 13/08/08
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$this->SetFont("helvetica","B",7);
		if ($as_mostrar==0)
		{
			$w=array(16,28,28,40,23,23,23,27,25,23,24,23,23,23);
			$header=array('Fecha','Comprobante','Documento','Detalle','Asignado','Aumento','Disminucion','Monto Actualizado','Pre Comprometido','Comprometido','Por Comprometer','Causado','Pagado','Por Pagar');
		}
		else
		{
			$w=array(16,28,30,25,25,25,30,27,25,25,25,25,25);
			$header=array('Fecha','Comprobante','Documento','Asignado','Aumento','Disminucion','Monto Actualizado','Pre Comprometido','Comprometido','Por Comprometer','Causado','Pagado','Por Pagar');
		}

		for($i=0;$i<count($header);$i++)
		{

			if ($as_mostrar==0)
			{
				if ($i<=3)
				{
					$this->Cell($w[$i],6,$header[$i],'0',0,'L',0);
				}
				elseif ($i>3)
				{
					$this->Cell($w[$i],6,$header[$i],'0',0,'R',0);
				}
			}
			else
			{
				if ($i<=2)
				{
					$this->Cell($w[$i],6,$header[$i],'0',0,'L',0);
				}
				elseif ($i>2)
				{
					$this->Cell($w[$i],6,$header[$i],'0',0,'R',0);
				}
			}
		}

		$this->Ln();

	}// end function uf_print_titulos




	//METODOS PARA GENERAR EL COMPROBANTE PRESUPUESTARIO FORMATO2

	public function uf_print_cabecera_comformato2($as_procede,$comprobante,$provee,$ls_numconcom)
	{

		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_cabecera
		//		   Access: private
		//	    Arguments: as_programatica // programatica del comprobante
		//	    		   as_denestpro5 // denominacion de la programatica del comprobante
		//    Description: funcion que imprime la cabecera de cada pgina
		//	   Creado Por: Ing.Yozelin Barragn
		// Fecha Creacion: 21/04/2006
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//if($as_programatica=='A00421010-0106')
		//{
		//	var_dump($as_denestpro);
		//	die();
		//}
		$this->Ln();
		$this->SetFont("helvetica","B",7);
		$dts_empresa=$_SESSION["la_empresa"];
		$style = array("width" => 0.1, "cap" => "round", "join" => "round", "dash" => "0", "color" => array(0, 0, 0));
		$this->SetLineStyle($style);


		$titulo1="Comprobante: {$as_procede}-{$comprobante}";
		$titulo3="Proveedor : {$provee}";
		$titulo2="Numero de Compromiso: {$ls_numconcom}";
		$this->Cell(0,8,$titulo1, 1, 1, 'L', 0, '0', 0);
		$this->Cell(0,8,$titulo2, 1, 1, 'L', 0, '0', 0);
		$this->Cell(0,8,$titulo3, 1, 1, 'L', 0, '0', 0);


	}// end function uf_print_cabecera





	public function uf_print_cabecera_ejecutado_por_partida($cuenta,$denominacion)
	{

		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_cabecera
		//		   Access: private
		//	    Arguments: as_programatica // programatica del comprobante
		//	    		   as_denestpro5 // denominacion de la programatica del comprobante
		//    Description: funcion que imprime la cabecera de cada pgina
		//	   Creado Por: Ing.Yozelin Barragn
		// Fecha Creacion: 21/04/2006
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//if($as_programatica=='A00421010-0106')
		//{
		//	var_dump($as_denestpro);
		//	die();
		//}
		$this->Ln();
		$this->SetFont("helvetica","B",7);
		$dts_empresa=$_SESSION["la_empresa"];
		$style = array("width" => 0.1, "cap" => "round", "join" => "round", "dash" => "0", "color" => array(0, 0, 0));
		$this->SetLineStyle($style);
			
		$titulo1="Cuenta: {$cuenta}";
		$titulo2="Denominacion : {$denominacion}";
		$this->Cell(0,8,$titulo1, 1, 1, 'L', 0, '0', 0);
		$this->Cell(0,8,$titulo2, 1, 1, 'L', 0, '0', 0);


	}// end function uf_print_cabecera











	public function uf_print_cabecera_programatica($as_programatica,$as_denestpro)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_cabecera
		//		   Access: private
		//	    Arguments: as_programatica // programatica del comprobante
		//	    		   as_denestpro5 // denominacion de la programatica del comprobante
		//    Description: funcion que imprime la cabecera de cada pgina
		//	   Creado Por: Ing.Yozelin Barragn
		// Fecha Creacion: 21/04/2006
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//if($as_programatica=='A00421010-0106')
		//{
		//	var_dump($as_denestpro);
		//	die();
		//}
		$this->Ln();
		$this->SetFont("helvetica","B",7);
		$dts_empresa=$_SESSION["la_empresa"];
		$style = array("width" => 0.1, "cap" => "round", "join" => "round", "dash" => "0", "color" => array(0, 0, 0));
		$this->SetLineStyle($style);
		if ($dts_empresa["estmodest"] == 2)
		{
			$this->MultiCell(0,8,'Programatica '.$as_programatica,1,'L', 0,1, 0 ,0, true, 0);
			$this->MultiCell(0,16,$as_denestpro,1,'L', 0,1, 0 ,0, true, 0);
		}
		else
		{
			$ls_loncodestpro1 = $dts_empresa["loncodestpro1"];
			$ls_loncodestpro2 = $dts_empresa["loncodestpro2"];
			$ls_loncodestpro3 = $dts_empresa["loncodestpro3"];
			$titulo1=substr($as_programatica,0,$ls_loncodestpro1).' '.$as_denestpro[0];
			$titulo2=substr($as_programatica,$ls_loncodestpro1,$ls_loncodestpro2).' '.$as_denestpro[1];
			$titulo3=substr($as_programatica,$ls_loncodestpro1+$ls_loncodestpro2,$ls_loncodestpro3).' '.$as_denestpro[2];

			$this->Cell(0,8,'ESTRUCTURA PRESUPUESTARIA',0, 1, 'L', 0, '0', 0);
			$this->Cell(0,8,$titulo1, 1, 1, 'L', 0, '0', 0);
			$this->Cell(0,8,$titulo2, 1, 1, 'L', 0, '0', 0);
			$this->Cell(0,8,$titulo3, 1, 1, 'L', 0, '0', 0);

		}
	}// end function uf_print_cabecera




	public function uf_print_titulos_comprobante2()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		// Function: uf_print_titulos
		//	Acess: private
		//  Description: funcion que imprime el detalle
		//	Creado Por: Ing. Mara Beatriz Unda
		//  Fecha Creacion: 13/08/08
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$this->SetFont("helvetica","B",7);
		$w=array(30,80,130);
		$header=array('Cuenta','Denominacion Cuenta','Descripcion Movimiento','Fecha','Operacion','Monto');

		$y=($this->getY() + 20);
		$this->MultiCell($w[0],6,$header[0],'0','L', 0, 0, 0 ,0, true, 0);
		$this->MultiCell($w[1],6,$header[1],'0','L', 0, 0, 0 ,0, true, 0);
		$this->MultiCell($w[2],6,$header[2],'0','L', 0, 0, 0 ,0, true, 0);
		$this->MultiCell($w[0],6,$header[3],'0','L', 0, 0, 0 ,0, true, 0);
		$this->MultiCell($w[0],6,$header[4],'0','L', 0, 0, 0 ,0, true, 0);
		$this->MultiCell($w[0],6,$header[5],'0','R', 0, 0, 0 ,0, true, 0);
		$this->Ln();
	}// end function uf_print_titulos


	public function uf_print_titulos_ejecutadoporpartidas()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		// Function: uf_print_titulos
		//	Acess: private
		//  Description: funcion que imprime el detalle
		//	Creado Por: Ing. Mara Beatriz Unda
		//  Fecha Creacion: 13/08/08
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$this->SetFont("helvetica","B",7);
		$w=array(23,80,23,28,30,140,70);
		$header=array('Programatica','Descripcion','Asignado','Precomprometido','Comprometido','% Comprometido','Causado','% Causado','Pagado','% Pagado');

		$y=($this->getY() + 20);
		$this->MultiCell($w[3],6,$header[0],'0','L', 0, 0, 0 ,0, true, 0);
		$this->MultiCell($w[5],6,$header[1],'0','L', 0, 0, 0 ,0, true, 0);
		$this->MultiCell($w[2],6,$header[2],'0','L', 0, 0, 0 ,0, true, 0);
		$this->MultiCell(24,6,$header[3],'0','L', 0, 0, 0 ,0, true, 0);
		$this->MultiCell($w[0],6,$header[4],'0','L', 0, 0, 0 ,0, true, 0);
		$this->MultiCell($w[0],6,$header[5],'0','L', 0, 0, 0 ,0, true, 0);
		$this->MultiCell($w[0],6,$header[6],'0','C', 0, 0, 0 ,0, true, 0);
		$this->MultiCell($w[0],6,$header[7],'0','L', 0, 0, 0 ,0, true, 0);
		$this->MultiCell($w[0],6,$header[8],'0','L', 0, 0, 0 ,0, true, 0);
		$this->MultiCell($w[0],6,$header[9],'0','L', 0, 0, 0 ,0, true, 0);
		$this->Ln();
	}// end function uf_print_titulos






	public function uf_print_detalle_comprobante2($la_data,$y,$tipo,$as_mostrar)
	{

		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_detalle
		//		    Acess: private
		//	    Arguments: la_data // arreglo de informacion
		//    Description: funcion que imprime el detalle
		//	   Creado Por: Ing. Yozelin Barragn
		// Fecha Creacion: 10/05/2006
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$fill=0;
		$w=array(30,80,130);
		$style = array("width" => 0.1, "cap" => "round", "join" => "round", "dash" => "2,10", "color" => array(0, 0, 0));
		$this->SetFont("helvetica","",7);
		$y=0;
		foreach($la_data as $row)
		{
			$y=($this->getY() + 20);
			$this->MultiCell($w[0],6,$row["cuenta"],'0','L', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[1],6,utf8_encode($row["dencuenta"]),'0','L', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[2],6,utf8_encode(substr($row["descripcion"],0,160)),'0','L', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[0],6,$row["fecha"],'0','L', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[0],6,$row["operacion"],'0','L', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[0],6,$row["monto"],'0','R', 0, 0, 0 ,0, true, 0);
			$this->Ln();
		}

		/*

		if ($as_mostrar==0)
		{
		if ($tipo==1)
		{
		$this->Ln(2);
		$this->Line(351, $this->GetY(), 137, $this->GetY(), $style);
		}
		}
		else
		{
		if ($tipo==1)
		{
		$this->Ln(2);
		$this->Line(320, $this->GetY(), 74, $this->GetY(), $style);
		}
		}
		*/
	}// end function uf_print_detalle



	public function uf_print_detalle_ejecutadoporpartida($la_data,$y,$tipo,$as_mostrar)
	{

		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_detalle
		//		    Acess: private
		//	    Arguments: la_data // arreglo de informacion
		//    Description: funcion que imprime el detalle
		//	   Creado Por: Ing. Yozelin Barragn
		// Fecha Creacion: 10/05/2006
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$fill=0;
		$w=array(22,80,20,28,30,140,70);
		$style = array("width" => 0.1, "cap" => "round", "join" => "round", "dash" => "2,10", "color" => array(0, 0, 0));
		$this->SetFont("helvetica","",7);
		$y=0;
		foreach($la_data as $row)
		{
			$y=($this->getY() + 20);
			$this->MultiCell($w[3],6,$row["programatica"],'0','L', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[5],6,utf8_encode(substr($row["descripcion"],0,130)),'0','L', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[2],6,utf8_encode($row["asignado"]),'0','R', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[0],6,$row["precomprometido"],'0','R', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[0],6,$row["comprometido"],'0','R', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[0],6,$row["porcomprometido"],'0','R', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[0],6,$row["causado"],'0','R', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[0],6,$row["porcausado"],'0','R', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[0],6,$row["pagado"],'0','R', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[0],6,$row["porpagado"],'0','R', 0, 0, 0 ,0, true, 0);
			$this->Ln();
		}

		/*

		if ($as_mostrar==0)
		{
		if ($tipo==1)
		{
		$this->Ln(2);
		$this->Line(351, $this->GetY(), 137, $this->GetY(), $style);
		}
		}
		else
		{
		if ($tipo==1)
		{
		$this->Ln(2);
		$this->Line(320, $this->GetY(), 74, $this->GetY(), $style);
		}
		}
		*/
	}// end function uf_print_detalle






	public	function uf_print_total_formato2($la_data)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_total_acumulado
		//		    Acess: private
		//	    Arguments: la_data // arreglo de informacion
		//    Description: funcion que imprime el detalle
		//	   Creado Por: Ing. Yozelin Barragn
		// Fecha Creacion: 10/05/2006
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$this->SetFont("helvetica","B",7);
		$w=array(30,80,130);
		$style = array("width" => 0.1, "cap" => "round", "join" => "round", "dash" => "2,10", "color" => array(0, 0, 0));
		$this->Line(347, $this->GetY(), 108, $this->GetY(), $style);
		$this->MultiCell($w[0],6," ",'0','L', 0, 0, 0 ,0, true, 0);
		$this->MultiCell($w[1],6," ",'0','L', 0, 0, 0 ,0, true, 0);
		$this->MultiCell($w[2],6," ",'0','L', 0, 0, 0 ,0, true, 0);
		$this->MultiCell($w[0],6," ",'0','L', 0, 0, 0 ,0, true, 0);
		$this->MultiCell($w[0],6,"Total",'0','L', 0, 0, 0 ,0, true, 0);
		$this->MultiCell($w[0],6,$la_data,'0','R', 0, 0, 0 ,0, true, 0);
		$this->Ln();
		unset($w);
		unset($style);
	}


	public	function uf_print_total_formato_ejecutado_porpartida($ld_total_asignado_general,$ld_total_precompromiso,$ld_total_compromiso,
	$ld_total_causado,$ld_total_pagado,$general=false)
	{
		//echo "llega aqui";
		//die();
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_total_acumulado
		//		    Acess: private
		//	    Arguments: la_data // arreglo de informacion
		//    Description: funcion que imprime el detalle
		//	   Creado Por: Ing. Yozelin Barragn
		// Fecha Creacion: 10/05/2006
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

		if($general==true)
		{
			$strgen = "Total General";
		}
		else
		{
			$strgen = "Total";
		}
		$this->SetFont("helvetica","B",7);
		$w=array(22,80,20,28,30,150,70);
		$style = array("width" => 0.1, "cap" => "round", "join" => "round", "dash" => "2,10", "color" => array(0, 0, 0));
		$this->Line(347, $this->GetY(), 108, $this->GetY(), $style);
		$this->MultiCell($w[3],6,'','0','L', 0, 0, 0 ,0, true, 0);
		$this->MultiCell($w[5],6,$strgen,'0','L', 0, 0, 0 ,0, true, 0);
		$this->MultiCell($w[2],6,$ld_total_asignado_general,'0','L', 0, 0, 0 ,0, true, 0);
		$this->MultiCell($w[0],6,$ld_total_precompromiso,'0','L', 0, 0, 0 ,0, true, 0);
		$this->MultiCell($w[0],6,$ld_total_compromiso,'0','L', 0, 0, 0 ,0, true, 0);
		$this->MultiCell($w[0],6,'','0','L', 0, 0, 0 ,0, true, 0);
		$this->MultiCell($w[0],6,$ld_total_causado,'0','L', 0, 0, 0 ,0, true, 0);
		$this->MultiCell($w[0],6,'','0','L', 0, 0, 0 ,0, true, 0);
		$this->MultiCell($w[0],6,$ld_total_pagado,'0','L', 0, 0, 0 ,0, true, 0);
		$this->MultiCell($w[0],6,'','0','R', 0, 0, 0 ,0, true, 0);
		$this->Ln();
		unset($w);
		unset($style);
	}



	public function uf_print_detalle_campoext($la_data,$y,$tipo,$as_mostrar)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_detalle
		//		    Acess: private
		//	    Arguments: la_data // arreglo de informacion
		//    Description: funcion que imprime el detalle
		//	   Creado Por: Ing. Yozelin Barragn
		// Fecha Creacion: 10/05/2006
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$fill=0;

		if ($as_mostrar==0)
		{
			$w=array(16,28,28,65,23,23,23,27,25,23,23,23,23);
		}
		else
		{
			$w=array(16,28,30,25,25,25,30,27,25,25,25,25);
		}

		$style = array("width" => 0.1, "cap" => "round", "join" => "round", "dash" => "2,10", "color" => array(0, 0, 0));
		$this->SetFont("helvetica","",7);
		$y=0;
		foreach($la_data as $row)
		{
			if ($y!=0)
			{
				$this->MultiCell($w[0],6,$row[0],0,'L', 0, 0, 0 ,$y, true, 0);
			}
			else
			{
				$this->MultiCell($w[0],6,$row[0],'0','L', 0, 0, 0 ,0, true, 0);
			}

			$this->MultiCell($w[1],6,$row[1],'0','L', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[2],6,$row[2],'0','L', 0, 0, 0 ,0, true, 0);
			if ($as_mostrar==0)
			{
				$row[3]=strtolower($row[3]);
				$this->MultiCell($w[3],6,substr($row[3],0,100),'0','L', 0, 0, 0 ,0, true, 0);
				$y=($this->getY() + 8);
				$this->MultiCell($w[4],6,$row[4],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[5],6,$row[5],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[6],6,$row[6],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[7],6,$row[7],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[8],6,$row[8],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[9],6,$row[9],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[10],6,$row[10],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[11],6,$row[11],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[12],6,$row[12],'0','R', 0, 0, 0 ,0, true, 0);
			}
			else
			{
				$this->MultiCell($w[3],6,$row[4],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[4],6,$row[5],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[5],6,$row[6],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[6],6,$row[7],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[7],6,$row[8],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[8],6,$row[9],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[9],6,$row[10],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[10],6,$row[11],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[11],6,$row[12],'0','R', 0, 0, 0 ,0, true, 0);

			}

			$this->Ln();
		}

		if ($as_mostrar==0)
		{
			if ($tipo==1)
			{
				$this->Ln(2);
				$this->Line(351, $this->GetY(), 137, $this->GetY(), $style);
			}
		}
		else
		{
			if ($tipo==1)
			{
				$this->Ln(2);
				$this->Line(320, $this->GetY(), 74, $this->GetY(), $style);
			}
		}
	}// end function uf_print_detalle


	public function uf_print_detalle_campo_procede($la_data,$y,$tipo,$as_mostrar)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_detalle
		//		    Acess: private
		//	    Arguments: la_data // arreglo de informacion
		//    Description: funcion que imprime el detalle
		//	   Creado Por: Ing. Yozelin Barragn
		// Fecha Creacion: 10/05/2006
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$fill=0;

		if ($as_mostrar==0)
		{
			$w=array(16,16,28,28,65,23,23,23,27,25,23,23,23,23);
		}
		else
		{
			$w=array(16,16,28,30,25,25,25,30,27,25,25,25,25);
		}

		$style = array("width" => 0.1, "cap" => "round", "join" => "round", "dash" => "2,10", "color" => array(0, 0, 0));
		$this->SetFont("helvetica","",7);
		$y=0;
		foreach($la_data as $row)
		{
			if ($y!=0)
			{
				$this->MultiCell($w[0],6,$row[0],0,'L', 0, 0, 0 ,$y, true, 0);
			}
			else
			{
				$this->MultiCell($w[0],6,$row[0],'0','L', 0, 0, 0 ,0, true, 0);
			}

			$this->MultiCell($w[1],6,$row[1],'0','L', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[2],6,$row[2],'0','L', 0, 0, 0 ,0, true, 0);
			if ($as_mostrar==0)
			{
				$row[3]=strtolower($row[3]);
				$this->MultiCell($w[3],6,substr($row[3],0,100),'0','L', 0, 0, 0 ,0, true, 0);
				$y=($this->getY() + 8);
				$this->MultiCell($w[4],6,$row[4],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[5],6,$row[5],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[6],6,$row[6],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[7],6,$row[7],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[8],6,$row[8],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[9],6,$row[9],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[10],6,$row[10],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[11],6,$row[11],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[12],6,$row[12],'0','R', 0, 0, 0 ,0, true, 0);
			}
			else
			{
				$this->MultiCell($w[3],6,$row[4],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[4],6,$row[5],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[5],6,$row[6],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[6],6,$row[7],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[7],6,$row[8],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[8],6,$row[9],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[9],6,$row[10],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[10],6,$row[11],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[11],6,$row[12],'0','R', 0, 0, 0 ,0, true, 0);

			}

			$this->Ln();
		}

		if ($as_mostrar==0)
		{
			if ($tipo==1)
			{
				$this->Ln(2);
				$this->Line(351, $this->GetY(), 137, $this->GetY(), $style);
			}
		}
		else
		{
			if ($tipo==1)
			{
				$this->Ln(2);
				$this->Line(320, $this->GetY(), 74, $this->GetY(), $style);
			}
		}
	}

public function uf_print_detalle_campoCMSP($la_data,$y,$tipo,$as_mostrar)
{
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//       Function: uf_print_detalle
	//		    Acess: private
	//	    Arguments: la_data // arreglo de informacion
	//    Description: funcion que imprime el detalle
	//	   Creado Por: Ing. Yozelin Barragn
	// Fecha Creacion: 10/05/2006
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$fill=0;

	if ($as_mostrar==0)
	{
		$w=array(16,28,28,15,50,23,23,23,27,25,23,23,23,23);
	}
	else
	{
		$w=array(16,28,30,15,25,25,25,30,27,25,25,25,25);
	}

	$style = array("width" => 0.1, "cap" => "round", "join" => "round", "dash" => "2,10", "color" => array(0, 0, 0));
	$this->SetFont("helvetica","",7);
	$y=0;
	foreach($la_data as $row)
	{
		if ($y!=0)
		{
			$this->MultiCell($w[0],6,$row[0],0,'L', 0, 0, 0 ,$y, true, 0);
		}
		else
		{
			$this->MultiCell($w[0],6,$row[0],'0','L', 0, 0, 0 ,0, true, 0);
		}

		$this->MultiCell($w[1],6,$row[1],'0','L', 0, 0, 0 ,0, true, 0);
		$this->MultiCell($w[2],6,$row[2],'0','L', 0, 0, 0 ,0, true, 0);
		$this->MultiCell($w[3],6,$row[3],'0','L', 0, 0, 0 ,0, true, 0);
		if ($as_mostrar==0)
		{
			$row[4]=strtolower($row[4]);
			$this->MultiCell($w[4],6,substr($row[4],0,270),'0','L', 0, 0, 0 ,0, true, 0);
			$y=($this->getY() + 22);
			$this->MultiCell($w[5],6,$row[5],'0','R', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[6],6,$row[6],'0','R', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[7],6,$row[7],'0','R', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[8],6,$row[8],'0','R', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[9],6,$row[9],'0','R', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[10],6,$row[10],'0','R', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[11],6,$row[11],'0','R', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[12],6,$row[12],'0','R', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[13],6,$row[13],'0','R', 0, 0, 0 ,0, true, 0);
		}
		else
		{
			$this->MultiCell($w[4],6,$row[5],'0','R', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[5],6,$row[6],'0','R', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[6],6,$row[7],'0','R', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[7],6,$row[8],'0','R', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[8],6,$row[9],'0','R', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[9],6,$row[10],'0','R', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[10],6,$row[11],'0','R', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[11],6,$row[12],'0','R', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[12],6,$row[13],'0','R', 0, 0, 0 ,0, true, 0);

		}
	}

	if ($as_mostrar==0)
	{
		if ($tipo==1)
		{
			$this->Ln(22);
			$this->Line(351, $this->GetY(), 137, $this->GetY(), $style);
		}
		else {
			$this->Ln(15);
		}
		
	}
	else
	{
		if ($tipo==1)
		{
			$this->Ln(22);
			$this->Line(320, $this->GetY(), 74, $this->GetY(), $style);
		}
		else {
			$this->Ln(15);
		}
	}


}// end function uf_print_detalle


	public function uf_print_detalle_campoext2($la_data,$y,$tipo,$as_mostrar)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_detalle
		//		    Acess: private
		//	    Arguments: la_data // arreglo de informacion
		//    Description: funcion que imprime el detalle
		//	   Creado Por: Ing. Yozelin Barragn
		// Fecha Creacion: 10/05/2006
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$fill=0;
		if ($as_mostrar==0)
		{
			$w=array(16,28,28,40,23,23,23,27,25,23,23,23,23);
		}
		else
		{
			$w=array(16,28,30,25,25,25,30,27,25,25,25,25);
		}

		$style = array("width" => 0.1, "cap" => "round", "join" => "round", "dash" => "2,10", "color" => array(0, 0, 0));
		$this->SetFont("helvetica","",7);
		$y=0;
		foreach($la_data as $row)
		{
			if ($y!=0)
			{
				$this->MultiCell($w[0],6,$row[0],0,'L', 0, 0, 0 ,$y, true, 0);
			}
			else
			{
				$this->MultiCell($w[0],6,$row[0],'0','L', 0, 0, 0 ,0, true, 0);
			}

			$this->MultiCell($w[1],6,$row[1],'0','L', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[2],6,$row[2],'0','L', 0, 0, 0 ,0, true, 0);
			if ($as_mostrar==0)
			{
				$row[3]=strtolower($row[3]);
				$this->MultiCell($w[3],6,substr($row[3],0,65),'0','L', 0, 0, 0 ,0, true, 0);
				$y=($this->getY() + 8);
				$this->MultiCell($w[4],6,$row[4],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[5],6,$row[5],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[6],6,$row[6],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[7],6,$row[7],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[8],6,$row[8],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[9],6,$row[9],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[10],6,$row[13],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[10],6,$row[10],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[11],6,$row[11],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[12],6,$row[12],'0','R', 0, 0, 0 ,0, true, 0);
			}
			else
			{
				$this->MultiCell($w[3],6,$row[4],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[4],6,$row[5],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[5],6,$row[6],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[6],6,$row[7],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[7],6,$row[8],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[8],6,$row[9],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[9],6,$row[13],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[10],6,$row[10],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[10],6,$row[11],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[11],6,$row[12],'0','R', 0, 0, 0 ,0, true, 0);

			}
			$this->Ln();
		}

		if ($as_mostrar==0)
		{
			if ($tipo==1)
			{
				$this->Ln(2);
				$this->Line(351, $this->GetY(), 137, $this->GetY(), $style);
			}
		}
		else
		{
			if ($tipo==1)
			{
				$this->Ln(2);
				$this->Line(320, $this->GetY(), 74, $this->GetY(), $style);
			}
		}
	}// end function uf_print_detalle

	//--------------------------------------------------------------------------------------------------------------------------------

	public function uf_print_titulos ($as_mostrar)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_titulos
		//		    Acess: private
		//    Description: funcion que imprime el detalle
		//	   Creado Por: Ing. Mara Beatriz Unda
		// Fecha Creacion: 13/08/08
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$this->SetFont("helvetica","B",7);
		if ($as_mostrar==0)
		{
			$w=array(16,28,28,20,35,33,23,23,33,25,20,20,20,20);
			$header=array('Fecha','Comprobante','Documento','Detalle','Benef / Prov','Asignado','Aumento','Disminucion','Monto Actualizado','Pre Comprometido','Comprometido','Causado','Pagado','Por Pagar');
		}
		else
		{
			$w=array(16,28,30,25,25,25,25,30,27,25,25,25,25);
			$header=array('Fecha','Comprobante','Documento','Beneficiario','Asignado','Aumento','Disminucion','Monto Actualizado','Pre Comprometido','Comprometido','Causado','Pagado','Por Pagar');
		}

		for($i=0;$i<count($header);$i++)
		{

			if ($as_mostrar==0)
			{
				if ($i<4)
				{
					$this->Cell($w[$i],6,$header[$i],'0',0,'L',0);
				}
				elseif($i==4)
				{
					$this->Cell($w[$i],6,$header[$i],'0',0,'C',0);
				}
				elseif ($i>4)
				{
					$this->Cell($w[$i],6,$header[$i],'0',0,'R',0);
				}
			}
			else
			{
				if ($i<3)
				{

					$this->Cell($w[$i],6,$header[$i],'0',0,'L',0);
				}


				elseif ($i>3)
				{
					$this->Cell($w[$i],6,$header[$i],'0',0,'R',0);
				}
			}

		}

		$this->Ln();

	}// end function uf_print_titulos

	//--------------------------------------------------------------------------------------------------------------------------------

	public function uf_print_detalle($la_data,$y,$tipo,$as_mostrar)
	{


		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_detalle
		//		    Acess: private
		//	    Arguments: la_data // arreglo de informacion
		//    Description: funcion que imprime el detalle
		//	   Creado Por: Ing. Yozelin Barragn
		// Fecha Creacion: 10/05/2006
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$fill=0;

		if ($as_mostrar==0)
		{
			$w=array(16,28,28,27,27,33,23,23,34,25,20,20,20,20);

		}
		else
		{
			$w=array(16,28,30,27,26,25,25,30,27,25,25,25,25);

		}

		$style = array("width" => 0.1, "cap" => "round", "join" => "round", "dash" => "2,10", "color" => array(0, 0, 0));
		$this->SetFont("helvetica","",6);
		$y=0;
		foreach($la_data as $row)
		{
			if($row[1]=="CO0000000000001" && $row[2]=="20-ADM000000001")
			{
				//var_dump($row);
				//die();
			}

			if ($y!=0)
			{
				$this->MultiCell($w[0],6,$row[0],0,'L', 0, 0, 0 ,$y, true, 0);
			}
			else
			{
				$this->MultiCell($w[0],6,$row[0],'0','L', 0, 0, 0 ,0, true, 0);
			}

			$this->MultiCell($w[1],6,$row[1],'0','L', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[2],6,$row[2],'0','L', 0, 0, 0 ,0, true, 0);
			if ($as_mostrar==0)
			{
				$row[3]=strtolower($row[3]);
				$this->MultiCell($w[3],6,substr($row[3],0,60),'0','L', 0, 0, 0 ,0, true, 0);
				$y=($this->getY() + 8);
				$this->MultiCell($w[4],6,substr($row[4],0,30),'0','L', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[5],6,$row[5],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[6],6,$row[6],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[7],6,$row[7],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[8],6,$row[8],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[9],6,$row[9],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[10],6,$row[10],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[11],6,$row[11],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[12],6,$row[12],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[13],6,$row[13],'0','R', 0, 0, 0 ,0, true, 0);
			}
			else
			{
				//	$this->MultiCell($w[4],6,substr($row[4],0,30),'0','L', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[4],6,$row[5],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[5],6,$row[6],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[6],6,$row[7],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[7],6,$row[8],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[8],6,$row[9],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[9],6,$row[10],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[10],6,$row[11],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[11],6,$row[12],'0','R', 0, 0, 0 ,0, true, 0);
				$this->MultiCell($w[11],6,$row[12],'0','R', 0, 0, 0 ,0, true, 0);
			}


			$this->Ln();
		}

		if ($as_mostrar==0)
		{
			if ($tipo==1)
			{
				$this->Ln(2);
				$this->Line(351, $this->GetY(), 137, $this->GetY(), $style);
			}

		}
		else
		{
			if ($tipo==1)
			{
				$this->Ln(2);
				$this->Line(320, $this->GetY(), 74, $this->GetY(), $style);
			}

		}




	}// end function uf_print_detalle


	//--------------------------------------------------------------------------------------------------------------------------------

	public function uf_print_cabecera($as_programatica,$as_denestpro)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_cabecera
		//		   Access: private
		//	    Arguments: as_programatica // programatica del comprobante
		//	    		   as_denestpro5 // denominacion de la programatica del comprobante
		//    Description: funcion que imprime la cabecera de cada pgina
		//	   Creado Por: Ing.Yozelin Barragn
		// Fecha Creacion: 21/04/2006
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//if($as_programatica=='A00421010-0106')
		//{
		//	var_dump($as_denestpro);
		//	die();
		//}
		$this->Ln();
		$this->SetFont("helvetica","B",7);
		$dts_empresa=$_SESSION["la_empresa"];
		$style = array("width" => 0.1, "cap" => "round", "join" => "round", "dash" => "0", "color" => array(0, 0, 0));
		$this->SetLineStyle($style);
		if ($dts_empresa["estmodest"] == 2)
		{
			$this->MultiCell(0,8,'Programatica '.$as_programatica,1,'L', 0,1, 0 ,0, true, 0);
			$this->MultiCell(0,16,$as_denestpro,1,'L', 0,1, 0 ,0, true, 0);
		}
		else
		{
			$ls_loncodestpro1 = $dts_empresa["loncodestpro1"];
			$ls_loncodestpro2 = $dts_empresa["loncodestpro2"];
			$ls_loncodestpro3 = $dts_empresa["loncodestpro3"];
			$titulo1=substr($as_programatica,0,$ls_loncodestpro1).' '.$as_denestpro[0];
			$titulo2=substr($as_programatica,$ls_loncodestpro1,$ls_loncodestpro2).' '.$as_denestpro[1];
			$titulo3=substr($as_programatica,$ls_loncodestpro1+$ls_loncodestpro2,$ls_loncodestpro3).' '.$as_denestpro[2];

			$this->Cell(0,8,'ESTRUCTURA PRESUPUESTARIA',0, 1, 'L', 0, '0', 0);
			$this->Cell(0,8,$titulo1, 1, 1, 'L', 0, '0', 0);
			$this->Cell(0,8,$titulo2, 1, 1, 'L', 0, '0', 0);
			$this->Cell(0,8,$titulo3, 1, 1, 'L', 0, '0', 0);

		}
	}// end function uf_print_cabecera

	//--------------------------------------------------------------------------------------------------------------------------------

	public function uf_print_cabecera_detalle($as_spg_cuenta,$as_denominacion)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_cabecera_detalle
		//		   Access: private
		//	    Arguments: as_spg_cuenta //cuenta
		//	    		   as_denominacion // denominacion
		//	    		   io_pdf // Objeto PDF
		//    Description: funcion que imprime la cabecera de cada pgina
		//	   Creado Por: Ing.Yozelin Barragn
		// Fecha Creacion: 21/04/2006
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$this->SetFont("helvetica","B",8);
		$this->Cell(0,8,'Cuenta '.$as_spg_cuenta.'  ---  '.$as_denominacion.'',0, 1, 'L', 0, '', 0);
	}// end function uf_print_cabecera_detalle


	//--------------------------------------------------------------------------------------------------------------------------------

	public	function uf_print_total2($la_data,$ls_tipo,$y,$as_mostrar)
	{
		//var_dump($la_data);
		//die();
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_total
		//		    Acess: private
		//	    Arguments: la_data // arreglo de informacion
		//    Description: funcion que imprime el detalle
		//	   Creado Por: Ing. Yozelin Barragn
		// Fecha Creacion: 10/05/2006
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$style = array("width" => 0.1, "cap" => "round", "join" => "round", "dash" => "2,10", "color" => array(0, 0, 0));

		if ($as_mostrar==0)
		{
			$w=array(120,30,22,22,30,22,21,23,30,23);
			if (($ls_tipo=='1'))
			{
				$this->Line(351, $this->GetY(), 137, $this->GetY(), $style);

			}
			elseif ($ls_tipo=='3')
			{
				$w=array(120,30,22,22,30,22,21,23,30,23);
				$this->Ln(3);
				$this->SetFont("helvetica","B",8);
				$this->Line(351, $this->GetY(), 133, $this->GetY(), $style);

			}

		}
		else
		{
			$w=array(74,25,25,25,30,27,25,25,25,25);
			if (($ls_tipo=='1'))
			{
				$this->Line(320, $this->GetY(), 74, $this->GetY(), $style);

			}
			elseif ($ls_tipo=='3')
			{
				$this->Ln(3);
				$this->SetFont("helvetica","B",8);
				$this->Line(320, $this->GetY(), 74, $this->GetY(), $style);

			}

		}

		foreach($la_data as $row)
		{
			//var_dump($row);
			//die();
			if($y!=0)
			{
				$this->MultiCell($w[0],6,$row[0],'0','R', 0, 0, 0 ,0, true, 0);

			}
			else
			{
				$this->MultiCell($w[0],6,$row[0],'0','R', 0, 0, 0 ,$y, true, 0);
			}
			$this->MultiCell($w[1],6,$row[1],'0',0,'R',0);
			$this->MultiCell($w[2],6,$row[2],'0',0,'R',0);
			$this->MultiCell($w[3],6,$row[3],'0',0,'R',0);
			$this->MultiCell($w[4],6,$row[4],'0',0,'R',0);
			$this->MultiCell($w[5],6,$row[5],'0',0,'R',0);

			$this->MultiCell($w[6],6,$row[6],'0',0,'R',0);
			$this->MultiCell($w[7],6,$row[10],'0',0,'R',0);
			$this->MultiCell($w[8],6,$row[7],'0',0,'R',0);
			$this->MultiCell($w[9],6,$row[8],'0',0,'R',0);
			$this->MultiCell($w[9],6,$row[9],'0',0,'R',0);
			$this->Ln();
		}
		unset($style);
		unset($w);
	}


	public	function uf_print_total($la_data,$ls_tipo,$y,$as_mostrar)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_total
		//		    Acess: private
		//	    Arguments: la_data // arreglo de informacion
		//    Description: funcion que imprime el detalle
		//	   Creado Por: Ing. Yozelin Barragn
		// Fecha Creacion: 10/05/2006
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$style = array("width" => 0.1, "cap" => "round", "join" => "round", "dash" => "2,10", "color" => array(0, 0, 0));

		if($as_mostrar==0)
		{
			$w=array(137,23,23,23,33,25,20,20,21,20);
			if (($ls_tipo=='1'))
			{
				$this->Line(351, $this->GetY(), 137, $this->GetY(), $style);

			}
			elseif ($ls_tipo=='3')
			{
				$w=array(137,23,23,23,33,25,20,20,21,20);
				$this->Ln(3);
				$this->SetFont("helvetica","B",8);
				$this->Line(351, $this->GetY(), 133, $this->GetY(), $style);
			}

		}
		else
		{
			$w=array(74,25,25,25,30,27,25,25,25,25);
			if (($ls_tipo=='1'))
			{
				$this->Line(320, $this->GetY(), 74, $this->GetY(), $style);

			}
			elseif ($ls_tipo=='3')
			{
				$this->Ln(3);
				$this->SetFont("helvetica","B",8);
				$this->Line(320, $this->GetY(), 74, $this->GetY(), $style);

			}

		}

		foreach($la_data as $row)
		{
			if ($y!=0)
			{
				$this->MultiCell($w[0],6,$row[0],'0','R', 0, 0, 0 ,0, true, 0);

			}
			else
			{
				$this->MultiCell($w[0],6,$row[0],'0','R', 0, 0, 0 ,$y, true, 0);
			}
			$this->Cell($w[1],6,$row[1],'0',0,'R',0);
			$this->Cell($w[2],6,$row[2],'0',0,'R',0);
			$this->Cell($w[3],6,$row[3],'0',0,'R',0);
			$this->Cell($w[4],6,$row[4],'0',0,'R',0);
			$this->Cell($w[5],6,$row[5],'0',0,'R',0);
			$this->Cell($w[6],6,$row[6],'0',0,'R',0);
			$this->Cell($w[7],6,$row[7],'0',0,'R',0);
			$this->Cell($w[8],6,$row[8],'0',0,'R',0);
			$this->Cell($w[9],6,$row[9],'0',0,'R',0);
			$this->Ln();

		}
		unset($style);
		unset($w);
	}



	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	//////////  F U N C I O N E S    P A R A    E L    A C U M U L A D O    P O R    C U E N T A S  //////////

	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	//--------------------------------------------------------------------------------------------------------------------------------

	public function uf_print_cabecera_acumulado()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_cabecera_acumulado
		//		    Acess: private
		//    Description: funcion que imprime el detalle
		//	   Creado Por: Ing. Mara Beatriz Unda
		// Fecha Creacion: 13/08/08
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$w=array(22,70,22,23,23,21,23,24,23,27,23,23,22);
		$this->SetFont("helvetica","B",7);
		$style1 = array("width" => 0.1, "cap" => "round", "join" => "round", "dash" => "0", "color" => array(0, 0, 0));

		$header=array('Cuenta','Denominacion','Asignado','Aumento','Disminucion','Monto Mensual Actualizado','Monto Acum. Actualizado','Pre Comprometido','Comprometido','Saldo por Comprometer','Causado','Pagado','Por Pagar');
		for($i=0;$i<count($header);$i++)
		{
			if ($i==0)
			{
				$this->MultiCell($w[$i],6,$header[$i],0,'C', 0, 0, 0 ,0, true, 0);

			}
			elseif ($i==1)
			{
				$this->MultiCell($w[$i],6,$header[$i],0,'L', 0, 0, 0 ,0, true, 0);
			}
			else
			{
				$this->MultiCell($w[$i],6,$header[$i],0,'R', 0, 0, 0 ,0, true, 0);
			}
		}

		$this->Line(349, $this->GetY()+8, 8, $this->GetY()+8, $style1);
		$this->Ln();
		$this->Ln();
		unset($style1);
		unset($w);
	}

	public function uf_print_cabecera_acumulado_fonpyme()
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_cabecera_acumulado
		//		    Acess: private
		//    Description: funcion que imprime el detalle
		//	   Creado Por: Ing. Mara Beatriz Unda
		// Fecha Creacion: 13/08/08
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$w=array(50,91,40,40,40,40);
		$this->SetFont("helvetica","B",7);
		$style1 = array("width" => 0.1, "cap" => "round", "join" => "round", "dash" => "0", "color" => array(0, 0, 0));

		$header=array('Cuenta','Denominacion','Pre Comprometido','Comprometido','Causado','Pagado');
		for($i=0;$i<count($header);$i++)
		{
			if ($i==0)
			{
				$this->MultiCell($w[$i],6,$header[$i],0,'C', 0, 0, 0 ,0, true, 0);

			}
			elseif ($i==1)
			{
				$this->MultiCell($w[$i],6,$header[$i],0,'L', 0, 0, 0 ,0, true, 0);
			}
			else
			{
				$this->MultiCell($w[$i],6,$header[$i],0,'R', 0, 0, 0 ,0, true, 0);
			}
		}

		$this->Line(349, $this->GetY()+8, 8, $this->GetY()+8, $style1);
		$this->Ln();
		$this->Ln();
		unset($style1);
		unset($w);
	}

	//--------------------------------------------------------------------------------------------------------------------------------

	public function uf_print_detalle_acumulado($la_data)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_detalle_acumulado
		//		    Acess: private
		//	    Arguments: la_data // arreglo de informacion
		//    Description: funcion que imprime el detalle
		//	   Creado Por: Ing. Yozelin Barragn
		// Fecha Creacion: 10/05/2006
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$fill=0;
		$w=array(22,70,22,23,23,21,23,24,23,27,23,23,22);

		$y=0;

		foreach($la_data as $row)
		{
			$this->SetFont("helvetica","",7);
			if ($y!=0)
			{
				$this->MultiCell($w[0],6,$row[0],0,'C', 0, 0, 0 ,$y, true, 0,true);
			}
			else
			{
				$this->MultiCell($w[0],6,$row[0],0,'C', 0, 0, 0 ,0, true, 0,true);
			}
			$this->MultiCell($w[1],6,strtolower($row[1]),0,'L', 0, 0, 0 ,0, true, 0);
			$y=($this->getY() + 8);
			$this->MultiCell($w[2],6,$row[2],0,'R', 0, 0, 0 ,0, true, 0,true);
			$this->MultiCell($w[3],6,$row[3],0,'R', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[4],6,$row[4],0,'R', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[5],6,$row[5],0,'R', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[6],6,$row[6],0,'R', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[7],6,$row[7],0,'R', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[8],6,$row[8],0,'R', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[9],6,$row[9],0,'R', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[10],6,$row[10],0,'R', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[11],6,$row[11],0,'R', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[12],6,$row[12],0,'R', 0, 0, 0 ,0, true, 0);
			$this->Ln();
		}
	}

	public function uf_print_detalle_acumulado_fonpyme($la_data){
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_detalle_acumulado
		//		    Acess: private
		//	    Arguments: la_data // arreglo de informacion
		//    Description: funcion que imprime el detalle
		//	   Creado Por: Ing. Yozelin Barragn
		// Fecha Creacion: 10/05/2006
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$fill=0;
		$w=array(50,91,40,40,40,40);

		$y=0;

		foreach($la_data as $row){
			$this->SetFont("helvetica","",7);
			if ($y!=0){
				$this->MultiCell($w[0],6,$row[0],0,'C', 0, 0, 0 ,$y, true, 0,true);
			}
			else{
				$this->MultiCell($w[0],6,$row[0],0,'C', 0, 0, 0 ,0, true, 0,true);
			}
				
			$this->MultiCell($w[1],6,strtolower($row[1]),0,'L', 0, 0, 0 ,0, true, 0);
			$y =($this->getY() + 8);
			$this->MultiCell($w[2],6,$row[2],0,'R', 0, 0, 0 ,0, true, 0,true);
			$this->MultiCell($w[3],6,$row[3],0,'R', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[4],6,$row[4],0,'R', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[5],6,$row[5],0,'R', 0, 0, 0 ,0, true, 0);
			$this->Ln();
		}
	}


	public function uf_print_detalle_acumulado2($la_data)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_detalle_acumulado
		//		    Acess: private
		//	    Arguments: la_data // arreglo de informacion
		//    Description: funcion que imprime el detalle
		//	   Creado Por: Ing. Yozelin Barragn
		// Fecha Creacion: 10/05/2006
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$fill=0;
		$w=array(22,91,22,23,23,23,24,23,27,23,23,22);

		$y=0;

		foreach($la_data as $row)
		{
			$this->SetFont("helvetica","",8);
			if ($y!=0)
			{

				if($row[12]=='S')
				{
					$this->SetFont("helvetica","B",8);
				}
				else
				{
					$this->SetFont("helvetica","",8);
				}

				$this->MultiCell($w[0],6,$row[0],0,'C', 0, 0, 0 ,$y, true, 0,true);
			}
			else
			{
				if($row[12]=='S')
				{
					$this->SetFont("helvetica","B",8);
				}
				else
				{
					$this->SetFont("helvetica","",8);
				}
				$this->MultiCell($w[0],6,$row[0],0,'C', 0, 0, 0 ,0, true, 0,true);
			}
			$this->SetFont("helvetica","",7);
			$this->MultiCell($w[1],6,strtolower($row[1]),0,'L', 0, 0, 0 ,0, true, 0);
			$y=($this->getY() + 8);
			$this->MultiCell($w[2],6,$row[2],0,'R', 0, 0, 0 ,0, true, 0,true);
			$this->MultiCell($w[3],6,$row[3],0,'R', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[4],6,$row[4],0,'R', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[5],6,$row[5],0,'R', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[6],6,$row[6],0,'R', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[7],6,$row[7],0,'R', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[8],6,$row[8],0,'R', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[9],6,$row[9],0,'R', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[10],6,$row[10],0,'R', 0, 0, 0 ,0, true, 0);
			$this->MultiCell($w[10],6,$row[11],0,'R', 0, 0, 0 ,0, true, 0);
			$this->Ln();
		}
	}




	//--------------------------------------------------------------------------------------------------------------------------------

	public	function uf_print_total_acumulado($la_data)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_total_acumulado
		//		    Acess: private
		//	    Arguments: la_data // arreglo de informacion
		//    Description: funcion que imprime el detalle
		//	   Creado Por: Ing. Yozelin Barragn
		// Fecha Creacion: 10/05/2006
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$this->SetFont("helvetica","B",7);
		$w=array(92,22,23,23,21,23,24,23,27,23,23,22);
		$style = array("width" => 0.1, "cap" => "round", "join" => "round", "dash" => "2,10", "color" => array(0, 0, 0));
		$this->Line(347, $this->GetY(), 108, $this->GetY(), $style);
		foreach($la_data as $row)
		{
			$this->Cell($w[0],6,$row[0],0,0,'R',0);
			$this->Cell($w[1],6,$row[1],0,0,'R',0);
			$this->Cell($w[2],6,$row[2],0,0,'R',0);
			$this->Cell($w[3],6,$row[3],0,0,'R',0);
			$this->Cell($w[4],6,$row[4],0,0,'R',0);
			$this->Cell($w[5],6,$row[5],0,0,'R',0);
			$this->Cell($w[6],6,$row[6],0,0,'R',0);
			$this->Cell($w[7],6,$row[7],0,0,'R',0);
			$this->Cell($w[8],6,$row[8],0,0,'R',0);
			$this->Cell($w[9],6,$row[9],0,0,'R',0);
			$this->Cell($w[10],6,$row[10],0,0,'R',0);
			$this->Cell($w[11],6,$row[11],0,0,'R',0);
			$this->Ln();

		}
		unset($w);
		unset($style);
	}

	public	function uf_print_total_acumulado_fonpyme($la_data)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_total_acumulado
		//		    Acess: private
		//	    Arguments: la_data // arreglo de informacion
		//    Description: funcion que imprime el detalle
		//	   Creado Por: Ing. Yozelin Barragn
		// Fecha Creacion: 10/05/2006
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$this->SetFont("helvetica","B",7);
		$w=array(145,40,40,40,40,40);
		$style = array("width" => 0.1, "cap" => "round", "join" => "round", "dash" => "2,10", "color" => array(0, 0, 0));
		$this->Line(347, $this->GetY(), 108, $this->GetY(), $style);
		foreach($la_data as $row)
		{
			$this->Cell($w[0],6,$row[0],0,0,'R',0);
			$this->Cell($w[1],6,$row[1],0,0,'R',0);
			$this->Cell($w[2],6,$row[2],0,0,'R',0);
			$this->Cell($w[3],6,$row[3],0,0,'R',0);
			$this->Cell($w[4],6,$row[4],0,0,'R',0);
			$this->Ln();

		}
		unset($w);
		unset($style);
	}

	//--------------------------------------------------------------------------------------------------------------------------------





	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
}

?>
