<?php
class sigesp_spg_class_reportes_instructivo_06
{
	var $io_mensajes;
	var $io_fecha;
	var $io_sigesp_int_spg;
	var $io_sql;
	var $ls_codemp;
	var $ls_gestor;
	var $li_estmodest;
	var $sqlca;
	var $is_msg_error;
	var $dts_empresa;
	var $dts_reporte;
	var $dts_cab;
	var $obj="";
	var $SQL;
	var $siginc;
	var $con;
	var $fun;

	//-----------------------------------------------------------------------------------------------------------------------------------

	//-----------------------------------------------------------------------------------------------------------------------------------
	function  sigesp_spg_class_reportes_instructivo_06()
	{
		require_once("../../../shared/class_folder/sigesp_include.php");
		require_once("../../../shared/class_folder/class_sql.php");
		require_once("../../../shared/class_folder/class_fecha.php");
		require_once("../../../shared/class_folder/class_funciones.php");
		require_once("../../../shared/class_folder/class_mensajes.php");
		require_once("../../../shared/class_folder/class_datastore.php");
		require_once("../../../shared/class_folder/class_sigesp_int.php");
		require_once("../../../shared/class_folder/class_sigesp_int_scg.php");
		require_once("../../../shared/class_folder/class_sigesp_int_spg.php");
		require_once("../../../shared/class_folder/class_sigesp_int_spi.php");

		$this->io_funciones = new class_funciones() ;
		$this->io_include = new sigesp_include();
		$this->io_conexion = $this->io_include->uf_conectar();
		$this->io_sql = new class_sql($this->io_conexion);
		$this->dts_reporte = new class_datastore();
		$this->io_sigesp_int_spg = new class_sigesp_int_spg();
		$this->io_sigesp_int_spi = new class_sigesp_int_spi();
		$this->io_fecha = new class_fecha();
		$this->io_mensajes = new class_mensajes();
		$this->ls_codemp = $_SESSION["la_empresa"]["codemp"];
		$this->ls_gestor = $_SESSION["ls_gestor"];
		$this->li_estmodest=$_SESSION["la_empresa"]["estmodest"];
		$this->dts_empresa=$_SESSION["la_empresa"];
		$this->loncodestpro1 = $_SESSION["la_empresa"]["loncodestpro1"];
		$this->loncodestpro2 = $_SESSION["la_empresa"]["loncodestpro2"];
	}
	//-----------------------------------------------------------------------------------------------------------------------------------


	//-----------------------------------------------------------------------------------------------------------------------------------
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//   CLASE REPORTES SPG  INSTRUCTIVO 06  - INFORMACION MENSUAL DE LA EJECUCION FINANCIERA                            //
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	function uf_spg_ejecutado_mensual($as_codestpro1,$as_codestpro2,$as_spg_cuenta,$adt_fecdes,$adt_fechas,$ad_comprometer,$ad_causado,$ad_pagado,$ad_aumento,$ad_disminucion)
	{///////////////////////////////////////////////////////////////////////////////////////////////////////
	 //	      Function :	uf_spg_ejecutado_mensual
	 //         Access :	private
	 //     Argumentos :    $as_codestpro1  -----> Codigo del Proyecto o Accion
	 //                     $as_codestpro2  -----> Codigo de la Acccion Especfica
	 //                     $adt_fechas     -----> Fecha hasta
	 //                     $ad_comprometer_acumulado  -----> monto comprometer referencia
	 //                     $ad_causado_acumulado  -----> monto causado referencia
	 //                     $ad_pagado_acumulado  -----> monto pagado referencia
	 //                     $ad_aumento_acumulado  -----> monto aumento referencia
	 //                     $ad_disminucion_acumulado  -----> monto disminucion referencia
		//	       Returns :	Retorna true o false si se realizo la consulta para el reporte
	 //	   Description :	Reporte que genera los ejcutados por mes
	 //     Creado por :    Ing. Arnaldo Surez
	 // Fecha Creacion :    16/10/2008          Fecha ltima Modificacion :      Hora :
		////////////////////////////////////////////////////////////////////////////////////////////////////////
	 $lb_valido = true;
	 $ad_comprometer = 0;
	 $ad_causado     = 0;
	 $ad_pagado      = 0;
	 $ad_aumento     = 0;
	 $ad_disminucion = 0;
	 $ls_cadena_ep1  = "";
	 $ls_cadena_ep2  = "";
	 $ls_cadena_spg  = "";
	 if (!empty($as_codestpro1))
	 {
	  $ls_cadena_ep1 = " AND DT.codestpro1 = '".$as_codestpro1."' ";
	 }
	 if (!empty($as_codestpro2))
	 {
	  $ls_cadena_ep2 = " AND DT.codestpro2 = '".$as_codestpro2."' ";
	 }
	 if (!empty($as_spg_cuenta))
	 {
	 	$as_spg_cuenta = $this->io_sigesp_int_spg->uf_spg_cuenta_sin_cero($as_spg_cuenta)."%";
	 	$ls_cadena_spg=" AND spg_cuenta like '".$as_spg_cuenta."' ";
	 }
	 $ls_sql = " SELECT DT.monto, OP.aumento, OP.disminucion, ".
               "        OP.precomprometer,OP.comprometer, ".
               "        OP.causar, OP.pagar ".
               " FROM   spg_dt_cmp DT, spg_operaciones OP ".
               " WHERE  DT.codemp='".$this->ls_codemp."' AND ".
               "        DT.operacion = OP.operacion AND ".
			   "        fecha BETWEEN '".$adt_fecdes."' AND  '".$adt_fechas."' ".
	 $ls_cadena_ep1." ".$ls_cadena_ep2." ".$ls_cadena_spg;
//echo $ls_sql;die();

	 $rs_ejecutado=$this->io_sql->select($ls_sql);
	 if($rs_ejecutado===false)
	 { // error interno sql
			$this->io_mensajes->message("CLASE->sigesp_spg_class_reportes_instructivo_06 ".
			                            "MTODO->uf_spg_ejecutado_mensual ".
										"ERROR->".$this->io_funciones->uf_convertirmsg($this->io_sql->message)); 
			$lb_valido = false;
	 }
	 else
	 {
	 	while($row=$this->io_sql->fetch_row($rs_ejecutado))
	 	{
		  $li_aumento=$row["aumento"];
		  $li_disminucion=$row["disminucion"];
		  $li_precomprometer=$row["precomprometer"];
		  $li_comprometer=$row["comprometer"];
		  $li_causar=$row["causar"];
		  $li_pagar=$row["pagar"];
		  $ld_monto=$row["monto"];

		  if($li_comprometer)
		  {
		  	$ad_comprometer=$ad_comprometer+$ld_monto;
		  }//if
		  if($li_causar)
		  {
		  	$ad_causado=$ad_causado+$ld_monto;
		  }//if
		  if($li_pagar)
		  {
		  	$ad_pagado=$ad_pagado+$ld_monto;
		  }//if
		  if($li_aumento)
		  {
		  	$ad_aumento=$ad_aumento+$ld_monto;
		  }//if
		  if($li_disminucion)
		  {
		  	$ad_disminucion=$ad_disminucion+$ld_monto;
		  }//if
	 	}// while
	 	$this->io_sql->free_result($rs_ejecutado);
	 }//else
		$arrResultado['ad_comprometer']=$ad_comprometer;
		$arrResultado['ad_causado']=$ad_causado;
		$arrResultado['ad_pagado']=$ad_pagado;
		$arrResultado['ad_aumento']=$ad_aumento;
		$arrResultado['ad_disminucion']=$ad_disminucion;
		$arrResultado['lb_valido']=$lb_valido;
		return $arrResultado;		
	}//fin uf_spg_ejecutado_trimestral
	//-----------------------------------------------------------------------------------------------------------------------------------

	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_spg_ejecutado_acumulado($as_codestpro1,$as_codestpro2,$as_spg_cuenta,$adt_fechas,$ad_comprometer_acumulado,$ad_causado_acumulado,$ad_pagado_acumulado,$ad_aumento_acumulado,$ad_disminucion_acumulado)
	{///////////////////////////////////////////////////////////////////////////////////////////////////////
	 //	      Function :	uf_spg_ejecutado_acumulado
	 //         Access :	private
	 //     Argumentos :    $as_spg_cuenta  -----> cuenta
	 //                     $adt_fechas  -----> fechas hasta
	 //                     $ad_comprometer_acumulado  -----> monto acumulado comprometer referencia
	 //                     $ad_causado_acumulado  -----> monto acumulado causado referencia
	 //                     $ad_pagado_acumulado  -----> monto acumulado pagado referencia
	 //                     $ad_aumento_acumulado  -----> monto acumulado aumento referencia
	 //                     $ad_disminucion_acumulado  -----> monto acumulado disminucion referencia
		//	       Returns :	Retorna true o false si se realizo la consulta para el reporte
	 //	   Description :	Reporte que genera los eejcutados por trimestre
	 //     Creado por :    Ing. Arnaldo Surez
	 // Fecha Creacion :    18/05/2008          Fecha ltima Modificacion :      Hora :
		////////////////////////////////////////////////////////////////////////////////////////////////////////
	 $lb_valido = true;
	 $ls_cadena_ep1  = "";
	 $ls_cadena_ep2  = "";
	 $ls_cadena_spg  = "";
	 if (!empty($as_codestpro1))
	 {
	  $ls_cadena_ep1 = " AND DT.codestpro1 = '".$as_codestpro1."' ";
	 }
	 if (!empty($as_codestpro2))
	 {
	  $ls_cadena_ep2 = " AND DT.codestpro2 = '".$as_codestpro2."' ";
	 }
	 if (!empty($as_spg_cuenta))
	 {
	 	$as_spg_cuenta = $this->io_sigesp_int_spg->uf_spg_cuenta_sin_cero($as_spg_cuenta)."%";
	 	$ls_cadena_spg=" AND spg_cuenta like '".$as_spg_cuenta."' ";
	 }
	 $ls_sql = " SELECT DT.monto, OP.aumento, OP.disminucion, ".
               "        OP.precomprometer,OP.comprometer, ".
               "        OP.causar, OP.pagar ".
               " FROM   spg_dt_cmp DT, spg_operaciones OP ".
               " WHERE  DT.codemp='".$this->ls_codemp."' AND ".
               "        DT.operacion = OP.operacion AND ".
			   "        fecha <='".$adt_fechas."' ".
	 $ls_cadena_ep1." ".$ls_cadena_ep2." ".$ls_cadena_spg;

	 $rs_ejecutado=$this->io_sql->select($ls_sql);
	 if($rs_ejecutado===false)
	 { // error interno sql
	 	$this->io_mensajes->message("CLASE->sigesp_spg_class_reportes_instructivo_06 ".
			                        "MTODO->uf_spg_ejecutado_acumulado ".
									"ERROR->".$this->io_funciones->uf_convertirmsg($this->io_sql->message)); 
	 	$lb_valido = false;
	 }
	 else
	 {
	 	while($row=$this->io_sql->fetch_row($rs_ejecutado))
	 	{
		  $li_aumento=$row["aumento"];
		  $li_disminucion=$row["disminucion"];
		  $li_precomprometer=$row["precomprometer"];
		  $li_comprometer=$row["comprometer"];
		  $li_causar=$row["causar"];
		  $li_pagar=$row["pagar"];
		  $ld_monto=$row["monto"];

		  if($li_comprometer)
		  {
		  	$ad_comprometer_acumulado=$ad_comprometer_acumulado+$ld_monto;
		  }//if
		  if($li_causar)
		  {
		  	$ad_causado_acumulado=$ad_causado_acumulado+$ld_monto;
		  }//if
		  if($li_pagar)
		  {
		  	$ad_pagado_acumulado=$ad_pagado_acumulado+$ld_monto;
		  }//if
		  if($li_aumento)
		  {
		  	$ad_aumento_acumulado=$ad_aumento_acumulado+$ld_monto;
		  }//if
		  if($li_disminucion)
		  {
		  	$ad_disminucion_acumulado=$ad_disminucion_acumulado+$ld_monto;
		  }//if
	 	}// while
	 	$this->io_sql->free_result($rs_ejecutado);
	 }//else
		$arrResultado['ad_comprometer_acumulado']=$ad_comprometer_acumulado;
		$arrResultado['ad_causado_acumulado']=$ad_causado_acumulado;
		$arrResultado['ad_pagado_acumulado']=$ad_pagado_acumulado;
		$arrResultado['ad_aumento_acumulado']=$ad_aumento_acumulado;
		$arrResultado['ad_disminucion_acumulado']=$ad_disminucion_acumulado;
		$arrResultado['lb_valido']=$lb_valido;
		return $arrResultado;		
	}//fin uf_spg_ejecutado_acumulado
	//----------------------------------------------------------------------------------------------------------------------------------
	//-----------------------------------------------------------------------------------------------------------------------------------
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//   CLASE REPORTES SPG  OTROS EDO. EJECUCIN DEL PRESUPUESTO                              //
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	function uf_spg_reporte_informacion_mensual_eje_pre($adt_fecdes,$adt_fechas,$as_nivel)
	{///////////////////////////////////////////////////////////////////////////////////////////////////////
	 //	      Function :	uf_spg_reporte_informacion_mensual_eje_pre
	 //         Access :	private
	 //     Argumentos :    $adt_fecdes  -----> fechas desde
	 //                     $adt_fechas  -----> fechas hasta
		//	       Returns :	Retorna true o false si se realizo la consulta para el reporte
	 //	   Description :	Reporte que genera salida  del Estado de la ejecucin del presupuesto 
	 //     Creado por :    Ing. Arnaldo Surez
	 // Fecha Creacion :    28/10/2008          Fecha ltima Modificacion :      Hora :
		////////////////////////////////////////////////////////////////////////////////////////////////////////
	 $lb_valido = true;
	 $ai_mes = intval(substr($adt_fechas,5,2));
	 if($as_nivel == 'C')
	 {
	  $ls_cadena = " AND spg_cuentas.nivel = 1 ";
	 }
	 else
	 {
	  $ls_cadena = " AND spg_cuentas.nivel <= 4";
	 }
	 $ls_sql=" SELECT  spg_cuentas.codestpro1, spg_cuentas.spg_cuenta, MIN(spg_cuentas.denominacion) as denominacion, MAX(spg_cuentas.status) as status, sum(spg_cuentas.asignado) as asignado, ".
	         "         sum(spg_cuentas.enero) as enero, sum(spg_cuentas.febrero) as febrero , ".
       		 "	       sum(spg_cuentas.marzo) as marzo, sum(spg_cuentas.abril) as abril, sum(spg_cuentas.mayo) as mayo, sum(spg_cuentas.junio) as junio, ".
             "         sum(spg_cuentas.julio) as julio, sum(spg_cuentas.agosto) as agosto, sum(spg_cuentas.septiembre) as septiembre,  ".
             "         sum(spg_cuentas.octubre) as octubre, sum(spg_cuentas.noviembre) as noviembre, sum(spg_cuentas.diciembre) as diciembre  ".
             "     FROM spg_cuentas, spg_ep1 ".                                                                    
             "        WHERE spg_cuentas.codemp='".$this->ls_codemp."'  ".
	 $ls_cadena.
			 " 			  AND spg_cuentas.codemp = spg_ep1.codemp  ".
			 "			  AND spg_cuentas.codestpro1 = spg_ep1.codestpro1 ".
			 "			  GROUP BY spg_cuentas.codestpro1, spg_cuentas.spg_cuenta ".                                                               
			 "			  ORDER BY spg_cuentas.codestpro1, spg_cuentas.spg_cuenta ";

//echo $ls_sql;die();
	 $rs_data=$this->io_sql->select($ls_sql);
	 if($rs_data===false)
	 {   // error interno sql
			$this->io_mensajes->message("CLASE->sigesp_spg_class_reportes_instructivo_06 ".
			                            "MTODO->uf_spg_reporte_informacion_mensual_eje_pre ".
										"ERROR->".$this->io_funciones->uf_convertirmsg($this->io_sql->message)); 
			$lb_valido = false;
	 }
	 else
	 {
	 	$li_numrows=$this->io_sql->num_rows($rs_data);
	 	if($li_numrows>=0)
	 	{
	 		while($row=$this->io_sql->fetch_row($rs_data))
			 {
			 	$ld_programado_mensual   = 0;
			 	$ld_programado_acumulado = 0;
			 	$ld_ejecutado_mens_comp  = 0;
			 	$ld_ejecutado_mens_caus  = 0;
			 	$ld_ejecutado_mens_paga  = 0;
			 	$ld_ejecutado_mens_aume  = 0;
			 	$ld_ejecutado_mens_dism  = 0;
			 	$ld_ejecutado_acum_comp  = 0;
			 	$ld_ejecutado_acum_caus  = 0;
			 	$ld_ejecutado_acum_paga  = 0;
			 	$ld_ejecutado_acum_aume  = 0;
			 	$ld_ejecutado_acum_dism  = 0;
			 	$ld_variacion_comp       = 0;
			 	$ld_variacion_caus       = 0;
			 	$ld_prevision_prox_mes   = 0;
			 	$ls_codestpro1   =  $row["codestpro1"];
			 	$ls_denominacion =  $row["denominacion"];
			 	$ls_spg_cuenta   =  $row["spg_cuenta"];
			 	$ls_status       =  $row["status"];
			 	$ld_asignado     =  $row["asignado"];
			 	$ld_enero        =  $row["enero"];
			 	$ld_febrero      =  $row["febrero"];
			 	$ld_marzo	    =  $row["marzo"];
			 	$ld_abril	    =  $row["abril"];
			 	$ld_mayo	        =  $row["mayo"];
			 	$ld_junio	    =  $row["junio"];
			 	$ld_julio	    =  $row["julio"];
			 	$ld_agosto	    =  $row["agosto"];
			 	$ld_septiembre   =  $row["septiembre"];
			 	$ld_octubre      =  $row["octubre"];
			 	$ld_noviembre    =  $row["noviembre"];
			 	$ld_diciembre    =  $row["diciembre"];

			 	$arrResultado=$this->uf_spg_ejecutado_mensual($ls_codestpro1,"",$ls_spg_cuenta,$adt_fecdes,$adt_fechas,$ld_ejecutado_mens_comp,
			 	$ld_ejecutado_mens_caus,$ld_ejecutado_mens_paga,$ld_ejecutado_mens_aume,$ld_ejecutado_mens_dism);
				$ld_ejecutado_mens_comp=$arrResultado['ad_comprometer'];
				$ld_ejecutado_mens_caus=$arrResultado['ad_causado'];
				$ld_ejecutado_mens_paga=$arrResultado['ad_pagado'];
				$ld_ejecutado_mens_aume=$arrResultado['ad_aumento'];
				$ld_ejecutado_mens_dism=$arrResultado['ad_disminucion'];
				$lb_valido=$arrResultado['lb_valido'];
			 	if($lb_valido)
			 	{
			 		$arrResultado=$this->uf_spg_ejecutado_acumulado($ls_codestpro1,"",$ls_spg_cuenta,$adt_fechas,$ld_ejecutado_acum_comp,
			 		$ld_ejecutado_acum_caus,$ld_ejecutado_acum_paga,$ld_ejecutado_acum_aume,
			 		$ld_ejecutado_acum_dism);
					$ld_ejecutado_acum_comp=$arrResultado['ad_comprometer_acumulado'];
					$ld_ejecutado_acum_caus=$arrResultado['ad_causado_acumulado'];
					$ld_ejecutado_acum_paga=$arrResultado['ad_pagado_acumulado'];
					$ld_ejecutado_acum_aume=$arrResultado['ad_aumento_acumulado'];
					$ld_ejecutado_acum_dism=$arrResultado['ad_disminucion_acumulado'];
					$lb_valido=$arrResultado['lb_valido'];
					
			 	}//if
			 	switch($ai_mes)
			 	{
			 		case 1  : $ld_programado_mensual   = $ld_enero;
			 		$ld_programado_acumulado = $ld_enero;
			 		$ld_prevision_prox_mes   = $ld_febrero;
			 		break;

			 		case 2  : $ld_programado_mensual   = $ld_febrero;
			 		$ld_programado_acumulado = $ld_enero + $ld_febrero;
			 		$ld_prevision_prox_mes   = $ld_marzo;
			 		break;

			 		case 3  : $ld_programado_mensual   = $ld_marzo;
			 		$ld_programado_acumulado = $ld_enero + $ld_febrero + $ld_marzo;
			 		$ld_prevision_prox_mes   = $ld_abril;
			 		break;

			 		case 4  : $ld_programado_mensual   = $ld_abril;
			 		$ld_programado_acumulado = $ld_enero + $ld_febrero + $ld_marzo + $ld_abril;
			 		$ld_prevision_prox_mes   = $ld_mayo;
			 		break;

			 		case 5 :  $ld_programado_mensual   = $ld_mayo;
			 		$ld_programado_acumulado = $ld_enero + $ld_febrero + $ld_marzo + $ld_abril + $ld_mayo;
			 		$ld_prevision_prox_mes   = $ld_junio;
			 		break;

			 		case 6 :  $ld_programado_mensual   = $ld_junio;
			 		$ld_programado_acumulado = $ld_enero + $ld_febrero + $ld_marzo + $ld_abril + $ld_mayo + $ld_junio;
			 		$ld_prevision_prox_mes   = $ld_julio;
			 		break;

			 		case 7 :  $ld_programado_mensual   = $ld_julio;
			 		$ld_programado_acumulado = $ld_enero + $ld_febrero + $ld_marzo + $ld_abril + $ld_mayo + $ld_junio + $ld_julio;
			 		$ld_prevision_prox_mes   = $ld_agosto;
			 		break;

			 		case 8 :  $ld_programado_mensual   = $ld_agosto;
			 		$ld_programado_acumulado = $ld_enero + $ld_febrero + $ld_marzo + $ld_abril + $ld_mayo + $ld_junio + $ld_julio + $ld_agosto;
			 		$ld_prevision_prox_mes   = $ld_septiembre;
			 		break;

			 		case 9 :  $ld_programado_mensual   = $ld_septiembre;
			 		$ld_programado_acumulado = $ld_enero + $ld_febrero + $ld_marzo + $ld_abril + $ld_mayo + $ld_junio + $ld_julio + $ld_agosto + $ld_septiembre;
			 		$ld_prevision_prox_mes   = $ld_octubre;
			 		break;

			 		case 10 : $ld_programado_mensual   = $ld_octubre;
			 		$ld_programado_acumulado = $ld_enero + $ld_febrero + $ld_marzo + $ld_abril + $ld_mayo + $ld_junio + $ld_julio + $ld_agosto + $ld_septiembre + $ld_octubre;
			 		$ld_prevision_prox_mes   = $ld_noviembre;
			 		break;

			 		case 11 : $ld_programado_mensual   = $ld_noviembre;
			 		$ld_programado_acumulado = $ld_enero + $ld_febrero + $ld_marzo + $ld_abril + $ld_mayo + $ld_junio + $ld_julio + $ld_agosto + $ld_septiembre + $ld_octubre + $ld_noviembre;
			 		$ld_prevision_prox_mes   = $ld_diciembre;
			 		break;

			 		case 12 : $ld_programado_mensual   = $ld_diciembre;
			 		$ld_programado_acumulado = $ld_enero + $ld_febrero + $ld_marzo + $ld_abril + $ld_mayo + $ld_junio + $ld_julio + $ld_agosto + $ld_septiembre + $ld_octubre + $ld_noviembre + $ld_diciembre;
			 		$ld_prevision_prox_mes   = 0;
			 		break;
			 	}

//AGREGADO
   $as_ano=substr($adt_fecdes,0,4);
   $as_mes = substr($adt_fecdes,5,2);
   $oper="=";
   $arrResultado=$this->uf_spg_reporte_detalle_ejecucion_financiera_mensual($ls_spg_cuenta,$ls_codestpro1,$as_ano, $as_mes, $oper);
   $arrResultado=$this->uf_spg_reporte_detalle_causado_no_pagado($ls_spg_cuenta,$ls_codestpro1,$as_ano, $as_mes, $oper);
   $arrResultado=$this->uf_spg_reporte_detalle_incremento_deduccion($ls_spg_cuenta,$ls_codestpro1,$as_ano, $as_mes, $oper);
   $oper="<=";
   $arrResultado=$this->uf_spg_reporte_detalle_ejecucion_financiera_mensual($ls_spg_cuenta,$ls_codestpro1,$as_ano, $as_mes, $oper);
   $arrResultado=$this->uf_spg_reporte_detalle_causado_no_pagado($ls_spg_cuenta,$ls_codestpro1,$as_ano, $as_mes, $oper);
   $arrResultado=$this->uf_spg_reporte_detalle_incremento_deduccion($ls_spg_cuenta,$ls_codestpro1,$as_ano, $as_mes, $oper);
//HASTA AQUI
			 	$ls_codigo=substr($ls_codestpro1,-$this->loncodestpro1);
			 	$this->dts_reporte->insertRow("codigo",$ls_codigo);
			 	$this->dts_reporte->insertRow("denominacion",$ls_denominacion);
			 	$this->dts_reporte->insertRow("asignado",$ld_asignado);
			 	$this->dts_reporte->insertRow("spg_cuenta",$ls_spg_cuenta);
			 	$this->dts_reporte->insertRow("status",$ls_status);
			 	$this->dts_reporte->insertRow("programado_mensual",$ld_programado_mensual);
			 	$this->dts_reporte->insertRow("programado_acumulado",$ld_programado_acumulado);
			 	$this->dts_reporte->insertRow("ejecutado_mens_comp",$ld_ejecutado_mens_comp);
			 	$this->dts_reporte->insertRow("ejecutado_mens_caus",$ld_ejecutado_mens_caus);
			 	$this->dts_reporte->insertRow("ejecutado_mens_paga",$ld_ejecutado_mens_paga);
			 	$this->dts_reporte->insertRow("ejecutado_acum_comp",$ld_ejecutado_acum_comp);
			 	$this->dts_reporte->insertRow("ejecutado_acum_caus",$ld_ejecutado_acum_caus);
			 	$this->dts_reporte->insertRow("ejecutado_acum_paga",$ld_ejecutado_acum_paga);
			 	$lb_valido=true;
			 }//while
	 	}//if
	 	$this->io_sql->free_result($rs_data);
	 }//else
	 return $lb_valido;
	}//fin uf_spg_reporte_informacion_mensual_eje_pre

   function uf_spg_reporte_detalle_ejecucion_financiera_mensual($as_spg_cuenta,$as_codestpro1,$as_ano, $as_mes, $oper)

	{

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	 //	      Function :	uf_spg_reporte_detalle_ejecucion_financiera_mensual
	 //         Access :	private
	 //     Argumentos :    as_codestpro1 ... $as_codestpro5 //rango nivel estructura presupuestaria origen
	 //                     as_spg_cuenta   // cuenta presupestaria
     //	       Returns :	Retorna estructuras ordenadas para la consulta sql
	 //	   Description :	Reporte que genera el reporte de la Ejecucion Financiara de Gasto
	 //     Creado por :    Ing. Arnaldo Surez
	 // Fecha Creacion :    16/03/09          Fecha ltima Modificacion :
  	 ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

		$lb_valido = true;

        $ls_sql=	" SELECT spg_dt_cmp.spg_cuenta,  ".
                  	" CASE WHEN  ".
					" (spg_dt_cmp.operacion = 'AU' AND spg_dt_cmp.procede_doc = 'SPGTRA') ". 
					" THEN sum(spg_dt_cmp.monto) ".
					" END as aumento, ".
			" CASE WHEN ".
					" (spg_dt_cmp.operacion = 'DI' AND spg_dt_cmp.procede_doc = 'SPGTRA') ". 
					" THEN sum(spg_dt_cmp.monto) ".
					" END as disminucion, ".
			" CASE spg_dt_cmp.operacion  ".
					" WHEN 'CCP' THEN sum(spg_dt_cmp.monto) ".
					" WHEN 'CG' THEN sum(spg_dt_cmp.monto) ".
					" WHEN 'CS' THEN sum(spg_dt_cmp.monto) ".
					" END as compromiso, ".
			" CASE spg_dt_cmp.operacion ".
					" WHEN 'CCP' THEN sum(spg_dt_cmp.monto) ".
					" WHEN 'CP' THEN sum(spg_dt_cmp.monto) ".
					" WHEN 'PG' THEN sum(spg_dt_cmp.monto) ".
					" END as pagado ".
                  	" FROM spg_dt_cmp  ".
					" WHERE spg_dt_cmp.spg_cuenta = '$as_spg_cuenta'".
					" AND DATE_PART('month',spg_dt_cmp.fecha) ".$oper." '$as_mes' AND DATE_PART('year',spg_dt_cmp.fecha) = '$as_ano' ".
					" GROUP BY spg_dt_cmp.spg_cuenta, spg_dt_cmp.operacion, spg_dt_cmp.procede_doc".
                  	" ORDER BY spg_dt_cmp.spg_cuenta ";
//echo $ls_sql;die();
	 	$rs_data2=$this->io_sql->select($ls_sql);
		if($rs_data2===false)
		{   //error interno sql
		   $this->io_msg->message("Error1 en Reporte Ejecucion Financiera Mensual ".$this->fun->uf_convertirmsg($this->SQL->message));
           	   $lb_valido = false;
		}
		else
		{
			$mod_pre_aum=0;
			$mod_pre_dis=0;
			$mod_pre_com=0;
			$mod_pre_pag=0;
			while($row=$this->io_sql->fetch_row($rs_data2))
			{
				$mod_pre_aum=$mod_pre_aum+$row['aumento'];
			 	$mod_pre_dis=$mod_pre_dis+$row['disminucion'];
				$mod_pre_com=$mod_pre_com+$row['compromiso'];
				$mod_pre_pag=$mod_pre_pag+$row['pagado'];
			}
			 switch($oper)
			 {
			 	case "="  :
					$this->dts_reporte->insertRow("mod_pre_mes_aum",$mod_pre_aum);
					$this->dts_reporte->insertRow("mod_pre_mes_dis",$mod_pre_dis);
					$this->dts_reporte->insertRow("mod_pre_mes_com",$mod_pre_com);
					$this->dts_reporte->insertRow("mod_pre_mes_pag",$mod_pre_pag);
			 		break;
			 	case "<="  :
					$this->dts_reporte->insertRow("mod_pre_acum_aum",$mod_pre_aum);
					$this->dts_reporte->insertRow("mod_pre_acum_dis",$mod_pre_dis);
					$this->dts_reporte->insertRow("mod_pre_acum_com",$mod_pre_com);
					$this->dts_reporte->insertRow("mod_pre_acum_pag",$mod_pre_pag);
			 		break;
			}
		}
	 $arrResultado['lb_valido']=$lb_valido;
	 return $arrResultado;
	}

   function uf_spg_reporte_detalle_causado_no_pagado($as_spg_cuenta,$as_codestpro1,$as_ano, $as_mes, $oper)

	{

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	 //	      Function :	uf_spg_reporte_detalle_causado_no_pagado
	 //         Access :	private
	 //     Argumentos :    as_codestpro1 ... $as_codestpro5 //rango nivel estructura presupuestaria origen
	 //                     as_spg_cuenta   // cuenta presupestaria
     //	       Returns :	Retorna estructuras ordenadas para la consulta sql
	 //	   Description :	Reporte que genera el reporte de Gasto causado no pagado
	 //     Creado por :    Ing. Arnaldo Surez
	 // Fecha Creacion :    16/03/09          Fecha ltima Modificacion :
  	 ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

		$lb_valido = true;

					//" GROUP BY spg_dt_cmp.spg_cuenta, spg_dt_cmp.operacion".

        $ls_sql=	" SELECT DISTINCT spg_dt_cmp.spg_cuenta, SUM(spg_dt_cmp.monto) AS deuda ".
                  	" FROM spg_dt_cmp, spg_operaciones  ".
					" WHERE spg_dt_cmp.operacion=spg_operaciones.operacion ". 
					" AND spg_operaciones.comprometer=1 AND spg_operaciones.pagar=0 ".
					" AND DATE_PART('month',spg_dt_cmp.fecha) ".$oper." '$as_mes' AND DATE_PART('year',spg_dt_cmp.fecha) = '$as_ano' ".
					" AND spg_dt_cmp.spg_cuenta = '$as_spg_cuenta'".
					" GROUP BY spg_dt_cmp.spg_cuenta, spg_dt_cmp.operacion".
                  	" ORDER BY spg_dt_cmp.spg_cuenta ";
//echo $ls_sql;die();
	 	$rs_data2=$this->io_sql->select($ls_sql);
		if($rs_data2===false)
		{   //error interno sql
		   $this->io_msg->message("Error1 en Reporte Ejecucion Financiera Mensual ".$this->fun->uf_convertirmsg($this->SQL->message));
           	   $lb_valido = false;
		}
		else
		{
			$deuda=0;
			while($row=$this->io_sql->fetch_row($rs_data2))
	 		{
			 	$deuda=$deuda+$row['deuda'];
			}
			 switch($oper)
			 {
			 	case "="  :
					$this->dts_reporte->insertRow("deuda_mes",$deuda);
			 		break;
			 	case "<="  :
					$this->dts_reporte->insertRow("deuda_acum",$deuda);
			 		break;
			}
		}
	 $arrResultado['lb_valido']=$lb_valido;
	 return $arrResultado;
	}

   function uf_spg_reporte_detalle_incremento_deduccion($as_spg_cuenta,$as_codestpro1,$as_ano, $as_mes, $oper)

	{

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	 //	      Function :	uf_spg_reporte_detalle_incremento_deduccion
	 //         Access :	private
	 //     Argumentos :    as_codestpro1 ... $as_codestpro5 //rango nivel estructura presupuestaria origen
	 //                     as_spg_cuenta   // cuenta presupestaria
     //	       Returns :	Retorna estructuras ordenadas para la consulta sql
	 //	   Description :	Reporte que genera el reporte de incrementos o deducciones
	 //     Creado por :    Ing. Arnaldo Surez
	 // Fecha Creacion :    16/03/09          Fecha ltima Modificacion :
  	 ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

		$lb_valido = true;
        $ls_sql=	" SELECT spg_dt_cmp.spg_cuenta, spg_dt_cmp.operacion, ".
        				" SUM(spg_dt_cmp.monto) AS monto ".
                  	" FROM spg_dt_cmp  ".
					" WHERE spg_dt_cmp.procede='SPGCRA' ". 
					" AND DATE_PART('month',spg_dt_cmp.fecha) ".$oper." '$as_mes' AND DATE_PART('year',spg_dt_cmp.fecha) = '$as_ano' ".
					" AND spg_dt_cmp.spg_cuenta = '$as_spg_cuenta'".
					" GROUP BY spg_dt_cmp.spg_cuenta, spg_dt_cmp.operacion".
                  	" ORDER BY spg_dt_cmp.spg_cuenta ";
//echo $ls_sql;die();
	 	$rs_data2=$this->io_sql->select($ls_sql);
		if($rs_data2===false)
		{   //error interno sql
		   $this->io_msg->message("Error1 en Reporte Ejecucion Financiera Mensual ".$this->fun->uf_convertirmsg($this->SQL->message));
           	   $lb_valido = false;
		}
		else
		{
			$monto=0;
			while($row=$this->io_sql->fetch_row($rs_data2))
	 		{
				$tipo_ope=$row['operacion'];
				if($tipo_ope='AU')
					$monto=$monto+$row['monto'];
				else
			 		$monto=$monto-$row['monto'];
			}
			 switch($oper)
			 {
			 	case "="  :
					$this->dts_reporte->insertRow("monto_mes",$monto);
			 		break;
			 	case "<="  :
					$this->dts_reporte->insertRow("monto_acum",$monto);
			 		break;
			}
		}
	 $arrResultado['lb_valido']=$lb_valido;
	 return $arrResultado;
	}

   function uf_spg_reporte_detalle_relacion_gastos($as_mes, $as_ano)

	{

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	 //	      Function :	uf_spg_reporte_detalle_relacion_gastos
	 //         Access :	private
	 //     Argumentos :    $as_ano, $as_mes //Mes rendido
     //	       Returns :	Retorna los gastos correspondientes al mes desde el mdulo de banco
	 //	   Description :	Reporte que genera los gastos correspondientes al mes desde el mdulo de banco
	 //     Creado por :    Ing. Arnaldo Surez
	 // Fecha Creacion :    16/03/09          Fecha ltima Modificacion :
  	 ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

		$lb_valido = true;
		$ls_sql	=	"SELECT spg_dt_cmp.spg_cuenta, spg_cuentas.denominacion, spg_dt_cmp.comprobante, ".
				" spg_dt_cmp.fecha, spg_dt_cmp.descripcion, (SELECT nompro FROM rpc_proveedor WHERE ".
				" cod_pro=sigesp_cmp.cod_pro) as proveedor, (SELECT nombene FROM rpc_beneficiario WHERE ".
				" ced_bene=sigesp_cmp.ced_bene) as beneficiario, spg_dt_cmp.monto, spg_dt_cmp.procede ".
				" FROM spg_dt_cmp, spg_cuentas, sigesp_cmp ".
				" WHERE spg_dt_cmp.codemp='".$this->ls_codemp."' AND spg_dt_cmp.codemp=spg_cuentas.codemp ".
				" AND spg_dt_cmp.spg_cuenta=spg_cuentas.spg_cuenta AND spg_dt_cmp.fecha=sigesp_cmp.fecha ".
				" AND spg_dt_cmp.comprobante=sigesp_cmp.comprobante AND spg_dt_cmp.procede='SCBBND' ".
				" AND DATE_PART('month',spg_dt_cmp.fecha) = '$as_mes' AND DATE_PART('year',spg_dt_cmp.fecha) = '$as_ano' ".
				" ORDER BY spg_dt_cmp.spg_cuenta, spg_dt_cmp.fecha";
	 	$rs_data2=$this->io_sql->select($ls_sql);
		if($rs_data2===false)
		{   //error interno sql
		   $this->io_msg->message("Error1 en Reporte Relacin de gastos Mensual ".$this->fun->uf_convertirmsg($this->SQL->message));
           	   $lb_valido = false;
		}
		else
		{
			while($row=$this->io_sql->fetch_row($rs_data2))
	 		{
				$this->dts_reporte->insertRow("codigo",$row['spg_cuenta']);
				$this->dts_reporte->insertRow("denominacion",$row['denominacion']);
				$this->dts_reporte->insertRow("comprobante",$row['comprobante']);
				$this->dts_reporte->insertRow("fecha",$row['fecha']);
				$this->dts_reporte->insertRow("descripcion",$row['descripcion']);
				$this->dts_reporte->insertRow("proveedor",$row['proveedor']);
				$this->dts_reporte->insertRow("beneficiario",$row['beneficiario']);
				$this->dts_reporte->insertRow("monto",$row['monto']);
				$this->dts_reporte->insertRow("procede",$row['procede']);
			}
		}
	 $arrResultado['lb_valido']=$lb_valido;
	 return $arrResultado;
	}

   function uf_spg_reporte_detalle_resumen_ejecucion_fin_pre($as_mes, $as_ano)

	{

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	 //	      Function :	uf_spg_reporte_detalle_resumen_ejecucion_fin_pre
	 //         Access :	private
	 //     Argumentos :    No aplica
     //	       Returns :	Retorna los montos correspondientes al resumen de la ejecucin financiera y presupuestaria
	 //   Description :	Reporte que genera los montos correspondientes al resumen de la ejecucin financiera y presupuestaria
	 //     Creado por :    Ing. Arnaldo Surez
	 // Fecha Creacion :    16/03/09          Fecha ltima Modificacion :
  	 ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

		$lb_valido = true;
		$ls_sql =	"SELECT spg_cuenta, MAX(denominacion) AS denominacion ".
				"FROM spg_cuentas ".
				"WHERE spg_cuenta ilike '%000000' ".
				"GROUP BY spg_cuenta ".
				"ORDER BY spg_cuenta";
//echo $ls_sql;die();
	 	$rs_data2=$this->io_sql->select($ls_sql);
		if($rs_data2===false)
		{   //error interno sql
		   $this->io_msg->message("Error1 en Reporte Relacin de gastos Mensual ".$this->fun->uf_convertirmsg($this->SQL->message));
           	   $lb_valido = false;
		}
		else
		{
			while($row=$this->io_sql->fetch_row($rs_data2))
	 		{
				$this->dts_reporte->insertRow("codigo",$row['spg_cuenta']);
				$this->dts_reporte->insertRow("denominacion",$row['denominacion']);
   				$arrResultado=$this->uf_spg_reporte_resumen_asignado($row['spg_cuenta']);
   				$arrResultado=$this->uf_spg_reporte_detalle_modificaciones($row['spg_cuenta'],"SPGTRA");
   				$arrResultado=$this->uf_spg_reporte_detalle_modificaciones($row['spg_cuenta'],"SPGCRA");
   				$arrResultado=$this->uf_spg_reporte_detalle_resumen_gastos($row['spg_cuenta']);
			}
		}
	 $arrResultado['lb_valido']=$lb_valido;
	 return $arrResultado;
	}

   function uf_spg_reporte_resumen_asignado($as_cuenta)

	{

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	 //	      Function :	uf_spg_reporte_resumen_asignado
	 //         Access :	private
	 //     Argumentos :    No aplica
     //	       Returns :	Retorna los montos correspondientes al resumen de asignacin inicial de presupuesto
	 //   Description :	Reporte que genera los montos correspondientes al resumen de asignacin inicial de presupuesto
	 //     Creado por :    Ing. Arnaldo Surez
	 // Fecha Creacion :    16/03/09          Fecha ltima Modificacion :
  	 ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

		$lb_valido = true;
		$cuenta = substr($as_cuenta,0,3);
		$ls_sql =	"SELECT SUM(asignado) AS asignado FROM spg_cuentas ".
				"WHERE spg_cuenta ILIKE '".$cuenta."%'";
		//echo $ls_sql;die();
	 	$rs_data1=$this->io_sql->select($ls_sql);
		if($rs_data1===false)
		{   //error interno sql
		   $this->io_msg->message("Error1 en Reporte Resumen asignacin presupuestaria ".$this->fun->uf_convertirmsg($this->SQL->message));
           	   $lb_valido = false;
		}
		else
		{
			while($row=$this->io_sql->fetch_row($rs_data1))
			{
				$this->dts_reporte->insertRow("asignado",$row['asignado']);
			}
		}
	 $arrResultado['lb_valido']=$lb_valido;
	 return $arrResultado;
	}

   function uf_spg_reporte_detalle_modificaciones($as_cuenta,$as_procede)

	{

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	 //	      Function :	uf_spg_reporte_detalle_modificaciones
	 //         Access :	private
	 //     Argumentos :    No aplica
     //	       Returns :	Retorna los montos correspondientes a las modificaciones de la ejecucin financiera y presupuestaria
	 //   Description :	Reporte que genera los montos correspondientes a las modificaciones de la ejecucin financiera y presupuestaria
	 //     Creado por :    Ing. Arnaldo Surez
	 // Fecha Creacion :    16/03/09          Fecha ltima Modificacion :
  	 ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

		$lb_valido = true;
		$cuenta = substr($as_cuenta,0,3);
		/*$ls_sql	=	"SELECT CASE operacion WHEN  'AU' THEN SUM(monto) END AS aumento, ".
				"CASE operacion WHEN  'DI' THEN SUM(monto) END AS disminucion ".
				"FROM spg_dt_cmp ".
				"WHERE spg_cuenta ILIKE '".$cuenta."%' and procede='".$as_procede."' ".
				"GROUP BY operacion";*/
		$ls_sql		=	"SELECT CASE spg_dt_cmp.operacion WHEN  'AU' THEN SUM(spg_dt_cmp.monto) END AS aumento, ".
				"CASE spg_dt_cmp.operacion WHEN  'DI' THEN SUM(spg_dt_cmp.monto) END AS disminucion, ".
				"CONCAT(MAX(spg_dt_cmp.codfuefin),'-', sigesp_fuentefinanciamiento.denfuefin) AS fuente ".
				"FROM spg_dt_cmp, sigesp_fuentefinanciamiento ".
				"WHERE spg_dt_cmp.spg_cuenta ILIKE '".$cuenta."%' and spg_dt_cmp.procede='".$as_procede."' ".
				"AND spg_dt_cmp.codfuefin=sigesp_fuentefinanciamiento.codfuefin ".
				"GROUP BY spg_dt_cmp.operacion, spg_dt_cmp.codfuefin, sigesp_fuentefinanciamiento.denfuefin";
		//echo $ls_sql;die();
	 	$rs_data3=$this->io_sql->select($ls_sql);
		if($rs_data3===false)
		{   //error interno sql
		   $this->io_msg->message("Error1 en Reporte Resumen modificaciones presupuestarias ".$this->fun->uf_convertirmsg($this->SQL->message));
           	   $lb_valido = false;
		}
		else
		{
			$j=0;
			while($row=$this->io_sql->fetch_row($rs_data3))
			{
			 	switch($as_procede)
			 	{
			 		case 'SPGTRA'  : 
						if ($row['aumento']!='')
							$this->dts_reporte->insertRow("aumento",$row['aumento']);
						if ($row['disminucion']!='')
							$this->dts_reporte->insertRow("disminucion",$row['disminucion']);
			 			break;
			 		case 'SPGCRA'  : 
						$this->dts_reporte->insertRow("credito",$row['aumento']);
			 			break;
				}
				$this->dts_reporte->insertRow("fuente",$row['fuente']);
			$j++;
			}
			if ($j==0) {
			 	switch($as_procede)
			 	{
			 		case 'SPGTRA'  : 
						$this->dts_reporte->insertRow("aumento","0");
						$this->dts_reporte->insertRow("disminucion","0");
			 			break;
			 		case 'SPGCRA'  : 
						$this->dts_reporte->insertRow("credito","0");
			 			break;
				}
				$this->dts_reporte->insertRow("fuente","");
			}
		}
	 $arrResultado['lb_valido']=$lb_valido;
	 return $arrResultado;
	}

   function uf_spg_reporte_detalle_resumen_gastos($as_cuenta)

	{

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	 //	      Function :	uf_spg_reporte_detalle_resumen_gastos
	 //         Access :	private
	 //     Argumentos :    No aplica
     //	       Returns :	Retorna los montos correspondientes al resumen de gastos de la ejecucin financiera y presupuestaria
	 //   Description :	Reporte que genera los montos correspondientes al resumen de gastos de la ejecucin financiera y presupuestaria
	 //     Creado por :    Ing. Arnaldo Surez
	 // Fecha Creacion :    16/03/09          Fecha ltima Modificacion :
  	 ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

		$lb_valido = true;
		$cuenta = substr($as_cuenta,0,3);
		$ls_sql =	"SELECT SUM(monto) AS gasto FROM spg_dt_cmp ".
				"WHERE (operacion='CS' OR operacion='CCP') AND spg_cuenta ILIKE '".$cuenta."%'";
		//echo $ls_sql;die();
	 	$rs_data4=$this->io_sql->select($ls_sql);
		if($rs_data4===false)
		{   //error interno sql
		   $this->io_msg->message("Error1 en Reporte Resumen gastos presupuestarios ".$this->fun->uf_convertirmsg($this->SQL->message));
           	   $lb_valido = false;
		}
		else
		{
			while($row=$this->io_sql->fetch_row($rs_data4))
			{
				$this->dts_reporte->insertRow("gasto",$row['gasto']);
			}
		}
	 $arrResultado['lb_valido']=$lb_valido;
	 return $arrResultado;
	}

}//fin de clase
?>
