/**
 * 
 */
var fromRegistroCotizacion = null; //varibale para almacenar la instacia de objeto de formulario 
var gridBienes = null;
var gridServicios = null;
var fromTotales = null;
var Actualizar = null;
barraherramienta    = true;

Ext.onReady(function() {
	Ext.BLANK_IMAGE_URL = '../../base/librerias/js/ext/resources/images/default/s.gif';
	
	// Buscar numero de registro de cotizacion
	function buscarNumCot(){
		var myJSONObject = {
				"operacion":"buscarNumero" 
			};
				
		var ObjSon=Ext.util.JSON.encode(myJSONObject);
		var parametros ='ObjSon='+ObjSon;
		Ext.Ajax.request({
			url: '../../controlador/soc/sigesp_ctr_soc_registro_cotizacion.php',
			params: parametros,
			method: 'POST',
			success: function ( result, request ) { 
		            var numero = result.responseText;
					if (numero != "") {
						limpiarFormulario(fromRegistroCotizacion);
						Ext.getCmp('numcot').setValue(numero);
					}
			},
			failure: function ( result, request){ 
					Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
			}//fin de success
		});//fin del ajax request	
	}
	
	//-------------------------------------------------------------------------------------------------------------------------	
	
	//Data del combo calidad 
	var reCalidad = [ ['E','Excelente'],
                      ['B','Bueno'],
                      ['R','Regular'],
                      ['M','Malo'] ];
	//Arreglo que contiene los Documentos que se pueden controlar

    var dsCalidad = new Ext.data.SimpleStore({
             fields: ['cod', 'den'],
             data : reCalidad // Se asocian los documentos disponibles
    });
	 
   //Creacion del combo calidad de la gridBienes
    var cmbCalidad =new Ext.form.ComboBox({
    		store: dsCalidad,
    		fieldLabel:'',
    		displayField:'den',
    		valueField:'cod',
	        name:'cali',
	        id:'calidad',
	        forceSelection: true,  
	        typeAhead: true,
	        mode: 'local',
	        binding:true,
	        triggerAction: 'all'
	});
	
	//------------------------------------------------------------------------------------------------------

	//Funcion que impia las grid al momento de cambiar de tipo de solictud
	function LimpiarGrid(){
		gridBienes.store.removeAll();
		gridServicios.store.removeAll();
		gridBienes.hide();
		gridServicios.hide();
		limpiarFormulario(fromTotales);
		fromTotales.hide();
	}
	
	//-----------------------------------------------------------------------------------------------
	
	//creando datastore y columnmodel para la grid de bienes
	var reBienes = Ext.data.Record.create([
	    {name: 'codart'},
		{name: 'denart'},
		{name: 'canart'},
	    {name: 'preuniart'},
	    {name: 'monsubart'},
	    {name: 'moniva'},
	    {name: 'montotart'},
	    {name: 'unidad'},
	    {name: 'formula'},
	    {name: 'porcar'},
	    {name: 'unimed'}
	    
	]);
	
	var dsBienes =  new Ext.data.Store({
		reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reBienes )
	});
						
	var cmBienes = new Ext.grid.ColumnModel([
        {header: "<H1 align='center'>Codigo</H1>", width: 60, align: 'center', sortable: true, dataIndex: 'codart'},
        {header: "<H1 align='center'>Denominacion</H1>", width: 80, sortable: true, dataIndex: 'denart'},
        {header: "<H1 align='center'>Cantidad</H1>", 
         width: 30, 
		 sortable: true, 
		 dataIndex: 'canart',
		 align: 'center',
		 editor: new Ext.form.TextField({allowBlank: false,
							             autoCreate: {tag: 'input', type: 'text', size: '15', autocomplete: 'off', maxlength: '15', onkeypress: "return keyRestrict(event,'0123456789.');"},
							             listeners:{
											'blur':function(objeto){
												var numero = objeto.getValue();
												valor = formatoNumericoMostrar(objeto.getValue(),2,'.',',','','','-','');
												objeto.setValue(valor);
											},
											'specialKey':function(objeto){
												var numero = objeto.getValue();
												valor = formatoNumericoMostrar(objeto.getValue(),2,'.',',','','','-','');
												objeto.setValue(valor);
											},
											'focus':function(objeto){
												var numero = formatoNumericoEdicion(objeto.getValue());
												objeto.setValue(numero);
											}
									    }})},
		{header: "<H1 align='center'>Precio/Unid</H1>", 
	   	 width: 40, 
		 sortable: true, 
		 dataIndex: 'preuniart',
		 align: 'right',
		 editor: new Ext.form.TextField({allowBlank: false,
							             autoCreate: {tag: 'input', type: 'text', size: '15', autocomplete: 'off', maxlength: '15', onkeypress: "return keyRestrict(event,'0123456789.');"},
							             listeners:{
											'blur':function(objeto){
												var numero = objeto.getValue();
												valor = formatoNumericoMostrar(objeto.getValue(),2,'.',',','','','-','');
												objeto.setValue(valor);
											},
											'specialKey':function(objeto){
												var numero = objeto.getValue();
												valor = formatoNumericoMostrar(objeto.getValue(),2,'.',',','','','-','');
												objeto.setValue(valor);
											},
											'focus':function(objeto){
												var numero = formatoNumericoEdicion(objeto.getValue());
												objeto.setValue(numero);
											}
									    }})},
		{header: "<H1 align='center'>Subtotal</H1>", type: 'float', width: 40, align: 'right', sortable: true, dataIndex: 'monsubart'},
		{header: "<H1 align='center'>Crditos</H1>", type: 'float', width: 40, align: 'right', sortable: true, dataIndex: 'moniva'},
		{header: "<H1 align='center'>Total</H1>", type: 'float', width: 40, align: 'right', sortable: true, dataIndex: 'montotart'},
		{header: "<H1 align='center'>Calidad</H1>", 
	   	 width: 30, 
	   	 sortable: true, 
	     dataIndex: 'nivcalart',
	   	 editor: cmbCalidad, renderer: MostrarCalidad}
		
	]);
	//fin del datastore y columnmodel para la grid de bienes
	
	//creando grid para los detalles de bienes
	gridBienes = new Ext.grid.EditorGridPanel({
	 		width:800,
	 		height:200,
			frame:true,
			title:"<H1 align='center'>Detalle de Bienes</H1>",
			style: 'position:absolute;left:10px;top:420px',
			autoScroll:true,
     		border:true,
     		ds: dsBienes,
       		cm: cmBienes,
       		stripeRows: true,
      		viewConfig: {forceFit:true}
	});
	
	//-----------------------------------------------------------------------------------------------
	
	//Metodo que realiza cambios despues de editar la gridBienes
	gridBienes.on('afteredit', function(Obj){
         var registro      = Obj.record;
         var cantidad      = registro.get('canart');
         var precio        = registro.get('preuniart');
         
         if(cantidad!=''){
 			cantidad = parseFloat(ue_formato_operaciones(cantidad));
 		 }
 		 if(precio!=''){
 			precio = parseFloat(ue_formato_operaciones(precio));
 		 }
 		 var subtotal = cantidad * precio;
 		 
         if(subtotal != ""){
        	 var moncre = calcularCargo(registro,subtotal);
           	 var montotal = subtotal + moncre;
             registro.set('monsubart',formatoNumericoMostrar(subtotal,2,'.',',','','','-',''));
             registro.set('moniva',formatoNumericoMostrar(moncre,2,'.',',','','','-',''));
             registro.set('montotart',formatoNumericoMostrar(montotal,2,'.',',','','','-',''));
             AcumularTotales('B');
      	 }
	});
	
	//-----------------------------------------------------------------------------------------------
	
	//creando datastore y columnmodel para la grid de servicios
	var reServicios = Ext.data.Record.create([
	     {name: 'codser'}, 
	     {name: 'denser'},
	     {name: 'canser'},
	     {name: 'monuniser'},
	     {name: 'monsubser'},
	     {name: 'moniva'},
	     {name: 'montotser'},
	     {name: 'formula'},
	     {name: 'porcar'}
		
    ]);

    var dsServicios =  new Ext.data.Store({
    	reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reServicios)
    });
					
    var cmServicios = new Ext.grid.ColumnModel([
         {header: "<H1 align='center'>Codigo</H1>", width: 60, sortable: true, dataIndex: 'codser'},
		 {header: "<H1 align='center'>Denominacion</H1>", width: 80, sortable: true, dataIndex: 'denser'},
		 {header: "<H1 align='center'>Cantidad</H1>", 
	      width: 30, 
		  sortable: true, 
		  dataIndex: 'canser',
		  align: 'center',
		  editor: new Ext.form.TextField({allowBlank: false,
							              autoCreate: {tag: 'input', type: 'text', size: '15', autocomplete: 'off', maxlength: '15', onkeypress: "return keyRestrict(event,'0123456789.');"},
							              listeners:{
												'blur':function(objeto){
													var numero = objeto.getValue();
													valor = formatoNumericoMostrar(objeto.getValue(),2,'.',',','','','-','');
													objeto.setValue(valor);
												},
												'specialKey':function(objeto){
													var numero = objeto.getValue();
													valor = formatoNumericoMostrar(objeto.getValue(),2,'.',',','','','-','');
													objeto.setValue(valor);
												},
												'focus':function(objeto){
													var numero = formatoNumericoEdicion(objeto.getValue());
													objeto.setValue(numero);
												}
										    }})},
		 {header: "<H1 align='center'>Precio</H1>", 
		  width: 40, 
		  sortable: true, 
		  dataIndex: 'monuniser',
		  align: 'right',
		  editor: new Ext.form.TextField({allowBlank: false,
							              autoCreate: {tag: 'input', type: 'text', size: '15', autocomplete: 'off', maxlength: '15', onkeypress: "return keyRestrict(event,'0123456789.');"},
							              listeners:{
												'blur':function(objeto){
													var numero = objeto.getValue();
													valor = formatoNumericoMostrar(objeto.getValue(),2,'.',',','','','-','');
													objeto.setValue(valor);
												},
												'specialKey':function(objeto){
													var numero = objeto.getValue();
													valor = formatoNumericoMostrar(objeto.getValue(),2,'.',',','','','-','');
													objeto.setValue(valor);
												},
												'focus':function(objeto){
													var numero = formatoNumericoEdicion(objeto.getValue());
													objeto.setValue(numero);
												}
										    }})},
		 {header: "<H1 align='center'>Subtotal</H1>", type: 'float', align: 'right', width: 40, sortable: true, dataIndex: 'monsubser'},
		 {header: "<H1 align='center'>Cargos</H1>", type: 'float', align: 'right', width: 40, sortable: true, dataIndex: 'moniva'},
		 {header: "<H1 align='center'>Total</H1>", type: 'float', align: 'right', width: 40, sortable: true, dataIndex: 'montotser'},
		 {header: "<H1 align='center'>Calidad</H1>", 
	   	  width: 30, 
	   	  sortable: true, 
	      dataIndex: 'nivcalser',
	   	  editor: cmbCalidad, renderer: MostrarCalidad}
    ]);
  
    //creando grid para los detalles de servicios
    gridServicios = new Ext.grid.EditorGridPanel({
 		width:800,
 		height:200,
		frame:true,
		title:"<H1 align='center'>Detalle de Servicios</H1>",
		style: 'position:absolute;left:10px;top:420px',
		autoScroll:true,
 		border:true,
 		ds: dsServicios,
   		cm: cmServicios,
   		stripeRows: true,
  		viewConfig: {forceFit:true}
    });
    
	//-----------------------------------------------------------------------------------------------
  
    //Metodo que realiza cambios despues de editar la gridServicios
	gridServicios.on('afteredit', function(Obj) {
		var registro      = Obj.record;
		var cantidad      = registro.get('canser');
		var precio        = registro.get('monuniser');
		
		if(cantidad!=''){
			cantidad = parseFloat(ue_formato_operaciones(cantidad));
		}
		if(precio!=''){
			precio = parseFloat(ue_formato_operaciones(precio));
		}
		var subtotal = cantidad*precio;
		
		if(subtotal!=0){
			var moncre = calcularCargo(registro,subtotal);
			var montotal = subtotal + moncre;
			registro.set('monsubser',formatoNumericoMostrar(subtotal,2,'.',',','','','-',''));
			registro.set('moniva',formatoNumericoMostrar(moncre,2,'.',',','','','-',''));
			registro.set('montotser',formatoNumericoMostrar(montotal,2,'.',',','','','-',''));
			AcumularTotales('S');
		}
	});
	
	//-----------------------------------------------------------------------------------------------
	
	//funcion para obtner el permiso del usuario
	function obtenerpermiso(){
		valor=!(tbadministrativo);
		Ext.getCmp('numcot').setDisabled(valor);
	}
	
	//-------------------------------------------------------------------------------------
	
	var botbusSolCot = new Ext.Button({
		id: 'botbusSolCot',
		iconCls: 'menubuscar',
		style:'position:absolute;left:345px;top:140px',
		listeners:{
            'click' : function(boton){
				if(Ext.getCmp('tipcot').getValue()==''){
					 Ext.Msg.show({
						 title:'Mensaje',
						 msg: 'Debe seleccionar el tipo de la cotizacion (Bienes - Servicios)',
						 buttons: Ext.Msg.OK,
						 icon: Ext.MessageBox.INFO
					 });
				}
				else{
					CatalogoSolicitudCotizacion('RC',Ext.getCmp('tipcot').getValue());
				}
           }
        }
	});
	
	//-------------------------------------------------------------------------------------
	
	var botbusProSolCot = new Ext.Button({
		id: 'botbusProSolCot',
		iconCls: 'menubuscar',
		style:'position:absolute;left:345px;top:170px',
		listeners:{
            'click' : function(boton){
				if(Ext.getCmp('numsolcot').getValue()==''){
					 Ext.Msg.show({
						 title:'Mensaje',
						 msg: 'Debe seleccionar el Nro. de la Solicitud de Cotizacion',
						 buttons: Ext.Msg.OK,
						 icon: Ext.MessageBox.INFO
					 });
				}
				else{
					ventanaCatalogoProSolCot(boton.id)	
				}
            }
        }
	});
	
	//--------------------------------------------------------------------------------------------

	function ventanaCatalogoProSolCot(idBoton){	
		
		function buscarCredito(codigo,registro){
			obtenerMensaje('procesar','','Buscando Datos');
			var JSONObject = {
				'operacion' : 'cargar_formula_credito',
				'codigo'    : codigo,
				'tipo'      : Ext.getCmp('tipcot').getValue()
			}			
			var ObjSon = JSON.stringify(JSONObject);
			var parametros = 'ObjSon='+ObjSon; 
			Ext.Ajax.request({
				  url : '../../controlador/soc/sigesp_ctr_soc_registro_cotizacion.php',
				  params : parametros,
				  method: 'POST',
				  success: function ( resultado, request){
				  	Ext.Msg.hide();
				  		var resultado = resultado.responseText;
				  		var objDatos = eval('(' + resultado + ')');
				  		var datos = objDatos.raiz;
				  		if(datos != ""){
			  				registro.set('formula',datos[0].formula);
			  				registro.set('porcar',datos[0].porcar);
						}
			  	  },
	  			  failure: function ( result, request){ 
			  		  Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
			  	  }//fin del success
			});//fin del ajax request
		}
		
		//Creando el campo de proveedores
		var reVentana = Ext.data.Record.create([
		          {name: 'cod_pro'}, 
		          {name: 'nompro'},
		          {name: 'rifpro'},
		          {name: 'dirpro'},
		          {name: 'telpro'},
		          {name: 'tipconpro'}
		]);
		                                        	
		var dsVentana =  new Ext.data.Store({
		           reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reVentana)
		});
		                                						
		 var cmVentana = new Ext.grid.ColumnModel([
		           {header: "<H1 align='center'>Codigo</H1>", width: 30, sortable: true, dataIndex: 'cod_pro'},
		           {header: "<H1 align='center'>Nombre</H1>", width: 50, sortable: true, dataIndex: 'nompro'},
		           {header: "<H1 align='center'>RIF</H1>", width: 30, sortable: true, dataIndex: 'rifpro'}
		]);
		//fin creando datastore y columnmodel para el catalogo de proveedores
		 
		 var gridVentanaCatalogoProveedores = new Ext.grid.GridPanel({
		 		width:500,
		 		height:250,
				frame:true,
				style: 'position:absolute;left:0px;top:130px',
				autoScroll:true,
				enableColumnHide: false,
				enableHdMenu: false,
				border:true,
				ds:dsVentana,
	    		cm:cmVentana,
	    		stripeRows: true,
	    		viewConfig: {forceFit:true}
		});
		 
		 gridVentanaCatalogoProveedores.on({
			'rowdblclick': {
				fn: function(grid, numFila, evento){
					var registro = grid.getStore().getAt(numFila);
					Aceptar(registro);
				}
			}
		});
		 
		//Creacion del formulario del catalogo proveedores
		 var formVentanaCatalogoProveedores = new Ext.FormPanel({
		 	width: 550,
			height: 500,
			frame: true,
			autoScroll:false,
			items: [{
				xtype:"fieldset", 
			    title:'Datos del Proveedor',
			    style: 'position:absolute;left:15px;top:10px',
				border:true,
				cls: 'fondo',
				width: 500,
				height: 120,
				items:[ {
					layout: "column",
					defaults: {border: false},
					style: 'position:absolute;left:15px;top:20px',
					items: [{
						layout: "form",
						border: false,
						labelWidth: 100,
						items: [{
							xtype: 'textfield',
							labelSeparator :'',
							fieldLabel: 'Codigo',
							name: 'codigo',
							id: 'codpro',									
							width: 100,
							binding:true,
							hiddenvalue:'',
							defaultvalue:'',
							autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789');"},
							changeCheck: function(){
								var textvalor = this.getValue();
								dsVentana.filter('cod_pro',textvalor,true);
									if(String(textvalor) !== String(this.startValue)){
										this.fireEvent('change', this, textvalor, this.startValue);
									} 
							}, 
							initEvents: function(){
								AgregarKeyPress(this);
							}
						}]
					}]
	     		},
	     		{
	     			layout: "column",
					defaults: {border: false},
					style: 'position:absolute;left:15px;top:50px',
					items: [{
						layout: "form",
						border: false,
						labelWidth: 100,
						items: [{
							xtype: 'textfield',
							labelSeparator :'',
							fieldLabel: 'Nombre',
							name: 'nombre',
							id: 'nom_pro',
							width: 350,
							binding:true,
							hiddenvalue:'',
							defaultvalue:'',
							changeCheck: function(){
								var textvalor = this.getValue();
								dsVentana.filter('nompro',textvalor,true);
									if(String(textvalor) !== String(this.startValue)){
										this.fireEvent('change', this, textvalor, this.startValue);
									} 
							}, 
							initEvents: function(){
								AgregarKeyPress(this);
							}	
						}]
					}]
	     		},
				gridVentanaCatalogoProveedores,
		     	{
					layout:"column",
					defaults: {border: false},
					style: 'position:absolute;left:400px;top:85px',
					border:false,
					items:[{
						layout:"form",
						border:false,
						items:[{
							xtype: 'button',
							labelSeparator :'',
							fieldLabel: '',
							id: 'btagregar',
							text: 'Buscar',
							width: 300,
							height: 300,
							binding:true,
							hiddenvalue:'',
							defaultvalue:'',
							iconCls: 'menubuscar',
							handler: function(){
								obtenerMensaje('procesar','','Buscando Datos');
				   				
								//buscar  proveedores
								var JSONObject = {
				   					'operacion' : 'cargarProveedores',
				   					'numsolcot' : Ext.getCmp('numsolcot').getValue(),
				   					'tipsolcot' : Ext.getCmp('tipcot').getValue(),
				   					'codpro'    : Ext.getCmp('codpro').getValue(),
				   					'nompro'    : Ext.getCmp('nom_pro').getValue(),
				   				}
							
				   				var ObjSon = JSON.stringify(JSONObject);
				   				var parametros = 'ObjSon='+ObjSon; 
				   				Ext.Ajax.request({
				   					url : '../../controlador/soc/sigesp_ctr_soc_registro_cotizacion.php',
				   					params : parametros,
				   					method: 'POST',
				   					success: function ( resultado, request){
				   						Ext.Msg.hide();
				   						var datos = resultado.responseText;
				   						var objProveedor = eval('(' + datos + ')');
				   						if(objProveedor!=''){
				   							if(objProveedor!='0'){
				   								if(objProveedor.raiz == null || objProveedor.raiz ==''){
				   									Ext.MessageBox.show({
									 					title:'Advertencia',
									 					msg:'Las Cotizaciones han sido registradas por cada Proveedor de la Solicitud seleccionada',
									 					buttons: Ext.Msg.OK,
									 					icon: Ext.MessageBox.WARNING
									 				});
												}
												else{
													gridVentanaCatalogoProveedores.store.loadData(objProveedor);
												}
				   							}
				   							else{
				   								Ext.MessageBox.show({
									 				title:'Advertencia',
									 				msg:'Debe configurar en Empresa los digitos de las cuentas de gastos',
									 				buttons: Ext.Msg.OK,
									 				icon: Ext.MessageBox.WARNING
									 			});
				   							}
				   						}
//				   						if(objProveedor!=''){
//				   							gridVentanaCatalogoProveedores.store.loadData(objProveedor);
//				   						}
				   					}//fin del success	
						   		});//fin del ajax request
					      	}
						}]
					}]
	   			}]  
			}]   
		});
		//fin del formulario 
		 
		var ventanaProveedor = new Ext.Window({
			title: "<H1 align='center'>Cat&#225;logo de Proveedor</H1>",
	        width:570,
	        height:480,
	        modal: true,
	        closable:false,
	        plain: false,
	        frame:true,
	        items:[formVentanaCatalogoProveedores],
	        buttons: [{
	        	text:'Aceptar',  
		        handler: function(){
	        		var registro = gridVentanaCatalogoProveedores.getSelectionModel().getSelected();
	        		Aceptar(registro);
		        }
			},{
				text: 'Salir',
	   		    handler:function(){
	   		    	ventanaProveedor.destroy();
				}
			}]
				
		});
		ventanaProveedor.show();
		
		function Aceptar(registro){
			Ext.getCmp('cod_pro').setValue(registro.get('cod_pro'));
    		Ext.getCmp('nompro').setText(registro.get('nompro'));
    		gridBienes.store.removeAll();
    		gridServicios.store.removeAll();
    		var reArt = Ext.data.Record.create([
				{name: 'codart'}, 
				{name: 'denart'},
				{name: 'canart'},
				{name: 'unidad'},
				{name: 'unimed'}
			]);
			var reSer = Ext.data.Record.create([
				{name: 'codser'}, 
				{name: 'denser'},
				{name: 'canser'}
			]);
			obtenerMensaje('procesar','','Buscando Datos');
			var JSONObject = {
				'operacion' : 'cargarBienesServicios',
				'numsolcot' : Ext.getCmp('numsolcot').getValue(),
				'tipsolcot' : Ext.getCmp('tipcot').getValue(),
				'codpro'    : Ext.getCmp('cod_pro').getValue()
			}			
			var ObjSon = JSON.stringify(JSONObject);
			var parametros = 'ObjSon='+ObjSon; 
			Ext.Ajax.request({
				url : '../../controlador/soc/sigesp_ctr_soc_solicitud_cotizacion.php',
				params : parametros,
				method: 'POST',
				success: function(resultado,request){
					Ext.Msg.hide();
					var resultado = resultado.responseText;
					var objDatos = eval('(' + resultado + ')');
					var datos = objDatos.raiz;
					if(datos != ""){
						if(Ext.getCmp('tipcot').getValue()=='B'){
							for(var j = 0; j < datos.length; j++){
								var bienesInt = new reArt({
									'codart'     :datos[j].codart,
									'denart'     :datos[j].denart,
									'canart'     :datos[j].canart,
									'unidad'	 :datos[j].unidad,
									'unimed'     :datos[j].unimed,
									'nivcalart'  :'E',
									'preuniart'  :'',
									'moniva'     :'',
									'monsubart'  :'',
									'montotart'  :''
								});
								if(registro.get('tipconpro')!='F')
								{
									buscarCredito(datos[j].codart,bienesInt);
								}
								gridBienes.store.insert(0,bienesInt);
							}
						}
						else{
							for(var j = 0; j < datos.length; j++){
								var serviciosInt = new reSer({
									'codser'    :datos[j].codser,
									'denser'    :datos[j].denser,
									'canser'    :datos[j].canser,
									'nivcalser' :'E',
									'monuniser' :'',
									'moniva'    :'',
									'monsubser' :'',
									'montotser' :'',
								});
								if(registro.get('tipconpro')!='F')
								{
									buscarCredito(datos[j].codser,serviciosInt);
								}
								gridServicios.store.insert(0,serviciosInt);
							}
						}
					}
				},
	  			  failure: function ( result, request){ 
			  		  Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
			  	  }//fin del success
			});//fin del ajax request
			ventanaProveedor.destroy();
		}
	}
	
	//-------------------------------------------------------------------------------------
	
	//Funcion para calcula el monto del credito 
	function calcularCargo(registro,subtotal,tipo){
      var cargo = 0;
      var formula = registro.get('formula');
      if(formula!=undefined){
    	  formula = formula.replace("$LD_MONTO",subtotal);
    	  cargo   = eval(formula);
      }
      return cargo;
	} 
	
	//-------------------------------------------------------------------------------------
	
	//funcion que acumula los montos(subtotal-monto del cargo-total) de la grid
	function AcumularTotales(tipo){
		var monsub = 0;
		var moncre = 0;
		if(tipo=='B'){
			gridBienes.store.each(function (regBie){
				var monauxuno = regBie.get('monsubart');
				var monauxdos = regBie.get('moniva');
				if(monauxuno!=undefined && monauxdos!=undefined){
					monauxuno = parseFloat(ue_formato_operaciones(monauxuno));
					monauxdos = parseFloat(ue_formato_operaciones(monauxdos));
					monsub += monauxuno;
					moncre += monauxdos;
				}
		    })
		}
		else{
			gridServicios.store.each(function (regBie){
				var monauxuno = regBie.get('monsubser');
				var monauxdos = regBie.get('moniva');
				if(monauxuno!=undefined && monauxdos!=undefined){
					monauxuno = parseFloat(ue_formato_operaciones(monauxuno));
					monauxdos = parseFloat(ue_formato_operaciones(monauxdos));
					monsub += monauxuno;
					moncre += monauxdos;
				}
		    })
		}
		Ext.getCmp('monsubtot').setValue(formatoNumericoMostrar(monsub,2,'.',',','','','-',''));
		Ext.getCmp('monimpcot').setValue(formatoNumericoMostrar(moncre,2,'.',',','','','-',''));
		Ext.getCmp('montotcot').setValue(formatoNumericoMostrar(monsub+moncre,2,'.',',','','','-',''));
	}
	
    //--------------------------------------------------------------------------------
	
	//Data del combo tipo distribucion
	var tipo = [ [ 'B', 'BIENES' ], 
	             [ 'S', 'SERVICIOS' ] ];
	
	var stTipo = new Ext.data.SimpleStore({
		fields : [ 'col', 'tipo' ],
		data : tipo
	});
	
	//-------------------------------------------------------------------------------------------------------------------------	
	
	//Data del combo forma de pago
	var reForpag = [ [ 'CONTADO', 'CONTADO' ], 
	               [ 'CREDITO', 'CREDITO' ],
	               [ 'CHEQUE', 'CHEQUE' ],
				   [ 'CARTA DE CREDITO', 'CARTA DE CREDITO' ],
				   [ 'ABONO EN CUENTA', 'ABONO EN CUENTA' ],
				   [ '50%APROBAR50%ENTREGA', '50% AL APROBAR 50% A LA ENTREGA' ],
				   [ 'OTROS', 'OTROS' ]];
	
	var stForpag = new Ext.data.SimpleStore({
		fields : [ 'cod', 'den' ],
		data : reForpag
	});
	
	//-------------------------------------------------------------------------------------------------------------------------	
	
	//Funcion para validar si tipo de distribucion fue seleccionada
	function validarNumSolCot(){
		var unidadOk = true;
		
		if(Ext.getCmp('numsolcot').getValue()==''){
			unidadOk = false;
		}
		return unidadOk;
	}
	
	//--------------------------------------------------------------------------------------------
	
	//Creacion del formulario de los totales
	fromTotales = new Ext.form.FieldSet({
			title:'Totales',
			style: 'position:absolute;left:505px;top:630px',
			border:true,
			width: 285,
			cls :'fondo',
			height: 125,
			items: [{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:10px;top:10px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						style:'font-weight: bold',
						fieldLabel: 'Subtotal',
						id: 'monsubtot',
						width: 150,
						disabled : true,
						formatonumerico:true,
						binding:true,
						hiddenvalue:'',
						defaultvalue:0,
						allowBlank:true
					}]
				}]
			},
			{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:10px;top:40px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						style:'font-weight: bold',
						fieldLabel: 'Crditos',
						id: 'monimpcot',
						width: 150,
						disabled : true,
						formatonumerico:true,
						binding:true,
						hiddenvalue:'',
						defaultvalue:0,
						allowBlank:true
					}]
				}]
			},
			{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:10px;top:70px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						style:'font-weight: bold',
						fieldLabel: 'Total Cotizacion',
						id: 'montotcot',
						width: 150,
						disabled : true,
						formatonumerico:true,
						binding:true,
						hiddenvalue:'',
						defaultvalue:0,
						allowBlank:true
					}]
				}]
			}] 		
  	})//fin de creacion del formulario de los totales
	
	//-------------------------------------------------------------------------------------------------------------------------	
	
	//Creando formulario principal 
	var Xpos = ((screen.width/2)-(430));
	var Ypos = ((screen.height/2)-(650/2));
	fromRegistroCotizacion = new Ext.FormPanel({
		title: "<H1 align='center'>Registro de Cotizaciones</H1>",
		applyTo: 'formRegistroCotizacion',
		width: 850,
		height: 500,
		style: 'position:absolute;top:'+Ypos+'px;left:'+Xpos+'px',  //'position:absolute;margin-left:'+Xpos+'px;margin-top:45px;',
		frame: true,
		autoScroll:true,
		items: [{
			xtype:"fieldset", 
		    title:'Datos de la Cotizacion',
		    style: 'position:absolute;left:10px;top:5px',
		    border:true,
		    width: 800,
		    cls :'fondo',
		    height: 415,
		    items: [{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:25px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 150,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						style:'font-weight: bold; border:none;background:#f1f1f1',
						fieldLabel: 'Estatus',
						id: 'estcotlabel',
						width: 150,
						value: 'REGISTRO'
					},{
						xtype: 'hidden',
						id: 'estcot',
						binding:true,
						hiddenvalue:'',
						value:'0'
					}]
				}]
		    },
		    {
		    	layout:"column",
			    defaults: {border: false},
			    style: 'position:absolute;left:15px;top:50px',
			    border:false,
				items:[{
					layout:"form",
					border:false,
					labelWidth:150,
					items:[{
						xtype:"datefield",
						labelSeparator :'',
						fieldLabel:"Fecha",
						name:'Fecha',
						id:'feccot',
						allowBlank:true,
						width:100,
						binding:true,
						defaultvalue:'1900-01-01',
						hiddenvalue:'',
						allowBlank:false,
						value: new Date().format('d-m-Y'),
						autoCreate: {tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789/');"}
					}]
				}]
		    },
		    {
		    	layout:"column",
			    defaults: {border: false},
			    style: 'position:absolute;left:15px;top:80px',
			    border:false,
			    items:[{
			    	layout:"form",
				    border:false,
					labelWidth:150,
					items:[{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Cotizacion',
						id: 'numcot',
						autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '15', onkeypress: "return keyRestrict(event,'0123456789');"},
						width: 150,
						formatonumerico:false,
						binding:true,
						hiddenvalue:'',
						defaultvalue:'',
						allowBlank:false
				  }]
		  	  }]
	      },
	      {
	    	  layout:"column",
			  defaults: {border: false},
			  style: 'position:absolute;left:15px;top:110px',
			  border:false,
			  items:[{
				  layout:"form",
				  border:false,
				  labelWidth:150,
				  items:[{
					  xtype: 'combo',
				      fieldLabel: 'Tipo',
					  labelSeparator :'',
					  id: 'tipcot',
					  store : stTipo,
					  editable : false,
					  displayField : 'tipo',
					  valueField : 'col',
					  typeAhead : true,
					  triggerAction : 'all',
					  mode : 'local',
				      emptyText:'----Seleccione----',
				   	  listWidth:150,
				      width:150,
				      binding:true,
					  hiddenvalue:'',
					  defaultvalue:'',
				      listeners: {
					  	'select': function(){
						  	if(this.getValue()=='B'){
						  		if (typeof(gridBienes) == 'object' && gridBienes != null){
						  			LimpiarGrid();
									fromRegistroCotizacion.add(gridBienes);
									fromRegistroCotizacion.add(fromTotales);
									gridBienes.show();
									fromTotales.show();
									fromRegistroCotizacion.doLayout();
								}
						  	}
						  	else{
						  		if(typeof(gridServicios) == 'object' && gridServicios != null){
						  			fromRegistroCotizacion.add(gridServicios);
									fromRegistroCotizacion.add(fromTotales);
									gridServicios.show();
									fromTotales.show();
									fromRegistroCotizacion.doLayout();
						  		}
						  	}
				  		}
				  	}
				}]
			}]
	    },{
			layout: "column",
			defaults: {border: false},
			style: 'position:absolute;left:15px;top:140px',
			items: [{
				layout: "form",
				border: false,
				labelWidth: 150,
				items: [{
					xtype: 'textfield',
					labelSeparator :'',
					fieldLabel: 'Solicitud Cotizacion',
					id: 'numsolcot',
					width: 150,
					binding:true,
					hiddenvalue:'',
					defaultvalue: 0,
					allowBlank:false,
					autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '15', onkeypress: "return keyRestrict(event,'0123456789');"}
				}]
			}]
	    },botbusSolCot,
	    {
			layout: "column",
			defaults: {border: false},
			style: 'position:absolute;left:15px;top:170px',
			items: [{
				layout: "form",
				border: false,
				labelWidth: 150,
				items: [{
					xtype: 'textfield',
					labelSeparator :'',
					fieldLabel: 'Proveedor',
					id: 'cod_pro',
					width: 150,
					binding:true,
					hiddenvalue:'',
					defaultvalue:'',
					allowBlank:false,
					autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789');"}
				}]
			}]
	    }
	    ,{
			layout: "column",
			defaults: {border: false},
			style: 'position:absolute;left:400px;top:170px',
			items: [{
				layout: "form",
				border: false,
				labelWidth: 200,
				items: [{	
					xtype: 'label',
					style:'font-weight: bold; border:none;background:#f1f1f1',
					text: '',
					disabled : true,
					id: 'nompro',
					width: 300
				}]
			}]
		}
	    ,botbusProSolCot,
	    {
	    	layout:"column",
			defaults: {border: false},
			style: 'position:absolute;left:15px;top:200px',
			border:false,
			items:[{
				layout:"form",
				border:false,
				labelWidth:150,
				items:[{
					xtype: 'textarea',
					labelSeparator :'',
					fieldLabel: 'Observacion',
					id: 'obscot',
					width: 600,
					row: 2,
					binding:true,
					hiddenvalue:'',
					defaultvalue:'',
					allowBlank:true,
					autoCreate: {tag: 'textarea', type: 'text', size: '100', onkeypress: "return keyRestrict(event,'abcdefghijklmnopqrstuvwxyz ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.;,!@%&/\()?-+*[]{}');"},
				}]
			}]
		},
		{		
			layout: "column",
			defaults: {border: false},
			style: 'position:absolute;left:15px;top:270px',
			items: [{
				layout: "form",
				border: false,
				labelWidth: 150,
				items:[{
					xtype: "radiogroup",
					fieldLabel: "Asistencia Tcnica",
					labelSeparator:"",	
					columns: [100,100],
					id:'estasitec',
					binding:true,
					hiddenvalue:'',
					defaultvalue:0,
					allowBlank:true,
					items: [
							{boxLabel: 'S', name: 'asistencia_tecnica',inputValue: '1'},
							{boxLabel: 'No', name: 'asistencia_tecnica', inputValue: '0'}
						   ]
	    		}]
			}]
		},
		{
			layout: "column",
			defaults: {border: false},
			style: 'position:absolute;left:15px;top:300px',
			items: [{
				layout: "form",
				border: false,
				labelWidth: 150,
				items:[{
					xtype: "radiogroup",
					fieldLabel: "Cumple con Especificaciones",
					labelSeparator:"",	
					columns: [100,100],
					id:'estesp',
					binding:true,
					hiddenvalue:'',
					defaultvalue:0,
					allowBlank:true,
					items: [
							{boxLabel: 'S', name: 'especificaciones',inputValue: '1'},
							{boxLabel: 'No', name: 'especificaciones', inputValue: '0'}
						   ]
	    		}]
			}]
		},
		{
			layout:"column",
			border:false,
			style: 'position:absolute;left:15px;top:335px',
			items:[{
				layout:"form",
				border:false,
				labelWidth:150,
				items:[{
					xtype: 'textfield',
					labelSeparator :'',
					fieldLabel: 'Garantas',
					id: 'garanacot',
					width: 600,
					binding:true,
					hiddenvalue:'',
					autoCreate: {tag: 'input', type: 'text', size: '50', autocomplete: 'off', maxlength: '50', onkeypress: "return keyRestrict(event,'abcdefghijklmnopqrstuvwxyz ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.;,!@%&/\()?-+*[]{}');"},
					defaultvalue:'',
					allowBlank:true
				  }]
			  }]
		  },
		  {
			 	layout:"column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:365px',
				border:false,
				items:[{
					layout:"form",
					border:false,
					labelWidth:150,
					items:[{
						xtype: 'combo',
						fieldLabel: 'Forma de Pago',
						labelSeparator :'',
						id: 'forpagcom',
						store : stForpag,
						editable : false,
						displayField : 'den',
						valueField : 'cod',
						typeAhead : true,
						triggerAction : 'all',
						mode : 'local',
						emptyText:'----Seleccione----',
				   	    listWidth:250,
				        width:150,
				        binding:true,
						hiddenvalue:'',
						defaultvalue:'CONTADO',
					}]
				}]
		  },
		  {
			  layout:"column",
			  defaults: {border: false},
			  style: 'position:absolute;left:340px;top:365px',
			  border:false,
			  items:[{
				  layout:"form",
				  border:false,
			      items:[{
			    	  xtype: 'textfield',
					  labelSeparator :'',
					  fieldLabel: 'Plazo de entrega',
					  id: 'diaentcom',
					  width: 50,
					  binding:true,
					  hiddenvalue:'',
					  autoCreate: {tag: 'input', type: 'text', size: '50', autocomplete: 'off', maxlength: '50', onkeypress: "return keyRestrict(event,'0123456789');"},
					  defaultvalue:0,
					  allowBlank:true
				  }]
			 }]
		 },
		 {
			 layout: "column",
			 defaults: {border: false},
			 style: 'position:absolute;left:500px;top:375px',
			 items: [{
				 layout: "form",
				 border: false,
				 labelWidth: 50,
				 items: [{
					 xtype: 'label',
					 style:'font-weight: bold; border:none;background:#f1f1f1',
					 text: 'das.',					
					 id: 'label',						
				 }]
			 }]
		 },
		 {
			 layout:"column",
			 defaults: {border: false},
			 style: 'position:absolute;left:540px;top:365px',
			 border:false,
			 items:[{
				 layout:"form",
				 border:false,
				 labelWidth:130,
				 items:[{
					 xtype: 'textfield',
					 labelSeparator :'',
					 fieldLabel: 'Validz de la oferta',
					 id: 'diavalofe',
					 width: 50,
					 binding:true,
					 hiddenvalue:'',
					 autoCreate: {tag: 'input', type: 'text', size: '50', autocomplete: 'off', maxlength: '50', onkeypress: "return keyRestrict(event,'0123456789-');"},
					 defaultvalue:0,
					 allowBlank:true
				 }]
			 }] 
		 },
		 {
			 layout: "column",
			 defaults: {border: false},
			 style: 'position:absolute;left:730px;top:375px',
			 items: [{
				 layout: "form",
				 border: false,
				 labelWidth: 50,
				 items: [{
					 xtype: 'label',
					 style:'font-weight: bold; border:none;background:#f1f1f1',
					 text: 'das.',					
					 id: 'label',						
				 }]
			 }]
		 },{
				xtype: 'hidden',
				id: 'formato',
				binding:true,
				defaultvalue:'sigesp_soc_rfs_registro_cotizacion.php'
			}]
		}]
	});
	buscarNumCot();
	Ext.getCmp('numcot').on('focus',obtenerpermiso);	
	
}); //fin creando formulario principal con parametros de busqueda y grid de modificaciones
	
	//-------------------------------------------------------------------------------------------------------------------------	
	
	function irBuscar( ){
		CatalogoCotizaciones('RC',true);
	}
	
	function irNuevo(){
		irCancelar();
		var myJSONObject = {
				"operacion":"buscarNumero" 
			};
				
		var ObjSon=Ext.util.JSON.encode(myJSONObject);
		var parametros ='ObjSon='+ObjSon;
		Ext.Ajax.request({
			url: '../../controlador/soc/sigesp_ctr_soc_registro_cotizacion.php',
			params: parametros,
			method: 'POST',
			success: function ( result, request ) { 
		            var numero = result.responseText;
					if (numero != "") {
						Ext.getCmp('numcot').setValue(numero);
					}
			},
			failure: function ( result, request){ 
					Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
			}//fin del success
		});	//fin del ajax request
	}
	
	function irCancelar(){
		limpiarFormulario(fromRegistroCotizacion);
		limpiarFormulario(fromTotales);
		fromTotales.hide();
		gridBienes.store.removeAll();
		gridBienes.hide();
		gridServicios.store.removeAll();
		gridServicios.hide();
		Ext.getCmp('nompro').setText("");
	}
	
	function irGuardar(){
		var cadjson = '';
	    var stProveedor = null;
	    var valido = true;
	    var poriva = 0;
	    var aux = formatoNumericoMostrar(0,2,'.',',','','','-','');
	    
		obtenerMensaje('procesar','','Buscando Datos');
		var myJSONObject = {
				"operacion":"validarFecha" 
		};
		var ObjSon=Ext.util.JSON.encode(myJSONObject);
		var parametros ='ObjSon='+ObjSon;
		Ext.Ajax.request({
			url : '../../controlador/soc/sigesp_ctr_soc_registro_cotizacion.php',
			params : parametros,
			method: 'POST',
			success: function ( result, request){ 
				var fecha = result.responseText;
				if(Ext.getCmp('feccot').getValue().format('Y-m-d')<fecha && Actualizar==null){
					Ext.Msg.show({
						title:'Mensaje',
						msg: 'La fecha de la cotizacion no puede ser Menor, a la ltima cotizacion registrada!!!',
						buttons: Ext.Msg.OK,
						icon: Ext.MessageBox.WARNING
					});
				}
			    else{
			    	if(Actualizar == null) {
			        	cadjson = "{'operacion':'incluir',"+getJsonFormulario(fromRegistroCotizacion);
			        } 
			        else{
			        	if(Ext.getCmp('estcot').getValue()=='1'){
			    	    	Ext.Msg.show({
			    				title:'Mensaje',
			    				msg: 'La Cotizacion ya fue procesada, No puede ser modificada!!!',
			    				buttons: Ext.Msg.OK,
			    				icon: Ext.MessageBox.ERROR
			    			});
			    	    	valido = false;
			    	    }
			        	else{
			        		cadjson = "{'operacion':'actualizar',"+getJsonFormulario(fromRegistroCotizacion);
			        	}
			        }
			        
			        var numcot  = Ext.getCmp('numcot').getValue();
			        var tipcot  = Ext.getCmp('tipcot').getValue();
					var codpro  = Ext.getCmp('cod_pro').getValue();
			        var numDetalle = 0;
			        cadjson += ",'detallesBienesServicios':[";	
			        
			        if(tipcot=='B'){
			        	stBie = gridBienes.getStore();
			        	if(Ext.getCmp('numsolcot').getValue() == ''){
				        	Ext.Msg.show({
				            	title:'Advertencia',
				                msg: 'Debe seleccionar al menos una Solicitud, para procesar la informacion',
				                buttons: Ext.Msg.OK,
				                icon: Ext.MessageBox.WARNING
				    		});
				        	valido = false;
				        }
			        	if(Ext.getCmp('cod_pro').getValue() == ''){
				        	Ext.Msg.show({
				            	title:'Advertencia',
				                msg: 'Debe seleccionar al menos un Proveedor, para procesar la informacion',
				                buttons: Ext.Msg.OK,
				                icon: Ext.MessageBox.WARNING
				    		});
				        	valido = false;
				        }
			        	if(stBie.getCount()>0){
			        		if(stBie.getCount()==1){
				        		poriva = stBie.getAt(0).get('porcar');
				        	}
			        		stBie.each(function (reBie){
		        				if(reBie.get('canart')<=aux || reBie.get('preuniart')<=aux){
		            				Ext.Msg.show({
		            	        		title:'Advertencia',
		            	            	msg: 'La Cantidad y el Precio del Artculo '+reBie.get('codart')+ ' deben ser mayor a cero',
		            	            	buttons: Ext.Msg.OK,
		            	            	icon: Ext.MessageBox.WARNING
		            				});
		            				valido = false;
		            			}
			        		});
			        		if(valido){
			        			stBie.each(function (reBien){
			        				var nivelcalidad = 'E';
				        			if(numDetalle==0){
				        				if(reBien.get('nivcalart')!=undefined){
				        					nivelcalidad = reBien.get('nivcalart');
				        				}
				        			    cadjson +="{'numcot':'"+numcot+"','cod_pro':'"+codpro+"','codart':'"+trim(reBien.get('codart'))+"'," +
				        			    		"'unidad':'"+reBien.get('unidad')+"','canart':'"+reBien.get('canart')+"'," +
				        			    		"'preuniart':'"+reBien.get('preuniart')+"','moniva':'"+reBien.get('moniva')+"'," +
				        			    		"'monsubart':'"+reBien.get('monsubart')+"','montotart':'"+reBien.get('montotart')+"'," +
				        			    		"'nivcalart':'"+nivelcalidad+"'}";
				        			}
				        			else{
				        				if(reBien.get('nivcalart')!=undefined){
				        					nivelcalidad = reBien.get('nivcalart');
				        				}
				        				cadjson +=",{'numcot':'"+numcot+"','cod_pro':'"+codpro+"','codart':'"+trim(reBien.get('codart'))+"'," +
				        			    		"'unidad':'"+reBien.get('unidad')+"','canart':'"+reBien.get('canart')+"'," +
				        			    		"'preuniart':'"+reBien.get('preuniart')+"','moniva':'"+reBien.get('moniva')+"'," +
				        			    		"'monsubart':'"+reBien.get('monsubart')+"','montotart':'"+reBien.get('montotart')+"'," +
				        			    		"'nivcalart':'"+nivelcalidad+"'}";
				        			}
				        			numDetalle++;
				        		});
			        		}
			        	}
			        }
			        if(tipcot=='S'){
			        	stSer = gridServicios.getStore();
			        	if(stSer.getCount() == 0){
				        	Ext.Msg.show({
				            	title:'Advertencia',
				                msg: 'Debe seleccionar al menos una Solicitud, para procesar la informacion',
				                buttons: Ext.Msg.OK,
				                icon: Ext.MessageBox.WARNING
				    		});
				        	valido = false;
				        }
			        	else{
			        		if(stSer.getCount()==1){
				        		poriva = stSer.getAt(0).get('porcar');
				        	}
				        	stSer.each(function (reSer){
		        				if(reSer.get('canser')<=aux || reSer.get('monuniser')<=aux){
		            				Ext.Msg.show({
		            	        		title:'Advertencia',
		            	            	msg: 'La Cantidad y el Precio del Servicio '+reSer.get('codser')+ ' deben ser mayor a cero',
		            	            	buttons: Ext.Msg.OK,
		            	            	icon: Ext.MessageBox.WARNING
		            				});
		            				valido = false;
		            			}
			        		});
				        	if(valido){
				        		stSer.each(function (reServicio){
				        			var nivelcalidad = 'E';
				        			if(numDetalle==0){
				        				if(reServicio.get('nivcalser')!=undefined){
				        					nivelcalidad = reServicio.get('nivcalser');
				        				}
				        				cadjson +="{'numcot':'"+numcot+"','cod_pro':'"+codpro+"','codser':'"+trim(reServicio.get('codser'))+"'," +
				        			   		    "'canser':'"+reServicio.get('canser')+"','monuniser':'"+reServicio.get('monuniser')+"'," +
				        			   		    "'moniva':'"+reServicio.get('moniva')+"','monsubser':'"+reServicio.get('monsubser')+"'," +
				        			   		    "'montotser':'"+reServicio.get('montotser')+"','nivcalser':'"+nivelcalidad+"'}";
				        			}
				        			else{
				        				if(reServicio.get('nivcalser')!=undefined){
				        					nivelcalidad = reServicio.get('nivcalser');
				        				}
				        			    cadjson +=",{'numcot':'"+numcot+"','cod_pro':'"+codpro+"','codser':'"+trim(reServicio.get('codser'))+"'," +
				        			   		    "'canser':'"+reServicio.get('canser')+"','monuniser':'"+reServicio.get('monuniser')+"'," +
				        			   		    "'moniva':'"+reServicio.get('moniva')+"','monsubser':'"+reServicio.get('monsubser')+"'," +
				        			   		    "'montotser':'"+reServicio.get('montotser')+"','nivcalser':'"+nivelcalidad+"'}";
				        			}
				        			numDetalle++;
				        		});
				        	}
			        	}
			        }
			        cadjson += "],'poriva':'"+poriva+"'}";
			        if(valido){
			        	try{
			        		var objjson = Ext.util.JSON.decode(cadjson);
			        		if(typeof(objjson) == 'object'){
			        			var parametros = 'ObjSon=' + cadjson;
			        			Ext.Ajax.request({
			        				url : '../../controlador/soc/sigesp_ctr_soc_registro_cotizacion.php',
			        				params : parametros,
			        				method: 'POST',
			        				success: function ( result, request){
				        				if(Actualizar==null){
					            			var datos = result.responseText;
						            		var Registros = datos.split("|");
						            		switch(Registros[1]){
						            			case '1':
						            				Ext.Msg.show({
							                        	title:'Mensaje',
							                            msg: exitoguardar,
							                            buttons: Ext.Msg.OK,
							                            icon: Ext.MessageBox.INFO
							                        });
						            				irCancelar();
						            				irNuevo();
							                        Actualizar=null;
						            				break;
						            			case '-1':
						            				Ext.Msg.show({
														title:'Mensaje',
														msg: 'Registro guardado con exito, con el codigo '+Registros[2],
														buttons: Ext.Msg.OK,
														icon: Ext.MessageBox.INFO
													});
						            				irCancelar();
						            				irNuevo();
							                        Actualizar=null;
						            				break;
						            			case '0':
						            				Ext.Msg.show({
							                        	title:'Mensaje',
							                            msg: errorguardar,
							                            buttons: Ext.Msg.OK,
							                            icon: Ext.MessageBox.ERROR
							                        });
						            				break;
						            		}
					            		}
					            		else{
					            			var codigo = result.responseText;
						                    if(String.trim(codigo) == '1'){
						                    	Ext.Msg.show({
						                        	title:'Mensaje',
						                            msg: exitoguardar,
						                            buttons: Ext.Msg.OK,
						                            icon: Ext.MessageBox.INFO
						                        });
						                    	irCancelar();
						                    	irNuevo();
						                        Actualizar=null;
						                    }
						                    else{
						                    	Ext.Msg.show({
						                        	title:'Mensaje',
						                            msg: errorguardar,
						                            buttons: Ext.Msg.OK,
						                            icon: Ext.MessageBox.ERROR
						                        });
						                    }
					            		}
			        		    	}
			        			});
			        		}
			        	}	
			        	catch(e){
			        		alert('Verifique los datos, esta insertando caracteres invalidos '+e);
			        	}
			        }
			    }
	    	},
	    	failure: function ( result, request){ 
	    		Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
	    	}
       });
	}

	function irImprimir(){
		var reporte='';
		if(Actualizar){
			if(Ext.getCmp('tipcot').getValue()!=''){
				var myJSONObject = {
						"operacion" : "select_config",
						"sistema"   : "SOC",
						"seccion"   : "REPORTE",
						"variable"  : "FORMATO_REGCOT",
						"valor"     : "sigesp_soc_rfs_registro_cotizacion.php",
						"tipo"      : "C"
				};
				var ObjSon=Ext.util.JSON.encode(myJSONObject);
				var parametros ='ObjSon='+ObjSon;
				Ext.Ajax.request({
					url: '../../controlador/soc/sigesp_ctr_soc_registro_cotizacion.php',
					params: parametros,
					method: 'POST',
					success: function ( result, request ) { 
							var config = result.responseText;
							if (config != '')
							{
								Ext.getCmp('formato').setValue(config);
								reporte=Ext.getCmp('formato').getValue();
								var JSONObject = {
										'numcot' : Ext.getCmp('numcot').getValue(),
										'codpro' : Ext.getCmp('cod_pro').getValue(),
								        'feccot' : Ext.getCmp('feccot').getValue().format('Y-m-d'),
									    'tipcot' : Ext.getCmp('tipcot').getValue(),
									    'tiporeporte':'BsF.'
								}
								var ObjSon = JSON.stringify(JSONObject); 
								window.open("reporte/"+reporte+"?ObjSon="+ObjSon,"menubar=no,toolbar=no,scrollbars=yes,width=800,height=600,left=0,top=0,location=no,resizable=yes");
							}
					},
					failure: function ( result, request){ 
							Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
					}
				});
			}
			else{
				alert("Debe seleccionar un Tipo de Solicitud vlida (Bienes/Servicios) !!!");
			}
		}
		else{
			alert("Debe existir un documento a imprimir !!!");
		}
	}
	
	function irEliminar(){
		
		var aux = formatoNumericoMostrar(0,2,'.',',','','','-','');
		var valido = true;
		function respuesta(btn){
			if(btn=='yes'){
				var cadjson = "{'operacion':'eliminar',"+getJsonFormulario(fromRegistroCotizacion);
				
				var poriva = 0;
				var numcot  = Ext.getCmp('numcot').getValue();
		        var tipcot  = Ext.getCmp('tipcot').getValue();
				var codpro  = Ext.getCmp('cod_pro').getValue();
		        var numDetalle = 0;
		        cadjson += ",'detallesBienesServicios':[";
		        
		        if(tipcot=='B'){
		        	stBie = gridBienes.getStore();
		        	if(stBie.getCount() == 0){
			        	Ext.Msg.show({
			            	title:'Advertencia',
			                msg: 'Debe seleccionar al menos una Solicitud, para procesar la informacion',
			                buttons: Ext.Msg.OK,
			                icon: Ext.MessageBox.WARNING
			    		});
			        	valido = false;
			        }
		        	else{
		        		if(stBie.getCount()==1){
			        		poriva = stBie.getAt(0).get('porcar');
			        	}
		        		stBie.each(function (reBie){
	        				if(reBie.get('canart')<=aux || reBie.get('preuniart')<=aux){
	            				Ext.Msg.show({
	            	        		title:'Advertencia',
	            	            	msg: 'La Cantidad y el Precio del Artculo '+reBie.get('codart')+ ' deben ser mayor a cero',
	            	            	buttons: Ext.Msg.OK,
	            	            	icon: Ext.MessageBox.WARNING
	            				});
	            				valido = false;
	            			}
		        		});
		        		if(valido){
		        			stBie.each(function (reBien){
		        				var nivelcalidad = 'E';
			        			if(numDetalle==0){
			        				if(reBien.get('nivcalart')!=undefined){
			        					nivelcalidad = reBien.get('nivcalart');
			        				}
			        			    cadjson +="{'numcot':'"+numcot+"','cod_pro':'"+codpro+"','codart':'"+trim(reBien.get('codart'))+"'," +
			        			    		"'unidad':'"+reBien.get('unidad')+"','canart':'"+reBien.get('canart')+"'," +
			        			    		"'preuniart':'"+reBien.get('preuniart')+"','moniva':'"+reBien.get('moniva')+"'," +
			        			    		"'monsubart':'"+reBien.get('monsubart')+"','montotart':'"+reBien.get('montotart')+"'," +
			        			    		"'nivcalart':'"+nivelcalidad+"'}";
			        			}
			        			else{
			        				if(reBien.get('nivcalart')!=undefined){
			        					nivelcalidad = reBien.get('nivcalart');
			        				}
			        				cadjson +=",{'numcot':'"+numcot+"','cod_pro':'"+codpro+"','codart':'"+trim(reBien.get('codart'))+"'," +
			        			    		"'unidad':'"+reBien.get('unidad')+"','canart':'"+reBien.get('canart')+"'," +
			        			    		"'preuniart':'"+reBien.get('preuniart')+"','moniva':'"+reBien.get('moniva')+"'," +
			        			    		"'monsubart':'"+reBien.get('monsubart')+"','montotart':'"+reBien.get('montotart')+"'," +
			        			    		"'nivcalart':'"+nivelcalidad+"'}";
			        			}
			        			numDetalle++;
			        		});
		        		}
		        	}
		        }
		        if(tipcot=='S'){
		        	stSer = gridServicios.getStore();
		        	if(stSer.getCount() == 0){
			        	Ext.Msg.show({
			            	title:'Advertencia',
			                msg: 'Debe seleccionar al menos una Solicitud, para procesar la informacion',
			                buttons: Ext.Msg.OK,
			                icon: Ext.MessageBox.WARNING
			    		});
			        	valido = false;
			        }
		        	else{
		        		if(stSer.getCount()==1){
			        		var poriva = stSer.getAt(0).get('porcar');
			        	}
			        	stSer.each(function (reSer){
	        				if(reSer.get('canser')<=aux || reSer.get('monuniser')<=aux){
	            				Ext.Msg.show({
	            	        		title:'Advertencia',
	            	            	msg: 'La Cantidad y el Precio del Servicio '+reSer.get('codser')+ ' deben ser mayor a cero',
	            	            	buttons: Ext.Msg.OK,
	            	            	icon: Ext.MessageBox.WARNING
	            				});
	            				valido = false;
	            			}
		        		});
			        	if(valido){
			        		stSer.each(function (reServicio){
			        			var nivelcalidad = 'E';
			        			if(numDetalle==0){
			        				if(reServicio.get('nivcalser')!=undefined){
			        					nivelcalidad = reServicio.get('nivcalser');
			        				}
			        				cadjson +="{'numcot':'"+numcot+"','cod_pro':'"+codpro+"','codser':'"+trim(reServicio.get('codser'))+"'," +
			        			   		    "'canser':'"+reServicio.get('canser')+"','monuniser':'"+reServicio.get('monuniser')+"'," +
			        			   		    "'moniva':'"+reServicio.get('moniva')+"','monsubser':'"+reServicio.get('monsubser')+"'," +
			        			   		    "'montotser':'"+reServicio.get('montotser')+"','nivcalser':'"+nivelcalidad+"'}";
			        			}
			        			else{
			        				if(reServicio.get('nivcalser')!=undefined){
			        					nivelcalidad = reServicio.get('nivcalser');
			        				}
			        			    cadjson +=",{'numcot':'"+numcot+"','cod_pro':'"+codpro+"','codser':'"+trim(reServicio.get('codser'))+"'," +
			        			   		    "'canser':'"+reServicio.get('canser')+"','monuniser':'"+reServicio.get('monuniser')+"'," +
			        			   		    "'moniva':'"+reServicio.get('moniva')+"','monsubser':'"+reServicio.get('monsubser')+"'," +
			        			   		    "'montotser':'"+reServicio.get('montotser')+"','nivcalser':'"+nivelcalidad+"'}";
			        			}
			        			numDetalle++;
			        		});
			        	}
		        	}
		        }
		        cadjson += "],'poriva':'"+poriva+"'}";
				
		        if(valido){
		        	try{
						var objjson = Ext.util.JSON.decode(cadjson);
						if(typeof(objjson) == 'object'){
							var parametros = 'ObjSon=' + cadjson;
							Ext.Ajax.request({
								url : '../../controlador/soc/sigesp_ctr_soc_registro_cotizacion.php',
								params : parametros,
								method: 'POST',
								success: function ( result, request){
									var codigo = result.responseText;
									if(String.trim(codigo) == '1'){
										Ext.Msg.show({
											title:'Mensaje',
											msg: 'Registro eliminado con exito',
											buttons: Ext.Msg.OK,
											icon: Ext.MessageBox.INFO
										});
										irCancelar();
										irNuevo();
										Actualizar=null;
									}
									else{
										Ext.Msg.show({
											title:'Mensaje',
											msg: 'Error al tratar de eliminar el registro <br>',
											buttons: Ext.Msg.OK,
											icon: Ext.MessageBox.ERROR
										});
									}							
								}//fin del success	
							});//fin del ajax request
						}
					}
					catch(e){
						alert('error'+e);
					}
		        }
			}
		}	
		if(Actualizar){
			if(Ext.getCmp('estcot').getValue()=='1'){
				Ext.Msg.show({
					title:'Mensaje',
					msg: 'La Cotizacion ya ha sido procesada, No puede ser modificada!!!',
					buttons: Ext.Msg.OK,
					icon: Ext.MessageBox.ERROR
				});
			}
			else{
				if(tbadministrativo){
					Ext.MessageBox.confirm('Confirmar', '&#191;Desea eliminar este registro&#63;', respuesta);
				}
				else{
					var myJSONObject = {
							"operacion":"buscarUltimoNumero" 
					};
					var ObjSon=Ext.util.JSON.encode(myJSONObject);
					var parametros ='ObjSon='+ObjSon;
					Ext.Ajax.request({
						url : '../../controlador/soc/sigesp_ctr_soc_registro_cotizacion.php',
						params : parametros,
						method: 'POST',
						success: function ( result, request) { 
							var codigo = result.responseText;
							if(trim(codigo)==trim(Ext.getCmp('numcot').getValue())){
								Ext.MessageBox.confirm('Confirmar', '&#191;Desea eliminar este registro&#63;', respuesta);
							}
							else{
								Ext.Msg.show({
									title:'Mensaje',
									msg: 'La Cotizacion no puede ser Eliminada, no es el ltimo archivo registrado!!!',
									buttons: Ext.Msg.OK,
									icon: Ext.MessageBox.ERROR
								});
							}
						},
						failure: function ( result, request){ 
								Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
						}
					});
				}
			} 
		}
		else{
			Ext.Msg.show({
					title:'Mensaje',
					msg: 'El registro debe estar guardado para poder eliminarlo, verifique por favor',
					buttons: Ext.Msg.OK,
					icon: Ext.MessageBox.ERROR
			}); 
		}

	}
	
	function MostrarCalidad(valor){
		if(valor=='E'){
			return 'Excelente';
		}
		if(valor=='B'){
			return 'Bueno';
		}
		if(valor=='R'){
			return 'Regular';
		}
		if(valor=='M'){
			return 'Malo';
		}
	}





