function CatalogoSolicitudCotizacion(codProceso,tipo){
	
	
	//Data del combo tipo distribucion
	var reTipo = [ [ 'BIENES', 'B' ], 
	             [ 'SERVICIOS', 'S' ] ];
	
	var stTipo = new Ext.data.SimpleStore({
		fields : [ 'col', 'tipo' ],
		data : reTipo
	});
	
	//--------------------------------------------------------------------------------
	
	function obtenerTipo(){
		if(tipo!=''){
			Ext.getCmp('tipsol').setValue(tipo);
			Ext.getCmp('tipsol').disable();
		}
	}
	
	
	//--------------------------------------------------------------------------------
		
	//Creando el campo de solicitud de cotizacion
	var reVentana = Ext.data.Record.create([
          {name: 'numsolcot'}, 
          {name: 'fecsol'},
          {name: 'consolcot'},
          {name: 'obssol'},
          {name: 'estcot'},
          {name: 'cedper'},
          {name: 'nomper'},
          {name: 'nomcompleto'},
          {name: 'codcar'},
          {name: 'soltel'},
          {name: 'solfax'},
          {name: 'coduniadm'},
          {name: 'denuniadm'},
          {name: 'codestpro1'},
          {name: 'codestpro2'},
          {name: 'codestpro3'},
          {name: 'codestpro4'},
          {name: 'codestpro5'},
          {name: 'estcla'},
          {name: 'tipsolcot'},
          {name: 'uniejeaso'},
          {name: 'codfuefin'},
          {name: 'tipsolbie'}
	]);
	                                        	
	var dsVentana =  new Ext.data.Store({
           reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reVentana)
	});
	                                						
	 var cmVentana = new Ext.grid.ColumnModel([
           {header: "<H1 align='center'>Nro. Solicitud</H1>", width: 40, sortable: true, dataIndex: 'numsolcot'},
           {header: "<H1 align='center'>Observacion</H1>", width: 60, sortable: true, dataIndex: 'obssol'},
		   {header: "<H1 align='center'>Fecha</H1>", width: 30, sortable: true, dataIndex: 'fecsol'}
	]);
	//fin creando datastore y columnmodel para el catalogo de solicitud de cotizacion
	 
	 gridVentanaCatalogoSolCot = new Ext.grid.GridPanel({
	 		width:550,
	 		height:280,
			frame:true,
			style: 'position:absolute;left:0px;top:130px',
			autoScroll:true,
			enableColumnHide: false,
			enableHdMenu: false,
			border:true,
			ds: dsVentana,
    		cm: cmVentana,
    		stripeRows: true,
    		viewConfig: {forceFit:true}
	});
	 
	gridVentanaCatalogoSolCot.on({
		'rowdblclick': {
			fn: function(grid, numFila, evento){
				var registro = grid.getStore().getAt(numFila);
				Aceptar(registro);
 		    }
		}
	});
	 
	//-------------------------------------------------------------------------------------------------------------------------		 
	 
	//Creacion del formulario del catalogo de solicitud de cotizacion
	 
	var formVentanaCatalogoSolCot = new Ext.FormPanel({
		width: 600,
		height: 450,
		style: 'position:absolute;left:5px;top:10px',
		frame: true,
		autoScroll:false,
		items: [{
			xtype:"fieldset", 
			title:'Datos de la Solicitud',
			style: 'position:absolute;left:10px;top:5px',
			border:true,
			width: 550,
			cls :'fondo',
			height: 120,
			items:[ {
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:20px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Nro. Solicitud',
						name: 'nro_solicitud',
						id: 'numsolic',									
						width: 150,
						changeCheck: function(){
							var textvalor = this.getValue();
							dsVentana.filter('numsolcot',textvalor,true);
							if(String(textvalor) !== String(this.startValue)){
								this.fireEvent('change', this, textvalor, this.startValue);
							} 
						}, 
						initEvents: function(){
							AgregarKeyPress(this);
						},
						autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '15', onkeypress: "return keyRestrict(event,'0123456789');"}
					}]
				}]
			},
			{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:50px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype: 'combo',
						fieldLabel: 'Tipo',
						labelSeparator :'',
						id: 'tipsol',
						store : stTipo,
						editable : false,
						displayField : 'col',
						valueField : 'tipo',
						typeAhead : true,
						triggerAction : 'all',
						mode : 'local',
						emptyText:'----Seleccione----',
						listWidth:150,
						width:150,
						changeCheck: function(){
							var textvalor = this.getValue();
							dsVentana.filter('tipsolcot',textvalor,true);
							if(String(textvalor) !== String(this.startValue)){
								this.fireEvent('change', this, textvalor, this.startValue);
							} 
						}, 
						initEvents: function(){
							AgregarKeyPress(this);
						}
					}]
				}]
			},
			{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:360px;top:20px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 50,
					items: [{
						xtype:"datefield",
						labelSeparator :'',
						fieldLabel:"Desde",
						name:"fechadesde",
						id: 'fecsolcotdesde',
						value: new Date().format('01/m/Y'),
						allowBlank:true,
						changeCheck: function(){
							var textvalor = this.getValue();
							dsVentana.filter('fecsol',textvalor,true);
							if(String(textvalor) !== String(this.startValue)){
								this.fireEvent('change', this, textvalor, this.startValue);
							} 
						}, 
						initEvents: function(){
							AgregarKeyPress(this);
						},
						autoCreate: {tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789/');"}	
					}]
				}]
			},
			{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:360px;top:50px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 50,
					items: [{
						xtype:"datefield",
						fieldLabel:"Hasta",
						labelSeparator :'',
						name:"fechahasta",
						id: 'fecsolcothasta',
						value: new Date().format('d/m/Y'),
						allowBlank:true,
						changeCheck: function(){
							var textvalor = this.getValue();
							dsVentana.filter('fecsol',textvalor,true);
							if(String(textvalor) !== String(this.startValue)){
								this.fireEvent('change', this, textvalor, this.startValue);
							} 
						}, 
						initEvents: function(){
							AgregarKeyPress(this);
						},
						autoCreate: {tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789/');"}	
					}]
				}]
			},gridVentanaCatalogoSolCot,
			{
		   		layout:"column",
		   		defaults: {border: false},
		   		style: 'position:absolute;left:420px;top:85px',
		   		border:false,
		   		items:[{
		   			layout:"form",
		   			border:false,
		   			items:[{
		   				xtype: 'button',
		   				labelSeparator :'',
		   				fieldLabel: '',
		   				id: 'btbuscar',
		   				text: 'Buscar',
		   				width: 300,
		   				height: 300,
		   				iconCls: 'menubuscar',
		   				handler: function(){
		   				
		   				if((Ext.getCmp('fecsolcotdesde').getValue()) > (Ext.getCmp('fecsolcothasta').getValue())){
		   					valido = false;
		   					Ext.MessageBox.show({
			 					title:'Advertencia',
			 					msg:'El rango de fechas no es valido!!!',
			 					buttons: Ext.Msg.OK,
			 					icon: Ext.MessageBox.WARNING
			 				});
		   				}
		   				else{
		   				    obtenerMensaje('procesar','','Buscando Datos');
			   				
							//buscar solicitudes de cotizacion
		   				    var JSONObject = {
			   					'operacion'      : 'buscar_solcot',
			   					'numsolcot'      : Ext.getCmp('numsolic').getValue(),
			   					'tipsolcot'      : Ext.getCmp('tipsol').getValue(),
			   					'fecdes'         : Ext.getCmp('fecsolcotdesde').getValue().format('y/m/d'),
		   			    	    'fechas'         : Ext.getCmp('fecsolcothasta').getValue().format('y/m/d'),
			   				}
						
			   				var ObjSon = JSON.stringify(JSONObject);
			   				var parametros = 'ObjSon='+ObjSon; 
			   				Ext.Ajax.request({
			   					url : '../../controlador/soc/sigesp_ctr_soc_solicitud_cotizacion.php',
			   					params : parametros,
			   					method: 'POST',
			   					success: function (resultado, request){
				   					Ext.Msg.hide();
			   						var datos = resultado.responseText;
			   						var objSolcot = eval('(' + datos + ')');
			   						if(objSolcot!=''){
			   							if(objSolcot!='0'){
			   								if(objSolcot.raiz == null || objSolcot.raiz ==''){
			   									Ext.MessageBox.show({
								 					title:'Advertencia',
								 					msg:'No existen datos para mostrar',
								 					buttons: Ext.Msg.OK,
								 					icon: Ext.MessageBox.WARNING
								 				});
											}
											else{
			   									gridVentanaCatalogoSolCot.store.loadData(objSolcot);
											}
			   							}
			   							else{
			   								Ext.MessageBox.show({
								 				title:'Advertencia',
								 				msg:'Debe configurar en Empresa los digitos de las cuentas de gastos',
								 				buttons: Ext.Msg.OK,
								 				icon: Ext.MessageBox.WARNING
								 			});
			   							}
			   						}
			   					}//fin del success	
			   				});//fin del ajax request
		   				}
		   				}
		   			}]
		   		}]
   	     	}]  
		}]   	
	});
	obtenerTipo();
	//fin del formulario 

	//-------------------------------------------------------------------------------------------------------------------------		 
	
	var ventanaCatalogoSolCot = new Ext.Window({
		title: "<H1 align='center'>Cat&#225;logo de Solicitudes de Cotizaciones</H1>",
		width:600,
		height:520,
		modal: true,
		closable:false,
		plain: false,
		frame:true,
		items:[formVentanaCatalogoSolCot],
		buttons: [{
			text:'Aceptar',  
				handler: function(){		
					var registro = gridVentanaCatalogoSolCot.getSelectionModel().getSelected();
					Aceptar(registro);
				}
			},
			{
			text: 'Salir',
				handler:function(){
					ventanaCatalogoSolCot.close();
				}
			}
		]
	});
	ventanaCatalogoSolCot.show();
	
	function Aceptar(registro){
		if(codProceso=='SC'){
			limpiarFormulario(fromSolicitudCotizacion);
			gridBienes.store.removeAll();
			gridServicios.store.removeAll();
			gridBienes.hide();
			gridServicios.hide();
			gridProveedores.store.removeAll();
			gridSEP.store.removeAll();
			setDataFrom(fromSolicitudCotizacion,registro);
			//tipsolbie
			if(registro.get('tipsolbie')=='0'){
				Ext.getCmp('tipsolbie').items.items[0].checked;
			}
			if(registro.get('tipsolbie')=='1'){
				Ext.getCmp('tipsolbie').items.items[1].checked;
			}
			//estcot
			if(registro.get('estcot')=='R'){
				Ext.getCmp('estcotlabel').setValue('REGISTRADA');
			}
			if(registro.get('estcot')=='P'){
				Ext.getCmp('estcotlabel').setValue('PROCESADA');
			}
			if(registro.get('estcot')=='A'){
				Ext.getCmp('estcotlabel').setValue('ANULADA');
			}
			var numsolcot = registro.get('numsolcot');
			Actualizar = true;
			var reArt = Ext.data.Record.create([
				{name: 'codart'}, 
				{name: 'denart'},
				{name: 'canart'},
				{name: 'coduniadm'},
				{name: 'unidad'},
				{name: 'numsep'},
			    {name: 'codestpro1'},
			    {name: 'codestpro2'},
			    {name: 'codestpro3'},
			    {name: 'codestpro4'},
			    {name: 'codestpro5'},
			    {name: 'estcla'},
			    {name: 'codfuefin'},
			    {name: 'unidad'},
			    {name: 'denunimed'}
				
			]);
			var reSer = Ext.data.Record.create([
				{name: 'codser'}, 
				{name: 'denser'},
				{name: 'canser'},
				{name: 'coduniadm'},
				{name: 'numsep'},
				{name: 'codestpro1'},
			    {name: 'codestpro2'},
			    {name: 'codestpro3'},
			    {name: 'codestpro4'},
			    {name: 'codestpro5'},
			    {name: 'estcla'},
			    {name: 'codfuefin'}
			]);
			var rePro = Ext.data.Record.create([
				{name: 'cod_pro'}, 
				{name: 'nompro'},
				{name: 'dirpro'},
				{name: 'telpro'}
			]);
			var reSEP = Ext.data.Record.create([
				{name: 'numsep'},
				{name: 'densep'},
				{name: 'monsep'},
			    {name: 'codunieje'},
			    {name: 'codestpro1'},
			    {name: 'codestpro2'},
			    {name: 'codestpro3'},
			    {name: 'codestpro4'},
			    {name: 'codestpro5'},
			    {name: 'estcla'},
			    {name: 'codfuefin'}
			]);
			obtenerMensaje('procesar','','Buscando Datos');
			var JSONObject = {
				'operacion' : 'cargarBienesServicios',
				'numsolcot' : numsolcot,
				'tipsolcot' : registro.get('tipsolcot'),
				'codpro'    : ""
			}			
			var ObjSon = JSON.stringify(JSONObject);
			var parametros = 'ObjSon='+ObjSon; 
			Ext.Ajax.request({
				  url : '../../controlador/soc/sigesp_ctr_soc_solicitud_cotizacion.php',
				  params : parametros,
				  method: 'POST',
				  success: function ( resultado, request){
				  	Ext.Msg.hide();
				  		var resultado = resultado.responseText;
				  		var objDatos = eval('(' + resultado + ')');
				  		var datos = objDatos.raiz;
				  		if (objDatos != ""){
								if(registro.get('tipsolcot')=='B'){
									Ext.getCmp('tipsolbie').enable();
									fromSolicitudCotizacion.add(gridBienes);
									gridBienes.show();
									fromSolicitudCotizacion.doLayout();
									for(var j = 0; j < datos.length; j++){
										var bienesInt = new reArt({
	    									'codart'     :datos[j].codart,
	    									'denart'     :datos[j].denart,
	    									'canart'     :datos[j].canart,
	    									'unidad'     :datos[j].unidad,
	    									'modalidad'  :datos[j].unidad,
	    									'numsep'     :datos[j].numsep,
	    									'denunimed'  :datos[j].denunimed,
	    									'coduniadm'  :datos[j].coduniadm,
		      							    'codfuefin'  :datos[j].codfuefin,
		      							    'codestpro1' :datos[j].codestpro1,
		      							    'codestpro2' :datos[j].codestpro2,
		      							    'codestpro3' :datos[j].codestpro3,
		      							    'codestpro4' :datos[j].codestpro4,
		      							    'codestpro5' :datos[j].codestpro5,
		      							    'estcla'     :datos[j].estcla
	    									
										});
										gridBienes.store.insert(0,bienesInt);
									}
								}
								else{
									Ext.getCmp('tipsolbie').disable();
									fromSolicitudCotizacion.add(gridServicios);
									gridServicios.show();
									fromSolicitudCotizacion.doLayout();
  								for(var j = 0; j < datos.length; j++){
	    								var serviciosInt = new reSer({
	    									'codser'    :datos[j].codser,
	    									'denser'    :datos[j].denser,
	    									'canser'    :datos[j].canser,
	    									'numsep'    :datos[j].numsep,
	    									'coduniadm' :datos[j].coduniadm,
		      							    'codfuefin' :datos[j].codfuefin,
		      							    'codestpro1':datos[j].codestpro1,
		      							    'codestpro2':datos[j].codestpro2,
		      							    'codestpro3':datos[j].codestpro3,
		      							    'codestpro4':datos[j].codestpro4,
		      							    'codestpro5':datos[j].codestpro5,
		      							    'estcla'    :datos[j].estcla
	    								});
	    								gridServicios.store.insert(0,serviciosInt);
	    							}
								}
							}
			  	  	},
	    				failure: function ( result, request){ 
  						Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
			  	  	}//fin del success
				});//fin del ajax request
				obtenerMensaje('procesar','','Buscando Datos');
				var JSONObject = {
						'operacion' : 'cargarProveedores',
						'numsolcot' : numsolcot,
						'tipsolcot' : registro.get('tipsolcot'),
						'codpro'    : '',
						'nompro'    : ''
				}			
				var ObjSon = JSON.stringify(JSONObject);
				var parametros = 'ObjSon='+ObjSon; 
				Ext.Ajax.request({
					url : '../../controlador/soc/sigesp_ctr_soc_solicitud_cotizacion.php',
					params : parametros,
					method: 'POST',
					success: function ( resultado, request){
				  		Ext.Msg.hide();
				  			var resultado = resultado.responseText;
				  			var objDatos = eval('(' + resultado + ')');
				  			var datos = objDatos.raiz;
				  			if (objDatos != ""){
				  				for(var j = 0; j < datos.length; j++){
				  					var proveedorInt = new rePro({
				  						'cod_pro'    :datos[j].cod_pro,
				  						'nompro'     :datos[j].nompro,
				  						'dirpro'     :datos[j].dirpro,
				  						'telpro'     :datos[j].telpro
				  					});
				  					gridProveedores.store.insert(0,proveedorInt);
      	    					}
				  			}
			  	  		},
			  	  		failure: function ( result, request){ 
			  	  			Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
			  	  		}//fin del success
					});//fin del ajax request
					obtenerMensaje('procesar','','Buscando Datos');
					var JSONObject = {
							'operacion' : 'cargarSEP',
							'numsolcot' : numsolcot
					}			
					var ObjSon = JSON.stringify(JSONObject);
					var parametros = 'ObjSon='+ObjSon; 
					Ext.Ajax.request({
						url : '../../controlador/soc/sigesp_ctr_soc_solicitud_cotizacion.php',
						params : parametros,
						method: 'POST',
						success: function ( resultado, request){
					  		Ext.Msg.hide();
					  		var resultado = resultado.responseText;
					  		var objDatos = eval('(' + resultado + ')');
					  		var datos = objDatos.raiz;
					  		if(objDatos != ""){
					  			for(var j = 0; j < datos.length; j++){
					  				var sepInt = new reSEP({
					  					'numsol'     :datos[j].numsep,
					  					'consol'     :datos[j].densep,
					  					'monto'      :datos[j].monsep,
					  					'coduniadm'  :datos[j].codunieje,
					  					'codestpro1' :datos[j].codestpro1,
					  					'codestpro2' :datos[j].codestpro2,
					  					'codestpro3' :datos[j].codestpro3,
					  					'codestpro4' :datos[j].codestpro4,
					  					'codestpro5' :datos[j].codestpro5,
					  					'estcla'     :datos[j].estcla,
					  					'codfuefin'  :datos[j].codfuefin
					  				});
					  				gridSEP.store.insert(0,sepInt);
					  			}
					  		}
						},
						failure: function ( result, request){ 
							Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
						}//fin del success
					});//fin del ajax request
				}
				if(codProceso=='RC'){
					Ext.getCmp('numsolcot').setValue(registro.get('numsolcot'));
				}
			gridVentanaCatalogoSolCot.destroy();
			ventanaCatalogoSolCot.close();
	}
}
