
function CatalogoSolEjePre(codProceso,tipo,proveedor){
	
	//Creando el campo de solicitud de ejecucion presupuestaria
	var reVentana = Ext.data.Record.create([
	          {name: 'numsol'}, 
	          {name: 'consol'},
	          {name: 'nombre'},
			  {name: 'fecregsol'},
			  {name: 'estsol'},
			  {name: 'monto'},
			  {name: 'coduniadm'},
			  {name: 'codfuefin'},
			  {name: 'denuniadm'},
			  {name: 'estapro'},
			  {name: 'codestpro1'},
			  {name: 'codestpro2'},
			  {name: 'codestpro3'},
			  {name: 'codestpro4'},
			  {name: 'codestpro5'},
			  {name: 'estcla'}
	]);
	                                        	
	var dsVentana =  new Ext.data.Store({
	           reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reVentana)
	});
	                                						
	 var cmVentana = new Ext.grid.ColumnModel([ 
	           new Ext.grid.CheckboxSelectionModel(),
	           {header: "<H1 align='center'>Nro. Solicitud</H1>", width: 50, sortable: true, dataIndex: 'numsol'},
	           {header: "<H1 align='center'>Concepto</H1>", width: 80, sortable: true, dataIndex: 'consol'},
	           {header: "<H1 align='center'>Proveedor</H1>", width: 50, sortable: true, dataIndex: 'nombre'},
			   {header: "<H1 align='center'>Fecha</H1>", width: 40, sortable: true, dataIndex: 'fecregsol'},
			   {header: "<H1 align='center'>Estatus</H1>", width: 40, sortable: true, dataIndex: 'estsol', renderer: mostrarEstatu},
			   {header: "<H1 align='center'>Monto</H1>", width: 50, sortable: true, dataIndex: 'monto'}
	]);
	//fin creando datastore y columnmodel para el catalogo de solicitud de ejecucion presupuestaria
	 
	 var gridVentanaCatalogoSolEjePre = new Ext.grid.GridPanel({
	 		width:550,
	 		height:240,
			frame:true,
			style: 'position:absolute;left:0px;top:200px',
			autoScroll:true,
			enableColumnHide: false,
			enableHdMenu: false,
			border:true,
			ds: dsVentana,
    		cm: cmVentana,
			sm: new Ext.grid.CheckboxSelectionModel({singleSelect:false}),
    		stripeRows: true,
    		viewConfig: {forceFit:true}
	});
	 
	//-------------------------------------------------------------------------------------------------------------------------		 
	 
	//Creando el campo de unidad ejecutora
	var reUnidadEjecutora = Ext.data.Record.create([
		  {name: 'coddenunidad'},
		  {name: 'estructura'},
		  {name: 'denestpro'},
		  {name: 'coduniadm'},
		  {name: 'denuniadm'},
		  {name: 'codestpro1'},
		  {name: 'codestpro2'},
		  {name: 'codestpro3'},
		  {name: 'codestpro4'},
		  {name: 'codestpro5'},
		  {name: 'estcla'}
	]);
	                                    	
	var dsUnidadEjecutora =  new Ext.data.GroupingStore({
		 reader: new Ext.data.JsonReader({
		 root: 'raiz',             
		 id: "id"},reUnidadEjecutora),
		 sortInfo:{field: 'coduniadm', direction: "ASC"}, 
		 groupField:'coddenunidad' 
	});
	                                    						
	var cmUnidadEjecutora = new Ext.grid.ColumnModel([
		 {header: "<H1>Unidad</H1>", width: 20, sortable: true,   dataIndex: 'coddenunidad'},
		 {header: "<H1 align='center'>Estructura</H1>", width: 30, sortable: true, dataIndex: 'estructura'},
		 {header: "<H1 align='center'>Denominaci&#243;n</H1>", width: 50, sortable: true, dataIndex: 'denestpro'}
	]);
		
	//componente campocatalogoAGRUPADO para el campo unidad ejecutora
	comcampocatUnidadEjecutora = new com.sigesp.vista.comCampoCatalogoAgrupado({
			titvencat: "<H1 align='center'>Catlogo de Unidades Ejecutoras</H1>", 
			anchoformbus: 530,
			altoformbus:200,
			anchogrid: 530,
			altogrid: 450,
			anchoven: 550,
			altoven: 520,
			anchofieldset: 850,
			datosgridcat: dsUnidadEjecutora,
			colmodelocat: cmUnidadEjecutora, 
			rutacontrolador:'../../controlador/sep/sigesp_ctr_sep_solicitud.php',
			parametros: "ObjSon={'operacion': 'buscarUnidadEjecutora', 'origen':'1'",
			arrfiltro:[{etiqueta:'Codigo',id:'cod_unid',valor:'coduniadm',longitud:'10',ancho:100},
					   {etiqueta:'Denominacion',id:'den_unid',valor:'denuniadm',ancho:250},
					   {etiqueta:'Codigo Estructura',id:'cod_estu',valor:'estructura',ancho:250},
					   {etiqueta:'Denominacion Estructura',id:'den_estu',valor:'denestpro',ancho:250}],
			posicion:'position:absolute;left:5px;top:100px', 
			ancholabelform:150, 
			tittxt:'Unidad Ejecutora',
			idtxt:'codua',
			campovalue:'coduniadm',
			anchoetiquetatext:120,
			anchotext:150, 
			anchocoltext:0.34, 
			idlabel:'dunieje',
			labelvalue:'denuniadm',
			anchocoletiqueta:0.50,
			anchoetiqueta:200,
			tipbus:'P', 
			binding:'C',
			hiddenvalue:'',
			defaultvalue:'---',
			allowblank:false, 
			labelitem:'Estructuras Presupuestarias', 
			datosocultos:1,
			camposocultos:['codestpro1','codestpro2','codestpro3','codestpro4','codestpro5','estcla']
	}); 
	
	//-------------------------------------------------------------------------------------------------------------------------		 
	 
	//Creando el campo de proveedor
	var reProveedor = Ext.data.Record.create([
		  {name: 'cod_pro'},                             
		  {name: 'nompro'},
		  {name: 'dirpro'},
		  {name: 'rifpro'}
	]);
	                                    	
	var dsProveedor =  new Ext.data.Store({
		 reader: new Ext.data.JsonReader({
		 root: 'raiz',             
		 id: "id"},reProveedor)
	});
	                                    						
	var colmodelcatProveedor = new Ext.grid.ColumnModel([
		 {header: "<H1 align='center'>Codigo</H1>", width: 20, sortable: true,   dataIndex: 'cod_pro'},
		 {header: "<H1 align='center'>Nombre</H1>", width: 40, sortable: true, dataIndex: 'nompro'},
		 {header: "<H1 align='center'>Direccion</H1>", width: 80, sortable: true, dataIndex: 'dirpro'},
		 {header: "<H1 align='center'>RIF</H1>", width: 30, sortable: true, dataIndex: 'rifpro'}
	]);
	
	//componente campocatalogo para el campo Proveedores
	comcampocatProveedor = new com.sigesp.vista.comCampoCatalogo({
			titvencat: "<H1 align='center'>Cat&#225;logo de Proveedores</H1>",
			anchoformbus: 480,
			altoformbus:180, 
			anchogrid: 480,
			altogrid: 410,
			anchoven: 500,
			altoven: 500,
			anchofieldset: 850,
			datosgridcat: dsProveedor,
			colmodelocat: colmodelcatProveedor, 
			rutacontrolador:'../../controlador/rpc/sigesp_ctr_rpc_cambioestatus.php',
			parametros: "ObjSon={'operacion': 'buscarProveedores'",
			arrfiltro:[{etiqueta:'Codigo',id:'cp',valor:'cod_pro',longitud:'10',ancho:120},
					   {etiqueta:'Nombre',id:'np',valor:'nompro',ancho:250},
					   {etiqueta:'Direccion',id:'dp',valor:'dirpro',ancho:250},
					   {etiqueta:'RIF',id:'rp',valor:'rifpro',longitud:'15',ancho:120}],
			posicion:'position:absolute;left:5px;top:70px',
			tittxt:'Proveedor',
			idtxt:'codpro',
			campovalue:'cod_pro',
			anchoetiquetatext:120, 
			anchotext:150,
			anchocoltext:0.34,
			idlabel:'nomprove',
			labelvalue:'nomp',
			anchocoletiqueta:0.50,
			anchoetiqueta:200, 
			tipbus:'P',
			binding:'C',
			hiddenvalue:'',
			defaultvalue:'---',
			allowblank:true
	});
	//fin componente para el campo Proveedor
	
	//-------------------------------------------------------------------------------------------------------------------------	
	 
	function buscarexistenciacuenta(tiposol){
		if(tiposol=='B'){
			gridBienes.store.each(function (reBien){
				obtenerMensaje('procesar','','Buscando Datos');
				var JSONObj = {
						'operacion' : 'buscar_existe_cuenta',
						'codestpro1': reBien.get('codestpro1'),
						'codestpro2': reBien.get('codestpro2'),
						'codestpro3': reBien.get('codestpro3'),
						'codestpro4': reBien.get('codestpro4'),
						'codestpro5': reBien.get('codestpro5'),
						'estcla'    : reBien.get('estcla')
				}
			  	var ObjjS=Ext.util.JSON.encode(JSONObj);
			  	var param ='ObjSon='+ObjjS;
			  	Ext.Ajax.request({
			  		url: '../../controlador/soc/sigesp_ctr_soc_registro_orden_compra.php',
			  		params: param,
			  		method: 'POST',
			  		success: function ( result, request ) { 
			  			Ext.Msg.hide();	
			  			var resul = result.responseText;
			  			reBien.set('existecuenta',resul);
			  			if(resul>0){
			  				Ext.getCmp('estcom').setValue('1');
			  			}
			  		},
			  		failure: function (result, request){ 
			  			Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
			  		}//fin del success
			  	});//fin del ajax request
			});
		}
		else{
			gridServicios.store.each(function (reSer){
				obtenerMensaje('procesar','','Buscando Datos');
				var JSONObj = {
						'operacion' : 'buscar_existe_cuenta',
						'codestpro1': reSer.get('codestpro1'),
						'codestpro2': reSer.get('codestpro2'),
						'codestpro3': reSer.get('codestpro3'),
						'codestpro4': reSer.get('codestpro4'),
						'codestpro5': reSer.get('codestpro5'),
						'estcla'    : reSer.get('estcla')
				}
			  	var ObjjS=Ext.util.JSON.encode(JSONObj);
			  	var param ='ObjSon='+ObjjS;
			  	Ext.Ajax.request({
			  		url: '../../controlador/soc/sigesp_ctr_soc_registro_orden_compra.php',
			  		params: param,
			  		method: 'POST',
			  		success: function ( result, request ) { 
			  			Ext.Msg.hide();	
			  			var resul = result.responseText;
			  			reSer.set('existecuenta',resul);
			  			if(resul>0){
			  				Ext.getCmp('estcom').setValue('1');
			  			}
			  		},
			  		failure: function (result, request){ 
			  			Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
			  		}//fin del success
			  	});//fin del ajax request
			});
		}
	}
	
	//-------------------------------------------------------------------------------------------------------------------------	
	
	function buscarcargos(numsol,tipo,codfuefin){
		var aux = formatoNumericoMostrar(0,2,'.',',','','','-','');
		var reCargos = Ext.data.Record.create([
			{name: 'codigo'},
			{name: 'codcar'}, 
			{name: 'dencar'},
			{name: 'monbasimp'},
			{name: 'moncar'},
			{name: 'monto'},
			{name: 'spg_cuenta'},
			{name: 'formula'},
			{name: 'estructura'}
		]);
		obtenerMensaje('procesar','','Buscando Datos');
		//Busco los cargos asociados a la sep 
		if(tipo=='B'){
			var JSONObj = {
					'operacion': 'cargarCargos',
					'numsol'   : numsol,
					'tabla'    : 'sep_dta_cargos',
					'campo'    : 'codart'
			}
		}
		if(tipo=='S'){
			var JSONObj = {
					'operacion': 'cargarCargos',
					'numsol'   : numsol,
					'tabla'    : 'sep_dts_cargos',
					'campo'    : 'codser'
			}
		}
	  	var ObjjS=Ext.util.JSON.encode(JSONObj);
	  	var param ='ObjSon='+ObjjS;
	  	Ext.Ajax.request({
	  		url: '../../controlador/sep/sigesp_ctr_sep_solicitud.php',
	  		params: param,
	  		method: 'POST',
	  		success: function ( result, request ) { 
	  			Ext.Msg.hide();	
	  			var resul = result.responseText;
	  			var objCargos = eval('(' + resul + ')');
	  			var cargos = objCargos.raiz;
	  			if (objCargos != ""){
	  				fromRegistroOrdenCompra.add(gridCreditos);
	  				gridCreditos.show();
					fromRegistroOrdenCompra.doLayout();
	  				for(var i = 0;  i<cargos.length; i++){
	  					var cargosInt = new reCargos({
	  						'codigo'     :cargos[i].codigo,
	  						'codcar'     :cargos[i].codcar,
	  						'dencar'     :cargos[i].dencar,
	  						'basimp'     :cargos[i].monbasimp,
	  						'moncar'	 :cargos[i].monimp,
	  						'totcar'     :cargos[i].monto,
	  						'spg_cuenta' :cargos[i].spg_cuenta,
	  						'formula'    :cargos[i].formula,
	  						'estructura' :cargos[i].estructura,
	  						'codestpro1' :cargos[i].codestpro1,
	  						'codestpro2' :cargos[i].codestpro2,
							'codestpro3' :cargos[i].codestpro3,
							'codestpro4' :cargos[i].codestpro4,
							'codestpro5' :cargos[i].codestpro5,
							'estcla'     :cargos[i].estcla,
	    					'numsol'     :numsol,
	    					'codfuefin'  :codfuefin
						});
	    				if(tipo=='B'){
							gridBienes.store.each(function (reBien){
								if(cargos[i].codigo==reBien.get('codart')){
									reBien.set('monimp',cargos[i].monimp)
								}
							});
						}
						if(tipo=='S'){
							gridServicios.store.each(function (reBien){
								if(cargos[i].codigo==reBien.get('codser')){
									reBien.set('moniva',cargos[i].monimp)
								}
							});
						}
	    				gridCreditos.store.insert(0,cargosInt);
					}
	  			}
	  		},
	  		failure: function (result, request){ 
	  			Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
	  		}//fin del success
	  	});//fin del ajax request
	}
	
	//-------------------------------------------------------------------------------------------------------------------------	
	
	//Creacion del formulario del catalogo de solicitud de ejecucion presupuestaria
	 
	var formVentanaCatalogoSolEjePre = new Ext.FormPanel({
		width: 580,
		height: 480,
		style: 'position:absolute;left:5px;top:10px',
		frame: true,
		autoScroll:false,
		items: [{
			xtype:"fieldset",
			title:'Datos de la Solicitud de Ejecucion Presupuestaria',
			style: 'position:absolute;left:10px;top:5px',
			border:true,
			width: 550,
			cls :'fondo',
			height: 190,
			items:[ {
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:20px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 120,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Nro. Solicitud',
						name: 'nro_solicitud',
						id: 'numsol',									
						width: 150,
						changeCheck: function(){
							var textvalor = this.getValue();
							dsVentana.filter('numsol',textvalor,true);
							if(String(textvalor) !== String(this.startValue)){
								this.fireEvent('change', this, textvalor, this.startValue);
							} 
						}, 
						initEvents: function(){
							AgregarKeyPress(this);
						},
						autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '15', onkeypress: "return keyRestrict(event,'0123456789');"}
					}]
				}]
			},comcampocatProveedor.fieldsetCatalogo,
			comcampocatUnidadEjecutora.fieldsetCatalogo,
			{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:50px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 120,
					items: [{
						xtype:"datefield",
						labelSeparator :'',
						fieldLabel:" Fecha Desde",
						name:"fechadesde",
						id: 'fecdes',
						allowBlank:true,
						changeCheck: function(){
							var textvalor = this.getValue();
							dsVentana.filter('fecregsol',textvalor,true);
							if(String(textvalor) !== String(this.startValue)){
								this.fireEvent('change', this, textvalor, this.startValue);
							} 
						}, 
						initEvents: function(){
							AgregarKeyPress(this);
						},
						autoCreate: {tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789/');"}	
					}]
				}]
			},
			{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:330px;top:50px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 50,
					items: [{
						xtype:"datefield",
						fieldLabel:"Hasta",
						labelSeparator :'',
						name:"fechahasta",
						id: 'fechas',
						allowBlank:true,
						changeCheck: function(){
							var textvalor = this.getValue();
							dsVentana.filter('fecregsol',textvalor,true);
							if(String(textvalor) !== String(this.startValue)){
								this.fireEvent('change', this, textvalor, this.startValue);
							} 
						}, 
						initEvents: function(){
							AgregarKeyPress(this);
						},
						autoCreate: {tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789/');"}	
					}]
				}]
			},gridVentanaCatalogoSolEjePre,
			{
				layout:"column",
		   		defaults: {border: false},
		   		style: 'position:absolute;left:400px;top:150px',
		   		border:false,
		   		items:[{
		   			layout:"form",
		   			border:false,
		   			items:[{
		   				xtype: 'button',
		   				labelSeparator :'',
		   				fieldLabel: '',
		   				id: 'btbuscar',
		   				text: 'Buscar Solicitud',
		   				iconCls: 'menubuscar',
		   				handler: function(){
		   				if((Ext.getCmp('fecdes').getValue()) > (Ext.getCmp('fechas').getValue())){
		   					valido = false;
		   					Ext.MessageBox.show({
			 					title:'Advertencia',
			 					msg:'El rango de fechas no es valido!!!',
			 					buttons: Ext.Msg.OK,
			 					icon: Ext.MessageBox.WARNING
			 				});
		   				}
		   				else{
			   				obtenerMensaje('procesar','','Buscando Datos');
			   				
			   				var destino = '';
			   				if(Ext.getCmp('codpro').getValue()!=''){
			   					var destino = 'P';
			   				}
			   				var codpro = Ext.getCmp('codpro').getValue();
							//Buscar solicitudes de ejecucion presupuestaria (sep)
			   				var JSONObject = {
								'operacion'      : 'buscarSolicitudes',
								'numsol'         : Ext.getCmp('numsol').getValue(),
								'destino'        : destino,
								'fechadesd'      : Ext.getCmp('fecdes').getValue(),
								'fechahas'       : Ext.getCmp('fechas').getValue(),
								'coduniadm'      : Ext.getCmp('codua').getValue(),   
								'tipo'           : tipo,
			   				    'codpro'         : codpro,
			   				    'origen_catalogo': 'SC'
							}
							
							var ObjSon = JSON.stringify(JSONObject);
			   				var parametros = 'ObjSon='+ObjSon; 
			   				Ext.Ajax.request({
			   					url : '../../controlador/sep/sigesp_ctr_sep_solicitud.php',
			   					params : parametros,
			   					method: 'POST',
			   					success: function ( resultado, request){
			   						Ext.Msg.hide();
			   						var datos = resultado.responseText;
			   						var objSolEjePre = eval('(' + datos + ')');
			   						if(objSolEjePre!=''){
			   							if(objSolEjePre!='0'){
			   								if(objSolEjePre.raiz == null || objSolEjePre.raiz ==''){
			   									Ext.MessageBox.show({
								 					title:'Advertencia',
								 					msg:'No existen datos para mostrar',
								 					buttons: Ext.Msg.OK,
								 					icon: Ext.MessageBox.WARNING
								 				});
											}
											else{
												gridVentanaCatalogoSolEjePre.store.loadData(objSolEjePre);
											}
			   							}
			   							else{
			   								Ext.MessageBox.show({
								 				title:'Advertencia',
								 				msg:'Debe configurar en Empresa los digitos de las cuentas de gastos',
								 				buttons: Ext.Msg.OK,
								 				icon: Ext.MessageBox.WARNING
								 			});
			   							}
			   						}
			   					}//fin del success	
			   				});//fin del ajax request
	   		           	}
		   			}
		   			}]
		   		}]
   	      	}]  
		}]   
    });
	
	//fin del formulario 
	 
	//-------------------------------------------------------------------------------------------------------------------------	
	
	var ventanaCatalogoSolEjePre = new Ext.Window({
		title: "<H1 align='center'>Cat&#225;logo de Solicitudes de Ejecucion Presupuestaria</H1>",
		width:600,
		height:550,
		modal: true,
		closable:false,
		plain: false,
		frame:true,
		items:[formVentanaCatalogoSolEjePre],
		buttons: [{
			text:'Aceptar', 
    			handler: function(){
					var moncar; 
					var arrRegistro = gridVentanaCatalogoSolEjePre.getSelectionModel().getSelections();
					var registro = gridVentanaCatalogoSolEjePre.getSelectionModel().getSelected();
					var tipsol = tipo;
  					if(codProceso=='SC'){
						var reArt = Ext.data.Record.create([
    						{name: 'codart'}, 
    						{name: 'denart'},
    						{name: 'canart'},
    						{name: 'unidad'},
    						{name: 'denunimed'}
    					]);	
						var reSEP = Ext.data.Record.create([
      						{name: 'numsol'}, 
      						{name: 'consol'},
      						{name: 'monto'},
      						{name: 'coduniadm'},
	      					{name: 'codfuefin'},
	      					{name: 'codestpro1'},
	      					{name: 'codestpro2'},
	      					{name: 'codestpro3'},
	      					{name: 'codestpro4'},
	      					{name: 'codestpro5'},
	      					{name: 'estcla'}
      					]); 
						
						var reSer = Ext.data.Record.create([
    						{name: 'codser'}, 
    						{name: 'denser'},
    						{name: 'canser'}
    					]);
						
      					if(arrRegistro.length>0){
      						if(arrRegistro.length==1 && gridSEP.getStore().getCount()==0){
      							setDataFrom(fromSolicitudCotizacion,registro);
							}
      						else{
      							Ext.getCmp('coduniadm').setValue('----------');
								Ext.getCmp('denuniadm').setValue('Ninguna');
								Ext.getCmp('codfuefin').setValue('--');
								Ext.getCmp('codestpro1').setValue('-------------------------');
								Ext.getCmp('codestpro2').setValue('-------------------------');
								Ext.getCmp('codestpro3').setValue('-------------------------');
								Ext.getCmp('codestpro4').setValue('-------------------------');
								Ext.getCmp('codestpro5').setValue('-------------------------');
								Ext.getCmp('estcla').setValue('-');
							}
	      	    			for(var int = 0; int < arrRegistro.length; int++) {
	      	    				var sep = arrRegistro[int];
	      	    				var numsep = sep.get('numsol');
	      	    				var coduniadm = sep.get('coduniadm');
	      	    				Ext.getCmp('uniejeaso').setValue(Ext.getCmp('uniejeaso').getValue()+'Nro. SEP '+numsep+'.'+'UNIDAD EJECUTORA '+sep.get('coduniadm')+'.'+sep.get('denuniadm')+'; ');
	      	    			    //validar si ya ha sido seleccionada para poder insertarla en la gridSEP
	      						if(validarExistenciaRegistroGrid(sep,gridSEP,'numsol','numsol',true)){ 
	      							var sepInt = new reSEP({
	      								'numsol'    :sep.get('numsol'),
	      								'consol'    :sep.get('consol'),
	      								'monto'     :sep.get('monto'),
	      								'coduniadm' :sep.get('coduniadm'),
	      							    'codfuefin' :sep.get('codfuefin'),
	      							    'codestpro1':sep.get('codestpro1'),
	      							    'codestpro2':sep.get('codestpro2'),
	      							    'codestpro3':sep.get('codestpro3'),
	      							    'codestpro4':sep.get('codestpro4'),
	      							    'codestpro5':sep.get('codestpro5'),
	      							    'estcla'    :sep.get('estcla')
	      							});
	      							gridSEP.store.insert(0,sepInt);
	      							
	      							//Busco segun el numero de solicitud los bienes o servicios que le corresponden a la misma
	      							if(tipsol=='B'){
	      								obtenerMensaje('procesar','','Buscando Datos');
				      	    			var JSONObj = {
												'operacion'  : 'cargarArticulos',
												'numsol'     : numsep
										}
				      	    			var ObjjSon=Ext.util.JSON.encode(JSONObj);
				      	    			var parametros ='ObjSon='+ObjjSon;
				      	    			Ext.Ajax.request({
				      	    				url: '../../controlador/sep/sigesp_ctr_sep_solicitud.php',
				      	    				params: parametros,
				      	    				method: 'POST',
				      	    				success: function ( result, request ) { 
			      	    						Ext.Msg.hide();
			      	    			            var resultado = result.responseText;
			      	    			            var objDatos = eval('(' + resultado + ')');
			      	    			            var datos = objDatos.raiz;
			      	    						if (objDatos != ""){
		      	    								for(var j=0;j<datos.length;j++){
		      	    									var bienesInt = new reArt({
			      	    									'codart'     :datos[j].codart,
			      	    									'denart'     :datos[j].denart,
			      	    									'canart'     :datos[j].canart,
			      	    									'modalidad'  :datos[j].unidad,
			      	    									'denunimed'  :datos[j].denunimed,
			      	    									'numsep'     :datos[j].numsol,
			      	    									'coduniadm'  :coduniadm,
			      	    									'codestpro1' :datos[j].codestpro1,
			      	    									'codestpro2' :datos[j].codestpro2,
				      	    								'codestpro3' :datos[j].codestpro3,
				      	    								'codestpro4' :datos[j].codestpro4,
				      	    								'codestpro5' :datos[j].codestpro5,
				      	    								'estcla'     :datos[j].estcla,
				      	    								'codfuefin'  :datos[j].codfuefin
			      	    								});
				      	    							gridBienes.store.insert(0,bienesInt);
		      	    								}
			      	    						}
				      	    				},
				      	    				failure: function ( result, request){ 
				      	    						Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
				      	    				}//fin del success
				      	    			});//fin del ajax request
	      							}
	      							else{
	      								obtenerMensaje('procesar','','Buscando Datos');
				      	    			var JSONObj = {
												'operacion'  : 'cargarServicios',
												'numsol'     : numsep
										}
				      	    			var ObjjSon=Ext.util.JSON.encode(JSONObj);
				      	    			var parametros ='ObjSon='+ObjjSon;
				      	    			Ext.Ajax.request({
				      	    				url: '../../controlador/sep/sigesp_ctr_sep_solicitud.php',
				      	    				params: parametros,
				      	    				method: 'POST',
				      	    				success: function ( result, request ) { 
			      	    						Ext.Msg.hide();
			      	    			            var resultado = result.responseText;
			      	    			            var objDatos = eval('(' + resultado + ')');
			      	    			            var datos = objDatos.raiz;
			      	    						if (objDatos != ""){
		      	    								for(var j = 0; j < datos.length; j++){
			      	    								var serviciosInt = new reSer({
			      	    									'codser'     :datos[j].codser,
			      	    									'denser'     :datos[j].denser,
			      	    									'canser'     :datos[j].canser,
			      	    									'numsep'     :datos[j].numsol,
				      	    								'coduniadm'  :coduniadm,
				      	    								'codestpro1' :datos[j].codestpro1,
				      	    								'codestpro2' :datos[j].codestpro2,
				      	    								'codestpro3' :datos[j].codestpro3,
				      	    								'codestpro4' :datos[j].codestpro4,
				      	    								'codestpro5' :datos[j].codestpro5,
				      	    								'estcla'     :datos[j].estcla,
				      	    								'codfuefin'  :datos[j].codfuefin
			      	    								});
				      	    							gridServicios.store.insert(0,serviciosInt);
			      	    							}
		      	    							}
				      	    				},
				      	    				failure: function ( result, request){ 
				      	    						Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
				      	    				}//fin del success
				      	    			});//fin del ajax request
	      							}
	      						}
	      					}
      					}
					}
  					else if(codProceso=='OC'){
  						var tipsol = tipo;
  						var valido = true
  						Ext.getCmp('entro').setValue(1);
						var reArt = Ext.data.Record.create([
    						{name: 'codart'}, 
    						{name: 'denart'},
    						{name: 'canart'},
    						{name: 'unidad'},
    						{name: 'monpre'},
    						{name: 'monart'},
    						{name: 'spg_cuenta'},
    						{name: 'coduniadm'},
    						{name: 'codestpro1'},
							{name: 'codestpro2'},
							{name: 'codestpro3'},
							{name: 'codestpro4'},
							{name: 'codestpro5'},
							{name: 'codfuefin'},
							{name: 'estcla'},
    						{name: 'estructura'},
    						{name: 'numsol'}
    					]);				
      					var reSer = Ext.data.Record.create([
    						{name: 'codser'}, 
    						{name: 'denser'},
    						{name: 'canser'},
    						{name: 'monpre'},
    						{name: 'monser'},
    						{name: 'spg_cuenta'},
    						{name: 'coduniadm'},
    						{name: 'codestpro1'},
							{name: 'codestpro2'},
							{name: 'codestpro3'},
							{name: 'codestpro4'},
							{name: 'codestpro5'},
							{name: 'codfuefin'},
							{name: 'estcla'},
    						{name: 'estructura'},
    						{name: 'numsol'}
    					]);
      					var reCuentas = Ext.data.Record.create([
						      {name: 'estructura'}, 
						      {name: 'total'},
						      {name: 'spg_cuenta'},
						      {name: 'codfuefin'},
						      {name: 'codestpro1'},
						      {name: 'codestpro2'},
						      {name: 'codestpro3'},
						      {name: 'codestpro4'},
						      {name: 'codestpro5'},
						      {name: 'estcla'}
						]);
      					var reCueCre = Ext.data.Record.create([
   						      {name: 'estructura'}, 
   						      {name: 'total'},
   						      {name: 'spg_cuenta'},
   						      {name: 'codfuefin'},
   						      {name: 'codcar'},
   						      {name: 'codestpro1'},
						      {name: 'codestpro2'},
						      {name: 'codestpro3'},
						      {name: 'codestpro4'},
						      {name: 'codestpro5'},
						      {name: 'estcla'},
						      {name: 'formula'}
   						]);
						if(arrRegistro.length>0){
							for(var int=0; int<arrRegistro.length; int++){
								var sep = arrRegistro[int];
								var numsol = sep.get('numsol');
								var coduniadm = sep.get('coduniadm');
								var codfuefin = sep.get('codfuefin');
								var encontro = true;
								if(tipsol=='B'){
									var i=0;
									if(gridBienes.getStore().getCount()>0){
										while(encontro){
											if(numsol==gridBienes.getStore().getAt(i).get('numsol')){
												alert('La Solictud '+gridBienes.getStore().getAt(i).get('numsol')+', ya ha sido insertada');
			  									valido = false;
			  									encontro = false
											}
											if(i==(gridBienes.getStore().getCount()-1)){
												encontro = false;
											}
											i++;
										}
									}
		  						}
								if(tipsol=='S'){
									var i=0;
									if(gridServicios.getStore().getCount()>0){
										while(encontro){
											if(numsol==gridServicios.getStore().getAt(i).get('numsol')){
												alert('La Solictud '+gridServicios.getStore().getAt(i).get('numsol')+', ya ha sido insertada');
			  									valido = false;
			  									encontro = false;
											}
											if(i==(gridServicios.getStore().getCount()-1)){
												encontro = false;
											}
											i++;
										}
									}
								}
								if(valido){
									Ext.getCmp('obscom').setValue(Ext.getCmp('obscom').getValue()+sep.get('consol')+'; ');
									Ext.getCmp('uniejeaso').setValue(Ext.getCmp('uniejeaso').getValue()+'Nro. SEP '+numsol+'.'+'UNIDAD EJECUTORA '+sep.get('coduniadm')+'.'+sep.get('denuniadm')+'; ');
									if(tipsol=='B'){
										if(arrRegistro.length==1 && gridBienes.getStore().getCount()==0){
											Ext.getCmp('coduniadm').setValue(sep.get('coduniadm'));
											Ext.getCmp('denuniadm').setValue(sep.get('denuniadm'));
											Ext.getCmp('codfuefin').setValue(sep.get('codfuefin'));
											Ext.getCmp('codestpro1').setValue(sep.get('codestpro1'));
											Ext.getCmp('codestpro2').setValue(sep.get('codestpro2'));
											Ext.getCmp('codestpro3').setValue(sep.get('codestpro3'));
											Ext.getCmp('codestpro4').setValue(sep.get('codestpro4'));
											Ext.getCmp('codestpro5').setValue(sep.get('codestpro5'));
											Ext.getCmp('estcla').setValue(sep.get('estcla'));
										}
										else{
											Ext.getCmp('coduniadm').setValue('----------');
											Ext.getCmp('denuniadm').setValue('Ninguna');
											Ext.getCmp('codfuefin').setValue('--');
											Ext.getCmp('codestpro1').setValue(sep.get('-------------------------'));
											Ext.getCmp('codestpro2').setValue(sep.get('-------------------------'));
											Ext.getCmp('codestpro3').setValue(sep.get('-------------------------'));
											Ext.getCmp('codestpro4').setValue(sep.get('-------------------------'));
											Ext.getCmp('codestpro5').setValue(sep.get('-------------------------'));
											Ext.getCmp('estcla').setValue(sep.get('-'));
										}
										//Busco segun el numero de solicitud los bienes que le corresponden a la misma
										var JSONObj = {
											'operacion'  : 'cargarArticulos',
											'numsol'     : numsol
										}
				      	    			var ObjjSon=Ext.util.JSON.encode(JSONObj);
				      	    			var parametros ='ObjSon='+ObjjSon;
				      	    			Ext.Ajax.request({
				      	    				url: '../../controlador/sep/sigesp_ctr_sep_solicitud.php',
				      	    				params: parametros,
				      	    				method: 'POST',
				      	    				success: function ( result, request ) { 
		      	    							Ext.Msg.hide();
		      	    							var aux = formatoNumericoMostrar(1,2,'.',',','','','-','');
		      	    							var resultado = result.responseText;
		      	    							var objDatos = eval('(' + resultado + ')');
		      	    							var datos = objDatos.raiz;
		      	    							if (objDatos != ""){
		  	    									fromRegistroOrdenCompra.add(gridBienes);
		  	    									gridBienes.show();
		  	    									fromRegistroOrdenCompra.doLayout();
		  	    									for(var j = 0; j < datos.length; j++){
		  	    										var bienesInt = new reArt({
			      	    									'codart'     :datos[j].codart,
			      	    									'denart'     :datos[j].denart,
			      	    									'canart'     :datos[j].canart,
			      	    									'unidad'     :datos[j].unidad,
			      	    									'modalidad'  :datos[j].unidad,
			      	    									'monimp'     :'0,00',
			      	    									'preuniart'  :datos[j].monpre,
			      	    									'montotart'  :datos[j].monart,
			      	    									'cuenta'     :datos[j].spg_cuenta,
			      	    									'estapro'    :0,
			      	    									'coduniadm'  :coduniadm,
			      	    									'codestpro1' :datos[j].codestpro1,
			      	    									'codestpro2' :datos[j].codestpro2,
			      	    									'codestpro3' :datos[j].codestpro3,
			      	    									'codestpro4' :datos[j].codestpro4,
			      	    									'codestpro5' :datos[j].codestpro5,
			      	    									'codfuefin'  :datos[j].codfuefin,
			      	    									'estcla'     :datos[j].estcla,
			      	    									'estructura' :datos[j].estructura,
			      	    									'numsol'     :datos[j].numsol
			      	    									
		  	    										});
		  	    										var cantidad = datos[j].canart;
				      	    							cantidad = parseFloat(ue_formato_operaciones(cantidad));
				      	    							var precio = datos[j].monpre;
				      	    							precio = parseFloat(ue_formato_operaciones(precio));
				      	    							var subtotal = cantidad*precio;
				      	    							var codigo = datos[j].codart;	
				      	    							bienesInt.set('monsubart',formatoNumericoMostrar(subtotal,2,'.',',','','','-',''));
				      	    							if(validarExistenciaRegistroGrid(bienesInt,gridBienes,'codart','codart',false)){
					      	    							gridBienes.store.insert(0,bienesInt);
					      	    						}
					      	    						else{
				      	    								gridBienes.store.each(function (registro){
				      	    									var aux = formatoNumericoMostrar(0,2,'.',',','','','-','');
					      	    								var auxuno = registro.get('codart');
					      	    								var auxdos = datos[j].codart;
					      	    								var monimp = registro.get('monimp');
					      	    								var preuno = registro.get('preuniart');
					      	    								preuno = parseFloat(ue_formato_operaciones(preuno));
					      	    								var predos = datos[j].monpre;
					      	    								predos = parseFloat(ue_formato_operaciones(predos));
			      	    										if(auxuno==auxdos){
			      	    											if(monimp!=aux){
			      	    												monimp = parseFloat(ue_formato_operaciones(monimp));
				      	    											var monaux = bienesInt.get('monimp');
				      	    											monaux = parseFloat(ue_formato_operaciones(monaux));
				      	    											registro.set('monimp',formatoNumericoMostrar(monimp+monaux,2,'.',',','','','-',''));
				      	    										}
			      	    											if(predos>preuno){
			      	    												registro.set('preuniart',formatoNumericoMostrar(predos,2,'.',',','','','-',''));
			      	    											}
			      	    											var canuno = registro.get('canart');
			      	    											canuno = parseFloat(ue_formato_operaciones(canuno));
			      	    											var candos = datos[j].canart;
			      	    											candos = parseFloat(ue_formato_operaciones(candos));
			      	    											var monsubuno = registro.get('monsubart');
			      	    											monsubuno = parseFloat(ue_formato_operaciones(monsubuno));
			      	    											var monimp = registro.get('monimp');
			      	    											monimp = parseFloat(ue_formato_operaciones(monimp));
				      	    										var montotuno = registro.get('montotart');
				      	    										montotuno = parseFloat(ue_formato_operaciones(montotuno));
				      	    										var montotdos = datos[j].monart;
				      	    										montotdos = parseFloat(ue_formato_operaciones(montotdos));
				      	    										registro.set('canart',formatoNumericoMostrar(canuno+candos,2,'.',',','','','-',''));
				      	    										registro.set('monsubart',formatoNumericoMostrar(monsubuno+subtotal,2,'.',',','','','-',''));
				      	    										registro.set('montotart',formatoNumericoMostrar(montotuno+montotdos,2,'.',',','','','-',''));
			      	    										}
				      	    								})
				      	    							}
		  	    									}
		      	    							}
				      	    				},
				      	    				failure: function ( result, request){ 
			      	    						Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
				      	    				}//fin del success
				      	    			});//fin del ajax request
									}
				      	    		else{
				      	    			if(arrRegistro.length==1 && gridBienes.getStore().getCount()==0){
											Ext.getCmp('coduniadm').setValue(sep.get('coduniadm'));
											Ext.getCmp('denuniadm').setValue(sep.get('denuniadm'));
											Ext.getCmp('codfuefin').setValue(sep.get('codfuefin'));
											Ext.getCmp('codestpro1').setValue(sep.get('codestpro1'));
											Ext.getCmp('codestpro2').setValue(sep.get('codestpro2'));
											Ext.getCmp('codestpro3').setValue(sep.get('codestpro3'));
											Ext.getCmp('codestpro4').setValue(sep.get('codestpro4'));
											Ext.getCmp('codestpro5').setValue(sep.get('codestpro5'));
											Ext.getCmp('estcla').setValue(sep.get('estcla'));
										}
										else{
											Ext.getCmp('coduniadm').setValue('---------');
											Ext.getCmp('denuniadm').setValue('Ninguna');
											Ext.getCmp('codfuefin').setValue('');
											Ext.getCmp('codestpro1').setValue(sep.get('-------------------------'));
											Ext.getCmp('codestpro2').setValue(sep.get('-------------------------'));
											Ext.getCmp('codestpro3').setValue(sep.get('-------------------------'));
											Ext.getCmp('codestpro4').setValue(sep.get('-------------------------'));
											Ext.getCmp('codestpro5').setValue(sep.get('-------------------------'));
											Ext.getCmp('estcla').setValue(sep.get('-'));
										}
				      	    			//Busco segun el numero de solicitud los servicios que le corresponden a la misma
										var JSONObj = {
											'operacion'  : 'cargarServicios',
											'numsol'     : numsol
										}
				      	    			var ObjjSon=Ext.util.JSON.encode(JSONObj);
				      	    			var parametros ='ObjSon='+ObjjSon;
				      	    			Ext.Ajax.request({
				      	    				url: '../../controlador/sep/sigesp_ctr_sep_solicitud.php',
				      	    				params: parametros,
				      	    				method: 'POST',
				      	    				success: function ( result, request ) { 
		      	    							Ext.Msg.hide();
		      	    							var aux = formatoNumericoMostrar(1,2,'.',',','','','-','');
		      	    							var resultado = result.responseText;
		      	    							var objDatos = eval('(' + resultado + ')');
		      	    							var datos = objDatos.raiz;
		      	    							if (objDatos != ""){
	      	    									fromRegistroOrdenCompra.add(gridServicios);
	      	    									gridServicios.show();
	      	    									fromRegistroOrdenCompra.doLayout();
	      	    									for(var j = 0; j < datos.length; j++){
			      	    								var serviciosInt = new reArt({
			      	    									'codser'     :datos[j].codser,
			      	    									'denser'     :datos[j].denser,
			      	    									'canser'     :datos[j].canser,
			      	    									'monuniser'  :datos[j].monpre,
			      	    									'moniva'     :'0,00',
			      	    									'montotser'  :datos[j].monser,
			      	    									'cuenta'     :datos[j].spg_cuenta,
			      	    									'estapro'    :0,
			      	    									'coduniadm'  :coduniadm,
			      	    									'codestpro1' :datos[j].codestpro1,
			      	    									'codestpro2' :datos[j].codestpro2,
			      	    									'codestpro3' :datos[j].codestpro3,
			      	    									'codestpro4' :datos[j].codestpro4,
			      	    									'codestpro5' :datos[j].codestpro5,
			      	    									'estcla'     :datos[j].estcla,
			      	    									'codfuefin'  :datos[j].codfuefin,
			      	    									'estructura' :datos[j].estructura,
			      	    									'numsol'     :datos[j].numsol
		  	      	    								});
			      	    								var cantidad = datos[j].canser;
				      	    							cantidad = parseFloat(ue_formato_operaciones(cantidad));
				      	    							var precio = datos[j].monpre;
				      	    							precio = parseFloat(ue_formato_operaciones(precio));
				      	    							var subtotal = cantidad*precio;
				      	    							serviciosInt.set('monsubser',formatoNumericoMostrar(subtotal,2,'.',',','','','-',''));
				      	    							if(validarExistenciaRegistroGrid(serviciosInt,gridServicios,'codser','codser',false)){
				      	    								gridServicios.store.insert(0,serviciosInt);
				      	    							}
				      	    							else{
				      	    								gridServicios.store.each(function (registro){
				      	    									var aux = formatoNumericoMostrar(0,2,'.',',','','','-','');
					      	    								var auxuno = registro.get('codser');
					      	    								var auxdos = datos[j].codser;
					      	    								var moniva = registro.get('moniva');
					      	    								var preuno = registro.get('monuniser');
					      	    								preuno = parseFloat(ue_formato_operaciones(preuno));
					      	    								var predos = datos[j].monpre;
					      	    								predos = parseFloat(ue_formato_operaciones(predos));
			      	    										if(auxuno==auxdos){
			      	    											if(moniva!=aux){
			      	    												moniva = parseFloat(ue_formato_operaciones(moniva));
				      	    											var monaux = serviciosInt.get('moniva');
				      	    											monaux = parseFloat(ue_formato_operaciones(monaux));
				      	    											registro.set('moniva',formatoNumericoMostrar(moniva+monaux,2,'.',',','','','-',''));
				      	    										}
			      	    											if(predos>preuno){
			      	    												registro.set('monuniser',formatoNumericoMostrar(predos,2,'.',',','','','-',''));
			      	    											}
			      	    											var canuno = registro.get('canser');
			      	    											canuno = parseFloat(ue_formato_operaciones(canuno));
			      	    											var candos = datos[j].canser;
			      	    											candos = parseFloat(ue_formato_operaciones(candos));
			      	    											var monsubuno = registro.get('monsubser');
			      	    											monsubuno = parseFloat(ue_formato_operaciones(monsubuno));
				      	    										var montotuno = registro.get('montotser');
				      	    										montotuno = parseFloat(ue_formato_operaciones(montotuno));
				      	    										var montotdos = datos[j].monser;
				      	    										montotdos = parseFloat(ue_formato_operaciones(montotdos));
			      	    											registro.set('canser',formatoNumericoMostrar(canuno+candos,2,'.',',','','','-',''));
				      	    										registro.set('monsubser',formatoNumericoMostrar(monsubuno+subtotal,2,'.',',','','','-',''));
				      	    										registro.set('montotser',formatoNumericoMostrar(montotuno+montotdos,2,'.',',','','','-',''));
			      	    										}
				      	    								})
				      	    							}
	      	    									}	
	      	    								}
			      	    					},
			      	    					failure: function ( result, request){ 
			      	    						Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
			      	    					}//fin del success
				      	    			});//fin del ajax request
				      	    		}
									buscarexistenciacuenta(tipsol);
									buscarcargos(numsol,tipsol,codfuefin);
			      	    			obtenerMensaje('procesar','','Buscando Datos');
									var JSONObject = {
										'operacion' : 'cargarCuentas',
										'numsol'    : numsol
									}			
									var ObjSon = JSON.stringify(JSONObject);
									var parametros = 'ObjSon='+ObjSon; 
									Ext.Ajax.request({
										url : '../../controlador/sep/sigesp_ctr_sep_solicitud.php',
										params : parametros,
										method: 'POST',
										success: function ( resultado, request){
											Ext.Msg.hide();
											var resultado = resultado.responseText;
											var objDatos = eval('(' + resultado + ')');
											var datos = objDatos.raiz;
											if (objDatos != ""){
												fromRegistroOrdenCompra.add(gridCuentas);
												fromRegistroOrdenCompra.add(fromTotales);
												gridCuentas.show();
												fromTotales.show();
												fromRegistroOrdenCompra.doLayout();
												for(var k=0; k<datos.length; k++){
													var cuentasInt = new reCuentas({
														'estructura' :datos[k].estructura,
														'monto'      :datos[k].total,
														'spg_cuenta' :datos[k].spg_cuenta,
														'codfuefin'  :datos[k].codfuefin,
														'codestpro1' :datos[k].codestpro1,
														'codestpro2' :datos[k].codestpro2,
														'codestpro3' :datos[k].codestpro3,
														'codestpro4' :datos[k].codestpro4,
														'codestpro5' :datos[k].codestpro5,
														'estcla'     :datos[k].estcla,
													});	
													var monsub = parseFloat(ue_formato_operaciones(datos[k].total));
													gridCuentas.store.insert(0,cuentasInt);
													if(Ext.getCmp('monsubtot').getValue()!=""){
														var montoaux = Ext.getCmp('monsubtot').getValue();
														montoaux = parseFloat(ue_formato_operaciones(montoaux));
														var montot = Ext.getCmp('montot').getValue();
														montot = parseFloat(ue_formato_operaciones(montot));
														Ext.getCmp('monsubtot').setValue(formatoNumericoMostrar(monsub+montoaux,2,'.',',','','','-',''));
														Ext.getCmp('montot').setValue(formatoNumericoMostrar(monsub+montot,2,'.',',','','','-',''));
													}
													else{
														Ext.getCmp('monsubtot').setValue(formatoNumericoMostrar(monsub,2,'.',',','','','-',''));
														Ext.getCmp('montot').setValue(formatoNumericoMostrar(monsub,2,'.',',','','','-',''));
													}
												}
											}
										},
										failure: function ( result, request){ 
											Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
										}//fin del success
									});//fin del ajax request
									obtenerMensaje('procesar','','Buscando Datos');
									var JSONObject = {
										'operacion' : 'cargarCuentasCargos',
										'numsol'    : numsol
									}			
									var ObjSon = JSON.stringify(JSONObject);
									var parametros = 'ObjSon='+ObjSon; 
									Ext.Ajax.request({
										url : '../../controlador/sep/sigesp_ctr_sep_solicitud.php',
										params : parametros,
										method: 'POST',
										success: function ( resultado, request){
											Ext.Msg.hide();
										  		var resultado = resultado.responseText;
										  		var objDatos = eval('(' + resultado + ')');
										  		var datos = objDatos.raiz;
										  		if (objDatos != ""){
										  			fromRegistroOrdenCompra.add(gridCuentasCreditos);
										  			gridCuentasCreditos.show();
													fromRegistroOrdenCompra.doLayout();
										  			if(objDatos.raiz==null || objDatos.raiz==''){
										  				Ext.getCmp('monimp').setValue(formatoNumericoMostrar(0,2,'.',',','','','-',''));
										  			}
										  			else{
										  				for(var l=0; l<datos.length; l++){
															var cuecreInt = new reCueCre({
				      	    									'estructura' :datos[l].estructura,
				      	    									'monto'      :datos[l].total,
				      	    									'spg_cuenta' :datos[l].spg_cuenta,
				      	    									'codfuefin'  :datos[l].codfuefin,
				      	    									'codcar'     :datos[l].codcar,
				      	    									'codestpro1' :datos[l].codestpro1,
				      	    									'codestpro2' :datos[l].codestpro2,
				      	    									'codestpro3' :datos[l].codestpro3,
				      	    									'codestpro4' :datos[l].codestpro4,
				      	    									'codestpro5' :datos[l].codestpro5,
				      	    									'formula'    :datos[l].formula,
				      	    									'estcla'     :datos[l].estcla
					    									});	
															var moncar = parseFloat(ue_formato_operaciones(datos[l].total));
															gridCuentasCreditos.store.insert(0,cuecreInt);
															if(Ext.getCmp('monimp').getValue()!=""){
																var montoaux = Ext.getCmp('monimp').getValue();
																montoaux = parseFloat(ue_formato_operaciones(montoaux));
																var montot = Ext.getCmp('montot').getValue();
																montot = parseFloat(ue_formato_operaciones(montot));
																Ext.getCmp('monimp').setValue(formatoNumericoMostrar(moncar+montoaux,2,'.',',','','','-',''));
																Ext.getCmp('montot').setValue(formatoNumericoMostrar(moncar+montot,2,'.',',','','','-',''));
															}
															else{
																Ext.getCmp('monimp').setValue(formatoNumericoMostrar(moncar,2,'.',',','','','-',''));
																var montot = Ext.getCmp('montot').getValue();
																if(montot!=""){
																	montot = parseFloat(ue_formato_operaciones(montot));
																	Ext.getCmp('montot').setValue(formatoNumericoMostrar(moncar+montot,2,'.',',','','','-',''));
																}
																
															}
									  					}
										  			}
										  		}
									  	  	},
				      	    				failure: function ( result, request){ 
			      	    						Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
			      	    				}//fin del success
									});//fin del ajax request
								}
							}
						}
					}
					gridVentanaCatalogoSolEjePre.destroy();
  	    			ventanaCatalogoSolEjePre.destroy();
				}		
    		},
			{
    		text: 'Salir',
	   			handler:function(){
    				ventanaCatalogoSolEjePre.close();
	   		    }
       		}
    	]
	});
	
	ventanaCatalogoSolEjePre.show();
	
}

//Funcion que retorna el nombre del Estatus para ser mostrado en la gridVentanaCatalogoSolEjePre
function mostrarEstatu(valor)
{
	if(valor=='A'){
		return 'Anulada';
	}
	if(valor=='P'){
		return 'Procesada';
	}
	if(valor=='E'){
		return 'Emitida';
	}
	if(valor=='R'){
		return 'Registrada';
	}
	if(valor=='C'){
		return 'Contabilizada';
	}
}


