function CatalogoServicios(codProceso){
	
	//Creando datastore y columnmodel para el catalogo de servicios
	var reVentana = Ext.data.Record.create([
	    {name: 'codser'}, 
	    {name: 'denser'},
	    {name: 'preser'},
	    {name: 'spg_cuenta'},
	    {name: 'existecuenta'}
	]);
	                                        	
	var dsVentana =  new Ext.data.Store({
	    reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reVentana)
	});
	                                						
	var cmVentana = new Ext.grid.ColumnModel([
		new Ext.grid.CheckboxSelectionModel(),
	    {header: "<H1 align='center'>Codigo</H1>", width: 20, sortable: true, dataIndex: 'codser'},
	    {header: "<H1 align='center'>Denominacion</H1>", width: 50, sortable: true, dataIndex: 'denser'},
	    {header: "<H1 align='center'>Precio Unitario</H1>", width: 30, sortable: true, dataIndex: 'preser'},
	    {header: "<H1 align='center'>Cuenta</H1>", width: 30, sortable: true, dataIndex: 'spg_cuenta'}
	]);
	
	//Creando grid del catalogo de servicios
	var gridVentanaCatalogoServicios = new Ext.grid.GridPanel({
	 		width:500,
	 		height:250,
			frame:true,
			style: 'position:absolute;left:0px;top:150px',
			autoScroll:true,
			enableColumnHide: false,
			enableHdMenu: false,
			border:true,
			ds: dsVentana,
    		cm: cmVentana,
			sm:new Ext.grid.CheckboxSelectionModel(),
    		stripeRows: true,
    		viewConfig: {forceFit:true}
	});
	
	gridVentanaCatalogoServicios.getView().getRowClass = function(record, index){
		if(record.data.existecuenta!='0'){
			return 'celda-azul';
		}
	}
	//------------------------------------------------------------------------------------------------------------------		 
	 
	//Creacion del formulario del catalogo servicios
	var formVentanaCatalogoServicios = new Ext.FormPanel({
		width: 550,
		height: 500,
		frame: true,
		autoScroll:false,
		items: [{
			xtype:"fieldset", 
			    title:'Datos del Servicio',
			    style: 'position:absolute;left:15px;top:10px',
				border:true,
				width: 500,
				cls: 'fondo',
				height: 140,
				items:[ {
					layout: "column",
					defaults: {border: false},
					style: 'position:absolute;left:15px;top:30px',
					items: [{
							layout: "form",
							border: false,
							labelWidth: 100,
							items: [{
								xtype: 'textfield',
								labelSeparator :'',
								fieldLabel: 'Codigo',
								name: 'codigo',
								id: 'codser',									
								width: 150,
								binding:true,
								hiddenvalue:'',
								defaultvalue:'',
								autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789');"},
								changeCheck: function(){
								    var textvalor = this.getValue();
									dsVentana.filter('codser',textvalor,true);
										if(String(textvalor) !== String(this.startValue)){
											this.fireEvent('change', this, textvalor, this.startValue);
										} 
								}, 
								initEvents: function(){
									AgregarKeyPress(this);
								}
							}]
					}]
     			},
     			{
					layout: "column",
					defaults: {border: false},
					style: 'position:absolute;left:15px;top:60px',
					items: [{
							layout: "form",
							border: false,
							labelWidth: 100,
							items: [{
								xtype: 'textfield',
								labelSeparator :'',
								fieldLabel: 'Denominacion',
								name: 'denominacion',
								id: 'denser',
								width: 350,
								binding:true,
								hiddenvalue:'',
								defaultvalue:'',
								changeCheck: function(){
									var textvalor = this.getValue();
									dsVentana.filter('denser',textvalor,true);
										if(String(textvalor) !== String(this.startValue)){
											this.fireEvent('change', this, textvalor, this.startValue);
										} 
								}, 
								initEvents: function(){
									AgregarKeyPress(this);
								}
							}]
					}]
     		},
     		gridVentanaCatalogoServicios,
       		{
       			layout:"column",
   				defaults: {border: false},
   				style: 'position:absolute;left:400px;top:100px',
   				border:false,
   				items:[{
   						layout:"form",
   						border:false,
   						items:[{
   							xtype: 'button',
			   				labelSeparator :'',
			   				fieldLabel: '',
			   				id: 'btagregar',
			   				text: 'Buscar',
			   				width: 300,
			   				height: 300,
			   				binding:true,
			   				hiddenvalue:'',
			   				defaultvalue:'',
			   				iconCls: 'menubuscar',
			   				handler: function(){
			   					obtenerMensaje('procesar','','Buscando Datos');
					   				
								//buscar  servicios
								var JSONObject = {
									'operacion'  : 'buscar_servicio',
									'codser'     : Ext.getCmp('codser').getValue(),
									'denser'     : Ext.getCmp('denser').getValue(),
									'codestpro1' : Ext.getCmp('codestpro1').getValue(),
				   				    'codestpro2' : Ext.getCmp('codestpro2').getValue(),
				   				    'codestpro3' : Ext.getCmp('codestpro3').getValue(),
				   				    'codestpro4' : Ext.getCmp('codestpro4').getValue(),
				   				    'codestpro5' : Ext.getCmp('codestpro5').getValue(),
				   				    'estcla'     : Ext.getCmp('estcla').getValue(),
				   				    'origenCat'  : codProceso
								}
						
								var ObjSon = JSON.stringify(JSONObject);
								var parametros = 'ObjSon='+ObjSon; 
								Ext.Ajax.request({
									url : '../../controlador/soc/sigesp_ctr_soc_registro_orden_compra.php',
									params : parametros,
									method: 'POST',
									success: function ( resultado, request){
										Ext.Msg.hide();
										var datos = resultado.responseText;
										var objServicio = eval('(' + datos + ')');
										if(objServicio!=''){
											if(objServicio.raiz == null || objServicio.raiz ==''){
			   									Ext.MessageBox.show({
								 					title:'Advertencia',
								 					msg:'No existen datos para mostrar',
								 					buttons: Ext.Msg.OK,
								 					icon: Ext.MessageBox.WARNING
								 				});
											}
											else{
												gridVentanaCatalogoServicios.store.loadData(objServicio);
											}
										}
									}//fin del success	
								});//fin del ajax request
							}
   			  			}]
   				}]
   			}]  
     	}]
    });
	//fin del formulario 
	//-------------------------------------------------------------------------------------------------------------------------	
	
    //Creando la ventana del catalogo servicios
	var ventanaServicios = new Ext.Window({
		title: "<H1 align='center'>Cat&#225;logo de Servicios</H1>",
        width:560,
        height:520,
        modal: true,
        closable:false,
        plain: false,
        frame:true,
        expandOnShow: false,
        items:[formVentanaCatalogoServicios],
        buttons: [{
        	text:'Aceptar',  
   		    handler: function(){
        		var arrRegistro = gridVentanaCatalogoServicios.getSelectionModel().getSelections();
        		if(codProceso=='SC'){
        			var reMovServicios = Ext.data.Record.create([
        				{name: 'codser'}, 
        				{name: 'denser'},
        				{name: 'canser'},
        				{name: 'numsep'}
        			]);
        			
        			for(var int=0; int< arrRegistro.length; int++){
        				var Servicios = arrRegistro[int];
        				if(validarExistenciaRegistroGrid(Servicios,gridServicios,'codser','codser',true)){
        					var ServiciosInt = new reMovServicios({
   								'codser'    :Servicios.get('codser'),
   								'denser'    :Servicios.get('denser'),
   								'canser'    :'',
   								'numsep'    :'0',
   								'coduniadm' :Ext.getCmp('coduniadm').getValue(),
   								'codestpro1':Ext.getCmp('codestpro1').getValue(),
   								'codestpro2':Ext.getCmp('codestpro2').getValue(),
   								'codestpro3':Ext.getCmp('codestpro3').getValue(),
   								'codestpro4':Ext.getCmp('codestpro4').getValue(),
   								'codestpro5':Ext.getCmp('codestpro5').getValue(),
   								'estcla'    :Ext.getCmp('estcla').getValue(),
   							});
  							if(Ext.getCmp('codfuefin').getValue()==''){
  								ServiciosInt.set('codfuefin','--');
  							}
  							else{
  								ServiciosInt.set('codfuefin',Ext.getCmp('codfuefin').getValue());
  							}
   							gridServicios.store.insert(0,ServiciosInt);
        				}
        			}
        		}
        		else if(codProceso=='OC'){
        			gridCuentasCreditos.store.removeAll();
					gridCuentas.store.removeAll();
					gridCuentasCreditos.hide();
					gridCuentas.hide();
					limpiarFormulario(fromTotales);
					fromTotales.hide();
        			var reMovServicios = Ext.data.Record.create([
        				{name: 'codser'}, 
        				{name: 'denser'},
        				{name: 'canser'},
        				{name: 'spg_cuenta'},
        				{name: 'existecuenta'}
        			]);
    		    	var reCargos = Ext.data.Record.create([
    		    	    {name: 'codser'},
 					    {name: 'codcar'}, 
 					    {name: 'dencar'},
 					    {name: 'estcla'},
 					    {name: 'spg_cuenta'},
 					    {name: 'formula'},
 					    {name: 'existecuenta'}
 				    ]);	
        			for(var int=0; int< arrRegistro.length; int++){
        				var Servicios = arrRegistro[int];
        				var codser = Servicios.get('codser');
    					if(validarExistenciaRegistroGrid(Servicios,gridServicios,'codser','codser',true)){
    						var ServiciosInt = new reMovServicios({
    							'codser'    :Servicios.get('codser'),
    							'denser'    :Servicios.get('denser'),
    							'canser'    :'',
    							'cuenta'    :Servicios.get('spg_cuenta'),
    							'existecuenta':Servicios.get('existecuenta'),
    							'monuniser' :'',
    							'estructura':Ext.getCmp('estructura').getValue(),
    							'coduniadm' :Ext.getCmp('coduniadm').getValue(),
    							'codestpro1':Ext.getCmp('codestpro1').getValue(),
   								'codestpro2':Ext.getCmp('codestpro2').getValue(),
   								'codestpro3':Ext.getCmp('codestpro3').getValue(),
   								'codestpro4':Ext.getCmp('codestpro4').getValue(),
   								'codestpro5':Ext.getCmp('codestpro5').getValue(),
   								'estcla'    :Ext.getCmp('estcla').getValue(),
   								'estapro'   :'0',
    							'numsol'    :'0',
    							'codfuefin' :'--'
    						});
    						if(ServiciosInt.get('existecuenta')>0){
								Ext.getCmp('estcom').setValue('1');
							}
  							if(Ext.getCmp('codfuefin').getValue()!=''){
  								ServiciosInt.set('codfuefin',Ext.getCmp('codfuefin').getValue());
  							}
    						gridServicios.store.insert(0,ServiciosInt);
    						
    						if(Ext.getCmp('tipconpro').getValue()!="F"){
    							//Busco segun el codigo del servicio los cargos asociados
     							var JSONObj = {
     								'operacion'  : 'cargar_cargosservicios',
     								'codser'     : codser,
     								'codestpro1' : Ext.getCmp('codestpro1').getValue(),
     				   			    'codestpro2' : Ext.getCmp('codestpro2').getValue(),
     				   			    'codestpro3' : Ext.getCmp('codestpro3').getValue(),
     				   			    'codestpro4' : Ext.getCmp('codestpro4').getValue(),
     				   			    'codestpro5' : Ext.getCmp('codestpro5').getValue(),
     				   			    'estcla'     : Ext.getCmp('estcla').getValue()
     							}
     							var ObjjSon=Ext.util.JSON.encode(JSONObj);
     		      	    		var parametros ='ObjSon='+ObjjSon;
     		      	    		Ext.Ajax.request({
     		      	    			url: '../../controlador/soc/sigesp_ctr_soc_registro_orden_compra.php',
     		      	    			params: parametros,
     		      	    			method: 'POST',
     		      	    			success: function ( result, request ) { 
     	  	    						Ext.Msg.hide();
     	  	    						var resultado = result.responseText;
     	  	    						var objDatos = eval('(' + resultado + ')');
     	  	    						var datos = objDatos.raiz;
     	  	    						if (objDatos != ""){
     	  	    							for(var j = 0; j < datos.length; j++){
     	  	    								var cargosInt = new reCargos({
     	  	    									'codigo'     :datos[j].codser,
     		      	    							'codcar'     :datos[j].codcar,
     		      	    							'dencar'     :datos[j].dencar,
     		      	    							'estcla'     :datos[j].estcla,
     		      	    							'spg_cuenta' :datos[j].spg_cuenta,
     		      	    							'existecuenta':datos[j].existecuenta,
     		      	    							'formula'    :datos[j].formula,
     		      	    							'codestpro1' :Ext.getCmp('codestpro1').getValue(),
          	    									'codestpro2' :Ext.getCmp('codestpro2').getValue(),
          	    									'codestpro3' :Ext.getCmp('codestpro3').getValue(),
          	    									'codestpro4' :Ext.getCmp('codestpro4').getValue(),
          	    									'codestpro5' :Ext.getCmp('codestpro5').getValue(),
          	    									'estcla'     :Ext.getCmp('estcla').getValue(),
         			      	    					'estructura' :Ext.getCmp('estructura').getValue(),
         			      	    					'numsol'     :'0',
         			      	    					'codfuefin'  :'--'
     	  	    								});
     			      	    					if(Ext.getCmp('codfuefin').getValue()!=''){
     			     								cargosInt.set('codfuefin',Ext.getCmp('codfuefin').getValue());
     			     							}
     			      	    					gridCreditos.store.insert(0,cargosInt);
     	  	    							}
     	  	    						}
     		  	    				},
     		      	    			failure: function ( result, request){ 
     		      	    				Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
     		      	    			}//fin del success
     		      	    		});//fin del ajax request
    						}
    					}
        			}
        			Ext.getCmp('monsubtot').setValue('');
	  				Ext.getCmp('monimp').setValue('');
	  				Ext.getCmp('montot').setValue('');
	  				gridCuentas.store.removeAll();
	  				gridCuentasCreditos.store.removeAll();
        		}
       			ventanaServicios.destroy();
   		    }
   		},{
   			text: 'Salir',
   		    handler:function(){
   				ventanaServicios.destroy();
   		    }
   		}]
	});
	
	ventanaServicios.show();
}	
