
function CatalogoOrdCom(codProceso,tipo){
	
	//Datos del combo tipo distribucion
	var reTipo = [ [ 'BIENES', 'B' ], 
	             [ 'SERVICIOS', 'S' ] ];
	
	var stTipo = new Ext.data.SimpleStore({
		fields : [ 'col', 'tipo' ],
		data : reTipo
	});
	
	//-------------------------------------------------------------------------------------
	function buscardenoEstado(rec)
	{
		var codpai = rec.get('codpai');
		var codest = rec.get('codest');
		var myJSONObject ={
				"operacion": 'denom_estado',
				"codpai":codpai
		};		
		ObjSon=JSON.stringify(myJSONObject);
		parametros = 'ObjSon='+ObjSon; 
		Ext.Ajax.request({
			url : '../../controlador/rpc/sigesp_ctr_rpc_proveedor.php',
			params : parametros,
			method: 'POST',
			success: function (resultado, request) { 
				datos = resultado.responseText;
				if(datos!='')
				{
					var DatosNuevo = eval('(' + datos + ')');
				}
				dsEstado.loadData(DatosNuevo);
				Ext.getCmp('codest').setValue(codest);
			}
		})	
	}

	//-------------------------------------------------------------------------------------
	
	function buscardenoMunicipio(rec)
	{
		var codpai = rec.get('codpai');
		var codest = rec.get('codest');
		var codmun = rec.get('codmun');
		var myJSONObject ={
				"operacion": 'denom_municipio',
				"codpai":codpai,
				"codest":codest
		};	
		ObjSon=JSON.stringify(myJSONObject);
		parametros = 'ObjSon='+ObjSon; 
		Ext.Ajax.request({
			url : '../../controlador/rpc/sigesp_ctr_rpc_proveedor.php',
			params : parametros,
			method: 'POST',
			success: function (resultado, request) { 
				datos = resultado.responseText;
				if(datos!='')
				{
					var DatosNuevo = eval('(' + datos + ')');
				}
				dsMunicipio.loadData(DatosNuevo);
				Ext.getCmp('codmun').setValue(codmun);
			}
		})		
	}
		
	//-------------------------------------------------------------------------------------
	
	function buscardenoParroquia(rec)
	{
		var codpai = rec.get('codpai');
		var codest = rec.get('codest');
		var codmun = rec.get('codmun');
		var codpar = rec.get('codpar');
		var myJSONObject ={
				"operacion": 'denom_parroquia',
				"codpai":codpai,
				"codest":codest,
				"codmun":codmun
		};	
		ObjSon=JSON.stringify(myJSONObject);
		parametros = 'ObjSon='+ObjSon; 
		Ext.Ajax.request({
			url : '../../controlador/rpc/sigesp_ctr_rpc_proveedor.php',
			params : parametros,
			method: 'POST',
			success: function (resultado, request) { 
				datos = resultado.responseText;
				if(datos!='')
				{
					var DatosNuevo = eval('(' + datos + ')');
				}
				dsParroquia.loadData(DatosNuevo);
				Ext.getCmp('codpar').setValue(codpar);
			}
		})	
	}
	
	//-------------------------------------------------------------------------------------
	//Buscar datos para el combo moneda
	function buscardenoMoneda(rec)
	{
		var codpai = rec.get('codpai');
		var codmon = rec.get('codmon');
		var myJSONObject ={
				"operacion": 'buscar_denmon',
				"codpai":codpai 
		};	
		var ObjSon=JSON.stringify(myJSONObject);
		var parametros = 'ObjSon='+ObjSon; 
		Ext.Ajax.request({
			url : '../../controlador/soc/sigesp_ctr_soc_registro_orden_compra.php',
			params : parametros,
			method: 'POST',
			success: function (resultado, request) { 
				var datosm = resultado.responseText;
				if(datosm!='')
				{
					var DatosMon = eval('(' + datosm + ')');
				}
				dsMoneda.loadData(DatosMon);
				Ext.getCmp('codmon').setValue(codmon);
			}//fin del success
		});//fin del ajax request
	}
	
	//-------------------------------------------------------------------------------------

	function Aceptar(registro){
		irCancelar();
		var tipo = null;
		var monsub = 0;
		var moncar = 0;
		limpiarFormulario(fromRegistroOrdenCompra);
		if(registro.get('codpai')!='---'){
			buscardenoEstado(registro);
			buscardenoMunicipio(registro);
			buscardenoParroquia(registro);
			buscardenoMoneda(registro);
		}
		setDataFrom(fromRegistroOrdenCompra,registro);
		if(registro.get('estapro')=='0'){
			fromRegistroOrdenCompra.add(botCreAsi);
			botCreAsi.show();
			fromRegistroOrdenCompra.doLayout();
		}
		//estatus de la compra
		var estcom = registro.get('estcom'); 
		switch (estcom){
	    	case "0": // Deberian ir en letras(R) como estan en la sep y en cxp 
	    		Ext.getCmp('estcotlabel').setValue('REGISTRADA');
	    		break;
	    	case "1":  //   Deberia ir  E
	    		if(registro.get('estapro')=='0'){
	    			Ext.getCmp('estcotlabel').setValue('EMITIDA');
	    		}
	    		else{
	    			Ext.getCmp('estcotlabel').setValue('EMITIDA(APROBADA)');
	    		}
	    		break;
	    	case "2": // DEBERIA IR P
	    		Ext.getCmp('estcotlabel').setValue('COMPROMETIDA (PROCESADA)');
	    		break;
	    	case "3": //DEBERIA IR A
	    		Ext.getCmp('estcotlabel').setValue('ANULADA');
	    		break;
	    	case "4": //DEBERIA IR ????
	    		Ext.getCmp('estcotlabel').setValue('ENTRADA COMPRA');
	    		break;
	    	case "5": //DEBERIA IR ????
	    		Ext.getCmp('estcotlabel').setValue('PRE-COMPROMETIDA');
	      		break;
	    	case "6": //DEBERIA IR ????
	    		Ext.getCmp('estcotlabel').setValue('PRE-COMPROMETIDA ANULADA');
	    		break;
	    	case "7": //DEBERIA IR ????
	    		Ext.getCmp('estcotlabel').setValue('SERVICIO RECIBIDO');
	    		break;
		}
		Actualizar = true;
		Ext.getCmp('monant').setValue(formatoNumericoMostrar(registro.monant,2,'.',',','','','-',''));
		var estapro = registro.get('estapro');
		var reArt = Ext.data.Record.create([
		      {name: 'codart'}, 
		      {name: 'denart'},
		      {name: 'canart'},
		      {name: 'coduniadm'},
		      {name: 'unidad'},
		      {name: 'preuniart'},
		      {name: 'monsubart'},
		      {name: 'montotart'},
		      {name: 'spg_cuenta'},
		      {name: 'estructura'},
		      {name: 'codestpro1'},
		      {name: 'codestpro2'},
		      {name: 'codestpro3'},
		      {name: 'codestpro4'},
		      {name: 'codestpro5'},
		      {name: 'codfuefin'},
		      {name: 'numsol'},
		      {name: 'estcla'}
		]);
		var reSer = Ext.data.Record.create([
		      {name: 'codser'}, 
		      {name: 'denser'},
		      {name: 'canser'},
		      {name: 'coduniadm'},
		      {name: 'monuniser'},
		      {name: 'monsubser'},
		      {name: 'montotser'},
		      {name: 'spg_cuenta'},
		      {name: 'estructura'},
		      {name: 'codestpro1'},
		      {name: 'codestpro2'},
		      {name: 'codestpro3'},
		      {name: 'codestpro4'},
		      {name: 'codestpro5'},
		      {name: 'codfuefin'},
		      {name: 'numsol'},
		      {name: 'estcla'}
	    ]);
		var reCuentas = Ext.data.Record.create([
		      {name: 'estructura'}, 
		      {name: 'total'},
		      {name: 'spg_cuenta'},
		      {name: 'codfuefin'},
		      {name: 'codestpro1'},
		      {name: 'codestpro2'},
		      {name: 'codestpro3'},
		      {name: 'codestpro4'},
		      {name: 'codestpro5'},
		      {name: 'estcla'}
		]);
		var reCueCre = Ext.data.Record.create([
		      {name: 'estructura'}, 
		      {name: 'total'},
		      {name: 'spg_cuenta'},
		      {name: 'codfuefin'},
		      {name: 'numsol'},
		      {name: 'codcar'},
		      {name: 'codestpro1'},
		      {name: 'codestpro2'},
		      {name: 'codestpro3'},
		      {name: 'codestpro4'},
		      {name: 'codestpro5'},
		      {name: 'estcla'},
		      {name: 'formula'}
		]);
		obtenerMensaje('procesar','','Buscando Datos');
		var JSONObject = {
			'operacion' : 'cargar_bieserordcom',
			'numordcom' : registro.get('numordcom'),
			'estcondat' : registro.get('estcondat')
		}			
		var ObjSon = JSON.stringify(JSONObject);
		var parametros = 'ObjSon='+ObjSon; 
		Ext.Ajax.request({
			url : '../../controlador/soc/sigesp_ctr_soc_registro_orden_compra.php',
			params : parametros,
			method: 'POST',
			success: function ( resultado, request){
				Ext.Msg.hide();
			  		var resultado = resultado.responseText;
			  		var objDatos = eval('(' + resultado + ')');
			  		var datos = objDatos.raiz;
			  		if (objDatos != ""){
							if(registro.get('estcondat')=='B'){
								tipo = registro.get('estcondat');
								Ext.getCmp('tipbieordcom').enable();
								fromRegistroOrdenCompra.add(gridBienes);
								gridBienes.show();
								fromRegistroOrdenCompra.doLayout();
								for(var j = 0; j < datos.length; j++){
									var bienesInt = new reArt({
										'codart'     :datos[j].codart,
										'denart'     :datos[j].denart,
										'canart'     :formatoNumericoMostrar(datos[j].canart,2,'.',',','','','-',''),
										'coduniadm'  :datos[j].coduniadm,
										'unidad'     :datos[j].unimed,
										'modalidad'  :datos[j].unidad,
										'preuniart'  :formatoNumericoMostrar(datos[j].preuniart,2,'.',',','','','-',''),
										'monsubart'  :formatoNumericoMostrar(datos[j].monsubart,2,'.',',','','','-',''),
										'monimp'     :formatoNumericoMostrar(0,2,'.',',','','','-',''),
										'montotart'  :formatoNumericoMostrar(datos[j].montotart,2,'.',',','','','-',''),
										'cuenta'     :datos[j].spg_cuenta,
										'estructura' :datos[j].estructura,
										'codestpro1' :datos[j].codestpro1,
										'codestpro2' :datos[j].codestpro2,
										'codestpro3' :datos[j].codestpro3,
										'codestpro4' :datos[j].codestpro4,
										'codestpro5' :datos[j].codestpro5,
										'codfuefin'  :datos[j].codfuefin,
										'numsol'     :datos[j].numsol,
										'estcla'     :datos[j].estcla,
										'estapro'    :estapro
									});	
									if(datos[j].numsol!=0){
										Ext.getCmp('entro').setValue(1);
									}
		  						fromRegistroOrdenCompra.add(gridCreditos);
		  			  			gridCreditos.show();
		  						fromRegistroOrdenCompra.doLayout();
		  						gridBienes.store.insert(0,bienesInt);
		  						
								}  	    									
							}
							else{
								tipo = registro.get('estcondat');
								Ext.getCmp('tipbieordcom').disable();
								fromRegistroOrdenCompra.add(gridServicios);
								gridServicios.show();
								fromRegistroOrdenCompra.doLayout();
								for(var j = 0; j < datos.length; j++){
									var codigo = datos[j].codser;
									var serviciosInt = new reSer({
										'codser'     :datos[j].codser,
										'denser'     :datos[j].denser,
										'canser'     :formatoNumericoMostrar(datos[j].canser,2,'.',',','','','-',''),
										'coduniadm'  :datos[j].coduniadm,
										'monuniser'  :formatoNumericoMostrar(datos[j].monuniser,2,'.',',','','','-',''),
										'monsubser'  :formatoNumericoMostrar(datos[j].monsubser,2,'.',',','','','-',''),
										'moiva'      :formatoNumericoMostrar(0,2,'.',',','','','-',''),
										'montotser'  :formatoNumericoMostrar(datos[j].montotser,2,'.',',','','','-',''),
										'cuenta'     :datos[j].spg_cuenta,
										'estructura' :datos[j].estructura,
										'codestpro1' :datos[j].codestpro1,
		  								'codestpro2' :datos[j].codestpro2,
		  								'codestpro3' :datos[j].codestpro3,
		  								'codestpro4' :datos[j].codestpro4,
		  								'codestpro5' :datos[j].codestpro5,
		  								'codfuefin'  :datos[j].codfuefin,
		  								'numsol'     :datos[j].numsol,
		  								'estcla'     :datos[j].estcla,
		  								'estapro'	 :estapro
									});
									if(datos[j].numsol!=0){
										Ext.getCmp('entro').setValue(1);
									}
	  							fromRegistroOrdenCompra.add(gridCreditos);
	  				  			gridCreditos.show();
	  							fromRegistroOrdenCompra.doLayout();
	  							gridServicios.store.insert(0,serviciosInt);
								}
							}
						}
		  	  	},
					failure: function ( result, request){ 
						Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
				}//fin del success
		});//fin del ajax request
		if(registro.get('tipconpro')!="F"){
				buscarcargos(registro.get('numordcom'),registro.get('estcondat'));
			}
		obtenerMensaje('procesar','','Buscando Datos');
		var JSONObject = {
			'operacion' : 'cargar_cuentas',
			'numero'    : registro.get('numordcom'),
			'estcondat' : registro.get('estcondat'),
			'tipsol'    : 'SOC'
		}			
		var ObjSon = JSON.stringify(JSONObject);
		var parametros = 'ObjSon='+ObjSon; 
		Ext.Ajax.request({
			url : '../../controlador/soc/sigesp_ctr_soc_registro_orden_compra.php',
			params : parametros,
			method: 'POST',
			success: function ( resultado, request){
				Ext.Msg.hide();
			  		var resultado = resultado.responseText;
			  		var objDatos = eval('(' + resultado + ')');
			  		var datos = objDatos.raiz;
			  		if (objDatos != ""){
			  			fromRegistroOrdenCompra.add(gridCuentas);
			  			fromRegistroOrdenCompra.add(fromTotales);
						gridCuentas.show();
						fromTotales.show();
						fromRegistroOrdenCompra.doLayout();
						for(var k=0; k<datos.length; k++){
							var cuentasInt = new reCuentas({
									'estructura' :datos[k].estructura,
									'monto'      :datos[k].total,
									'spg_cuenta' :datos[k].spg_cuenta,
									'codfuefin'  :datos[k].codfuefin,
									'codestpro1' :datos[k].codestpro1,
									'codestpro2' :datos[k].codestpro2,
									'codestpro3' :datos[k].codestpro3,
									'codestpro4' :datos[k].codestpro4,
									'codestpro5' :datos[k].codestpro5,
									'estcla'     :datos[k].estcla,
							});	
							if(registro.get('estcondat')=='B'){
								stBieSer = gridBienes.getStore();
							}
							else{
								stBieSer = gridServicios.getStore();
							}
							stBieSer.each(function (reBieSer){
								if(reBieSer.get('cuenta')==datos[k].spg_cuenta){
									if(validarExistenciaRegistroGrid(cuentasInt,gridCuentas,'spg_cuenta','spg_cuenta',false)){
										gridCuentas.store.insert(0,cuentasInt);
										var monto = parseFloat(ue_formato_operaciones(datos[k].total));
										monsub += monto;
	  	    						}
								}
							});
	  					}
						Ext.getCmp('monsubtot').setValue(formatoNumericoMostrar(monsub,2,'.',',','','','-',''));
						Ext.getCmp('montot').setValue(formatoNumericoMostrar(monsub,2,'.',',','','','-',''));
						}
		  	  	},
					failure: function ( result, request){ 
						Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
				}//fin del success
		});//fin del ajax request
		obtenerMensaje('procesar','','Buscando Datos');
		var JSONObject = {
			'operacion' : 'cargar_cuentas_creditos',
			'numero'    : registro.get('numordcom'),
			'estcondat' : registro.get('estcondat'),
			'tipsol'    : 'SOC'
		}			
		var ObjSon = JSON.stringify(JSONObject);
		var parametros = 'ObjSon='+ObjSon; 
		Ext.Ajax.request({
			url : '../../controlador/soc/sigesp_ctr_soc_registro_orden_compra.php',
			params : parametros,
			method: 'POST',
			success: function ( resultado, request){
				Ext.Msg.hide();
			  		var resultado = resultado.responseText;
			  		var objDatos = eval('(' + resultado + ')');
			  		var datos = objDatos.raiz;
			  		if (objDatos != ""){
			  			fromRegistroOrdenCompra.add(gridCuentasCreditos);
			  			gridCuentasCreditos.show();
						fromRegistroOrdenCompra.doLayout();
						Ext.getCmp('monimp').setValue(formatoNumericoMostrar(0,2,'.',',','','','-',''));
						if(registro.get('tipconpro')!="F"){
							for(var l=0; l<datos.length; l++){
								var cuecreInt = new reCueCre({
										'estructura' :datos[l].estructura,
										'monto'      :datos[l].total,
										'spg_cuenta' :datos[l].spg_cuenta,
										'codfuefin'  :datos[l].codfuefin,
										'codcar'     :datos[l].codcar,
										'codestpro1' :datos[l].codestpro1,
										'codestpro2' :datos[l].codestpro2,
										'codestpro3' :datos[l].codestpro3,
										'codestpro4' :datos[l].codestpro4,
										'codestpro5' :datos[l].codestpro5,
										'formula'    :datos[l].formula,
										'estcla'     :datos[l].estcla,
										'numsol'     :datos[l].numsol
								});	
								gridCuentasCreditos.store.insert(0,cuecreInt);
								var monto = parseFloat(ue_formato_operaciones(datos[l].total));
								moncar += monto;
		  					}
							Ext.getCmp('monimp').setValue(formatoNumericoMostrar(moncar,2,'.',',','','','-',''));
							var total = monsub + moncar;
							Ext.getCmp('montot').setValue(formatoNumericoMostrar(total,2,'.',',','','','-',''));
						}
			  		}
			  		else{
			  			fromRegistroOrdenCompra.add(gridCuentasCreditos);
			  			gridCuentasCreditos.show();
			  			Ext.getCmp('monimp').setValue(formatoNumericoMostrar(0,2,'.',',','','','-',''));
						fromRegistroOrdenCompra.doLayout();
			  		}
		  	  	},
					failure: function ( result, request){ 
						Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
				}//fin del success
		});//fin del ajax request
	}
	
	//-------------------------------------------------------------------------------------
	
	//funcion para el formato de fecha en grid
	function formatoFechaGrid(fecha){
		if (fecha != '') {
			var fechanoguion = fecha.replace('-', '/', 'g');
			var objfecha = new Date(fechanoguion);
			return objfecha.format(Date.patterns.fechacorta);
		}
		
	}
	//fin funcion para el formato de fecha en grid
	
	//-------------------------------------------------------------------------------------------------------------------------
	
	function buscarcargos(numordcom,tipo){
		var reCargos = Ext.data.Record.create([
		    {name: 'codigo'},
		    {name: 'codcar'}, 
		    {name: 'dencar'},
		    {name: 'spg_cuenta'},
		    {name: 'formula'},
		    {name: 'codestpro1'},
		    {name: 'codestpro2'},
		    {name: 'codestpro3'},
		    {name: 'codestpro4'},
		    {name: 'codestpro5'},
		    {name: 'estcla'},
		    {name: 'estructura'},
		    {name: 'numsol'},
		    {name: 'codfuefin'},
		    {name: 'monbasimp'},
		    {name: 'monimp'},
		    {name: 'monto'},
		    {name: 'existecuenta'}
		]);
		obtenerMensaje('procesar','','Buscando Datos');
		//Busco segun los cargos asociados a el bien 
		var JSONObj = {
				'operacion'  : 'cargar_cargos',
				'numero'     : numordcom,
				'tipo'       : tipo
		}
		var ObjjSon=Ext.util.JSON.encode(JSONObj);
		var parametros ='ObjSon='+ObjjSon;
		Ext.Ajax.request({
			url: '../../controlador/soc/sigesp_ctr_soc_registro_orden_compra.php',
			params: parametros,
			method: 'POST',
			success: function ( result, request ) { 
				Ext.Msg.hide();
				var resul = result.responseText;
				var Datos = eval('(' + resul + ')');
				var cargos = Datos.raiz;
				if (Datos != ""){
					for(var i = 0; i < cargos.length; i++){
						var cargosInt = new reCargos({
							'codigo'     :cargos[i].codigo,
							'codcar'     :cargos[i].codcar,
							'dencar'     :cargos[i].dencar,
							'estcla'     :cargos[i].estcla,
							'spg_cuenta' :cargos[i].spg_cuenta,
							'formula'    :cargos[i].formula,
							'estructura' :cargos[i].estructura,
							'codestpro1' :cargos[i].codestpro1,
							'codestpro2' :cargos[i].codestpro2,
							'codestpro3' :cargos[i].codestpro3,
							'codestpro4' :cargos[i].codestpro4,
							'codestpro5' :cargos[i].codestpro5,
							'estcla'     :cargos[i].estcla,
							'codfuefin'  :cargos[i].codfuefin,
							'numsol'     :cargos[i].numsol,
							'basimp'     :cargos[i].monbasimp,
							'moncar'     :cargos[i].monimp,
							'totcar'     :cargos[i].monto,
							'existecuenta':cargos[i].existecuenta
						});
						if(tipo=='B'){
							gridBienes.store.each(function (registro){
								if(registro.get('codart')==cargos[i].codigo){
									registro.set('monimp',cargos[i].monimp);
								}
							});
						}
						else{
							gridServicios.store.each(function (registro){
								if(registro.get('codser')==cargos[i].codigo){
									registro.set('moniva',cargos[i].monimp);
								}
							});
						}
						gridCreditos.store.insert(0,cargosInt);
					}
				}
			},
			failure: function ( result, request){ 
					Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
			}//fin del success
		});//fin del ajax request
	}

	//-------------------------------------------------------------------------------------------------------------------------
	
	//Creando el campo de proveedor
	var Proveedor = Ext.data.Record.create([
		  {name: 'cod_pro'},                             
		  {name: 'nompro'},
		  {name: 'dirpro'},
		  {name: 'rifpro'}
	]);
	                                    	
	var dsProveedor =  new Ext.data.Store({
		 reader: new Ext.data.JsonReader({
		 root: 'raiz',             
		 id: "id"},Proveedor)
	});
	                                    						
	var colmodelcatproveedor = new Ext.grid.ColumnModel([
		 {header: "<H1 align='center'>Codigo</H1>", width: 20, sortable: true,   dataIndex: 'cod_pro'},
		 {header: "<H1 align='center'>Nombre</H1>", width: 40, sortable: true, dataIndex: 'nompro'},
		 {header: "<H1 align='center'>Direccion</H1>", width: 80, sortable: true, dataIndex: 'dirpro'},
		 {header: "<H1 align='center'>RIF</H1>", width: 30, sortable: true, dataIndex: 'rifpro'}
	]);
		
	//componente campocatalogo para el campo proveedor
	comcampocatproveedor = new com.sigesp.vista.comCampoCatalogo({
			titvencat: "<H1 align='center'>Catlogo de Proveedores</H1>",
			anchoformbus: 450,
			altoformbus:180, 
			anchogrid: 450,
			altogrid: 400,
			anchoven: 470,
			altoven: 470,
			anchofieldset: 850,
			datosgridcat: dsProveedor,
			colmodelocat: colmodelcatproveedor, 
			rutacontrolador:'../../controlador/rpc/sigesp_ctr_rpc_cambioestatus.php',
			parametros: "ObjSon={'operacion': 'buscarProveedores'",
			arrfiltro:[{etiqueta:'Codigo',id:'codpr',valor:'cod_pro',longitud:'10',requerido:true},
					   {etiqueta:'Nombre',id:'nompr',valor:'nompro',requerido:true},
					   {etiqueta:'Direccion',id:'dirpr',valor:'dirpro'},
					   {etiqueta:'RIF',id:'rifpr',valor:'rifpro'}],
			posicion:'position:absolute;left:5px;top:70px', 
			tittxt:'Proveedor',
			idtxt:'codpro',
			campovalue:'cod_pro',
			anchoetiquetatext:130, 
			anchotext:150,
			anchocoltext:0.36, 
			idlabel:'nombpro',
			labelvalue:'nompro',
			anchocoletiqueta:0.50, 
			anchoetiqueta:200,
			tipbus:'P',
			binding:'C',
			hiddenvalue:'',
			defaultvalue:'---',
			allowblank:true
	});
	//fin componente para el campo proveedor/
	
	//-------------------------------------------------------------------------------------------------------------------------	
	
	//Creando datastore y columnmodel para el catalogo de orden de compra
	var reVentana = Ext.data.Record.create([
	          {name: 'numordcom'}, 
	          {name: 'cod_pro'},
	          {name: 'nompro'},
	          {name: 'rifpro'},
	          {name: 'tipbieordcom'},
	          {name: 'coduniadm'},
	          {name: 'codfuefin'},
	          {name: 'codtipmod'},
	          {name: 'forpagcom'},
	          {name: 'concom'},
	          {name: 'monbasimp'},
	          {name: 'obscom'},
	          {name: 'uniejeaso'},
	          {name: 'obsordcom'},
	          {name: 'conanusoc'},
	          {name: 'lugentnomdep'},
	          {name: 'lugentdir'},
	          {name: 'diaplacom'},
	          {name: 'fechentdesde'},
	          {name: 'fechenthasta'},
	          {name: 'estsegcom'},
	          {name: 'porsegcom'},
	          {name: 'monsegcom'},
	          {name: 'tascamordcom'},
	          {name: 'montotdiv'},
	          {name: 'codpai'},
	          {name: 'codest'},
	          {name: 'codmun'},
	          {name: 'codpar'},
	          {name: 'codmon'},
	          {name: 'denmon'},
	          {name: 'estcondat'},
	          {name: 'estcom'},
	          {name: 'fecordcom'},
	          {name: 'estlugcom'},
              {name: 'montot'},
              {name: 'monant'},
              {name: 'codestpro1'},
              {name: 'codestpro2'},
              {name: 'codestpro3'},
              {name: 'codestpro4'},
              {name: 'codestpro5'},
              {name: 'estcla'},
              {name: 'estructura'},
              {name: 'estapro'},
              {name: 'tipconpro'},
              {name: 'desest'},
              {name: 'denmun'},
              {name: 'denpar'},
	]);
	                                        	
	var dsVentana =  new Ext.data.Store({
	           reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reVentana)
	});
	                                						
	 var cmVentana = new Ext.grid.ColumnModel([  
	           {header: "<H1 align='center'>Nmero</H1>", width: 50, sortable: true, dataIndex: 'numordcom'},
	           {header: "<H1 align='center'>Proveedor</H1>", width: 60, sortable: true, dataIndex: 'nompro'},
	           {header: "<H1 align='center'>Concepto</H1>", width: 40, sortable: true, dataIndex: 'obscom'},
	           {header: "<H1 align='center'>Tipo</H1>", width: 30, align: 'center', sortable: true, dataIndex: 'estcondat', renderer: mostrarBieSer},
	           {header: "<H1 align='center'>Estatus</H1>", width: 30, align: 'center', sortable: true, dataIndex: 'estcom', renderer: mostrarEstatus},
	           {header: "<H1 align='center'>Fecha de Registro</H1>", align: 'center', width: 60, sortable: true, dataIndex: 'fecordcom'},
	           {header: "<H1 align='center'>Monto</H1>", width: 30, align: 'right', sortable: true, dataIndex: 'montot'}
	]);
	 
	//Creando grid para el catalogo de orden de compra
	var gridVentanaCatalogoOrdCom = new Ext.grid.GridPanel({
		width:650,
 		height:250,
		frame:true,
		style: 'position:absolute;left:0px;top:160px',
		autoScroll:true,
		border:true,
		ds: dsVentana,
		cm: cmVentana,
		stripeRows: true,
		viewConfig: {forceFit:true}
	});
	
	gridVentanaCatalogoOrdCom.on({
		'rowdblclick': {
			fn: function(grid, numFila, evento){
				var registro = grid.getStore().getAt(numFila);
				Aceptar(registro);
				gridVentanaCatalogoOrdCom.destroy();
				ventanaOrdCom.destroy();
 		    }
		}
	});
	
	//-------------------------------------------------------------------------------------------------------------------------		 

	//Creacion del formulario del catalogo orden de compra	
	var formVentanaCatalogoOrdCom = new Ext.FormPanel({
		width: 690,
		height: 450,
		style: 'position:absolute;left:5px;top:10px',
		frame: true,
		autoScroll:false,
		items: [{
			xtype:"fieldset", 
			title:'Datos de la Orden de Compra',
			style: 'position:absolute;left:15px;top:10px',
			border:true,
			width: 650,
			cls: 'fondo',
			height: 150,
			items:[{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:20px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 130,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Orden de Compra',
						id: 'numeordcom',									
						width: 150,
						autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '15', onkeypress: "return keyRestrict(event,'0123456789');"},
						changeCheck: function(){
							var textvalor = this.getValue();
							dsVentana.filter('numordcom',textvalor,true);
							if(String(textvalor) !== String(this.startValue)){
								this.fireEvent('change', this, textvalor, this.startValue);
							} 
						}, 
						initEvents: function(){
							AgregarKeyPress(this);
						}
					}]
				}]
			},
			{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:50px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 130,
					items: [{
						xtype: 'combo',
						fieldLabel: 'Tipo',
						labelSeparator :'',
						id: 'tipbieser',
						store : stTipo,
						valueField : 'tipo',
						editable : false,
						displayField : 'col',
						typeAhead : true,
						triggerAction : 'all',
						mode : 'local',
						emptyText:'----Seleccione----',
						listWidth:150,
						width:150,
						changeCheck: function(){
							var textvalor = this.getValue();
							dsVentana.filter('tipbieser',textvalor,true);
							if(String(textvalor) !== String(this.startValue)){
								this.fireEvent('change', this, textvalor, this.startValue);
							} 
						}, 
						initEvents: function(){
							AgregarKeyPress(this);
						}
					}]
				}]
			},comcampocatproveedor.fieldsetCatalogo,
			{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:380px;top:20px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype:"datefield",
						labelSeparator :'',
						fieldLabel:"Fecha Desde",
						name:"fechadesde",
						id: 'fecordcomdes',
						allowBlank:true,
						value: new Date().format('01/m/Y'),
						autoCreate: {tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789/');"},
						changeCheck: function(){
							var textvalor = this.getValue();
							dsVentana.filter('fecordcomdes',textvalor,true);
							if(String(textvalor) !== String(this.startValue)){
								this.fireEvent('change', this, textvalor, this.startValue);
							} 
						}, 
						initEvents: function(){
							AgregarKeyPress(this);
						}
					}]
				}]
			},
			{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:380px;top:50px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype:"datefield",
						fieldLabel:"Hasta",
						labelSeparator :'',
						name:"fechahasta",
						id: 'fecordcomhas',
						allowBlank:true,
						value: new Date().format('d/m/Y'),
						autoCreate: {tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789/');"},
						changeCheck: function(){
							var textvalor = this.getValue();
							dsVentana.filter('fecordcomhas',textvalor,true);
							if(String(textvalor) !== String(this.startValue)){
								this.fireEvent('change', this, textvalor, this.startValue);
							} 
						}, 
						initEvents: function(){
							AgregarKeyPress(this);
						}
					}]
				}]
			}, gridVentanaCatalogoOrdCom,
			{
				layout:"column",
		   		defaults: {border: false},
		   		style: 'position:absolute;left:420px;top:110px', 
		   		border:false,
		   		items:[{
		   			layout:"form",
		   			border:false,
		   			items:[{
		   				xtype: 'button',
		   				fieldLabel: '',
		   				id: 'btagregar',
		   				text: 'Buscar Orden de Compra',
		   				iconCls: 'menubuscar',
		   				handler: function(){
			   				if(Ext.getCmp('fecordcomdes').getValue()>Ext.getCmp('fecordcomhas').getValue()){
			    				Ext.MessageBox.show({
				 					title:'Advertencia',
				 					msg:'El rango de fechas no es valido!!!',
				 					buttons: Ext.Msg.OK,
				 					icon: Ext.MessageBox.WARNING
				 				});
			    			}
			    			else{
			   					obtenerMensaje('procesar','','Buscando Datos');
			   					
			   					//Buscar ordenes de compra
				   				var JSONObject = {
				   					'operacion'     : 'buscar_ordenes_compra',
				   					'numeordcom'    : Ext.getCmp('numeordcom').getValue(),
				   					'tipbieser'     : Ext.getCmp('tipbieser').getValue(),
				   					'codpro'        : Ext.getCmp('codpro').getValue(),
				   					'fecordcomdes'  : Ext.getCmp('fecordcomdes').getValue().format('d/m/Y'),
				   					'fecordcomhas'  : Ext.getCmp('fecordcomhas').getValue().format('d/m/Y')
				   				}
				   				
				   				var ObjSon = JSON.stringify(JSONObject);
				   				var parametros = 'ObjSon='+ObjSon; 
				   				Ext.Ajax.request({
				   					url : '../../controlador/soc/sigesp_ctr_soc_registro_orden_compra.php',
				   					params : parametros,
				   					method: 'POST',
				   					success: function ( resultado, request){
				   						Ext.Msg.hide();
				   						var datos = resultado.responseText;
				   						var objOrdCom = eval('(' + datos + ')');
				   						if(objOrdCom!=''){
				   							if(objOrdCom!='0'){
				   								if(objOrdCom.raiz == null || objOrdCom.raiz ==''){
				   									Ext.MessageBox.show({
									 					title:'Advertencia',
									 					msg:'No existen datos para mostrar',
									 					buttons: Ext.Msg.OK,
									 					icon: Ext.MessageBox.WARNING
									 				});
												}
												else{
				   									gridVentanaCatalogoOrdCom.store.loadData(objOrdCom);
												}
				   							}
				   							else{
				   								Ext.MessageBox.show({
									 				title:'Advertencia',
									 				msg:'',
									 				buttons: Ext.Msg.OK,
									 				icon: Ext.MessageBox.WARNING
									 			});
				   							}
				   						}
				   					}//fin del success	
				   				});//fin del ajax request
		   		           	}
		   				}
	   				}]
	   			}]
		   	}]  
    	}]   
	});
	//fin del formulario 
	
	//-------------------------------------------------------------------------------------------------------------	
	
	//Creando la ventana del catalogo del registro de orden de compra
	var ventanaOrdCom = new Ext.Window({
		title: "<H1 align='center'>Cat&#225;logo del Registro de Orden de Compra</H1>",
        width:700, 
        height:520,
        modal: false,
        closable:false,
        plain: false,
        frame:true,
        items:[formVentanaCatalogoOrdCom],
		buttons: [{
			text:'Aceptar',  
				handler: function(){
					var registro = gridVentanaCatalogoOrdCom.getSelectionModel().getSelected();
					if(codProceso=='OC'){
						Aceptar(registro);
					}
					gridVentanaCatalogoOrdCom.destroy();
					ventanaOrdCom.destroy();
				}
			},
			{
   			text: 'Salir',
   				handler:function(){
   					ventanaOrdCom.destroy();
   		    	}
			}	
		]
	});
	
	ventanaOrdCom.show();
}	

//Funcion que retorna Bien si es B o Servicio si es S para ser mostrado en la gridVentanaCatalogoOrdCom
function mostrarBieSer(valor)
{
	if(valor=='B'){
		return 'Bien';
	}
	else
		return 'Servicio';
}
//Funcion que retorna el nombre del Estatus para ser mostrado en la gridVentanaCatalogoOrdCom
function mostrarEstatus(valor)
{
	switch (valor){
    	case "0": // Deberian ir en letras(R) como estan en la sep y en cxp 
    		return 'REGISTRADA';
    		break;
    	case "1":  //   Deberia ir  E
    		return 'EMITIDA';
    		break;
    	case "2": // DEBERIA IR P
    		return 'COMPROMETIDA (PROCESADA)';
    		break;
    	case "3": //DEBERIA IR A
    		return 'ANULADA';
    		break;
    	case "4": //DEBERIA IR ????
    		return 'ENTRADA COMPRA';
    		break;
    	case "5": //DEBERIA IR ????
    		return 'PRE-COMPROMETIDA';
      		break;
    	case "6": //DEBERIA IR ????
    		return 'PRE-COMPROMETIDA ANULADA';
    		break;
    	case "7": //DEBERIA IR ????
    		return 'SERVICIO RECIBIDO';
    		break;
	}
}


