
function CatalogoProveedores(codigo){
	
	//Creando el campo de proveedores
	var reVentana = Ext.data.Record.create([
	          {name: 'cod_pro'}, 
	          {name: 'nompro'},
	          {name: 'rifpro'},
	          {name: 'dirpro'},
	          {name: 'telpro'}
	]);
	                                        	
	var dsVentana =  new Ext.data.Store({
	           reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reVentana)
	});
	                                						
	 var cmVentana = new Ext.grid.ColumnModel([
	           new Ext.grid.CheckboxSelectionModel(),
	           {header: "<H1 align='center'>Codigo</H1>", width: 30, sortable: true, dataIndex: 'cod_pro'},
	           {header: "<H1 align='center'>Nombre</H1>", width: 50, sortable: true, dataIndex: 'nompro'},
	           {header: "<H1 align='center'>RIF</H1>", width: 30, sortable: true, dataIndex: 'rifpro'}
	]);
	//fin creando datastore y columnmodel para el catalogo de proveedores
	 
	 var gridVentanaCatalogoProveedores = new Ext.grid.GridPanel({
	 		width:500,
	 		height:250,
			frame:true,
			style: 'position:absolute;left:0px;top:190px',
			autoScroll:true,
			enableColumnHide: false,
			enableHdMenu: false,
			border:true,
			ds:dsVentana,
    		cm:cmVentana,
			sm:new Ext.grid.CheckboxSelectionModel(),
    		stripeRows: true,
    		viewConfig: {forceFit:true}
	});
	 
	//-------------------------------------------------------------------------------------------------------------------------		 
 
	 
	//Creacion del formulario del catalogo proveedores
	 var formVentanaCatalogoProveedores = new Ext.FormPanel({
	 	width: 550,
		height: 500,
		frame: true,
		autoScroll:false,
		items: [{
			xtype:"fieldset", 
			title:'Datos del Proveedor',
			style: 'position:absolute;left:10px;top:5px',
			border:true,
			width: 500,
			cls :'fondo',
			height: 180,
			items:[ {
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:20px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Codigo',
						name: 'codigo',
						id: 'codpro',									
						width: 120,
						binding:true,
						hiddenvalue:'',
						defaultvalue:'',
						autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789');"},
						changeCheck: function(){
							var textvalor = this.getValue();
							dsVentana.filter('cod_pro',textvalor,true);
								if(String(textvalor) !== String(this.startValue)){
									this.fireEvent('change', this, textvalor, this.startValue);
								} 
						}, 
						initEvents: function(){
							AgregarKeyPress(this);
						}
					}]
				}]
     		},
     		{
     			layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:50px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Nombre',
						name: 'nombre',
						id: 'nompro',
						width: 350,
						binding:true,
						hiddenvalue:'',
						defaultvalue:'',
						changeCheck: function(){
							var textvalor = this.getValue();
							dsVentana.filter('nompro',textvalor,true);
								if(String(textvalor) !== String(this.startValue)){
									this.fireEvent('change', this, textvalor, this.startValue);
								} 
						}, 
						initEvents: function(){
							AgregarKeyPress(this);
						}	
					}]
				}]
     		},
			{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:80px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Direccion',
						name: 'direccion',
						id: 'dirpro',
						width: 350,
						binding:true,
						hiddenvalue:'',
						defaultvalue:'',
						changeCheck: function(){
							var textvalor = this.getValue();
							dsVentana.filter('dirpro',textvalor,true);
								if(String(textvalor) !== String(this.startValue)){
									this.fireEvent('change', this, textvalor, this.startValue);
								} 
						}, 
						initEvents: function(){
							AgregarKeyPress(this);
						}
					}]
				}]
     		},
			{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:110px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'RIF',
						name: 'rif',
						id: 'rifpro',
						width: 120,
						binding:true,
						hiddenvalue:'',
						defaultvalue:'',
						autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '15'},
						changeCheck: function(){
							var textvalor = this.getValue();
							dsVentana.filter('rifpro',textvalor,true);
								if(String(textvalor) !== String(this.startValue)){
									this.fireEvent('change', this, textvalor, this.startValue);
								} 
						}, 
						initEvents: function(){
							AgregarKeyPress(this);
						}
					}]
				}]
	     	},
	     	gridVentanaCatalogoProveedores,
	     	{
				layout:"column",
				defaults: {border: false},
				style: 'position:absolute;left:420px;top:140px',
				border:false,
				items:[{
					layout:"form",
					border:false,
					items:[{
						xtype: 'button',
						labelSeparator :'',
						fieldLabel: '',
						id: 'btagregar',
						text: 'Buscar',
						width: 300,
						height: 300,
						binding:true,
						hiddenvalue:'',
						defaultvalue:'',
						iconCls: 'menubuscar',
						handler: function(){
							//buscar  proveedores
							var codpro  = Ext.getCmp('codpro').getValue();
							var nompro  = Ext.getCmp('nompro').getValue();
							var dirpro  = Ext.getCmp('dirpro').getValue();
							var rifpro  = Ext.getCmp('rifpro').getValue();
							if((codpro == '') && (nompro == '') && (dirpro == '') && (rifpro == '')){
								Ext.Msg.show({
									title:'Mensaje',
									msg:'Debe seleccionar al menos un par&#225;metro de b&#250;squeda',
									buttons: Ext.Msg.OK,
									icon: Ext.MessageBox.INFO
								});
							}
							else{
								obtenerMensaje('procesar','','Buscando Datos');
				   				
				
				   				var JSONObject = {
				   					'operacion' : 'buscarProveedores',
				   					'codpro'    : codpro,
				   					'nompro'    : nompro,
				   					'dirpro'    : dirpro,
					                'rifpro'    : rifpro
				   				}
							
				   				var ObjSon = JSON.stringify(JSONObject);
				   				var parametros = 'ObjSon='+ObjSon; 
				   				Ext.Ajax.request({
				   					url : '../../controlador/rpc/sigesp_ctr_rpc_cambioestatus.php',
				   					params : parametros,
				   					method: 'POST',
				   					success: function ( resultado, request){
				   						Ext.Msg.hide();
				   						var datos = resultado.responseText;
				   						var objProveedor = eval('(' + datos + ')');
				   						if(objProveedor!=''){
				   							gridVentanaCatalogoProveedores.store.loadData(objProveedor);
				   						}
				   					}//fin del success	
						   		});//fin del ajax request
							}	
				      	}
					}]
				}]
   			}]  
		}]   
	});
	
	//fin del formulario 
	 
	//-------------------------------------------------------------------------------------------------------------------------	
	
	var ventanaProveedor = new Ext.Window({
		title: "<H1 align='center'>Cat&#225;logo de Proveedor</H1>",
        width:550,
        height:530,
        modal: true,
        closable:false,
        plain: false,
        frame:true,
        items:[formVentanaCatalogoProveedores],
        buttons: [{
        	text:'Aceptar',  
	        handler: function(){
        	
	        	if(codigo=='SC'){
	        		var reMovProveedores = Ext.data.Record.create([
						{name: 'cod_pro'}, 
						{name: 'nompro'},
						{name: 'dirpro'},
						{name: 'telpro'}
					]);
		        	var arrRegistro = gridVentanaCatalogoProveedores.getSelectionModel().getSelections();
	        		for ( var int = 0; int < arrRegistro.length; int++) {
						var proveedor = arrRegistro[int];
						if(validarExistenciaRegistroGrid(proveedor,gridProveedores,'cod_pro','cod_pro',true)){
							var proveedorInt = new reMovProveedores({
								'cod_pro':proveedor.get('cod_pro'),
								'nompro' :proveedor.get('nompro'),
								'dirpro' :proveedor.get('dirpro'),
								'telpro' :proveedor.get('telpro')
							});
							gridProveedores.store.insert(0,proveedorInt);
						}
					}
	        		ventanaProveedor.destroy();
	        	}
	        }
		},{
			text: 'Salir',
   		    handler:function(){
   		    	ventanaProveedor.destroy();
			}
		}]
			
	});
	
	ventanaProveedor.show();
}	


