
function CatalogoBienes(codProceso){
  
	//Creando datastore y columnmodel para el catalogo de bienes
	var reVentana = Ext.data.Record.create([
	          {name: 'codart'}, 
	          {name: 'denart'},
	          {name: 'coduniadm'},
	          {name: 'denunimed'},
	          {name: 'spg_cuenta'},
	          {name: 'existecuenta'},
	          {name: 'unidad'}
	]);
	                                        	
	var dsVentana =  new Ext.data.Store({
	           reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reVentana)
	});
	                                						
	 var cmVentana = new Ext.grid.ColumnModel([
	           new Ext.grid.CheckboxSelectionModel(),
	           {header: "<H1 align='center'>Codigo</H1>", width: 20, sortable: true, dataIndex: 'codart'},
	           {header: "<H1 align='center'>Denominacion</H1>", width: 80, sortable: true, dataIndex: 'denart'},
	           {header: "<H1 align='center'>Unidad</H1>", width: 30, sortable: true, dataIndex: 'denunimed'},
	           {header: "<H1 align='center'>Cuenta</H1>", width: 30, sortable: true, dataIndex: 'spg_cuenta'}
	]);
	
	//Creando grid para el catalogo de bienes
	var gridVentanaCatalogoBienes = new Ext.grid.GridPanel({
		width:500,
 		height:240,
		frame:true,
		style: 'position:absolute;left:0px;top:170px',
		autoScroll:true,
		enableColumnHide: false,
		enableHdMenu: false,
		border:true,
		ds: dsVentana,
		cm: cmVentana,
		sm:new Ext.grid.CheckboxSelectionModel(),
		stripeRows: true,
		viewConfig: {forceFit:true}
	});
	
	gridVentanaCatalogoBienes.getView().getRowClass = function(record, index){
		if(record.data.existecuenta!='0'){
			return 'celda-azul';
		}
	}
	//-------------------------------------------------------------------------------------------------------------------------		 
	 
	
	//Creacion del combo tipo de bienes
	var reTipBie = Ext.data.Record.create([
		{name:'codtipart'},
		{name:'dentipart'}           
	]);

	var	dsTipBie =  new Ext.data.Store({
		reader: new Ext.data.JsonReader({root: 'raiz', id: "id"},reTipBie)
	});
		
	var myJSONObject = {
		"operacion": 'buscarTipoArticulo'
	};	
	
	var ObjSon = JSON.stringify(myJSONObject);
	var parametros = 'ObjSon='+ObjSon; 
	Ext.Ajax.request({
		url : '../../controlador/soc/sigesp_ctr_soc_solicitud_cotizacion.php',
		params : parametros,
		method: 'POST',
		success: function (resultado, request) { 
			var datos = resultado.responseText;  
			if(datos!=''){
				var DatosNuevo = eval('(' + datos + ')');
				dsTipBie.loadData(DatosNuevo);
			}
		}//fin de success
	});//fin de ajax request
	 
	//-------------------------------------------------------------------------------------------------------------------------		 
	 
	//Creacion del formulario del catalogo bienes
	var formVentanaCatalogoBienes = new Ext.FormPanel({
		width: 550,
		height: 450,
		frame:true,
		autoScroll:false,
		items: [{
			xtype:"fieldset", 
		    title:'Datos del Artculo',
		    style: 'position:absolute;left:15px;top:10px',
			border:true,
			width: 500,
			cls: 'fondo',
			height: 160,
			items:[{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:30px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Codigo',
						name: 'codigo',
						id: 'codart',									
						width: 150,
						autoCreate: {tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '20', onkeypress: "return keyRestrict(event,'abcdefghijklmnopqrstuvwxyz ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.;,!@%&/\()?-+*[]{}');"},
						changeCheck: function(){
							var textvalor = this.getValue();
							dsVentana.filter('codart',textvalor,true);
								if(String(textvalor) !== String(this.startValue)){
									this.fireEvent('change', this, textvalor, this.startValue);
								} 
						}, 
						initEvents: function(){
							AgregarKeyPress(this);
						}
					}]
				}]
     		},
     		{
     			layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:60px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Denominacion',
						name: 'denominacion',
						id: 'denart',
						width: 350,
						changeCheck: function(){
							var textvalor = this.getValue();
							dsVentana.filter('denart',textvalor,true);
							if(String(textvalor) !== String(this.startValue)){
								this.fireEvent('change', this, textvalor, this.startValue);
							} 
						}, 
						initEvents: function(){
							AgregarKeyPress(this);
						}
					}]
				}]
     		},
     		{
     			layout: "column",
				border: false,
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:90px',
				items: [{
					layout: "form",
 					border: false,
 					labelWidth: 100,			
 					items: [{
 						xtype:"combo",
 			        	store: dsTipBie,
 			        	labelSeparator :'',
 			        	valueField: 'codtipart',
 			        	displayField: 'dentipart', 
 			        	id:"codtipart",
 			        	typeAhead: true,
 			        	mode: 'local',
				        triggerAction: 'all',
				        fieldLabel:'Tipo',
				   	    listWidth:250,
				   	    editable:false,
				        width:250
 		    		}]
         		}]
       		},
       		{
       			layout:"column",
		   		defaults: {border: false},
		   		style: 'position:absolute;left:420px;top:120px', 
		   		border:false,
		   		items:[{
		   			layout:"form",
		   			border:false,
		   			items:[{
		   				xtype: 'button',
		   				fieldLabel: '',
		   				id: 'btagregar',
		   				text: 'Buscar',
		   				iconCls: 'menubuscar',
		   				handler: function(){
		   				
		   					obtenerMensaje('procesar','','Buscando Datos');
		   					
	   						//buscar bienes
			   				var JSONObject = {
			   					'operacion'  : 'buscar_bienes',
			   					'codart'     : Ext.getCmp('codart').getValue(),
			   					'denart'     : Ext.getCmp('denart').getValue(),
			   					'codtipart'  : Ext.getCmp('codtipart').getValue(),
			   				    'codestpro1' : Ext.getCmp('codestpro1').getValue(),
			   				    'codestpro2' : Ext.getCmp('codestpro2').getValue(),
			   				    'codestpro3' : Ext.getCmp('codestpro3').getValue(),
			   				    'codestpro4' : Ext.getCmp('codestpro4').getValue(),
			   				    'codestpro5' : Ext.getCmp('codestpro5').getValue(),
			   				    'estcla'     : Ext.getCmp('estcla').getValue(),
			   				    'origenCat'  : codProceso
			   				}
	   				
			   				var ObjSon = JSON.stringify(JSONObject);
			   				var parametros = 'ObjSon='+ObjSon; 
			   				Ext.Ajax.request({
			   					url : '../../controlador/soc/sigesp_ctr_soc_solicitud_cotizacion.php',
			   					params : parametros,
			   					method: 'POST',
			   					success: function ( resultado, request){
			   						Ext.Msg.hide();
			   						var datos = resultado.responseText;
			   						var objBienes = eval('(' + datos + ')');
			   						if(objBienes!=''){
			   							if(objBienes!='0'){
			   								if(objBienes.raiz == null || objBienes.raiz ==''){
			   									Ext.MessageBox.show({
								 					title:'Advertencia',
								 					msg:'No existen datos para mostrar',
								 					buttons: Ext.Msg.OK,
								 					icon: Ext.MessageBox.WARNING
								 				});
											}
											else{
			   									gridVentanaCatalogoBienes.store.loadData(objBienes);
											}
			   							}
			   							else{
			   								Ext.MessageBox.show({
								 				title:'Advertencia',
								 				msg:'Debe configurar en Empresa los digitos de las cuentas de gastos',
								 				buttons: Ext.Msg.OK,
								 				icon: Ext.MessageBox.WARNING
								 			});
			   							}
			   						}
			   					}//fin del success	
			   				});//fin del ajax request
		   		        }
		   			}]
		   		}]
   			},
   			gridVentanaCatalogoBienes]  
    	}]   
	});
	//fin del formulario 
	//-------------------------------------------------------------------------------------------------------------	
	
	//Creando la ventana del catalogo bienes
	var ventanaBienes = new Ext.Window({
		title: "<H1 align='center'>Cat&#225;logo de Bienes y Materiales</H1>",
        width:560,
        height:520,
        modal: false,
        closable:false,
        plain: false,
        frame:true,
        items:[formVentanaCatalogoBienes],
		buttons: [{
			text:'Aceptar',  
			handler: function(){
				var arrRegistro = gridVentanaCatalogoBienes.getSelectionModel().getSelections();
				if(codProceso=='SC'){
					var reMovBienes = Ext.data.Record.create([
						{name: 'codart'}, 
						{name: 'denart'},
						{name: 'canart'},
						{name: 'numsep'},
						{name: 'denunimed'}
					]);
					
					for ( var int = 0; int < arrRegistro.length; int++) {
	    				var bienes = arrRegistro[int];
	    				if(validarExistenciaRegistroGrid(bienes,gridBienes,'codart','codart',true)){
							var bienesInt = new reMovBienes({
								'codart'   :'',
								'denart'   :'',
								'canart'   :'',
								'numsep'   :'0',
								'denunimed':''
							});
							bienesInt.set('codart',bienes.get('codart'));
							bienesInt.set('denart',bienes.get('denart'));
							bienesInt.set('denunimed',bienes.get('denunimed'));
							bienesInt.set('coduniadm',Ext.getCmp('coduniadm').getValue());
  							bienesInt.set('codestpro1',Ext.getCmp('codestpro1').getValue());
  							bienesInt.set('codestpro2',Ext.getCmp('codestpro2').getValue());
  							bienesInt.set('codestpro3',Ext.getCmp('codestpro3').getValue());
  							bienesInt.set('codestpro4',Ext.getCmp('codestpro4').getValue());
  							bienesInt.set('codestpro5',Ext.getCmp('codestpro5').getValue());
  							bienesInt.set('estcla',Ext.getCmp('estcla').getValue());
  							bienesInt.set('modalidad','D');
  							if(Ext.getCmp('codfuefin').getValue()==''){
  								bienesInt.set('codfuefin','--');
  							}
  							else{
  								bienesInt.set('codfuefin',Ext.getCmp('codfuefin').getValue());
  							}
							gridBienes.store.insert(0,bienesInt);
	    				}
					}
					
				}
				else if(codProceso=='OC'){
					gridCuentasCreditos.store.removeAll();
					gridCuentas.store.removeAll();
					gridCuentasCreditos.hide();
					gridCuentas.hide();
					limpiarFormulario(fromTotales);
					fromTotales.hide();
					var modalidad = null;
					var aux = formatoNumericoMostrar(1,2,'.',',','','','-','');
					var reMovBienes = Ext.data.Record.create([
  						{name: 'codart'}, 
  						{name: 'denart'},
  						{name: 'canart'},
  						{name: 'unidad'},
  						{name: 'spg_cuenta'},
  						{name: 'existecuenta'}
  					]);
					
					var reCargos = Ext.data.Record.create([
						{name: 'codart'},
						{name: 'codcar'}, 
						{name: 'dencar'},
						{name: 'estcla'},
						{name: 'spg_cuenta'},
						{name: 'formula'},
						{name: 'existecuenta'}
					]);
					for(var i=0; i<arrRegistro.length; i++){
						var bienes = arrRegistro[i];
						var codart = bienes.get('codart');
	    				if(bienes.get('unidad')==aux){
	    					modalidad = 'D';
	    				}
	    				else{
	    					modalidad = 'M';
	    				}
	    				if(validarExistenciaRegistroGrid(bienes,gridBienes,'codart','codart',true)){
							var bienesInt = new reMovBienes({
								'codart'    :bienes.get('codart'),
								'denart'    :bienes.get('denart'),
								'canart'    :'',
								'unidad'    :bienes.get('unidad'),
								'modalidad' :modalidad,
								'cuenta'    :bienes.get('spg_cuenta'),
								'existecuenta':bienes.get('existecuenta'),
								'preuniart' :'',
								'estructura':Ext.getCmp('estructura').getValue(),
								'coduniadm' :Ext.getCmp('coduniadm').getValue(),
								'codestpro1':Ext.getCmp('codestpro1').getValue(),
								'codestpro2':Ext.getCmp('codestpro2').getValue(),
								'codestpro3':Ext.getCmp('codestpro3').getValue(),
  								'codestpro4':Ext.getCmp('codestpro4').getValue(),
  								'codestpro5':Ext.getCmp('codestpro5').getValue(),
  								'estcla'    :Ext.getCmp('estcla').getValue(),
  								'estapro'   :'0',
  								'numsol'    :'0',
  								'codfuefin' :'--'
							});
							if(bienes.get('existecuenta')!='0'){
								Ext.getCmp('estcom').setValue('1');
							}
  							if(Ext.getCmp('codfuefin').getValue()!=''){
  								bienesInt.set('codfuefin',Ext.getCmp('codfuefin').getValue());
  							}
							gridBienes.store.insert(0,bienesInt);
							if(Ext.getCmp('tipconpro').getValue()!="F"){
								var JSONObj = {
									'operacion'  : 'cargar_cargosbienes',
									'codart'     : codart,
									'codestpro1' : Ext.getCmp('codestpro1').getValue(),
				   				    'codestpro2' : Ext.getCmp('codestpro2').getValue(),
				   				    'codestpro3' : Ext.getCmp('codestpro3').getValue(),
				   				    'codestpro4' : Ext.getCmp('codestpro4').getValue(),
				   				    'codestpro5' : Ext.getCmp('codestpro5').getValue(),
				   				    'estcla'     : Ext.getCmp('estcla').getValue()
								}
								
								var ObjjSon=Ext.util.JSON.encode(JSONObj);
		      	    			var parametros ='ObjSon='+ObjjSon;
		      	    			Ext.Ajax.request({
		      	    				url: '../../controlador/soc/sigesp_ctr_soc_registro_orden_compra.php',
		      	    				params: parametros,
		      	    				method: 'POST',
		      	    				success: function ( result, request ) { 
	  	    							Ext.Msg.hide();
	  	    							var resultado = result.responseText;
	  	    							var objDatos = eval('(' + resultado + ')');
	  	    							var datos = objDatos.raiz;
	  	    							if (objDatos != ""){
	  	    								for(var j = 0; j < datos.length; j++){
	  	    									var cargosInt = new reCargos({
	  	    										'codigo'     :datos[j].codart,
	  	    										'codcar'     :datos[j].codcar,
	  	    										'dencar'     :datos[j].dencar,
	  	    										'spg_cuenta' :datos[j].spg_cuenta,
	  	    										'formula'    :datos[j].formula,
	  	    										'existecuenta':datos[j].existecuenta,
	  	    										'codestpro1' :Ext.getCmp('codestpro1').getValue(),
	  	    										'codestpro2' :Ext.getCmp('codestpro2').getValue(),
	  	    										'codestpro3' :Ext.getCmp('codestpro3').getValue(),
	  	    									    'codestpro4' :Ext.getCmp('codestpro4').getValue(),
	  	    									    'codestpro5' :Ext.getCmp('codestpro5').getValue(),
	  	    									    'estcla'     :Ext.getCmp('estcla').getValue(),
	  	    									    'estructura' :Ext.getCmp('estructura').getValue(),
	  	    									    'numsol'     :'0',
	  	    									    'codfuefin'  :'--'
	  	    									});
	  	    									if(Ext.getCmp('codfuefin').getValue()!=''){
	  	    										cargosInt.set('codfuefin',Ext.getCmp('codfuefin').getValue());
	 			     							}
	  	    									gridCreditos.store.insert(0,cargosInt);
	  	    								}
	  	    							}
		  	    					},
		      	    				failure: function ( result, request){ 
		      	    						Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
		      	    				}//fin del success
		      	    			});//fin del ajax request
							}
						}
					}
					Ext.getCmp('monsubtot').setValue('');
	  				Ext.getCmp('monimp').setValue('');
	  				Ext.getCmp('montot').setValue('');
	  				gridCuentas.store.removeAll();
	  				gridCuentasCreditos.store.removeAll();
				}
				
				ventanaBienes.destroy();
			}
		},{
	   		text: 'Salir',
   			handler:function(){
   				ventanaBienes.destroy();
   		    }
   		}]
	});
	
	ventanaBienes.show();
}	


