var gridVentanaCatalogoAnaCot = null;

function CatalogoAnaCot(){
		
	//Creando el campo de analisis de cotizacion
	var reVentana = Ext.data.Record.create([
          {name: 'numanacot'}, 
          {name: 'numsolcot'},
          {name: 'obsana'},
		  {name: 'fecanacot'},
          {name: 'tipsolcot'},
          {name: 'estana'},
          {name: 'recanacot'},
          {name: 'fecapro'}
	]);
	                                        	
	var dsVentana =  new Ext.data.Store({
           reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reVentana)
	});
	                                						
	 var cmVentana = new Ext.grid.ColumnModel([
           {header: "<H1 align='center'>Nro. Anlisis</H1>", width: 50, sortable: true, dataIndex: 'numanacot'},
           {header: "<H1 align='center'>Nro. Solicitud</H1>", width: 50, sortable: true, dataIndex: 'numsolcot'},
           {header: "<H1 align='center'>Observacion</H1>", width: 50, sortable: true, dataIndex: 'obsana'},
           {header: "<H1 align='center'>Fecha</H1>", width: 30, align: 'center', sortable: true, dataIndex: 'fecanacot'},
           {header: "<H1 align='center'>Tipo</H1>", width: 30, align: 'center', sortable: true, dataIndex: 'tipsolcot', renderer: mostrarBieSer},
		   {header: "<H1 align='center'>Estatus</H1>", width: 40, align: 'center', sortable: true, dataIndex: 'estana', renderer: mostrarStatus}
	]);
	
	//fin creando datastore y columnmodel para el catalogo de analisis de cotizacion
	 
	 gridVentanaCatalogoAnaCot = new Ext.grid.GridPanel({
	 		width:550,
	 		height:270,
			frame:true,
			style: 'position:absolute;left:0px;top:130px',
			autoScroll:true,
			enableColumnHide: false,
			enableHdMenu: false,
			border:true,
			ds: dsVentana,
    		cm: cmVentana,
    		stripeRows: true,
    		viewConfig: {forceFit:true}
	});
	 
	 gridVentanaCatalogoAnaCot.on({
		'rowdblclick': {
			fn: function(grid, numFila, evento){
				var registro = grid.getStore().getAt(numFila);
				Aceptar(registro);
				ventanaAnaCot.close();
			}
		}
	});
	 
	//-------------------------------------------------------------------------------------------------------------------------		 

	//Creacion del formulario del catalogo de analsis de cotizacion
	 
	var formVentanaCatalogoAnaCot = new Ext.FormPanel({
		width: 600,
		height: 450,
		style: 'position:absolute;left:5px;top:10px',
		frame: true,
		autoScroll:false,
		items: [{
			xtype:"fieldset", 
			title:'Datos del Anlisis',
			style: 'position:absolute;left:15px;top:10px',
			border:true,
			cls: 'fondo',
			width: 550,
			height: 120,
			items:[ {
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:20px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 150,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Nro. Solicitud Cotizacion',
						id: 'numesolcot',									
						width: 150,
						changeCheck: function(){
							var textvalor = this.getValue();
							dsVentana.filter('numsolcot',textvalor,true);
							if(String(textvalor) !== String(this.startValue)){
								this.fireEvent('change', this, textvalor, this.startValue);
							} 
						}, 
						initEvents: function(){
							AgregarKeyPress(this);
						},
						autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '15', onkeypress: "return keyRestrict(event,'0123456789');"}
					}]
				}]
			},
			{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:50px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 150,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Nro. Anlisis Cotizacion',
						id: 'numeanacot',									
						width: 150,
						changeCheck: function(){
							var textvalor = this.getValue();
							dsVentana.filter('numanacot',textvalor,true);
							if(String(textvalor) !== String(this.startValue)){
								this.fireEvent('change', this, textvalor, this.startValue);
							} 
						}, 
						initEvents: function(){
							AgregarKeyPress(this);
						},
						autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '15', onkeypress: "return keyRestrict(event,'0123456789');"}
					}]
				}]
			},
			{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:340px;top:20px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 80,
					items: [{
						xtype:"datefield",
						labelSeparator :'',
						fieldLabel:"Fecha Inicio",
						value:new Date().format('01/m/Y'),
						id: 'fecsolcotdesde',
						allowBlank:true,
						changeCheck: function(){
							var textvalor = this.getValue();
							dsVentana.filter('fecanacot',textvalor,true);
							if(String(textvalor) !== String(this.startValue)){
								this.fireEvent('change', this, textvalor, this.startValue);
							} 
						}, 
						initEvents: function(){
							AgregarKeyPress(this);
						},
						autoCreate: {tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789/');"}	
					}]
				}]
			},
			{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:340px;top:50px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 80,
					items: [{
						xtype:"datefield",
						fieldLabel:"Fecha Fin",
						labelSeparator :'',
						id: 'fecsolcothasta',
						allowBlank:true,
						value:new Date().format('d/m/Y'),
						changeCheck: function(){
							var textvalor = this.getValue();
							dsVentana.filter('fecanacot',textvalor,true);
							if(String(textvalor) !== String(this.startValue)){
								this.fireEvent('change', this, textvalor, this.startValue);
							} 
						}, 
						initEvents: function(){
							AgregarKeyPress(this);
						},
						autoCreate: {tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789/');"}	
					}]
				}]
			},gridVentanaCatalogoAnaCot,
			{
		   		layout:"column",
		   		defaults: {border: false},
		   		style: 'position:absolute;left:450px;top:85px',
		   		border:false,
		   		items:[{
		   			layout:"form",
		   			border:false,
		   			items:[{
		   				xtype: 'button',
		   				labelSeparator :'',
		   				fieldLabel: '',
		   				id: 'btbuscar',
		   				text: 'Buscar',
		   				width: 300,
		   				height: 300,
		   				iconCls: 'menubuscar',
		   				handler: function(){
		   				
		   				if((Ext.getCmp('fecsolcotdesde').getValue()) > (Ext.getCmp('fecsolcothasta').getValue())){
		   					valido = false;
		   					Ext.MessageBox.show({
			 					title:'Advertencia',
			 					msg:'El rango de fechas no es valido!!!',
			 					buttons: Ext.Msg.OK,
			 					icon: Ext.MessageBox.WARNING
			 				});
		   				}
		   				else{	
		   					obtenerMensaje('procesar','','Buscando Datos');
								
	   					    //Buscar los analisis de cotizacion (creacion del objeto json)
			   				var JSONObject = {
			   					'operacion': 'buscar_anacot',
			   					'numsolcot': Ext.getCmp('numesolcot').getValue(),
			   					'numanacot': Ext.getCmp('numeanacot').getValue(),
			   					'fecdes'   : Ext.getCmp('fecsolcotdesde').getValue().format('y/m/d'),
			   					'fechas'   : Ext.getCmp('fecsolcothasta').getValue().format('y/m/d'),
			   				}
						
			   				var ObjSon = JSON.stringify(JSONObject);
			   				var parametros = 'ObjSon='+ObjSon; 
			   				Ext.Ajax.request({
			   					url : '../../controlador/soc/sigesp_ctr_soc_analisis_cotizacion.php',
			   					params : parametros,
			   					method: 'POST',
			   					success: function ( resultado, request){
			   						Ext.Msg.hide();
			   						var datos = resultado.responseText;
			   						var objetoMovbco = eval('(' + datos + ')');
			   						if(objetoMovbco!=''){
			   							if(objetoMovbco!='0'){
			   								if(objetoMovbco.raiz == null || objetoMovbco.raiz ==''){
			   									Ext.MessageBox.show({
								 					title:'Advertencia',
								 					msg:'No existen datos para mostrar',
								 					buttons: Ext.Msg.OK,
								 					icon: Ext.MessageBox.WARNING
								 				});
											}
											else{
												gridVentanaCatalogoAnaCot.store.loadData(objetoMovbco);
											}
			   							}
			   							else{
			   								Ext.MessageBox.show({
								 				title:'Advertencia',
								 				msg:'',
								 				buttons: Ext.Msg.OK,
								 				icon: Ext.MessageBox.WARNING
								 			});
			   							}
			   						}
			   					}//fin del success	
			   				});//fin del ajax request
		   				}
		   			}
		   			}]
		   		}]
			}]  
		}]   
	});
	
	//fin del formulario 

	//-------------------------------------------------------------------------------------------------------------------------		 

	var ventanaAnaCot = new Ext.Window({
		title: "<H1 align='center'>Cat&#225;logo de An&#225;lisis de Cotizaciones</H1>",
        width:600,
        height:520,
        modal: true,
        closable:false,
        plain: false,
        frame:true,
        items:[formVentanaCatalogoAnaCot],
        buttons: [{
        	text:'Aceptar',
        		handler: function(){
        			var registro = gridVentanaCatalogoAnaCot.getSelectionModel().getSelected();
        			Aceptar(registro);
        			ventanaAnaCot.close();
 		        }
        	},
        	{
        	text: 'Salir',
        		handler:function(){
        			ventanaAnaCot.close();
        		}
 		    }
         ]
	  });
	  ventanaAnaCot.show();
}	

//Funcion que retorna Bien si es B o Servicio si es S para ser mostrado en la gridVentanaCatalogoOrdCom
function mostrarBieSer(valor)
{
	if(valor=='B'){
		return 'Bien';
	}
	else
		return 'Servicio';
}

function Aceptar(registro){
	limpiarFormulario(fromAnalisisCotizacion);
	gridBienes.store.removeAll();
	gridServicios.store.removeAll();
    gridCotizacion.store.removeAll();
	setDataFrom(fromAnalisisCotizacion,registro);
	if(registro.get('estana')=='0'){
		Ext.getCmp('estanacotlabel').setValue('REGISTRADA');
	}
	if(registro.get('estana')=='1'){
		Ext.getCmp('estanacotlabel').setValue('APROBADA');
	}
	if(registro.get('estana')=='2'){
		Ext.getCmp('estanacotlabel').setValue('ANULADA');
	}
	Actualizar=true;
	var reCot = Ext.data.Record.create([
		  {name: 'numsolcot'}, 
          {name: 'numcot'},
          {name: 'cod_pro'},
          {name: 'nompro'},
		  {name: 'feccot'},
          {name: 'poriva'},
          {name: 'monsubtot'},
		  {name: 'monimpcot'},
          {name: 'montotcot'},
          {name: 'obscot'},
          {name: 'forpagcom'},
          {name: 'diaentcom'},
          {name: 'tipcot'}
	]);
	obtenerMensaje('procesar','','Buscando Datos');
	var JSONObject = {
			'operacion' : 'cargar_cotizaciones',
			'numanacot' : registro.get('numanacot')
	}			
	var ObjSon = JSON.stringify(JSONObject);
	var parametros = 'ObjSon='+ObjSon; 
	Ext.Ajax.request({
		url : '../../controlador/soc/sigesp_ctr_soc_analisis_cotizacion.php',
		params : parametros,
		method: 'POST',
		success: function ( resultado, request){
	  		Ext.Msg.hide();
	  		var resultado = resultado.responseText;
	  		var objDatos = eval('(' + resultado + ')');
	  		var datos = objDatos.raiz;
	  		if(objDatos != ""){
	  			for(var j = 0; j < datos.length; j++){
	  				var cotizacionInt = new reCot({
	  					'numsolcot':datos[j].numsolcot,
	  					'numcot'   :datos[j].numcot,
	  					'cod_pro'  :datos[j].cod_pro,
	  					'nompro'   :datos[j].nompro,
	  					'feccot'   :datos[j].feccot,
	  					'poriva'   :datos[j].poriva,
	  					'monsubtot':datos[j].monsubtot,
	  					'monimpcot':datos[j].monimpcot,
	  					'montotcot':datos[j].montotcot,
	  					'obscot'   :datos[j].obscot,
	  					'forpagcom':datos[j].forpagcom,
	  					'diaentcom':datos[j].diaentcom,
	  					'tipcot'   :datos[j].tipcot
	  				});
	  				gridCotizacion.store.insert(0,cotizacionInt);
	  			}
	  		}
		},
		failure: function ( result, request){ 
			Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
		}//fin del success
	});//fin del ajax request
	var reBieSer = Ext.data.Record.create([
			  {name: 'codigo'}, 
	          {name: 'denominacion'},
	          {name: 'cod_pro'},
	          {name: 'nompro'},
			  {name: 'cantidad'},
			  {name: 'precio'},
	          {name: 'moniva'},
	          {name: 'monto'},
			  {name: 'obsanacot'},
	          {name: 'numcot'},
	          {name: 'numsolcot'},
	          {name: 'unidad'},
	          {name: 'denunimed'}
		]); 
	obtenerMensaje('procesar','','Buscando Datos');
	var JSONObject = {
			'operacion' : 'cargar_bieser',
			'numanacot' : registro.get('numanacot'),
			'tipsolcot' : registro.get('tipsolcot')
	}			
	var ObjSon = JSON.stringify(JSONObject);
	var parametros = 'ObjSon='+ObjSon; 
	Ext.Ajax.request({
		url : '../../controlador/soc/sigesp_ctr_soc_analisis_cotizacion.php',
		params : parametros,
		method: 'POST',
		success: function ( resultado, request){
	  		Ext.Msg.hide();
	  		var resultado = resultado.responseText;
	  		var objDatos = eval('(' + resultado + ')');
	  		var datos = objDatos.raiz;
	  		if(objDatos != ""){
	  			if(registro.get('tipsolcot')=='B'){
	  				if(typeof(gridBienes) == 'object' && gridBienes != null){
						fromAnalisisCotizacion.add(gridBienes);
						gridBienes.show();
						fromAnalisisCotizacion.doLayout();
					}
	  				for(var j = 0; j < datos.length; j++){
	  					if(datos[j].obsanacot!=undefined){
	  						var obser = datos[j].obsanacot; 
	  					}
	  					else{
	  						var obser = '';
	  					}
	  					var bienesInt = new reBieSer({
		  					'codigo'      :datos[j].codigo,
		  					'denominacion':datos[j].denominacion,
		  					'cod_pro'     :datos[j].cod_pro,
		  					'nompro'      :datos[j].nompro,
		  					'cantidad'    :datos[j].cantidad,
		  					'precio'      :datos[j].precio,
		  					'moniva'      :datos[j].moniva,
		  					'montotal'    :datos[j].monto,
		  					'observacion' :datos[j].obsanacot,
		  					'tipo'        :obser,
		  					'numcot'      :datos[j].numcot,
		  					'numsolcot'   :datos[j].numsolcot,
		  					'modalidad'   :datos[j].unidad,
		  					'denunimed'   :datos[j].denunimed
		  				});
		  				gridBienes.store.insert(0,bienesInt);
	  				}
	  			}
	  			else{
	  				if(typeof(gridServicios) == 'object' && gridServicios != null){
						fromAnalisisCotizacion.add(gridServicios);
						gridServicios.show();
						fromAnalisisCotizacion.doLayout();
					}
	  				for(var j = 0; j < datos.length; j++){
	  					if(datos[j].obsanacot!=undefined){
	  						var obser = datos[j].obsanacot; 
	  					}
	  					else{
	  						var obser = '';
	  					}
	  					var servicioInt = new reBieSer({
		  					'codigo'      :datos[j].codigo,
		  					'denominacion':datos[j].denominacion,
		  					'cod_pro'     :datos[j].cod_pro,
		  					'nompro'      :datos[j].nompro,
		  					'cantidad'    :datos[j].cantidad,
		  					'precio'      :datos[j].precio,
		  					'moniva'      :datos[j].moniva,
		  					'montotal'    :datos[j].monto,
		  					'observacion' :obser,
		  					'tipo'        :registro.get('tipsolcot'),
		  					'numcot'      :datos[j].numcot,
		  					'numsolcot'   :datos[j].numsolcot
		  				});
		  				gridServicios.store.insert(0,servicioInt);
	  				}
	  			}
	  		}
		},
		failure: function ( result, request){ 
			Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
		}//fin del success
	});//fin del ajax request
}

function mostrarStatus(valor){
	if(valor=='0'){
		return 'REGISTRO';
	}
	else
		return 'PROCESADO';
}

