var fromProgramacionCompra = null;  //instancia del formulario principal 
var gridArticulos          = null;  //instancia de grid de reintegros
var reProgArticulo         = null;
rutaProgCompra = '../../controlador/sfp/sigesp_ctr_sfp_programacioncompras.php'; 
salirAlterno   = 'sigesp_vis_sfp_index_formulacion.php';
setSistemaVentana('SFP', 'sigesp_spe_reportespoa.php');

Ext.onReady(function(){
	Ext.BLANK_IMAGE_URL = '../../base/librerias/js/ext/resources/images/default/s.gif';
		
	//creando datastore y columnmodel para la grid de articulos programados
	reProgArticulo = Ext.data.Record.create([
			{name: 'codart'}, 
			{name: 'denart'},
			{name: 'spg_cuenta'},
			{name: 'codunimed'},
			{name: 'denunimed'},
			{name: 'ultcosart'},
			{name: 'porcar'},
			{name: 'tipodist'},
			{name: 'cantotal'},
			{name: 'totalgeneral'},
			{name: 'codmoneda'},
			{name: 'denmoneda'},
			{name: 'codtipoprogramacion'},
			{name: 'codfuefin'},
			{name: 'codtipodestino'},
			{name: 'destino'},
			{name: 'enero'},
			{name: 'febrero'},
			{name: 'marzo'},
			{name: 'abril'},
			{name: 'mayo'},
			{name: 'junio'},
			{name: 'julio'},
			{name: 'agosto'},
			{name: 'septiembre'},
			{name: 'octubre'},
			{name: 'noviembre'},
			{name: 'diciembre'},
			{name: 'codigo_unspsc'}
	]);
	
	dsProgArticulo =  new Ext.data.Store({
		reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reProgArticulo)
	});
						
	var cmProgArticulo = new Ext.grid.ColumnModel([
          				{header: "C&#243;digo", width: 20, sortable: true, dataIndex: 'codart'},
          				{header: "Denominaci&#243;n", width: 60, sortable: true, dataIndex: 'denart'},
          				{header: "Total", width: 30, sortable: true, dataIndex: 'totalgeneral'}
	]);
	//creando datastore y columnmodel para la grid de articulos programados
	
	//funcion que llama al catalogo de articulos...
	function getCatArticulo() {
		if(Ext.getCmp('codinte').getValue()!=''){
			catalogoArticulo();
		}
		else{
			Ext.MessageBox.alert('Advertencia', 'Debe seleccionar la estructura a programar');
		}
		
	}
	
	//Boton para insertar articulo a programar
	var addArticulo = new Ext.Action({
		text: 'Agregar',
		handler: getCatArticulo,
		iconCls: 'bmenuagregar',
        tooltip: 'Agregar cuenta'
	});
	
	//funcion para eliminar un arti
	function eliminarArticulo(){
		function ejecutarEliminar(btn){
			if(btn=='yes'){
				var registro = gridArticulos.getSelectionModel().getSelected();
				if(registro.get('totalgeneral')=='' || registro.get('totalgeneral')==undefined){
					gridArticulos.getStore().remove(registro);
				}
				else{
					var JSONObject = {
			 			'oper'    : 'elminarProgramacion',
			 			'codinte' : Ext.getCmp('codinte').getValue(),
			 			'codart' : registro.get('codart'),
				        'sig_cuenta': registro.get('spg_cuenta')
			 		}
		 			var ObjSon = JSON.stringify(JSONObject);
		 			var parametros = 'ObjSon='+ObjSon; 
		 			Ext.Ajax.request({
		 				url : rutaProgCompra,
		 				params : parametros,
		 				method: 'POST',
		 				success: function ( resultado, request){
		 					var respuesta = resultado.responseText;
		 					if(respuesta=='1'){
		 						Ext.MessageBox.alert('Mensaje', 'El registro fue eliminado exitosamente');
		 						gridArticulos.getStore().remove(registro);
		 					}
		 					else{
		 						Ext.MessageBox.alert('Mensaje', 'Oucrri&#243; un error al eliminar el registro');
		 					}
		 				}	
		 			});
				}
			}
		}	
		Ext.MessageBox.confirm('Confirmar', '&#191;Desea eliminar este registro&#63;', ejecutarEliminar);
	}
	
	//Boton para eliminar un articulo programado
	var delArticulo = new Ext.Action({
		text: 'Quitar',
		handler: eliminarArticulo,
		iconCls: 'bmenuquitar',
        tooltip: 'Eliminar registro'
	});
	//crendo botones de inserta y eliminar articulos			
				
	//creando grid para los articulos programados
	gridArticulos = new Ext.grid.GridPanel({
	 		width:800,
	 		height:250,
			frame:true,
			title:'Bienes/Servicios Programados',
			style: 'position:absolute;left:20px;top:100px',
			tbar:[addArticulo,delArticulo],
	 		autoScroll:true,
     		border:true,
     		ds: dsProgArticulo,
       		cm: cmProgArticulo,
       		stripeRows: true,
      		viewConfig: {forceFit:true}
	});
	//fin creando grid para los articulos programados
	
	gridArticulos.on({
		'celldblclick': {
			fn: function(grid) {
				var registro = grid.getSelectionModel().getSelected();
				if(registro.get('codigo_unspsc')!=''){
					getVentanaProgramacion();
				}
				else{
					Ext.MessageBox.alert('Advertencia', 'El item debe tener configurado el C&#243;digo UNSPSC');
					grid.getStore().remove(registro);
				}
			}
		}
    });
	
	//creando funcion que construye formulario principal
	function getFromProgramacion(){
		Ext.QuickTips.init();
		var Xpos = ((screen.width/2)-(920/2));
		fromProgramacionCompra = new Ext.FormPanel({
			applyTo: 'formulario',
			width: 920,
			height: 500,
			title: 'Programaci&#243;n de Compras',
			frame: true,
			autoScroll:true,
			style:'position:absolute;margin-left:'+Xpos+'px;margin-top:25px;',
			bbar: [{
        	 	text:'Generar XML SNC',
        	 	iconCls : 'bmenudescargar',
        	 	tooltip : 'Genera el xml para el SNC con la programaci&#243;n de compras cargada',
        	 	handler: function(){
        	 		var JSONObject = {
        	 				'oper'   : 'generarXML'
        	 		}
    	 			var ObjSon = JSON.stringify(JSONObject);
    	 			var parametros = 'ObjSon='+ObjSon; 
    	 			Ext.Ajax.request({
    	 				url : rutaProgCompra,
    	 				params : parametros,
    	 				method: 'POST',
    	 				success: function ( resultado, request){
    	 					var respuesta = resultado.responseText;
    	 					if(respuesta=='1'){
    	 						Ext.MessageBox.alert('Mensaje', 'El archivo xml fue generado exitosamente');
    	 					}
    	 					else{
    	 						Ext.MessageBox.alert('Mensaje', 'Oucrri&#243; un error al generar el archivo xml');
    	 					}
    	 				}	
    	 			});
        	 		                      
        	 	}
    		  },{
    			text: 'Generar Formulaci&#243;n de Gastos',
    			iconCls : 'menuprocesar',
    			tooltip : 'Genera la formulaci&#243;n de gasto con la programaci&#243;n de compras cargada',
    			handler: function(){
    				var JSONObject = {
        	 				'oper'   : 'generarFormulacion'
        	 		}
    	 			var ObjSon = JSON.stringify(JSONObject);
    	 			var parametros = 'ObjSon='+ObjSon; 
    	 			Ext.Ajax.request({
    	 				url : rutaProgCompra,
    	 				params : parametros,
    	 				method: 'POST',
    	 				success: function ( resultado, request){
    	 					var respuesta = resultado.responseText;
    	 					if(respuesta=='1'){
    	 						Ext.MessageBox.alert('Mensaje', 'La formulaci&#243;n de gastos fue generada exitosamente');
    	 					}
    	 					else{
    	 						Ext.MessageBox.alert('Mensaje', 'Oucrri&#243; un error al generar la formulaci&#243;n de gastos');
    	 					}
    	 				}	
    	 			});
    			}
    		  }],
			items: [{
						layout: "column",
						defaults: {border: false},
						style: 'position:absolute;left:15px;top:10px',
						items: [{
									layout: "form",
									border: false,
									labelWidth: 100,
									columnWidth: 0.5,
									items: [{
												xtype: 'textfield',
												fieldLabel: 'C&#243;digo',
												labelSeparator :'',
												id: 'codest',
												autoCreate: {tag: 'input',type: 'text',size: '15',autocomplete: 'off',maxlength: '15'},
												width: 130,
												readOnly:true
									}]
							}]
					},{
						layout: "column",
						defaults: {border: false},
						style: 'position:absolute;left:280px;top:10px',
						items: [{
							layout: "form",
							border: false,
							labelWidth: 0,
							columnWidth: 0.5,
							items: [{
									xtype:'button',
									id:'botcatesturctura',
									text: '...',
									handler:function(){
										mostrarCatalagoEstructuraIntegrada()
									}
							}]
						}]
					},{
						layout: "column",
						defaults: {border: false},
						style: 'position:absolute;left:15px;top:40px',
						items: [{
									layout: "form",
									border: false,
									labelWidth: 100,
									columnWidth: 0.5,
									items: [{
												xtype: 'textfield',
												fieldLabel: 'Denominaci&#243;n',
												labelSeparator :'',
												name: 'denominacion',
												id: 'denest',
												width: 400,
												readOnly:true
											}]
								}]
					},gridArticulos
					,{
						xtype: 'hidden',
						id: 'codinte'
					}]
		});
	}
	//fin creando funcion que construye formulario principal
	
	//creando funcion que construye ventana para registrar programacion de un articulo
	function getVentanaProgramacion(){
		//informacion del articulo a programar
		var articulo = gridArticulos.getSelectionModel().getSelected();
		
		//grid de meses y montos...
		var Meses = [ [ 'm', 'Enero', 0 , 0, 0 ], 
		              [ 'l', 'Febrero', 0, 0, 0 ],
		              [ 'k', 'Marzo', 0, 0, 0 ], 
		              [ 'j', 'Abril', 0, 0, 0 ],
		              [ 'i', 'Mayo', 0, 0, 0 ], 
		              [ 'h', 'Junio', 0, 0, 0 ],
		              [ 'g', 'Julio', 0, 0, 0 ], 
		              [ 'f', 'Agosto', 0, 0, 0 ],
		              [ 'e', 'Septiembre', 0, 0, 0 ], 
		              [ 'd', 'Octubre', 0, 0, 0 ],
		              [ 'c', 'Noviembre', 0, 0, 0 ], 
		              [ 'b', 'Diciembre', 0, 0, 0 ] ];
		
		var stMeses = new Ext.data.SimpleStore({
			fields : [ {name : 'numes'}, 
			           {name : 'mes'},
			           {name : 'cantidad'},
			           {name : 'montoipc'},
			           {name : 'total'} ]
		});

		stMeses.loadData(Meses);
		stMeses.sort('numes', 'DESC');
		var gridProgramacionMensual = new Ext.grid.EditorGridPanel({
			width : 400,
			style: 'position:absolute;left:50px;top:230px',
			title : 'Programaci&#243;n Mensual',
			autoScroll : true,
			border : true,
			ds : stMeses,
			cm : new Ext.grid.ColumnModel(
					[{header : "Mes",width : 70,sortable : false,dataIndex : 'mes'}, 
					 {header : "Cantidad",width : 50,dataIndex : 'cantidad',editor : new Ext.form.TextField({allowBlank : false})},
					 {header : "IPC",width : 70,dataIndex : 'montoipc'},
					 {header : "Total",width : 90,dataIndex : 'total'}
			]),
			viewConfig : {forceFit : true},
			autoHeight : true,
			stripeRows : true
		});
		
		//validar cantidad
		function validarCantidad(cantTotal) {
			var cantGrid = 0;
			gridProgramacionMensual.store.each(function (registroGrid){
				cantGrid = cantGrid + parseFloat(ue_formato_operaciones(registroGrid.get('cantidad')));
			});
			
			if(cantGrid>cantTotal){
				Ext.MessageBox.alert('Advertencia', 'La cantidad programada no puede ser mayor a la cantidad total');
				return false;
			}
			else{
				return true;
			}
		}
		
		
		//Evento despues de editar para calcular el total
		gridProgramacionMensual.on('afteredit', function(Objeto) {
			var registroMes = Objeto.record;
			var cantidad    = Objeto.value;
			var cantTotal   = ue_formato_operaciones(Ext.getCmp('cantotal').getValue());
			if(validarCantidad(cantTotal)){
				var precio      = ue_formato_operaciones(Ext.getCmp('ultcosart').getValue());
				var ipc         = ue_formato_operaciones(registroMes.get('montoipc'));
				
				var subtotal = cantidad * precio;
				var montoipc = subtotal * ipc;
				var total    = subtotal + montoipc;
				registroMes.set('total',formatoNumericoMostrar(total,2,'.',',','','','-',''));
				
			}
			else{
				registroMes.set('cantidad',0);
			}
			gridProgramacionMensual.store.commitChanges();
		});
		
		//cargar montos ipc en grid...
		var myJSONObject = {
				"oper" : 'obtenerIPC',
				"spg_cuenta" : articulo.get('spg_cuenta')
		};

		var ObjSon = JSON.stringify(myJSONObject);
		var parametros = 'ObjSon=' + ObjSon;
		Ext.Ajax.request({
			url : rutaProgCompra,
			params : parametros,
			method : 'POST',
			success : function(resultado, request) {
				var datos = resultado.responseText;
				if (datos != '') {
					var DatosNuevo2 = eval('(' + datos + ')');
					if (DatosNuevo2.raiz != null && DatosNuevo2.raiz!="") {
						var arrObj = gridProgramacionMensual.store.getRange(0, 11)
						arrObj[0].set('montoipc',DatosNuevo2.raiz[0].enero);
						arrObj[1].set('montoipc',DatosNuevo2.raiz[0].febrero);
						arrObj[2].set('montoipc',DatosNuevo2.raiz[0].marzo);
						arrObj[3].set('montoipc',DatosNuevo2.raiz[0].abril);
						arrObj[4].set('montoipc',DatosNuevo2.raiz[0].mayo);
						arrObj[5].set('montoipc',DatosNuevo2.raiz[0].junio);
						arrObj[6].set('montoipc',DatosNuevo2.raiz[0].julio);
						arrObj[7].set('montoipc',DatosNuevo2.raiz[0].agosto);
						arrObj[8].set('montoipc',DatosNuevo2.raiz[0].septiembre);
						arrObj[9].set('montoipc',DatosNuevo2.raiz[0].octubre);
						arrObj[10].set('montoipc',DatosNuevo2.raiz[0].noviembre);
						arrObj[11].set('montoipc',DatosNuevo2.raiz[0].diciembre);
						gridProgramacionMensual.store.commitChanges();
					}
				}
			}
		});
		
		//data del combo tipo distribucion
		var tipo = [ [ 'Automatica', '1' ], 
		             [ 'Manual', '0' ] ];
		
		var stDistribucion = new Ext.data.SimpleStore({
			fields : [ 'col', 'tipo' ],
			data : tipo
		});
		
		//creando datastore y columnmodel para el catalogo de articulos
		var reunidamedida = Ext.data.Record.create([
							{name: 'codunimed'},
							{name: 'denunimed'}
					]);
		
		var dsunidadmedida =  new Ext.data.Store({
						reader: new Ext.data.JsonReader({
								root: 'raiz',             
								id: "id"   
								},reunidamedida)
		  			});
							
		var cmunidadmedida = new Ext.grid.ColumnModel([
	          				{header: "C&#243;digo", width: 20, sortable: true,   dataIndex: 'codunimed'},
	          				{header: "Denominaci&#243;n", width: 40, sortable: true, dataIndex: 'denunimed'}
					]);
		//fin creando datastore y columnmodel para el catalogo de articulos
		
		//componente campocatalogo para el campo articulos
		var cmpcampocatunidad = new com.sigesp.vista.comCampoCatalogo({
								titvencat: 'Cat&#225;logo de Unidades de Medidas del SNC',
								anchoformbus: 450,
								altoformbus:130,
								anchogrid: 450,
								altogrid: 400,
								anchoven: 500,
								altoven: 500,
								datosgridcat: dsunidadmedida,
								colmodelocat: cmunidadmedida,
								rutacontrolador: rutaProgCompra,
								parametros: "ObjSon={'oper': 'catalogoUnidad'",
								arrfiltro:[{etiqueta:'C&#243;digo',id:'codunidad',valor:'codunimed'},
										   {etiqueta:'Descripci&#243;n',id:'denunidad',valor:'denunimed'}],
								posicion:'position:absolute;left:5px;top:90px',
								tittxt:'Unidad de medida',
								idtxt:'codunimed',
								anchofieldset: 710,
								campovalue:'codunimed',
								anchoetiquetatext:100,
								anchotext:40,
								anchocoltext:0.40,
								idlabel:'denunimed',
								labelvalue:'denunimed',
								anchocoletiqueta:0.55,
								anchoetiqueta:150,
								tipbus:'P',
								binding:'C',
								hiddenvalue:'',
								defaultvalue:'',
								allowblank:false
		});
		//fin componente campocatalogo para el campo articulos
		
		//formulario de programacion del articulo...
		var fromProgramacionArticulo = new Ext.FormPanel({
			width:760,
	        height:650,
			title: 'Bien/Servicio',
			frame: true,
			autoScroll:true,
			items: [{//
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:10px',
				items: [{
							layout: "form",
							border: false,
							labelWidth: 100,
							items: [{
										xtype: 'textfield',
										fieldLabel: 'C&#243;digo',
										labelSeparator :'',
										id: 'codart',
										autoCreate: {tag: 'input',type: 'text',size: '15',autocomplete: 'off',maxlength: '15'},
										width: 170,
										readOnly:true,
										value: articulo.get('codart')
							}]
					}]
			},{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:40px',
				items: [{
							layout: "form",
							border: false,
							labelWidth: 100,
							items: [{
										xtype: 'textfield',
										fieldLabel: 'Denominaci&#243;n',
										labelSeparator :'',
										id: 'denart',
										width: 450,
										readOnly:true,
										value: articulo.get('denart')
									}]
						}]
			},{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:70px',
				items: [{
							layout: "form",
							border: false,
							labelWidth: 100,
							items: [{
										xtype: 'textfield',
										fieldLabel: 'Cuenta',
										labelSeparator :'',
										id: 'spg_cuenta',
										width: 170,
										readOnly:true,
										value: articulo.get('spg_cuenta')
									}]
						}]
			},
			cmpcampocatunidad.fieldsetCatalogo
			,{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:130px',
				items: [{
							layout: "form",
							border: false,
							labelWidth: 100,
							items: [{
										xtype: 'textfield',
										fieldLabel: 'Precio',
										labelSeparator :'',
										id: 'ultcosart',
										width: 90,
										value: articulo.get('ultcosart'),
										listeners: {
		                                	'blur': function(){
		                                    			var formatonumero = formatoNumericoMostrar(this.getValue(),2,'.',',','','','-','');
														this.setValue(formatonumero);
											}
										}
									}]
						}]
			},{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:160px',
				items: [{
							layout: "form",
							border: false,
							labelWidth: 100,
							items: [{
										xtype: 'textfield',
										fieldLabel: 'Cantidad Total',
										labelSeparator :'',
										id: 'cantotal',
										width: 50,
										value : 0
									}]
						}]
			},{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:190px',
				items: [{
							layout: "form",
							border: false,
							labelWidth: 100,
							items: [{
										xtype: 'combo',
										fieldLabel: 'Distribuci&#243;n',
										labelSeparator :'',
										id: 'tipodist',
										store : stDistribucion,
										editable : false,
										displayField : 'col',
										valueField : 'tipo',
										typeAhead : true,
										triggerAction : 'all',
										mode : 'local',
										listeners: {
                							'select': function(){
                								if(this.getValue()=='1'){
                    								var cantidad = parseFloat(Ext.getCmp('cantotal').getValue());
                    								if(cantidad != 0){
                    									var cantidadMes = Math.round(cantidad/12);
                    									var cantidadDic = cantidad - (Math.round(cantidadMes)*11);
                    									var precio      = ue_formato_operaciones(Ext.getCmp('ultcosart').getValue());
                    									var subtotMes   = cantidadMes * precio;
                    									var subtotDic   = cantidadDic * precio;
                    									
                    									var arrObj   = gridProgramacionMensual.store.getRange(0, 11)
                    									var totalEnero = subtotMes + (subtotMes*ue_formato_operaciones(arrObj[0].get('montoipc')));
                    									arrObj[0].set('cantidad',formatoNumericoMostrar(cantidadMes,2,'.',',','','','-',''));
                    									arrObj[0].set('total',formatoNumericoMostrar(totalEnero,2,'.',',','','','-',''));
                    									var totalFebrero = subtotMes + (subtotMes*ue_formato_operaciones(arrObj[1].get('montoipc')));
                    									arrObj[1].set('cantidad',formatoNumericoMostrar(cantidadMes,2,'.',',','','','-',''));
                    									arrObj[1].set('total',formatoNumericoMostrar(totalFebrero,2,'.',',','','','-',''));
                    									var totalMarzo = subtotMes + (subtotMes*ue_formato_operaciones(arrObj[2].get('montoipc')));
                    									arrObj[2].set('cantidad',formatoNumericoMostrar(cantidadMes,2,'.',',','','','-',''));
                    									arrObj[2].set('total',formatoNumericoMostrar(totalMarzo,2,'.',',','','','-',''));
                    									var totalAbril = subtotMes + (subtotMes*ue_formato_operaciones(arrObj[3].get('montoipc')));
                    									arrObj[3].set('cantidad',formatoNumericoMostrar(cantidadMes,2,'.',',','','','-',''));
                    									arrObj[3].set('total',formatoNumericoMostrar(totalAbril,2,'.',',','','','-',''));
                    									var totalMayo = subtotMes + (subtotMes*ue_formato_operaciones(arrObj[4].get('montoipc')));
                    									arrObj[4].set('cantidad',formatoNumericoMostrar(cantidadMes,2,'.',',','','','-',''));
                    									arrObj[4].set('total',formatoNumericoMostrar(totalMayo,2,'.',',','','','-',''));
                    									var totalJunio = subtotMes + (subtotMes*ue_formato_operaciones(arrObj[5].get('montoipc')));
                    									arrObj[5].set('cantidad',formatoNumericoMostrar(cantidadMes,2,'.',',','','','-',''));
                    									arrObj[5].set('total',formatoNumericoMostrar(totalJunio,2,'.',',','','','-',''));
                    									var totalJulio = subtotMes + (subtotMes*ue_formato_operaciones(arrObj[6].get('montoipc')));
                    									arrObj[6].set('cantidad',formatoNumericoMostrar(cantidadMes,2,'.',',','','','-',''));
                    									arrObj[6].set('total',formatoNumericoMostrar(totalJulio,2,'.',',','','','-',''));
                    									var totalAgosto = subtotMes + (subtotMes*ue_formato_operaciones(arrObj[7].get('montoipc')));
                    									arrObj[7].set('cantidad',formatoNumericoMostrar(cantidadMes,2,'.',',','','','-',''));
                    									arrObj[7].set('total',formatoNumericoMostrar(totalAgosto,2,'.',',','','','-',''));
                    									var totalSeptiembre = subtotMes + (subtotMes*ue_formato_operaciones(arrObj[8].get('montoipc')));
                    									arrObj[8].set('cantidad',formatoNumericoMostrar(cantidadMes,2,'.',',','','','-',''));
                    									arrObj[8].set('total',formatoNumericoMostrar(totalSeptiembre,2,'.',',','','','-',''));
                    									var totalOctubre = subtotMes + (subtotMes*ue_formato_operaciones(arrObj[9].get('montoipc')));
                    									arrObj[9].set('cantidad',formatoNumericoMostrar(cantidadMes,2,'.',',','','','-',''));
                    									arrObj[9].set('total',formatoNumericoMostrar(totalOctubre,2,'.',',','','','-',''));
                    									var totalNoviembre = subtotMes + (subtotMes*ue_formato_operaciones(arrObj[10].get('montoipc')));
                    									arrObj[10].set('cantidad',formatoNumericoMostrar(cantidadMes,2,'.',',','','','-',''));
                    									arrObj[10].set('total',formatoNumericoMostrar(totalNoviembre,2,'.',',','','','-',''));
                    									var totalDiciembre = subtotDic + (subtotDic*ue_formato_operaciones(arrObj[11].get('montoipc')));
                    									arrObj[11].set('cantidad',formatoNumericoMostrar(cantidadDic,2,'.',',','','','-',''));
                    									arrObj[11].set('total',formatoNumericoMostrar(totalDiciembre,2,'.',',','','','-',''));
                    									gridProgramacionMensual.store.commitChanges();
                    									var porcar       = ue_formato_operaciones(Ext.getCmp('porcar').getValue());
                    									var subtotal     = totalEnero + totalFebrero + totalMarzo + totalAbril + totalMayo +  
                    													   totalJunio + totalJulio + totalAgosto + totalSeptiembre + totalOctubre +
                    													   totalNoviembre + totalDiciembre;
                    									var ivatotal = subtotal * (porcar/100);
                    									totalgeneral = subtotal + ivatotal;
                    									Ext.getCmp('subtotart').setValue(formatoNumericoMostrar(subtotal,2,'.',',','','','-',''));
                    									Ext.getCmp('totalart').setValue(formatoNumericoMostrar(totalgeneral,2,'.',',','','','-',''));
                    								}
                    								else{
                    									Ext.MessageBox.alert('Advertencia', 'Debe indicar la cantidad total');
                    								}
                								}
                								else{
                									var arrObj   = gridProgramacionMensual.store.getRange(0, 11)
                									arrObj[0].set('cantidad',0);
                									arrObj[0].set('total',0);
                									arrObj[1].set('cantidad',0);
                									arrObj[1].set('total',0);
                									arrObj[2].set('cantidad',0);
                									arrObj[2].set('total',0);
                									arrObj[3].set('cantidad',0);
                									arrObj[3].set('total',0);
                									arrObj[4].set('cantidad',0);
                									arrObj[4].set('total',0);
                									arrObj[5].set('cantidad',0);
                									arrObj[5].set('total',0);
                									arrObj[6].set('cantidad',0);
                									arrObj[6].set('total',0);
                									arrObj[7].set('cantidad',0);
                									arrObj[7].set('total',0);
                									arrObj[8].set('cantidad',0);
                									arrObj[8].set('total',0);
                									arrObj[9].set('cantidad',0);
                									arrObj[9].set('total',0);
                									arrObj[10].set('cantidad',0);
                									arrObj[10].set('total',0);
                									arrObj[11].set('cantidad',0);
                									arrObj[11].set('total',0);
                									gridProgramacionMensual.store.commitChanges();
                									Ext.getCmp('subtotart').setValue(0);
                									Ext.getCmp('totalart').setValue(0);
                								}
                							}
										}
									}]
						}]
			},
			gridProgramacionMensual
			,{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:550px',
				items: [{
							layout: "form",
							border: false,
							labelWidth: 100,
							items: [{
										xtype: 'textfield',
										fieldLabel: 'Subtotal',
										labelSeparator :'',
										id: 'subtotart',
										width: 150,
										readOnly:true
									}]
						}]
			},{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:580px',
				items: [{
							layout: "form",
							border: false,
							labelWidth: 100,
							items: [{
										xtype: 'textfield',
										fieldLabel: 'IVA',
										labelSeparator :'',
										id: 'porcar',
										width: 50,
										readOnly:true,
										value: articulo.get('porcar')
									}]
						}]
			},{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:610px',
				items: [{
							layout: "form",
							border: false,
							labelWidth: 100,
							items: [{
										xtype: 'textfield',
										fieldLabel: 'Total General',
										labelSeparator :'',
										id: 'totalart',
										width: 150,
										readOnly:true
									}]
						}]
			},{
				xtype: 'hidden',
				id: 'codigo_unspsc',
				value: articulo.get('codigo_unspsc')
			}]
		});
		
		//data del combo tipo programacion
		var tipoprogramacion = [ [ 'PROGRAMACION ORDINARIA', '1' ], 
		                         [ 'ENCUENTRO DE OFERTA Y DEMANDA', '2' ],
					 			 [ 'PLAN EXCEPCIONAL', '3' ]];
		
		var stTipoProgramacion = new Ext.data.SimpleStore({
			fields : [ 'etiqueta', 'valor' ],
			data : tipoprogramacion
		});
		
		//data del combo fuente financiamiento
		var fuentefinanciamiento = [ [ 'RECURSOS ORDINARIOS (ley de presupuesto)', '1' ], 
		                             [ 'FIDES', '2' ],
					 				 [ 'LAEE', '3' ],
					 				 [ 'MULTILATERAL', '4' ],
					 				 [ 'BILATERAL', '5' ],
					 				 [ 'RECURSOS PROPIOS', '6' ],
					 				 [ 'MIXTOS', '7' ],
					 				 [ 'OTROS ENTES DEL ESTADO', '8' ],
					 				 [ 'CREDITO ADICIONAL', '9' ],
					 				 [ 'LEY DE PRESUPUESTO', '10' ],
									 [ 'SITUADO CONSTITUCIONAL', '11' ],
									 [ 'TRANSFERENCIA', '12' ],
									 [ 'FONDO DE COMPENSACION INTERTERRITORIAL (FCI)', '13' ],
									 [ 'DONACIONES', '14' ]];
		
		var stFuenteFinanciamiento = new Ext.data.SimpleStore({
			fields : [ 'etiqueta', 'valor' ],
			data : fuentefinanciamiento
		});
		
		//data del combo tipo destino
		var destino = [ [ 'ESTADO', 'E' ], 
		                [ 'MUNICIPIO', 'M' ],
		                [ 'PARROQUIA', 'P' ],
					 	[ 'TODA VENEZUELA', 'T' ]];
		
		var stDestino = new Ext.data.SimpleStore({
			fields : [ 'etiqueta', 'valor' ],
			data : destino
		});
		
		//creando datastore y columnmodel para el catalogo de articulos
		var remoneda = Ext.data.Record.create([
							{name: 'codmon'},
							{name: 'denmon'}
					]);
		
		var dsmoneda =  new Ext.data.Store({
						reader: new Ext.data.JsonReader({
								root: 'raiz',             
								id: "id"   
								},remoneda)
		  			});
							
		var cmmoneda = new Ext.grid.ColumnModel([
	          				{header: "C&#243;digo", width: 20, sortable: true,   dataIndex: 'codmon'},
	          				{header: "Denominaci&#243;n", width: 40, sortable: true, dataIndex: 'denmon'}
					]);
		//fin creando datastore y columnmodel para el catalogo de articulos
		
		//componente campocatalogo para el campo articulos
		var cmpcampocatmoneda = new com.sigesp.vista.comCampoCatalogo({
								titvencat: 'Cat&#225;logo de Monedas',
								anchoformbus: 450,
								altoformbus:130,
								anchogrid: 450,
								altogrid: 400,
								anchoven: 500,
								altoven: 500,
								datosgridcat: dsmoneda,
								colmodelocat: cmmoneda,
								rutacontrolador: rutaProgCompra,
								parametros: "ObjSon={'oper': 'catalogoMoneda'",
								arrfiltro:[{etiqueta:'C&#243;digo',id:'codmoneda',valor:'codmon'},
										   {etiqueta:'Descripci&#243;n',id:'denmoneda',valor:'denmon'}],
								posicion:'position:absolute;left:0px;top:5px',
								tittxt:'Moneda',
								idtxt:'codmon',
								anchofieldset: 710,
								campovalue:'codmon',
								anchoetiquetatext:150,
								anchotext:40,
								anchocoltext:0.40,
								idlabel:'denmon',
								labelvalue:'denmon',
								anchocoletiqueta:0.55,
								anchoetiqueta:150,
								tipbus:'P',
								binding:'C',
								hiddenvalue:'',
								defaultvalue:'',
								allowblank:false
		});
		//fin componente campocatalogo para el campo articulos
		
		//creando datastore y columnmodel para la grid de destinos
		reDestino = Ext.data.Record.create([
			{name: 'coddestino'}, 
			{name: 'dendestino'}
		]);
		
		var dsDestino =  new Ext.data.Store({
			reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reDestino)
		});
							
		var cmDestino = new Ext.grid.ColumnModel([
		    {header: "C&#243;digo", width: 50, sortable: true, dataIndex: 'coddestino'},
		    {header: "Denominaci&#243;n", width: 250, sortable: true, dataIndex: 'dendestino'}
		]);
		//creando datastore y columnmodel para la grid de destinos
		
		//funcion para llamar al catalogo de destinos
		function agregarDestino() {
			var tipoDestino = Ext.getCmp('tipodestino').getValue();
			if(tipoDestino != ''){
				catalogoDestinos(tipoDestino);
			}
			else{
				Ext.MessageBox.alert('Advertencia','Debe seleccionar el tipo de destino');
			}
		}
		
		//crendo botones de inserta y eliminar articulos
		var addDestino = new Ext.Action({
			text: 'Agregar',
			handler: agregarDestino,
			iconCls: 'bmenuagregar',
	        tooltip: 'Agregar destino'
		});
		
		var delDestino = new Ext.Action({
			text: 'Quitar',
			//handler: irQuitarEjeFin,
			iconCls: 'bmenuquitar',
	        tooltip: 'Eliminar destino'
		});
		//crendo botones de inserta y eliminar articulos			
					
		//creando grid para los articulos programados
		gridCodDestino = new Ext.grid.GridPanel({
		 		width:300,
		 		height:150,
				frame:true,
				title:'Destinos',
				style: 'position:absolute;left:20px;top:200px',
				tbar:[addDestino,delDestino],
		 		autoScroll:true,
	     		border:true,
	     		ds: dsDestino,
	       		cm: cmDestino,
	       		stripeRows: true,
	      		viewConfig: {forceFit:true}
		});
		
		//formulario de Datos SNC...
		var fromDatosSNC = new Ext.FormPanel({
			width:760,
	        height:650,
			title: 'Datos SNC',
			frame: true,
			autoScroll:true,
			items: [cmpcampocatmoneda.fieldsetCatalogo,
			   {layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:10px;top:50px',
				items: [{
							layout: "form",
							border: false,
							labelWidth: 150,
							width:750,
							items: [{
								xtype: 'combo',
								fieldLabel: 'Tipo de Programaci&#243;n',
								labelSeparator :'',
								width : 220,
								listWidth: 220,
								id: 'codtipprog',
								store : stTipoProgramacion,
								editable : false,
								displayField : 'etiqueta',
								valueField : 'valor',
								typeAhead : true,
								triggerAction : 'all',
								mode : 'local'
							}]
					}]
			},{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:10px;top:85px',
				items: [{
							layout: "form",
							border: false,
							labelWidth: 150,
							width:750,
							items: [{
								xtype: 'combo',
								fieldLabel: 'Fuente de Financiamiento',
								labelSeparator :'',
								id: 'codfuefin',
								width : 320,
								listWidth: 320,
								store : stFuenteFinanciamiento,
								editable : false,
								displayField : 'etiqueta',
								valueField : 'valor',
								typeAhead : true,
								triggerAction : 'all',
								mode : 'local'										
								}]
						}]
			},
			{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:10px;top:120px',
				items: [{
							layout: "form",
							border: false,
							labelWidth: 150,
							width:750,
							items: [{
								xtype: 'combo',
								fieldLabel: 'Tipo Destino',
								labelSeparator :'',
								id: 'tipodestino',
								width : 150,
								listWidth: 150,
								store : stDestino,
								editable : false,
								displayField : 'etiqueta',
								valueField : 'valor',
								typeAhead : true,
								triggerAction : 'all',
								mode : 'local'										
								}]
						}]
			},
			gridCodDestino]
		});
		
		var panelProgramacion = new Ext.TabPanel({
			border: false,  
		    activeTab: 0,
		    width:800,
	        height:700,
		    deferredRender:false,
		    items: [fromProgramacionArticulo,fromDatosSNC]   
		});  
		
		var venProgramacionArticulo = new Ext.Window({
			title: 'Programaci&#243;n de Bienes/Servicios',
		    autoScroll:true,
	        width:850,
	        height:600,
	        modal: true,
	        closable:false,
	        plain: false,
	        items:[panelProgramacion],
	        buttons: [{
	            	 	text:'Aceptar',  
	            	 	handler: function(){
	            	 		var arrObj     = gridProgramacionMensual.store.getRange(0, 11)
	            	 		var codinte    = Ext.getCmp('codinte').getValue();
	            	 		var codart     = Ext.getCmp('codart').getValue();
	            	 		var spg_cuenta = Ext.getCmp('spg_cuenta').getValue();
	            	 		var precio     = Ext.getCmp('ultcosart').getValue();
	            	 		var porcar     = Ext.getCmp('porcar').getValue();
	            	 		var tipodist   = Ext.getCmp('tipodist').getValue();
	            	 		var cantotal   = Ext.getCmp('cantotal').getValue();
	            	 		var totalart   = Ext.getCmp('totalart').getValue();
	            	 		var codunimed  = Ext.getCmp('codunimed').getValue();
	            	 		var codmoneda  = Ext.getCmp('codmon').getValue();
	            	 		var codtipprog = Ext.getCmp('codtipprog').getValue();
	            	 		var codfuefin  = Ext.getCmp('codfuefin').getValue();
	            	 		var codtipodes = Ext.getCmp('tipodestino').getValue();
	            	 		var denunimed  = Ext.getCmp('denunimed').getValue();
							var denmoneda  = Ext.getCmp('denmon').getValue();
							var enero      = arrObj[0].get('cantidad');
	            	 		var febrero    = arrObj[1].get('cantidad');
							var marzo      = arrObj[2].get('cantidad');
							var abril      = arrObj[3].get('cantidad');
							var mayo       = arrObj[4].get('cantidad');
							var junio      = arrObj[5].get('cantidad');
							var julio      = arrObj[6].get('cantidad');
							var agosto     = arrObj[7].get('cantidad');
							var septiembre = arrObj[8].get('cantidad');
							var octubre    = arrObj[9].get('cantidad');
							var noviembre  = arrObj[10].get('cantidad');
							var diciembre  = arrObj[11].get('cantidad');
							var codigo_unspsc = Ext.getCmp('codigo_unspsc').getValue();
	            	 		//Destinos recorre la grid de destinos y armar una string separada por comas con los destinos.
	            	 		var destino = "";
	            	 		gridCodDestino.store.each(function (registroGrid){
	            	 			var coddestino = registroGrid.get('coddestino');
	            	 			if(destino==""){
	            	 				destino = coddestino;
	            	 			}
	            	 			else{
	            	 				destino = destino+","+coddestino;
	            	 			}
	            	 			
	            	 		});
	            	 		
	            	 		var cadenaJson = "{'oper':'registrarProgramacion',codinte:'"+codinte+"',codart:'"+codart+"'," +
	            	 				         " 'sig_cuenta':'"+spg_cuenta+"','precio_uni':"+ue_formato_operaciones(precio)+",'iva':"+ue_formato_operaciones(porcar)+"," +
	            	 				         " 'tipodist':"+tipodist+", cantotal:"+cantotal+"," +
	            	 				         " 'totgeneral':"+ue_formato_operaciones(totalart)+", codunimed:"+codunimed+"," +
	            	 				         " 'codaccion':'1', 'codmoneda':'"+codmoneda+"', 'codtipoprogramacion':'"+codtipprog+"'," +
	            	 				         " 'codfuefin':'"+codfuefin+"', 'codtipodestino':'"+codtipodes+"', 'destino':'"+destino+"'," +
	            	 				         " 'enero':"+ue_formato_operaciones(enero)+"," +
	            	 				         " 'febrero':"+ue_formato_operaciones(febrero)+",'marzo':"+ue_formato_operaciones(marzo)+"," +
	            	 				         " 'abril':"+ue_formato_operaciones(abril)+",'mayo':"+ue_formato_operaciones(mayo)+"," +
	            	 				         " 'junio':"+ue_formato_operaciones(junio)+",'julio':"+ue_formato_operaciones(julio)+"," +
	            	 				         " 'agosto':"+ue_formato_operaciones(agosto)+",'septiembre':"+ue_formato_operaciones(septiembre)+"," +
	            	 				         " 'octubre':"+ue_formato_operaciones(octubre)+",'noviembre':"+ue_formato_operaciones(noviembre)+"," +
	            	 				         " 'diciembre':"+ue_formato_operaciones(diciembre)+",'codigo_unspsc':"+codigo_unspsc+"}";
	            	 		var objTemp = eval('(' + cadenaJson + ')');
	            			var objJson = JSON.stringify(objTemp);
	            			var parametros = 'ObjSon=' + objJson;
	            			Ext.Ajax.request({
	            				url : rutaProgCompra,
	            				params : parametros,
	            				method : 'POST',
	            				success : function(resultad,request) {
	            							var datos = resultad.responseText;
	            							if (datos == '1') {
	            								Ext.MessageBox.alert('Mensaje','Programaci&#243;n de Bien/Servicio registrada con exito');
	            								articulo.set('codunimed',codunimed);
	            								articulo.set('denunimed',denunimed);
	            								articulo.set('tipodist',tipodist);
	            								articulo.set('cantotal',cantotal);
	            								articulo.set('totalgeneral',totalart);
	            								articulo.set('codmoneda',codmoneda);
	            								articulo.set('denmoneda',denmoneda);
	            								articulo.set('codtipoprogramacion',codtipprog);
	            								articulo.set('codfuefin',codfuefin);
	            								articulo.set('codtipodestino',codtipodes);
	            								articulo.set('enero',enero);
	            								articulo.set('febrero',febrero);
	            								articulo.set('marzo',marzo);
	            								articulo.set('abril',abril);
	            								articulo.set('mayo',mayo);
	            								articulo.set('junio',junio);
	            								articulo.set('julio',julio);
	            								articulo.set('agosto',agosto);
	            								articulo.set('septiembre',septiembre);
	            								articulo.set('octubre',octubre);
	            								articulo.set('noviembre',noviembre);
	            								articulo.set('diciembre',diciembre);
	            							} 
	            							else {
	            								Ext.MessageBox.alert('Advertencia','La programaci&#243;n no fue registrada ');
	            							}
	            				},
	            				failure : function(result, request) {
	            							Ext.MessageBox.alert('Error','No hay conexion, contacte al administrador del sistema');
	            				}
	            			});
	            	 		venProgramacionArticulo.destroy();                      
	            	 	}
	        		  },{
	        			text: 'Salir',
	        			handler: function(){
	        				venProgramacionArticulo.destroy();
	        			}
	        		  }]
	             
		});
		venProgramacionArticulo.show();
	}
	//fin formulario de programacion del articulo...
	
	//Llamado de funciones
	getFromProgramacion();
	
});

function irProcesar(){
}
