function catalogoDestinos(tipoDestino){
		
	//creando datastore y columnmodel para la grid de reintegros
	var reCatDestinos = Ext.data.Record.create([
	    {name: 'coddestino'}, 
	    {name: 'dendestino'}
	]);
	
	var dsCatDestinos =  new Ext.data.Store({
		reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reCatDestinos)
	});
						
	var cmCatDestinos = new Ext.grid.ColumnModel([
          				{header: "C&#243;digo", width: 20, sortable: true, dataIndex: 'coddestino'},
          				{header: "Denominaci&#243;n", width: 60, sortable: true, dataIndex: 'dendestino'}
	]);
	//creando datastore y columnmodel para la grid de reintegros
				
				
	//creando grid para los reintegros
	var gridCatalogoDestinos = new Ext.grid.GridPanel({
	 		width:700,
	 		height:250,
			frame:true,
			title:'',
			autoScroll:true,
     		border:true,
     		ds: dsCatDestinos,
       		cm: cmCatDestinos,
       		stripeRows: true,
      		viewConfig: {forceFit:true}
	});
	//fin creando grid para los reintegros
	
	gridCatalogoDestinos.on({
		'celldblclick': {
			fn: function() {
				var registro = gridCatalogoDestinos.getSelectionModel().getSelected();
    	 		if(validarExistenciaRegistroGrid(registro,gridCodDestino,'coddestino','coddestino',true)){
    	 			var nuevoRegistro = new reDestino({
        	 			'coddestino':registro.get('coddestino'),
        	 			'dendestino':registro.get('dendestino')
        	 		});
    	 			gridCodDestino.store.insert(0,nuevoRegistro);
    	 		}
    	 		gridCatalogoDestinos.destroy();
    	 		venCatalogoDestino.destroy(); 
			}
		}
    });
	
	
	switch (tipoDestino) {
		case 'E'://CATALOGO DE ESTADOS
			var datosEstado = "{'raiz':[{'coddestino':'1','dendestino':'Distrito Capital'}," +
							  "        {'coddestino':'2','dendestino':'Amazonas'}," +
							  "        {'coddestino':'3','dendestino':'Anzo&#225;tegui'}," +
							  "        {'coddestino':'4','dendestino':'Apure'}," +
							  "        {'coddestino':'5','dendestino':'Aragua'}," +
							  "        {'coddestino':'6','dendestino':'Barinas'}," +
							  "        {'coddestino':'7','dendestino':'Bol&#237;var'}," +
							  "        {'coddestino':'8','dendestino':'Carabobo'}," +
							  "        {'coddestino':'9','dendestino':'Cojedes'}," +
							  "        {'coddestino':'10','dendestino':'Delta Amacuro'}," +
							  "        {'coddestino':'11','dendestino':'Falc&#243;n'}," +
							  "        {'coddestino':'12','dendestino':'Gu&#225;rico'}," +
							  "        {'coddestino':'13','dendestino':'Lara'}," +
							  "        {'coddestino':'14','dendestino':'M&#233;rida'}," +
							  "        {'coddestino':'15','dendestino':'Miranda'}," +
							  "        {'coddestino':'15','dendestino':'Monagas'}," +
							  "        {'coddestino':'17','dendestino':'Nueva Esparta'}," +
							  "        {'coddestino':'18','dendestino':'Portuguesa'}," +
							  "        {'coddestino':'19','dendestino':'Sucre'}," +
							  "        {'coddestino':'20','dendestino':'T&#225;chira'}," +
							  "        {'coddestino':'21','dendestino':'Trujillo'}," +
							  "        {'coddestino':'22','dendestino':'Yaracuy'}," +
							  "        {'coddestino':'23','dendestino':'Zulia'}," +
							  "        {'coddestino':'24','dendestino':'Vargas'}]}";
			var jsonEstados = eval('(' + datosEstado + ')');
			dsCatDestinos.loadData(jsonEstados);
						
			var venCatalogoDestino = new Ext.Window({
				title: 'Cat&#225;logo de Destinos',
			    autoScroll:true,
		        width:750,
		        height:400,
		        modal: true,
		        closable:false,
		        plain: false,
		        items:[gridCatalogoDestinos],
		        buttons: [{
		            	 	text:'Aceptar',  
		            	 	handler: function(){
		            	 		var registro = gridCatalogoDestinos.getSelectionModel().getSelected();
		            	 		if(validarExistenciaRegistroGrid(registro,gridCodDestino,'coddestino','coddestino',true)){
		            	 			var nuevoRegistro = new reDestino({
		                	 			'coddestino':registro.get('coddestino'),
		                	 			'dendestino':registro.get('dendestino')
		                	 		});
		            	 			gridCodDestino.store.insert(0,nuevoRegistro);
		            	 		}
		            	 		gridCatalogoDestinos.destroy();
		            	 		venCatalogoDestino.destroy();                      
		            	 	}
		        		  },{
		        			text: 'Salir',
		        			handler: function(){
		        				gridCatalogoDestinos.destroy();
		        				venCatalogoDestino.destroy();
		        			}
		        		  }]
		             
			});
			venCatalogoDestino.show();
			break;
		
		case 'M'://CATALOGO DE MUNICIPIOS
			function buscarData(estado){
				var JSONObject = {
						'oper'   : 'catalogoMunicipio',
						'estado' : estado
				}
				var ObjSon = JSON.stringify(JSONObject);
				var parametros = 'ObjSon='+ObjSon; 
				Ext.Ajax.request({
					url : rutaProgCompra,
					params : parametros,
					method: 'POST',
					success: function ( resultado, request){
						var datos = resultado.responseText;
						var objetoBanco = eval('(' + datos + ')');
						if(objetoBanco!=''){
							dsCatDestinos.loadData(objetoBanco);
						}
					}	
				});
			}
			
			
			//data del combo de estados
			var estados = [  [ 'Distrito Capital', '1' ], 
                             [ 'Amazonas', '2' ],
			 				 [ 'Anzotegui', '3' ],
			 				 [ 'Apure', '4' ],
			 				 [ 'Barinas', '5' ],
			 				 [ 'Bolvar', '6' ],
			 				 [ 'Carabobo', '7' ],
			 				 [ 'Cojedes', '8' ],
			 				 [ 'Delta Amacuro', '9' ],
			 				 [ 'Falcon', '10' ],
							 [ 'Gurico', '11' ],
							 [ 'Lara', '12' ],
							 [ 'Mrida', '13' ],
							 [ 'Miranda', '14' ],
							 [ 'Monagas', '15' ],
							 [ 'Nueva Esparta', '16' ],
							 [ 'Potuguesa', '17' ],
							 [ 'Sucre', '18' ],
							 [ 'Potuguesa', '19' ],
							 [ 'Tchira', '20' ],
							 [ 'Trujillo', '21' ],
							 [ 'Yaracuy', '22' ],
							 [ 'Zulia', '23' ],
							 [ 'Vargas', '24' ] ];
			//&#237;
			var stEstados = new Ext.data.SimpleStore({
				fields : [ 'etiqueta', 'valor' ],
				data : estados
			});
			
			var	fromBusquedaMunicipio = new Ext.FormPanel({
				width: 700,
				height: 80,
				title: '',
				frame: true,
				autoScroll:true,
				items: [{
							layout: "column",
							defaults: {border: false},
							style: 'position:absolute;left:15px;top:10px',
							items: [{
										layout: "form",
										border: false,
										labelWidth: 100,
										items: [{
											xtype: 'combo',
											fieldLabel: 'Estado',
											labelSeparator :'',
											width : 130,
											listWidth: 130,
											id: 'codestado',
											store : stEstados,
											editable : false,
											displayField : 'etiqueta',
											valueField : 'etiqueta',
											typeAhead : true,
											triggerAction : 'all',
											mode : 'local'
										}]
								}]
						},{
							layout: "column",
							defaults: {border: false},
							style: 'position:absolute;left:350px;top:40px',
							items: [{
								layout: "form",
								border: false,
								labelWidth: 0,
								items: [{
										xtype:'button',
										id:'botcatesturctura',
										text: 'Buscar',
										handler:function(){
											//buscar articulos
											var codigo      = Ext.getCmp('codestado').getValue();
											buscarData(codigo);
										}
								}]
							}]
						}]
			});
			
			var venCatalogoDestino = new Ext.Window({
				title: 'Cat&#225;logo de Destinos',
			    autoScroll:true,
		        width:800,
		        height:400,
		        modal: true,
		        closable:false,
		        plain: false,
		        items:[fromBusquedaMunicipio,gridCatalogoDestinos],
		        buttons: [{
		            	 	text:'Aceptar',  
		            	 	handler: function(){
		            	 		var registro = gridCatalogoDestinos.getSelectionModel().getSelected();
		            	 		if(validarExistenciaRegistroGrid(registro,gridCodDestino,'coddestino','coddestino',true)){
		            	 			var nuevoRegistro = new reDestino({
		                	 			'coddestino':registro.get('coddestino'),
		                	 			'dendestino':registro.get('dendestino')
		                	 		});
		            	 			gridCodDestino.store.insert(0,nuevoRegistro);
		            	 		}
		            	 		gridCatalogoDestinos.destroy();
		            	 		venCatalogoDestino.destroy();                      
		            	 	}
		        		  },{
		        			text: 'Salir',
		        			handler: function(){
		        				gridCatalogoDestinos.destroy();
		        				venCatalogoDestino.destroy();
		        			}
		        		  }]
		             
			});
			venCatalogoDestino.show();
			break;
					
		case 'P'://CATALOGO DE PARROQUIAS
			function buscarData(estado, municipio){
				var JSONObject = {
						'oper'      : 'catalogoParroquia',
						'estado'    : estado,
						'municipio' : municipio
				}
				var ObjSon = JSON.stringify(JSONObject);
				var parametros = 'ObjSon='+ObjSon; 
				Ext.Ajax.request({
					url : rutaProgCompra,
					params : parametros,
					method: 'POST',
					success: function ( resultado, request){
						var datos = resultado.responseText;
						var objetoBanco = eval('(' + datos + ')');
						if(objetoBanco!=''){
							dsCatDestinos.loadData(objetoBanco);
						}
					}	
				});
			}
			
			
			//data del combo de estados
			var estados = [  [ 'Distrito Capital', '1' ], 
                             [ 'Amazonas', '2' ],
			 				 [ 'Anzotegui', '3' ],
			 				 [ 'Apure', '4' ],
			 				 [ 'Barinas', '5' ],
			 				 [ 'Bolvar', '6' ],
			 				 [ 'Carabobo', '7' ],
			 				 [ 'Cojedes', '8' ],
			 				 [ 'Delta Amacuro', '9' ],
			 				 [ 'Falcon', '10' ],
							 [ 'Gurico', '11' ],
							 [ 'Lara', '12' ],
							 [ 'Mrida', '13' ],
							 [ 'Miranda', '14' ],
							 [ 'Monagas', '15' ],
							 [ 'Nueva Esparta', '16' ],
							 [ 'Potuguesa', '17' ],
							 [ 'Sucre', '18' ],
							 [ 'Potuguesa', '19' ],
							 [ 'Tchira', '20' ],
							 [ 'Trujillo', '21' ],
							 [ 'Yaracuy', '22' ],
							 [ 'Zulia', '23' ],
							 [ 'Vargas', '24' ] ];
			
			var stEstados = new Ext.data.SimpleStore({
				fields : [ 'etiqueta', 'valor' ],
				data : estados
			});
			
			//creando datastore para el combo de municipios
			var reMunicipios = Ext.data.Record.create([
			    {name: 'dendestino'}
			]);
			
			var dsMunicipios =  new Ext.data.Store({
				reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reMunicipios)
			});
			
			var	fromBusquedaParroquia = new Ext.FormPanel({
				width: 700,
				height: 130,
				title: '',
				frame: true,
				autoScroll:true,
				items: [{
							layout: "column",
							defaults: {border: false},
							style: 'position:absolute;left:15px;top:10px',
							items: [{
										layout: "form",
										border: false,
										labelWidth: 100,
										items: [{
											xtype: 'combo',
											fieldLabel: 'Estado',
											labelSeparator :'',
											width : 130,
											listWidth: 130,
											id: 'codestado',
											store : stEstados,
											editable : false,
											displayField : 'etiqueta',
											valueField : 'etiqueta',
											typeAhead : true,
											triggerAction : 'all',
											mode : 'local',
											listeners: {
	                							'select': function(){
	                								var codestado = this.getValue();
	                								var JSONObject = {
	                										'oper'   : 'catalogoMunicipio',
	                										'estado' : codestado
	                								}
	                								var ObjSon = JSON.stringify(JSONObject);
	                								var parametros = 'ObjSon='+ObjSon; 
	                								Ext.Ajax.request({
	                									url : rutaProgCompra,
	                									params : parametros,
	                									method: 'POST',
	                									success: function ( resultado, request){
	                										var datos = resultado.responseText;
	                										var dataMunicipio = eval('(' + datos + ')');
	                										if(dataMunicipio!=''){
	                											dsMunicipios.loadData(dataMunicipio);
	                										}
	                									}	
	                								});
	                							}
											}
										}]
								}]
						},{
							layout: "column",
							defaults: {border: false},
							style: 'position:absolute;left:15px;top:40px',
							items: [{
								layout: "form",
								border: false,
								labelWidth: 0,
								items: [{
									xtype: 'combo',
									fieldLabel: 'Municipio',
									labelSeparator :'',
									width : 200,
									listWidth: 200,
									id: 'codmunicipio',
									store : dsMunicipios,
									editable : false,
									displayField : 'dendestino',
									valueField : 'dendestino',
									typeAhead : true,
									triggerAction : 'all',
									mode : 'local'
								}]
							}]
						},{
							layout: "column",
							defaults: {border: false},
							style: 'position:absolute;left:400px;top:75px',
							items: [{
								layout: "form",
								border: false,
								labelWidth: 0,
								items: [{
										xtype:'button',
										id:'botcatesturctura',
										text: 'Buscar',
										handler:function(){
											//buscar articulos
											var codEstado    = Ext.getCmp('codestado').getValue();
											var codMunicipio = Ext.getCmp('codmunicipio').getValue();
											buscarData(codEstado, codMunicipio);
										}
								}]
							}]
						}]
			});
			
			var venCatalogoDestino = new Ext.Window({
				title: 'Cat&#225;logo de Destinos',
			    autoScroll:true,
		        width:800,
		        height:500,
		        modal: true,
		        closable:false,
		        plain: false,
		        items:[fromBusquedaParroquia,gridCatalogoDestinos],
		        buttons: [{
		            	 	text:'Aceptar',  
		            	 	handler: function(){
		            	 		var registro = gridCatalogoDestinos.getSelectionModel().getSelected();
		            	 		if(validarExistenciaRegistroGrid(registro,gridCodDestino,'coddestino','coddestino',true)){
		            	 			var nuevoRegistro = new reDestino({
		                	 			'coddestino':registro.get('coddestino'),
		                	 			'dendestino':registro.get('dendestino')
		                	 		});
		            	 			gridCodDestino.store.insert(0,nuevoRegistro);
		            	 		}
		            	 		gridCatalogoDestinos.destroy();
		            	 		venCatalogoDestino.destroy();                      
		            	 	}
		        		  },{
		        			text: 'Salir',
		        			handler: function(){
		        				gridCatalogoDestinos.destroy();
		        				venCatalogoDestino.destroy();
		        			}
		        		  }]
		             
			});
			venCatalogoDestino.show();
			break;

	
	}
}