function catalogoArticulo(){
	
	function buscarData(codigo, descripcion, tipo){
		var tipoCatalogo = '';
		if(tipo == '1'){
			tipoCatalogo = 'catalogoArticulo';
		}
		else{
			tipoCatalogo = 'catalogoServicio';
		}
		
		var JSONObject = {
			'oper'   : tipoCatalogo,
			'codart' : codigo,
			'denart' : descripcion
		}
		var ObjSon = JSON.stringify(JSONObject);
		var parametros = 'ObjSon='+ObjSon; 
		Ext.Ajax.request({
			url : rutaProgCompra,
			params : parametros,
			method: 'POST',
			success: function ( resultado, request){
				var datos = resultado.responseText;
				var objetoBanco = eval('(' + datos + ')');
				if(objetoBanco!=''){
					dsProgArticulo.loadData(objetoBanco);
				}
			}	
		});
	}
	
	//creando datastore y columnmodel para la grid de reintegros
	var reProgArticulo = Ext.data.Record.create([
	    {name: 'codart'}, 
	    {name: 'denart'},
	    {name: 'spg_cuenta'},
	    {name: 'ultcosart'},
		{name: 'porcar'},
		{name: 'codigo_unspsc'}
	]);
	
	var dsProgArticulo =  new Ext.data.Store({
		reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reProgArticulo)
	});
						
	var cmProgArticulo = new Ext.grid.ColumnModel([
          				{header: "Codigo", width: 20, sortable: true, dataIndex: 'codart'},
          				{header: "Denominacion", width: 60, sortable: true, dataIndex: 'denart'}
	]);
	//creando datastore y columnmodel para la grid de reintegros
				
				
	//creando grid para los reintegros
	var gridCatalogoArticulos = new Ext.grid.GridPanel({
	 		width:700,
	 		height:250,
			frame:true,
			title:'',
			autoScroll:true,
     		border:true,
     		ds: dsProgArticulo,
       		cm: cmProgArticulo,
       		stripeRows: true,
      		viewConfig: {forceFit:true}
	});
	//fin creando grid para los reintegros
	
	gridCatalogoArticulos.on({
		'celldblclick': {
			fn: function() {
				var registro = gridCatalogoArticulos.getSelectionModel().getSelected();
    	 		if(validarExistenciaRegistroGrid(registro,gridArticulos,'codart','codart',true)){
    	 			var nuevoRegistro = new reProgArticulo({
        	 			'codart':registro.get('codart'),
        	 			'denart':registro.get('denart'),
        	 			'spg_cuenta':registro.get('spg_cuenta'),
        	 			'ultcosart':registro.get('ultcosart'),
        	 			'porcar':registro.get('porcar'),
        	 			'codigo_unspsc':registro.get('codigo_unspsc')
        	 		});
        	 		gridArticulos.store.insert(0,nuevoRegistro);
    	 		}
    	 		gridCatalogoArticulos.destroy();
    	 		venCatalogoArticulo.destroy();
			}
		}
    });
	
	//data del combo tipo 
	var tipo = [ [ 'Bien', '1' ], 
	             [ 'Servicio', '0' ] ];
	
	var stTipo = new Ext.data.SimpleStore({
		fields : [ 'col', 'tipo' ],
		data : tipo
	});
	
	//creando funcion que construye formulario principal
	var	fromBusquedaArticulo = new Ext.FormPanel({
			width: 700,
			height: 150,
			title: '',
			frame: true,
			autoScroll:true,
			items: [{
						layout: "column",
						defaults: {border: false},
						style: 'position:absolute;left:15px;top:10px',
						items: [{
									layout: "form",
									border: false,
									labelWidth: 100,
									items: [{
												xtype: 'textfield',
												fieldLabel: 'C&#243;digo',
												labelSeparator :'',
												id: 'codarticulo',
												autoCreate: {tag: 'input',type: 'text',size: '15',autocomplete: 'off',maxlength: '15'},
												width: 130,
												listeners: {
                                							'onClick': function(){
                                							}			
                       							},
												allowBlank:false
									}]
							}]
					},{
						layout: "column",
						defaults: {border: false},
						style: 'position:absolute;left:15px;top:40px',
						items: [{
									layout: "form",
									border: false,
									labelWidth: 100,
									items: [{
												xtype: 'textfield',
												fieldLabel: 'Denominaci&#243;n',
												labelSeparator :'',
												name: 'denominacion',
												id: 'denarticulo',
												width: 400,
												allowBlank:false
											}]
								}]
					},{
						layout: "column",
						defaults: {border: false},
						style: 'position:absolute;left:15px;top:70px',
						items: [{
									layout: "form",
									border: false,
									labelWidth: 100,
									items: [{
												xtype: 'combo',
												fieldLabel: 'Tipo',
												labelSeparator :'',
												id: 'tipo',
												store : stTipo,
												editable : false,
												displayField : 'col',
												valueField : 'tipo',
												typeAhead : true,
												triggerAction : 'all',
												mode : 'local'
											}]
								}]
					},{
						layout: "column",
						defaults: {border: false},
						style: 'position:absolute;left:550px;top:90px',
						items: [{
							layout: "form",
							border: false,
							labelWidth: 0,
							items: [{
									xtype:'button',
									id:'botcatesturctura',
									text: 'Buscar',
									handler:function(){
										//buscar articulos
										var codigo      = Ext.getCmp('codarticulo').getValue();
										var descripcion = Ext.getCmp('denarticulo').getValue();
										var tipo        = Ext.getCmp('tipo').getValue();
										if(tipo != ''){
											buscarData(codigo, descripcion, tipo);
										}
										else{
											Ext.MessageBox.alert('Advertencia', 'Debe seleccionar el tipo de item a buscar');
										}
									}
							}]
						}]
					}]
	});
	
	
	
	var venCatalogoArticulo = new Ext.Window({
		title: 'Cat&#225;logo de articulos',
	    autoScroll:true,
        width:900,
        height:500,
        modal: true,
        closable:false,
        plain: false,
        items:[fromBusquedaArticulo,gridCatalogoArticulos],
        buttons: [{
            	 	text:'Aceptar',  
            	 	handler: function(){
            	 		var registro = gridCatalogoArticulos.getSelectionModel().getSelected();
            	 		if(validarExistenciaRegistroGrid(registro,gridArticulos,'codart','codart',true)){
            	 			var nuevoRegistro = new reProgArticulo({
                	 			'codart':registro.get('codart'),
                	 			'denart':registro.get('denart'),
                	 			'spg_cuenta':registro.get('spg_cuenta'),
                	 			'ultcosart':registro.get('ultcosart'),
                	 			'porcar':registro.get('porcar'),
                	 			'codigo_unspsc':registro.get('codigo_unspsc')
                	 		});
                	 		gridArticulos.store.insert(0,nuevoRegistro);
            	 		}
            	 		gridCatalogoArticulos.destroy();
            	 		venCatalogoArticulo.destroy();                      
            	 	}
        		  },{
        			text: 'Salir',
        			handler: function(){
        				gridCatalogoArticulos.destroy();
        				venCatalogoArticulo.destroy();
        			}
        		  }]
             
	});
	venCatalogoArticulo.show();
}