function CatalogoServicios(){	
	//creando datastore y columnmodel para el catalogo de servicios
	var reVentana = Ext.data.Record.create([
	    {name: 'codser'}, 
	    {name: 'denser'},
	    {name: 'preser'},
	    {name: 'spg_cuenta'},
	    {name: 'existecuenta'},
	]);                                        	
	var dsVentana =  new Ext.data.Store({
	    reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reVentana)
	});                                						
	var cmVentana = new Ext.grid.ColumnModel([
		new Ext.grid.CheckboxSelectionModel(),
	    {header: "<H1 align='center'>Codigo</H1>", width: 20, sortable: true, dataIndex: 'codser'},
	    {header: "<H1 align='center'>Denominacion</H1>", width: 50, sortable: true, dataIndex: 'denser'},
	    {header: "<H1 align='center'>Precio Unitario</H1>", width: 30, sortable: true, dataIndex: 'preser'},
	    {header: "<H1 align='center'>Cuenta</H1>", width: 30, sortable: true, dataIndex: 'spg_cuenta'},
	    {header: "<H1 align='center'>existe</H1>", width: 30, sortable: true,hidden: true, dataIndex: 'existecuenta'}
	]);
	//-------------------------------------------------------------------------------------------------------------
	
	//creando grid del catalogo de servicios
	var gridVentanaCatalogoServicios = new Ext.grid.GridPanel({
	 	width:500,
	 	height:270,
		frame:true,
		style: 'position:absolute;left:0px;top:130px',
		autoScroll:true,
//		enableColumnHide: false,
// 		enableHdMenu: false,
		border:true,
		ds: dsVentana,
    	cm: cmVentana,
		sm:new Ext.grid.CheckboxSelectionModel(),
    	stripeRows: true,
    	viewConfig: {forceFit:true}
	});
	
	gridVentanaCatalogoServicios.getView().getRowClass = function(record, index){
		if(record.data.existecuenta!='0'){
			return 'celda-azul';
		}
	}
	//------------------------------------------------------------------------------------------------------------------		 
	 
	//Creacion del formulario del catalogo servicios
	var formVentanaCatalogoServicios = new Ext.FormPanel({
		width: 550,
		height: 500,
		frame: true,
		autoScroll:false,
		items: [{
			xtype:"fieldset", 
			title:'Datos del Servicio',
			style: 'position:absolute;left:15px;top:10px',
			border:true,
			width: 500,
			cls:'fondo',
			height: 120,
			items:[{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:20px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Codigo',
						name: 'codigo',
						id: 'codser',									
						width: 150,
						binding:true,
						hiddenvalue:'',
						defaultvalue:'',
						autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '20', onkeypress: "return keyRestrict(event,'0123456789');"},
						changeCheck: function(){
							var textvalor = this.getValue();
							dsVentana.filter('codser',textvalor,true);
							if(String(textvalor) !== String(this.startValue)){
								this.fireEvent('change', this, textvalor, this.startValue);
							} 
						}, 
						initEvents: function(){
							AgregarKeyPress(this);
						}
					}]
				}]
			},
			{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:50px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Denominacion',
						name: 'denominacion',
						id: 'denser',
						width: 350,
						binding:true,
						hiddenvalue:'',
						defaultvalue:'',
						changeCheck: function(){
							var textvalor = this.getValue();
							dsVentana.filter('denser',textvalor,true);
							if(String(textvalor) !== String(this.startValue)){
								this.fireEvent('change', this, textvalor, this.startValue);
							} 
						}, 
						initEvents: function(){
							AgregarKeyPress(this);
						}
					}]
				}]
     		},
     		gridVentanaCatalogoServicios,
       		{
       			layout:"column",
   				defaults: {border: false},
   				style: 'position:absolute;left:400px;top:80px',
   				border:false,
   				items:[{
   						layout:"form",
   						border:false,
   						items:[{
   							xtype: 'button',
			   				labelSeparator :'',
			   				fieldLabel: '',
			   				text: 'Buscar',
			   				id: 'btagregar',
			   				width: 300,
			   				height: 300,
			   				binding:true,
			   				hiddenvalue:'',
			   				defaultvalue:'',
			   				iconCls: 'menubuscar',
			   				handler: function(){
			   					obtenerMensaje('procesar','','Buscando Datos');				   				
								//buscar  servicios
								var codser  = Ext.getCmp('codser').getValue();
								var denser  = Ext.getCmp('denser').getValue();
								var codestpro1 = Ext.getCmp('codestpro1').getValue();
				   				var codestpro2 = Ext.getCmp('codestpro2').getValue();
				   				var codestpro3 = Ext.getCmp('codestpro3').getValue();
				   				var codestpro4 = Ext.getCmp('codestpro4').getValue();
				   				var codestpro5 = Ext.getCmp('codestpro5').getValue();
				   				var estcla     = Ext.getCmp('estcla').getValue();			                 
								var JSONObject = {
									'operacion' : 'buscarServicios',
									'codser'    : codser,
									'denser'   : denser,
									'codestpro1' : codestpro1,
				   				    'codestpro2' : codestpro2,
				   				    'codestpro3' : codestpro3,
				   				    'codestpro4' : codestpro4,
				   				    'codestpro5' : codestpro5,
				   				    'estcla'     : estcla
								}
								var ObjSon = JSON.stringify(JSONObject);
								var parametros = 'ObjSon='+ObjSon; 
								Ext.Ajax.request({
									url : '../../controlador/sep/sigesp_ctr_sep_solicitud.php',
									params : parametros,
									method: 'POST',
									success: function ( resultado, request){
										Ext.Msg.hide();
										var datos = resultado.responseText;
										var objServicio = eval('(' + datos + ')');
										if(objServicio!=''){
											if(objServicio!='0'){
												if(objServicio.raiz == null || objServicio.raiz ==''){
				   									Ext.MessageBox.show({
									 					title:'Advertencia',
									 					msg:'No existen datos para mostrar',
									 					buttons: Ext.Msg.OK,
									 					icon: Ext.MessageBox.WARNING
									 				});
												}
												else{
													gridVentanaCatalogoServicios.store.loadData(objServicio);
												}
											}
											else{
												Ext.MessageBox.show({
									 				title:'Advertencia',
									 				msg:'Debe configurar en Empresa los digitos de los servicios',
									 				buttons: Ext.Msg.OK,
									 				icon: Ext.MessageBox.WARNING
									 			});
											}	
										}
									}	
								});
							}
   			  			}]
   				}]
   			}]  
     	}]
    });
	//fin del formulario 
	//-------------------------------------------------------------------------------------------------------------------------	
    //Creando la ventana del catalogo servicios
	var ventanaServicios = new Ext.Window({
		title: "<H1 align='center'>Cat&#225;logo de Servicios</H1>",
        width:560,
        height:520,
        modal: true,
        closable:false,
        plain: false,
        frame:true,
        expandOnShow: false,
        items:[formVentanaCatalogoServicios],
        buttons: [{
        	text:'Aceptar',  
   		    handler: function(){
   		    	var reMovServicios = Ext.data.Record.create([
       				{name: 'codser'}, 
       				{name: 'denser'},
       				{name: 'canser'},
       				{name: 'spg_cuenta'},
       				{name: 'estructura'},
       				{name: 'existecuenta'}
       				
       			]);
   		    	var arrRegistro = gridVentanaCatalogoServicios.getSelectionModel().getSelections();
       				for ( var int = 0; int < arrRegistro.length; int++) {
       					var Servicios = arrRegistro[int];
       					estructura= Ext.getCmp('estructura').getValue(); 
   						if(validarExistenciaRegistroGrid(Servicios,gridServicios,'codser','codser',true)){
   							var ServiciosInt = new reMovServicios({
   								'codser':'',
   								'denser':'',
   								'canser':'',
   								'preser':'',
   								'spg_cuenta':'',
   								'estructura':estructura,
   								'existecuenta':'',
   							});
   							gridServicios.store.insert(0,ServiciosInt);
   							ServiciosInt.set('codser',Servicios.get('codser'));
   							ServiciosInt.set('denser',Servicios.get('denser'));
   							ServiciosInt.set('spg_cuenta', Servicios.get('spg_cuenta'));
   							ServiciosInt.set('existecuenta', Servicios.get('existecuenta'));
   							ServiciosInt.set('coduniadm',Ext.getCmp('coduniadm').getValue());
   							ServiciosInt.set('codestpro1',Ext.getCmp('codestpro1').getValue());
   							ServiciosInt.set('codestpro2',Ext.getCmp('codestpro2').getValue());
   							ServiciosInt.set('codestpro3',Ext.getCmp('codestpro3').getValue());
   							ServiciosInt.set('codestpro4',Ext.getCmp('codestpro4').getValue());
   							ServiciosInt.set('codestpro5',Ext.getCmp('codestpro5').getValue());
   							ServiciosInt.set('estcla',Ext.getCmp('estcla').getValue());
   							if(Ext.getCmp('codfuefin').getValue()!=''){
   								ServiciosInt.set('codfuefin',Ext.getCmp('codfuefin').getValue());
   							}
   							else{
   								ServiciosInt.set('codfuefin','--');
   							}
   							cargarCreditosServicios(codser);
   							gridCuentasCreditos.store.removeAll();
   				   		 	gridCuentas.store.removeAll();
   				   		 	gridCuentas.hide();
   				   		 	gridCuentasCreditos.hide();
   				   		 	limpiarFormulario(formVentanaCatalogo);
   				   		 	formVentanaCatalogo.hide();
   						}
       				}
       				function cargarCreditosServicios(codser){
       				var codser  = Servicios.get('codser');
        			var codestpro1 = Ext.getCmp('codestpro1').getValue();
       				var codestpro2 = Ext.getCmp('codestpro2').getValue();
       				var codestpro3 = Ext.getCmp('codestpro3').getValue();
       				var codestpro4 = Ext.getCmp('codestpro4').getValue();
       				var codestpro5 = Ext.getCmp('codestpro5').getValue();
       				var estcla = Ext.getCmp('estcla').getValue();
    				obtenerMensaje('procesar','','Buscando Datos');
    				var JSONObject = {
    						'operacion' : 'cargarCargosServicios',
    						'codser'    : codser,
    						'codestpro1': codestpro1,
    						'codestpro2': codestpro2,
    						'codestpro3': codestpro3,
    						'codestpro4': codestpro4,
    						'codestpro5': codestpro5,
    						'estcla'    : estcla
    					}
    					var ObjSon = JSON.stringify(JSONObject);
    					var parametros = 'ObjSon='+ObjSon; 
    					Ext.Ajax.request({
    						url : '../../controlador/sep/sigesp_ctr_sep_solicitud.php',
    						params : parametros,
    						method: 'POST',
    						success: function ( resultado, request){
    							Ext.Msg.hide();
    							var datos = resultado.responseText;
    							var objetoCreditos = eval('(' + datos + ')');
    							if(objetoCreditos!='' || objetoCreditos.raiz!=''){
    								var reCreditos = Ext.data.Record.create([
     							        {name: 'codcar'},
     							        {name: 'dencar'},
     							        {name: 'codigo'},
     							        {name: 'moncar'},
     							        {name: 'basimp'},
     							        {name: 'totcar'},
     							        {name: 'formula'}
     							 	]);
     								var arrdata = objetoCreditos.raiz;
     								for (var i = arrdata.length - 1; i >= 0; i--){
     									var cargo = new reCreditos({
     										'codigo':arrdata[i].codigo,
    										'codcar':arrdata[i].codcar,
    										'dencar':arrdata[i].dencar,
    										'spg_cuenta':arrdata[i].spg_cuenta,
    										'formula':arrdata[i].formula,
     									});
     									cargo.set('codestpro1',Ext.getCmp('codestpro1').getValue());
    									cargo.set('codestpro2',Ext.getCmp('codestpro2').getValue());
    									cargo.set('codestpro3',Ext.getCmp('codestpro3').getValue());
    									cargo.set('codestpro4',Ext.getCmp('codestpro4').getValue());
    									cargo.set('codestpro5',Ext.getCmp('codestpro5').getValue());
    									cargo.set('estructura',Ext.getCmp('estructura').getValue());
    									cargo.set('estcla',Ext.getCmp('estcla').getValue());
    									if(Ext.getCmp('codfuefin').getValue()!=''){
    										cargo.set('codfuefin',Ext.getCmp('codfuefin').getValue());
    		   							}
    		   							else{
    		   								cargo.set('codfuefin','--');
    		   							}
     									gridCreditos.store.insert(0,cargo);
     								}
    							}
    							else {
    								Ext.Msg.show({
    									title:'Advertencia',
    									msg: 'No se ha Creditos',
    									buttons: Ext.Msg.OK,
    									icon: Ext.MessageBox.WARNING
    								});  				
    							}
    						}	
    					});
       				}// fin de la funcion cargarCreditosServicios
    				ventanaServicios.destroy();
   		    }
   		},{
   			text: 'Salir',
   		    handler:function(){
   				ventanaServicios.destroy();
   		    }
   		}]
	});
	ventanaServicios.show();
}	

