
function CatalogoBusquedaSEP(tipo,coduniadm,codtipsol,campo){
	
	//creando el campo unidad ejecutora
	var unidad_ejecutora = Ext.data.Record.create([
   		{name: 'coduniadm'},
   		{name: 'denuniadm'}
   	]);
   	var dsUnidadEjecutora =  new Ext.data.Store({
   	    reader: new Ext.data.JsonReader({
   		root: 'raiz',             
   		id: "id"},unidad_ejecutora)
   	});
   	var cmcatUnidadEjecutora = new Ext.grid.ColumnModel([
           {header: "<H1 align='center'>Codigo</H1>", width: 20, sortable: true,   dataIndex: 'coduniadm'},
           {header: "<H1 align='center'>Denominacion</H1>", width: 40, sortable: true, dataIndex: 'denuniadm'}
   	]);
   	
    //componente campocatalogo para el campo unidades ejecutoras
   	comcampocatUnidadEjecutora = new com.sigesp.vista.comCampoCatalogo({
		titvencat: "<H1 align='center'>Cat&#225;logo de Unidades Ejecutoras</H1>",
		anchoformbus: 450,
		altoformbus:120,
		anchogrid: 450,
		altogrid: 400,
		anchoven: 500,
		altoven: 400,
		anchofieldset: 850,
		datosgridcat: dsUnidadEjecutora,
		colmodelocat: cmcatUnidadEjecutora,
		rutacontrolador:'../../controlador/sep/sigesp_ctr_sep_solicitud.php',
		parametros: "ObjSon={'operacion': 'buscarUnidadEjecutora', 'origen': '2'}",
		arrfiltro:[{etiqueta:'Codigo',id:'codicuenta',valor:'unidadcod'},
				   {etiqueta:'Descripcion',id:'descuenta',valor:'unidadden'}],
		posicion:'position:absolute;left:5px;top:160px',
		tittxt:'Unidad Ejecutora',
		idtxt:'coduniadma',
		campovalue:'coduniadm',
		anchoetiquetatext:100,
		anchotext:130,
		anchocoltext:0.30,
		idlabel:'denuniadma',
		labelvalue:'denuniadm',
		anchocoletiqueta:0.50,
		anchoetiqueta:260,
		tipbus:'L',
		binding:'C',
		hiddenvalue:'',
		defaultvalue:''             			
   	});
   	
    //------------------------------------------------------------------------------------------------------
   	
   	function tipoSeleccionado(){
   		
   		if(gridSolicitudes.getStore().getCount()!=0){
   			valor=Ext.util.Format.substr(Ext.getCmp('codtipsoli').getValue(),0,2);
   	   		var JSONObject = {
   				   'operacion' : 'buscarSolicitudes',
   				   'codtipsol' : valor,
   	   		}
   	   		var ObjSon = JSON.stringify(JSONObject);
   			var parametros = 'ObjSon='+ObjSon; 
   			Ext.Ajax.request({
   				url : '../../controlador/sep/sigesp_ctr_sep_solicitud.php',
   				params : parametros,
   				method: 'POST',
   				success: function ( resultado, request){
   					Ext.Msg.hide();
   					var datos = resultado.responseText;
   					var objetoProv = eval('(' + datos + ')');
   					if(objetoProv!='' || objetoProv.raiz!=''){
   						gridSolicitudes.store.loadData(objetoProv);
   					}
   				}	
   			});
   		}
	}
   	
  //------------------------------------------------------------------------------------------------------

	//funcion que calcula el subtotal del bien, servicio u otro
	function calcularSubtotal(tipo,cantidad,precio,unidad){
		var monsub = 0;
		if(cantidad!=undefined && precio!=undefined){
			cantidad = parseFloat(ue_formato_operaciones(cantidad));
			precio = parseFloat(ue_formato_operaciones(precio));
			monsub = cantidad*precio;
		}
		return monsub;
	}

   	//------------------------------------------------------------------------------------------------------

    //funcion que buscar el cargo por cada detalle
	function buscarcargos(descripcion,numsol,tipo,codfuefin){
		var aux = formatoNumericoMostrar(0,2,'.',',','','','-','');
		var reCargos = Ext.data.Record.create([
			{name: 'codigo'},
			{name: 'codcar'}, 
			{name: 'dencar'},
			{name: 'spg_cuenta'},
			{name: 'formula'},
			{name: 'codestpro1'},
			{name: 'codestpro2'},
			{name: 'codestpro3'},
			{name: 'codestpro4'},
			{name: 'codestpro5'},
			{name: 'estcla'},
			{name: 'monimp'},
			{name: 'monbasimp'},
			{name: 'totcar'}
		]);
		obtenerMensaje('procesar','','Buscando Datos');
		//Busco los cargos asociados a la sep
		if(descripcion=='B'){
			var JSONObj = {
				'operacion': 'cargarCargos',
				'numsol'   :  numsol,
				'tabla'    : 'sep_dta_cargos',
				'campo'    : 'codart'
			}
		}
		else if(descripcion=='S'){
			var JSONObj = {
				'operacion': 'cargarCargos',
				'numsol'   : numsol,
				'tabla'    : 'sep_dts_cargos',
				'campo'    : 'codser'
			}
		}
		else if(descripcion=='O'){
			var JSONObj = {
				'operacion': 'cargarCargos',
				'numsol'   : numsol,
				'tabla'    : 'sep_dtc_cargos',
				'campo'    : 'codconsep'
			}
		}
	  	var ObjjS=Ext.util.JSON.encode(JSONObj);
	  	var param ='ObjSon='+ObjjS;
	  	Ext.Ajax.request({
	  		url: '../../controlador/sep/sigesp_ctr_sep_solicitud.php',
	  		params: param,
	  		method: 'POST',
	  		success: function ( result, request ) { 
	  			Ext.Msg.hide();	
	  			var resul = result.responseText;
	  			var objCargos = eval('(' + resul + ')');
	  			var cargos = objCargos.raiz;
	  			if (objCargos != ""){
	  				plSolicitud.add(gridCreditos);
					gridCreditos.show();
					plSolicitud.doLayout();
	  				for(var i = 0;  i<cargos.length; i++){
	  					var cargosInt = new reCargos({
							'codigo'    :cargos[i].codigo,
							'codcar'    :cargos[i].codcar,
							'dencar'    :cargos[i].dencar,
							'spg_cuenta':cargos[i].spg_cuenta,
							'formula'   :cargos[i].formula,
							'monimp'    :'0,00',
							'monbasimp' :'0,00'
						});
						if(tipo=='CONSULTAR'){
							cargosInt.set('estructura',cargos[i].estructura);
							cargosInt.set('codestpro1',cargos[i].codestpro1);
							cargosInt.set('codestpro2',cargos[i].codestpro2);
							cargosInt.set('codestpro3',cargos[i].codestpro3);
							cargosInt.set('codestpro4',cargos[i].codestpro4);
							cargosInt.set('codestpro5',cargos[i].codestpro5);
							cargosInt.set('estcla',cargos[i].estcla);
							cargosInt.set('codfuefin',codfuefin);
							cargosInt.set('moncar',cargos[i].monimp);
							cargosInt.set('basimp',cargos[i].monbasimp);
							cargosInt.set('totcar',cargos[i].monto);
							if(descripcion=='B'){
								gridBienes.store.each(function (reBien){
									if(cargos[i].codigo==reBien.get('codart')){
										reBien.set('carart',cargos[i].monimp)
									}
								});
							}
							if(descripcion=='S'){
								gridServicios.store.each(function (reBien){
									if(cargos[i].codigo==reBien.get('codser')){
										reBien.set('carser',cargos[i].monimp)
									}
								});
							}
							if(descripcion=='O'){
								gridConceptos.store.each(function (reCon){
									if(cargos[i].codigo==reCon.get('codconsep')){
										reCon.set('carcon',cargos[i].monimp)
									}
								});
							}
							
						}
						else if(tipo=='COPIAR'){
							cargosInt.set('codestpro1',Ext.getCmp('codestpro1').getValue());
							cargosInt.set('codestpro2',Ext.getCmp('codestpro2').getValue());
							cargosInt.set('codestpro3',Ext.getCmp('codestpro3').getValue());
							cargosInt.set('codestpro4',Ext.getCmp('codestpro4').getValue());
							cargosInt.set('codestpro5',Ext.getCmp('codestpro5').getValue());
							cargosInt.set('estcla',Ext.getCmp('estcla').getValue());
							cargosInt.set('codfuefin',codfuefin);
      	    				cargosInt.set('estructura',Ext.getCmp('estructura').getValue());
						}
	    				gridCreditos.store.insert(0,cargosInt);
					}
	  			}
	  		},
	  		failure: function (result, request){ 
	  			Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
	  		}//fin del success
	  	});//fin del ajax request
	}
   	
   	//------------------------------------------------------------------------------------------------------
   	
   	//funcion que acumula los totales de la grid
   	function AcumularTotales(){
		var montoSubtotal = 0;
		var montoOtroCreditos = 0;
		gridCuentas.store.each(function (registro){
			var aux = registro.get('monto');
			aux = parseFloat(ue_formato_operaciones(aux));
			montoSubtotal = aux + montoSubtotal;
		})
		Ext.getCmp('monbasinm').setValue(formatoNumericoMostrar(montoSubtotal,2,'.',',','','','-',''));
		
		gridCuentasCreditos.store.each(function (registroCredito){
			var auxCredito = registroCredito.get('moncar');
			auxCredito = parseFloat(ue_formato_operaciones(auxCredito));
			montoOtroCreditos = auxCredito + montoOtroCreditos;
		})
	   	Ext.getCmp('montotcar').setValue(formatoNumericoMostrar(montoOtroCreditos,2,'.',',','','','-',''));
		
		var TotalGeneral = 	montoSubtotal + montoOtroCreditos;
		Ext.getCmp('monto').setValue(formatoNumericoMostrar(TotalGeneral,2,'.',',','','','-',''));
	}
   	
   	//------------------------------------------------------------------------------------------------------
  	
   	//creando el campo tipo de solicitud (Bien-Servicio-Otros)
   	var reTipoSolicitud = Ext.data.Record.create([
   	       {name: 'codtipsol'},
   	       {name: 'modsep'},
   	       {name: 'descripcion'}
    ]);
    var dsTipoSolicitud =  new Ext.data.Store({
        reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reTipoSolicitud)
    });
    function buscarTipoSolicitud(){
        var myJSONObject ={
          	"operacion":"buscarTipoSolicitud" 
        };
		var ObjSon=Ext.util.JSON.encode(myJSONObject);
		var parametros ='ObjSon='+ObjSon;
		Ext.Ajax.request({
			url: '../../controlador/sep/sigesp_ctr_sep_solicitud.php',
			params: parametros,
			method: 'POST',
			success: function ( result, request ) { 
		            var datosTipoSolicitud = eval('(' + result.responseText + ')');
		            dsTipoSolicitud.loadData(datosTipoSolicitud);		            
			},
			failure: function ( result, request){ 
					Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
			}
		});			                    	
	}
	buscarTipoSolicitud(); 

   	//------------------------------------------------------------------------------------------------------

	//creando el campo destino (proveedor-beneficiario)
	var arregloDestino = [
	    ['-','-- Seleccione --'],
        ['P','PROVEEDOR'],
        ['B','BENEFICIARIO']
	]; // Arreglo que contiene los Documentos que se pueden controlar
	var dsDestino = new Ext.data.SimpleStore({
		fields: ['codigo', 'denominacion'],
		data : arregloDestino // Se asocian los documentos disponibles
	});
	
   	//------------------------------------------------------------------------------------------------------

	function Aceptar(registro){
		var reArt = Ext.data.Record.create([
			{name: 'codart'}, 
			{name: 'denart'},
			{name: 'canart'},
			{name: 'codunimed'},
			{name: 'unidad'},
			{name: 'denunimed'},
			{name: 'monpre'},
			{name: 'unimed'},
			{name: 'monart'},
			{name: 'spg_cuenta'},
			{name: 'codestpro1'},
			{name: 'codestpro2'},
			{name: 'codestpro3'},
			{name: 'codestpro4'},
			{name: 'codestpro5'},
			{name: 'estcla'},
			{name: 'codfuefin'}
		]);
		var reSer = Ext.data.Record.create([
		      {name: 'codser'}, 
		      {name: 'denser'},
		      {name: 'monpre'},
		      {name: 'monser'},
		      {name: 'spg_cuenta'},
		      {name: 'codestpro1'},
		      {name: 'codestpro2'},
			  {name: 'codestpro3'},
			  {name: 'codestpro4'},
			  {name: 'codestpro5'},
			  {name: 'estcla'},
			  {name: 'codfuefin'}
	    ]);
		var reCon = Ext.data.Record.create([
			  {name: 'codconsep'}, 
			  {name: 'denconsep'},
			  {name: 'spg_cuenta'},
			  {name: 'cancon'},
			  {name: 'monpre'},
			  {name: 'moncon'},
			  {name: 'codestpro1'},
		      {name: 'codestpro2'},
			  {name: 'codestpro3'},
			  {name: 'codestpro4'},
			  {name: 'codestpro5'},
			  {name: 'estcla'},
			  {name: 'codfuefin'}
		]);
		var reCuentas = Ext.data.Record.create([
			  {name: 'estructura'},
			  {name: 'spg_cuenta'},
			  {name: 'total'},
			  {name: 'codestpro1'},
		      {name: 'codestpro2'},
			  {name: 'codestpro3'},
			  {name: 'codestpro4'},
			  {name: 'codestpro5'},
			  {name: 'estcla'},
			  {name: 'codfuefin'}
		]);
		var reCueCar = Ext.data.Record.create([
		      {name: 'estructura'},
		 	  {name: 'spg_cuenta'},
		 	  {name: 'total'},
		      {name: 'codcar'},
		      {name: 'formula'},
		      {name: 'codestpro1'},
		      {name: 'codestpro2'},
			  {name: 'codestpro3'},
			  {name: 'codestpro4'},
			  {name: 'codestpro5'},
			  {name: 'estcla'},
			  {name: 'codfuefin'}
		]);
		if(tipo=='CONSULTAR'){
			limpiarFormulario(plSolicitud);
			gridCuentasCreditos.store.removeAll();
			gridCuentas.store.removeAll();
			gridBienes.store.removeAll();
			gridConceptos.store.removeAll();
			gridServicios.store.removeAll();
			gridCreditos.store.removeAll();
			gridCuentasCreditos.hide();
			gridCuentas.hide();
			gridBienes.hide();
			gridServicios.hide();
			gridConceptos.hide();
			gridCreditos.hide();
			botCreAsiBie.hide();
			Ext.getCmp('tipsepbie').disable();
			setDataFrom(plSolicitud,registro);
			Actualizar = true;
			var valor = '';
			var descripcion ='';
			//estatus de la solicitud
			if((registro.get('estsol')=='R') || (registro.get('estsol')=='E')){
				plSolicitud.add(botCreAsiBie);
				botCreAsiBie.show();
				plSolicitud.doLayout();
				var estope = Ext.util.Format.substr(registro.get('codtipsol'),3,1);
				var estayueco = Ext.util.Format.substr(registro.get('codtipsol'),4,1);
				if(estope=='O' && estayueco=='1'){
					Ext.getCmp('nombenalt').setDisabled(false);
				}
			}
			if(registro.get('estsol')=='R'){
				valor = 'REGISTRADA';
			}
			if(registro.get('estsol')=='P'){
				valor = 'PROCESADA';
			}
			if(registro.get('estsol')=='A'){
				valor = 'ANULADA';
			}
			if(registro.get('estsol')=='C'){
				valor = 'CONTABILIZADA';
			}
			if(registro.get('estsol')=='E'){
				valor = 'EMITIDA';
			}
			if(registro.get('estsol')=='E' && registro.get('estapro')==1){
				valor = 'APROBADA';
			}
			Ext.getCmp('estsollabel').setValue(valor);
			//tipo de la solicitud
			var descripcion = Ext.util.Format.substr(registro.get('codtipsol'),2,1);
			if(descripcion=='B'){
				obtenerMensaje('procesar','','Buscando Datos');
				var JSONObject = {
					'operacion' : 'cargarArticulos',
					'numsol'    : registro.get('numsol')
				}			
				var ObjSon = JSON.stringify(JSONObject);
				var parametros = 'ObjSon='+ObjSon; 
				Ext.Ajax.request({
					url : '../../controlador/sep/sigesp_ctr_sep_solicitud.php',
					params : parametros,
					method: 'POST',
					success: function ( resultado, request){
						Ext.Msg.hide();
						var resultado = resultado.responseText;
						var objDatos = eval('(' + resultado + ')');
						var datos = objDatos.raiz;
						plSolicitud.add(gridBienes);
						gridBienes.show();
						plSolicitud.doLayout();
						Ext.getCmp('tipsepbie').enable();
						if(objDatos != ""){
							for(var j = 0; j < datos.length; j++){
								var bienesInt = new reArt({
									'codart'     :datos[j].codart,
									'denart'     :datos[j].denart,
									'canart'     :datos[j].canart,
									'unidad'     :datos[j].unimed,
									'preart'     :datos[j].monpre,
									'totart'     :datos[j].monart,
									'denunimed'  :datos[j].denunimed,
									'modalidad'  :datos[j].unidad,
									'spg_cuenta' :datos[j].spg_cuenta,
									'codestpro1' :datos[j].codestpro1,
									'codestpro2' :datos[j].codestpro2,
									'codestpro3' :datos[j].codestpro3,
									'codestpro4' :datos[j].codestpro4,
									'codestpro5' :datos[j].codestpro5,
									'estcla'     :datos[j].estcla,
									'codfuefin'  :datos[j].codfuefin,
									'estructura' :datos[j].estructura,
									'carart'     :'0,00'
								});	
	      	    				var monsub = calcularSubtotal(descripcion,datos[j].canart,datos[j].monpre,datos[j].unimed);
	      	    				bienesInt.set('subtotalart',formatoNumericoMostrar(monsub,2,'.',',','','','-',''));
	      	    				gridBienes.store.insert(0,bienesInt);
							}
						}
					},
					failure: function ( result, request){ 
						Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
					}//fin del success
				});//fin del ajax request
			}
			else if(descripcion=='S'){
				obtenerMensaje('procesar','','Buscando Datos');
				var JSONObject = {
					'operacion' : 'cargarServicios',
					'numsol'    : registro.get('numsol')
				}			
				var ObjSon = JSON.stringify(JSONObject);
				var parametros = 'ObjSon='+ObjSon; 
				Ext.Ajax.request({
					url : '../../controlador/sep/sigesp_ctr_sep_solicitud.php',
					params : parametros,
					method: 'POST',
					success: function ( resultado, request){
						Ext.Msg.hide();
						var resultado = resultado.responseText;
						var objDatos = eval('(' + resultado + ')');
						var datos = objDatos.raiz;
						plSolicitud.add(gridServicios);
						gridServicios.show();
						plSolicitud.doLayout();
						if(objDatos != ""){
							for(var j = 0; j < datos.length; j++){
								var serviciosInt = new reSer({
									'codser'     :datos[j].codser,
									'denser'     :datos[j].denser,
									'canser'     :datos[j].canser,
									'preser'     :datos[j].monpre,
									'totser'     :datos[j].monser,
									'spg_cuenta' :datos[j].spg_cuenta,
									'codestpro1' :datos[j].codestpro1,
									'codestpro2' :datos[j].codestpro2,
									'codestpro3' :datos[j].codestpro3,
									'codestpro4' :datos[j].codestpro4,
									'codestpro5' :datos[j].codestpro5,
									'estcla'     :datos[j].estcla,
									'codfuefin'  :datos[j].codfuefin,
									'estructura' :datos[j].estructura,
									'carser'     :'0,00'
								});
								var monsub = calcularSubtotal(descripcion,datos[j].canser,datos[j].monpre);
								serviciosInt.set('subtotser',formatoNumericoMostrar(monsub,2,'.',',','','','-',''));
								gridServicios.store.insert(0,serviciosInt);
							}
						}
					},
					failure: function ( result, request){ 
						Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
					}//fin del success
				});//fin del ajax request
			}
			else if(descripcion=='O'){
				obtenerMensaje('procesar','','Buscando Datos');
				var JSONObject = {
					'operacion' : 'cargarConceptos',
					'numsol'    : registro.get('numsol')
				}			
				var ObjSon = JSON.stringify(JSONObject);
				var parametros = 'ObjSon='+ObjSon; 
				Ext.Ajax.request({
					url : '../../controlador/sep/sigesp_ctr_sep_solicitud.php',
					params : parametros,
					method: 'POST',
					success: function ( resultado, request){
						Ext.Msg.hide();
						var resultado = resultado.responseText; 
						var objDatos = eval('(' + resultado + ')');
						var datos = objDatos.raiz;
						plSolicitud.add(gridConceptos);
						gridConceptos.show();
						plSolicitud.doLayout();
						Ext.getCmp('tipo_destino').enable();
						if(objDatos != ""){
							for(var j = 0; j < datos.length; j++){
								var conceptoInt = new reCon({
									'codconsep' :datos[j].codconsep, 
									'denconsep' :datos[j].denconsep,
									'cancon'    :datos[j].cancon,
									'spg_cuenta':datos[j].spg_cuenta,
									'monconsepe':datos[j].monpre,
									'totcon'    :datos[j].moncon,
									'codestpro1':datos[j].codestpro1,
									'codestpro2':datos[j].codestpro2,
									'codestpro3':datos[j].codestpro3,
									'codestpro4':datos[j].codestpro4,
									'codestpro5':datos[j].codestpro5,
									'estcla'    :datos[j].estcla,
									'codfuefin' :datos[j].codfuefin,
									'estructura':datos[j].estructura,
									'carcon'    :'0,00'
								});
								var monsub = calcularSubtotal(descripcion,datos[j].cancon,datos[j].monpre);
								conceptoInt.set('subtotcon',formatoNumericoMostrar(monsub,2,'.',',','','','-',''));
								gridConceptos.store.insert(0,conceptoInt);
							}
						}
					},
					failure: function ( result, request){ 
						Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
					}//fin del success
				});//fin del ajax request
			}
			buscarcargos(descripcion,registro.get('numsol'),tipo,registro.get('codfuefin'));
			obtenerMensaje('procesar','','Buscando Datos');
			//Busco la cuentas asociadas a la solicitud
			var JSONObj = {
					'operacion'  : 'cargarCuentas',
					'numsol'     : registro.get('numsol')
			}
			var ObjjSon=Ext.util.JSON.encode(JSONObj);
			var parametros ='ObjSon='+ObjjSon;
			Ext.Ajax.request({
				url: '../../controlador/sep/sigesp_ctr_sep_solicitud.php',
				params: parametros,
				method: 'POST',
				success: function ( result, request ) { 
					Ext.Msg.hide();
					var resul = result.responseText;
					var Datos = eval('(' + resul + ')');
					var cuentas = Datos.raiz;
					plSolicitud.add(gridCuentas);
					gridCuentas.show();
					plSolicitud.add(formVentanaCatalogo);
					formVentanaCatalogo.show();
					plSolicitud.doLayout();
					if(Datos != ""){
						for(var i = 0; i < cuentas.length; i++){
							var cuentasInt = new reCuentas({
								'estructura' :'',
								'spg_cuenta' :'',
								'total'      :''
							});
							cuentasInt.set('estructura',cuentas[i].estructura);
							cuentasInt.set('spg_cuenta',cuentas[i].spg_cuenta);
							cuentasInt.set('monto',cuentas[i].total);
							cuentasInt.set('codestpro1', cuentas[i].codestpro1);
							cuentasInt.set('codestpro2', cuentas[i].codestpro2);
							cuentasInt.set('codestpro3', cuentas[i].codestpro3);
							cuentasInt.set('codestpro4', cuentas[i].codestpro4);
							cuentasInt.set('codestpro5', cuentas[i].codestpro5);
							cuentasInt.set('estcla', cuentas[i].estcla);
							cuentasInt.set('codfuefin', cuentas[i].codfuefin);
							gridCuentas.store.insert(0,cuentasInt);
						}
						AcumularTotales();
					}
					
				},
				failure: function ( result, request){ 
					Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
				}//fin del success
			});//fin del ajax request
			obtenerMensaje('procesar','','Buscando Datos');
			//Busco la cuentas asociadas a la solicitud
			var JSONObj = {
					'operacion'  : 'cargarCuentasCargos',
					'numsol'     : registro.get('numsol')
			}
			var ObjjSon=Ext.util.JSON.encode(JSONObj);
			var parametros ='ObjSon='+ObjjSon;
			Ext.Ajax.request({
				url: '../../controlador/sep/sigesp_ctr_sep_solicitud.php',
				params: parametros,
				method: 'POST',
				success: function ( result, request ) { 
					Ext.Msg.hide();
					var resul = result.responseText;
					var Datos = eval('(' + resul + ')');
					var cuecar = Datos.raiz;
					plSolicitud.add(gridCuentasCreditos);
					gridCuentasCreditos.show();
					plSolicitud.doLayout();
					if(Datos != ""){
						for(var i = 0; i < cuecar.length; i++){
							var cuecarInt = new reCueCar({
								'estructura' :'',
								'spg_cuenta' :'',
								'total'      :'',
								'codcar'     :''
							});
							cuecarInt.set('estructura',cuecar[i].estructura);
							cuecarInt.set('spg_cuenta',cuecar[i].spg_cuenta);
							cuecarInt.set('moncar',cuecar[i].total);
							cuecarInt.set('credito',cuecar[i].codcar);
							cuecarInt.set('formula', cuecar[i].formula);
							cuecarInt.set('codestpro1', cuecar[i].codestpro1);
							cuecarInt.set('codestpro2', cuecar[i].codestpro2);
							cuecarInt.set('codestpro3', cuecar[i].codestpro3);
							cuecarInt.set('codestpro4', cuecar[i].codestpro4);
							cuecarInt.set('codestpro5', cuecar[i].codestpro5);
							cuecarInt.set('estcla', cuecar[i].estcla);
							cuecarInt.set('codfuefin', cuecar[i].codfuefin);
							gridCuentasCreditos.store.insert(0,cuecarInt);
						}
					}
					AcumularTotales();
				},
				failure: function ( result, request){ 
					Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
				}//fin del success
			});//fin del ajax request
		}
		else if(tipo=='COPIAR'){
			gridCuentasCreditos.store.removeAll();
			gridCuentas.store.removeAll();
			gridBienes.store.removeAll();
			gridConceptos.store.removeAll();
			gridServicios.store.removeAll();
			gridCreditos.store.removeAll();
			limpiarFormulario(formVentanaCatalogo);
			formVentanaCatalogo.hide();
			gridCuentasCreditos.hide();
			gridCuentas.hide();
			gridBienes.hide();
			gridConceptos.hide();
			gridServicios.hide();
			plSolicitud.add(botCreAsiBie);
			botCreAsiBie.show();
			plSolicitud.doLayout();
			Ext.getCmp('codtipsol').setValue(registro.get('codtipsol'));
			if(Ext.getCmp('codfuefin').getValue()!=''){
				var codfuefin = Ext.getCmp('codfuefin').getValue(); 
			}
			else{
				var codfuefin = '--';
			}
			//tipo de la solicitud
			var descripcion = Ext.util.Format.substr(registro.get('codtipsol'),2,1);
			if(descripcion=='B'){
				obtenerMensaje('procesar','','Buscando Datos');
				var JSONObject = {
					'operacion' : 'cargarArticulos',
					'numsol'    : registro.get('numsol')
				}			
				var ObjSon = JSON.stringify(JSONObject);
				var parametros = 'ObjSon='+ObjSon; 
				Ext.Ajax.request({
					url : '../../controlador/sep/sigesp_ctr_sep_solicitud.php',
					params : parametros,
					method: 'POST',
					success: function ( resultado, request){
						Ext.Msg.hide();
						var resultado = resultado.responseText;
						var objDatos = eval('(' + resultado + ')');
						var datos = objDatos.raiz;
						if(typeof(gridBienes) == 'object' && gridBienes != null){
							plSolicitud.add(gridBienes);
							gridBienes.show();
							plSolicitud.doLayout();
							Ext.getCmp('tipsepbie').enable();
						}
						if(objDatos != ""){
							for(var j = 0; j < datos.length; j++){
								var bienesInt = new reArt({
									'codart'     :datos[j].codart,
									'denart'     :datos[j].denart,
									'unidad'     :datos[j].unimed,
									'denunimed'  :datos[j].denunimed,
									'modalidad'  :datos[j].unidad,
									'canart'     :'',
									'preart'     :'',
									'spg_cuenta' :datos[j].spg_cuenta,
									'codestpro1' :Ext.getCmp('codestpro1').getValue(),
									'codestpro2' :Ext.getCmp('codestpro2').getValue(),
	      	    					'codestpro3' :Ext.getCmp('codestpro3').getValue(),
	      	    					'codestpro4' :Ext.getCmp('codestpro4').getValue(),
	      	    					'codestpro5' :Ext.getCmp('codestpro5').getValue(),
	      	    					'estcla'     :Ext.getCmp('estcla').getValue(),
	      	    					'codfuefin'  :codfuefin,
	      	    					'estructura' :Ext.getCmp('estructura').getValue()
								});
	      	    				gridBienes.store.insert(0,bienesInt);
							}
						}
					},
					failure: function ( result, request){ 
						Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
					}//fin del success
				});//fin del ajax request
			}
			else if(descripcion=='S'){
				obtenerMensaje('procesar','','Buscando Datos');
				var JSONObject = {
					'operacion' : 'cargarServicios',
					'numsol'    : registro.get('numsol')
				}			
				var ObjSon = JSON.stringify(JSONObject);
				var parametros = 'ObjSon='+ObjSon; 
				Ext.Ajax.request({
					url : '../../controlador/sep/sigesp_ctr_sep_solicitud.php',
					params : parametros,
					method: 'POST',
					success: function ( resultado, request){
						Ext.Msg.hide();
						var resultado = resultado.responseText;
						var objDatos = eval('(' + resultado + ')');
						var datos = objDatos.raiz;
						if (typeof(gridServicios) == 'object' && gridServicios != null){
							plSolicitud.add(gridServicios);
							gridServicios.show();
							plSolicitud.doLayout();
						}
						if(objDatos != ""){
							for(var j = 0; j < datos.length; j++){
								var serviciosInt = new reSer({
									'codser'     :datos[j].codser,
									'denser'     :datos[j].denser,
									'spg_cuenta' :datos[j].spg_cuenta,
									'canser'     :'',
									'preser'     :'',
									'codestpro1' :Ext.getCmp('codestpro1').getValue(),
									'codestpro2' :Ext.getCmp('codestpro2').getValue(),
									'codestpro3' :Ext.getCmp('codestpro3').getValue(),
									'codestpro4' :Ext.getCmp('codestpro4').getValue(),
									'codestpro5' :Ext.getCmp('codestpro5').getValue(),
									'estcla'     :Ext.getCmp('estcla').getValue(),
									'codfuefin'  :codfuefin,
									'estructura' :Ext.getCmp('estructura').getValue()
								});
								gridServicios.store.insert(0,serviciosInt);
							}
						}
					},
					failure: function ( result, request){ 
						Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
					}//fin del success
				});//fin del ajax request
			}
			else if(descripcion=='O'){
				obtenerMensaje('procesar','','Buscando Datos');
				var JSONObject = {
					'operacion' : 'cargarConceptos',
					'numsol'    : registro.get('numsol')
				}			
				var ObjSon = JSON.stringify(JSONObject);
				var parametros = 'ObjSon='+ObjSon; 
				Ext.Ajax.request({
					url : '../../controlador/sep/sigesp_ctr_sep_solicitud.php',
					params : parametros,
					method: 'POST',
					success: function ( resultado, request){
						Ext.Msg.hide();
						var resultado = resultado.responseText;
						var objDatos = eval('(' + resultado + ')');
						var datos = objDatos.raiz;
						if (typeof(gridConceptos) == 'object' && gridConceptos != null){
							plSolicitud.add(gridConceptos);
							gridConceptos.show();
							plSolicitud.doLayout();
							Ext.getCmp('tipo_destino').enable();
						}
						if(objDatos != ""){
							for(var j = 0; j < datos.length; j++){
								var conceptoInt = new reCon({
									'codconsep' :datos[j].codconsep, 
									'denconsep' :datos[j].denconsep,
									'spg_cuenta':datos[j].spg_cuenta,
									'cancon'    :'',
									'monconsepe':'',
									'codestpro1':Ext.getCmp('codestpro1').getValue(),
									'codestpro2':Ext.getCmp('codestpro2').getValue(),
									'codestpro3':Ext.getCmp('codestpro3').getValue(),
									'codestpro4':Ext.getCmp('codestpro4').getValue(),
									'codestpro5':Ext.getCmp('codestpro5').getValue(),
									'estcla'    :Ext.getCmp('estcla').getValue(),
									'codfuefin' :codfuefin,
									'estructura':Ext.getCmp('estructura').getValue()
								});
								gridConceptos.store.insert(0,conceptoInt);
							}
						}
					},
					failure: function ( result, request){ 
						Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
					}//fin del success
				});//fin del ajax request
			}
			buscarcargos(descripcion,registro.get('numsol'),tipo,codfuefin);
		}
		gridSolicitudes.destroy();
		ventanaEstructura.destroy();
	}
	
   	//------------------------------------------------------------------------------------------------------

	//crando el campo solicitud
	var reSolicitud = Ext.data.Record.create([
	       {name: 'numsol'},
	       {name: 'codtipsol'},
	       {name: 'codfuefin'},
	       {name: 'fecregsol'},
	       {name: 'estapro'},
	       {name: 'consol'},
	       {name: 'tipo_destino'},
	       {name: 'coduniadm'},
	       {name: 'numdocori'},
	       {name: 'nombre'},
	       {name: 'conanusep'},
	       {name: 'monto'},
	       {name: 'cod_pro'},
	       {name: 'ced_bene'},
	       {name: 'codestpro1'},
	       {name: 'codestpro2'},
	       {name: 'codestpro3'},
	       {name: 'codestpro4'},
	       {name: 'codestpro5'},
	       {name: 'estcla'},
	       {name: 'subtotal'},
	       {name: 'creditos'},
	       {name: 'total'},
	       {name: 'artser'},
	       {name: 'codigo'},
	       {name: 'estprolabel'},
	       {name: 'estpro'},
	       {name: 'modalidad'},
	       {name: 'estructura'},
	       {name: 'estapro'},
	       {name: 'estsol'},
	       {name: 'fecaprsep'},
	       {name: 'tipsepbie'},
	       {name: 'formato'},
	       {name: 'tipo_destino'},
	       {name: 'consol'},
	       {name: 'nombenalt'},
	       {name: 'codtipsol'},
	       {name: 'ced_bene'}
	]);	
	var dsVentana =  new Ext.data.Store({
		reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reSolicitud)
	});
	var cmVentana = new Ext.grid.ColumnModel([
//	    new Ext.grid.CheckboxSelectionModel(),
	    {header: "<H1 align='center'>Nro. de Solicitud</H1>", width: 60, sortable: true, dataIndex: 'numsol'},
	    {header: "<H1 align='center'>Unidad Ejecutora</H1>", width: 60, sortable: true, dataIndex: 'coduniadm'},          
	    {header: "<H1 align='center'>Fecha</H1>", width: 30, sortable: true, dataIndex: 'fecregsol'},          
	    {header: "<H1 align='center'>Proveedor/Beneficiario</H1>", width: 70, sortable: true, dataIndex: 'nombre'},        
	    {header: "<H1 align='center'>Monto</H1>", width: 40, sortable: true, dataIndex: 'monto'}          
	]);
	
	//creando datastore y columnmodel para la grid de buscar solicitudes
	gridSolicitudes = new Ext.grid.GridPanel({
		width:600,
		height:200,
		frame:true,
		title:"<H1 align='center'>Cantidad de Registros</H1>",
		style: 'position:absolute;left:0px;top:240px',
		autoScroll:true,
		border:true,
		ds: dsVentana,
		cm: cmVentana,
//		sm:new Ext.grid.CheckboxSelectionModel({singleSelect:true}),
		stripeRows: true,
		viewConfig: {forceFit:true}

	});
	
	gridSolicitudes.on({
		'rowdblclick': {
			fn: function(grid, numFila, evento){
		    	var registro = grid.getStore().getAt(numFila);
		    	Aceptar(registro);
		    }
		}
	});
	
   	//------------------------------------------------------------------------------------------------------
	
	//creacion del formulario principal
	var formVentanaCatalogo2= new Ext.FormPanel({
		width: 630,
		height: 485,
		title: '',
		style: 'position:absolute;left:5px;top:10px',
		frame: true,
		autoScroll:false,
		items: [{
			xtype:"fieldset", 
			title:'Datos de la Solicitud',
			style: 'position:absolute;left:20px;top:10px',
			border:true,
			cls: 'fondo',
			height:230,
			width:590,
			items:[{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:10px;top:20px',
				items:[{
					layout: "form",
					border: false,
					labelWidth: 105,
					items:[{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Solicitud',
						id: 'numsoli',								
						width: 200,
						autoCreate: {tag: 'input', type: 'text', size: '100', maxlength: '15', onkeypress: "return keyRestrict(event,'0123456789');"},
						changeCheck: function(){
							var valor = this.getValue();
							dsVentana.filter('numsol',valor,true,false);
							if(String(valor) != String(this.startValue)){
								this.fireEvent('change', this, valor, this.startValue);
							} 
						},							 
						initEvents : function(){
							AgregarKeyPress(this);
						}
					}]
				}]
			},   
			{
				layout: "column",
				border: false,
				defaults: {border: false},
				style: 'position:absolute;left:10px;top:50px',
				items:[{
					layout: "form",
					border: false,
					labelWidth: 105,			
					items:[{
     			        xtype:"combo",
     			        labelSeparator :'',
     			        store: dsTipoSolicitud,
     			        displayField:'descripcion',
     			        valueField:'codtipsol',
     			        id:'codtipsoli',
     			        disabled:campo,
     			        typeAhead: true,
     			        mode: 'local',
     			        triggerAction: 'all',
     			        fieldLabel:'Tipo',
     			   	    listWidth:300,
     			   	    editable:false,
     			        width:200,
     			       listeners:{'select':tipoSeleccionado}
					}]
				}]
			},comcampocatUnidadEjecutora.fieldsetCatalogo,
			{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:10px;top:80px',
				items:[{
 					layout: "form",
 					border: false,
 					labelWidth: 105,
 					items:[{
 						xtype: 'textfield',
 						labelSeparator :'',
 						fieldLabel: 'Concepto',
 						id: 'consoli',
 						width: 200,
 						changeCheck: function(){
							var valor = this.getValue();
							dsVentana.filter('consol',valor,true,false);
							if(String(valor) != String(this.startValue)){
								this.fireEvent('change', this, valor, this.startValue);
							} 
						},							 
						initEvents : function(){
							AgregarKeyPress(this);
						}
 					}]
				}]
			},{
       			layout:"column",
		   		defaults: {border: false},
		   		style: 'position:absolute;left:500px;top:195px', 
		   		border:false,
		   		items:[{
		   			layout:"form",
		   			border:false,
		   			items:[{
		   				xtype: 'button',
		   				fieldLabel: '',
		   				text: 'Buscar',
		   				id: 'btagregar',
		   				iconCls: 'menubuscar',
		   				handler: function(){ 
		   				
		   					var tipobien = "";
		   					if(Ext.getCmp('tipsepbie').items.items[0].checked){
		   						tipobien = "M";
		   					}
		   					if(Ext.getCmp('tipsepbie').items.items[1].checked){
		   						tipobien = "A";
		   					}
		   					obtenerMensaje('procesar','','Buscando Datos');
		   					var JSONObject = { 
		   							'operacion' 	 : 'buscarSolicitudes',
		   							'numsol'    	 : Ext.getCmp('numsoli').getValue(),
		   							'codtipsol'  	 : Ext.util.Format.substr(Ext.getCmp('codtipsoli').getValue(),0,2),
		   							'tipsepbie'      : tipobien,
		   							'concepto'  	 : Ext.getCmp('consoli').getValue(),
		   							'destino'   	 : Ext.getCmp('tipo_destinoi').getValue(),
		   							'fechadesd' 	 : Ext.getCmp('fechadesd').getValue(),
		   							'fechahas'  	 : Ext.getCmp('fechahas').getValue(),
		   							'coduniadm' 	 : Ext.getCmp('coduniadma').getValue(),
		   							'tipo'           : '',
		   							'codpro'         : Ext.getCmp('codpro').getValue(),
		   							'cedbene'        : Ext.getCmp('cedbene').getValue(),
		   							'tipooperacion'  : '',
		   							'descripcion'    : tipo,
		   							'origen_catalogo': ''
		   							
		   					}			
		   					var ObjSon = JSON.stringify(JSONObject);
		   					var parametros = 'ObjSon='+ObjSon; 
		   					Ext.Ajax.request({
		   						url : '../../controlador/sep/sigesp_ctr_sep_solicitud.php',
		   						params : parametros,
		   						method: 'POST',
		   						success: function ( resultado, request){
		   							Ext.Msg.hide();
		   							var datos = resultado.responseText;
		   							var objetoProveedores = eval('(' + datos + ')');
		   							if(objetoProveedores!=''){
			   							if(objetoProveedores!='0'){
			   								if(objetoProveedores.raiz == null || objetoProveedores.raiz ==''){
			   									gridSolicitudes.store.removeAll();
			   									Ext.MessageBox.show({
								 					title:'Advertencia',
								 					msg:'No existen datos para mostrar',
								 					buttons: Ext.Msg.OK,
								 					icon: Ext.MessageBox.WARNING
								 				});
											}
											else{
												gridSolicitudes.store.loadData(objetoProveedores);
											}
			   							}
			   							else{
			   								Ext.MessageBox.show({
								 				title:'Advertencia',
								 				msg:'Debe configurar en Empresa los digitos de las cuentas de gastos',
								 				buttons: Ext.Msg.OK,
								 				icon: Ext.MessageBox.WARNING
								 			});
			   							}
			   						}
		   						}	
		   					});
		   		        }
		   			}]
		   		}]
   			}, 
			{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:10px;top:110px',
				items:[{
					layout: "form",
					border: false,
					labelWidth: 105,
					items:[{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Artculo',
						id: 'codart',
						width: 200,
						binding:true,
						hiddenvalue:'',
						defaultvalue:'',
						changeCheck: function(){
							var valor = this.getValue();
							dsVentana.filter('artser',valor,true,false);
							if(String(valor) != String(this.startValue)){
								this.fireEvent('change', this, valor, this.startValue);
							} 
						},							 
						initEvents : function(){
							AgregarKeyPress(this);
						}
					}]
				}]
			},
			{
				layout: "column",
				border: false,
				defaults: {border: false},
				style: 'position:absolute;left:10px;top:140px',
				items:[{
					layout: "form",
					border: false,
					labelWidth: 105,			
					items:[{
     			        xtype:"combo",
     			       labelSeparator :'',
     			        store: dsDestino,
     			        displayField:'denominacion',
     			        valueField:'codigo',
     			        id:"tipo_destinoi",
     			        typeAhead: true,
     			        mode: 'local',
     			        triggerAction: 'all',
     			        fieldLabel:'Destino',
     			   	    listWidth:250,
     			   	    editable:false,
     			        width:110,
     			        binding:true,
     					hiddenvalue:'',
     					defaultvalue:'',
     					listeners:{'select':tipoVentanaSeleccionado} //esta funcion hace lo mismo q la funcion destinoSeleccionado que esta mas arriba
					}]														//tal vez se puede reutilizar ese codigo y evitar tantas lineas con lo mismo
				}]
			},
			{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:235px;top:140px',
				items:[{
					layout: "form",
					border: false,
					labelWidth:5 ,
					items:[{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: '',
						id: 'nombrei',
						width: 320,
						disabled:true,
						binding:true,
						formatonumerico:false,
						hiddenvalue:'',
						defaultvalue:''
					}]
				}]
	        },gridSolicitudes,
	        {
				layout: "form",
				border: false,
				labelWidth: 90,
				columnWidth: 0.5,
				style:'position:absolute;left:360px;top:50px',
				items:[{
					xtype:"datefield",
					fieldLabel:"Fecha Desde",
					name:"Fecregistrornc",
					allowBlank:true,
					labelSeparator :'',
					width:100,
					binding:true,
					defaultvalue:'1900-01-01',
					hiddenvalue:'',
					id:"fechadesd",						
					autoCreate: {tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789/');"},
					changeCheck: function(){
						var valor = this.getValue();
						dsVentana.filter('fecregsol',valor,true,false);
						if(String(valor) != String(this.startValue)){
							this.fireEvent('change', this, valor, this.startValue);
						} 
					},							 
					initEvents : function(){
						AgregarKeyPress(this);
					}
				}]
			},
			{
				layout: "form",
				border: false,
				labelWidth: 50,
				columnWidth: 0.5,
				style:'position:absolute;left:400px;top:80px',
				items:[{
					xtype:"datefield",
					fieldLabel:"Hasta",
					name:"Fecregist",
					allowBlank:true,
					labelSeparator :'',
					width:100,
					binding:true,
					defaultvalue:'1900-01-01',
					hiddenvalue:'',
					id:"fechahas",
					autoCreate: {tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789/');"},
					changeCheck: function(){
						var valor = this.getValue();
						dsVentana.filter('fecregsol',valor,true,false);
						if(String(valor) != String(this.startValue)){
							this.fireEvent('change', this, valor, this.startValue);
						} 
					},							 
					initEvents : function(){
						AgregarKeyPress(this);
					}
				}]
			},{
				xtype: 'hidden',
				id: 'codpro',
				binding:true,
				allowBlank:true,
				defaultvalue:'----------'
			},{
				xtype: 'hidden',
				id: 'cedbene',
				binding:true,
				allowBlank:true,
				defaultvalue:'----------'
			}] 
		}] 		
	});
	var ventanaEstructura = new Ext.Window({
		width:650,
		height:560,
		border:false,
		modal: true,
		closable:false,
		frame:true,
		title:"<H1 align='center'>Cat&#225;logo de Solicitudes de Ejecucion Presupuestaria</H1>",
		items:[formVentanaCatalogo2],
		buttons:[{
			text:'Aceptar',  
			handler: function(){
			var registro = gridSolicitudes.getSelectionModel().getSelected();
			if(registro!=undefined){
				Aceptar(registro);
			}
		 	else{
		 		Ext.MessageBox.show({
		 			title:'Mensaje',
		 			msg:'Debe seleccionar al menos un registro para procesar la informacion!!!',
		 			buttons: Ext.Msg.OK,
		 			icon: Ext.MessageBox.INFO
		 		});
        	}
		}
		},{
			text: 'Salir',
			handler: function(){
				ventanaEstructura.destroy();
			}
		}] 	
    });
	
	ventanaEstructura.show();
	  
	function act_data_store_numSolicitud(criterio,cadena){
		dsVentana.filter(criterio,cadena);
	}
	function act_data_store_conSolicitud(criterio,cadena){
		dsVentana.filter(criterio,cadena);
	}
	function act_data_store_codArticulos(criterio,cadena){
		dsVentana.filter(criterio,cadena);
	}
	function act_data_store_fechaDesdeSolicitud(criterio,cadena){
		dsVentana.filter(criterio,cadena);
	}
	function act_data_store_fechaHastaSolicitud(criterio,cadena){
		dsVentana.filter(criterio,cadena);
	}
	
   	//------------------------------------------------------------------------------------------------------
	 
	function tipoVentanaSeleccionado(){  
		valor2=Ext.getCmp('tipo_destinoi').getValue();	
		if(valor2=='P'){
			//creando datastore y columnmodel para la grid de cambio de estatus de proveedor
			var reVentana = Ext.data.Record.create([
			    {name: 'cod_pro'}, 
	            {name: 'nompro'},
	            {name: 'dirpro'}
	        ]);
			var dsVentana =  new Ext.data.Store({
				reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reVentana)
			});
			var cmVentana = new Ext.grid.ColumnModel([
			    {header: "<H1 align='center'>Codigo</H1>", width: 40, sortable: true, dataIndex: 'cod_pro'},
			    {header: "<H1 align='center'>Nombre</H1>", width: 100, sortable: true, dataIndex: 'nompro'}          
			]);
			gridVentanaProveedor = new Ext.grid.GridPanel({
				width:550,
				height:210,
				frame:true,
				title:"<H1 align='center'>Cantidad de Registros</H1>",
				style: 'position:absolute;left:0px;top:140px',
				autoScroll:true,
				border:true,
				ds: dsVentana,
				cm: cmVentana,
				stripeRows: true,
				viewConfig: {forceFit:true}
			});
			gridVentanaProveedor.on({
	    		'rowdblclick': {
	    			fn: function(grid, numFila, evento){
	    		    	var registro = grid.getStore().getAt(numFila);
	    		    	Ext.getCmp('nombrei').setValue(registro.get('nompro'));
						Ext.getCmp('cedbene').setValue('');
						Ext.getCmp('codpro').setValue(registro.get('cod_pro'));
						gridVentanaProveedor.destroy();
						ventanaEstructura.destroy();	
	    		    }
	    		}
	    	});
			var formVentanaCatalogos= new Ext.FormPanel({
				width: 590,
				height: 380,
				title: '',
				style: 'position:absolute;left:5px;top:10px',
				frame: true,
				autoScroll:false,
				items: [{
					xtype:"fieldset", 
					title:'Datos del Proveedor',
					style: 'position:absolute;left:20px;top:10px',
					border:true,
					height:130,
					cls:'fondo',
					width:550,
					items:[{
						layout: "column",
						defaults: {border: false},
						style: 'position:absolute;left:15px;top:20px',
						items:[{
							layout: "form",
							border: false,
							labelWidth: 80,
							items:[{
								xtype: 'textfield',
								labelSeparator :'',
								fieldLabel: 'Codigo',
								name: 'codigo',
								id: 'cod_pro',								
								width: 150,
								autoCreate: {tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789');"},
								changeCheck: function(){
									var valor = this.getValue();
									dsVentana.filter('cod_pro',valor,true,false);
									if(String(valor) != String(this.startValue)){
										this.fireEvent('change', this, valor, this.startValue);
									} 
								},						 
								initEvents : function(){
									AgregarKeyPress(this);
								}
							}]
						}]
	  		        },
	  		        {
	  					layout: "column",
	  					defaults: {border: false},
	  					style: 'position:absolute;left:15px;top:50px',
	  					items:[{
	  						layout: "form",
	  						border: false,
	  						labelWidth: 80,
	  						items: [{
	  							xtype: 'textfield',
	  							labelSeparator :'',
	  							fieldLabel: 'Nombre',
	  							name: 'nombre',
	  							id: 'nompro',
	  							width: 300,
	  							changeCheck: function(){
									var valor = this.getValue();
									dsVentana.filter('nompro',valor,true,false);
									if(String(valor) != String(this.startValue)){
										this.fireEvent('change', this, valor, this.startValue);
									} 
								},						 
								initEvents : function(){
									AgregarKeyPress(this);
								}
	  						}]
	  					}]
	  		        },
	  		        {
	  					layout: "column",
	  					defaults: {border: false},
	  					style: 'position:absolute;left:15px;top:80px',
	  					items: [{
	  						layout: "form",
	  						border: false,
	  						labelWidth: 80,
	  						items: [{
	  							xtype: 'textfield',
	  							labelSeparator :'',
	  							fieldLabel: 'Direccion',
	  							id: 'dirpro',
	  							width: 300,
	  							changeCheck: function(){
									var valor = this.getValue();
									dsVentana.filter('dirpro',valor,true,false);
									if(String(valor) != String(this.startValue)){
										this.fireEvent('change', this, valor, this.startValue);
									} 
								},						 
								initEvents : function(){
									AgregarKeyPress(this);
								}
	  						}]
	  					}]
	  		        },
	  		        {
	        			layout:"column",
	 		   			defaults: {border: false},
	 		   			style: 'position:absolute;left:460px;top:100px', 
	 		   			border:false,
	 		   			items:[{
	 		   				layout:"form",
	 		   				border:false,
	 		   				items:[{
	 		   					xtype: 'button',
	 		   					fieldLabel: '',
	 		   					text: 'Buscar',
	 		   					id: 'btagregar',
	 		   					iconCls: 'menubuscar',
	 		   					handler: function(){
			 		   				
	 		   						if((Ext.getCmp('cod_pro').getValue() == '') && (Ext.getCmp('nompro').getValue() == '') 
									&& (Ext.getCmp('dirpro').getValue() == '')){
										Ext.Msg.show({
											title:'Mensaje',
											msg:'Debe seleccionar al menos un par&#225;metro de b&#250;squeda',
											buttons: Ext.Msg.OK,
											icon: Ext.MessageBox.INFO
										});
									}
	 		   						else{
		 		   						obtenerMensaje('procesar','','Buscando Datos');
					 		   			var JSONObject = { 
			 		   							'operacion' : 'catalogo',
			 		   							'codi_pro'  : Ext.getCmp('cod_pro').getValue(),
			 		   							'nombpro'   : Ext.getCmp('nompro').getValue(),
			 		   							'direcpro'  : Ext.getCmp('dirpro').getValue()
			 		   					}
					 		   			var ObjSon = JSON.stringify(JSONObject);
			 		   					var parametros = 'ObjSon='+ObjSon; 
			 		   					Ext.Ajax.request({
			 		   						url : '../../controlador/rpc/sigesp_ctr_rpc_proveedor.php',
				 		   					params : parametros,
			 		   						method: 'POST',
			 		   						success: function ( resultado, request){
					 		   					Ext.Msg.hide();
			 		   							var datos = resultado.responseText;
			 		   							var objetoProveedores = eval('(' + datos + ')');
			 		   							if(objetoProveedores!=''){
			 		   								if(objetoProveedores!='0'){
			 		   									if(objetoProveedores.raiz == null || objetoProveedores.raiz ==''){
						   									Ext.MessageBox.show({
											 					title:'Advertencia',
											 					msg:'No existen datos para mostrar',
											 					buttons: Ext.Msg.OK,
											 					icon: Ext.MessageBox.WARNING
											 				});
			 		   									}
														else{
															gridVentanaProveedor.store.loadData(objetoProveedores);
														}
			 		   								}
						   							else{
						   								Ext.MessageBox.show({
											 				title:'Advertencia',
											 				msg:'Debe configurar en Empresa los digitos de las cuentas de gastos',
											 				buttons: Ext.Msg.OK,
											 				icon: Ext.MessageBox.WARNING
											 			});
						   							}
			 		   							}
			 		   						}
			 		   					});
	 		   						}
	 		   					}
	 		   				}]
	 		   			}]
	    			},gridVentanaProveedor ] 
				}] 		
			});
			var ventanaEstructura = new Ext.Window({
				width:600,
				height:450,
				border:false,
				modal: true,
				closable:false,
				frame:true,
				title:"<H1 align='center'>Cat&#225;logo de Proveedores</H1>",
				items:[formVentanaCatalogos],
				buttons:[{
					text:'Aceptar',  
					handler: function(){
					    gridSolicitudes.store.removeAll();
						var registro = gridVentanaProveedor.getSelectionModel().getSelected();	        	
						if(registro!= undefined){		
							Ext.getCmp('nombrei').setValue(registro.get('nompro'));
							Ext.getCmp('cedbene').setValue('');
							Ext.getCmp('codpro').setValue(registro.get('cod_pro'));
							gridVentanaProveedor.destroy();
							ventanaEstructura.destroy();	        									
						}
						else {
							Ext.MessageBox.show({
								title:'Mensaje',
								msg:'Debe seleccionar al menos un registro a procesar',
								buttons: Ext.Msg.OK,
								icon: Ext.MessageBox.INFO
							});
						}
					}
					},{
						text: 'Salir',
						handler: function(){
						ventanaEstructura.destroy();
					}
				}] 	
			});
			ventanaEstructura.show();
		}
		else if(valor2=='B'){				  
			var reVentana = Ext.data.Record.create([
			     {name: 'ced_bene'}, 
			     {name: 'nombene'},
			     {name: 'apebene'}
			])
			var dsVentana =  new Ext.data.Store({
				reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reVentana)
			});
			var cmVentana = new Ext.grid.ColumnModel([
			     {header: "<H1 align='center'>Codigo</H1>", width: 40, sortable: true, dataIndex: 'ced_bene'},
			     {header: "<H1 align='center'>Nombre</H1>", width: 100, sortable: true, dataIndex: 'nombene'}          
			]);
			//creando datastore y columnmodel para la grid de cambio de estatus de beneficiario
			gridVentanaBeneficiario = new Ext.grid.GridPanel({
				width:550,
				height:210,
				frame:true,
				title:"<H1 align='center'>Cantidad de Registros</H1>",
				style: 'position:absolute;left:0px;top:140px',
				autoScroll:true,
				border:true,
				ds: dsVentana,
				cm: cmVentana,
				stripeRows: true,
				viewConfig: {forceFit:true}
			});
			gridVentanaBeneficiario.on({
	    		'rowdblclick': {
	    			fn: function(grid, numFila, evento){
	    		    	var registro = grid.getStore().getAt(numFila);
	    		    	Ext.getCmp('nombrei').setValue(registro.get('nombene'));
						Ext.getCmp('codpro').setValue('');
						Ext.getCmp('cedbene').setValue(registro.get('ced_bene'));
						gridVentanaBeneficiario.destroy();
						ventanaEstructura.destroy();	
	    		    }
	    		}
	    	});
			var formVentanaCatalogo1= new Ext.FormPanel({
				width: 590,
				height: 380,
				title: '',
				style: 'position:absolute;left:5px;top:10px',
				frame: true,
				autoScroll:false,
				items: [{
					xtype:"fieldset", 
					title:'Datos del Beneficiario',
					style: 'position:absolute;left:20px;top:10px',
					border:true,
					height:130,
					cls:'fondo',
					width:550,
					items:[{
						layout: "column",
						defaults: {border: false},
						style: 'position:absolute;left:15px;top:20px',
						items: [{
							layout: "form",
							border: false,
							labelWidth: 80,
							items: [{
								xtype: 'textfield',
								labelSeparator :'',
								fieldLabel: 'Cdula',
								id: 'ced_bene',								
								width: 150,
								autoCreate: {tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789');"},
								changeCheck: function(){
									var valor = this.getValue();
									dsVentana.filter('ced_bene',valor,true,false);
									if(String(valor) != String(this.startValue)){
										this.fireEvent('change', this, valor, this.startValue);
									} 
								},						 
								initEvents : function(){
									AgregarKeyPress(this);
								}
							}]
						}]
					},
					{
						layout: "column",
						defaults: {border: false},
						style: 'position:absolute;left:15px;top:50px',
						items: [{
							layout: "form",
							border: false,
							labelWidth: 80,
							items: [{
								xtype: 'textfield',
								labelSeparator :'',
								fieldLabel: 'Nombre',
								id: 'nombene',
								width: 300,
								changeCheck: function(){
								var valor = this.getValue();
									dsVentana.filter('nombene',valor,true,false);
									if(String(valor) != String(this.startValue)){
										this.fireEvent('change', this, valor, this.startValue);
									} 
								},						 
								initEvents : function(){
									AgregarKeyPress(this);
								}
							}]
						}]
					},
					{
						layout: "column",
						defaults: {border: false},
						style: 'position:absolute;left:15px;top:80px',
						items: [{
							layout: "form",
							border: false,
							labelWidth: 80,
							items: [{
								xtype: 'textfield',
								labelSeparator :'',
								fieldLabel: 'Apellido',
								id: 'apebene',
								width: 300,
								changeCheck: function(){
									var valor = this.getValue();
									dsVentana.filter('apebene',valor,true,false);
									if(String(valor) != String(this.startValue)){
										this.fireEvent('change', this, valor, this.startValue);
									} 
								},						 
								initEvents : function(){
									AgregarKeyPress(this);
								}
							}]
						}]
					},
					{
	        			layout:"column",
	 		   			defaults: {border: false},
	 		   			style: 'position:absolute;left:460px;top:100px', 
	 		   			border:false,
	 		   			items:[{
	 		   				layout:"form",
	 		   				border:false,
	 		   				items:[{
	 		   					xtype: 'button',
	 		   					fieldLabel: '',
	 		   					text: 'Buscar',
	 		   					id: 'btagregar',
	 		   					iconCls: 'menubuscar',
	 		   					handler: function(){
			 		   				
		 		   					if((Ext.getCmp('ced_bene').getValue() == '') && (Ext.getCmp('nombene').getValue() == '') 
				   						&& (Ext.getCmp('apebene').getValue() == '')){
				   						Ext.Msg.show({
				   							title:'Mensaje',
				   							msg:'Debe seleccionar al menos un par&#225;metro de b&#250;squeda',
				   							buttons: Ext.Msg.OK,
				   							icon: Ext.MessageBox.INFO
				   						});
				   					}
		 		   					else{
			 		   					obtenerMensaje('procesar','','Buscando Datos');
					 		   			var JSONObject = { 
			 		   							'operacion' : 'catalogo_beneficiario',
			 		   							'mced_bene' : Ext.getCmp('ced_bene').getValue(),
			 		   							'mnombene'  : Ext.getCmp('nombene').getValue(),
			 		   							'mapebene'  : Ext.getCmp('apebene').getValue()
			 		   					}
					 		   			var ObjSon = JSON.stringify(JSONObject);
			 		   					var parametros = 'ObjSon='+ObjSon; 
			 		   					Ext.Ajax.request({
			 		   						url : '../../controlador/rpc/sigesp_ctr_rpc_beneficiario.php',
				 		   					params : parametros,
			 		   						method: 'POST',
			 		   						success: function ( resultado, request){
					 		   					Ext.Msg.hide();
			 		   							var datos = resultado.responseText;
			 		   							var objetoBeneficiarios = eval('(' + datos + ')');
			 		   							if(objetoBeneficiarios!=''){
			 		   								if(objetoBeneficiarios!='0'){
			 		   									if(objetoBeneficiarios.raiz == null || objetoBeneficiarios.raiz ==''){
						   									Ext.MessageBox.show({
											 					title:'Advertencia',
											 					msg:'No existen datos para mostrar',
											 					buttons: Ext.Msg.OK,
											 					icon: Ext.MessageBox.WARNING
											 				});
			 		   									}
														else{
															gridVentanaBeneficiario.store.loadData(objetoBeneficiarios);
														}
			 		   								}
						   							else{
						   								Ext.MessageBox.show({
											 				title:'Advertencia',
											 				msg:'Debe configurar en Empresa los digitos de las cuentas de gastos',
											 				buttons: Ext.Msg.OK,
											 				icon: Ext.MessageBox.WARNING
											 			});
						   							}
			 		   							}
			 		   						}
			 		   					});
		 		   					}
	 		   					}
	 		   				}]
	 		   			}]
	    			},gridVentanaBeneficiario]    
				}] 		
			});
			var ventanaEstructura = new Ext.Window({
				width:600,
				height:450,
				border:false,
				modal: true,
				closable:false,
				frame:true,
				title:"<H1 align='center'>Cat&#225;logo de Beneficiarios</H1>",
				items:[formVentanaCatalogo1],
				buttons:[{
					text:'Aceptar',  
					handler: function(){
					    gridSolicitudes.store.removeAll();
						var registro = gridVentanaBeneficiario.getSelectionModel().getSelected();	        	
						if(registro!= undefined){		
							Ext.getCmp('nombrei').setValue(registro.get('nombene'));
							Ext.getCmp('codpro').setValue('');
							Ext.getCmp('cedbene').setValue(registro.get('ced_bene'));
							gridVentanaBeneficiario.destroy();
							ventanaEstructura.destroy();	        									
						}
						else{
							Ext.MessageBox.show({
								title:'Mensaje',
								msg:'Debe seleccionar al menos un registro a procesar',
								buttons: Ext.Msg.OK,
								icon: Ext.MessageBox.INFO
							});
						}
					}
					},{
						text: 'Salir',
						handler: function(){
							ventanaEstructura.destroy();
						}
				}] 	
			});
			ventanaEstructura.show();
		  }
	  }  
	 
   	//------------------------------------------------------------------------------------------------------


}