
function CatalogoConceptos(){
			
	//Creando datastore y columnmodel para el catalogo de CONCEPTOS
	var reVentana = Ext.data.Record.create([
        {name: 'codconsep'}, 
        {name: 'denconsep'},
    	{name: 'spg_cuenta'},
    	{name: 'cancon'},
    	{name: 'monconsepe'},
    	{name: 'monco'},
    	{name: 'orden'},
    	{name: 'existecuenta'}
    ]);
            	
	var dsVentana =  new Ext.data.Store({
		reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reVentana)
    });
	                                						
	 var cmVentana = new Ext.grid.ColumnModel([
	     new Ext.grid.CheckboxSelectionModel(),
	         {header: "<H1 align='center'>Codigo</H1>", width: 20, sortable: true, dataIndex: 'codconsep'},
	         {header: "<H1 align='center'>Denominacion</H1>", width: 60, sortable: true, dataIndex: 'denconsep'},
	         {header: "<H1 align='center'>Precio Unitario</H1>", width: 45, sortable: true, dataIndex: 'monconsepe'},
	         {header: "<H1 align='center'>Cuenta</H1>", width: 30, sortable: true, dataIndex: 'spg_cuenta'},
	         {header: "<H1 align='center'>existe</H1>", width: 30, sortable: true,hidden:true, dataIndex: 'existecuenta'}

	]);
	//-------------------------------------------------------------------------------------------------------------------------
	
	//Creando grid para el catalogo de conceptos
	var gridVentanaCatalogoConceptos = new Ext.grid.GridPanel({
		width:500,
 		height:250,
		frame:true,
		style: 'position:absolute;left:0px;top:130px',
		autoScroll:true,
		border:true,
		ds: dsVentana,
		cm: cmVentana,
		sm:new Ext.grid.CheckboxSelectionModel(),
		stripeRows: true,
		viewConfig: {forceFit:true}
	});
	gridVentanaCatalogoConceptos.getView().getRowClass = function(record, index){
		if(record.data.existecuenta!='0'){
			return 'celda-azul';
		}
	}
	
	//-------------------------------------------------------------------------------------------------------------------------		 
	 	 //boton de buscar para los conceptos
	var botBuscarConceptos = new Ext.Button({
		id: 'botBuscarConceptos',
		iconCls: 'menubuscar',
		style:'position:absolute;left:480px;top:110px',
		handler:function(){
			 obtenerMensaje('procesar','','Buscando Datos');
				var JSONObject = {
				'operacion' : 'buscarConceptos',
				}			
				var ObjSon = JSON.stringify(JSONObject);
				var parametros = 'ObjSon='+ObjSon; 
				Ext.Ajax.request({
					url : '../../controlador/sep/sigesp_ctr_sep_solicitud.php',
					params : parametros,
					method: 'POST',
					success: function ( resultado, request){
						Ext.Msg.hide();
						var datos = resultado.responseText;
						var objetoConceptos = eval('(' + datos + ')');
						if(objetoConceptos!='' || objetoConceptos.raiz!=''){
							gridVentanaCatalogoConceptos.store.loadData(objetoConceptos);
					}
					else {
							Ext.Msg.show({
							title:'Advertencia',
							msg: 'No se ha Proveedores',
							buttons: Ext.Msg.OK,
							icon: Ext.MessageBox.WARNING
						});  				
					}
				}	
			});	
		}
	});
	//-------------------------------------------------------------------------------------------------------------------------		 
	 
	//Creacion del formulario del catalogo conceptos
	var formVentanaCatalogoConceptos = new Ext.FormPanel({
		width: 550,
		height: 500,
		frame: true,
		autoScroll:false,
		items: [{
			xtype:"fieldset", 
			title:'Datos del Concepto',
			style: 'position:absolute;left:15px;top:10px',
			border:true,
			cls: 'fondo',
			width: 500,
			height: 120,
			items:[{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:20px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Codigo',
						name: 'codigo',
						id: 'codconsep',									
						width: 150,
						binding:true,
						hiddenvalue:'',
						defaultvalue:'',
						autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '20', onkeypress: "return keyRestrict(event,'0123456789');"},
						changeCheck: function(){
							var textvalor = this.getValue();
							dsVentana.filter('codconsep',textvalor,true);
							if(String(textvalor) !== String(this.startValue)){
								this.fireEvent('change', this, textvalor, this.startValue);
							} 
						}, 
						initEvents: function(){
							AgregarKeyPress(this);
						}
					}]
				}]
			},
			{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:50px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Denominacion',
						name: 'denominacion',
						id: 'denconsep',
						width: 350,
						binding:true,
						hiddenvalue:'',
						defaultvalue:'',
						changeCheck: function(){
							var textvalor = this.getValue();
							dsVentana.filter('denconsep',textvalor,true);
							if(String(textvalor) !== String(this.startValue)){
								this.fireEvent('change', this, textvalor, this.startValue);
							} 
						}, 
						initEvents: function(){
							AgregarKeyPress(this);
						}
					}]
				}]
     		},
     		gridVentanaCatalogoConceptos,
       		{
       			layout:"column",
   				defaults: {border: false},
   				style: 'position:absolute;left:400px;top:85px',
   				border:false,
   				items:[{
   						layout:"form",
   						border:false,
   						items:[{
   							xtype: 'button',
			   				labelSeparator :'',
			   				fieldLabel: '',
			   				text: 'Buscar',
			   				id: 'btagregar',
			   				width: 300,
			   				height: 300,
			   				binding:true,
			   				hiddenvalue:'',
			   				defaultvalue:'',
			   				iconCls: 'menubuscar',
			   				handler: function(){
			   					obtenerMensaje('procesar','','Buscando Datos');
					   				
								//buscar  Conceptos
								var codconsep  = Ext.getCmp('codconsep').getValue();
								var denconsep  = Ext.getCmp('denconsep').getValue();
								var codestpro1 = Ext.getCmp('codestpro1').getValue();
				   				var codestpro2 = Ext.getCmp('codestpro2').getValue();
				   				var codestpro3 = Ext.getCmp('codestpro3').getValue();
				   				var codestpro4 = Ext.getCmp('codestpro4').getValue();
				   				var codestpro5 = Ext.getCmp('codestpro5').getValue();
				   				var estcla     = Ext.getCmp('estcla').getValue();
				
								var JSONObject = {
									'operacion' : 'buscarConceptos',
									'codconsep'    : codconsep,
									'denconsep'   : denconsep,
									'codestpro1' : codestpro1,
				   				    'codestpro2' : codestpro2,
				   				    'codestpro3' : codestpro3,
				   				    'codestpro4' : codestpro4,
				   				    'codestpro5' : codestpro5,
				   				    'estcla'     : estcla
								}
						
								var ObjSon = JSON.stringify(JSONObject);
								var parametros = 'ObjSon='+ObjSon; 
								Ext.Ajax.request({
									url : '../../controlador/sep/sigesp_ctr_sep_solicitud.php',
									params : parametros,
									method: 'POST',
									success: function ( resultado, request){
										Ext.Msg.hide();
										var datos = resultado.responseText;
										var objConceptos = eval('(' + datos + ')');
										if(objConceptos!=''){
											if(objConceptos!='0'){
												if(objConceptos.raiz == null || objConceptos.raiz ==''){
				   									Ext.MessageBox.show({
									 					title:'Advertencia',
									 					msg:'No existen datos para mostrar',
									 					buttons: Ext.Msg.OK,
									 					icon: Ext.MessageBox.WARNING
									 				});
												}
												else{
													gridVentanaCatalogoConceptos.store.loadData(objConceptos);
												}
											}
											else{
												Ext.MessageBox.show({
									 				title:'Advertencia',
									 				msg:'Debe configurar en Empresa los digitos de los conceptos',
									 				buttons: Ext.Msg.OK,
									 				icon: Ext.MessageBox.WARNING
									 			});
											}
										}
									}	
								});
							}
   			  			}]
   				}]
   			}]  
     	}]
    });
	//fin del formulario 
	//-------------------------------------------------------------------------------------------------------------	
	
	//Creando la ventana del catalogo conceptos
	var ventanaConceptos = new Ext.Window({
		title: "<H1 align='center'>Cat&#225;logo de Conceptos</H1>",
        width:560,
        height:500,
        modal: true,
        closable:false,
        plain: false,
        frame:true,
        expandOnShow: false,
        items:[formVentanaCatalogoConceptos],
        buttons: [{
        	text:'Aceptar',  
   		    handler: function(){
   		    	var reMovConceptos = Ext.data.Record.create([
       				{name: 'codconsep'}, 
       				{name: 'denconsep'},
       				{name: 'cancon'},
       				{name: 'spg_cuenta'},
       				{name: 'estructura'},
       				{name: 'existecuenta'},
       			]);
   		    	var arrRegistro = gridVentanaCatalogoConceptos.getSelectionModel().getSelections();
       				for ( var int = 0; int < arrRegistro.length; int++) {
       					var Conceptos = arrRegistro[int];
       					estructura= Ext.getCmp('estructura').getValue(); 
   						if(validarExistenciaRegistroGrid(Conceptos,gridConceptos,'codconsep','codconsep',true)){
   							var ConceptosInt = new reMovConceptos({
   								'codconsep':'',
   								'denconsep':'',
   								'cancon':'',
   								'monconsepe':'',
   								'spg_cuenta':'',
   								'estructura':estructura,
   								'existecuenta':'',
   							});
   					
   							gridConceptos.store.insert(0,ConceptosInt);
   							ConceptosInt.set('codconsep',Conceptos.get('codconsep'));
   							ConceptosInt.set('denconsep',Conceptos.get('denconsep'));
   							ConceptosInt.set('spg_cuenta', Conceptos.get('spg_cuenta'));
   							ConceptosInt.set('existecuenta', Conceptos.get('existecuenta'));
   							ConceptosInt.set('coduniadm',Ext.getCmp('coduniadm').getValue());
   							ConceptosInt.set('codestpro1',Ext.getCmp('codestpro1').getValue());
   							ConceptosInt.set('codestpro2',Ext.getCmp('codestpro2').getValue());
   							ConceptosInt.set('codestpro3',Ext.getCmp('codestpro3').getValue());
   							ConceptosInt.set('codestpro4',Ext.getCmp('codestpro4').getValue());
   							ConceptosInt.set('codestpro5',Ext.getCmp('codestpro5').getValue());
   							ConceptosInt.set('estcla',Ext.getCmp('estcla').getValue());
   							if(Ext.getCmp('codfuefin').getValue()!=''){
   								ConceptosInt.set('codfuefin',Ext.getCmp('codfuefin').getValue());
   							}
   							else{
   								ConceptosInt.set('codfuefin','--');
   							}
   							cargarCreditosConceptos(codconsep);
   							gridCuentasCreditos.store.removeAll();
   			   		    	gridCuentas.store.removeAll();
   			   		    	gridCuentas.hide();
   			   		    	gridCuentasCreditos.hide();
   			   		    	limpiarFormulario(formVentanaCatalogo);
   			   		    	formVentanaCatalogo.hide();
   						}
       				}
       				function cargarCreditosConceptos(codconsep){
       				var codconsep  = Conceptos.get('codconsep');
        			var codestpro1 = Ext.getCmp('codestpro1').getValue();
       				var codestpro2 = Ext.getCmp('codestpro2').getValue();
       				var codestpro3 = Ext.getCmp('codestpro3').getValue();
       				var codestpro4 = Ext.getCmp('codestpro4').getValue();
       				var codestpro5 = Ext.getCmp('codestpro5').getValue();
       				var estcla = Ext.getCmp('estcla').getValue();
    				obtenerMensaje('procesar','','Buscando Datos');
    				var JSONObject = {
    						'operacion' : 'cargarCargosConceptos',
    						'codconsep'  : codconsep,
    						'codestpro1': codestpro1,
    						'codestpro2': codestpro2,
    						'codestpro3': codestpro3,
    						'codestpro4': codestpro4,
    						'codestpro5': codestpro5,
    						'estcla': estcla
    					}
    					var ObjSon = JSON.stringify(JSONObject);
    					var parametros = 'ObjSon='+ObjSon; 
    					Ext.Ajax.request({
    						url : '../../controlador/sep/sigesp_ctr_sep_solicitud.php',
    						params : parametros,
    						method: 'POST',
    						success: function ( resultado, request){
    							Ext.Msg.hide();
    							var datos = resultado.responseText;
    							var objetoCreditos = eval('(' + datos + ')');
    							if(objetoCreditos!='' || objetoCreditos.raiz!=''){
    								var reCreditos = Ext.data.Record.create([
     							        {name: 'codcar'},
     							        {name: 'dencar'},
     							        {name: 'codigo'},
     							        {name: 'moncar'},
     							        {name: 'basimp'},
     							        {name: 'totcar'},
     							        {name: 'formula'}
     							 	]);
     								var arrdata = objetoCreditos.raiz;
     								
     								for (var i = arrdata.length - 1; i >= 0; i--){
     									var cargo = new reCreditos({
     										'codigo':arrdata[i].codigo,
    										'codcar':arrdata[i].codcar,
    										'dencar':arrdata[i].dencar,
    										'spg_cuenta':arrdata[i].spg_cuenta,
    										'formula':arrdata[i].formula
     									});
     									cargo.set('codestpro1',Ext.getCmp('codestpro1').getValue());
    									cargo.set('codestpro2',Ext.getCmp('codestpro2').getValue());
    									cargo.set('codestpro3',Ext.getCmp('codestpro3').getValue());
    									cargo.set('codestpro4',Ext.getCmp('codestpro4').getValue());
    									cargo.set('codestpro5',Ext.getCmp('codestpro5').getValue());
    									cargo.set('estructura',Ext.getCmp('estructura').getValue());
    									cargo.set('estcla',Ext.getCmp('estcla').getValue());
    									if(Ext.getCmp('codfuefin').getValue()!=''){
    										cargo.set('codfuefin',Ext.getCmp('codfuefin').getValue());
    		   							}
    		   							else{
    		   								cargo.set('codfuefin','--');
    		   							}
     									gridCreditos.store.insert(0,cargo);
     								}
    							}
    							else {
    								Ext.Msg.show({
    									title:'Advertencia',
    									msg: 'No se ha Creditos',
    									buttons: Ext.Msg.OK,
    									icon: Ext.MessageBox.WARNING
    								});  				
    							}
    						}	
    					});
       				}// fin de la funcion cargarCreditosConceptos
    					ventanaConceptos.destroy();
   		    }
   		},{
   			text: 'Salir',
   		    handler:function(){
   			ventanaConceptos.destroy();
   		    }
   		}]
	});
	
	ventanaConceptos.show();
	//--------------------------------------------------------------------------------------------------------------
}	



