
function CatalogoBienes(){
			
	//Creando datastore y columnmodel para el catalogo de bienes
	var reVentana = Ext.data.Record.create([
	   {name: 'codart'}, 
	   {name: 'denart'},
	   {name: 'denunimed'},
	   {name: 'spg_cuenta'},
	   {name: 'existecuenta'},
	   {name: 'unidad'}
	]);
	                                        	
	var dsVentana =  new Ext.data.Store({
	   reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reVentana)
	});
	                                						
	var cmVentana = new Ext.grid.ColumnModel([
	   new Ext.grid.CheckboxSelectionModel(),
	       {header: "<H1 align='center'>Codigo</H1>", width: 20, sortable: true, dataIndex: 'codart'},
	       {header: "<H1 align='center'>Denominacion</H1>", width: 80, sortable: true, dataIndex: 'denart'},
	       {header: "<H1 align='center'>Unidad</H1>", width: 30, sortable: true, dataIndex: 'denunimed'},
	       {header: "<H1 align='center'>Cuenta</H1>", width: 30, sortable: true, dataIndex: 'spg_cuenta'},
	       {header: "<H1 align='center'>Existe</H1>", width: 30, hidden:true, sortable: true, dataIndex: 'existecuenta'}
	       
	]);
	//-------------------------------------------------------------------------------------------------------------------------
	
	//Creando grid para el catalogo de bienes
	var gridVentanaCatalogoBienes = new Ext.grid.GridPanel({
		width:500,
 		height:250,
		frame:true,
		style: 'position:absolute;left:0px;top:150px',
		autoScroll:true,
		border:true,
		ds: dsVentana,
		cm: cmVentana,
		sm:new Ext.grid.CheckboxSelectionModel(),
		stripeRows: true,
		viewConfig: {forceFit:true}
	});
	
	gridVentanaCatalogoBienes.getView().getRowClass = function(record, index){
		if(record.data.existecuenta!='0'){
			return 'celda-azul';
		}
	}
	//-------------------------------------------------------------------------------------------------------------------------		 
	 
	
	//Creacion del combo tipo de bienes
	var reTipBie = Ext.data.Record.create([
		{name:'codtipart'},
		{name:'dentipart'}           
	]);

	var	dsTipBie =  new Ext.data.Store({
		reader: new Ext.data.JsonReader({root: 'raiz', id: "id"},reTipBie)
	});
		
	var myJSONObject = {
		"operacion": 'buscarTipoBienes'
	};	
	
	var ObjSon = JSON.stringify(myJSONObject);
	var parametros = 'ObjSon='+ObjSon; 
	Ext.Ajax.request({
		url : '../../controlador/sep/sigesp_ctr_sep_solicitud.php',
		params : parametros,
		method: 'POST',
		success: function (resultado, request) { 
			var datos = resultado.responseText;  
			if(datos!=''){
				var DatosNuevo = eval('(' + datos + ')');
				dsTipBie.loadData(DatosNuevo);
			}
		}//fin de success
	});//fin de ajax request
	 
	//-------------------------------------------------------------------------------------------------------------------------		 
	 
	//Creacion del formulario del catalogo bienes
	var formVentanaCatalogoBienes = new Ext.FormPanel({
		width: 550,
		height: 450,
		frame:true,
		autoScroll:false,
		items: [{
			xtype:"fieldset", 
		    title:'Datos del Artculo',
		    style: 'position:absolute;left:15px;top:10px',
			border:true,
			width: 500,
			cls:'fondo',
			height: 140,
			items:[{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:20px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Codigo',
						name: 'codigo',
						id: 'codart',									
						width: 100,
						changeCheck: function(){
							var textvalor = this.getValue();
							dsVentana.filter('codart',textvalor,true);
								if(String(textvalor) !== String(this.startValue)){
									this.fireEvent('change', this, textvalor, this.startValue);
								} 
						}, 
						initEvents: function(){
							AgregarKeyPress(this);
						}
					}]
				}]
     		},
     		{
     			layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:50px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 100,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Denominacion',
						name: 'denominacion',
						id: 'denart',
						width: 350,
						changeCheck: function(){
							var textvalor = this.getValue();
							dsVentana.filter('denart',textvalor,true);
							if(String(textvalor) !== String(this.startValue)){
								this.fireEvent('change', this, textvalor, this.startValue);
							} 
						}, 
						initEvents: function(){
							AgregarKeyPress(this);
						}
					}]
				}]
     		},
     		{
     			layout: "column",
				border: false,
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:80px',
				items: [{
					layout: "form",
 					border: false,
 					labelWidth: 100,			
 					items: [{
 						xtype:"combo",
 			        	store: dsTipBie,
 			        	labelSeparator :'',
 			        	valueField: 'codtipart',
 			        	displayField: 'dentipart', 
 			        	id:"codtipart",
 			        	typeAhead: true,
 			        	mode: 'local',
				        triggerAction: 'all',
				        fieldLabel:'Tipo',
				   	    listWidth:200,
				   	    editable:false,
				        width:200,
				        binding:true,
						hiddenvalue:'',
						defaultvalue:''
 		    		}]
         		}]
       		 },
       		 {
       			layout:"column",
		   		defaults: {border: false},
		   		style: 'position:absolute;left:420px;top:100px', 
		   		border:false,
		   		items:[{
		   			layout:"form",
		   			border:false,
		   			items:[{
		   				xtype: 'button',
		   				fieldLabel: '',
		   				text: 'Buscar',
		   				id: 'btagregar',
		   				iconCls: 'menubuscar',
		   				handler: function(){
		   					obtenerMensaje('procesar','','Buscando Datos');	
		   					//buscar bienes
		   					var tipobien = "";
		   					if(Ext.getCmp('tipsepbie').items.items[0].checked){
		   						tipobien = "M";
		   					}
		   					if(Ext.getCmp('tipsepbie').items.items[1].checked){
		   						tipobien = "A";
		   					}
		   					var codart     = Ext.getCmp('codart').getValue();			   			
			   				var denart     = Ext.getCmp('denart').getValue();
			   				var codtipart  = Ext.getCmp('codtipart').getValue();
			   				var codestpro1 = Ext.getCmp('codestpro1').getValue();
			   				var codestpro2 = Ext.getCmp('codestpro2').getValue();
			   				var codestpro3 = Ext.getCmp('codestpro3').getValue();
			   				var codestpro4 = Ext.getCmp('codestpro4').getValue();
			   				var codestpro5 = Ext.getCmp('codestpro5').getValue();
			   				var estcla     = Ext.getCmp('estcla').getValue();	
			
			   				var JSONObject = {
			   					'operacion'  : 'buscarBienes',
			   					'codart'     : codart,
			   					'denart'     : denart,
			   					'codtipart'  : codtipart,
			   					'tipobien'   : tipobien,   
			   				    'codestpro1' : codestpro1,
			   				    'codestpro2' : codestpro2,
			   				    'codestpro3' : codestpro3,
			   				    'codestpro4' : codestpro4,
			   				    'codestpro5' : codestpro5,
			   				    'estcla'     : estcla,
			   				}
	   				
			   				var ObjSon = JSON.stringify(JSONObject);
			   				var parametros = 'ObjSon='+ObjSon; 
			   				Ext.Ajax.request({
			   					url : '../../controlador/sep/sigesp_ctr_sep_solicitud.php',
			   					params : parametros,
			   					method: 'POST',
			   					success: function ( resultado, request){
			   						Ext.Msg.hide();
			   						var datos = resultado.responseText;
			   						var objBienes = eval('(' + datos + ')');
			   						if(objBienes!=''){
			   							if(objBienes!='0'){
			   								if(objBienes.raiz == null || objBienes.raiz ==''){
			   									Ext.MessageBox.show({
								 					title:'Advertencia',
								 					msg:'No existen datos para mostrar',
								 					buttons: Ext.Msg.OK,
								 					icon: Ext.MessageBox.WARNING
								 				});
											}
											else{
			   									gridVentanaCatalogoBienes.store.loadData(objBienes);
			   								}
			   							}
			   							else{
			   								Ext.MessageBox.show({
								 				title:'Advertencia',
								 				msg:'Debe configurar en Empresa los digitos de los bienes',
								 				buttons: Ext.Msg.OK,
								 				icon: Ext.MessageBox.WARNING
								 			});
			   							}
			   						}
			   					}	
			   				});
		   		        }
		   			}]
		   		}]
   			},
   			gridVentanaCatalogoBienes]  
    	}]   
	});
	//fin del formulario 
	//-------------------------------------------------------------------------------------------------------------	
	
	//Creando la ventana del catalogo bienes
	var ventanaBienes = new Ext.Window({
		title: "<H1 align='center'>Cat&#225;logo de Bienes y Materiales</H1>",
        width:560,
        height:520,
        modal: false,
        closable:false,
        plain: false,
        frame:true,
        items:[formVentanaCatalogoBienes],
		buttons: [{
			text:'Aceptar',  
			handler: function(){			
				var reMovBienes = Ext.data.Record.create([
					{name: 'codart'}, 
					{name: 'denart'},
					{name: 'canart'},
					{name: 'spg_cuenta'},
					{name: 'estructura'},
					{name: 'existecuenta'},
					{name: 'unidad'}
				]);
				
	        	var arrRegistro = gridVentanaCatalogoBienes.getSelectionModel().getSelections();
				
				for ( var int = 0; int < arrRegistro.length; int++) {
					var cuenta = arrRegistro[int].get('spg_cuenta');
    				estructura= Ext.getCmp('estructura').getValue(); 
					var bienes = arrRegistro[int];
    			
					if(validarExistenciaRegistroGrid(bienes,gridBienes,'codart','codart',true)){
						var bienesInt = new reMovBienes({
							'codart':'',
							'denart':'',
							'canart':'',
							'preart':'',
							'modalidad':'',
							'spg_cuenta':'',
							'estructura':estructura,
							'existecuenta':'',
							'unidad':''
						});
						gridBienes.store.insert(0,bienesInt);
						bienesInt.set('codart',bienes.get('codart'));
						bienesInt.set('denart',bienes.get('denart'));
						bienesInt.set('denunimed', bienes.get('denunimed'));
						bienesInt.set('modalidad', bienes.get('modalidad'));
						bienesInt.set('spg_cuenta', bienes.get('spg_cuenta'));
						bienesInt.set('modalidad', 'D');
						bienesInt.set('unidad', bienes.get('unidad'));
						bienesInt.set('existecuenta', bienes.get('existecuenta'));
						bienesInt.set('coduniadm',Ext.getCmp('coduniadm').getValue());
						bienesInt.set('codestpro1',Ext.getCmp('codestpro1').getValue());
						bienesInt.set('codestpro2',Ext.getCmp('codestpro2').getValue());
						bienesInt.set('codestpro3',Ext.getCmp('codestpro3').getValue());
						bienesInt.set('codestpro4',Ext.getCmp('codestpro4').getValue());
						bienesInt.set('codestpro5',Ext.getCmp('codestpro5').getValue());
						bienesInt.set('estcla',Ext.getCmp('estcla').getValue());
						if(Ext.getCmp('codfuefin').getValue()!=''){
							bienesInt.set('codfuefin',Ext.getCmp('codfuefin').getValue());
						}
						else{
							bienesInt.set('codfuefin','--');
						}
						//bienesInt.set('estructura', bienes.get('estructura'));
		    		    cargarCreditosBienes(codart);
		    		   // cargarcuenta(spg_cuenta);
		    		    gridCuentasCreditos.store.removeAll();
						gridCuentas.store.removeAll();
						gridCuentas.hide();
						gridCuentasCreditos.hide();
						limpiarFormulario(formVentanaCatalogo);
						formVentanaCatalogo.hide();
		    		   
					}
					
				}

    			function cargarCreditosBienes(codart){
    				var codart  = bienes.get('codart');    	
    				var spg_cuenta  = bienes.get('spg_cuenta');  
    				var codestpro1 = Ext.getCmp('codestpro1').getValue();
    				var codestpro2 = Ext.getCmp('codestpro2').getValue();
    				var codestpro3 = Ext.getCmp('codestpro3').getValue();
    				var codestpro4 = Ext.getCmp('codestpro4').getValue();
    				var codestpro5 = Ext.getCmp('codestpro5').getValue();
    				var estcla = Ext.getCmp('estcla').getValue();
    				obtenerMensaje('procesar','','Buscando Datos');
    				var JSONObject = {
						'operacion' : 'cargarCargosArticulos',
						'codart'    : codart,
						'codestpro1': codestpro1,
						'codestpro2': codestpro2,
						'codestpro3': codestpro3,
						'codestpro4': codestpro4,
						'codestpro5': codestpro5,
						'estcla'    : estcla
						
					}
					var ObjSon = JSON.stringify(JSONObject);
					var parametros = 'ObjSon='+ObjSon; 
					Ext.Ajax.request({
						url : '../../controlador/sep/sigesp_ctr_sep_solicitud.php',
						params : parametros,
						method: 'POST',
						success: function ( resultado, request){
							Ext.Msg.hide();
							var datos = resultado.responseText;
							var objetoCreditos = eval('(' + datos + ')');
							if(objetoCreditos!='' || objetoCreditos.raiz!=''){
								var reCreditos = Ext.data.Record.create([
							        {name: 'codcar'},
							 		{name: 'dencar'},
							 		{name: 'codigo'},
							 		{name: 'moncar'},
							 		{name: 'basimp'},
							 		{name: 'totcar'},
							 		{name: 'formula'}
							 		//{name: 'spg_cuenta'}
							 	]);
								var arrdata = objetoCreditos.raiz;
								
								for (var i = arrdata.length - 1; i >= 0; i--){
									var cargo = new reCreditos({
										'codigo':arrdata[i].codigo,
										'codcar':arrdata[i].codcar,
										'dencar':arrdata[i].dencar,
										'spg_cuenta':arrdata[i].spg_cuenta,
										'formula':arrdata[i].formula,
									});
									cargo.set('codestpro1',Ext.getCmp('codestpro1').getValue());
									cargo.set('codestpro2',Ext.getCmp('codestpro2').getValue());
									cargo.set('codestpro3',Ext.getCmp('codestpro3').getValue());
									cargo.set('codestpro4',Ext.getCmp('codestpro4').getValue());
									cargo.set('codestpro5',Ext.getCmp('codestpro5').getValue());
									cargo.set('estructura',Ext.getCmp('estructura').getValue());
									cargo.set('estcla',Ext.getCmp('estcla').getValue());
									if(Ext.getCmp('codfuefin').getValue()!=''){
										cargo.set('codfuefin',Ext.getCmp('codfuefin').getValue());
		   							}
		   							else{
		   								cargo.set('codfuefin','--');
		   							}
									gridCreditos.store.insert(0,cargo);
								}
							}
							else {
								Ext.Msg.show({
									title:'Advertencia',
									msg: 'No se ha Proveedores',
									buttons: Ext.Msg.OK,
									icon: Ext.MessageBox.WARNING
								});  				
							}
						}	
					});
    			}//fin de funcion cargarCreditosBienes
        		ventanaBienes.destroy();
			}
		},
   		{
   			text: 'Salir',
   			handler:function(){
   				ventanaBienes.destroy();
   		    }
   		}]
	});
	
	ventanaBienes.show();
	//--------------------------------------------------------------------------------------------------------------
}	



