<?php
    session_start();   
	header("Pragma: public");
	header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
	header("Cache-Control: private",false);
	if(!array_key_exists("la_logusr",$_SESSION))
	{
		print "<script language=JavaScript>";
		print "close();";
		print "</script>";		
	}
	ini_set('memory_limit','512M');
	ini_set('max_execution_time','0');

	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_insert_seguridad($as_titulo)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_insert_seguridad
		//		   Access: private 
		//	    Arguments: as_titulo // Titulo del Reporte
		//    Description: funcion que guarda la seguridad de quien genero el reporte
		//	   Creado Por: Ing. Yesenia Moreno
		// Fecha Creacion: 22/09/2006 
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_fun_scf;
		
		$ls_descripcion="Genero el Reporte ".$as_titulo;
		$lb_valido=$io_fun_scf->uf_load_seguridad_reporte("SCF","sigesp_vis_scf_reporte_MayorAnalitico.html",$ls_descripcion);
		return $lb_valido;
	}
	//-----------------------------------------------------------------------------------------------------------------------------------

	//--------------------------------------------------------------------------------------------------------------------------------
	function uf_print_encabezado_pagina($as_titulo,$io_pdf)
	{
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_encabezadopagina
		//		    Acess: private
		//	    Arguments: as_titulo // Titulo del Reporte
		//	    		   as_periodo_comp // Descripcion del periodo del comprobante
		//	    		   as_fecha_comp // Descripcion del periodo de la fecha del comprobante
		//	    		   io_pdf // Instancia de objeto pdf
		//    Description: funcion que imprime los encabezados por pagina
		//	   Creado Por: Ing.Yozelin 
		// Fecha Creacion: 21/04/2006
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
		$io_encabezado=$io_pdf->openObject();
		$io_pdf->saveState();
		$io_pdf->line(10,40,578,40);
		$io_pdf->addJpegFromFile('../../../shared/imagebank/'.$_SESSION["ls_logo"],25,710,$_SESSION["ls_width"],$_SESSION["ls_height"]); // Agregar Logo
		$li_tm=$io_pdf->getTextWidth(10,$as_titulo);
		$tm=306-($li_tm/2);
		$io_pdf->addText($tm,720,10,$as_titulo); // Agregar el titulo
		$io_pdf->addText(500,750,8,date("d/m/Y")); // Agregar la Fecha
		$io_pdf->addText(506,743,7,date("h:i a")); // Agregar la hora
		$io_pdf->restoreState();
		$io_pdf->closeObject();
		$io_pdf->addObject($io_encabezado,'all');
	}// end function uf_print_encabezadopagina
	//--------------------------------------------------------------------------------------------------------------------------------

	//--------------------------------------------------------------------------------------------------------------------------------
	function uf_print_cabecera($as_cuenta,$as_denominacion,$ad_saldo_ant,$io_pdf)
	{
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_cabecera
		//		   Access: private
		//	    Arguments: as_cuenta // cuenta
		//	    		   as_denominacion // denominacion
		//	    		   io_pdf // Objeto PDF
		//    Description: funcion que imprime la cabecera de cada pagina
		//	   Creado Por: Ing.Yozelin 
		// Fecha Creacion: 18/05/2006
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $ls_bolivares;
		global $io_pdf;
		
		$la_data=array(array('name'=>'<b>Cuenta</b> '.$as_cuenta.'  -----  '.$as_denominacion.''),
		               array('name'=>'<b>Saldo Anterior '.$ls_bolivares.'</b> '.$ad_saldo_ant.' '));
		$la_columna=array('name'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'showLines'=>1, // Mostrar Lineas
						 'fontSize' => 7, // Tamaño de Letras
						 'shaded'=>0, // Sombra entre lineas
						 'shadeCol'=>array(0.9,0.9,0.9),
						 'shadeCo2'=>array(0.9,0.9,0.9),
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'xPos'=>305, // Orientacion de la tabla
						 'width'=>550, // Ancho de la tabla
						 'maxWidth'=>550); // Ancho Maximo de la tabla
		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);
	}// end function uf_print_cabecera
	//--------------------------------------------------------------------------------------------------------------------------------

	//--------------------------------------------------------------------------------------------------------------------------------
	function uf_print_detalle($la_data,$io_pdf)
	{
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_detalle
		//		    Acess: private
		//	    Arguments: la_data // arreglo de informacion
		//	   			   io_pdf // Objeto PDF
		//    Description: funcion que imprime el detalle
		//	   Creado Por: Ing.Yozelin 
		// Fecha Creacion: 18/05/2006
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;

		$la_config=array('showHeadings'=>1, // Mostrar encabezados
						 'fontSize' => 6, // Tamaño de Letras
						 'titleFontSize' => 7,  // Tamaño de Letras de los titulos
						 'showLines'=>0, // Mostrar Lineas
						 'shaded'=>0, // Sombra entre lineas
						 'colGap'=>0, // separacion entre tablas
						 'width'=>550, // Ancho de la tabla
						 'maxWidth'=>550, // Ancho Maximo de la tabla
						 'xPos'=>299, // Orientacion de la tabla
						 'cols'=>array('procede'=>array('justification'=>'center','width'=>30), // Justificacion y ancho de la columna
						 			   'comprobante'=>array('justification'=>'center','width'=>55), // Justificacion y ancho de la columna
						 			   'concepto'=>array('justification'=>'left','width'=>125), // Justificacion y ancho de la columna
									   'nombre'=>array('justification'=>'left','width'=>75), // Justificacion y ancho de la columna
						 			   'documento'=>array('justification'=>'center','width'=>55), // Justificacion y ancho de la columna
						 			   'fecha'=>array('justification'=>'center','width'=>40), // Justificacion y ancho de la columna
						 			   'debe'=>array('justification'=>'right','width'=>60), // Justificacion y ancho de la columna
						 			   'haber'=>array('justification'=>'right','width'=>60), // Justificacion y ancho de la columna
									   'saldo'=>array('justification'=>'right','width'=>60))); // Justificacion y ancho de la columna

		$la_columnas=array('procede'=>'<b>Procede</b>',
						   'comprobante'=>'<b>Comprobante</b>',
						   'concepto'=>'<b>Concepto</b>',
						   'nombre'=>'<b>Beneficiario</b>',
						   'documento'=>'<b>Documento</b>',
						   'fecha'=>'<b>Fecha</b>',
						   'debe'=>'<b>Debe</b>',
						   'haber'=>'<b>Haber</b>',
						   'saldo'=>'<b>Saldo Actual</b>');
		$io_pdf->ezTable($la_data,$la_columnas,'',$la_config);
	}// end function uf_print_detalle
	//--------------------------------------------------------------------------------------------------------------------------------

	//--------------------------------------------------------------------------------------------------------------------------------
	function uf_print_pie_cabecera($ad_totaldebe,$ad_totalhaber,$ad_totalsaldo,$io_pdf)
	{
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function : uf_print_pie_cabecera
		//		    Acess : private
		//	    Arguments : ad_total // Total General
		//    Description : funcion que imprime el fin de la cabecera de cada pagina
		//	   Creado Por: Ing.Yozelin 
		// Fecha Creacion: 18/05/2006
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $ls_bolivares;
		global $io_pdf;
		
		$la_data=array(array('name'=>'-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------'));
		$la_columna=array('name'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 7, // Tamaño de Letras
						 'showLines'=>0, // Mostrar Lineas
						 'shaded'=>0, // Sombra entre lineas
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'xPos'=>310, // Orientacion de la tabla
						 'width'=>550); // Ancho Maximo de la tabla
		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);
		$la_data=array(array('total'=>'<b><i>Total '.$ls_bolivares.' </i></b>','debe'=>$ad_totaldebe,'haber'=>$ad_totalhaber,'saldo'=>$ad_totalsaldo));
		$la_columna=array('total'=>'','debe'=>'','haber'=>'','saldo'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 7, // Tamaño de Letras
						 'showLines'=>0, // Mostrar Lineas
						 'shaded'=>0, // Sombra entre lineas
						 'width'=>550, // Ancho Maximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'xPos'=>305, // Orientacion de la tabla
				 		 'cols'=>array('total'=>array('justification'=>'right','width'=>375), // Justificacion y ancho de la columna
						 			   'debe'=>array('justification'=>'right','width'=>60), // Justificacion y ancho de la columna
						 			   'haber'=>array('justification'=>'right','width'=>60), // Justificacion y ancho de la columna
									   'saldo'=>array('justification'=>'right','width'=>60))); // Justificacion y ancho de la columna

		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);
		$la_data=array(array('name'=>''));
		$la_columna=array('name'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'showLines'=>0, // Mostrar Lineas
						 'shaded'=>0, // Sombra entre lineas
						 'width'=>530, // Ancho Maximo de la tabla
						 'xOrientation'=>'center'); // Orientacion de la tabla
		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);
	}// end function uf_print_pie_cabecera
	//--------------------------------------------------------------------------------------------------------------------------------

	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_init_niveles()
	{	///////////////////////////////////////////////////////////////////////////////////////////////////////
		//	   Function: uf_init_niveles
		//	     Access: public
		//	    Returns: vacio	 
		//	Description: Este metodo realiza una consulta a los formatos de las cuentas
		//               para conocer los niveles de la escalera de las cuentas contables  
		//////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_funciones,$ia_niveles_scf;
		
		$ls_formato=""; $li_posicion=0; $li_indice=0;
		$dat_emp=$_SESSION["la_empresa"];
		//contable
		$ls_formato = trim($dat_emp["formcont"])."-";
		$li_posicion = 1 ;
		$li_indice   = 1 ;
		$li_posicion = $io_funciones->uf_posocurrencia($ls_formato, "-" , $li_indice ) - $li_indice;
		do
		{
			$ia_niveles_scf[$li_indice] = $li_posicion;
			$li_indice   = $li_indice+1;
			$li_posicion = $io_funciones->uf_posocurrencia($ls_formato, "-" , $li_indice ) - $li_indice;
		} while ($li_posicion>=0);
	}// end function uf_init_niveles
	//-----------------------------------------------------------------------------------------------------------------------------------

	require_once("../../../shared/ezpdf/class.ezpdf.php");
	require_once("../../../shared/class_folder/class_funciones.php");
	$io_funciones=new class_funciones();
	require_once("../../../shared/class_folder/class_fecha.php");
	$io_fecha = new class_fecha();
	require_once("class_funciones_scf.php");
	$io_fun_scf=new class_funciones_scf("../../../");
	$ls_tiporeporte="0";
	$ls_bolivares="";
	if (array_key_exists("tiporeporte",$_GET))
	{
		$ls_tiporeporte=$_GET["tiporeporte"];
	}
	switch($ls_tiporeporte)
	{
		case "0":
			require_once("sigesp_scf_class_report.php");
			$io_report  = new sigesp_scf_class_report();
			$ls_bolivares ="Bs.";
			break;
	
		case "1":
			require_once("sigesp_scf_class_report.php");
			$io_report  = new sigesp_scf_class_report();
			$ls_bolivares ="Bs.";
			break;
	}
	$ia_niveles_scf[0]="";			
	uf_init_niveles();
	$li_total=count($ia_niveles_scf)-1;
	//--------------------------------------------------  Parametros para Filtar el Reporte  -----------------------------------------
	$ld_fecdes=$_GET["fecdes"];
	$ld_fechas=$_GET["fechas"];
	$ls_cuentadesde=$_GET["cuentadesde"];
	$ls_cuentahasta=$_GET["cuentahasta"];
	$ls_orden=$_GET["orden"];
	//----------------------------------------------------  Parametros del encabezado  -----------------------------------------------
	$ldt_fecha="<b> Desde   ".$ld_fecdes."   al   ".$ld_fechas." </b>" ;
	$ls_titulo="<b> Mayor  Analitico</b>  ".$ldt_fecha;       
	//--------------------------------------------------------------------------------------------------------------------------------
    // Cargar el dts_cab con los datos de la cabecera del reporte( Selecciono todos comprobantes )	
	$lb_valido=uf_insert_seguridad("<b>Mayor Analítico en PDF</b>"); // Seguridad de Reporte
	if($lb_valido)
	{
		 $lb_valido=$io_report->uf_mayoranalitico($ld_fecdes,$ld_fechas,$ls_cuentadesde,$ls_cuentahasta,$ls_orden);
	}
	 if($lb_valido==false) // Existe algun error o no hay registros
	 {
		print("<script language=JavaScript>");
		print(" alert('No hay nada que Reportar');"); 
		print(" close();");
		print("</script>");
	 }
	 else // Imprimimos el reporte
	 {
		$io_pdf=new Cezpdf('LETTER','portrait'); // Instancia de la clase PDF
		$io_pdf->selectFont('../../../shared/ezpdf/fonts/Helvetica.afm'); // Seleccionamos el tipo de letra
		$io_pdf->ezSetCmMargins(3.5,3,3,3); // Configuracion de los margenes en centimetros
		uf_print_encabezado_pagina($ls_titulo,$io_pdf); // Imprimimos el encabezado de la pagina
		$io_pdf->ezStartPageNumbers(550,50,10,'','',1); // Insertar el numero de pagina
		$io_report->DS->group_noorder("sc_cuenta");
		$li_totrow=$io_report->DS->getRowCount("sc_cuenta");
		$ld_totaldebe=0;
		$ld_totalhaber=0;
		$ld_totalsaldo=0;
        $ld_saldo=0;
		$ldec_mondeb=0;
        $ldec_monhab=0;
		for($li_i=1;$li_i<=$li_totrow;$li_i++)
		{
		    $li_tmp=($li_i+1);
		    $io_pdf->transaction('start'); // Iniciamos la transaccion
			$thisPageNum=$io_pdf->ezPageCount;
			$ls_comprobante=$io_report->DS->getValue("comprobante",$li_i);
			$ls_cuenta=trim($io_report->DS->getValue("sc_cuenta",$li_i));
		    if ($li_i<$li_totrow)
		    {
				$ls_cuenta_next=trim($io_report->DS->getValue("sc_cuenta",$li_tmp));
		    }
		    elseif($li_i=$li_totrow)
		    {
				$ls_cuenta_next='no_next';
		    }
			if(!empty($ls_cuenta))
			{
			  $ls_cuenta_ant=trim($io_report->DS->getValue("sc_cuenta",$li_i));
			}
			$ls_denominacion=$io_report->DS->getValue("denominacion",$li_i);

			$ls_codpro=$io_report->DS->getValue("cod_pro",$li_i);
			$ls_cedbene=$io_report->DS->getValue("ced_bene",$li_i);
			$ls_nompro=$io_report->DS->getValue("nompro",$li_i);
			$ls_nombene=$io_report->DS->getValue("apebene",$li_i).", ".$io_report->DS->getValue("nombene",$li_i);
			$ls_nombre="";
			if($ls_codpro!="----------")
			{
				$ls_nombre=$ls_nompro;
			}			
			if($ls_cedbene!="----------")
			{
				$ls_nombre=$ls_nombene;
			}			
			$ls_documento=$io_report->DS->getValue("documento",$li_i);
			$ls_procede=$io_report->DS->getValue("procede",$li_i);
			$ls_concepto=$io_report->DS->getValue("descripcion",$li_i);
			$ldec_monto=$io_report->DS->getValue("monto",$li_i);
			$fecmov=$io_report->DS->getValue("fecha",$li_i);
			$ld_fecmov=$io_funciones->uf_convertirfecmostrar($fecmov);
			$ls_debhab=$io_report->DS->getValue("debhab",$li_i);
			$ld_saldo_ant=$io_report->DS->getValue("saldo_ant",$li_i);
			if($ls_debhab=='D')
			{
				$ldec_mondeb=$ldec_monto;
				$ldec_monhab=0;		
				$ld_totaldebe=$ld_totaldebe+$ldec_mondeb;
			}
			elseif($ls_debhab=='H')
			{
				$ldec_monhab=$ldec_monto;		
				$ldec_mondeb=0;
				$ld_totalhaber=$ld_totalhaber+$ldec_monhab;
			}
			if (!empty($ls_cuenta))
			{
			  $ld_saldo=$ld_saldo_ant+$ldec_mondeb-$ldec_monhab;
			}
			else
			{
				if($ls_debhab=='D')
				{
					$ld_saldo=$ld_saldo+$ldec_monto;
				}
				elseif($ls_debhab=='H')
				{
					$ld_saldo=$ld_saldo-$ldec_monto;
				}
			}
			if (!empty($ls_cuenta))
		    {
				$ldec_mondeb=abs($ldec_mondeb);
				$ldec_monhab=abs($ldec_monhab);
				
				$ldec_mondeb=number_format($ldec_mondeb,2,",",".");
				$ldec_monhab=number_format($ldec_monhab,2,",",".");
				if($ld_saldo<0)
				{
				  $ld_saldo_aux=abs($ld_saldo); 
				  $ld_saldo_aux=number_format($ld_saldo_aux,2,",",".");
				  $ld_saldo_final="(".$ld_saldo_aux.")";
				}
				else
				{
				  $ld_saldo_aux=number_format($ld_saldo,2,",",".");
				  $ld_saldo_final=$ld_saldo_aux;
				}
				$la_data[$li_i]=array('procede'=>$ls_procede,'comprobante'=>$ls_comprobante,'concepto'=>$ls_concepto,
								   'nombre'=>$ls_nombre,'documento'=>$ls_documento,'fecha'=>$ld_fecmov,'debe'=>$ldec_mondeb,
								   'haber'=>$ldec_monhab,'saldo'=>$ld_saldo_final);
			   
				$ldec_mondeb=str_replace('.','',$ldec_mondeb);
				$ldec_mondeb=str_replace(',','.',$ldec_mondeb);		
				$ldec_monhab=str_replace('.','',$ldec_monhab);
				$ldec_monhab=str_replace(',','.',$ldec_monhab);		
			}
			else
			{
				$ldec_mondeb=abs($ldec_mondeb);
				$ldec_monhab=abs($ldec_monhab);
				
				$ldec_mondeb=number_format($ldec_mondeb,2,",",".");
				$ldec_monhab=number_format($ldec_monhab,2,",",".");
				
				if($ld_saldo<0)
				{
				  $ld_saldo_aux=abs($ld_saldo); 
				  $ld_saldo_aux=number_format($ld_saldo_aux,2,",",".");
				  $ld_saldo_final="(".$ld_saldo_aux.")";
				}
				else
				{
				  $ld_saldo_aux=number_format($ld_saldo,2,",",".");
				  $ld_saldo_final=$ld_saldo_aux;
				}
				$la_data[$li_i]=array('procede'=>$ls_procede,'comprobante'=>$ls_comprobante,'concepto'=>$ls_concepto,
								   'nombre'=>$ls_nombre,'documento'=>$ls_documento,'fecha'=>$ld_fecmov,'debe'=>$ldec_mondeb,
								   'haber'=>$ldec_monhab,'saldo'=>$ld_saldo_final);
			   
				$ldec_mondeb=str_replace('.','',$ldec_mondeb);
				$ldec_mondeb=str_replace(',','.',$ldec_mondeb);		
				$ldec_monhab=str_replace('.','',$ldec_monhab);
				$ldec_monhab=str_replace(',','.',$ldec_monhab);		
			}
			if (!empty($ls_cuenta_next))
			{
				$ldec_mondeb=abs($ldec_mondeb);
				$ldec_monhab=abs($ldec_monhab);
				$ldec_mondeb=number_format($ldec_mondeb,2,",",".");
				$ldec_monhab=number_format($ldec_monhab,2,",",".");
				if($ld_saldo<0)
				{
				  $ld_saldo_aux=abs($ld_saldo); 
				  $ld_saldo_aux=number_format($ld_saldo_aux,2,",",".");
				  $ld_saldo_final="(".$ld_saldo_aux.")";
				}
				else
				{
				  $ld_saldo_aux=number_format($ld_saldo,2,",",".");
				  $ld_saldo_final=$ld_saldo_aux;
				}
				$la_data[$li_i]=array('procede'=>$ls_procede,'comprobante'=>$ls_comprobante,'concepto'=>$ls_concepto,
								   'nombre'=>$ls_nombre,'documento'=>$ls_documento,'fecha'=>$ld_fecmov,'debe'=>$ldec_mondeb,
								   'haber'=>$ldec_monhab,'saldo'=>$ld_saldo_final);
				$ld_saldo_ant=number_format($ld_saldo_ant,2,",",".");
				$ld_saldo_anterior=$ld_saldo_ant;
					$li_totfil=0;
					$as_cuenta="";
					for($li=$li_total;$li>1;$li--)
					{
						$li_ant=$ia_niveles_scf[$li-1];
						$li_act=$ia_niveles_scf[$li];
						$li_fila=$li_act-$li_ant;
						$li_len=strlen($ls_cuenta_ant);
						$li_totfil=$li_totfil+$li_fila;
						$li_inicio=$li_len-$li_totfil;
						if($li==$li_total)
						{
							$as_cuenta=substr($ls_cuenta_ant,$li_inicio,$li_fila);
						}
						else
						{
							$as_cuenta=substr($ls_cuenta_ant,$li_inicio,$li_fila)."-".$as_cuenta;
						}
					}
					$li_fila=$ia_niveles_scf[1]+1;
					$as_cuenta=substr($ls_cuenta_ant,0,$li_fila)."-".$as_cuenta;


			    uf_print_cabecera($as_cuenta,$ls_denominacion,$ld_saldo_ant,$io_pdf);
				uf_print_detalle($la_data,$io_pdf); // Imprimimos el detalle 
			  	$ld_totalsaldo_final=$ld_saldo_final;
				if($ld_totaldebe<0)
				{
			       $ld_totaldebe_aux=abs($ld_totaldebe);
				   $ld_totaldebe_aux=number_format($ld_totaldebe_aux,2,",",".");
				   $ld_totaldebe="(".$ld_totaldebe_aux.")";
				}
				else
				{
				  $ld_totaldebe=number_format($ld_totaldebe,2,",",".");
				}
				if($ld_totalhaber<0)
				{
			       $ld_totalhaber_aux=abs($ld_totalhaber);
				   $ld_totalhaber_aux=number_format($ld_totalhaber_aux,2,",",".");
				   $ld_totalhaber="(".$ld_totalhaber_aux.")";
				}
				else
				{
				  $ld_totalhaber=number_format($ld_totalhaber,2,",",".");
				}
				uf_print_pie_cabecera($ld_totaldebe,$ld_totalhaber,$ld_totalsaldo_final,$io_pdf);
				$ld_totalde=$ld_totaldebe;
				$ld_totalha=$ld_totalhaber;
				$ld_totalsal=$ld_totalsaldo_final;
				$ld_totaldebe=0;
				$ld_totalhaber=0;
				if ($io_pdf->ezPageCount==$thisPageNum)
				{// Hacemos el commit de los registros que se desean imprimir
					$io_pdf->transaction('commit');
				}
				elseif($thisPageNum>1)
				{// Hacemos un rollback de los registros, agregamos una nueva pagina y volvemos a imprimir
					$io_pdf->transaction('rewind');
					$io_pdf->ezNewPage(); // Insertar una nueva pagina
					uf_print_cabecera($as_cuenta,$ls_denominacion,$ld_saldo_anterior,$io_pdf);
					uf_print_detalle($la_data,$io_pdf); // Imprimimos el detalle 
                    uf_print_pie_cabecera($ld_totalde,$ld_totalha,$ld_totalsal,$io_pdf);
				}
				else
				{
					$io_pdf->transaction('commit');
				}
			    unset($la_data);			
			}//if
	    }//for
			
		$io_pdf->ezStopPageNumbers(1,1);
		if (isset($d) && $d)
		{
			$ls_pdfcode = $io_pdf->ezOutput(1);
		  	$ls_pdfcode = str_replace("\n","\n<br>",htmlspecialchars($ls_pdfcode));
		  	echo '<html><body>';
		  	echo trim($ls_pdfcode);
		  	echo '</body></html>';
		}
		else
		{
			$io_pdf->ezStream();
		}
		unset($io_pdf);
	}
	unset($io_report);
	unset($io_funciones);
?> 