///**//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// * @FECHA DE CREACION: 09-01-2013
// * @DESARROLLADOR: ING. CARLOS ZAMBRANO
// * @DESARROLLADOR: ING. DOMINGO CALICCHIO
// * @DESCRIPCION: js correspondiente a la vista de transferencias bancarias
///**//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

var frmTransferenciaBancaria = null;  //instancia del formulario de transferencias bancarias
var Actualizar = null;
var ruta ='../../controlador/scb/sigesp_ctr_scb_transferencias.php'; //rutae del controlador
var rutae ='../../controlador/scb/sigesp_ctr_scb_emision_chq.php'; //rutae del controlador
var rutap ='../../controlador/scb/sigesp_ctr_scb_progpago.php'; //rutae del controlador
var operacion_origen='ND';
var operacion_destino='NC';
barraherramienta = true;
Ext.onReady(function()
{
	Ext.QuickTips.init();
	Ext.BLANK_IMAGE_URL = '../../base/librerias/js/ext/resources/images/default/s.gif';
//--------------------------------------------------------------------------------------------------------------------------------	
//**********************************************************************************************************************************	
//                                 				INICIO DEL FORMULARIO DATOS DE ORIGEN
//**********************************************************************************************************************************
	//creando store para la operacion
	var operacion = [ 
					['Cheque','CH'],
					['Nota Dbito','ND'] 
					];	// arreglo que contiene los Documentos que se pueden controlar
	
	var stoperacion = new Ext.data.SimpleStore({
		fields : [ 'etiqueta' , 'valor' ],
		data : operacion
	});
	
	var cmbtipoperacion = new Ext.form.ComboBox({
		store:stoperacion,
		fieldLabel:'Operaci&#243;n',
		labelSeparator:'',
		editable:false,
		emptyText:'--- Seleccione ---',
		displayField:'etiqueta',
		valueField:'valor',
		id:'codope',
		width:150,
		typeAhead:true,
		triggerAction:'all',
		forceselection:true,
		binding:true,
		mode:'local',
		hiddenvalue:'',
		defaultvalue:'',
		listeners: {
					'select': function()
					{
						if (this.getValue() == 'ND')
						{	
							operacion_origen='ND';
							operacion_destino='NC';
							Ext.getCmp('operaciondes').setValue('NC');
							Ext.getCmp('chevou').disable();
							validarOperacion();
						}
						else if (this.getValue() == 'CH')
						{
							operacion_origen='CH';
							operacion_destino='DP';
							Ext.getCmp('operaciondes').setValue('DP');
							Ext.getCmp('chevou').enable();
							validarOperacion();
							llenarVoucher();
						}
					}
				   }
	});
	//fin creando store para el combo tipo operacion
//----------------------------------------------------------------------------------------------------------------------------------
	//Creando el campo de banco origen
	var bancorig = Ext.data.Record.create([
						{name: 'codban'},
						{name: 'nomban'},
						{name: 'codemp'},
						{name: 'dirban'},
						{name: 'telban'},
						{name: 'conban'},
						{name: 'movcon'},
						{name: 'esttesnac'},
						{name: 'codsudeban'}
				]);
	
	var dsbancorig = new Ext.data.Store({
				  	reader: new Ext.data.JsonReader({
				  	root: 'raiz',             
				  	id: "id"},bancorig)
	  			});
						
	var cmbancorig = new Ext.grid.ColumnModel([
          				{header: "<H1 align='center'>C&#243;digo</H1>", width: 20, sortable: true,   dataIndex: 'codban'},
          				{header: "<H1 align='center'>Denominaci&#243;n</H1>", width: 40, sortable: true, dataIndex: 'nomban'}
				]);
	//fin creando datastore y columnmodel para el catalogo de bancos origen
	
	//componente campocatalogo para el campo banco origen
	cmbbancorig = new com.sigesp.vista.comCampoCatalogo({
							titvencat: "<H1 align='center'>Cat&#225;logo de Bancos</H1>",
							id: 'catalogobanco',
							anchoformbus: 450,
							altoformbus:100,
							anchogrid: 450,
							altogrid: 400,
							anchoven: 500,
							altoven: 400,
							datosgridcat: dsbancorig,
							colmodelocat: cmbancorig,
							rutacontrolador:rutap,
//							rutacontrolador:'../../controlador/scb/sigesp_ctr_scb_conciliacion.php',
							parametros: "ObjSon={'operacion': 'catalogo_banco'}",
							arrfiltro:[{etiqueta:'C&#243;digo',id:'codbanorig',valor:'codban'},
									   {etiqueta:'Nombre',id:'nombanorig',valor:'nomban'}],
							posicion:'position:absolute;left:5px;top:35px',
							tittxt:'Banco',
							idtxt:'codban',
							campovalue:'codban',
							anchoetiquetatext:130,
							anchotext:80,
							anchocoltext:0.35,
							idlabel:'nomban',
							labelvalue:'nomban',
							anchocoletiqueta:0.65,
							anchoetiqueta:300,
							tipbus:'L',
							binding:'C',
							hiddenvalue:'',
							defaultvalue:'',
							allowblank:true
				});
	//fin componente para el campo banco origen
//----------------------------------------------------------------------------------------------------------------------------------	
	//Creando el campo de cuentas de bancos origen
	var ctabancorig = Ext.data.Record.create([
						{name: 'ctaban'},
						{name: 'dencta'},
						{name: 'sc_cuenta'},
						{name: 'denominacion'},
						{name: 'nomban'},
						{name: 'codtipcta'},
						{name: 'nomtipcta'},
						{name: 'fecapr'},
						{name: 'feccie'},
						{name: 'estact'},
						{name: 'codban'}
				]);
	
	var dsctabancorig = new Ext.data.Store({
					 	reader: new Ext.data.JsonReader({
					 	root: 'raiz',             
					 	id: "id"},ctabancorig)
	  			});
						
	var cmctabancorig = new Ext.grid.ColumnModel([
          				{header: "<H1 align='center'>C&#243;digo</H1>", width: 30, sortable: true, dataIndex: 'ctaban'},
          				{header: "<H1 align='center'>Denominaci&#243;n</H1>", width: 45, sortable: true, dataIndex: 'dencta'},
						{header: "<H1 align='center'>Tipo</H1>", width: 25, sortable: true, dataIndex: 'nomtipcta' },
						{header: "<H1 align='center'>Contable</H1>", width: 35, sortable: true, dataIndex: 'sc_cuenta'},
						{header: "<H1 align='center'>Descripci&#243;n</H1>", align: 'center', width: 40, sortable: true, dataIndex: 'denominacion'},
						{header: "<H1 align='center'>Apertura</H1>", align: 'center', width: 35, sortable: true, dataIndex: 'fecapr'}
				]);
	//fin creando datastore y columnmodel para el catalogo de cuentas de bancos origen
	
	//componente campocatalogo para el campo cuentas de bancos origen
	cmbctabancorig = new com.sigesp.vista.comCampoCatalogo({
							titvencat: "<H1 align='center'>Cat&#225;logo de Cuentas de Bancos</H1>",
							id:'catalagocuenta',
							anchoformbus: 650,
							altoformbus:130,
							anchogrid: 650,
							altogrid: 400,
							anchoven: 700,
							altoven: 400,
							datosgridcat: dsctabancorig,
							colmodelocat: cmctabancorig,
							rutacontrolador:rutap,
							parametros: "ObjSon={'operacion': 'catalogo_ctabanco'",
							arrfiltro:[{etiqueta:'C&#243;digo',id:'ctabanorig',valor:'ctaban'},
									   {etiqueta:'Nombre',id:'denctaorig',valor:'dencta'}],
							posicion:'position:absolute;left:5px;top:65px',
							tittxt:'Cuenta',
							idtxt:'ctaban',
							campovalue:'ctaban',
							anchoetiquetatext:130,
							anchotext:180,
							anchocoltext:0.35,
							idlabel:'dencta',
							labelvalue:'dencta',
							anchocoletiqueta:0.65,
							anchoetiqueta:300,
							tipbus:'P',
							binding:'C',
							arrtxtfiltro:['codban'],
							hiddenvalue:'',
							defaultvalue:'',
							allowblank:true,
							validarMostrar:1,
							fnValidarMostrar: validarCatalogoBanco,
							msjValidarMostrar: 'Debe seleccionar el Banco asociado a la Cuenta',
							onAceptar:true,
	    					fnOnAceptar:buscarTipoCuenta
				});
	//fin componente para el campo cuentas de bancos origen
//----------------------------------------------------------------------------------------------------------------------------------	  
	var frmDatosOrigen = new Ext.form.FieldSet({ 
		title:"Datos de Origen",
		style: 'position:absolute;left:10px;top:160px',
		border:true,
		width: 915,
		cls :'fondo',
		height: 190,
		items: [{
				style:'position:absolute;left:15px;top:15px',
				layout:"column",
				border:false,
				items: [{
						layout:"form",
						border:false,
						labelWidth:130,
						items: [{
								xtype:"textfield",
								labelSeparator:'',
								fieldLabel:'Documento',
								name:'documento_origen',
								id:'numdocori',			
								width:150,
								binding:true,
								hiddenvalue:'',
								defaultvalue:'',
								allowBlank:true,
								autoCreate:{tag: 'input', type: 'text', size: '15', autocomplete: 'off', maxlength: '15', onkeypress: "return keyRestrict(event,'abcdefghijklmnopqrstuvwxyz ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789');"},
								listeners:{
									'blur' : function(campo)
									{
									llenar_campo_numdoc_origen(campo.getValue());
									}
								}
							}]
					}]
				},
				cmbbancorig.fieldsetCatalogo,
				cmbctabancorig.fieldsetCatalogo,
				{
				style:'position:absolute;left:15px;top:105px',
				layout:"form",
				border:false,
				labelWidth:130,
				items: [{
						xtype:"textfield",
						labelSeparator:'',
						fieldLabel:'Cuenta Contable',
						name:'ctacontorig',
						id:'scg_cuentaori',
						width:150,
						binding:true,
						hiddenvalue:'',
						defaultvalue:'',
						allowBlank:true,
						readOnly:true 
					}]
				},
				{
				style:'position:absolute;left:650px;top:105px',
				layout:"form",
				border:false,
				labelWidth:70,
				items: [{
						xtype:"textfield",
						labelSeparator:'',
						fieldLabel:'Disponible',
						name:'disponible_origen',
						id:'dispori',
						width:150,
						binding:true,
						hiddenvalue:'',
						defaultvalue:'',
						allowBlank:true,
						readOnly:true 
					}]
				},
				{
				style:'position:absolute;left:15px;top:135px',
				layout:"column",
				border:false,
				items: [{
						layout:"form",
						border:false,
						labelWidth:130,
						items: [cmbtipoperacion]
					}]
				},	
				{
				style:'position:absolute;left:650px;top:135px',
				layout:"form",
				border:false,
				labelWidth:70,
				items: [{
						xtype:"textfield",
						labelSeparator:'',
						fieldLabel:'Voucher',
						name:'voucher',
						id:'chevou',
						width:150,
						binding:true,
						hiddenvalue:'',
						defaultvalue:'',
						allowBlank:true,
						readOnly:true,
						listeners:{
						'blur' : function(campo)
						{
						verificarVoucher(campo.getValue());
						}
						}
					}]
				}]
	});
//----------------------------------------------------------------------------------------------------------------------------------
//**********************************************************************************************************************************	
//                                 				INICIO DEL FORMULARIO DATOS DE DESTINO
//**********************************************************************************************************************************
	//Creando el campo de banco destino
	var banco = Ext.data.Record.create([
						{name: 'codban'},
						{name: 'nomban'},
						{name: 'codemp'},
						{name: 'dirban'},
						{name: 'telban'},
						{name: 'conban'},
						{name: 'movcon'},
						{name: 'esttesnac'},
						{name: 'codsudeban'}
				]);
	
	var dsbanco = new Ext.data.Store({
				  	reader: new Ext.data.JsonReader({
				  	root: 'raiz',             
				  	id: "id"},banco)
	  			});
						
	var cmbanco = new Ext.grid.ColumnModel([
          				{header: "<H1 align='center'>C&#243;digo</H1>", width: 20, sortable: true,   dataIndex: 'codban'},
          				{header: "<H1 align='center'>Denominaci&#243;n</H1>", width: 40, sortable: true, dataIndex: 'nomban'}
				]);
	//fin creando datastore y columnmodel para el catalogo de bancos destino
	
	//componente campocatalogo para el campo banco destino
	cmbbanco = new com.sigesp.vista.comCampoCatalogo({
							titvencat: "<H1 align='center'>Cat&#225;logo de Bancos</H1>",
							id: 'catalogobanco',
							anchoformbus: 450,
							altoformbus:100,
							anchogrid: 450,
							altogrid: 400,
							anchoven: 500,
							altoven: 400,
							datosgridcat: dsbanco,
							colmodelocat: cmbanco,
//							rutacontrolador:'../../controlador/scb/sigesp_ctr_scb_conciliacion.php',
							rutacontrolador:rutap,
							parametros: "ObjSon={'operacion': 'catalogo_banco'}",
							arrfiltro:[{etiqueta:'C&#243;digo',id:'codiban',valor:'codban'},
									   {etiqueta:'Nombre',id:'nombban',valor:'nomban'}],
							posicion:'position:absolute;left:5px;top:35px',
							tittxt:'Banco',
							idtxt:'codbandes',
							campovalue:'codban',
							anchoetiquetatext:130,
							anchotext:80,
							anchocoltext:0.35,
							idlabel:'nombandes',
							labelvalue:'nomban',
							anchocoletiqueta:0.65,
							anchoetiqueta:300,
							tipbus:'L',
							binding:'C',
							hiddenvalue:'',
							defaultvalue:'',
							allowblank:true
				});
	//fin componente para el campo banco destino
//----------------------------------------------------------------------------------------------------------------------------------	
//----------------------------------------------------------------------------------------------------------------------------------	
	//Creando el campo de cuentas de bancos destino
	var ctabanco = Ext.data.Record.create([
						{name: 'ctaban'},
						{name: 'dencta'},
						{name: 'sc_cuenta'},
						{name: 'denominacion'},
						{name: 'nomban'},
						{name: 'codtipcta'},
						{name: 'nomtipcta'},
						{name: 'fecapr'},
						{name: 'feccie'},
						{name: 'estact'},
						{name: 'codban'}
				]);
	
	var dsctabanco = new Ext.data.Store({
					 	reader: new Ext.data.JsonReader({
					 	root: 'raiz',             
					 	id: "id"},ctabanco)
	  			});
						
	var cmctabanco = new Ext.grid.ColumnModel([
          				{header: "<H1 align='center'>C&#243;digo</H1>", width: 40, sortable: true, dataIndex: 'ctaban'},
          				{header: "<H1 align='center'>Denominaci&#243;n</H1>", width: 60, sortable: true, dataIndex: 'dencta'},
          				{header: "<H1 align='center'>Banco</H1>", width: 40, sortable: true, dataIndex: 'nomban'},
						{header: "<H1 align='center'>Tipo de Cuenta</H1>", width: 50, sortable: true, dataIndex: 'nomtipcta' },
						{header: "<H1 align='center'>Cuenta Contable</H1>", width: 50, sortable: true, dataIndex: 'sc_cuenta'},
						{header: "<H1 align='center'>Descripci&#243;n</H1>", width: 40, sortable: true, dataIndex: 'denominacion'},
						{header: "<H1 align='center'>Apertura</H1>", width: 35, sortable: true, dataIndex: 'fecapr'}
				]);
	//fin creando datastore y columnmodel para el catalogo de cuentas de bancos destino
	
	//componente campocatalogo para el campo cuentas de bancos destino
	cmbctabanco = new com.sigesp.vista.comCampoCatalogo({
							titvencat: "<H1 align='center'>Cat&#225;logo de Cuentas de Bancos</H1>",
							id:'catalagocuenta',
							anchoformbus: 650,
							altoformbus:130,
							anchogrid: 650,
							altogrid: 400,
							anchoven: 700,
							altoven: 400,
							datosgridcat: dsctabanco,
							colmodelocat: cmctabanco,
							rutacontrolador:rutap,
							parametros: "ObjSon={'operacion': 'catalogo_ctabanco_transf'",
							arrfiltro:[{etiqueta:'C&#243;digo',id:'ctabandest',valor:'ctaban'},
									   {etiqueta:'Nombre',id:'denctadest',valor:'dencta'}],
							posicion:'position:absolute;left:5px;top:65px',
							tittxt:'Cuenta',
							idtxt:'ctabandes',
							campovalue:'ctaban',
							anchoetiquetatext:130,
							anchotext:180,
							anchocoltext:0.45,
							idlabel:'denctades',
							labelvalue:'dencta',
							anchocoletiqueta:0.55,
							anchoetiqueta:300,
							tipbus:'P',
							binding:'C',
							arrtxtfiltro:['codbandes'],
							hiddenvalue:'',
							defaultvalue:'',
							allowblank:true,
							validarMostrar:1,
							fnValidarMostrar: validarCatalogoBanco2,
							msjValidarMostrar: 'Debe seleccionar el Banco asociado a la Cuenta',
							onAceptar:true,
	    					fnOnAceptar:buscarTipoCuentaDes
				});
	//fin componente para el campo cuentas de bancos destino
//----------------------------------------------------------------------------------------------------------------------------------	  
	var frmDatosDestino = new Ext.form.FieldSet({
		title:"Datos de Destino",
		style: 'position:absolute;left:10px;top:360px',
		border:true,
		width: 915,
		cls :'fondo',
		height: 190,
		items: [{
				style:'position:absolute;left:15px;top:15px',
				layout:"column",
				border:false,
				items: [{
						layout:"form",
						border:false,
						labelWidth:130,
						items: [{
								xtype:"textfield",
								labelSeparator:'',
								fieldLabel:'Documento',
								name:'documento_destino',
								id:'numdocdes',			//ID INCORRECTO
								width:150,
								binding:true,
								hiddenvalue:'',
								defaultvalue:'',
								allowBlank:true,
								autoCreate:{tag: 'input', type: 'text', size: '15', autocomplete: 'off', maxlength: '15', onkeypress: "return keyRestrict(event,'abcdefghijklmnopqrstuvwxyz ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789');"},
								listeners:{
									'blur' : function(campo)
									{
									llenar_campo_numdoc_destino(campo.getValue());
									}
								}
							}]
					}]
				},
				cmbbanco.fieldsetCatalogo,
				cmbctabanco.fieldsetCatalogo,
				{
				style:'position:absolute;left:15px;top:105px',
				layout:"form",
				border:false,
				labelWidth:130,
				items: [{
						xtype:"textfield",
						labelSeparator:'',
						fieldLabel:'Cuenta Contable',
						name:'ctacontdest',
						id:'scg_cuentades',
						width:150,
						binding:true,
						hiddenvalue:'',
						defaultvalue:'',
						allowBlank:true,
						readOnly:true 
					}]
				},
				{
				style:'position:absolute;left:650px;top:115px',
				layout:"form",
				border:false,
				labelWidth:70,
				items: [{
						xtype:"textfield",
						labelSeparator:'',
						fieldLabel:'Disponible',
						name:'disponible_destino',
						id:'dispodes', 		
						width:150,
						binding:true,
						hiddenvalue:'',
						defaultvalue:'',
						allowBlank:true,
						readOnly:true 
						}]
				},
				{
				style:'position:absolute;left:15px;top:135px',
				layout:"form",
				border:false,
				labelWidth:130,
				items: [{
						xtype:"textfield",
						labelSeparator:'',
						fieldLabel:'Operaci&#243;n',
						name:'operacion',
						id:'operaciondes', 
						width:150,
						binding:true,
						hiddenvalue:'',
						defaultvalue:'',
						allowBlank:true,
						readOnly:true 
					}]
				}]
	});
//----------------------------------------------------------------------------------------------------------------------------------
//**********************************************************************************************************************************	
//                                 			INICIO DEL FORMULARIO TRANSFERENCIAS BANCARIAS
//**********************************************************************************************************************************
//Creacion del formulario transferencias bancarias
	var Xpos = ((screen.width/2)-(475));
	frmTransferenciaBancaria = new Ext.FormPanel({
		applyTo: 'formulario',
		width: 970,
		height: 515,
		title: "<H1 align='center'>Transferencias Bancarias</H1>",
		frame: true,
		autoScroll: true,
		style: 'position:absolute;margin-left:'+Xpos+'px;margin-top:20px;',
		items: [{
				xtype:"fieldset",
				style: 'position:absolute;left:10px;top:10px',
				border:true,
				width: 915,
				cls :'fondo',
				height: 140,
				items: [{
						style:'position:absolute;left:670px;top:25px',
						layout:"column",
						border:false,
						items: [{
								layout:"form",
								border:false,
								labelWidth:50,
								items: [{
										xtype:"datefield",
										labelSeparator:'',
										fieldLabel:'Fecha',
										name:'fechamov',
										id:'fecmov',
										value: new Date().format('Y-m-d'),
										width:150,
										binding:true,
										hiddenvalue:'',
										defaultvalue:'1900-01-01',
										allowBlank:true,
										autoCreate:{tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789/');"}
									}]
							}]
				},
				{
				style:'position:absolute;left:15px;top:55px',
				layout:"column",
				border:false,
				items: [{
						layout:"form",
						border:false,
						labelWidth:130,
						items: [{
								xtype:"textfield",
								labelSeparator:'',
								fieldLabel:'Concepto Movimiento',
								name:'concepto',
								id:'conmov',
								width:725,
								binding:true,
								hiddenvalue:'',
								defaultvalue:'',
								allowBlank:true,
								autoCreate: {tag: 'input', type: 'text', size: '600', autocomplete: 'off', maxlength: '100', onkeypress: "return keyRestrict(event,'0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ');"}
							}]
					}]
				},
				{	
				style:'position:absolute;left:15px;top:85px',
				layout:"column",
				border:false,
				items: [{
						layout:"form",
						border:false,
						labelWidth:130,
						items: [{
								xtype:"textfield",
								labelSeparator:'',
								fieldLabel:'Monto',
								name:'montomov',
								id:'monto',
								width:150,
								binding:true,
								hiddenvalue:'',
								defaultvalue:'',
								allowBlank:true,
								autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '100', onkeypress: "return keyRestrict(event,'0123456789');"},
								listeners:{
									'blur':function(objeto)
									{
									var numero = objeto.getValue();
									valor = formatoNumericoMostrar(objeto.getValue(),2,'.',',','','','-','');
									objeto.setValue(valor);
		
									},
									'focus':function(objeto)
									{
										var numero = formatoNumericoEdicion(objeto.getValue());
										objeto.setValue(numero);
									}
								}												
							}]
						}]
				},
				{
				style:'position:absolute;left:660px;top:100px',
				layout:"column",
				border:false,
				items: [{
						layout:"form",
						border:false,
						labelWidth:60,
						items: [{
								xtype:"checkbox",
								fieldLabel:'Via Web',
								labelSeparator:'',
								id: 'chkweb',	
								inputValue:1,
								binding:true,
								hiddenvalue:'',
								defaultvalue:'0',
								allowBlank:false,
								checked : true,
								handler: function()
								{
									if (Ext.getCmp('chkweb').checked)
									{
										ls_status = 0;
										ls_opedestino = 'ND';
										Ext.getCmp('codope').setValue('Nota de Dbito');
										Ext.getCmp('operaciondes').setValue('Nota de Crdito');
										Ext.getCmp('chevou').disable();
									}
									else
									{	
										ls_status = 1;
										ls_opedestino = 'DP';
										Ext.getCmp('codope').setValue('Cheque');
										Ext.getCmp('operaciondes').setValue('Deposito');
										Ext.getCmp('chevou').enable();
									}
								}
							}]
						}]
				}]
				},frmDatosOrigen,frmDatosDestino]
	});
	irNuevo();
	verificarViaweb();
});
//----------------------------------------------------------------------------------------------------------------------------------
//**********************************************************************************************************************************	
//                                  INICIO DE FUNCIONES PARA LOS CATALOGOS DE BUSQUEDA Y VALIDACIONES 
//**********************************************************************************************************************************
//funcion para validar si dentro del catalogo de banco se ha seleccionado alguna entidad bancaria
	function validarCatalogoBanco()
	{
		var unidadOk = true;
		if(Ext.getCmp('codban').getValue()=='')
		{
			unidadOk = false;
		}
		
		return unidadOk;
	}

//funcion para validar si dentro del catalogo de banco se ha seleccionado alguna entidad bancaria
	function validarCatalogoBanco2(){
		
		var unidadOk = true;
		if(Ext.getCmp('codbandes').getValue()=='')
		{
			unidadOk = false;
		}
		
		return unidadOk;
	}
//----------------------------------------------------------------------------------------------------------------------------------
	function llenar_campo_numdoc_origen(campo)
	{
		var myJSONObject = {
				"operacion" :'llenar_numdoc',
				"numdoc"    : campo
		};
		var ObjSon= JSON.stringify(myJSONObject);
		var parametros ='ObjSon='+ObjSon;
		Ext.Ajax.request({
			url: rutae,
			params: parametros,
			method: 'POST',
			success: function ( result, request ) 
			{ 
				var numdoc = result.responseText;
				if (numdoc.length != 0)
				{
					Ext.getCmp('numdocori').setValue(numdoc);
				}
			}
		});
	}
//----------------------------------------------------------------------------------------------------------------------------------
	function llenar_campo_numdoc_destino(campo)
	{
		var myJSONObject = {
				"operacion" :'llenar_numdoc',
				"numdoc"    : campo
		};
		var ObjSon= JSON.stringify(myJSONObject);
		var parametros ='ObjSon='+ObjSon;
		Ext.Ajax.request({
			url: rutae,
			params: parametros,
			method: 'POST',
			success: function ( result, request ) 
			{ 
				var numdoc = result.responseText;
				if (numdoc.length != 0)
				{
					Ext.getCmp('numdocdes').setValue(numdoc);
				}
			}
		});
	}
//----------------------------------------------------------------------------------------------------------------------------------
	function buscarTipoCuenta()
	{
		var codigoban = Ext.getCmp('codban').getValue();
		var codigoctaban = Ext.getCmp('ctaban').getValue();
		var myJSONObject = {
					"operacion":"buscarcontablecta",
					"codban":codigoban,
					"codcta":codigoctaban 
		};
					
		var ObjSon=JSON.stringify(myJSONObject);
		var parametros ='ObjSon='+ObjSon;
		Ext.Ajax.request({
			url: rutae,
			params: parametros,
			method: 'POST',
			success: function ( result, request )
			{ 
				var cuenta = result.responseText;
				if (cuenta != "")
				{
					Ext.getCmp('scg_cuentaori').setValue(cuenta);
				}
				else
				{
					//Ext.getCmp('tipcta').setValue('---');
				}
			},
			failure: function ( result, request)
			{ 
				Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
			}
		});
		buscarSaldo();
		validarOperacion();
	}
//----------------------------------------------------------------------------------------------------------------------------------
	function buscarSaldo()
	{
		var codigoban = Ext.getCmp('codban').getValue();
		var codigoctaban = Ext.getCmp('ctaban').getValue();
		var myJSONObject = {
					"operacion":"buscarsaldo",
					"codban":codigoban,
					"codcta":codigoctaban 
				};
					
		var ObjSon=JSON.stringify(myJSONObject);
		var parametros ='ObjSon='+ObjSon;
		Ext.Ajax.request({
			url: rutap,
			params: parametros,
			method: 'POST',
			success: function ( result, request )
			{ 
				var saldo = result.responseText;
				if (saldo != "")
				{
					Ext.getCmp('dispori').setValue(saldo);
				}
				else
				{
					Ext.getCmp('dispori').setValue(0.00);
				}
			},
			failure: function ( result, request)
			{ 
				Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
			}
		});
	}
//----------------------------------------------------------------------------------------------------------------------------------
	function buscarTipoCuentaDes()
	{
		var codigoban = Ext.getCmp('codbandes').getValue();
		var codigoctaban = Ext.getCmp('ctabandes').getValue();
		var myJSONObject = {
					"operacion":"buscarcontablecta",
					"codban":codigoban,
					"codcta":codigoctaban 
				};
					
		var ObjSon=JSON.stringify(myJSONObject);
		var parametros ='ObjSon='+ObjSon;
		Ext.Ajax.request({
			url: rutae,
			params: parametros,
			method: 'POST',
			success: function ( result, request )
			{ 
				var cuenta = result.responseText;
				if (cuenta != "")
				{
					Ext.getCmp('scg_cuentades').setValue(cuenta);
				}
				else
				{
					//Ext.getCmp('tipcta').setValue('---');
				}
			},
			failure: function ( result, request)
			{ 
				Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
			}
		});
		buscarSaldoDes();
		validarOperacion();
	}
//----------------------------------------------------------------------------------------------------------------------------------
	function buscarSaldoDes()
	{
		var codigoban = Ext.getCmp('codbandes').getValue();
		var codigoctaban = Ext.getCmp('ctabandes').getValue();
		var myJSONObject = {
					"operacion":"buscarsaldo",
					"codban":codigoban,
					"codcta":codigoctaban 
				};
					
		var ObjSon=JSON.stringify(myJSONObject);
		var parametros ='ObjSon='+ObjSon;
		Ext.Ajax.request({
			url: rutap,
			params: parametros,
			method: 'POST',
			success: function ( result, request )
			{ 
				var saldo = result.responseText;
				if (saldo != "")
				{
					Ext.getCmp('dispodes').setValue(saldo);
				}
				else
				{
					Ext.getCmp('dispodes').setValue(0.00);
				}
			},
			failure: function ( result, request)
			{ 
				Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
			}
		});
	}
//----------------------------------------------------------------------------------------------------------------------------------
	function llenarVoucher()
	{
		var myJSONObject = {
			"operacion":"buscarvoucher" 
		};
				
		var ObjSon=Ext.util.JSON.encode(myJSONObject);
		var parametros ='ObjSon='+ObjSon;
		Ext.Ajax.request({
			url: rutae,
			params: parametros,
			method: 'POST',
			success: function ( result, request ) { 
				var chevou = result.responseText;
				if (chevou != "")
				{
					chevou=chevou.substring(10,25);
					Ext.getCmp('chevou').setValue(chevou);
				}
			},
			failure: function ( result, request){ 
				Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
			}
		});		
	}
//----------------------------------------------------------------------------------------------------------------------------------
	function validarOperacion()
	{
		var ls_opeorigen = Ext.getCmp('codope').getValue()
		var ls_opedestino = Ext.getCmp('operaciondes').getValue();
		var ls_codbanorigen = Ext.getCmp('codban').getValue();
		var ls_nombanorigen = Ext.getCmp('nomban').getValue();
		var ls_ctabanorigen = Ext.getCmp('ctaban').getValue();
		var ls_codbandestino = Ext.getCmp('codbandes').getValue();
		var ls_nombandestino = Ext.getCmp('nombandes').getValue();
		var ls_ctabandestino = Ext.getCmp('ctabandes').getValue();
		var ls_conceptoA = 'Transferencias de Fondo del '+Ext.getCmp('nomban').getValue(); 
		var ls_conceptoB = 'cuenta '+Ext.getCmp('ctaban').getValue(); 
		var ls_conceptoC = 'al '+Ext.getCmp('nombandes').getValue();
		var ls_conceptoD = 'cuenta '+Ext.getCmp('ctabandes').getValue();
		
		if (ls_opeorigen == 'CH')
		{
			ls_opedestino = 'DP';
			Ext.getCmp('operaciondes').setValue('Deposito');
		}
		else
		{
			ls_opedestino = 'ND';
			Ext.getCmp('operaciondes').setValue('Nota de Crbito');
		}
		Ext.getCmp('conmov').setValue(ls_conceptoA+' '+ls_conceptoB+' '+ls_conceptoC+' '+ls_conceptoD);
	}
//----------------------------------------------------------------------------------------------------------------------------------
	function verificarViaweb()
	{
		if (Ext.getCmp('chkweb').checked)
		{
			ls_status = 0;
			ls_opedestino = 'ND';
			Ext.getCmp('codope').setValue('Nota de Dbito');
			Ext.getCmp('operaciondes').setValue('Nota de Crdito');
			Ext.getCmp('chevou').disable();
		}
		else
		{	
			ls_status = 1;
			ls_opedestino = 'DP';
			Ext.getCmp('codope').setValue('Cheque');
			Ext.getCmp('operaciondes').setValue('Deposito');
			Ext.getCmp('chevou').enable();
		}
	}
//----------------------------------------------------------------------------------------------------------------------------------
	function mostrarCheck(islr) 
	{
		if (islr=='1')
		{
  			return '<img src="../../base/imagenes/aceptar.png" style="border-style:none" />';
 		}
		else
		{
			return '<img src="../../base/imagenes/cancelar.png" style="border-style:none" />';
		}
	}
//----------------------------------------------------------------------------------------------------------------------------------
	function buscarDeducciones()
	{
		ls_documento = Ext.getCmp('docorig').getValue();
		ldec_objret = Ext.getCmp('monobjret').getValue();

		var JSONObject = {
				'operacion' : 'buscar_deducciones',
				'documento' : ls_documento,
				'objret'	: ldec_objret
		}
		var ObjSon = JSON.stringify(JSONObject);
		var parametros = 'ObjSon='+ObjSon; 
		Ext.Ajax.request({
			url: ruta,
			params : parametros,
			method: 'POST',
			success: function ( resultado, request)
			{
				Ext.Msg.hide();
				var datos = resultado.responseText;
				var objetoMovbco = eval('(' + datos + ')');
				if(objetoMovbco!='')
				{
					gridBuscarDeduccion.store.loadData(objetoMovbco);
				}
			}	
		});
	}
//----------------------------------------------------------------------------------------------------------------------------------
	function CatalogoDeducciones()
	{	
		if ((Ext.getCmp('monto').getValue() == '') || (Ext.getCmp('monobjret').getValue() == ''))
		{
			Ext.Msg.show({
						  title:'Mensaje',
						  msg:'Debe establecer el Monto y el Monto Objeto a Retencion para realizar la Bsqueda',
						  buttons: Ext.Msg.OK,
						  icon: Ext.MessageBox.INFO
						  });
		}
		else if (Ext.getCmp('docorig').getValue() == '')
		{
			Ext.Msg.show({
						  title:'Mensaje',
						  msg:'Debe establecer el Documento de Origen para realizar la Bsqueda',
						  buttons: Ext.Msg.OK,
						  icon: Ext.MessageBox.INFO
						  });
		}
		else
		{
			//Creando el campo de buscar deducciones
			var reBuscarDedu = Ext.data.Record.create([
					  {name: 'codded'}, 		
					  {name: 'dended'},
					  {name: 'formula'}, 		
					  {name: 'islr'},
					  {name: 'iva'}, 		
					  {name: 'estretmun'},
					  {name: 'sc_cuenta'},
					  {name: 'montoret'}, 		
					  {name: 'monded'},
					  {name: 'documento'},
					  {name: 'objret'}
					  ]);
														
			var dsBuscarDedu =  new Ext.data.Store({
					   reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reBuscarDedu)
			});
			
			var smBuscarDedu = new Ext.grid.CheckboxSelectionModel({singleSelect:false});
			
			smBuscarDedu.on({
			'rowselect': 
			{
				fn: function(grid, numFila, registro)
				{
					if (Ext.getCmp('monobjret').getValue() == registro.get('objret'))
					{
						var monobjret = parseFloat(ue_formato_operaciones(Ext.getCmp('monobjret').getValue()));
						var total = parseFloat(ue_formato_operaciones(Ext.getCmp('totret').getValue()));
						var codigo = registro.get('codded');
						
						var JSONObject = {
							'operacion' : 'calcular_montobjret',
							'objret' 	: monobjret,
							'codded'	: codigo
											}
		
						var ObjSon = JSON.stringify(JSONObject);
						var parametros = 'ObjSon='+ObjSon; 
						Ext.Ajax.request({
							url : ruta,
							params : parametros,
							method: 'POST',
							success: function ( resultado, request)
							{
								Ext.Msg.hide();
								var datos = resultado.responseText;
								if(datos!='')
								{
									datos = parseFloat(ue_formato_operaciones(datos));
									registro.set('montoret',formatoNumericoMostrar(datos,2,'.',',','','','-',''));
									total = total + datos;
									Ext.getCmp('totret').setValue(formatoNumericoMostrar(total,2,'.',',','','','-',''));
								}
							}	
						});
					}
					else
					{
						var monobjret = parseFloat(ue_formato_operaciones(registro.get('objret')));
						var total = parseFloat(ue_formato_operaciones(Ext.getCmp('totret').getValue()));
						var codigo = registro.get('codded');
						
						var JSONObject = {
							'operacion' : 'calcular_montobjret',
							'objret' 	: monobjret,
							'codded'	: codigo
											}
		
						var ObjSon = JSON.stringify(JSONObject);
						var parametros = 'ObjSon='+ObjSon; 
						Ext.Ajax.request({
							url : '../../controlador/scb/sigesp_ctr_scb_transferencias.php',
							params : parametros,
							method: 'POST',
							success: function ( resultado, request)
							{
								Ext.Msg.hide();
								var datos = resultado.responseText;
								if(datos!='')	//undefined
								{
									datos = parseFloat(ue_formato_operaciones(datos));
									registro.set('montoret',formatoNumericoMostrar(datos,2,'.',',','','','-',''));
									total = parseFloat(total) + parseFloat(datos);
									Ext.getCmp('totret').setValue(formatoNumericoMostrar(total,2,'.',',','','','-',''));
								}
							}	
						});
					}
				}
			},
			'rowdeselect': 
			{
				fn: function(grid, numFila, registro)
				{
					var montoret = registro.get('montoret');
					var	total = Ext.getCmp('totret').getValue(formatoNumericoMostrar(total,2,'.',',','','','-',''));
					total = total - montoret;		
					registro.set('montoret',formatoNumericoMostrar(0,2,'.',',','','','-',''));
					Ext.getCmp('totret').setValue(formatoNumericoMostrar(total,2,'.',',','','','-',''));
				}
			}
			});
		
			var cmBuscarDedu = new Ext.grid.ColumnModel([ 
						smBuscarDedu,
						{header: "<CENTER>Documento</CENTER>", align: 'center', width: 50, sortable: true, dataIndex: 'documento'},
						{header: "<CENTER>Denominaci&#243;n</CENTER>", align: 'center', width: 80, sortable: true, dataIndex: 'dended'},
						{header: "<CENTER>Monto Objeto Retenci&#243;n</CENTER>", align: 'center', width: 70, sortable: true, dataIndex: 'objret', editor: new Ext.form.NumberField({allowBlank: false})},
						{header: "<CENTER>Monto Retenci&#243;n</CENTER>", align: 'center', width: 50, sortable: true, dataIndex: 'montoret'},
						{header: "<CENTER>Monto Deducible</CENTER>", align: 'center', width: 50, sortable: true, dataIndex: 'monded'},
						{header: "<CENTER>ISLR</CENTER>", align: 'center', width: 25, sortable: true, dataIndex: 'islr', renderer: mostrarCheck}
						]);
			//fin creando datastore y columnmodel para el catalogo de buscar deducciones
			
			 gridBuscarDeduccion = new Ext.grid.EditorGridPanel({
					width:750,
					height:270,
					frame:true,
					style: 'position:absolute;left:15px;top:120px',
					title: "<H1 align='center'>Cat&#225;logo de Retenciones</H1>",
					autoScroll:true,
					border:true,
					ds: dsBuscarDedu,
					cm: cmBuscarDedu,
					sm: smBuscarDedu,
				//	sm:	new Ext.grid.CheckboxSelectionModel({singleSelect:false}),
					stripeRows: true,
					viewConfig: {forceFit:true}
			});
			 
			gridBuscarDeduccion.on('afteredit', function(Obj)
			{
				var registro = Obj.record;
				var objeto = registro.get('objret');
				if(objeto!='')
				{
					objeto = parseFloat(ue_formato_operaciones(objeto)); 
				}
				registro.set('objret',formatoNumericoMostrar(objeto,2,'.',',','','','-',''));
			});
		//----------------------------------------------------------------------------------------------------------------------------------
			//Creacion del formulario del catalogo de deducciones
			var frmBuscarDeduccion = new Ext.FormPanel({
					width: 800,
					height: 450,
					style: 'position:absolute;left:7px;top:0px',
					frame: true,
					autoScroll:false,
					items: [{
							xtype:"fieldset", 
							title:'',
							style:'position:absolute;left:15px;top:15px',
							border:true,
							width:750,
							cls :'fondo',
							height:85,
							items:[{
									style:'position:absolute;left:15px;top:15px',
									layout:"column",
									defaults:{border: false},
									items: [{
											layout:"form",
											border:false,
											labelWidth:100,
											items: [{
													xtype:'textfield',
													labelSeparator:'',
													fieldLabel:'Documento',
													name:'documentoprov',
													id:'catdocprov',
													value: Ext.getCmp('docorig').getValue(),									
													width: 150,
													binding:true,
													hiddenvalue:'',
													defaultvalue:'',
													readOnly:true
												}]
										}]
									},
									{
									style:'position:absolute;left:15px;top:45px',
									layout:"column",
									defaults:{border: false},
									items: [{
											layout:"form",
											border:false,
											labelWidth:100,
											items: [{
													xtype:'textfield',
													labelSeparator:'',
													fieldLabel:'Total Retenido',
													name:'totret',
													id:'totret',
													value: formatoNumericoMostrar(0,2,'.',',','','','-',''),
													width: 150,
													binding:true,
													hiddenvalue:'',
													defaultvalue:'',
													readOnly:true
												}]
										}]
									}]
							},gridBuscarDeduccion,
							{
							layout:"column",
							defaults:{border: false},
							style:'position:absolute;left:540px;top:397px', 
							border:false,
							items:[{
									buttons: [{
												text:'Procesar Deducciones',
												iconCls: 'bmenuaceptar',
												handler: function()
												{
													var registro2 = gridBuscarDeduccion.getSelectionModel().getSelected();	        	
													if(registro2 != undefined)
													{
														Ext.getCmp('monret').setValue(Ext.getCmp('totret').getValue());
														ventanaCatalogoDeduccion.close();
													}
													else 
													{
														Ext.MessageBox.show({
														title:'Mensaje',
														msg:'Debe seleccionar al menos un registro a procesar',
														buttons: Ext.Msg.OK,
														icon: Ext.MessageBox.INFO
														});
													}
												}
											},												
											{
											text:'Salir',
											iconCls: 'menusalir',
											handler:function(){
														ventanaCatalogoDeduccion.close();
											}
											}]
									}]
							}]  
			});
			buscarDeducciones();
	//----------------------------------------------------------------------------------------------------------------------------------	
		
			var ventanaCatalogoDeduccion = new Ext.Window({
					title: "<H1 align='center'>Cat&#225;logo Deducciones</H1>",
					width:814,
					height:478,
					modal: true,
					closable:false,
					plain: false,
					frame:true,
					items:[frmBuscarDeduccion]
			
			});
			
			ventanaCatalogoDeduccion.show();
			}
	}
//FIN DEL FORMULARIO CATALOGO DEDUCCIONES//
//----------------------------------------------------------------------------------------------------------------------------------

function irCancelar(){
	limpiarFormulario(frmTransferenciaBancaria);
	verificarViaweb();
}
//----------------------------------------------------------------------------------------------------------------------------------
function irNuevo(){
	limpiarFormulario(frmTransferenciaBancaria);
	verificarViaweb();
}
//----------------------------------------------------------------------------------------------------------------------------------
function irBuscar(){
}
//----------------------------------------------------------------------------------------------------------------------------------
function irGuardar(){
	valido=true;
	var numdocori       = Ext.getCmp('numdocori').getValue();
	var numdocdes       = Ext.getCmp('numdocdes').getValue();
	var codigobanori    = Ext.getCmp('codban').getValue();
	var codigoctabanori = Ext.getCmp('ctaban').getValue();
	var codigobandes    = Ext.getCmp('codbandes').getValue();
	var codigoctabandes = Ext.getCmp('ctabandes').getValue();
	var scg_cuentaori   = Ext.getCmp('scg_cuentaori').getValue();
	var scg_cuentades   = Ext.getCmp('scg_cuentades').getValue();
	var codopeori		= operacion_origen;
	var codopedes       = operacion_destino;
	var voucher         = Ext.getCmp('chevou').getValue();
	var monto           = Ext.getCmp('monto').getValue();
	var conmov          = Ext.getCmp('conmov').getValue();
	var fechamov        = Ext.getCmp('fecmov').getValue();
	var fechamov	    = fechamov.format(Date.patterns.fechacorta);

	if((codigobanori!="")&&(codigobandes!="")&&(codigoctabanori!="")&&(codigoctabandes!="")&&(numdocori!="")&&(numdocdes!="")&&(monto!=0))
	{
			if (numdocori!=numdocdes)
			{
				Delay(500);
				obtenerMensaje('procesar','','Procesando Datos');
				var JSONObject = {
						'operacion'    : 'transferir',
						'codsis'       : sistema,
						'nomven'       : vista,
						'estmov'       : 'N',
						'numdocori'    : numdocori,
						'numdocdes'    : numdocdes,
						'codbanori'    : codigobanori,
						'codbandes'    : codigobandes,
						'ctabanori'    : codigoctabanori,
						'ctabandes'    : codigoctabandes,
						'sc_cuentaori' : scg_cuentaori,
						'sc_cuentades' : scg_cuentades,
						'codopeori'    : codopeori,
						'codopedes'    : codopedes,
						'voucher'      : voucher,
						'conmov'       : conmov,
						'fecmov'	   : fechamov,
						'monto'        : monto
					}
				objdata=JSON.stringify(JSONObject);
				var parametros = 'ObjSon='+objdata; 
				Ext.Ajax.request({
				url : ruta,
				params : parametros,
				method: 'POST',
				success: function (resultado, request)
				{ 
					datos = resultado.responseText;
					Ext.Msg.hide();
					var datajson = eval('(' + datos + ')');
					if (datajson.raiz.valido==true)
					{	
						Ext.MessageBox.alert('Mensaje', datajson.raiz.mensaje);
					}
					else
					{
						Ext.MessageBox.alert('Error', datajson.raiz.mensaje);
					}
				},
				failure: function (result,request) 
				{ 
					Ext.Msg.hide();
					Ext.MessageBox.alert('Error', 'Error al generar la transferencia'); 
				}					
				});
			
				irCancelar();
			}
			else
			{
				Ext.Msg.hide();
				Ext.MessageBox.alert('Error', 'El nmero de documento origen y destino deben ser distinto!'); 
			}
	}
	else
	{
		Ext.Msg.hide();
		Ext.MessageBox.alert('Error', 'Debe llenar todos los campos!'); 
	}
}
//----------------------------------------------------------------------------------------------------------------------------------
function irEliminar(){
}
//----------------------------------------------------------------------------------------------------------------------------------
function irImprimir(){
}


