///**//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// * @FECHA DE CREACION: 18-01-2013
// * @DESARROLLADOR: ING. DOMINGO CALICCHIO
// * @DESCRIPCION: js correspondiente a la vista de comprobante de retencion de islr
///**//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

var frmRetencionesISLR = null;  //instancia del formulario de comprobante de retencion islr
var Actualizar = null;
var gridDocumentos = null;
var ruta ='../../controlador/scb/sigesp_ctr_scb_retencionesislr.php'; //ruta del controlador
var rutapb = '../../controlador/scb/sigesp_ctr_scb_pagos.php'; //ruta del controlador
var fechaPrimera = obtenerPrimerDiaMes();

barraherramienta = true;
Ext.onReady(function()
{
	Ext.QuickTips.init();
	Ext.BLANK_IMAGE_URL = '../../base/librerias/js/ext/resources/images/default/s.gif';
//--------------------------------------------------------------------------------------------------------------------------------	
//**********************************************************************************************************************************	
//                                 	INICIO DEL FORMULARIO COMPROBANTE DE RETENCION ISLR
//**********************************************************************************************************************************
	//Creando el campo de solicitudes a programar 
	var reDocumentos = Ext.data.Record.create([
						{name: 'numero'}, 
						{name: 'concepto'},
						{name: 'procede'}
						]);

	var dsDocumentos =  new Ext.data.Store({
						reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reDocumentos)
					});
    						
	var cmDocumentos = new Ext.grid.ColumnModel([
						new Ext.grid.CheckboxSelectionModel(),
						{header: "<CENTER>N&#186; Documento</CENTER>", align: 'center', width: 40, sortable: true, dataIndex: 'numero'},
						{header: "<CENTER>Concepto</CENTER>", align: 'center', width: 80, sortable: true, dataIndex: 'concepto'},
						{header: "<CENTER>Procede</CENTER>", align: 'center', width: 40, sortable: true, dataIndex: 'procede'}
					]);

	//creando datastore y columnmodel para la grid de solicitudes a programar
	 gridDocumentos = new Ext.grid.EditorGridPanel({
	 		width:715,
	 		height:200,
			frame:true,
			title:"<H1 align='center'>Comprobantes de Retenci&#243;n de I.S.L.R.</H1>",
			style: 'position:absolute;left:10px;top:265px',
			autoScroll:true,
     		border:true,
     		ds: dsDocumentos,
       		cm: cmDocumentos,
			sm:new Ext.grid.CheckboxSelectionModel({singleSelect:false}),
       		stripeRows: true,
      		viewConfig: {forceFit:true}
	});
//----------------------------------------------------------------------------------------------------------------------------------
//Creacion del formulario
	var Xpos = ((screen.width/2)-(380));
	frmRetencionesISLR = new Ext.FormPanel({
		applyTo: 'formulario',
		width: 750,
		height: 505,
		title: "<H1 align='center'>Reporte de Retenciones de I.S.L.R.</H1>",
		frame: true,
		style: 'position:absolute;margin-left:'+Xpos+'px;margin-top:20px;',
		items: [{
				xtype:"fieldset", 
				style: 'position:absolute;left:12px;top:10px',
				border:true,
				width: 715,
				cls :'fondo',
				height: 240,
				items: [{
						xtype:"fieldset", 
						title:'',
						style:'position:absolute;left:25px;top:15px',
						border:true,
						width:665,
						height:90,
						items: [{
								style:'position:absolute;left:50px;top:10px',
								layout:"column",
								border:false,
								items: [{
										layout:"form",
										border:false,
										labelWidth:100,
										items:[{
												xtype:"radiogroup",
												labelSeparator:'',
												columns: [150, 150, 150],
												id:'prov_bene',
												binding:true,
												items: [{
														boxLabel: "Todos", 
														name: "rbstipodes", 
														inputValue: 'T',
														listeners:{	
															'check': function (checkbox, checked) 
															{
																if(checked)
																{
																	Ext.getCmp('cat_prov').setValue('');
																	Ext.getCmp('cat_bene').setValue('');
																}
															}
															}
														},
														{
														boxLabel: "Proveedor", 
														name: "rbstipodes", 
														inputValue: 'P',
														listeners:{	
															'check': function (checkbox, checked) 
															{
																if(checked)
																{
																	Ext.getCmp('cat_prov').setValue('');
																	Ext.getCmp('cat_bene').setValue('');
																	Ext.getCmp('prov_bene').setValue('P');
																}
															}
														}
														},
														{
														boxLabel: "Beneficiario", 
														name: "rbstipodes", 
														inputValue: 'B',
														listeners:{	
															'check': function (checkbox, checked) 
															{
																if(checked)
																{
																	Ext.getCmp('cat_prov').setValue('');
																	Ext.getCmp('cat_bene').setValue('');
																	Ext.getCmp('prov_bene').setValue('B');
																}
															}
														}
														}]
												}]
										}]
								},
								{
								style:'position:absolute;left:45px;top:45px',
								layout:"column",
								border:false,
								items: [{
										layout:"form",
										border:false,
										labelWidth:60,
										items: [{
												xtype:"textfield",
												labelSeparator:'',
												fieldLabel:'Desde',
												name:'proveedor',
												id:'cat_prov',
												width:150,
												binding:true,
												hiddenvalue:'',
												defaultvalue:'',
												allowBlank:true,
												autoCreate:{tag: 'input', type: 'text', size: '15', autocomplete: 'off', maxlength: '15', onkeypress: "return keyRestrict(event,'0123456789');"}
											}]
									}]
								},
								{
								style:'position:absolute;left:270px;top:45px',
								layout:"column",
								border:false,
								items: [{
										layout:"form",
										border:false,
										items: [{
												 xtype:"button",
												 id:'btnBuscarProv',
												 iconCls:'menubuscar',
												 handler:	function(boton)
												 {
													if(Ext.getCmp('prov_bene').items.items[1].checked)
													{
														CatalogoProveedores(boton.id);
													}
													else if(Ext.getCmp('prov_bene').items.items[2].checked)	
													{
														CatalogoBeneficiarios(boton.id);
													}
													else if(Ext.getCmp('prov_bene').items.items[0].checked)	
													{
														Ext.Msg.show({
														title:'Mensaje',
														msg:'Debe seleccionar un Proveedor / Beneficiario',
														buttons: Ext.Msg.OK,
														icon: Ext.MessageBox.INFO
														});
													}
													else if((Ext.getCmp('prov_bene').items.items[1] != 'P') && (Ext.getCmp('prov_bene').items.items[2] != 'B'))
													{
														Ext.Msg.show({
																		title:'Mensaje',
																		msg:'Debe seleccionar un Proveedor / Beneficiario',
																		buttons: Ext.Msg.OK,
																		icon: Ext.MessageBox.INFO
																		});
													}
												}
											}]
										}]
								},
								{
								style:'position:absolute;left:390px;top:45px',
								layout:"column",
								border:false,
								items: [{
										layout:"form",
										border:false,
										labelWidth:60,
										items: [{
												xtype:"textfield",
												labelSeparator:'',
												fieldLabel:'Hasta',
												name:'beneficiario',
												id:'cat_bene',
												width:150,
												binding:true,
												hiddenvalue:'',
												defaultvalue:'',
												allowBlank:true,
												autoCreate:{tag: 'input', type: 'text', size: '15', autocomplete: 'off', maxlength: '15', onkeypress: "return keyRestrict(event,'0123456789');"}
											}]
									}]
								},
								{
								style:'position:absolute;left:615px;top:45px',
								layout:"column",
								border:false,
								items: [{
										layout:"form",
										border:false,
										items: [{
												 xtype:"button",
												 id:'btnBuscarBene',
												 iconCls:'menubuscar',
												 handler:	function(boton)
												 {
													if(Ext.getCmp('prov_bene').items.items[1].checked)
													{
														CatalogoProveedores(boton.id);
													}
													else if(Ext.getCmp('prov_bene').items.items[2].checked)	
													{
														CatalogoBeneficiarios(boton.id);
													}
													else if(Ext.getCmp('prov_bene').items.items[0].checked)	
													{
														Ext.Msg.show({
														title:'Mensaje',
														msg:'Debe seleccionar un Proveedor / Beneficiario',
														buttons: Ext.Msg.OK,
														icon: Ext.MessageBox.INFO
														});
													}
													else if((Ext.getCmp('prov_bene').items.items[1] != 'P') && (Ext.getCmp('prov_bene').items.items[2] != 'B'))
													{
														Ext.Msg.show({
														title:'Mensaje',
														msg:'Debe seleccionar un Proveedor / Beneficiario',
														buttons: Ext.Msg.OK,
														icon: Ext.MessageBox.INFO
														});
													}
												}
											}]
										}]
								}]
						},
						{
						xtype:"fieldset", 
						title:'',
						style:'position:absolute;left:25px;top:120px',
						border:true,
						width:665,
						height:70,
						items: [{
								style:'position:absolute;left:295px;top:10px',
								layout:"column",
								border:false,
								items: [{
										xtype:'label',
										style:'font-weight:bold;border:none;align:center;',
										text:'Rango de Fecha',
										id:'lblcp',
										width:100		
									}]
								},
								{
								style:'position:absolute;left:25px;top:30px',
								layout:"column",
								border:false,
								items: [{
										layout:"form",
										border:false,
										labelWidth:50,
										items: [{
												 xtype:"datefield",
												 labelSeparator:'',
												 fieldLabel:'Desde',
												 name:'fechadesde',
												 id:'fecdesde',
												 value: fechaPrimera,
												 width:150,
												 binding:true,
												 hiddenvalue:'',
												 defaultvalue:'1900-01-01',
												 allowBlank:true,
												 autoCreate:{tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789/');"}
											}]
										}]
								},
								{
								style:'position:absolute;left:450px;top:30px',
								layout:"column",
								border:false,
								items: [{
										layout:"form",
										border:false,
										labelWidth:50,
										items: [{
												 xtype:"datefield",
												 labelSeparator:'',
												 fieldLabel:'Hasta',
												 name:'fechahasta',
												 id:'fechasta',
												 value: new Date().format('Y-m-d'),
												 width:150,
												 binding:true,
												 hiddenvalue:'',
												 defaultvalue:'1900-01-01',
												 allowBlank:true,
												 autoCreate:{tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789/');"}
											}]
										}]
								}]
						},
						{
						style:'position:absolute;left:555px;top:203px',
						layout:"column",
						border:false,
						items: [{
								layout:"form",
								border:false,
								items: [{
										 xtype:"button",
										 text:'Buscar Documentos',
										 id:'btnbuuscar',
										 iconCls:'menubuscar',
										 handler: function(){
											  var prov_bene2 = '';
											  if((Ext.getCmp('prov_bene').items.items[0].checked) || (Ext.getCmp('prov_bene').items.items[1].checked) || (Ext.getCmp('prov_bene').items.items[2].checked))
											  {
												obtenerMensaje('procesar','','Buscando Datos');
												
												if(Ext.getCmp('prov_bene').items.items[1].checked)
												{
													prov_bene2 = 'P';
												}
												else if(Ext.getCmp('prov_bene').items.items[2].checked)
												{
													prov_bene2 = 'B';
												}
												
												cat_prov2 = Ext.getCmp('cat_prov').getValue();
												cat_bene2 = Ext.getCmp('cat_bene').getValue();
												var fecdes2 = Ext.getCmp('fecdes').getValue();
												var fechas2 = Ext.getCmp('fechas').getValue();
												
												fecdes2= fecdes2.format(Date.patterns.fechacorta);
												fechas2= fechas2.format(Date.patterns.fechacorta);
												compara=ue_comparar_intervalo(fecdes2, fechas2);
												
												if (compara)
												{
													var JSONObject = {
														'operacion' : 	'buscar_datos','fecdes':fecdes2,'fechas':fechas2,
																	'prov_bene':prov_bene2,'cat_prov':cat_prov2,
																	'cat_bene':cat_bene2
																	}
													var ObjSon = JSON.stringify(JSONObject);
													var parametros = 'ObjSon='+ObjSon; 
													Ext.Ajax.request({
														url : ruta,
														params : parametros,
														method: 'POST',
														success: function ( resultado, request)
														{
															Ext.Msg.hide();
															var datos = resultado.responseText;
															var objetoDatosGrid = eval('(' + datos + ')');
															if(objetoDatosGrid!='')
															{
																gridDocumentos.store.loadData(objetoDatosGrid);
															}
														}	
													});
												}
												else
												{
												Ext.Msg.show({
													title:'Mensaje',
													msg:'Fecha Desde debe ser menor que Fecha Hasta',
													buttons: Ext.Msg.OK,
													icon: Ext.MessageBox.INFO
													});
												}
											  }
											  else
											  {
												  Ext.Msg.show({
													title:'Mensaje',
													msg:'Seleccione los parmetros de bsqueda',
													buttons: Ext.Msg.OK,
													icon: Ext.MessageBox.INFO
													});
											  }
										}
										}]
								}]
					}]
	 		},gridDocumentos]
	});
	ValidacionSeguridad();
});
//----------------------------------------------------------------------------------------------------------------------------------
//**********************************************************************************************************************************	
//                                  INICIO DE FUNCIONES PARA LOS CATALOGOS DE BUSQUEDA Y VALIDACIONES 
//**********************************************************************************************************************************
	function ValidacionSeguridad()
	{
		var arregloJson = "{'operacion':'validar_seguridad'}";
		validar= eval('(' + arregloJson + ')');
		ObjSon=Ext.util.JSON.encode(validar);
		parametros = 'ObjSon='+ObjSon;
		Ext.Ajax.request({
			url : ruta,
			params : parametros,
			method: 'POST',
			success: function ( resultado, request )
			{ 
				datos = resultado.responseText;
				switch(datos)
				{
					case '0': 
							Ext.Msg.show({
								title:'Mensaje',
								msg: 'Este Reporte esta configurado para ser generado en el Modulo Cuentas Por Pagar',
								buttons: Ext.Msg.OK,
								icon: Ext.MessageBox.WARNING,
								fn: function ()
								{	
									location.href='sigesp_vis_scb_inicio.html';
								}
							});
					break;
				}
			},
			failure: function ( result, request)
			{ 
				Ext.MessageBox.alert('Error','Ha ocurrido un error en la operaci&#243;n, por favor intente de nuevo'); 
			} 
		});
	}
	
	function mostrarEstatus(fecha2)
	{
		var fecha1 = new Date();
		fecha1 = fecha1.format(Date.patterns.fechacorta)
		
		vali=false;
		dia1 = fecha1.substr(0,2);
		mes1 = fecha1.substr(3,2);
		ano1 = fecha1.substr(6,4);
		dia2 = fecha2.substr(0,2);
		mes2 = fecha2.substr(3,2);
		ano2 = fecha2.substr(6,4);
		if (ano1 < ano2)
		{
			vali = true; 
		}
		else 
		{ 
			if (ano1 == ano2)
			{ 
				if (mes1 < mes2)
				{
					vali = true; 
				}
				else 
				{ 
					if (mes1 == mes2)
					{
						if (dia1 <= dia2)
						{
							vali = true; 
						}
					}
				} 
			} 	
		}
		if (vali)
		{
			return 'VIGENTE';
		}
		else
		{
			return 'VENCIDO';	
		}
	}

function CatalogoProveedores(idBoton)
{			
	var reVentana = Ext.data.Record.create([
				{name: 'cod_pro'},
				{name: 'nompro'},
				{name: 'dirpro'},
				{name: 'rifpro'},
				{name: 'fecvenrnc'},
				{name: 'codban'},
				{name: 'nomban'},
				{name: 'ctaban'},
				{name: 'dencta'}
	]);
					
	var dsVentana =  new Ext.data.Store({
		reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reVentana)
	});
								
	var cmVentana = new Ext.grid.ColumnModel([
	//		new Ext.grid.CheckboxSelectionModel({singleSelect:true}),								  
			{header: "<H1 align='center'>C&#243;digo</H1>", width: 40, sortable: true, dataIndex: 'cod_pro'},
			{header: "<H1 align='center'>Nombre</H1>", width: 50, sortable: true, dataIndex: 'nompro'},
			{header: "<H1 align='center'>Direcci&#243;n</H1>", width: 50, sortable: true, dataIndex: 'dirpro'},
			{header: "<H1 align='center'>RIF</H1>", width: 40, sortable: true, dataIndex: 'rifpro'},
			{header: "<H1 align='center'>Fecha</H1>", width: 40, sortable: true, dataIndex: 'fecvenrnc'},
			{header: "<H1 align='center'>Reg. Nac. Contratistas</H1>", width: 70, sortable: true, dataIndex: 'fecvenrnc',renderer:mostrarEstatus}
	]);
		
	gridVentanaProveedor = new Ext.grid.GridPanel({
		width:650,
		height:255,
		frame:true,
		title:"",
		style: 'position:absolute;left:15px;top:210px',
		autoScroll:true,
		border:true,
		ds: dsVentana,
		cm: cmVentana,
	//	sm:new Ext.grid.CheckboxSelectionModel({singleSelect:true}),
		stripeRows: true,
		viewConfig: {forceFit:true}
	});
	
	if(idBoton == 'btnBuscarProv')
	{	
		gridVentanaProveedor.on({
		'rowdblclick': {
			fn: function(grid, numFila, evento){
				var registro = grid.getStore().getAt(numFila);
				Ext.getCmp('cat_prov').setValue(registro.get('cod_pro'));
				gridVentanaProveedor.destroy();
				ventanaEstructura.destroy();
				}
			}
		});
	}
	else if(idBoton == 'btnBuscarBene')
	{
		gridVentanaProveedor.on({
		'rowdblclick': {
			fn: function(grid, numFila, evento){
				var registro = grid.getStore().getAt(numFila);
				Ext.getCmp('cat_bene').setValue(registro.get('cod_pro'));
				gridVentanaProveedor.destroy();
				ventanaEstructura.destroy();
				}
			}
		});
	}
		 
	var formVentanaCatalogo= new Ext.FormPanel({
		width: 690,
		height: 515,
		title: '',
		style: 'position:absolute;left:7px;top:0px',
		frame: true,
		autoScroll:false,
		items: [{
				xtype:"fieldset", 
				title:'Datos del Proveedor',
				style: 'position:absolute;left:15px;top:5px',
				border:true,
				height:185,
				cls: 'fondo',
				width:650,
				items:[{
						layout: "column",
						defaults: {border: false},
						style: 'position:absolute;left:15px;top:15px',
						items: [{
								layout: "form",
								border: false,
								labelWidth: 80,
								items: [{
										xtype: 'textfield',
										labelSeparator :'',
										fieldLabel: 'C&#243;digo',
										name: 'codigo',
										id: 'codi_pro',									
										width: 150,
										binding:true,
										hiddenvalue:'',
										defaultvalue:'',
										autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '20', onkeypress: "return keyRestrict(event,'0123456789');"},
										changeCheck: function(){
											var textvalor = this.getValue();
											dsVentana.filter('cod_pro',textvalor,true);
											if(String(textvalor) !== String(this.startValue)){
												this.fireEvent('change', this, textvalor, this.startValue);
											} 
										}, 
										initEvents: function(){
											AgregarKeyPress(this);
										}
									}]
							}]
				},
				{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:45px',
				items: [{
						layout: "form",
						border: false,
						labelWidth: 80,
						items: [{
								xtype: 'textfield',
								labelSeparator :'',
								fieldLabel: 'Nombre',
								name: 'nombre',
								id: 'nombpro',
								width: 300,
								binding:true,
								hiddenvalue:'',
								defaultvalue:'',
								changeCheck: function(){
									var v = this.getValue();
									act_data_store_proveedores('nompro',v);
									if(String(v) !== String(this.startValue)){
										this.fireEvent('change', this, v, this.startValue);
									} 
								},							 
								initEvents : function(){
									AgregarKeyPress(this);
								}
							}]
					}]
				},
				{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:75px',
				items: [{
						layout: "form",
						border: false,
						labelWidth: 80,
						items: [{
								xtype: 'textfield',
								labelSeparator :'',
								fieldLabel: 'Direcci&#243;n',
								name: 'direccion',
								id: 'direcpro',
								width: 450,
								binding:true,
								hiddenvalue:'',
								defaultvalue:'',
								changeCheck: function(){
									var v = this.getValue();
									act_data_store_proveedores('dirpro',v);
									if(String(v) !== String(this.startValue)){
										this.fireEvent('change', this, v, this.startValue);
									} 
								},							 
								initEvents : function(){
									AgregarKeyPress(this);
								}
							}]
					}]
				},
				{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:105px',
				items: [{
						layout: "form",
						border: false,
						labelWidth: 80,
						items: [{
								xtype: 'textfield',
								labelSeparator :'',
								fieldLabel: 'R.I.F',
								name: 'rif',
								id: 'rifprov',
								width: 150,
								binding:true,
								hiddenvalue:'',
								defaultvalue:'',
								autoCreate: {tag: 'input', type: 'text', size: '15', autocomplete: 'off', maxlength: '12'},
								changeCheck: function(){
									var v = this.getValue();
									act_data_store_proveedores('rifpro',v);
									if(String(v) !== String(this.startValue)){
										this.fireEvent('change', this, v, this.startValue);
									} 
								},							 
								initEvents : function(){
									AgregarKeyPress(this);
								},
							}]
					}]
				},
				{	
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:300px;top:109px',
				items: [{
						layout: "form",
						border: false,
						labelWidth: 400,
						items: [{
								xtype: 'label',
								text: 'El formato correcto del RIF es: [JGVE]-[99999999]-[9]',
								disabled: true
							}]
					}]
				},
				{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:135px',
				items: [{
						layout: "form",
						border: false,
						labelWidth: 80,
						items: [{
								xtype: 'datefield',
								labelSeparator :'',
								fieldLabel: 'Fecha Desde',
								name: 'fecdesde',
								id: 'fecdes',
								width: 150,
								binding:true,
								hiddenvalue:'',
								defaultvalue:'1900-01-01',
								autoCreate: {tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789/');"},
								changeCheck: function(){
									var v = this.getValue();
									act_data_store_proveedores('fecvenrnc',v);
									if(String(v) !== String(this.startValue)){
										this.fireEvent('change', this, v, this.startValue);
									} 
								},							 
								initEvents : function(){
									AgregarKeyPress(this);
								}
							}]
					}]
				},
				{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:300px;top:135px',
				items: [{
						layout: "form",
						border: false,
						labelWidth: 80,
						items: [{
								xtype: 'datefield',
								labelSeparator :'',
								fieldLabel: 'Fecha Hasta',
								name: 'fechasta',
								id: 'fechas',
								width: 150,
								binding:true,
								hiddenvalue:'',
								defaultvalue:'1900-01-01',
								autoCreate: {tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789/');"},
								changeCheck: function(){
									var v = this.getValue();
									act_data_store_proveedores('fecvenrnc',v);
									if(String(v) !== String(this.startValue)){
										this.fireEvent('change', this, v, this.startValue);
									} 
								},							 
								initEvents : function(){
									AgregarKeyPress(this);
								}
							}]
					}]
				},
				{
				layout:"column",
				defaults: {border: false},
				style: 'position:absolute;left:560px;top:135px',
				border:false,
				items:[{
						layout:"form",
						border:false,
						items:[{					
								xtype: 'button',
								labelSeparator :'',
								fieldLabel: '',
								id: 'btnBuscarBene',
								text: 'Buscar',
								width: 300,
								height: 300,
								binding:true,
								hiddenvalue:'',
								defaultvalue:'',
								iconCls: 'menubuscar',
								handler: function()
								{
									if((Ext.getCmp('codi_pro').getValue() == '') && (Ext.getCmp('nombpro').getValue() == '') 
									&& (Ext.getCmp('direcpro').getValue() == '') && (Ext.getCmp('rifprov').getValue() == '')
									&& (Ext.getCmp('fecdes').getValue() == '') && (Ext.getCmp('fechas').getValue() == ''))
									{
										Ext.Msg.show({
											title:'Mensaje',
											msg:'Debe seleccionar al menos un par&#225;metro de b&#250;squeda',
											buttons: Ext.Msg.OK,
											icon: Ext.MessageBox.INFO
										});
									}
									else{
										obtenerMensaje('procesar','','Buscando Datos');
										
										var codpro  = Ext.getCmp('codi_pro').getValue();
										var nompro  = Ext.getCmp('nombpro').getValue();
										var dirpro  = Ext.getCmp('direcpro').getValue();
										var rifpro  = Ext.getCmp('rifprov').getValue();
										if ((Ext.getCmp('fecdes').getValue() != '') && (Ext.getCmp('fechas').getValue() != '')){
											var fecdes  = Ext.getCmp('fecdes').getValue().format('Y-m-d');
											var fechas  = Ext.getCmp('fechas').getValue().format('Y-m-d');
										}
										else{
											var fecdes = Ext.getCmp('fecdes').getValue();
											var fechas  = Ext.getCmp('fechas').getValue();
										}
																		
										var JSONObject = {
										'operacion'	: 'catalogo',
										'codi_pro'  : codpro,
										'nombpro'   : nompro,
										'direcpro' 	: dirpro,
										'rifprov'   : rifpro,
										'fecdes'   	: fecdes,
										'fechas' 	: fechas
										}			
										var ObjSon = JSON.stringify(JSONObject);
										var parametros = 'ObjSon='+ObjSon; 
										Ext.Ajax.request({
											url : '../../controlador/rpc/sigesp_ctr_rpc_proveedor.php',
											params : parametros,
											method: 'POST',
											success: function ( resultado, request){
												Ext.Msg.hide();
												var datos = resultado.responseText;
												var objetoProveedores = eval('(' + datos + ')');
												if(objetoProveedores!=''){
													if(objetoProveedores!='0'){
														if(objetoProveedores.raiz == null || objetoProveedores.raiz ==''){
															Ext.MessageBox.show({
																title:'Advertencia',
																msg:'No existen datos para mostrar',
																buttons: Ext.Msg.OK,
																icon: Ext.MessageBox.WARNING
															});
														}
														else{
															gridVentanaProveedor.store.loadData(objetoProveedores);
														}
													}
													else{
														Ext.MessageBox.show({
															title:'Advertencia',
															msg:'Debe configurar en Empresa los digitos de las cuentas de gastos',
															buttons: Ext.Msg.OK,
															icon: Ext.MessageBox.WARNING
														});
													}
												}
											 }	
										});
									}
								}
							}]
					}]
				}]
				},gridVentanaProveedor,
				{
				layout:"column",
				defaults:{border: false},
				style:'position:absolute;left:500px;top:469px', 
				border:false,
				items:[{
						buttons: [{
							text:'Aceptar',  
							handler: function()
							{
								var registro = gridVentanaProveedor.getSelectionModel().getSelected();	        	
								if(registro!= undefined)
								{
									if(idBoton == 'btnBuscarProv')
									{
										Ext.getCmp('cat_prov').setValue(registro.get('cod_pro'));
										gridVentanaProveedor.destroy();
										ventanaEstructura.destroy();
									}
									else if(idBoton == 'btnBuscarBene')
									{
										Ext.getCmp('cat_bene').setValue(registro.get('cod_pro'));
										gridVentanaProveedor.destroy();
										ventanaEstructura.destroy();
									}
								}
								else
								{
									Ext.MessageBox.show({
										title:'Mensaje',
										msg:'Debe seleccionar al menos un registro a procesar',
										buttons: Ext.Msg.OK,
										icon: Ext.MessageBox.INFO
									});
								 }
							}
					   	},
						{
							text: 'Salir',
							handler: function()
							{
								ventanaEstructura.destroy();
							}
						}]
					}]
				}]
	});
	var ventanaEstructura = new Ext.Window({
		width:704,
		height:543,
		border:false,
		modal: true,
		closable:false,
		frame:true,
		title:"<H1 align='center'>Cat&#225;logo de Proveedores</H1>",
		items:[formVentanaCatalogo]
	});
	
	function act_data_store_proveedores(criterio,cadena){
		dsVentana.filter(criterio,cadena);
	}
	ventanaEstructura.show();
	}
//FIN DEL FORMULARIO CATALOGO PROVEEDORES//
//----------------------------------------------------------------------------------------------------------------------------------
function CatalogoBeneficiarios(idBoton)
{			
	var reVentana = Ext.data.Record.create([
				{name: 'ced_bene'},
				{name: 'nombene'},
				{name: 'apebene'},
				{name: 'dirbene'},
				{name: 'codban'},
				{name: 'nomban'},
				{name: 'ctaban'},
				{name: 'dencta'}
	]);

	var dsVentana =  new Ext.data.Store({
		reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reVentana)
	});

	var cmVentana = new Ext.grid.ColumnModel([
			  {header: "<H1 align='center'>C&#243;digo</H1>", width: 40, sortable: true, dataIndex: 'ced_bene'},
			  {header: "<H1 align='center'>Nombre</H1>", width: 50, sortable: true, dataIndex: 'nombene'},
			  {header: "<H1 align='center'>Apellido</H1>", width: 50, sortable: true, dataIndex: 'apebene'},
			  {header: "<H1 align='center'>Direcci&#243;n</H1>", width: 50, sortable: true, dataIndex: 'dirbene'}
	]);

	gridVentanaBeneficiario = new Ext.grid.GridPanel({
		width:550,
		height:260,
		frame:true,
		title:"",
		style: 'position:absolute;left:15px;top:150px',
		autoScroll:true,
		border:true,
		ds: dsVentana,
		cm: cmVentana,
	//	sm:new Ext.grid.CheckboxSelectionModel({singleSelect:true}),
		stripeRows: true,
		viewConfig: {forceFit:true}
	});
		
	if(idBoton == 'btnBuscarProv')
	{
		gridVentanaBeneficiario.on({
		'rowdblclick': {
			fn: function(grid, numFila, evento){
				var registro = grid.getStore().getAt(numFila);
				Ext.getCmp('cat_prov').setValue(registro.get('ced_bene'));
				gridVentanaBeneficiario.destroy();
				ventanaEstructura.destroy();
				}
			}
		});
	}
	else if(idBoton == 'btnBuscarBene')
	{
		gridVentanaBeneficiario.on({
		'rowdblclick': {
			fn: function(grid, numFila, evento){
				var registro = grid.getStore().getAt(numFila);
				Ext.getCmp('cat_bene').setValue(registro.get('ced_bene'));
				gridVentanaBeneficiario.destroy();
				ventanaEstructura.destroy();
				}
			}
		});
	}

	var formVentanaCatalogo= new Ext.FormPanel({
		width: 590,
		height: 462,
		title: '',
		style: 'position:absolute;left:7px;top:0px',
		frame: true,
		autoScroll:false,
		items: [{
				xtype:"fieldset", 
				title:'Datos del Beneficiario',
				style: 'position:absolute;left:15px;top:5px',
				border:true,
				height:125,
				width:550,
				cls: 'fondo',
				items:[{
						layout: "column",
						defaults: {border: false},
						style: 'position:absolute;left:15px;top:15px',
						items: [{
								layout: "form",
								border: false,
								labelWidth: 50,
								items: [{
										xtype: 'textfield',
										labelSeparator :'',
										fieldLabel: 'C&#243;digo',
										name: 'codigo',
										id: 'cedulabene',									
										width: 150,
										binding:true,
										hiddenvalue:'',
										defaultvalue:'',
										autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '20', onkeypress: "return keyRestrict(event,'0123456789');"},
										changeCheck: function(){
											var v = this.getValue();
											act_data_store_beneficiarios('ced_bene',v);
											if(String(v) !== String(this.startValue)){
												this.fireEvent('change', this, v, this.startValue);
											} 
										},							 
										initEvents : function(){
											AgregarKeyPress(this);
										}
									}]
							}]
						},
						{
						layout: "column",
						defaults: {border: false},
						style: 'position:absolute;left:15px;top:45px',
						items: [{
								layout: "form",
								border: false,
								labelWidth: 50,
								items: [{
										xtype: 'textfield',
										labelSeparator :'',
										fieldLabel: 'Nombre',
										name: 'nombre',
										id: 'nombrebene',
										width: 350,
										binding:true,
										hiddenvalue:'',
										defaultvalue:'',
										changeCheck: function(){
										var v = this.getValue();
										act_data_store_beneficiarios('nombene',v);
										if(String(v) !== String(this.startValue)){
											this.fireEvent('change', this, v, this.startValue);
										} 
									},							 
									initEvents : function(){
										AgregarKeyPress(this);
									}
									}]
							}]
						},
						{
						layout: "column",
						defaults: {border: false},
						style: 'position:absolute;left:15px;top:75px',
						items: [{
								layout: "form",
								border: false,
								labelWidth: 50,
								items: [{
										xtype: 'textfield',
										labelSeparator :'',
										fieldLabel: 'Apellido',
										name: 'apellido',
										id: 'apellidobene',
										width: 350,
										binding:true,
										hiddenvalue:'',
										defaultvalue:'',
										changeCheck: function(){
										var v = this.getValue();
										act_data_store_beneficiarios('apebene',v);
										if(String(v) !== String(this.startValue)){
											this.fireEvent('change', this, v, this.startValue);
										} 
									},							 
									initEvents : function(){
										AgregarKeyPress(this);
									}
									}]
						}]
						},
						{
						layout:"column",
						defaults: {border: false},
						style: 'position:absolute;left:450px;top:75px',
						border:false,
						items:[{
								layout:"form",
								border:false,
								items:[{					
										xtype: 'button',
										labelSeparator :'',
										fieldLabel: '',
										id: 'btnBuscarBene',
										text: 'Buscar',
										width: 300,
										height: 300,
										binding:true,
										hiddenvalue:'',
										defaultvalue:'',
										iconCls: 'menubuscar',
										handler: function(){
											if ((Ext.getCmp('cedulabene').getValue() == '') && (Ext.getCmp('nombrebene').getValue() == '') && (Ext.getCmp('apellidobene').getValue() == '')){
												Ext.Msg.show({
													title:'Mensaje',
													msg:'Debe seleccionar al menos un par&#225;metro de b&#250;squeda',
													buttons: Ext.Msg.OK,
													icon: Ext.MessageBox.INFO
												});
											}
											else{
												obtenerMensaje('procesar','','Buscando Datos');
					
												var ced_bene  = Ext.getCmp('cedulabene').getValue();
												var nombene  = Ext.getCmp('nombrebene').getValue();
												var apebene  = Ext.getCmp('apellidobene').getValue();
					
												var JSONObject = {
														'operacion'    : 'buscarBeneficiarios',
														'cedulabene'   : ced_bene,
														'nombrebene'   : nombene,
														'apellidobene' : apebene
												}			
												var ObjSon = JSON.stringify(JSONObject);
												var parametros = 'ObjSon='+ObjSon; 
												Ext.Ajax.request({
													url : '../../controlador/rpc/sigesp_ctr_rpc_beneficiario.php',
													params : parametros,
													method: 'POST',
													success: function ( resultado, request){
														Ext.Msg.hide();
														var datos = resultado.responseText;
														var objetoProveedores = eval('(' + datos + ')');
														if(objetoProveedores!=''){
															if(objetoProveedores!='0'){
																if(objetoProveedores.raiz == null || objetoProveedores.raiz ==''){
																	Ext.MessageBox.show({
																		title:'Advertencia',
																		msg:'No existen datos para mostrar',
																		buttons: Ext.Msg.OK,
																		icon: Ext.MessageBox.WARNING
																	});
																}
																else{
																	gridVentanaBeneficiario.store.loadData(objetoProveedores);
																}
															}
															else{
																Ext.MessageBox.show({
																	title:'Advertencia',
																	msg:'Debe configurar en Empresa los digitos de las cuentas de gastos',
																	buttons: Ext.Msg.OK,
																	icon: Ext.MessageBox.WARNING
																});
															}
														}
													}	
												});
											}
										}
									}]
							}]
						}]
				},
				gridVentanaBeneficiario,
				{
				layout:"column",
				defaults:{border: false},
				style:'position:absolute;left:400px;top:412px', 
				border:false,
				items:[{
						buttons: [{
							text:'Aceptar',  
							handler: function()
							{
								var registro = gridVentanaBeneficiario.getSelectionModel().getSelected();	        	
								if(registro!= undefined)
								{
									if(idBoton == 'btnBuscarProv')
									{
										Ext.getCmp('cat_prov').setValue(registro.get('ced_bene'));
										gridVentanaBeneficiario.destroy();
										ventanaEstructura.destroy();
									}
									else if(idBoton == 'btnBuscarBene')
									{
										Ext.getCmp('cat_bene').setValue(registro.get('ced_bene'));
										gridVentanaBeneficiario.destroy();
										ventanaEstructura.destroy();
									}
								}
								else
								{
									Ext.MessageBox.show({
										title:'Mensaje',
										msg:'Debe seleccionar al menos un registro a procesar',
										buttons: Ext.Msg.OK,
										icon: Ext.MessageBox.INFO
									});
								 }
							}
						   	},
							{
								text: 'Salir',
								handler: function()
								{
									ventanaEstructura.destroy();
								}
							}]
						}]
			}]  
	});
	var ventanaEstructura = new Ext.Window({
		width:604,
		height:490,
		border:false,
		modal: true,
		closable:false,
		frame:true,
		title:"<H1 align='center'>Cat&#225;logo de Beneficiarios</H1>",
		items:[formVentanaCatalogo]
	});
	
	function act_data_store_beneficiarios(criterio,cadena)
	{
		dsVentana.filter(criterio,cadena);
	}
	ventanaEstructura.show();
	}
//FIN DEL FORMULARIO CATALOGO BENEFICIARIOS//
//----------------------------------------------------------------------------------------------------------------------------------
//**********************************************************************************************************************************	
//                                  						BOTONES 
//**********************************************************************************************************************************
function irCancelar(){
	limpiarFormulario(frmMovimientoBanco);
}

function irNuevo(){
	limpiarFormulario(frmMovimientoBanco);
	//Ext.getCmp('codope').setValue('NC');
}

function irBuscar(){
	//creando datastore y columnmodel para el catalogo de agencias
	var registro_parametro = Ext.data.Record.create([
						{name: 'ced_bene'},
						{name: 'nombene'},
						{name: 'apebene'},
						{name: 'dirbene'},
						{name: 'sc_cuenta'},
						{name: 'rifben'},
						{name: 'telbene'},
						{name: 'celbene'},
						{name: 'email'},
						{name: 'codpai'},
						{name: 'codest'},
						{name: 'codmun'},
						{name: 'codpar'},
						{name: 'codbansig'},
						{name: 'codban'},
						{name: 'ctaban'},
						{name: 'fecregben'},
						{name: 'nacben'},
						{name: 'numpasben'},	
						{name: 'codtipcta'},
						{name: 'tipconben'},
						{name: 'codtipcta'}						
		]);	
	var dsparametro =  new Ext.data.Store({
			reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},registro_parametro)
		});						
	var colmodelcatparametro = new Ext.grid.ColumnModel([
          				{header: "Cedula", width: 30, sortable: true,   dataIndex: 'ced_bene'},
          				{header: "Nombre", width: 50, sortable: true, dataIndex: 'nombene'},
          				{header: "Apellido", width: 50, sortable: true, dataIndex: 'apebene'},
          				{header: "Direccion", width: 50, sortable: true, dataIndex: 'dirbene'}          				
        ]);
	//fin creando datastore y columnmodel para el catalogo de agencias	
	comcatparametrocla = new com.sigesp.vista.comCatalogo({
		titvencat: 'Catalogo de Beneficiarios',
		anchoformbus: 450,
		altoformbus:100,
		anchogrid: 450,
		altogrid: 400,
		anchoven: 500,
		altoven: 400,
		datosgridcat: dsparametro,
		colmodelocat: colmodelcatparametro,
		arrfiltro:[{etiqueta:'Cedula',id:'coage',valor:'ced_bene'}],
		rutacontrolador:'../../controlador/rpc/sigesp_ctr_rpc_beneficiario.php',
		parametros: 'ObjSon='+Ext.util.JSON.encode({'operacion': 'catalogo_beneficiario'}),
		tipbus:'L',
		setdatastyle:'F',
		autoScroll:false,
		formulario:frmMovimientoBanco,
	    onAceptar:true,
	    fnOnAceptar:deshabilitarCedula
	});
	
	function deshabilitarCedula(){
		Ext.getCmp('ced_bene').disable();
	}
	comcatparametrocla.mostrarVentana();  
}

function irGuardar(){
	var cadjson = '';
	if(Actualizar == null) {
		cadjson      = getItems(frmMovimientoBanco,'incluir','N',null,null);
	} 
    else {
    	cadjson      = getItems(frmMovimientoBanco,'actualizar','N',null,null);
    }	
	try {
		var objjson = Ext.util.JSON.decode(cadjson);
		if (typeof(objjson) == 'object') {
			var parametros = 'ObjSon=' + cadjson;
			Ext.Ajax.request({ 
				url : '../../controlador/rpc/sigesp_ctr_rpc_beneficiario.php',
				params : parametros,
				method: 'POST',
				success: function ( result, request){
					var codigo = result.responseText;
					if(String.trim(codigo) == '1'){
						Ext.Msg.show({
							title:'Mensaje',
							msg: exitoguardar,
							buttons: Ext.Msg.OK,
							icon: Ext.MessageBox.INFO
						    });
						limpiarFormulario(frmMovimientoBanco);
						Actualizar=null;
					}
					else
					{
						Ext.Msg.show({
							title:'Mensaje',
							msg: errorguardar,
							buttons: Ext.Msg.OK,
							icon: Ext.MessageBox.ERROR
						 });
					}
				}	
			});
		}
	}	
	catch(e){
			//alert('Verifique los datos, esta insertando caracteres invalidos '+e);
	}	
}

function irEliminar(){
	
	function respuesta(btn){
		if(btn=='yes'){
			var cadjson = getItems(frmMovimientoBanco,'eliminar','N',null,null);
			try {
				var objjson = Ext.util.JSON.decode(cadjson);
				if (typeof(objjson) == 'object') {
					var parametros = 'ObjSon=' + cadjson;
					Ext.Ajax.request({
						url : '../../controlador/rpc/sigesp_ctr_rpc_beneficiario.php',
						params : parametros,
						method: 'POST',
						success: function ( result, request){
							var codigo = result.responseText;
							if(String.trim(codigo) == '1'){
								Ext.Msg.show({
									title:'Mensaje',
									msg: 'Registro eliminado con exito',
									buttons: Ext.Msg.OK,
									icon: Ext.MessageBox.INFO
								    });
								limpiarFormulario(frmMovimientoBanco);
								Actualizar=null;
							}
							else{
								Ext.Msg.show({
									title:'Mensaje',
									msg: 'Error al tratar de eliminar el registro <br>',
									buttons: Ext.Msg.OK,
									icon: Ext.MessageBox.ERROR
								    });
							}							
						}	
					});
				}
			}
			catch(e){
				alert('error'+e);
			}
		}
	}	
	if(Actualizar){
		  Ext.MessageBox.confirm('Confirmar', '&#191;Desea eliminar este registro&#63;', respuesta);
	}
	else{
		Ext.Msg.show({
				title:'Mensaje',
				msg: 'El registro debe estar guardado para poder eliminarlo, verifique por favor',
				buttons: Ext.Msg.OK,
				icon: Ext.MessageBox.ERROR
		}); 
	}
}

function irImprimir(){
	
	if(Ext.getCmp('orden').items.items[0].checked)
	{
		orden = Ext.getCmp('orden').items.items[0].inputValue;
	}
	else if (Ext.getCmp('orden').items.items[1].checked)
	{
		orden = Ext.getCmp('orden').items.items[1].inputValue;
	}
	else if(Ext.getCmp('orden').items.items[2].checked)	
	{
		orden = Ext.getCmp('orden').items.items[2].inputValue;
	}
	obtenerMensaje('procesar','','Buscando Datos');
	var JSONObject = {
		'operacion'    : 'buscarBeneReporte',
		'ced_benedesde' : Ext.getCmp('ced_benedesde').getValue(),
		'ced_benehasta' : Ext.getCmp('ced_benehasta').getValue(),
		'orden'         : orden
	}			
	var ObjSon = JSON.stringify(JSONObject);
	var parametros = 'ObjSon='+ObjSon; 
	Ext.Ajax.request({
		url : '../../controlador/rpc/sigesp_ctr_rpc_reporteBeneficiarios.php',
		params : parametros,
		method: 'POST',
		success: function ( resultado, request){
			Ext.Msg.hide();
			var datos = resultado.responseText;
			if (datos!=''){		    	
				abrirVentana(datos);
			}   
			else
			{
				Ext.MessageBox.alert('Mensaje', 'No existen datos para imprimir');  
			}
		}	
	});
}
