///**//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// * @FECHA DE CREACION: 17-11-2012
// * @DESARROLLADOR: ING. CARLOS ZAMBRANO
// * @DESCRIPCION: js correspondiente a la vista de movimientos de banco
///**//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

var frmProgPago = null;  //instancia del formulario de programacion de pagos
var gridSolicitud=null;
var Actualizar = null;
var numfilaaux = -1;
var Acumulador = 0;

barraherramienta = true;
Ext.onReady(function()
{
	
	Ext.QuickTips.init();
	Ext.BLANK_IMAGE_URL = '../../base/librerias/js/ext/resources/images/default/s.gif';
//----------------------------------------------------------------------------------------------------------------------------------
//**********************************************************************************************************************************	
//                                 				INICIO DEL FORMULARIO DETALLES SOLICITUDES
//**********************************************************************************************************************************
	//Creando el campo de solicitudes a programar 
	var reSolicitud = Ext.data.Record.create([
						{name: 'numsol'}, 
						{name: 'monsol'},
						{name: 'saldo'},  
						{name: 'fecemisol'}, 
						{name: 'codproben'},
						{name: 'fecprog'}
						]);

	var dsSolicitud =  new Ext.data.Store({
						reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reSolicitud)
					});
    						
	var cmSolicitud = new Ext.grid.ColumnModel([
						new Ext.grid.CheckboxSelectionModel(),
						{header: "<CENTER>Solicitud</CENTER>", align: 'center', width: 50, sortable: true, dataIndex: 'numsol'},
						{header: "<CENTER>Monto</CENTER>", align: 'center', width: 40, sortable: true, dataIndex: 'monsol'},
						{header: "<CENTER>Saldo</CENTER>", align: 'center', width: 40, sortable: true, dataIndex: 'saldo'},
						{header: "<CENTER>Fecha</CENTER>", align: 'center', width: 40, sortable: true, dataIndex: 'fecemisol',renderer:formatoFechaGrid},
						{header: "<CENTER>Proveedor / Beneficiario</CENTER>", align: 'center', width: 80, sortable: true, dataIndex: 'codproben'},
						{header: "<CENTER>Fecha Programada</CENTER>", align: 'center', width: 50, sortable: true, dataIndex: 'fecprog'}
					]);

	//creando datastore y columnmodel para la grid de solicitudes a programar
	 gridSolicitud = new Ext.grid.EditorGridPanel({
	 		width:850,
	 		height:280,
			frame:true,
			title:"<H1 align='center'>Solicitudes a Programar</H1>",
			style: 'position:absolute;left:10px;top:285px',
			autoScroll:true,
     		border:true,
     		ds: dsSolicitud,
       		cm: cmSolicitud,
			sm:new Ext.grid.CheckboxSelectionModel({singleSelect:false}),
       		stripeRows: true,
      		viewConfig: {forceFit:true}
			//bbar: 
	});
	 
//-----------------------------------------------------------------------------------------------------------------------	
// Creando el pase de data de la grid a la pantalla
	gridSolicitud.getSelectionModel().on({
		'rowselect': {
			fn: function(sm, numFila, registro)
			{
				monto=ue_formato_calculo(registro.get('monsol'));
				Acumulador=ue_formato_calculo(Acumulador);
				Acumulador=parseFloat(monto)+parseFloat(Acumulador);
				Acumulador=uf_convertir(Acumulador);
				Ext.getCmp('totalprog').setValue(Acumulador);
				numfilaaux=numFila;
			}
		},
		'rowdeselect': {
			fn: function(sm, numFila, registro)
			{
				monto=ue_formato_calculo(registro.get('monsol'));
				Acumulador=ue_formato_calculo(Acumulador);
				Acumulador=parseFloat(Acumulador)-parseFloat(monto);
				Acumulador=uf_convertir(Acumulador);
				Ext.getCmp('totalprog').setValue(Acumulador);
				numfilaaux=numFila;
				registro.set('fecprog','');
			}
		}
	});
//-----------------------------------------------------------------------------------------------------------------------	
	var frmTotalProgramado = new Ext.form.FieldSet({ 
			width: 280,
			height: 87,
			style: 'position:absolute;left:10px;top:585px',
			frame: true,
			cls: 'fondo',
			autoScroll:false,
			items: [{
					layout:"column",
					border:false,
					items: [{
							layout:"form",
							border:false,
							laberWidth:100,
							items: [{
									xtype:"textfield",
									fieldLabel:'Total Programado',
									labelSeparator:'',
									id:'totalprog',
									width:150
								   }]
							}]
					}]
		});
//----------------------------------------------------------------------------------------------------------------------------------	 
	//creacion del formulario datos del cheque
	var frmDetaSolicitudes = new Ext.form.FieldSet({ 
    	title:"Detalles Solicitudes",
		style: 'position:absolute;left:10px;top:170px',
		border:true,
		width: 850,
		cls :'fondo',
		height: 100,
		items: [{	
				style:'position:absolute;left:20px;top:15px',
				layout:"column",
				border:false,
				items: [{
						layout:"form",
						border:false,
						labelWidth:118,
						items: [{
								 xtype:"datefield",
								 labelSeparator:'',
								 fieldLabel:'Fecha Programada',
								 name:'fechaprog',
								 id:'fecpagsol',
								 width:150,
								 binding:true,
								 value: obtenerFechaActual(),
								 hiddenvalue:'',
								 defaultvalue:'1900-01-01',
								 allowBlank:true,
								 autoCreate:{tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789/');"}
							}]
					}]
				},
				{
				style:'position:absolute;left:552px;top:15px',
				layout:"column",
				border:false,
				items: [{
						layout:"form",
						border:false,
						labelWidth:118,
						items: [{
								xtype:"textfield",
								labelSeparator:'',
								fieldLabel:'Total Programado',
								name:'totalprog',
								id:'totalprog',
								width:150,
								binding:true,
								hiddenvalue:'',
								allowBlank:true,
								readOnly:true
							}]
					}]
				},
				{
				style:'position:absolute;left:680px;top:50px',
				layout:"column",
				border:false,
				items: [{
						layout:"form",
						border:false,
						items: [{
								 xtype:"button",
								 text:'Procesar Informaci&#243;n',
								 id:'btnaceptar',
								 iconCls:'bmenuaceptar',
								 handler: function()
								 {
									  arrSolicitudesprog = gridSolicitud.getSelectionModel().getSelections();
									  total = arrSolicitudesprog.length;
									  if(Ext.getCmp('fecpagsol').getValue()=='')
									  {
										  Ext.Msg.show({
											title:'Mensaje',
											msg:'Fecha de programaci&#243;n debe ser mayor a la de la solicitud',
											buttons: Ext.Msg.OK,
											icon: Ext.MessageBox.INFO
											});
									  }
									  else if((Ext.getCmp('codban').getValue()=='')||(Ext.getCmp('ctaban').getValue()==''))
									  {
										  Ext.Msg.show({
											title:'Mensaje',
											msg:'Debe seleccionar un banco y una cuenta antes de programar una solicitud!',
											buttons: Ext.Msg.OK,
											icon: Ext.MessageBox.INFO
											});
									  }
									  else if(Ext.getCmp('fecpagsol').getValue()!='')
									  {
										  for (i=0; i < total; i++)
										  {
												var fechaprogramada=Ext.getCmp('fecpagsol').getValue();
												var fechasolicitud2=formatoFechaGrid(arrSolicitudesprog[i].get('fecemisol'));
												fechaprogramada= fechaprogramada.format(Date.patterns.fechacorta);
												compara=ue_comparar_intervalo(fechaprogramada, fechasolicitud2);
												if (compara)
												{
													if (fechaprogramada==fechasolicitud2)
													{
														arrSolicitudesprog[i].set('fecprog',fechaprogramada);
													}
													else
													{
														Ext.Msg.show({
														title:'Mensaje',
														msg:'Fecha de programaci&#243;n debe ser mayor a la de la solicitud',
														buttons: Ext.Msg.OK,
														icon: Ext.MessageBox.INFO
														});
														arrSolicitudesprog[i].set('fecprog',' ');
													}
												}
												else
												{
													arrSolicitudesprog[i].set('fecprog',fechaprogramada);
												}
											}
									  }
								 }
								}]
						}]
				}]
	 				
	});
//----------------------------------------------------------------------------------------------------------------------------------	
//**********************************************************************************************************************************	
//                                 				INICIO DEL FORMULARIO PROGRAMACION DE PAGOS
//**********************************************************************************************************************************
//----------------------------------------------------------------------------------------------------------------------------------

//Creando el campo de banco
	var reg_banco = Ext.data.Record.create([
		{name: 'codban'},
		{name: 'nomban'}
	]);
		
	//componente catalogo de banco
	comcampocatbanco = new com.sigesp.vista.comCatalogoBancos({
		idComponente:'scb',
		anchofieldset: 850,
		reCatalogo: reg_banco,
		rutacontrolador:'../../controlador/scb/sigesp_ctr_scb_comcatbanco.php',
//		rutacontrolador:'../../controlador/scb/sigesp_ctr_scb_conciliacion.php',
		parametros: "ObjSon={'operacion': 'catalogo_banco'",
		posicion:'position:absolute;left:10px;top:40px', 
		tittxt:'Banco',
		idtxt:'codban',
		campovalue:'codban',
		anchoetiquetatext:70,
		anchotext:80,
		anchocoltext:0.19, 
		idlabel:'nomban',
		labelvalue:'nomban',
		anchocoletiqueta:0.55, 
		anchoetiqueta:300,
		binding:'C',
		tipbus:'L',
		hiddenvalue:'',
		defaultvalue:'---',
		allowblank:false
	});
//Fin del componente
//----------------------------------------------------------------------------------------------------------------------------------	
	
// Componente para el catalogo de cuenta de banco
//Creando el campo de proveedor
	var ctabanco = Ext.data.Record.create([
						{name: 'ctaban'},
						{name: 'dencta'},
						{name: 'sc_cuenta'},
						{name: 'denominacion'},
						{name: 'nomban'},
						{name: 'codtipcta'},
						{name: 'nomtipcta'},
						{name: 'fecapr'},
						{name: 'feccie'},
						{name: 'estact'}
				]);
		
	//componente catalogo de proveedores
	comcampocatctabanco = new com.sigesp.vista.comCatalogoCtaBancos({
		idComponente:'scb',
		anchofieldset: 850,
		reCatalogo: ctabanco,
		rutacontrolador:'../../controlador/scb/sigesp_ctr_scb_comcatctabanco.php',
		parametros: "ObjSon={'operacion': 'catalogo_ctabanco'",
		posicion:'position:absolute;left:10px;top:70px', 
		tittxt:'Cuenta',
		idtxt:'ctaban',
		campovalue:'ctaban',
		anchoetiquetatext:70,
		anchotext:150,
		anchocoltext:0.28, 
		idlabel:'dencta',
		labelvalue:'dencta',
		anchocoletiqueta:0.55, 
		anchoetiqueta:300,
		arrtxtfiltro:['codban'],
		binding:'C',
		tipbus:'L',
		hiddenvalue:'',
		defaultvalue:'---',
		allowblank:false,
		validarMostrar:1,
		fnValidarMostrar: validarCatalogoBanco,
		msjValidarMostrar: 'Debe seleccionar el Banco asociado a la Cuenta',
		onAceptar:true,
		fnOnAceptar:buscarSaldo
	});
	//fin componente catalogo de proveedores

// Fin del componente del catalogo de cuenta bancaria
//----------------------------------------------------------------------------------------------------------------------------------
//********************************************************************************************************************************
//Creacion del formulario
	var Xpos = ((screen.width/2)-(450));
	frmProgPago = new Ext.FormPanel({
		applyTo: 'formulario',
		width: 900,
		height: 500,
		title: "<H1 align='center'>Programaci&#243;n de Pagos</H1>",
		frame: true,
		autoScroll: true,
		style: 'position:absolute;margin-left:'+Xpos+'px;margin-top:20px;',
		items: [{
				xtype:"fieldset", 
				style: 'position:absolute;left:10px;top:10px',
				border:true,
				width: 850,
				cls :'fondo',
				height: 150,
				items: [{
						style:'position:absolute;left:-60px;top:10px',
						layout:"column",
						border:false,
						items: [{
								layout:"form",
								border:false,
								labelWidth:150,
								items:[{
										xtype:"radiogroup",
										labelSeparator:'',
										columns: [150, 150],
										id:'tipo_proben',		
										binding:true,
										items: [{
												boxLabel: "Proveedor", 
												name: "rbstipopb", 
												inputValue: 'P', 
												listeners:{	
													'check': function (checkbox, checked) 
													{
														if(checked)
														{
															Ext.getCmp('esttipvia').setValue(false);
															buscarsolicitudes('P');
															Ext.getCmp('esttipvia').disable();
															Ext.getCmp('totalprog').setValue('');
															Acumulador=0;
															numfilaaux=-1;
														}
													}
												}
												},
												{
												boxLabel: "Beneficiario", 
												name: "rbstipopb", 
												inputValue: 'B',
												listeners:{	
													'check': function (checkbox, checked) 
													{
													if(checked)
													{
														buscarsolicitudes('B');
														Ext.getCmp('esttipvia').enable();
														Ext.getCmp('totalprog').setValue('');
														Acumulador=0;
														numfilaaux=-1;
													}
													}
												}
												}]
										}]
							}]
						},
				{
				style:'position:absolute;left:616px;top:10px',
				layout:"column",
				border:false,
				items: [{
						layout:"form",
						border:false,
						labelWidth:55,
						items: [{
								xtype:"checkbox",
								fieldLabel:'Vi&#225;tico',
								id: 'esttipvia',
								inputValue:1,
								binding:true,
								hiddenvalue:'',
								defaultvalue:'0',
								allowBlank:false,
								disabled:'true',
								listeners:{	
									'check': function (checkbox, checked) 
									{
										if(checked)
										{
											buscarsolicitudes('B');
											Ext.getCmp('totalprog').setValue('');
											Acumulador=0;
											numfilaaux=-1;
										}
									}
								}
							}]
					}]
				},
				comcampocatbanco.fieldsetCatalogo,
				comcampocatctabanco.fieldsetCatalogo,
				{
				style:'position:absolute;left:20px;top:110px',
				layout:"column",
				border:false,
				items: [{
						layout:"form",
						border:false,
						labelWidth:70,
						items: [{
								xtype:"textfield",
								labelSeparator:'',
								fieldLabel:'Disponible',
								name:'disponible',
								id:'dispmov', //FALTA ID CORRECTO
								width:150,
								binding:true,
								hiddenvalue:'',
								allowBlank:true,
								autoCreate:{tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789/');"},
								readOnly:true
							}]
						}]
				}]	
			},frmDetaSolicitudes,gridSolicitud]
	});			
});

//-------------------------------------------------------------------------------------------------------------------------------        
//**********************************************************************************************************************************	
//                                  INICIO DE FUNCIONES PARA LOS CATALOGOS DE BUSQUEDA Y VALIDACIONES 
//**********************************************************************************************************************************
//funcion para validar si dentro del catalogo de banco se ha seleccionado alguna entidad bancaria
function validarCatalogoBanco(){
	var unidadOk = true;
	if(Ext.getCmp('codban').getValue()==''){
		unidadOk = false;
	}
	
	return unidadOk;
}
//----------------------------------------------------------------------------------------------------------------------------------
function buscarSaldo()
{
	var codigoban = Ext.getCmp('codban').getValue();
	var codigoctaban = Ext.getCmp('ctaban').getValue();
	var myJSONObject = {
				"operacion":"buscarsaldo",
				"codban":codigoban,
				"codcta":codigoctaban 
			};
				
	var ObjSon=JSON.stringify(myJSONObject);
	var parametros ='ObjSon='+ObjSon;
	Ext.Ajax.request({
		url: '../../controlador/scb/sigesp_ctr_scb_progpago.php',
		params: parametros,
		method: 'POST',
		success: function ( result, request )
		{ 
	    	var saldo = result.responseText;
			if (saldo != "")
			{
				Ext.getCmp('dispmov').setValue(saldo);
			}
			else
			{
				Ext.getCmp('dispmov').setValue(0.00);
			}
		},
		failure: function ( result, request)
		{ 
			Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
		}
	});	
}

function buscarsolicitudes(tipproben)
{
	obtenerMensaje('procesar','','Buscando Datos');
	if (Ext.getCmp('esttipvia').checked)
	{
		tipvia='1';
	}
	else
	{
		tipvia='0';
	}
	var JSONObject = {
			'operacion'   : 'buscar_solicitudes',
			'tipproben' : tipproben,
			'tipvia' : tipvia
		}
	var ObjSon = JSON.stringify(JSONObject);
	var parametros = 'ObjSon='+ObjSon; 
	Ext.Ajax.request({
		url : '../../controlador/scb/sigesp_ctr_scb_progpago.php',
		params : parametros,
		method: 'POST',
		success: function ( resultado, request){
			Ext.Msg.hide();
			var datos = resultado.responseText;
			var objetoSolicitudes = eval('(' + datos + ')');
			if(objetoSolicitudes!=''){
				if(objetoSolicitudes!='0'){
					if(objetoSolicitudes.raiz==null || objetoSolicitudes.raiz ==''){
						Ext.MessageBox.show({
							title:'Advertencia',
							msg:'No existen datos para mostrar',
							buttons: Ext.Msg.OK,
							icon: Ext.MessageBox.WARNING
		 				});
						gridSolicitud.store.removeAll();
						
					}
					else{
						gridSolicitud.getStore().loadData(objetoSolicitudes);
					
					}
				}
			}
		}	
	});
}

//----------------------------------------------------------------------------------------------------------------------------------
function irCancelar(){
	limpiarFormulario(frmProgPago);
	gridSolicitud.store.removeAll();

}

function irNuevo(){
	limpiarFormulario(frmProgPago);
	gridSolicitud.store.removeAll();
}

function irBuscar(){
}

function irGuardar(){
	valido=true;
	var codigoban = Ext.getCmp('codban').getValue();
	var codigoctaban = Ext.getCmp('ctaban').getValue();
	var prov_benef = '';
	arrSolicitudesProg = gridSolicitud.getSelectionModel().getSelections();
	total = arrSolicitudesProg.length;
	var radio= Ext.getCmp('tipo_proben');
	for (var j = 0; j < radio.items.length; j++)
	{
      if (radio.items.items[j].checked)
	  {
      	proben = radio.items.items[j].inputValue;
		
       break;
      }
    }
	if (Ext.getCmp('esttipvia').checked)
	{
		tipvia='1';
	}
	else
	{
		tipvia='0';
	}
	if (total>0)
	{			
		for (i=0; i < total; i++)
		{
			Delay(500);
			obtenerMensaje('procesar','','Procesando Datos');
			var JSONObject = {
					'operacion' : 'programar',
					'codsis'    : sistema,
					'nomven'    : vista,
					'numsol'    : arrSolicitudesProg[i].get('numsol'),
					'fechaprog' : arrSolicitudesProg[i].get('fecprog'),
					'estmov'    : 'P',
					'codban'    : codigoban,
					'ctaban'    : codigoctaban,
					'provee_benef' : prov_benef,
					'tipproben' : proben,
					'tipvia'	: tipvia				
				}
			objdata=JSON.stringify(JSONObject);
			var parametros = 'ObjSon='+objdata; 
			Ext.Ajax.request({
				url : '../../controlador/scb/sigesp_ctr_scb_progpago.php',
				params : parametros,
				method: 'POST',
				success: function (resultado, request)
				{ 
					datos = resultado.responseText;
					Ext.Msg.hide();
					if (datos==1)
					{	
						Ext.MessageBox.alert('Mensaje', 'La programacion se ha registrado');
					}
					else
					{
						Ext.MessageBox.alert('Error', 'Ocurrio un error al registrar la programacion');
					}
				},
				failure: function (result,request) 
				{ 
					Ext.Msg.hide();
					Ext.MessageBox.alert('Error', 'Error al procesar la Informacion'); 
				}					
			});
		}
		irCancelar();
	}
	else
	{
		Ext.Msg.hide();
		Ext.MessageBox.alert('Error', 'Seleccione la solicitud a programar y asigne la fecha de programacion'); 
	}
}

function irEliminar(){
	
	function respuesta(btn){
		if(btn=='yes'){
			var cadjson = getItems(frmProgPago,'eliminar','N',null,null);
			try {
				var objjson = Ext.util.JSON.decode(cadjson);
				if (typeof(objjson) == 'object') {
					var parametros = 'ObjSon=' + cadjson;
					Ext.Ajax.request({
						url : '../../controlador/rpc/sigesp_ctr_rpc_beneficiario.php',
						params : parametros,
						method: 'POST',
						success: function ( result, request){
							var codigo = result.responseText;
							if(String.trim(codigo) == '1'){
								Ext.Msg.show({
									title:'Mensaje',
									msg: 'Registro eliminado con exito',
									buttons: Ext.Msg.OK,
									icon: Ext.MessageBox.INFO
								    });
								limpiarFormulario(frmProgPago);
								Actualizar=null;
							}
							else{
								Ext.Msg.show({
								title:'Mensaje',
								msg: 'Error al tratar de eliminar el registro <br>',
								buttons: Ext.Msg.OK,
								icon: Ext.MessageBox.ERROR
							    });
							}							
						}	
					});
				}
			}
			catch(e){
				alert('error'+e);
			}
		}
	}	
	if(Actualizar){
		  Ext.MessageBox.confirm('Confirmar', '&#191;Desea eliminar este registro&#63;', respuesta);
	}
	else{
		Ext.Msg.show({
		title:'Mensaje',
		msg: 'El registro debe estar guardado para poder eliminarlo, verifique por favor',
		buttons: Ext.Msg.OK,
		icon: Ext.MessageBox.ERROR
		}); 
	}
}

function irImprimir(){
	if(Ext.getCmp('orden').items.items[0].checked)
	{
		orden = Ext.getCmp('orden').items.items[0].inputValue;
	}
	else if (Ext.getCmp('orden').items.items[1].checked)
	{
		orden = Ext.getCmp('orden').items.items[1].inputValue;
	}
	else if(Ext.getCmp('orden').items.items[2].checked)	
	{
		orden = Ext.getCmp('orden').items.items[2].inputValue;
	}
	obtenerMensaje('procesar','','Buscando Datos');
	var JSONObject = {
		'operacion'    : 'buscarBeneReporte',
		'ced_benedesde' : Ext.getCmp('ced_benedesde').getValue(),
		'ced_benehasta' : Ext.getCmp('ced_benehasta').getValue(),
		'orden'         : orden
	}			
	var ObjSon = JSON.stringify(JSONObject);
	var parametros = 'ObjSon='+ObjSon; 
	Ext.Ajax.request({
		url : '../../controlador/rpc/sigesp_ctr_rpc_reporteBeneficiarios.php',
		params : parametros,
		method: 'POST',
		success: function ( resultado, request){
			Ext.Msg.hide();
			var datos = resultado.responseText;
		    if (datos!=''){		    	
		    	abrirVentana(datos);
		    }   
		    else
		    {
		    	Ext.MessageBox.alert('Mensaje', 'No existen datos para imprimir');  
		    }
		}	
	});
}

