///**//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// * @FECHA DE CREACION: 17-01-2013
// * @DESARROLLADOR: ING. DOMINGO CALICCHIO
// * @DESCRIPCION: js correspondiente a la vista de libro de banco
///**//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

var frmLibroBanco = null;  //instancia del formulario de libro de banco
var Actualizar = null;
var ruta ='../../controlador/scb/sigesp_ctr_scb_documentos.php'; //ruta del controlador
var fechaPrimera = obtenerPrimerDiaMes();

barraherramienta = true;
Ext.onReady(function()
{
	Ext.QuickTips.init();
	Ext.BLANK_IMAGE_URL = '../../base/librerias/js/ext/resources/images/default/s.gif';
//--------------------------------------------------------------------------------------------------------------------------------	
//**********************************************************************************************************************************	
//                                 			INICIO DEL FORMULARIO LIBRO DE BANCO
//**********************************************************************************************************************************
	//Creando el campo de banco 
	var banco = Ext.data.Record.create([
						{name: 'codban'},
						{name: 'nomban'},
						{name: 'codemp'},
						{name: 'dirban'},
						{name: 'telban'},
						{name: 'conban'},
						{name: 'movcon'},
						{name: 'esttesnac'},
						{name: 'codsudeban'}
				]);
	
	var dsbanco = new Ext.data.Store({
				  	reader: new Ext.data.JsonReader({
				  	root: 'raiz',             
				  	id: "id"},banco)
	  			});
						
	var cmbanco = new Ext.grid.ColumnModel([
          				{header: "<H1 align='center'>C&#243;digo</H1>", width: 20, sortable: true,   dataIndex: 'codban'},
          				{header: "<H1 align='center'>Denominaci&#243;n</H1>", width: 40, sortable: true, dataIndex: 'nomban'}
				]);
	//fin creando datastore y columnmodel para el catalogo de bancos 
	
	//componente campocatalogo para el campo banco
	cmbbanco = new com.sigesp.vista.comCampoCatalogo({
					titvencat: "<H1 align='center'>Cat&#225;logo de Bancos</H1>",
					id: 'catalogobanco',
					anchoformbus: 450,
					altoformbus:100,
					anchogrid: 450,
					altogrid: 400,
					anchoven: 500,
					altoven: 400,
					datosgridcat: dsbanco,
					colmodelocat: cmbanco,
					rutacontrolador:'../../controlador/scb/sigesp_ctr_scb_progpago.php',
					parametros: "ObjSon={'operacion': 'catalogo_banco'}",
					arrfiltro:[{etiqueta:'C&#243;digo',id:'codiban',valor:'codban'},
							   {etiqueta:'Nombre',id:'nombban',valor:'nomban'}],
					posicion:'position:absolute;left:15px;top:5px',
					tittxt:'Banco',
					idtxt:'codban',
					campovalue:'codban',
					anchoetiquetatext:70,
					anchotext:150,
					anchocoltext:0.35,
					idlabel:'nomban',
					labelvalue:'nomban',
					anchocoletiqueta:0.65,
					anchoetiqueta:300,
					tipbus:'L',
					binding:'C',
					hiddenvalue:'',
					defaultvalue:'',
					allowblank:true
				});
	//fin componente para el campo banco
//----------------------------------------------------------------------------------------------------------------------------------	
	//Creando el campo de cuentas de bancos 
	var ctabanco = Ext.data.Record.create([
						{name: 'ctaban'},
						{name: 'dencta'},
						{name: 'sc_cuenta'},
						{name: 'denominacion'},
						{name: 'nomban'},
						{name: 'codtipcta'},
						{name: 'nomtipcta'},
						{name: 'fecapr'},
						{name: 'feccie'},
						{name: 'estact'}
				]);
	
	var dsctabanco = new Ext.data.Store({
					 	reader: new Ext.data.JsonReader({
					 	root: 'raiz',             
					 	id: "id"},ctabanco)
	  			});
						
	var cmctabanco = new Ext.grid.ColumnModel([
          				{header: "<H1 align='center'>C&#243;digo</H1>", width: 30, sortable: true, dataIndex: 'ctaban'},
          				{header: "<H1 align='center'>Denominaci&#243;n</H1>", width: 45, sortable: true, dataIndex: 'dencta'},
						{header: "<H1 align='center'>Tipo</H1>", width: 25, sortable: true, dataIndex: 'nomtipcta' },
						{header: "<H1 align='center'>Contable</H1>", width: 35, sortable: true, dataIndex: 'sc_cuenta'},
						{header: "<H1 align='center'>Descripci&#243;n</H1>", width: 40, sortable: true, dataIndex: 'denominacion'}, //DATO INCORRECTO
						{header: "<H1 align='center'>Apertura</H1>", width: 35, sortable: true, dataIndex: 'fecapr'}
				]);
	//fin creando datastore y columnmodel para el catalogo de cuentas de bancos 
	
	//componente campocatalogo para el campo cuentas de bancos
	cmbctabanco = new com.sigesp.vista.comCampoCatalogo({
					titvencat: "<H1 align='center'>Cat&#225;logo de Cuentas de Bancos</H1>",
					id:'catalagocuenta',
					anchoformbus: 650,
					altoformbus:130,
					anchogrid: 650,
					altogrid: 400,
					anchoven: 700,
					altoven: 400,
					datosgridcat: dsctabanco,
					colmodelocat: cmctabanco,
					rutacontrolador:'../../controlador/scb/sigesp_ctr_scb_progpago.php',
					parametros: "ObjSon={'operacion': 'catalogo_ctabanco'",
					arrfiltro:[{etiqueta:'C&#243;digo',id:'ctasban',valor:'ctaban'},
							   {etiqueta:'Nombre',id:'densban',valor:'dencta'}],
					posicion:'position:absolute;left:15px;top:35px',
					tittxt:'Cuenta',
					idtxt:'ctaban',
					campovalue:'ctaban',
					anchoetiquetatext:70,
					anchotext:150,
					anchocoltext:0.35,
					idlabel:'dencta',
					labelvalue:'dencta',
					anchocoletiqueta:0.65,
					anchoetiqueta:300,
					tipbus:'P',
					binding:'C',
					arrtxtfiltro:['codban'],
					hiddenvalue:'',
					defaultvalue:'',
					allowblank:true,
					validarMostrar:1,
					fnValidarMostrar: validarCatalogoBanco,
					msjValidarMostrar: 'Debe seleccionar el Banco asociado a la Cuenta'
		});
	//fin componente para el campo cuentas de bancos 
//----------------------------------------------------------------------------------------------------------------------------------	  
	function llenarComboConcepto()
	{
		var myJSONObject ={
				"operacion": 'catalogo_concepto'	
		};	
		var ObjSon=JSON.stringify(myJSONObject);
		var parametros = 'ObjSon='+ObjSon; 
		Ext.Ajax.request({
			url : ruta,
			params : parametros,
			method: 'POST',
			success: function (resultado, request) { 
				var datosm = resultado.responseText;  
				if(datosm!='')
				{
					var DatosFor = eval('(' + datosm + ')');
					dsConcepto.loadData(DatosFor);
				}
			}
		});
	}

	var reConcepto = Ext.data.Record.create([
		{name:'codconmov'},
		{name:'denconmov'}
	]);
	
	var dsConcepto =  new Ext.data.Store({
		reader: new Ext.data.JsonReader({root: 'raiz',id: "codconmov"},reConcepto)
	});
	
	var cmbConcepto = new Ext.form.ComboBox({
		store:dsConcepto,
		fieldLabel:'Concepto',
		labelSeparator:'',
		editable:false,
		emptyText:'--- Seleccione ---',
		displayField:'denconmov',
		valueField:'codconmov',
		id:'codcon',
		width:179,
		typeAhead:true,
		triggerAction:'all',
		forceselection:true,
		binding:true,
		mode:'local'
	});
	//fin creando store para el combo tipo operacion
//----------------------------------------------------------------------------------------------------------------------------------
	//creando store para el estatus
	var ordenar = [
				  ['Documento','D'],
				  ['Fecha','F'], 
                  ['Operacion','O']
                  ]; // Arreglo que contiene los Documentos que se pueden controlar
	
	var stordenar = new Ext.data.SimpleStore({
		fields : ['etiqueta','valor'],
		data : ordenar
	});
	//fin creando store para el combo estatus

	//creando objeto combo estatus
	var cmbOrdenar = new Ext.form.ComboBox({
		store : stordenar,
		fieldLabel : 'Ordenar',
		labelSeparator : '',
		editable : false,
		emptyText:'--- Seleccione ---',
		displayField : 'etiqueta',
		valueField : 'valor',
		id : 'codord',
		width : 150,
		typeAhead : true,
		triggerAction : 'all',
		forceselection : true,
		binding : true,
		mode : 'local'
	});
//----------------------------------------------------------------------------------------------------------------------------------
//**********************************************************************************************************************************
//Creacion del formulario
	var Xpos = ((screen.width/2)-(380));
	frmLibroBanco = new Ext.FormPanel({
		applyTo: 'formulario',
		width: 750,
		height: 220,
		title: "<H1 align='center'>Libro de Banco</H1>",
		frame: true,
		style: 'position:absolute;margin-left:'+Xpos+'px;margin-top:20px;',
		items: [{
				xtype:"fieldset", 
		   		style: 'position:absolute;left:10px;top:5px',
				border:true,
				width: 720,
				cls :'fondo',
				height: 175,
				items: [
						cmbbanco.fieldsetCatalogo,
						cmbctabanco.fieldsetCatalogo,
						{
						style:'position:absolute;left:25px;top:75px',
						layout:"column",
						border:false,
						items: [{
								layout:"form",
								border:false,
								labelWidth:70,
								items: [{
										 xtype:"datefield",
										 labelSeparator:'',
										 fieldLabel:'Desde',
										 name:'fechades',
										 id:'fecdes',
										 value: fechaPrimera,
										 width:150,
										 binding:true,
										 hiddenvalue:'',
										 defaultvalue:'1900-01-01',
										 allowBlank:true,
										 autoCreate:{tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789/');"}
									}]
								}]
						},
						{
						style:'position:absolute;left:470px;top:75px',
						layout:"column",
						border:false,
						items: [{
								layout:"form",
								border:false,
								labelWidth:70,
								items: [{
										 xtype:"datefield",
										 labelSeparator:'',
										 fieldLabel:'Hasta',
										 name:'fechahas',
										 id:'fechas',
										 value: new Date().format('Y-m-d'),
										 width:150,
										 binding:true,
										 hiddenvalue:'',
										 defaultvalue:'1900-01-01',
										 allowBlank:true,
										 autoCreate:{tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789/');"}
									}]
								}]
						},
						{
						style:'position:absolute;left:25px;top:105px',
						layout:"column",
						border:false,
						items: [{
								layout:"form",
								border:false,
								labelWidth:70,
								items: [cmbConcepto]
								}]
						},
						{
						style:'position:absolute;left:325px;top:105px',
						layout:"column",
						border:false,
						items: [{
								layout:"form",
								border:false,
								labelWidth:350,
								items: [{
										xtype:"checkbox",
										fieldLabel:'Detallado (solo movimientos con imputaci&#243;n presupuestaria)',
										labelSeparator:'',
										id: 'chkdet',
										inputValue:1,
										binding:true,
										hiddenvalue:'',
										defaultvalue:'0',
										allowBlank:false
									}]
								}]
						},
						{
						style:'position:absolute;left:25px;top:135px',
						layout:"column",
						border:false,
						items: [{
								layout:"form",
								border:false,
								labelWidth:70,
								items: [cmbOrdenar]
								}]
						}]
	 		}]
	});
	llenarComboConcepto();
});
//----------------------------------------------------------------------------------------------------------------------------------
//**********************************************************************************************************************************	
//                                  INICIO DE FUNCIONES PARA LOS CATALOGOS DE BUSQUEDA Y VALIDACIONES 
//**********************************************************************************************************************************
//funcion para validar si dentro del catalogo de banco se ha seleccionado alguna entidad bancaria
	function validarCatalogoBanco()
	{
		var unidadOk = true;
		if(Ext.getCmp('codban').getValue()==''){
			unidadOk = false;
		}
		
		return unidadOk;
	}
//----------------------------------------------------------------------------------------------------------------------------------
//**********************************************************************************************************************************	
//                                  						BOTONES 
//**********************************************************************************************************************************
function irImprimir()
{	
	codban2 = Ext.getCmp('codban').getValue();
	ctaban2 = Ext.getCmp('ctaban').getValue();
	var fecdes2 = Ext.getCmp('fecdes').getValue();
	var fechas2 = Ext.getCmp('fechas').getValue();
	fecdes2 = fecdes2.format(Date.patterns.fechacorta);
	fechas2 = fechas2.format(Date.patterns.fechacorta);
	compara=ue_comparar_intervalo(fecdes2, fechas2);
	var codope = '';
	
	if(Ext.getCmp('codcon').getValue() == '---')
	{
		codope = '--';
		codope2 = 'Ninguno';	
	}
	else if(Ext.getCmp('codcon').getValue() == '001')
	{
		codope = 'ND';
		codope2 = 'DEBITO';	
	}
	else if(Ext.getCmp('codcon').getValue() == '002')
	{
		codope = 'NC';
		codope2 = 'CREDITO';	
	}
	else if(Ext.getCmp('codcon').getValue() == '003')
	{
		codope = 'DP';
		codope2 = 'DEPOSITO';	
	}
	else if(Ext.getCmp('codcon').getValue() == '004')
	{
		codope = 'RE';
		codope2 = 'RETIRO';	
	}
	else if(Ext.getCmp('codcon').getValue() == '005')
	{
		codope = 'CH';
		codope2 = 'CHEQUE';	
	}
	else if(Ext.getCmp('codcon').getValue() == '006')
	{
		codope = 'CH';
		codope2 = 'PAGO JUNTA LIQUIDADORA';	
	}

	if ((compara) && (codban2 != '') && (ctaban2 != ''))
	{
		if(Ext.getCmp('chkdet').checked)
		{
			chkdet2 = 'D';
			tipdes2 = '1';
			var JSONObject = {
					'codban' : codban2,
					'nomban' : Ext.getCmp('nomban').getValue(),	
					'ctaban' : ctaban2,
					'dencta' : Ext.getCmp('dencta').getValue(),
					'fecdes' : fecdes2,
					'fechas' : fechas2,
					'codcon' : codope,
					'descon' : codope2,
					'chkdet' : chkdet2,
					'tipdes' : tipdes2,
					'codord' : Ext.getCmp('codord').getValue()	
			}
			var ObjSon = JSON.stringify(JSONObject);	 
			window.open("reportes/sigesp_scb_rpp_libro_banco_detallado.php?ObjSon="+ObjSon,"menubar=no,toolbar=no,scrollbars=yes,width=800,height=600,left=0,top=0,location=no,resizable=yes");
		}
		else
		{
			chkdet2 = 'C';
			tipdes2 = '0';
			var JSONObject = {
					'codban' : codban2,
					'nomban' : Ext.getCmp('nomban').getValue(),	
					'ctaban' : ctaban2,
					'dencta' : Ext.getCmp('dencta').getValue(),
					'fecdes' : fecdes2,
					'fechas' : fechas2,
					'codcon' : codope,
					'chkdet' : chkdet2,
					'tipdes' : tipdes2,
					'codord' : Ext.getCmp('codord').getValue()	
			}
			var ObjSon = JSON.stringify(JSONObject);	 
			window.open("reportes/sigesp_scb_rpp_libro_banco_pdf.php?ObjSon="+ObjSon,"menubar=no,toolbar=no,scrollbars=yes,width=800,height=600,left=0,top=0,location=no,resizable=yes");
		}
	}
	else
	{
		Ext.Msg.show({
		  title:'Mensaje',
		  msg:'Seleccione los parmetros de bsqueda',
		  buttons: Ext.Msg.OK,
		  icon: Ext.MessageBox.INFO
		  });
	}
}