///**//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// * @FECHA DE CREACION: 17-11-2012
// * @DESARROLLADOR: Ing. Carlos Zambrano
// * @DESCRIPCION: js correspondiente a la vista de emision de cheques
///**//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

var frmEmisionCh = null;  //instancia del formulario de emision de cheques
var gridSolicitud=null;
var Actualizar = null;
var selcatded = 0;
var numfilaaux = -1;
var Acumulador = 0;
var ArrDeducciones = Array();
var ruta ='../../controlador/scb/sigesp_ctr_scb_emision_chq.php'; //ruta del controlador
var numche=null;
var numchequera=null;
var fechaPrimeraP = obtenerPrimerDiaMes();
var fechaPrimeraB = obtenerPrimerDiaMes();
barraherramienta = true;
var Inicio = 0;
Ext.onReady(function()
{
	Ext.QuickTips.init();
	Ext.BLANK_IMAGE_URL = '../../base/librerias/js/ext/resources/images/default/s.gif';
//----------------------------------------------------------------------------------------------------------------------------------
//**********************************************************************************************************************************	
//                                 				INICIO DEL FORMULARIO EMISION DE CHEQUES
//**********************************************************************************************************************************
	//creando store para la tipo concepto
	function llenarComboConceptoCH()
	{
		var myJSONObject ={
				"operacion": 'comboconcepto',
				"mov":'CH'
		};	
		var ObjSon=JSON.stringify(myJSONObject);
		var parametros = 'ObjSon='+ObjSon; 
		Ext.Ajax.request({
			url : ruta,
			params : parametros,
			method: 'POST',
			success: function (resultado, request) { 
				var datosc = resultado.responseText;  
				if(datosc!='')
				{
					var DatosCon = eval('(' + datosc + ')');
					dsConcepto.loadData(DatosCon);
				}
			}
		});
	}

	var reConcepto = Ext.data.Record.create([
	    {name:'codconmov'},
	    {name:'denconmov'}
	]);

	var dsConcepto =  new Ext.data.Store({
		reader: new Ext.data.JsonReader({root: 'raiz',id: "codconmov"},reConcepto)
	});

	var cmbtipoconcepto = new Ext.form.ComboBox({
		store:dsConcepto,
		fieldLabel:'Tipo Concepto',
		displayField:'denconmov',
		valueField : 'codconmov',
		name: 'concepto',
		id:'codconmov',
		width:200,
		editable : false,
		typeAhead: true,
		triggerAction:'all',
		forceselection:true,
		binding:true,
		mode:'local'
	});

//----------------------------------------------------------------------------------------------------------------------------------
	//Creando el campo de banco 
	var banco = Ext.data.Record.create([
						{name: 'codban'},
						{name: 'nomban'}
				]);
	
	var dsbanco = new Ext.data.Store({
				  	reader: new Ext.data.JsonReader({
				  	root: 'raiz',             
				  	id: "id"},banco)
	  			});
						
	var colmodelcatbanco = new Ext.grid.ColumnModel([
          				{header: "<H1 align='center'>C&#243;digo</H1>", width: 20, sortable: true,   dataIndex: 'codban'},
          				{header: "<H1 align='center'>Nombre</H1>", width: 40, sortable: true, dataIndex: 'nomban'}
				]);
	//fin creando datastore y columnmodel para el catalogo de bancos 
	
	//componente campocatalogo para el campo banco
	comcampocatbanco = new com.sigesp.vista.comCampoCatalogo({
		titvencat: "<H1 align='center'>Cat&#225;logo de Bancos</H1>",
		anchoformbus: 450,
		altoformbus:100,
		anchogrid: 450,
		altogrid: 400,
		anchoven: 500,
		altoven: 400,
		datosgridcat: dsbanco,
		colmodelocat: colmodelcatbanco,
		rutacontrolador:'../../controlador/scb/sigesp_ctr_scb_progpago.php',
//		rutacontrolador:'../../controlador/scb/sigesp_ctr_scb_conciliacion.php',
		parametros: "ObjSon={'operacion': 'catalogo_banco'}",
		arrfiltro:[{etiqueta:'C&#243;digo',id:'codiban',valor:'codban'},
		           {etiqueta:'Denominaci&#243;n',id:'nombban',valor:'nomban'}],
		           posicion:'position:absolute;left:5px;top:37px',
		           tittxt:'Banco',
		           idtxt:'codban',
		           campovalue:'codban',
		           anchoetiquetatext:100,
		           anchotext:80,
		           anchocoltext:0.45,
		           idlabel:'nomban',
		           labelvalue:'nomban',
		           anchocoletiqueta:0.55,
		           anchoetiqueta:300,
		           tipbus:'L',
		           binding:'C',
		           hiddenvalue:'',
		           defaultvalue:'---',
		           allowblank:true
	});
	//fin componente para el campo banco 
//----------------------------------------------------------------------------------------------------------------------------------	
	//Creando el campo de cuentas de bancos 
	var ctabanco = Ext.data.Record.create([
						{name: 'ctaban'},
						{name: 'dencta'},
						{name: 'sc_cuenta'},
						{name: 'denominacion'},
						{name: 'nomban'},
						{name: 'codtipcta'},
						{name: 'nomtipcta'},
						{name: 'fecapr'},
						{name: 'feccie'},
						{name: 'estact'}
				]);
	
	var dsctabanco = new Ext.data.Store({
					 	reader: new Ext.data.JsonReader({
					 	root: 'raiz',             
					 	id: "id"},ctabanco)
	  			});
						
	var colmodelcatctabanco = new Ext.grid.ColumnModel([
          				{header: "<H1 align='center'>C&#243;digo</H1>", width: 60, sortable: true, dataIndex: 'ctaban'},
          				{header: "<H1 align='center'>Denominaci&#243;n</H1>", width: 45, sortable: true, dataIndex: 'dencta'},
						{header: "<H1 align='center'>Tipo</H1>", width: 25, sortable: true, dataIndex: 'nomtipcta' },
						{header: "<H1 align='center'>Contable</H1>", width: 35, sortable: true, dataIndex: 'sc_cuenta'},
						{header: "<H1 align='center'>Descrpci&#243;n</H1>", width: 40, sortable: true, dataIndex: 'denominacion'}, 
						{header: "<H1 align='center'>Apertura</H1>", width: 35, sortable: true, dataIndex: 'fecapr'}
				]);
	//fin creando datastore y columnmodel para el catalogo de cuentas de bancos 
	
	//componente campocatalogo para el campo cuentas de bancos
	comcampocatctabanco = new com.sigesp.vista.comCampoCatalogo({
		titvencat: "<H1 align='center'>Cat&#225;logo de Cuentas de Bancos</H1>",
		anchoformbus: 680,
		altoformbus:130,
		anchogrid: 680,
		altogrid: 400,
		anchoven: 700,
		altoven: 400,
		datosgridcat: dsctabanco,
		colmodelocat: colmodelcatctabanco,
		rutacontrolador:'../../controlador/scb/sigesp_ctr_scb_progpago.php',
		parametros: "ObjSon={'operacion': 'catalogo_ctabanco'",
		arrfiltro:[{etiqueta:'C&#243;digo',id:'ctaiban',valor:'ctaban'},
		           {etiqueta:'Denominaci&#243;n',id:'deniban',valor:'dencta'}],
		           posicion:'position:absolute;left:5px;top:65px',
		           tittxt:'Cuenta',
		           idtxt:'ctaban',
		           campovalue:'ctaban',
		           anchoetiquetatext:100,
		           anchotext:200,
		           anchocoltext:0.45,
		           idlabel:'dencta',
		           labelvalue:'dencta',
		           anchocoletiqueta:0.55,
		           anchoetiqueta:300,
		           tipbus:'P',
		           binding:'C',
		           arrtxtfiltro:['codban'],
		           hiddenvalue:'',
		           defaultvalue:'---',
		           allowblank:true,
		           validarMostrar:1,
		           fnValidarMostrar: validarCatalogoBanco,
		           msjValidarMostrar: 'Debe seleccionar el Banco asociado a la Cuenta',
		           onAceptar:true,
		           fnOnAceptar:buscarSaldo
	});
	//fin componente para el campo cuentas de bancos 
//----------------------------------------------------------------------------------------------------------------------------------
	//Creando el campo de solicitudes a programar 
	var reSolicitud = Ext.data.Record.create([
						{name: 'numsolicitud'}, 
						{name: 'consolicitud'},
						{name: 'monsolicitud'},
						{name: 'montopendiente'},
						{name: 'montop'},
						{name: 'codfuefin'},
						{name: 'fechapropag'},
						{name: 'nombenalt'}
						]);

	var dsSolicitud =  new Ext.data.Store({
						reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reSolicitud)
					});
    						
	var cmSolicitud = new Ext.grid.ColumnModel([
						new Ext.grid.CheckboxSelectionModel(),
						{header: "<CENTER>Solicitud</CENTER>", width: 50, sortable: true, dataIndex: 'numsolicitud'},
						{header: "<CENTER>Concepto Solicitud</CENTER>", width: 50, sortable: true, dataIndex: 'consolicitud'},
						{header: "<CENTER>Monto Solicitud</CENTER>", width: 50, sortable: true, dataIndex: 'monsolicitud', align: 'right'},	
						{header: "<CENTER>Monto Pendiente</CENTER>", width: 50, sortable: true, dataIndex: 'montopendiente', align: 'right'},
						{header: "<CENTER>Monto a Pagar</CENTER>", width: 50, sortable: true, dataIndex: 'montop', align: 'right', editor: new Ext.form.TextField({allowBlank: false,autoCreate: {tag: 'input', type: 'text', size: '15', autocomplete: 'off', maxlength: '15', onkeypress: "return keyRestrict(event,'0123456789.');"}})}
					]);

	//creando datastore y columnmodel para la grid de solicitudes a programar
	 gridSolicitud = new Ext.grid.EditorGridPanel({
	 		width:917,
	 		height:200,
			frame:true,
			title:"<H1 align='center'>Solicitudes a Programadas</H1>",
			style: 'position:absolute;left:10px;top:375px',
			autoScroll:true,
     		border:true,
     		ds: dsSolicitud,
       		cm: cmSolicitud,
			sm:new Ext.grid.CheckboxSelectionModel({singleSelect:false}),
       		stripeRows: true,
      		viewConfig: {forceFit:true}
			//bbar: 
	});
	 
	//-------------------------------------------------------------------------------------
	
	//Metodo que realiza cambios despues de editar la gridBienes
	gridSolicitud.on('afteredit', function(Obj){
         var registro = Obj.record;
         var montoapag = registro.get('montop');
		 var monsolpendiente = registro.get('montopendiente');
		 var montosol = registro.get('monsolicitud');
		 
		 if (parseFloat(montoapag) <= parseFloat(ue_formato_calculo(monsolpendiente)))
		 {
		 	if(montoapag!='')
			{
        		montoapag = parseFloat(montoapag); 
			}
			 registro.set('montop',formatoNumericoMostrar(montoapag,2,'.',',','','','-',''));
			 Ext.getCmp('monto').setValue(registro.get('montop'));
			 Acumulador=registro.get('montop');
			 Ext.getCmp('monobjret').setValue(registro.get('montop'));
			 Ext.getCmp('conmov').setValue(registro.get('consolicitud'));
		 }
		 else
		 {
		 	Ext.Msg.show({
			title:'Mensaje',
			msg: 'El monto a pagar no puede ser mayor al monto pendiente de la solicitud!',
			buttons: Ext.Msg.OK,
			icon: Ext.MessageBox.INFO
			});
			registro.set('montop',registro.get('montopendiente'));
		 }

	});
    // Metodo que realiza en pase de info. del grid al formulario	
	gridSolicitud.getSelectionModel().on({
		'rowselect': {
			fn: function(sm, numFila, registro)
			{
				var bancop=Ext.getCmp('codban').getValue();
				var cuentap=Ext.getCmp('ctaban').getValue();
				var conceptop=Ext.getCmp('conmov').getValue();
				
				if (Inicio==0)
				{
					//////////////////////////////////////////////////////////////////////////////
					Inicio++;
					Ext.getCmp('conmov').setValue(registro.get('consolicitud'));
					Ext.getCmp('monto').setValue(registro.get('montop'));
					Ext.getCmp('monobjret').setValue(registro.get('montop'));
					//////////////////////////////////////////////////////////////////////////////
					monto=ue_formato_calculo(registro.get('montop'));
					Acumulador=ue_formato_calculo(Acumulador);
					Acumulador=parseFloat(monto)+parseFloat(Acumulador);
					Acumulador=uf_convertir(Acumulador);
					Ext.getCmp('monto').setValue(Acumulador);
					Ext.getCmp('monobjret').setValue(Acumulador);
					Ext.getCmp('monret').setValue(0,00);
				}
				else
				{
					if (conceptop!=registro.get('consolicitud'))
					{
						Ext.getCmp('conmov').setValue('');
					}
					monto=ue_formato_calculo(registro.get('montop'));
					Acumulador=ue_formato_calculo(Acumulador);
					Acumulador=parseFloat(monto)+parseFloat(Acumulador);
					Acumulador=uf_convertir(Acumulador);
					Ext.getCmp('monto').setValue(Acumulador);
					Ext.getCmp('monobjret').setValue(Acumulador);
					Ext.getCmp('monret').setValue(0,00);
					numfilaaux=numFila;
				}
			}
		},
		'rowdeselect': {
			fn: function(sm, numFila, registro)
			{
				var bancop=Ext.getCmp('codban').getValue();
				var cuentap=Ext.getCmp('ctaban').getValue();
				var concepto=Ext.getCmp('conmov').getValue();
				
				monto=ue_formato_calculo(registro.get('montop'));
				Acumulador=ue_formato_calculo(Acumulador);
				Acumulador=parseFloat(Acumulador)-parseFloat(monto);
				Acumulador=uf_convertir(Acumulador);
				Ext.getCmp('conmov').setValue('');
				Ext.getCmp('monto').setValue(Acumulador);
				Ext.getCmp('monobjret').setValue(Acumulador);
				Ext.getCmp('monret').setValue(0,00);
				
				Inicio=1;
				if (Acumulador=="0,00")
				{
					Ext.getCmp('conmov').setValue('');
					Ext.getCmp('monto').setValue('');
					Ext.getCmp('monobjret').setValue('');
					Inicio=0;
				}
			}
		}
	});
	//-------------------------------------------------------------------------------------

//----------------------------------------------------------------------------------------------------------------------------------	 
	//creacion del formulario datos del cheque
	var frmDatosCheque = new Ext.form.FieldSet({ 
	    	title:'Datos del Cheque',
	    	style: 'position:absolute;left:10px;top:115px',
	    	border:true,
	    	width: 917,
	    	cls :'fondo',
	    	height: 240,
			items: [{
					style:'position:absolute;left:15px;top:18px',
					layout:"column",
					border:false,
					items: [{
							layout:"form",
							border:false,
							labelWidth:101,
							items: [cmbtipoconcepto]
							}]
					},
					comcampocatbanco.fieldsetCatalogo,
					comcampocatctabanco.fieldsetCatalogo,
					{
					style:'position:absolute;left:670px;top:47px',
					layout:"column",
					border:false,
					items: [{
							layout:"form",
							border:false,
							labelWidth:46,
							items: [{
									 xtype:"datefield",
									 labelSeparator:'',
									 fieldLabel:'Fecha',
									 name:'fechamov',		
									 id:'fecmov',			
									 width:150,
									 binding:true,
									 hiddenvalue:'',
									 value: obtenerFechaActual(),
									 defaultvalue:'1900-01-01',
									 allowBlank:true,
									 autoCreate:{tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789/');"}
									}]
							}]
					},
					{
					style:'position:absolute;left:15px;top:103px',
					layout:"column",
					border:false,
					items: [{
							layout:"form",
							border:false,
							labelWidth:100,
							items: [{
									xtype:"textfield",
									labelSeparator:'',
									fieldLabel:'Cuenta Contable',
									name:'cuenta_contable',			
									id:'sc_cuenta',			//ID INCORRECTO
									width:150,
									binding:true,
									hiddenvalue:'',
									defaultvalue:'',
									readOnly:true,
									allowBlank:true,
									autoCreate:{tag: 'input', type: 'text', size: '15', autocomplete: 'off', maxlength: '15', onkeypress: "return keyRestrict(event,'0123456789');"}
								}]
							}]
					},
					{
					style:'position:absolute;left:650px;top:103px',
					layout:"column",
					border:false,
					items: [{
							layout:"form",
							border:false,
							labelWidth:66,
							items: [{
									xtype:"textfield",
									labelSeparator:'',
									fieldLabel:'Disponible',
									name:'disponible',
									id:'dispmov',		//ID INCORRECTO
									width:150,
									binding:true,
									hiddenvalue:'',
									defaultvalue:'',
									allowBlank:true,
									readOnly:true,
									autoCreate:{tag: 'input', type: 'text', size: '15', autocomplete: 'off', maxlength: '15', onkeypress: "return keyRestrict(event,'0123456789');"}
								}]
							}]
					},
					{
					style:'position:absolute;left:15px;top:131px',
					layout:"column",
					border:false,
					items: [{
							layout:"form",
							border:false,
							labelWidth:100,
							items: [{
									xtype:"textfield",
									labelSeparator:'',
									fieldLabel:'Documento',
									name:'documento',
									id:'numdoc',		
									width:150,
									binding:true,
									hiddenvalue:'',
									defaultvalue:'',
									allowBlank:true,
									autoCreate:{tag: 'input', type: 'text', size: '15', autocomplete: 'off', maxlength: '15', onkeypress: "return keyRestrict(event,'abcdefghijklmnopqrstuvwxyz ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789');"},
									listeners:{
											  	'blur' : function(campo)
														 {
															llenar_campo_numdoc(campo.getValue());
														 }
											  }
								}]
							}]
					},
					{
					style:'position:absolute;left:281px;top:131px',
					layout:"column",
					border:false,
					items: [{
							layout:"form",
							border:false,
							items: [{
									 xtype:"button",
									 id:'btnBuscarChq',		//ID INCORRECTO
									 iconCls:'menubuscar',
									 handler: function()
									 { 
									 	CatalogoCheques();
									 }
								}]
							}]
					},
					{
					style:'position:absolute;left:658px;top:131px',
					layout:"column",
					border:false,
					items: [{
							layout:"form",
							border:false,
							labelWidth:58,
							items: [{
									xtype:"textfield",
									labelSeparator:'',
									fieldLabel:'Voucher',
									name:'voucher',
									id:'chevau',		//ID INCORRECTO
									width:150,
									binding:true,
									hiddenvalue:'',
									defaultvalue:'',
									allowBlank:false,
									autoCreate:{tag: 'input', type: 'text', size: '8', autocomplete: 'off', maxlength: '8'},
									listeners:{
										'blur' : function(campo)
										 {
											uf_verificar_voucher(campo.getValue());
										 }
									 }
								}]
							}]
					},
					{
					style:'position:absolute;left:15px;top:159px',
					layout:"column",
					border:false,
					items: [{
							layout:"form",
							border:false,
							labelWidth:100,
							items: [{
									xtype:"textfield",
									labelSeparator:'',
									fieldLabel:'Concepto',
									name:'concepto',
									id:'conmov',		
									width:751,
									binding:true,
									hiddenvalue:'',
									defaultvalue:'',
									autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '300', onkeypress: "return keyRestrict(event,'0123456789 abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ');"},
									allowBlank:true
								}]
							}]
					},
					{	
					style:'position:absolute;left:15px;top:187px',
					layout:"column",
					border:false,
					items: [{
							layout:"form",
							border:false,
							labelWidth:100,
							items: [{
									xtype:"textfield",
									labelSeparator:'',
									fieldLabel:'Monto',
									name:'montomov',
									id:'monto',			//ID INCORRECTO
									width:150,
									binding:true,
									hiddenvalue:'',
									defaultvalue:'',
									allowBlank:true,
									autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '100', onkeypress: "return keyRestrict(event,'0123456789');"}
								}]
							}]
					},
					{
					style:'position:absolute;left:370px;top:187px',
					layout:"column",
					border:false,
					items: [{
							layout:"form",
							border:false,
							labelWidth:50,
							items: [{
									xtype:"textfield",
									labelSeparator:'',
									fieldLabel:'M.O.R.', //CHEQUEAR! SE DEBE LLENAR SOLO COLOCANDO EL MISMO MONTO CON OPCION A MODIFICARLO A UN VALOR < AL MONTO SIEMPRE
									name:'monobre',
									id:'monobjret',  //LISTO
									width:150,
									binding:true,
									hiddenvalue:'',
									defaultvalue:'',
									allowBlank:false
								}]
							}]
					},
					{
					style:'position:absolute;left:616px;top:187px',
					layout:"column",
					border:false,
					items: [{
							layout:"form",
							border:false,
							labelWidth:100,
							items: [{
									xtype:"textfield",
									labelSeparator:'',
									fieldLabel:'Monto Retenido', //CHEQUEAR! ESTE VALOR TAMBIEN LO DEBE MOSTRAR SOLO, VIENE DE UN CALCULO (MONTO_RETENIDO=MONTO-MOR) "CREO QUE ES ASI"
									name:'monret',
									id:'monret',  		//ID INCORRECTO
									width:150,
									binding:true,
									hiddenvalue:'',
									defaultvalue:'',
									allowBlank:false
								}]
							}]
					},
					{
					style:'position:absolute;left:882px;top:187px',
					layout:"column",
					border:false,
					items: [{
							layout:"form",
							border:false,
							items: [{
									 xtype:"button",
									 id:'btnBuscarD',		//ID INCORRECTO
									 iconCls:'menubuscar',
									 handler: function()
									 {
										if ((Ext.getCmp('monto').getValue()=="")||(Ext.getCmp('monobjret').getValue()==""))
										{
											var montoc=0;
											var montocr=0;
										}
										else
										{
											var montoc=parseFloat(Ext.getCmp('monto').getValue());
											var montocr=parseFloat(Ext.getCmp('monobjret').getValue());
										}
										if ((Ext.getCmp('modageret').getValue()=='B')||(Ext.getCmp('estretmil').getValue()=='B'))
										{
											if ((Ext.getCmp('numdoc').getValue()!="")&&(montoc>0)&&(montocr>0)&&(montoc)>=(montocr))   
											{
												CatalogoDeducciones();
											}
											else
											{
												if (Ext.getCmp('numdoc').getValue()=="")
												{
													Ext.Msg.show({
													title:'Mensaje',
													msg:'Introduzca un n&#250;mero de documento',
													buttons: Ext.Msg.OK,
													icon: Ext.MessageBox.INFO
													});
												}
												else if(montoc<=0)
												{
													Ext.Msg.show({
													title:'Mensaje',
													msg:'El monto debe ser mayor a cero(0)',
													buttons: Ext.Msg.OK,
													icon: Ext.MessageBox.INFO
													});
												}
												else if(montocr<=0)
												{
													Ext.Msg.show({
													title:'Mensaje',
													msg:'La base imponible debe ser mayor a cero(0)',
													buttons: Ext.Msg.OK,
													icon: Ext.MessageBox.INFO
													});  	
												}
												else if(montoc<montocr)
												{
													Ext.Msg.show({
													title:'Mensaje',
													msg:'Base imponible no puede ser mayor al monto del documento',
													buttons: Ext.Msg.OK,
													icon: Ext.MessageBox.INFO
													});
												  //f.txtmonobjret.value=uf_convertir(ldec_monto);
												}
											}
										}
										else if ((Ext.getCmp('modageret').getValue()=='B'))
										{
											if ((Ext.getCmp('numdoc').getValue()!="")&&(montoc>0)&&(montocr>0)&&(montoc)>=(montocr))   
											{
												CatalogoDeducciones();
											}
											else
											{
												if (Ext.getCmp('numdoc').getValue()=="")
												{
													Ext.Msg.show({
													title:'Mensaje',
													msg:'Introduzca un n&#250;mero de documento',
													buttons: Ext.Msg.OK,
													icon: Ext.MessageBox.INFO
													});
												}
												else if(montoc<=0)
												{
													Ext.Msg.show({
													title:'Mensaje',
													msg:'El monto debe ser mayor a cero(0)',
													buttons: Ext.Msg.OK,
													icon: Ext.MessageBox.INFO
													});
												}
												else if(montocr<=0)
												{
													Ext.Msg.show({
													title:'Mensaje',
													msg:'La base imponible debe ser mayor a cero(0)',
													buttons: Ext.Msg.OK,
													icon: Ext.MessageBox.INFO
													});  	
												}
												else if(montoc<montocr)
												{
													Ext.Msg.show({
													title:'Mensaje',
													msg:'Base imponible no puede ser mayor al monto del documento',
													buttons: Ext.Msg.OK,
													icon: Ext.MessageBox.INFO
													});
												  //f.txtmonobjret.value=uf_convertir(ldec_monto);
												}
											}
										}
										else
										{
											Ext.Msg.show({
											title:'Mensaje',
											msg:'Las retenciones municipales deben aplicarse a travs del modulo de Cuentas por Pagar',
											buttons: Ext.Msg.OK,
											icon: Ext.MessageBox.INFO
											});
										}
									}													
								}]
							}]
					}]

	});
//----------------------------------------------------------------------------------------------------------------------------------	
//**********************************************************************************************************************************
//Creacion del formulario emision de cheques
	var Xpos = ((screen.width/2)-(475));
	frmEmisionCh = new Ext.FormPanel({			
		applyTo: 'formulario',
		width: 970,
		height: 500,
		title: "<H1 align='center'>Emisi&#243;n de Cheques</H1>",
		frame: true,
		autoScroll: true,
		style: 'position:absolute;margin-left:'+Xpos+'px;margin-top:15px;',
		items: [{
				xtype:"fieldset", 
		    	style: 'position:absolute;left:10px;top:10px',
		    	border:true,
		    	width: 920,
		    	cls :'fondo',
		    	height: 90,
				items: [{
							style:'position:absolute;left:-35px;top:15px',
							layout:"column",
							border:false,
							items: [{
									layout:"form",
									border:false,
									labelWidth:150,
									items:[{
											xtype:"radiogroup",
											labelSeparator:'',
											columns: [150, 150],
											id:'tipproben',		//LISTO
											binding:true,
											items: [{
													boxLabel: "Proveedor", 
													name: "rbstipopb", 
													inputValue: 'P', 
													listeners:{	
														'check': function (checkbox, checked) 
														{
															if(checked)
															{
																Ext.getCmp('conmov').setValue('');
																Ext.getCmp('monto').setValue('');
																Ext.getCmp('monobjret').setValue('');
																numfilaaux=-1;
																Acumulador=0;
																if (Ext.getCmp('confi_ch').getValue()==1)
																{
																	Ext.getCmp('btnBuscarChq').disable();
																}
																valida1=2;
																if ((Ext.getCmp('estciespg').getValue()==1 || Ext.getCmp('estciespi').getValue()==1) && Ext.getCmp('estciescg').getValue()==0 )
																{
																	valida1=0;
																}
																else if(Ext.getCmp('estciespg').getValue()==1 && Ext.getCmp('estciespi').getValue()==1 && Ext.getCmp('estciescg').getValue()==1)
																{
																	Ext.Msg.alert('Mensaje', 'Ya fu procesado el Cierre Contable, No pueden efectuarse movimientos, Contacte al Administrador del Sistema !');
																	valida1=1;
																}
																if ((valida1==0)&&(checked))
																{
																	Ext.Msg.show({
																	title:'Mensaje',
																	msg: 'Ya fu procesado el Cierre Presupuestario, solo sern cargadas Programaciones de Pago asociadas a Recepciones de Documentos netamente Contables !',
																	buttons: Ext.Msg.OK,
																	icon: Ext.MessageBox.INFO,
																	fn: CatalogoProveedores
																	});
																																			
																}
																else
																{
																	CatalogoProveedores();
																}
															}
														}
													}
												},
												{
												boxLabel: "Beneficiario", 
												name: "rbstipopb", 
												inputValue: 'B',
												listeners:{	
													'check': function (checkbox, checked) 
													{
														if(checked)
														{
															Ext.getCmp('conmov').setValue('');
															Ext.getCmp('monto').setValue('');
															Ext.getCmp('monobjret').setValue('');
															numfilaaux=-1;
															Acumulador=0;
															if (Ext.getCmp('confi_ch').getValue()==1)
															{
																Ext.getCmp('btnBuscarChq').disable();
															}
															valida1=2;
															if ((Ext.getCmp('estciespg').getValue()==1 || Ext.getCmp('estciespi').getValue()==1) && Ext.getCmp('estciescg').getValue()==0 )
															{
																valida1=0;
															}
															else if(Ext.getCmp('estciespg').getValue()==1 && Ext.getCmp('estciespi').getValue()==1 && Ext.getCmp('estciescg').getValue()==1)
															{
																Ext.Msg.alert('Mensaje', 'Ya fu procesado el Cierre Contable, No pueden efectuarse movimientos, Contacte al Administrador del Sistema !');
																valida1=1;
															}
															if ((valida1==0)&&(checked))
															{
																Ext.Msg.show({
																title:'Mensaje',
																msg: 'Ya fu procesado el Cierre Presupuestario, solo sern cargadas Programaciones de Pago asociadas a Recepciones de Documentos netamente Contables !',
																buttons: Ext.Msg.OK,
																icon: Ext.MessageBox.INFO,
																fn: CatalogoBeneficiarios
																});
															}
															else
															{
																CatalogoBeneficiarios();
															}
														}
													}
												}
											}]
										}]
								}]
							},
							{
							style:'position:absolute;left:563px;top:17px',
							layout:"column",
							border:false,
							items: [{
									layout:"form",
									border:false,
									labelWidth:153,
									items: [{
											xtype:"textfield",
											labelSeparator:'',
											fieldLabel:'N&#176; Orden Pago Ministerio',
											name:'numordpagmin',
											id:'numordpagmin',		//LISTO
											width:150,
											binding:true,
											hiddenvalue:'',
											defaultvalue:'-',
											allowBlank:true,
											autoCreate:{tag: 'input', type: 'text', size: '15', autocomplete: 'off', maxlength: '15', onkeypress: "return keyRestrict(event,'0123456789');"}
											}]
									}]
							},
							{
							style:'position:absolute;left:882px;top:17px',
							layout:"column",
							border:false,
							items: [{
									layout:"form",
									border:false,
									items: [{
											 xtype:"button",
											 id:'btnBuscarOP',		
											 iconCls:'menubuscar',
											 handler: function()
											 { 
											 	CatalogoNumOrdPagMin();
											 }
											}]
									}]
							},
							{
							style:'position:absolute;left:15px;top:50px',
							layout:"column",
							border:false,
							items: [{
									layout:"form",
									border:false,
									labelWidth:100,
									items: [{
											xtype:"textfield",
											labelSeparator:'',
											fieldLabel:'C&#243;digo',
											name:'codproben',
											id:'codproben',		
											width:150,
											binding:true,
											hiddenvalue:'',
											defaultvalue:'',
											allowBlank:false,
											disabled:true
											}]
									}]
							},
							{					
							layout: "column",
							defaults: {border: false},
							style: 'position:absolute;left:290px;top:50px;font-size:12px;',
							items: [{
									layout: "form",
									border: false,
									labelWidth: 200,
									items: [{xtype: 'label',
									id:'nom_label',	
									text: '-',
									style:'font: 120% sans-serif small-caps'
									}]
								}]
							},
							{
							xtype: 'hidden',
							id: 'estciespg',
							binding:true,
							defaultvalue:'',
							allowBlank:true
							},
							{
							xtype: 'hidden',
							id: 'estciespi',
							binding:true,
							defaultvalue:'',
							allowBlank:true
							},
							{
							xtype: 'hidden',
							id: 'estciescg',
							binding:true,
							defaultvalue:'',
							allowBlank:true
							},
							{
							xtype: 'hidden',
							id: 'codtipfon',
							binding:true,
							defaultvalue:'---',
							allowBlank:true
							},
							{
							xtype: 'hidden',
							id: 'confi_ch',
							binding:true,
							defaultvalue:'',
							allowBlank:true
							},
							{
							xtype: 'hidden',
							id: 'chequera2',
							binding:true,
							defaultvalue:'',
							allowBlank:true
							},
							{
							xtype: 'hidden',
							id: 'nomproben',
							binding:true,
							defaultvalue:'',
							allowBlank:true
							},
							{
							xtype: 'hidden',
							id: 'modageret',
							binding:true,
							defaultvalue:'',
							allowBlank:true
							},
							{
							xtype: 'hidden',
							id: 'estretmil',
							binding:true,
							defaultvalue:'',
							allowBlank:true
							},
							{
							xtype: 'hidden',
							id: 'numchequera',
							binding:true,
							defaultvalue:'',
							allowBlank:true
							},
							{
							xtype: 'hidden',
							id: 'reporte',
							binding:true,
							defaultvalue:'',
							allowBlank:true
							}
					]
			},frmDatosCheque,gridSolicitud]
	});
	llamarVoucher();
	llenarComboConceptoCH();
	verificarEstcieSpg();
	verificarEstcieSpi();
	verificarEstcieScg();
	verificarEstcieCfCh();
	verificarEstModageret();
	verificarEstRetmil();
	buscarReporteCfg();
	Ext.getCmp('btnBuscarChq').disable();
	irNuevo();
});
//----------------------------------------------------------------------------------------------------------------------------------
//**********************************************************************************************************************************	
//                                  INICIO DE FUNCIONES PARA LOS CATALOGOS DE BUSQUEDA Y VALIDACIONES 
//**********************************************************************************************************************************
function llamarVoucher()
{
	var myJSONObject = {
	"operacion":"buscarvoucher" 
	};
			
	var ObjSon=Ext.util.JSON.encode(myJSONObject);
	var parametros ='ObjSon='+ObjSon;
	Ext.Ajax.request({
		url: ruta,
		params: parametros,
		method: 'POST',
		success: function ( result, request ) { 
			var chevau = result.responseText;
			if (chevau != "")
			{
				chevau=chevau.substring(17,25);
				Ext.getCmp('chevau').setValue(chevau);
			}
		},
		failure: function ( result, request){ 
				Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
		}
	});		

}
//----------------------------------------------------------------------------------------------------------------------------------
function verificarEstcieSpg()
{
	var myJSONObject = {
		"operacion":"verificar_estatus_ciespg" 
	};
			
	var ObjSon=Ext.util.JSON.encode(myJSONObject);
	var parametros ='ObjSon='+ObjSon;
	Ext.Ajax.request({
		url: ruta,
		params: parametros,
		method: 'POST',
		success: function ( result, request ) { 
			var ciespg = result.responseText;
			if (ciespg != "")
			{
				Ext.getCmp('estciespg').setValue(ciespg);
			}
		},
		failure: function ( result, request){ 
				Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
		}
	});		
}
//----------------------------------------------------------------------------------------------------------------------------------
function verificarEstcieSpi()
{
	var myJSONObject = {
		"operacion":"verificar_estatus_ciespi" 
	};
			
	var ObjSon=Ext.util.JSON.encode(myJSONObject);
	var parametros ='ObjSon='+ObjSon;
	Ext.Ajax.request({
		url: ruta,
		params: parametros,
		method: 'POST',
		success: function ( result, request ) { 
			var ciespi = result.responseText;
			if (ciespi != "")
			{
				Ext.getCmp('estciespi').setValue(ciespi);
			}
		},
		failure: function ( result, request){ 
				Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
		}
	});		

}
//----------------------------------------------------------------------------------------------------------------------------------
function verificarEstcieScg()
{
	var myJSONObject = {
		"operacion":"verificar_estatus_ciescg" 
	};
			
	var ObjSon=Ext.util.JSON.encode(myJSONObject);
	var parametros ='ObjSon='+ObjSon;
	Ext.Ajax.request({
		url: ruta,
		params: parametros,
		method: 'POST',
		success: function ( result, request ) { 
			var ciescg = result.responseText;
			if (ciescg != "")
			{
				Ext.getCmp('estciescg').setValue(ciescg);
			}
		},
		failure: function ( result, request){ 
				Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
		}
	});		

}
//----------------------------------------------------------------------------------------------------------------------------------
function verificarEstcieCfCh()
{
	var myJSONObject = {
		"operacion":"verificar_estatus_cfch" 
	};
			
	var ObjSon=Ext.util.JSON.encode(myJSONObject);
	var parametros ='ObjSon='+ObjSon;
	Ext.Ajax.request({
		url: ruta,
		params: parametros,
		method: 'POST',
		success: function ( result, request ) { 
			var confich = result.responseText;
			if (confich != "")
			{
				Ext.getCmp('confi_ch').setValue(confich);
			}
		},
		failure: function ( result, request){ 
				Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
		}
	});		

}
//----------------------------------------------------------------------------------------------------------------------------------
function verificarEstModageret()
{
	var myJSONObject = {
		"operacion":"verificar_estatus_modageret" 
	};
			
	var ObjSon=Ext.util.JSON.encode(myJSONObject);
	var parametros ='ObjSon='+ObjSon;
	Ext.Ajax.request({
		url: ruta,
		params: parametros,
		method: 'POST',
		success: function ( result, request ) { 
			var modageret = result.responseText;
			if (modageret != "")
			{
				Ext.getCmp('modageret').setValue(modageret);
			}
		},
		failure: function ( result, request){ 
				Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
		}
	});		

}
//----------------------------------------------------------------------------------------------------------------------------------
function verificarEstRetmil()
{
	var myJSONObject = {
		"operacion":"verificar_estatus_retmil" 
	};
			
	var ObjSon=Ext.util.JSON.encode(myJSONObject);
	var parametros ='ObjSon='+ObjSon;
	Ext.Ajax.request({
		url: ruta,
		params: parametros,
		method: 'POST',
		success: function ( result, request ) { 
			var estretmil = result.responseText;
			if (estretmil != "")
			{
				Ext.getCmp('estretmil').setValue(estretmil);
			}
		},
		failure: function ( result, request){ 
				Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
		}
	});		

}
//----------------------------------------------------------------------------------------------------------------------------------
function buscarReporteCfg()
{
	var myJSONObject = {
		"operacion":"buscar_reporte" 
	};
			
	var ObjSon=Ext.util.JSON.encode(myJSONObject);
	var parametros ='ObjSon='+ObjSon;
	Ext.Ajax.request({
		url: ruta,
		params: parametros,
		method: 'POST',
		success: function ( result, request ) { 
			var reporte = result.responseText;
			if (reporte != "")
			{
				Ext.getCmp('reporte').setValue(reporte);
			}
		},
		failure: function ( result, request){ 
				Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
		}
	});		

}
//----------------------------------------------------------------------------------------------------------------------------------
//funcion para validar si dentro del catalogo de banco se ha seleccionado alguna entidad bancaria
function validarCatalogoBanco()
{
	var unidadOk = true;
	if(Ext.getCmp('codban').getValue()==''){
		unidadOk = false;
	}
	
	return unidadOk;
}
//Funcion que busca un saldo de la cuenta bancaria------------------------------------------------------------------------------------------------------
function buscarSaldo()
{
	var codigoban = Ext.getCmp('codban').getValue();
	var codigoctaban = Ext.getCmp('ctaban').getValue();
	var myJSONObject = {
				"operacion":"buscarsaldo",
				"codban":codigoban,
				"codcta":codigoctaban 
			};
				
	var ObjSon=JSON.stringify(myJSONObject);
	var parametros ='ObjSon='+ObjSon;
	Ext.Ajax.request({
		url: '../../controlador/scb/sigesp_ctr_scb_progpago.php',
		params: parametros,
		method: 'POST',
		success: function ( result, request )
		{ 
	    	var saldo = result.responseText;
			if (saldo != "")
			{
				Ext.getCmp('dispmov').setValue(saldo);
			}
			else
			{
				Ext.getCmp('dispmov').setValue(0.00);
			}
		},
		failure: function ( result, request)
		{ 
			Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
		}
	});
	buscarContable(codigoban,codigoctaban);
}
//Funcion que busca la cta contable de la cta bancaria-----------------------------------------------------------------------------------------------------
function buscarContable(codigoban,codigoctaban)
{
	var myJSONObject = {
		"operacion":"buscarcontablecta",
		"codban":codigoban,
		"codcta":codigoctaban 
	};
				
	var ObjSon=JSON.stringify(myJSONObject);
	var parametros ='ObjSon='+ObjSon;
	Ext.Ajax.request({
		url: ruta,
		params: parametros,
		method: 'POST',
		success: function ( result, request )
		{ 
	    	var cta_con = result.responseText;
			if (cta_con != "")
			{
				Ext.getCmp('sc_cuenta').setValue(cta_con);
			}
			else
			{
				Ext.getCmp('sc_cuenta').setValue('--------------------');
			}
		},
		failure: function ( result, request)
		{ 
			Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
		}
	});
}
//----------------------------------------------------------------------------------------------------------------------------------
function uf_verificar_voucher(campo)
{
	var myJSONObject = {
			"operacion":'verificar_voucher',
			"chevau" : campo
		};
	var ObjSon= JSON.stringify(myJSONObject);
	var parametros ='ObjSon='+ObjSon;
	Ext.Ajax.request({
		url: ruta,
		params: parametros,
		method: 'POST',
		success: function ( result, request ) 
		{ 
	        var voucher = result.responseText;
			if (voucher.length != 0)
			{
				Ext.Msg.show({
							title:'Advertencia',
							msg: 'El nmero de voucher ya existe!',
							buttons: Ext.Msg.OK,
							icon: Ext.MessageBox.WARNING
							});
				llamarVoucher();
			}
		}
	});
}
//----------------------------------------------------------------------------------------------------------------------------------
function llenar_campo_numdoc(campo)
{
	var codban = Ext.getCmp('codban').getValue();
	var ctaban = Ext.getCmp('ctaban').getValue();
	if((codban!='')&&(ctaban!=''))
	{
		var myJSONObject = {
					"operacion" :'llenar_numdoc',
					"numdoc"    : campo
		};
		var ObjSon= JSON.stringify(myJSONObject);
		var parametros ='ObjSon='+ObjSon;
		Ext.Ajax.request({
			url: ruta,
			params: parametros,
			method: 'POST',
			success: function ( result, request ) 
			{ 
				var numdoc = result.responseText;
				if (numdoc.length != 0)
				{
					Ext.getCmp('numdoc').setValue(numdoc);
					campo=numdoc;
					comprobar_numdoc(campo,codban,ctaban,'CH');
				}
			}
		});
	}
	else
	{
		Ext.Msg.show({
		title:'Advertencia',
		msg: 'Debe existir un Codigo de banco y cuenta respectivamente!',
		buttons: Ext.Msg.OK,
		icon: Ext.MessageBox.WARNING
		});
		Ext.getCmp('numdoc').setValue('');
	}
}
//----------------------------------------------------------------------------------------------------------------------------------
function comprobar_numdoc(numdoc,codban,ctaban,operacion)
{
	var myJSONObject = {
					"operacion" :'comprobar_numdoc',
					"numdoc"    : numdoc,
					"codban"    : codban,
					"ctaban"    : ctaban,
					"ope" : operacion
	};
	var ObjSon= JSON.stringify(myJSONObject);
	var parametros ='ObjSon='+ObjSon;
	Ext.Ajax.request({
		url: ruta,
		params: parametros,
		method: 'POST',
		success: function ( result, request ) 
		{ 
			var numdoc = result.responseText;
			if (numdoc.length != 0)
			{
				Ext.Msg.show({
				title:'Advertencia',
				msg: 'Ya existe un movimiento bancario con ese nmero de documento!',
				buttons: Ext.Msg.OK,
				icon: Ext.MessageBox.WARNING
				});
				Ext.getCmp('numdoc').setValue('');
			}
		}
	});
}
//----------------------------------------------------------------------------------------------------------------------------------
function CatalogoProveedores()
{
	//Creando el campo de buscar proveedores
	var reBuscarProv = Ext.data.Record.create([
	          {name: 'codigo'}, 	
	          {name: 'nombrep'},		
	          {name: 'banco'},		
			  {name: 'cuenta'},
			  {name: 'codban'},		
			  {name: 'ctaban'},
			  {name: 'nombreban'},
			  {name: 'nombrecta'},
			  {name: 'scg_cta'}
	]);
	                                        	
	var dsBuscarProv =  new Ext.data.Store({
	           reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reBuscarProv)
	});
	                                						
	var cmBuscarProv = new Ext.grid.ColumnModel([ 
	           new Ext.grid.CheckboxSelectionModel(),
	           {header: "<H1 align='center'>C&#233;dula / C&#243;digo</H1>", width: 50, sortable: true, dataIndex: 'codigo'},
	           {header: "<H1 align='center'>Nombre</H1>", width: 80, sortable: true, dataIndex: 'nombrep'},
	           {header: "<H1 align='center'>Banco</H1>", width: 50, sortable: true, dataIndex: 'banco'},
			   {header: "<H1 align='center'>Cuenta</H1>", width: 50, sortable: true, dataIndex: 'cuenta'}
	]);
	
	//fin creando datastore y columnmodel para el catalogo de buscar proveedores

	 gridBuscarProveedor = new Ext.grid.GridPanel({
	 		width:600,
	 		height:240,
			frame:true,
			style: 'position:absolute;left:45px;top:140px',
			autoScroll:true,
			border:true,
			ds: dsBuscarProv,
    		cm: cmBuscarProv,
			sm:new Ext.grid.CheckboxSelectionModel({singleSelect:true}),
    		stripeRows: true,
    		viewConfig: {forceFit:true}
	});
//----------------------------------------------------------------------------------------------------------------------------------
	//Creacion del formulario del catalogo de proveedores
	var frmBuscarProveedor = new Ext.FormPanel({
			width: 700,
			height: 470,
			style: 'position:absolute;left:0px;top:0px',
			frame: true,
			autoScroll:false,
			items: [{
					xtype:"fieldset", 
					style:'position:absolute;left:45px;top:15px',
					border:true,
					width:600,
					cls :'fondo',
					height:110,
					items: [{
							style:'position:absolute;left:15px;top:15px',
							layout:"column",
							defaults:{border: false},
							items: [{
									layout:"form",
									border:false,
									labelWidth:80,
									items: [{
											xtype:'textfield',
											labelSeparator:'',
											fieldLabel:'Documento',
											name:'documentoprov',
											id:'catdocprov',		//ID INCORRECTO									
											width: 150,
											binding:true,
											hiddenvalue:'',
											defaultvalue:'',
											autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '20', onkeypress: "return keyRestrict(event,'0123456789');"}
											}]
									}]
							},
							{
							style:'position:absolute;left:315px;top:18px',
							layout:"column",
							border:false,
							height:20,
							items: [{
									xtype:'label',
									style:'font-weight:bold;border:none',
									text:'Fecha',
									id:'label',
									width:900		
									}]
							},
							{
							style:'position:absolute;left:370px;top:15px',
							layout:"form",
							border:false,
							labelWidth:50,
							items: [{
									 xtype:"datefield",
									 labelSeparator:'',
									 fieldLabel:'Desde',
									 name:'catfecdesde',
									 id:'catfecdesp',
									 width:150,
									 binding:true,
									 hiddenvalue:'',
									 defaultvalue:'1900-01-01',
									 value: fechaPrimeraP,
									 allowBlank:true,
									 autoCreate:{tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789/');"}
								}]
							},
							{
							style:'position:absolute;left:370px;top:45px',
							layout:"form",
							border:false,
							labelWidth:50,
							items: [{
									 xtype:"datefield",
									 labelSeparator:'',
									 fieldLabel:'Hasta',
									 name:'catfechasta',
									 id:'catfechasp',
									 width:150,
									 binding:true,
									 hiddenvalue:'',
									 defaultvalue:'1900-01-01',
									 value: obtenerFechaActual(),
									 allowBlank:true,
									 autoCreate:{tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789/');"}
									}]
							},
							{
							style: 'position:absolute;left:503px;top:75px',
							layout:"column",
							defaults: {border: false},
							border:false,
							items:[{
									layout:"form",
									border:false,
									items:[{					
											xtype: 'button',
											labelSeparator :'',
											fieldLabel: '',
											id: 'btnBuscarProv',
											text: 'Buscar',
											width: 300,
											height: 300,
											binding:true,
											hiddenvalue:'',
											defaultvalue:'',
											iconCls: 'menubuscar',
											handler: function()
											{
												obtenerMensaje('procesar','','Buscando Datos');
												
												//buscar a solicitudes de ejecucion presupuestaria
												var numsol  = Ext.getCmp('catdocprov').getValue();
												var fecdes  = Ext.getCmp('catfecdesp').getValue().format('Y-m-d');
												var fechas  = Ext.getCmp('catfechasp').getValue().format('Y-m-d');
											    var JSONObject = {
												'operacion' : 'buscar_prog_prov',
												'numsol'    : numsol,
												'fecdes'   	: fecdes,
												'fechas'   	: fechas
																}
								
												var ObjSon = JSON.stringify(JSONObject);
												var parametros = 'ObjSon='+ObjSon; 
												Ext.Ajax.request({
													url : ruta,
													params : parametros,
													method: 'POST',
													success: function ( resultado, request)
													{
														Ext.Msg.hide();
														var datos = resultado.responseText;
														var objetoProgProv = eval('(' + datos + ')');
														if(objetoProgProv!='')
														{
															if(objetoProgProv!='0'){
																if(objetoProgProv.raiz==null|| objetoProgProv.raiz==''){
																	Ext.MessageBox.show({
													 					title:'Advertencia',
													 					msg:'No existen datos para mostrar',
													 					buttons: Ext.Msg.OK,
													 					icon: Ext.MessageBox.WARNING
													 				});
																gridBuscarProveedor.store.removeAll();
																}
																else{
																	dsBuscarProv.loadData(objetoProgProv);
																}
																																
															}
														}	
													}
											});
										 }
										}]
									}]
							}]
					}
					,gridBuscarProveedor,
					{
					layout:"column",
					defaults:{border: false},
					style:'position:absolute;left:450px;top:380px', 
					border:false,
					items:[{
							buttons: [{
							text:'Aceptar',  
							handler: function()
							{
								var registro_prov = gridBuscarProveedor.getSelectionModel().getSelected();
								if (registro_prov!= undefined)
								{
									Ext.getCmp('codproben').setValue(registro_prov.get('codigo'));
									Ext.getCmp('codban').setValue(registro_prov.get('codban'));
									Ext.getCmp('ctaban').setValue(registro_prov.get('ctaban'));
									Ext.getCmp('nomban').setValue(registro_prov.get('nombreban'));
									Ext.getCmp('dencta').setValue(registro_prov.get('nombrecta'));
									Ext.getCmp('sc_cuenta').setValue(registro_prov.get('scg_cta'));
									Ext.getCmp('nom_label').setText(registro_prov.get('nombrep'));
									Ext.getCmp('nomproben').setValue(registro_prov.get('nombrep'));
									Ext.getCmp('numordpagmin').setValue('-');
									Ext.getCmp('codtipfon').setValue('---');
									buscarSaldo();
									buscarSolicitudesProgramadas();
									gridBuscarProveedor.destroy();
									ventanaCatalogoProveedor.destroy();
									//ventanaCatalogoProveedor.close();
								}
								else
								{
									Ext.MessageBox.show({
									title:'Mensaje',
									msg:'Debe seleccionar al menos un registro a procesar',
									buttons: Ext.Msg.OK,
									icon: Ext.MessageBox.INFO
									});
								}
							}
							},
							{
							text:'Salir',
							handler:function(){
								ventanaCatalogoProveedor.close();
								//ventanaCatalogoProveedor.destroy();
								}
							}]
						}]
					}]
	  	});
//----------------------------------------------------------------------------------------------------------------------------------	
	
	var ventanaCatalogoProveedor = new Ext.Window({
    		title: "<H1 align='center'>Cat&#225;logo de Programaciones de Pago a Proveedores</H1>",
            width:700,
            height:470,
            modal: true,
            closable:false,
            plain: false,
            frame:true,
            items:[frmBuscarProveedor]
	
	});
	
	ventanaCatalogoProveedor.show();
}
//FIN DEL FORMULARIO CATALOGO PROVEEDORES//
//----------------------------------------------------------------------------------------------------------------------------------
function CatalogoBeneficiarios()
{
	//Creando el campo de buscar beneficiarios
	var reBuscarBene = Ext.data.Record.create([
	          {name: 'codigo'}, 	
	          {name: 'nombreb'},		
	          {name: 'banco'},		
			  {name: 'cuenta'},
			  {name: 'codban'},		
			  {name: 'ctaban'},
			  {name: 'nombreban'},
			  {name: 'nombrecta'},
			  {name: 'scg_cta'}
	]);
	
	var dsBuscarBene =  new Ext.data.Store({
	           reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reBuscarBene)
	});
	                                						
	var cmBuscarBene = new Ext.grid.ColumnModel([ 
	           new Ext.grid.CheckboxSelectionModel(),
	           {header: "<H1 align='center'>C&#243;digo</H1>", width: 40, sortable: true, dataIndex: 'codigo'},
	           {header: "<H1 align='center'>Nombre</H1>", width: 80, sortable: true, dataIndex: 'nombreb'},
	           {header: "<H1 align='center'>Banco</H1>", width: 50, sortable: true, dataIndex: 'banco'},
			   {header: "<H1 align='center'>Cuenta</H1>", width: 50, sortable: true, dataIndex: 'cuenta'}
	]);
	
	//fin creando datastore y columnmodel para el catalogo de buscar beneficiarios

	 gridBuscarBeneficiario = new Ext.grid.GridPanel({
	 		width:600,
	 		height:240,
			frame:true,
			style: 'position:absolute;left:45px;top:140px',
			autoScroll:true,
			border:true,
			ds: dsBuscarBene,
    		cm: cmBuscarBene,
			sm:new Ext.grid.CheckboxSelectionModel({singleSelect:true}),
    		stripeRows: true,
    		viewConfig: {forceFit:true}
	});

//----------------------------------------------------------------------------------------------------------------------------------
	//Creacion del formulario del catalogo de beneficiarios
	var frmBuscarBeneficiario = new Ext.FormPanel({
			width: 700,
			height: 470,
			style: 'position:absolute;left:0px;top:0px',
			frame: true,
			autoScroll:false,
			items: [{
					xtype:"fieldset", 
					style:'position:absolute;left:45px;top:15px',
					border:true,
					width:600,
					cls :'fondo',
					height:110,
					items:[{
							style:'position:absolute;left:15px;top:15px',
							layout:"column",
							defaults:{border: false},
							items: [{
									layout:"form",
									border:false,
									labelWidth:100,
									items: [{
											xtype:'textfield',
											labelSeparator:'',
											fieldLabel:'Documento',
											name:'documentoprov',
											id:'catdocben',		//ID INCORRECTO									
											width: 150,
											binding:true,
											hiddenvalue:'',
											defaultvalue:'',
											autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '20', onkeypress: "return keyRestrict(event,'0123456789');"}
										}]
								}]
		 					},
		 					{
							style:'position:absolute;left:315px;top:18px',
							layout:"column",
							border:false,
							height:20,
							items: [{
									xtype:'label',
									style:'font-weight:bold;border:none',
									text:'Fecha',
									id:'label',
									width:900		
								}]
							},
							{
							style:'position:absolute;left:370px;top:15px',
							layout:"form",
							border:false,
							labelWidth:50,
							items: [{
									 xtype:"datefield",
									 labelSeparator:'',
									 fieldLabel:'Desde',
									 name:'catfecdesde',	
									 id:'catfecdesb',			//ID INCORRECTO
									 width:150,
									 binding:true,
									 hiddenvalue:'',
									 defaultvalue:'1900-01-01',
									 value: fechaPrimeraB,
									 allowBlank:true,
									 autoCreate:{tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789/');"}
								}]
							},
							{
							style:'position:absolute;left:370px;top:45px',
							layout:"form",
							border:false,
							labelWidth:50,
							items: [{
									 xtype:"datefield",
									 labelSeparator:'',
									 fieldLabel:'Hasta',
									 name:'catfechasta',
									 id:'catfechasb',			//ID INCORRECTO
									 width:150,
									 binding:true,
									 hiddenvalue:'',
									 defaultvalue:'1900-01-01',
									 value: obtenerFechaActual(),
									 allowBlank:true,
									 autoCreate:{tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789/');"}
								}]
							},
							{
							style: 'position:absolute;left:503px;top:75px',
							layout:"column",
							defaults: {border: false},
							border:false,
							items:[{
									layout:"form",
									border:false,
									items:[{					
											xtype: 'button',
											labelSeparator :'',
											fieldLabel: '',
											id: 'btnBuscarBen',		//ID INCORRECTO
											text: 'Buscar',
											width: 300,
											height: 300,
											binding:true,
											hiddenvalue:'',
											defaultvalue:'',
											iconCls: 'menubuscar',
											handler: function()
											{
												obtenerMensaje('procesar','','Buscando Datos');
																
												var numsol  = Ext.getCmp('catdocben').getValue();
												var fecdes  = Ext.getCmp('catfecdesb').getValue().format('Y-m-d');
												var fechas  = Ext.getCmp('catfechasb').getValue().format('Y-m-d');
												
												var JSONObject = {
												'operacion' : 'buscar_prog_ben',
												'numsol'    : numsol,
												'fecdes'   	: fecdes,
												'fechas'   	: fechas
																}
																
												var ObjSon = JSON.stringify(JSONObject);
												var parametros = 'ObjSon='+ObjSon; 
												Ext.Ajax.request
												({
													url : ruta,
													params : parametros,
													method: 'POST',
													success: function ( resultado, request)
													{
														Ext.Msg.hide();
														var datos = resultado.responseText;
														var objetoProgBen = eval('(' + datos + ')');
														if(objetoProgBen!='')
														{
															if (objetoProgBen!='0'){
																if (objetoProgBen.raiz==null || objetoProgBen.raiz=='')
																	{
																	Ext.MessageBox.show({
													 					title:'Advertencia',
													 					msg:'No existen datos para mostrar',
													 					buttons: Ext.Msg.OK,
													 					icon: Ext.MessageBox.WARNING
													 				});
																	gridBuscarBeneficiario.store.removeAll();
																	}
																else{
																	dsBuscarBene.loadData(objetoProgBen);
																}
															}
														}
													}	
												});
											}
										}]
									}]
							}]		
						},gridBuscarBeneficiario,
						{
						layout:"column",
						defaults:{border: false},
						style:'position:absolute;left:450px;top:380px', 
						border:false,
						items:[{
								buttons: [{
								text:'Aceptar',  
								handler: function()
									{
										var registro_bene = gridBuscarBeneficiario.getSelectionModel().getSelected();
										if (registro_bene!= undefined)
										{
											Ext.getCmp('codproben').setValue(registro_bene.get('codigo'));
											Ext.getCmp('codban').setValue(registro_bene.get('codban'));
											Ext.getCmp('ctaban').setValue(registro_bene.get('ctaban'));
											Ext.getCmp('nomban').setValue(registro_bene.get('nombreban'));
											Ext.getCmp('dencta').setValue(registro_bene.get('nombrecta'));
											Ext.getCmp('sc_cuenta').setValue(registro_bene.get('scg_cta'));
											Ext.getCmp('nom_label').setText(registro_bene.get('nombreb'));
											//Ext.getCmp('nomproben').setValue(registro_prov.get('nombrep'));
											Ext.getCmp('numordpagmin').setValue('-');
											Ext.getCmp('codtipfon').setValue('---');
											buscarSaldo();
											buscarSolicitudesProgramadas();
											gridBuscarBeneficiario.destroy();
											ventanaCatalogoBeneficiario.destroy();
											//ventanaCatalogoBeneficiario.close();
										}
										else
										{
											Ext.MessageBox.show({
											title:'Mensaje',
											msg:'Debe seleccionar al menos un registro a procesar',
											buttons: Ext.Msg.OK,
											icon: Ext.MessageBox.INFO
											});
										}
									}
								},
								{
									text:'Salir',
									handler:function(){
										ventanaCatalogoBeneficiario.close();
										//ventanaCatalogoBeneficiario.destroy();
									}
								}]
							}]
					}]   
	  	});
//----------------------------------------------------------------------------------------------------------------------------------	
	
	var ventanaCatalogoBeneficiario = new Ext.Window({
    		title: "<H1 align='center'>Cat&#225;logo de Programaciones de Pago a Beneficiarios</H1>",
            width:700,
            height:470,
            modal: true,
            closable:false,
            plain: false,
            frame:true,
            items:[frmBuscarBeneficiario]
	
	});
	
	ventanaCatalogoBeneficiario.show();
}
//FIN DEL FORMULARIO CATALOGO BENEFICIARIOS//
//----------------------------------------------------------------------------------------------------------------------------------
function mostrarCheck(islr) 
{
	if (islr=='1')
	{
		return '<img src="../../base/imagenes/aceptar.png" style="border-style:none" />';
	}
	else
	{
		return '<img src="../../base/imagenes/cancelar.png" style="border-style:none" />';
	}
}
//----------------------------------------------------------------------------------------------------------------------------------
function buscarDeducciones()
{
	ls_documento = Ext.getCmp('numdoc').getValue();
	ldec_objret = Ext.getCmp('monobjret').getValue();
		
	var JSONObject = {
			'operacion' : 'buscar_deducciones',
			'documento' : ls_documento,
			'objret'	: ldec_objret
							}
	var ObjSon = JSON.stringify(JSONObject);
	var parametros = 'ObjSon='+ObjSon; 
	Ext.Ajax.request({
		url : '../../controlador/scb/sigesp_ctr_scb_transferencias.php',
		params : parametros,
		method: 'POST',
		success: function ( resultado, request)
		{
			Ext.Msg.hide();
			var datos = resultado.responseText;
			var objetoMovbco = eval('(' + datos + ')');
			if(objetoMovbco!='')
			{
				gridBuscarDeduccion.store.loadData(objetoMovbco);
			}
		}	
	});
}
//----------------------------------------------------------------------------------------------------------------------------------
function CatalogoNumOrdPagMin()
{
//funcion para validar si dentro del catalogo de banco se ha seleccionado alguna entidad bancaria
	function validarCatalogoBanco2()
	{
		var unidadOk = true;
		if(Ext.getCmp('catcodban').getValue()==''){
			unidadOk = false;
		}
		return unidadOk;
	}
//----------------------------------------------------------------------------------------------------------------------------------
	//creando store para la operacion
	var catoperacion = 	[ 
						['Deposito','DP'],
						['Nota Crdito','NC']
						];	// arreglo que contiene los Documentos que se pueden controlar
	
	var stcatoperacion = new Ext.data.SimpleStore({
		fields : [ 'etiqueta' , 'valor' ],
		data : catoperacion
	});
	
	var cmbcatoperacion = new Ext.form.ComboBox({
		store:stcatoperacion,
		fieldLabel:'Operaci&#243;n',
		labelSeparator:'',
		editable:false,
		emptyText:'--- Seleccione ---',
		displayField:'etiqueta',
		valueField:'valor',
		id:'catcodope',		//ID INCORRECTO
		width:150,
		typeAhead:true,
		triggerAction:'all',
		forceselection:true,
		binding:true,
		mode:'local',
		hiddenvalue:'',
		defaultvalue:'',
	});
//----------------------------------------------------------------------------------------------------------------------------------
	//Creando el campo de banco 
	var catbanco = Ext.data.Record.create([
						{name: 'codban'},
						{name: 'nomban'}
				]);
	
	var dscatbanco = new Ext.data.Store({
				  	reader: new Ext.data.JsonReader({
				  	root: 'raiz',             
				  	id: "id"},catbanco)
	  			});
						
	var cmcatbanco = new Ext.grid.ColumnModel([
          				{header: "<H1 align='center'>C&#243;digo</H1>", width: 20, sortable: true,   dataIndex: 'codban'},
          				{header: "<H1 align='center'>Nombre</H1>", width: 40, sortable: true, dataIndex: 'nomban'}
				]);
	//fin creando datastore y columnmodel para el catalogo de bancos 
	
	//componente campocatalogo para el campo banco
	cmbcatbanco = new com.sigesp.vista.comCampoCatalogo({
		titvencat: "<H1 align='center'>Cat&#225;logo de Bancos</H1>",
		//id: 'catalogobancos',
		anchoformbus: 450,
		altoformbus:100,
		anchogrid: 450,
		altogrid: 400,
		anchoven: 500,
		altoven: 400,
		datosgridcat: dscatbanco,
		colmodelocat: cmcatbanco,
//		rutacontrolador:'../../controlador/scb/sigesp_ctr_scb_conciliacion.php',
		rutacontrolador:'../../controlador/scb/sigesp_ctr_scb_progpago.php',
		parametros: "ObjSon={'operacion': 'catalogo_banco'}",
		arrfiltro:[{etiqueta:'C&#243;digo',id:'codiban2',valor:'codban'},
		           {etiqueta:'Denominaci&#243;n',id:'nombban2',valor:'nomban'}],
		           posicion:'position:absolute;left:5px;top:59px',
		           tittxt:'Banco',
		           idtxt:'catcodban',
		           campovalue:'codban',
		           anchoetiquetatext:100,
		           anchotext:125,
		           anchocoltext:0.40,
		           idlabel:'catnomban',
		           labelvalue:'nomban',
		           anchocoletiqueta:0.55,
		           anchoetiqueta:300,
		           tipbus:'L',
		           binding:'C',
		           anchofieldset: 600,
		           hiddenvalue:'',
		           defaultvalue:'',
		           allowblank:true
	});
	//fin componente para el campo banco
//----------------------------------------------------------------------------------------------------------------------------------	
	//Creando el campo de cuentas de bancos 
	var catctabanco = Ext.data.Record.create([
						{name: 'ctaban'},
						{name: 'dencta'},
						{name: 'sc_cuenta'},
						{name: 'denominacion'},
						{name: 'nomban'},
						{name: 'codtipcta'},
						{name: 'nomtipcta'},
						{name: 'fecapr'},
						{name: 'feccie'},
						{name: 'estact'}
				]);
	
	var dscatctabanco = new Ext.data.Store({
					 	reader: new Ext.data.JsonReader({
					 	root: 'raiz',             
					 	id: "id"},catctabanco)
	  			});
						
	var cmcatctabanco = new Ext.grid.ColumnModel([
          				{header: "<H1 align='center'>C&#243;digo</H1>", width: 80, sortable: true, dataIndex: 'ctaban'},
          				{header: "<H1 align='center'>Denominaci&#243;n</H1>", width: 45, sortable: true, dataIndex: 'dencta'},
						{header: "<H1 align='center'>Tipo</H1>", width: 25, sortable: true, dataIndex: 'nomtipcta' },
						{header: "<H1 align='center'>Contable</H1>", width: 35, sortable: true, dataIndex: 'sc_cuenta'},
						{header: "<H1 align='center'>Descrpci&#243;n</H1>", width: 40, sortable: true, dataIndex: 'denominacion'}, 
						{header: "<H1 align='center'>Apertura</H1>", width: 35, sortable: true, dataIndex: 'fecapr'}
				]);
	//fin creando datastore y columnmodel para el catalogo de cuentas de bancos 
	
	//componente campocatalogo para el campo cuentas de bancos
	cmbcatctabanco = new com.sigesp.vista.comCampoCatalogo({
		titvencat: "<H1 align='center'>Cat&#225;logo de Cuentas de Bancos</H1>",
		//id:'catalagocuentas',
		anchoformbus: 570,
		altoformbus:130,
		anchogrid: 570,
		altogrid: 400,
		anchoven: 600,
		altoven: 400,
		datosgridcat: dscatctabanco,
		colmodelocat: cmcatctabanco,
		rutacontrolador:ruta,
		parametros: "ObjSon={'operacion': 'catalogo_ctabanco_numpag'",
		arrfiltro:[{etiqueta:'C&#243;digo',id:'ctaiban2',valor:'ctaban'},
		           {etiqueta:'Denominaci&#243;n',id:'deniban2',valor:'dencta'}],
		           posicion:'position:absolute;left:5px;top:86px',
		           tittxt:'C&#243;digo',
		           idtxt:'catctaban',
		           campovalue:'ctaban',
		           anchoetiquetatext:100,
		           anchotext:125,
		           anchocoltext:0.40,
		           idlabel:'catdencta',
		           labelvalue:'dencta',
		           anchocoletiqueta:0.55,
		           anchoetiqueta:300,
		           tipbus:'P',
		           binding:'C',
		           anchofieldset: 600,
		           arrtxtfiltro:['catcodban'],
		           hiddenvalue:'',
		           defaultvalue:'',
		           allowblank:true,
		           validarMostrar:1,
		           fnValidarMostrar: validarCatalogoBanco2,
		           msjValidarMostrar: 'Debe seleccionar el Banco asociado a la Cuenta'
	});
	//fin componente para el campo cuentas de bancos 
//----------------------------------------------------------------------------------------------------------------------------------
	//Creando el campo de buscar no. orden pago ministerio
	var reBuscar = Ext.data.Record.create([
	          {name: 'numordpagmin'}, 
	          {name: 'codnomban'},
	          {name: 'ctanomban'},
			  {name: 'monto'},		
			  {name: 'porrep'},		
			  {name: 'porcon'},		
			  {name: 'disp'}		
	]);
	                                        	
	var dsBuscar =  new Ext.data.Store({
	           reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reBuscar)
	});
	                                						
	var cmBuscar = new Ext.grid.ColumnModel([ 
	           new Ext.grid.CheckboxSelectionModel(),
	           {header: "<H1 align='center'>No. Orden Pago</H1>", width: 70, sortable: true, dataIndex: 'numordpagmin'},
	           {header: "<H1 align='center'>Banco</H1>", width: 40, sortable: true, dataIndex: 'codnomban'},
	           {header: "<H1 align='center'>Cuenta</H1>", width: 45, sortable: true, dataIndex: 'ctanomban'},
			   {header: "<H1 align='center'>Monto</H1>", width: 40, sortable: true, dataIndex: 'monto'},
			   {header: "<H1 align='center'>% Reposici&#243;n</H1>", width: 65, sortable: true, dataIndex: 'porrep'},
			   {header: "<H1 align='center'>% Consumido</H1>", width: 65, sortable: true, dataIndex: 'porcon'},
			   {header: "<H1 align='center'>Disponible</H1>", width: 55, sortable: true, dataIndex: 'disp'}
	]);
	
	//fin creando datastore y columnmodel para el catalogo de buscar no. orden pago ministerio

	 gridBuscarNumOrdPagMin = new Ext.grid.GridPanel({
	 		width:750,
	 		height:200,
			frame:true,
			style: 'position:absolute;left:15px;top:170px',
			autoScroll:true,
			border:true,
			ds: dsBuscar,
    		cm: cmBuscar,
			sm:new Ext.grid.CheckboxSelectionModel({singleSelect:true}),
    		stripeRows: true,
    		viewConfig: {forceFit:true}
	});
//----------------------------------------------------------------------------------------------------------------------------------
	//Creacion del formulario del catalogo de no. orden de pago ministerio
	var frmBuscarNumOrdPagMin = new Ext.FormPanel({
			width: 800,
			height: 500,
			style: 'position:absolute;left:7px;top:0px',
			frame: true,
			autoScroll:false,
			items: [{
					xtype:"fieldset", 
					style:'position:absolute;left:15px;top:15px',
					border:true,
					width:750,
					cls :'fondo',
					height:135,
					items:[{
							style: 'position:absolute;left:15px;top:15px',
							layout: "column",
							defaults: {border: false},
							items: [{
									layout: "form",
									border: false,
									labelWidth: 100,
									items: [{
											xtype:'textfield',
											labelSeparator:'',
											fieldLabel:'N&#176; Orden Pago',
											name:'catnumordpagmin',
											id:'catnumordpagmin',									
											width: 150,
											binding:true,
											hiddenvalue:'',
											defaultvalue:'',
											autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '20', onkeypress: "return keyRestrict(event,'0123456789');"}
											}]
									}]
		 					},
							{
							style:'position:absolute;left:470px;top:15px',
							layout:"form",
							border:false,
							labelWidth:50,
							items: [{
									 xtype:"datefield",
									 labelSeparator:'',
									 fieldLabel:'Fecha',
									 name:'catfechamov',
									 id:'catfecmov',
									 width:150,
									 binding:true,
									 hiddenvalue:'',
									 defaultvalue:'1900-01-01',
									 value: obtenerFechaActual(),
									 allowBlank:true,
									 autoCreate:{tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789/');"}
								}]
							},		
							{
							style:'position:absolute;left:15px;top:42px',
							layout:"column",
							border:false,
							items: [{
									layout:"form",
									border:false,
									labelWidth:100,
									items: [cmbcatoperacion]
									}]
							},	
							cmbcatbanco.fieldsetCatalogo,
							cmbcatctabanco.fieldsetCatalogo,
							{
							layout:"column",
							defaults: {border: false},
							style: 'position:absolute;left:650px;top:97px',
							border:false,
							items:[{
									layout:"form",
									border:false,
									items:[{					
											xtype: 'button',
											labelSeparator :'',
											fieldLabel: '',
											id: 'btnBuscarOPM',
											text: 'Buscar',
											width: 300,
											height: 300,
											binding:true,
											hiddenvalue:'',
											defaultvalue:'',
											iconCls: 'menubuscar',
											handler: function()
											{
												obtenerMensaje('procesar','','Buscando Datos');
												//buscar a solicitudes de ejecucion presupuestaria
												var numpagmin  = Ext.getCmp('catnumordpagmin').getValue();
												var codopepagmin  = Ext.getCmp('catcodope').getValue();
												if (codopepagmin=="")
												{
													codopepagmin="-";
												}
												var fecmovpagmin  = Ext.getCmp('catfecmov').getValue().format('Y-m-d');
												var codbanpagmin  = Ext.getCmp('codiban2').getValue();
												var ctabanpagmin  = Ext.getCmp('ctaiban2').getValue();
										
												var JSONObject = {
													'operacion' : 'buscar_ordpagmin',
													'numpagmin'    : numpagmin,
													'opepagmin'    : codopepagmin,
													'fecpagmin'    : fecmovpagmin,
													'banpagmin'    : codbanpagmin,
													'ctapagmin'    : ctabanpagmin
										 		}
								
												var ObjSon = JSON.stringify(JSONObject);
												var parametros = 'ObjSon='+ObjSon; 
												Ext.Ajax.request({
													url : ruta,
													params : parametros,
													method: 'POST',
													success: function ( resultado, request)
													{
														Ext.Msg.hide();
														var datos = resultado.responseText;
														var objetoMovbcopagmin = eval('(' + datos + ')');
														if(objetoMovbcopagmin!='')
														{
															if(objetoMovbcopagmin!='0'){
								   								if(objetoMovbcopagmin.raiz == null || objetoMovbcopagmin.raiz ==''){
								   									Ext.MessageBox.show({
													 					title:'Advertencia',
													 					msg:'No existen datos para mostrar',
													 					buttons: Ext.Msg.OK,
													 					icon: Ext.MessageBox.WARNING
													 				});
								   									gridBuscarNumOrdPagMin.store.removeAll();
																}
																else{
																	dsBuscar.loadData(objetoMovbcopagmin);
																}	
															}
														}	
													}
												});
											}
										}]
								}]
						}]
					},gridBuscarNumOrdPagMin,
					{
					layout:"column",
					defaults: {border: false},
					style: 'position:absolute;left:600px;top:380px', 
					border:false,
					items:[{
							buttons: [{
										text:'Aceptar',  
										handler: function(){
											ventanaCatalogoNumOrdPagMin.close();
										}
									},
									{
										text:'Salir',
										handler:function(){
											cmbcatbanco.destruirVentana();
											cmbcatctabanco.destruirVentana();
											ventanaCatalogoNumOrdPagMin.close();
										}
									}]
							}]
					}]  
	  	});

//----------------------------------------------------------------------------------------------------------------------------------	
	
	var ventanaCatalogoNumOrdPagMin = new Ext.Window({
    		title: "<H1 align='center'>Cat&#225;logo de Ordenes de Pago Ministerio</H1>",
            width:814,
            height:450,
            modal: true,
            closable:false,
            plain: false,
            frame:true,
            items:[frmBuscarNumOrdPagMin]
	
	});
	
	ventanaCatalogoNumOrdPagMin.show();
}
//FIN DEL FORMULARIO NR. ORDEN PAGO MINISTERIO//
//----------------------------------------------------------------------------------------------------------------------------------
function CatalogoCheques()
{
	//Creando el campo de buscar cheques
	var codigoban2    = Ext.getCmp('codban').getValue();
	var codigoctaban2 = Ext.getCmp('ctaban').getValue();
	
	var reBuscarChq = Ext.data.Record.create([
	          {name: 'cheque'}, 
	          {name: 'chequera'},
	          {name: 'banco'},	
			  {name: 'cuenta'},	
			  {name: 'estatus'}	
	]);
	                                        	
	var dsBuscarChq =  new Ext.data.Store({
	           reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reBuscarChq)
	});
	
	var cmBuscarChq = new Ext.grid.ColumnModel([ 
	           new Ext.grid.CheckboxSelectionModel(),
	           {header: "<H1 align='center'>Cheque</H1>", width: 50, sortable: true, dataIndex: 'cheque'},
	           {header: "<H1 align='center'>Chequera</H1>", width: 50, sortable: true, dataIndex: 'chequera'},
	           {header: "<H1 align='center'>Banco</H1>", width: 50, sortable: true, dataIndex: 'banco'},
			   {header: "<H1 align='center'>Cuenta</H1>", width: 50, sortable: true, dataIndex: 'cuenta'},
			   {header: "<H1 align='center'>Estatus</H1>", width: 40, sortable: true, dataIndex: 'estatus'}
	]);
	
	//fin creando datastore y columnmodel para el catalogo de buscar cheques

	 gridBuscarCheque = new Ext.grid.GridPanel({
	 		width:650,
	 		height:220,
			frame:true,
			style: 'position:absolute;left:20px;top:120px',
			autoScroll:true,
			border:true,
			ds: dsBuscarChq,
    		cm: cmBuscarChq,
			sm:new Ext.grid.CheckboxSelectionModel({singleSelect:true}),
    		stripeRows: true,
    		viewConfig: {forceFit:true}
	});
//----------------------------------------------------------------------------------------------------------------------------------
	//Creacion del formulario del catalogo de cheques
	var frmBuscarCheque = new Ext.FormPanel({
			width: 700,
			height: 410,
			style: 'position:absolute;left:7px;top:0px',
			frame: true,
			autoScroll:false,
			items: [{
					xtype:"fieldset", 
					style:'position:absolute;left:20px;top:15px',
					border:true,
					width:650,
					cls :'fondo',
					height:80,
					items:[{
							style:'position:absolute;left:15px;top:15px',
							layout:"column",
							defaults:{border: false},
							items: [{
									layout:"form",
									border:false,
									labelWidth:100,
									items: [{
											xtype:'textfield',
											labelSeparator:'',
											fieldLabel:'Banco',
											name:'banchq',
											id:'banchq',		//ID INCORRECTO									
											width: 150,
											binding:true,
											hiddenvalue:'',
											defaultvalue:'',
											value:codigoban2,
											disabled:true
											}]
									}]
		 					},
							{
							style:'position:absolute;left:15px;top:45px',
							layout:"column",
							defaults:{border: false},
							items: [{
									layout:"form",
									border:false,
									labelWidth:100,
									items: [{
											xtype:'textfield',
											labelSeparator:'',
											fieldLabel:'Cuenta',
											name:'ctachq',
											id:'ctachq',		//ID INCORRECTO									
											width: 190,
											binding:true,
											hiddenvalue:'',
											defaultvalue:'',
											value:codigoctaban2,
											disabled:true
										}]
								}]
		 					},							
							{
							style: 'position:absolute;left:550px;top:45px',
							layout:"column",
							defaults: {border: false},
							border:false,
							items:[{
									layout:"form",
									border:false,
									items:[{					
											xtype: 'button',
											labelSeparator :'',
											fieldLabel: '',
											id: 'btnBuscarChq',
											text: 'Buscar',
											width: 300,
											height: 300,
											binding:true,
											hiddenvalue:'',
											defaultvalue:'',
											iconCls: 'menubuscar',
											handler: function()
											{
												obtenerMensaje('procesar','','Buscando Datos');
												
												//buscar a solicitudes de ejecucion presupuestaria
												var bancochq  = Ext.getCmp('banchq').getValue();
												var cuentachq  = Ext.getCmp('ctachq').getValue();
							
												var JSONObject = {
													'operacion' : 'buscar_numdoc_chq',
													'banco'     : bancochq,
													'cuenta'    : cuentachq
																}
					
												var ObjSon = JSON.stringify(JSONObject);
												var parametros = 'ObjSon='+ObjSon; 
												Ext.Ajax.request({
													url : ruta,
													params : parametros,
													method: 'POST',
													success: function ( resultado, request)
													{
														Ext.Msg.hide();
														var datos = resultado.responseText;
														var objetoNumdocChq = eval('(' + datos + ')');
														if(objetoNumdocChq!='')
														{
															gridBuscarCheque.getStore().loadData(objetoNumdocChq);
														}
													}	
												});
											}
										}]
									}]
							}]
					},gridBuscarCheque,
					{
					layout:"column",
					defaults:{border: false},
					style:'position:absolute;left:505px;top:350px', 
					border:false,
					items:[{
							buttons: [{
										text:'Aceptar',  
										handler: function()
										{
											var registro_cheque = gridBuscarCheque.getSelectionModel().getSelected();
											if (registro_cheque!= undefined)
											{
												Ext.getCmp('numdoc').setValue(registro_cheque.get('cheque'));
												Ext.getCmp('chequera2').setValue(registro_cheque.get('chequera'));
												gridBuscarCheque.destroy();
												ventanaCatalogoCheque.close();
											}
											else
											{
												Ext.MessageBox.show({
												title:'Mensaje',
												msg:'Debe seleccionar al menos un registro a procesar',
												buttons: Ext.Msg.OK,
												icon: Ext.MessageBox.INFO
												});
											}
										}
										},
										{
										text:'Salir',
										handler:function(){
										ventanaCatalogoCheque.close();
										}
										}]
							}]
					}]  
	  	});
//----------------------------------------------------------------------------------------------------------------------------------	
	
	var ventanaCatalogoCheque = new Ext.Window({
    		title: "<H1 align='center'>Cat&#225;logo Cheques</H1>",
            width:714,
            height:438,
            modal: true,
            closable:false,
            plain: false,
            frame:true,
            items:[frmBuscarCheque]
	
	});
	
	ventanaCatalogoCheque.show();
}
//FIN DEL FORMULARIO CATALOGO CHEQUES//
//----------------------------------------------------------------------------------------------------------------------------------
function CatalogoDeducciones()
{	
	if ((Ext.getCmp('monto').getValue() == '') && (Ext.getCmp('monobjret').getValue() == ''))
	{
		Ext.Msg.show({
		  title:'Mensaje',
		  msg:'Debe establecer el Monto y el Monto Objeto a Retencion para realizar la Bsqueda',
		  buttons: Ext.Msg.OK,
		  icon: Ext.MessageBox.INFO
		  });
	}
	else if (Ext.getCmp('numdoc').getValue() == '')
	{
		Ext.Msg.show({
		  title:'Mensaje',
		  msg:'Debe establecer el Documento de Origen para realizar la Bsqueda',
		  buttons: Ext.Msg.OK,
		  icon: Ext.MessageBox.INFO
		  });
	}
	else
	{
		//Creando el campo de buscar deducciones
		var reBuscarDedu = Ext.data.Record.create([
				  {name: 'codded'}, 		
				  {name: 'dended'},
				  {name: 'formula'}, 		
				  {name: 'islr'},
				  {name: 'iva'}, 		
				  {name: 'estretmun'},
				  {name: 'sc_cuenta'},
				  {name: 'montoret'}, 		
				  {name: 'monded'},
				  {name: 'documento'},
				  {name: 'objret'}
				  ]);
													
		var dsBuscarDedu =  new Ext.data.Store({
				   reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reBuscarDedu)
		});
		
		var smBuscarDedu = new Ext.grid.CheckboxSelectionModel({singleSelect:false});
		
		smBuscarDedu.on({
		'rowselect': 
		{
			fn: function(grid, numFila, registro)
			{
				if (Ext.getCmp('monobjret').getValue() == registro.get('objret'))
				{
					var monobjret = parseFloat(ue_formato_operaciones(Ext.getCmp('monobjret').getValue()));
					var total = parseFloat(ue_formato_operaciones(Ext.getCmp('totret').getValue()));
					var codigo = registro.get('codded');
					
					var JSONObject = {
						'operacion' : 'calcular_montobjret',
						'objret' 	: monobjret,
						'codded'	: codigo
										}
	
					var ObjSon = JSON.stringify(JSONObject);
					var parametros = 'ObjSon='+ObjSon; 
					Ext.Ajax.request({
						url : '../../controlador/scb/sigesp_ctr_scb_transferencias.php',
						params : parametros,
						method: 'POST',
						success: function ( resultado, request)
						{
							Ext.Msg.hide();
							var datos = resultado.responseText;
							if(datos!='')	//undefined
							{
								datos = parseFloat(ue_formato_operaciones(datos));
								registro.set('montoret',formatoNumericoMostrar(datos,2,'.',',','','','-',''));
								total = total + datos;
								Ext.getCmp('totret').setValue(formatoNumericoMostrar(total,2,'.',',','','','-',''));
							}
						}	
					});
				}
				else
				{
					var monobjret = parseFloat(ue_formato_operaciones(registro.get('objret')));
					var total = parseFloat(ue_formato_operaciones(Ext.getCmp('totret').getValue()));
					var codigo = registro.get('codded');
					
					var JSONObject = {
						'operacion' : 'calcular_montobjret',
						'objret' 	: monobjret,
						'codded'	: codigo
										}
	
					var ObjSon = JSON.stringify(JSONObject);
					var parametros = 'ObjSon='+ObjSon; 
					Ext.Ajax.request({
						url : '../../controlador/scb/sigesp_ctr_scb_transferencias.php',
						params : parametros,
						method: 'POST',
						success: function ( resultado, request)
						{
							Ext.Msg.hide();
							var datos = resultado.responseText;
							if(datos!='')	//undefined
							{
								datos = parseFloat(ue_formato_operaciones(datos));
								registro.set('montoret',formatoNumericoMostrar(datos,2,'.',',','','','-',''));
								total = parseFloat(total) + parseFloat(datos);
								Ext.getCmp('totret').setValue(formatoNumericoMostrar(total,2,'.',',','','','-',''));
							}
						}	
					});
				}
			}
		},
		'rowdeselect': 
		{
			fn: function(grid, numFila, registro)
			{
					var montoret = registro.get('montoret');
					var	total = Ext.getCmp('totret').getValue(formatoNumericoMostrar(total,2,'.',',','','','-',''));
					total = total - montoret;		
					registro.set('montoret',formatoNumericoMostrar(0,2,'.',',','','','-',''));
					Ext.getCmp('totret').setValue(formatoNumericoMostrar(total,2,'.',',','','','-',''));
			}
		}
		});
	
		var cmBuscarDedu = new Ext.grid.ColumnModel([ 
					smBuscarDedu,
					{header: "<CENTER>Documento</CENTER>", align: 'center', width: 50, sortable: true, dataIndex: 'documento'},
				   	{header: "<CENTER>Denominaci&#243;n</CENTER>", align: 'center', width: 80, sortable: true, dataIndex: 'dended'},
				   	{header: "<CENTER>Monto Objeto Retenci&#243;n</CENTER>", align: 'center', width: 70, sortable: true, dataIndex: 'objret', editor: new Ext.form.NumberField({allowBlank: false})},
				   	{header: "<CENTER>Monto Retenci&#243;n</CENTER>", align: 'center', width: 50, sortable: true, dataIndex: 'montoret'},
				   	{header: "<CENTER>Monto Deducible</CENTER>", align: 'center', width: 50, sortable: true, dataIndex: 'monded'},
				   	{header: "<CENTER>ISLR</CENTER>", align: 'center', width: 25, sortable: true, dataIndex: 'islr', renderer: mostrarCheck}
					]);
		//fin creando datastore y columnmodel para el catalogo de buscar deducciones
		
		 gridBuscarDeduccion = new Ext.grid.EditorGridPanel({
				width:750,
				height:270,
				frame:true,
				style: 'position:absolute;left:15px;top:120px',
				title: "<H1 align='center'>Cat&#225;logo de Retenciones</H1>",
				autoScroll:true,
				border:true,
				ds: dsBuscarDedu,
				cm: cmBuscarDedu,
				sm: smBuscarDedu,
			//	sm:	new Ext.grid.CheckboxSelectionModel({singleSelect:false}),
				stripeRows: true,
				viewConfig: {forceFit:true}
		});
		 
		gridBuscarDeduccion.on('afteredit', function(Obj)
		{
			var registro = Obj.record;
			var objeto = registro.get('objret');
			if(objeto!='')
			{
				objeto = parseFloat(ue_formato_operaciones(objeto)); 
			}
			registro.set('objret',formatoNumericoMostrar(objeto,2,'.',',','','','-',''));
		});
	//----------------------------------------------------------------------------------------------------------------------------------
		//Creacion del formulario del catalogo de deducciones
		var frmBuscarDeduccion = new Ext.FormPanel({
				width: 800,
				height: 450,
				style: 'position:absolute;left:7px;top:0px',
				frame: true,
				autoScroll:false,
				items: [{
						xtype:"fieldset", 
						title:'',
						style:'position:absolute;left:15px;top:15px',
						border:true,
						width:750,
						cls :'fondo',
						height:85,
						items:[{
								style:'position:absolute;left:15px;top:15px',
								layout:"column",
								defaults:{border: false},
								items: [{
										layout:"form",
										border:false,
										labelWidth:100,
										items: [{
												xtype:'textfield',
												labelSeparator:'',
												fieldLabel:'Documento',
												name:'documentoprov',
												id:'catdocprov2',
												value: Ext.getCmp('numdoc').getValue(),									
												width: 150,
												binding:true,
												hiddenvalue:'',
												defaultvalue:'',
					 							readOnly:true
											}]
									}]
								},
								{
								style:'position:absolute;left:15px;top:45px',
								layout:"column",
								defaults:{border: false},
								items: [{
										layout:"form",
										border:false,
										labelWidth:100,
										items: [{
												xtype:'textfield',
												labelSeparator:'',
												fieldLabel:'Total Retenido',
												name:'totret',
												id:'totret',
												value: formatoNumericoMostrar(0,2,'.',',','','','-',''),
												width: 150,
												binding:true,
												hiddenvalue:'',
												defaultvalue:'',
					 							readOnly:true
											}]
									}]
								}]
						},gridBuscarDeduccion,
						{
						layout:"column",
						defaults:{border: false},
						style:'position:absolute;left:540px;top:397px', 
						border:false,
						items:[{
								buttons: [{
								text:'Procesar Deducciones',
								iconCls: 'bmenuaceptar',
								handler: function()
								{
									var registro2 = gridBuscarDeduccion.getSelectionModel().getSelected();	        	
									if(registro2 != undefined)
									{
										selcatded = 1;
										Ext.getCmp('monret').setValue(Ext.getCmp('totret').getValue());
										ventanaCatalogoDeduccion.close();
									}
									else 
									{
										Ext.MessageBox.show({
										title:'Mensaje',
										msg:'Debe seleccionar al menos un registro a procesar',
										buttons: Ext.Msg.OK,
										icon: Ext.MessageBox.INFO
										});
									}
								}
								},												
								{
								text:'Salir',
								iconCls: 'menusalir',
								handler:function(){
											ventanaCatalogoDeduccion.close();
										}
								}]
								}]
						}]  
		});
		buscarDeducciones();
//----------------------------------------------------------------------------------------------------------------------------------	
	
		var ventanaCatalogoDeduccion = new Ext.Window({
				title: "<H1 align='center'>Cat&#225;logo Deducciones</H1>",
				width:814,
				height:478,
				modal: true,
				closable:false,
				plain: false,
				frame:true,
				items:[frmBuscarDeduccion]
		
		});
		
		ventanaCatalogoDeduccion.show();
		}
}

//FIN DEL FORMULARIO CATALOGO DEDUCCIONES//
//----------------------------------------------------------------------------------------------------------------------------------
function buscarSolicitudesProgramadas()
{
	valido=true;
	var codigoban    = Ext.getCmp('codban').getValue();
	var codigoctaban = Ext.getCmp('ctaban').getValue();
	var prov_benef   = Ext.getCmp('codproben').getValue();
	var numpagmin    = Ext.getCmp('numordpagmin').getValue();
	var codtipfon    = Ext.getCmp('codtipfon').getValue();
	var radio        = Ext.getCmp('tipproben');
	var fechahoy	 = obtenerFechaActual();
	for (var j = 0; j < radio.items.length; j++)
	{
      if (radio.items.items[j].checked)
	  {
      	proben = radio.items.items[j].inputValue;
		radio.items.items[j].checked=false;
		break;
      }
    }
	
	obtenerMensaje('procesar','','Buscando Datos');
	var JSONObject = {
			'operacion' : 'solicitudes_programadas',
			'codban'    : codigoban,
			'ctaban'    : codigoctaban,
			'codigopb'  : prov_benef,
			'numpagmin' : numpagmin,
			'codtipfon' : codtipfon,
			'tipproben' : proben,
			'fechadhoy' : fechahoy
		}
	var ObjSon = JSON.stringify(JSONObject);
	var parametros = 'ObjSon='+ObjSon; 
	Ext.Ajax.request({
		url : ruta,
		params : parametros,
		method: 'POST',
		success: function ( resultado, request)
		{
			Ext.Msg.hide();
			var datos = resultado.responseText;
			var	resultado2 = datos.split("|");
			var numerodoc = resultado2[0];
			var numchequera = resultado2[1];
			var Solicitudes = resultado2[2];
			
			var objetoProgEmisionCH = eval('(' + Solicitudes + ')');
			if(objetoProgEmisionCH!='')
			{
				gridSolicitud.getStore().loadData(objetoProgEmisionCH);
			}
			Ext.getCmp('numchequera').setValue(numchequera);
			config_ch    = Ext.getCmp('confi_ch').getValue();
			if (config_ch)
			{
				if (numerodoc.length!=0)
				{			      
					Ext.getCmp('numdoc').setValue(numerodoc);
					Ext.getCmp('numdoc').disable();		 
				}
				else
				{
					Ext.Msg.show({
					title:'Mensaje',
					msg: 'No tiene chequera asociada!',
					buttons: Ext.Msg.OK,
					icon: Ext.MessageBox.INFO
					});
				} 
			}
		}	
	});
}

function irCancelar(){
	numfilaaux = -1;
	Acumulador = 0;
	Ext.getCmp('nom_label').setText('-');
	limpiarFormulario(frmEmisionCh);
	gridSolicitud.store.removeAll();
	llamarVoucher();
	verificarEstcieSpg();
	verificarEstcieSpi();
	verificarEstcieScg();
	verificarEstcieCfCh();
	verificarEstModageret();
	verificarEstRetmil();
	buscarReporteCfg();
	Ext.getCmp('btnBuscarChq').disable();
}

function irNuevo(){
	numfilaaux = -1;
	Acumulador = 0;
	Ext.getCmp('nom_label').setText('-');
	limpiarFormulario(frmEmisionCh);
	gridSolicitud.store.removeAll();
	llamarVoucher();
	verificarEstcieSpg();
	verificarEstcieSpi();
	verificarEstcieScg();
	verificarEstcieCfCh();
	verificarEstModageret();
	verificarEstRetmil();
	buscarReporteCfg();
	Ext.getCmp('btnBuscarChq').disable();
}

function irBuscar(){
}

function irGuardar()
{
	valido=true;
	var codigoban    = Ext.getCmp('codban').getValue();
	var codigoctaban = Ext.getCmp('ctaban').getValue();
	var prov_benef   = Ext.getCmp('codproben').getValue();
	var numdoc       = Ext.getCmp('numdoc').getValue();
	var fechamov     = Ext.getCmp('fecmov').getValue();
	var nomproben    = Ext.getCmp('nomproben').getValue();
	var fechamov	 = fechamov.format(Date.patterns.fechacorta);
	var codope       = 'CH';
	var estmov       = 'N';
	var montomov     = Ext.getCmp('monto').getValue();
	var monobjretmov = Ext.getCmp('monobjret').getValue();
	var monretmov    = Ext.getCmp('monret').getValue();
	var concepto     = Ext.getCmp('conmov').getValue();
	var codconmov    = Ext.getCmp('codconmov').getValue();
	var chevau       = Ext.getCmp('chevau').getValue();
	var numordpagmin = Ext.getCmp('numordpagmin').getValue();
	var modageret    = Ext.getCmp('modageret').getValue();
	var estretmil    = Ext.getCmp('estretmil').getValue();
	var sc_cuenta    = Ext.getCmp('sc_cuenta').getValue();
	var numchequera  = Ext.getCmp('numchequera').getValue();
	var reporte		 = Ext.getCmp('reporte').getValue();
	var radio        = Ext.getCmp('tipproben');
	if((codigoban!="")&&(codigoctaban!="")&&(codconmov!="")&&(prov_benef!="")&&(concepto!=""))
	{
		for (var j = 0; j < radio.items.length; j++)
		{
		  if (radio.items.items[j].checked)
		  {
			proben = radio.items.items[j].inputValue;
			break;
		  }
		}
		if (selcatded==1)
		{
			ArrDeducciones = gridBuscarDeduccion.getSelectionModel().getSelections();
		}
		var ArrSolicitudes = gridSolicitud.getSelectionModel().getSelections();	
		if(ArrSolicitudes.length > 0)
		{			
			var arregloJsonEmitirCh = "{'operacion':'emitirch','codsis':'"+sistema+"','nomven':'"+vista+"',"+
									  " 'tipproben':'" + proben + "','codproben': '" + prov_benef + "',"+
									  " 'codban':'" + codigoban + "','ctaban':'" + codigoctaban + "',"+
									  " 'numdoc':'" + numdoc + "','fecmov':'" + fechamov + "','codope':'" + codope + "',"+
									  " 'estmov':'" + estmov + "','montomov':'" + montomov + "',"+
									  " 'monobjret':'" + monobjretmov + "','monret':'" + monretmov + "',"+
									  " 'concepto':'" + concepto + "','codconmov':'" + codconmov + "',"+
									  " 'chevau':'" + chevau + "','nomproben':'" + nomproben + "','numordpagmin':'" + numordpagmin + "', "+
									  " 'modageret':'" + modageret + "','estretmil':'" + estretmil + "','sc_cuenta':'" + sc_cuenta + "', "+
									  " 'numchequera':'" + numchequera + "','emisionch':[";
			for(var i=0;i<=ArrSolicitudes.length-1;i++)
			{	
				if(i==0)
				{
					arregloJsonEmitirCh += "{'numsolicitud':'" + ArrSolicitudes[i].get('numsolicitud')+"'," +
								  "'consolicitud':'" + ArrSolicitudes[i].get('consolicitud')+"'," +
								  "'monsolicitud':'" + ArrSolicitudes[i].get('monsolicitud')+"'," +
								  "'montopendiente':'" + ArrSolicitudes[i].get('montopendiente')+"'," +
								  "'montop':'" + ArrSolicitudes[i].get('montop')+"'," +
								  "'codfuefin':'" + ArrSolicitudes[i].get('codfuefin')+"'," +
								  "'fechapropag':'" + ArrSolicitudes[i].get('fechapropag')+"'," +
								  "'nombenalt':'" + ArrSolicitudes[i].get('nombenalt')+"'}";
				}	
				else
				{
					arregloJsonEmitirCh += ",{'numsolicitud':'" + ArrSolicitudes[i].get('numsolicitud')+"'," +
								  "'consolicitud':'" + ArrSolicitudes[i].get('consolicitud')+"'," +
								  "'monsolicitud':'" + ArrSolicitudes[i].get('monsolicitud')+"'," +
								  "'montopendiente':'" + ArrSolicitudes[i].get('montopendiente')+"'," +
								  "'montop':'" + ArrSolicitudes[i].get('montop')+"'," +
								  "'codfuefin':'" + ArrSolicitudes[i].get('codfuefin')+"'," +
								  "'fechapropag':'" + ArrSolicitudes[i].get('fechapropag')+"'," +
								  "'nombenalt':'" + ArrSolicitudes[i].get('nombenalt')+"'}";
				}
				
			}
			if (ArrDeducciones.length > 0)
			{
				arregloJsonEmitirCh = arregloJsonEmitirCh + "],'deducciones':[";
				for(var x=0;x<=ArrDeducciones.length-1;x++)
				{
					if (x==0)
					{
						arregloJsonEmitirCh += "{'codded':'" + ArrDeducciones[x].get('codded')+"'," +
								  "'dended':'" + ArrDeducciones[x].get('dended')+"'," +
								  "'monobjret':'" + ArrDeducciones[x].get('objret')+"'," +
								  "'montotret':'" + ArrDeducciones[x].get('montoret')+"'," +
								  "'sc_cuenta':'" + ArrDeducciones[x].get('sc_cuenta')+"'}";
					}
					else
					{
						arregloJsonEmitirCh += ",{'codded':'" + ArrDeducciones[x].get('codded')+"'," +
								  "'dended':'" + ArrDeducciones[x].get('dended')+"'," +
								  "'monobjret':'" + ArrDeducciones[x].get('objret')+"'," +
								  "'montotret':'" + ArrDeducciones[x].get('montoret')+"'," +
								  "'sc_cuenta':'" + ArrDeducciones[x].get('sc_cuenta')+"'}";
					}
				}
				
			}
			arregloJsonEmitirCh = arregloJsonEmitirCh + "]}";
			var cheques = eval('(' + arregloJsonEmitirCh + ')');
			ObjSon=Ext.util.JSON.encode(cheques);
			parametros = 'ObjSon='+ObjSon;
			Ext.Ajax.request({
			url : ruta,
			params : parametros,
			method: 'POST',
			success: function (resultado, request)
			{ 
				datos = resultado.responseText;
				Ext.Msg.hide();
				var datajson = eval('(' + datos + ')');
				if (datajson.raiz.valido==true)
				{	
					//Ext.MessageBox.alert('Mensaje', datajson.raiz.mensaje);
					function Imprime_ch()
					{
						var JSONObjectReporte = 
						{
						  'codban' : codigoban,
						  'ctaban' : codigoctaban,
						  'numdoc' : numdoc,
						  'chevau' : "00000000000000000"+chevau,
						  'codope' : codope
						}
						var ObjSonImp = JSON.stringify(JSONObjectReporte);
						window.open("reportes/"+reporte+"?ObjSon="+ObjSonImp,"menubar=no,toolbar=no,scrollbars=yes,width=800,height=600,left=0,top=0,location=no,resizable=yes")
					}
					Ext.Msg.show({
					title:'Mensaje',
					msg: datajson.raiz.mensaje,
					buttons: Ext.Msg.OK,
					icon: Ext.MessageBox.INFO,
					fn: Imprime_ch 
					});
					
				}
				else
				{
					Ext.MessageBox.alert('Error', datajson.raiz.mensaje);
				}
			},
			failure: function (result,request) 
			{ 
				Ext.Msg.hide();
				Ext.MessageBox.alert('Error', 'Error al guardar el Cheque'); 
			}	
			});
			irCancelar();
		}
		else
		{
			Ext.Msg.hide();
			Ext.MessageBox.alert('Error', 'Seleccione la solicitud a programar y asigne la fecha de programacion'); 
		}
	}
	else
	{
		Ext.Msg.hide();
		Ext.MessageBox.alert('Error', 'Debe llenar todos los campos!'); 
	}
}

function irEliminar(){
	
	function respuesta(btn){
		if(btn=='yes'){
			var cadjson = getItems(frmEmisionCh,'eliminar','N',null,null);
			try {
				var objjson = Ext.util.JSON.decode(cadjson);
				if (typeof(objjson) == 'object') {
					var parametros = 'ObjSon=' + cadjson;
					Ext.Ajax.request({
						url : '../../controlador/rpc/sigesp_ctr_rpc_beneficiario.php',
						params : parametros,
						method: 'POST',
						success: function ( result, request){
							var codigo = result.responseText;
							if(String.trim(codigo) == '1'){
								Ext.Msg.show({
									title:'Mensaje',
									msg: 'Registro eliminado con exito',
									buttons: Ext.Msg.OK,
									icon: Ext.MessageBox.INFO
								    });
								limpiarFormulario(frmEmisionCh);
								Actualizar=null;
							}
							else{
								Ext.Msg.show({
									title:'Mensaje',
									msg: 'Error al tratar de eliminar el registro <br>',
									buttons: Ext.Msg.OK,
									icon: Ext.MessageBox.ERROR
								    });
							}							
						}	
					});
				}
			}
			catch(e){
				alert('error'+e);
			}
		}
	}	
	if(Actualizar){
		  Ext.MessageBox.confirm('Confirmar', '&#191;Desea eliminar este registro&#63;', respuesta);
	}
	else{
		Ext.Msg.show({
				title:'Mensaje',
				msg: 'El registro debe estar guardado para poder eliminarlo, verifique por favor',
				buttons: Ext.Msg.OK,
				icon: Ext.MessageBox.ERROR
		}); 
	}
}

function irImprimir(){
	 
	
	if(Ext.getCmp('orden').items.items[0].checked)
	{
		orden = Ext.getCmp('orden').items.items[0].inputValue;
	}
	 else if (Ext.getCmp('orden').items.items[1].checked)
	{
		 orden = Ext.getCmp('orden').items.items[1].inputValue;
	}else if(Ext.getCmp('orden').items.items[2].checked)	
	{
		orden = Ext.getCmp('orden').items.items[2].inputValue;
	}
	obtenerMensaje('procesar','','Buscando Datos');
	var JSONObject = {
		'operacion'    : 'buscarBeneReporte',
		'ced_benedesde' : Ext.getCmp('ced_benedesde').getValue(),
		'ced_benehasta' : Ext.getCmp('ced_benehasta').getValue(),
		'orden'         : orden
	}			
	var ObjSon = JSON.stringify(JSONObject);
	var parametros = 'ObjSon='+ObjSon; 
	Ext.Ajax.request({
		url : '../../controlador/rpc/sigesp_ctr_rpc_reporteBeneficiarios.php',
		params : parametros,
		method: 'POST',
		success: function ( resultado, request){
			Ext.Msg.hide();
			var datos = resultado.responseText;
		    if (datos!=''){		    	
		    	abrirVentana(datos);
		    }   
		    else
		    {
		    	Ext.MessageBox.alert('Mensaje', 'No existen datos para imprimir');  
		    }
		}	
	});
}

