///**//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// * @FECHA DE CREACION: 11-01-2013
// * @DESARROLLADOR: ING. DOMINGO CALICCHIO
// * @DESCRIPCION: js correspondiente a la vista de actualizacion de control de documentos
///**//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

var frmControlDoc = null;  //instancia del formulario de actualizacion de control de documentos
var gridSolicitudProg=null;
var Actualizar = null;
var ruta ='../../controlador/scb/sigesp_ctr_scb_controldocumentos.php'; //ruta del controlador
var fechaPrimera = obtenerPrimerDiaMes();

barraherramienta = true;
Ext.onReady(function()
{
	Ext.QuickTips.init();
	Ext.BLANK_IMAGE_URL = '../../base/librerias/js/ext/resources/images/default/s.gif';
//--------------------------------------------------------------------------------------------------------------------------------	
//**********************************************************************************************************************************	
//                                 	INICIO DEL FORMULARIO ACTUALIZACION DE CONTROL DE DOCUMENTOS
//**********************************************************************************************************************************
	//Creando el campo de banco 
	var banco = Ext.data.Record.create([
						{name: 'codban'},
						{name: 'nomban'},
						{name: 'codemp'},
						{name: 'dirban'},
						{name: 'telban'},
						{name: 'conban'},
						{name: 'movcon'},
						{name: 'esttesnac'},
						{name: 'codsudeban'}
				]);
	
	var dsbanco = new Ext.data.Store({
				  	reader: new Ext.data.JsonReader({
				  	root: 'raiz',             
				  	id: "id"},banco)
	  			});
						
	var cmbanco = new Ext.grid.ColumnModel([
          				{header: "<H1 align='center'>C&#243;digo</H1>", width: 20, sortable: true,   dataIndex: 'codban'},
          				{header: "<H1 align='center'>Denominaci&#243;n</H1>", width: 40, sortable: true, dataIndex: 'nomban'}
				]);
	//fin creando datastore y columnmodel para el catalogo de bancos 
	
	//componente campocatalogo para el campo banco
	cmbbanco = new com.sigesp.vista.comCampoCatalogo({
							titvencat: "<H1 align='center'>Cat&#225;logo de Bancos</H1>",
							id: 'catalogobanco',
							anchoformbus: 450,
							altoformbus:100,
							anchogrid: 450,
							altogrid: 400,
							anchoven: 500,
							altoven: 400,
							datosgridcat: dsbanco,
							colmodelocat: cmbanco,
							rutacontrolador:'../../controlador/scb/sigesp_ctr_scb_progpago.php',
							parametros: "ObjSon={'operacion': 'catalogo_banco'}",
							arrfiltro:[{etiqueta:'C&#243;digo',id:'codiban',valor:'codban'},
									   {etiqueta:'Nombre',id:'nombban',valor:'nomban'}],
							posicion:'position:absolute;left:15px;top:10px',
							tittxt:'Banco',
							idtxt:'codban',
							campovalue:'codban',
							anchoetiquetatext:70,
							anchotext:150,
							anchocoltext:0.35,
							idlabel:'nomban',
							labelvalue:'nomban',
							anchocoletiqueta:0.65,
							anchoetiqueta:300,
							tipbus:'L',
							binding:'C',
							hiddenvalue:'',
							defaultvalue:'',
							allowblank:true
				});
	//fin componente para el campo banco
//----------------------------------------------------------------------------------------------------------------------------------	
	//Creando el campo de cuentas de bancos 
	var ctabanco = Ext.data.Record.create([
						{name: 'ctaban'},
						{name: 'dencta'},
						{name: 'sc_cuenta'},
						{name: 'denominacion'},
						{name: 'nomban'},
						{name: 'codtipcta'},
						{name: 'nomtipcta'},
						{name: 'fecapr'},
						{name: 'feccie'},
						{name: 'estact'}
				]);
	
	var dsctabanco = new Ext.data.Store({
					 	reader: new Ext.data.JsonReader({
					 	root: 'raiz',             
					 	id: "id"},ctabanco)
	  			});
						
	var cmctabanco = new Ext.grid.ColumnModel([
          				{header: "<H1 align='center'>C&#243;digo</H1>", width: 30, sortable: true, dataIndex: 'ctaban'},
          				{header: "<H1 align='center'>Denominaci&#243;n</H1>", width: 45, sortable: true, dataIndex: 'dencta'},
						{header: "<H1 align='center'>Tipo</H1>", width: 25, sortable: true, dataIndex: 'nomtipcta' },
						{header: "<H1 align='center'>Contable</H1>", width: 35, sortable: true, dataIndex: 'sc_cuenta'},
						{header: "<H1 align='center'>Descripci&#243;n</H1>", width: 40, sortable: true, dataIndex: 'denominacion'},
						{header: "<H1 align='center'>Apertura</H1>", width: 35, sortable: true, dataIndex: 'fecapr'}
				]);
	//fin creando datastore y columnmodel para el catalogo de cuentas de bancos 
	
	//componente campocatalogo para el campo cuentas de bancos
	cmbctabanco = new com.sigesp.vista.comCampoCatalogo({
							titvencat: "<H1 align='center'>Cat&#225;logo de Cuentas de Bancos</H1>",
							id:'catalagocuenta',
							anchoformbus: 650,
							altoformbus:130,
							anchogrid: 650,
							altogrid: 400,
							anchoven: 700,
							altoven: 400,
							datosgridcat: dsctabanco,
							colmodelocat: cmctabanco,
							rutacontrolador:'../../controlador/scb/sigesp_ctr_scb_progpago.php',
							parametros: "ObjSon={'operacion': 'catalogo_ctabanco'",
							arrfiltro:[{etiqueta:'C&#243;digo',id:'ctasban',valor:'ctaban'},
									   {etiqueta:'Nombre',id:'densban',valor:'dencta'}],
							posicion:'position:absolute;left:15px;top:40px',
							tittxt:'Cuenta',
							idtxt:'ctaban',
							campovalue:'ctaban',
							anchoetiquetatext:70,
							anchotext:150,
							anchocoltext:0.35,
							idlabel:'dencta',
							labelvalue:'dencta',
							anchocoletiqueta:0.65,
							anchoetiqueta:300,
							tipbus:'P',
							binding:'C',
							arrtxtfiltro:['codban'],
							hiddenvalue:'',
							defaultvalue:'',
							allowblank:true,
							validarMostrar:1,
							fnValidarMostrar: validarCatalogoBanco,
							msjValidarMostrar: 'Debe seleccionar el Banco asociado a la Cuenta'
				});
	//fin componente para el campo cuentas de bancos 
//----------------------------------------------------------------------------------------------------------------------------------	  
	//creando store para la operacion
	var operacion = [ 
					['Enviar a Firma','EF'], 
					['Enviar a Caja','EC'],
					['Deshacer Envio a Firma','DF'],
					['Deshacer Envio a Caja','DC']
					];	// arreglo que contiene los Documentos que se pueden controlar
	
	var stoperacion = new Ext.data.SimpleStore({
		fields : [ 'etiqueta' , 'valor' ],
		data : operacion
	});
	
	var cmbtipoperacion = new Ext.form.ComboBox({
		store:stoperacion,
		fieldLabel:'Operaci&#243;n',
		labelSeparator:'',
		editable:false,
		emptyText:'--- Seleccione ---',
		displayField:'etiqueta',
		valueField:'valor',
		id:'operac',
		width:150,
		typeAhead:true,
		triggerAction:'all',
		forceselection:true,
		binding:true,
		mode:'local',
		hiddenvalue:'',
		defaultvalue:''
	});
	//fin creando store para el combo tipo operacion
//----------------------------------------------------------------------------------------------------------------------------------
	//Creando el campo de solicitudes a programar 
	var reSolicitudProg = Ext.data.Record.create([
						{name: 'numdoc'}, 
						{name: 'codope'},
						{name: 'nombre'},
						{name: 'fecmov'},
						{name: 'monto'},
						{name: 'estmov'}
						]);

	var dsSolicitudProg =  new Ext.data.Store({
						reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reSolicitudProg)
					});
    						
	var cmSolicitudProg = new Ext.grid.ColumnModel([
						new Ext.grid.CheckboxSelectionModel(),
						{header: "<CENTER>Documento</CENTER>", align: 'center', width: 70, sortable: true, dataIndex: 'numdoc'},
						{header: "<CENTER>Operaci&#243;n</CENTER>", align: 'center', width: 50, sortable: true, dataIndex: 'codope'},
						{header: "<CENTER>Proveedor / Beneficiario</CENTER>", align: 'center', width: 90, sortable: true, dataIndex: 'nombre'},
						{header: "<CENTER>Fecha</CENTER>", align: 'center', width: 50, sortable: true, dataIndex: 'fecmov'},
						{header: "<CENTER>Monto</CENTER>", align: 'center', width: 60, sortable: true, dataIndex: 'monto'},
						{header: "<CENTER>Estatus</CENTER>", align: 'center', width: 15, hidden: true, dataIndex: 'estmov'}
					]);

	//creando datastore y columnmodel para la grid de solicitudes a programar
	 gridSolicitudProg = new Ext.grid.EditorGridPanel({
	 		width:915,
	 		height:275,
			frame:true,
			title:"<H1 align='center'>Listado de Documentos</H1>",
			style: 'position:absolute;left:10px;top:185px',
			autoScroll:true,
     		border:true,
     		ds: dsSolicitudProg,
       		cm: cmSolicitudProg,
			sm:new Ext.grid.CheckboxSelectionModel({singleSelect:false}),
       		stripeRows: true,
      		viewConfig: {forceFit:true}
	});
//----------------------------------------------------------------------------------------------------------------------------------	 
//**********************************************************************************************************************************
//Creacion del formulario
	var Xpos = ((screen.width/2)-(475));
	frmControlDoc = new Ext.FormPanel({
		applyTo: 'formulario',
		width: 950,
		height: 500,
		title: "<H1 align='center'>Cheques / Carta Orden</H1>",
		frame: true,
		autoScroll: true,
		style: 'position:absolute;margin-left:'+Xpos+'px;margin-top:20px;',
		items: [{
				xtype:"fieldset", 
				// 	title:'Datos de la Cotizacion',
				style: 'position:absolute;left:10px;top:15px',
				border:true,
				width: 915,
				cls :'fondo',
				height: 150,
				items: [			
				        cmbbanco.fieldsetCatalogo,
				        cmbctabanco.fieldsetCatalogo,
				        {
			        	style:'position:absolute;left:25px;top:80px',
			        	layout:"column",
			        	border:false,
			        	items: [{
				        		layout:"form",
				        		border:false,
				        		labelWidth:70,
				        		items: [{
					        			xtype:"datefield",
					        			labelSeparator:'',
					        			fieldLabel:'Desde',
					        			name:'fechades',
					        			id:'fecdes',
					        			value: fechaPrimera,
					        			width:150,
					        			binding:true,
					        			hiddenvalue:'',
					        			defaultvalue:'1900-01-01',
					        			allowBlank:true,
					        			autoCreate:{tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789/');"}
				        				}]
			        			}]
				        },	
				        {
			        	style:'position:absolute;left:665px;top:80px',
			        	layout:"column",
			        	border:false,
			        	items: [{
				        		layout:"form",
				        		border:false,
				        		labelWidth:70,
				        		items: [{
					        			xtype:"datefield",
					        			labelSeparator:'',
					        			fieldLabel:'Hasta',
					        			name:'fechahas',
					        			id:'fechas',
					        			value: new Date().format('Y-m-d'),
					        			width:150,
					        			binding:true,
					        			hiddenvalue:'',
					        			defaultvalue:'1900-01-01',
					        			allowBlank:true,
					        			autoCreate:{tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789/');"}
				        			}]
			        			}]
				        },	
				        {
			        	style:'position:absolute;left:25px;top:110px',
			        	layout:"column",
			        	border:false,
			        	items: [{
				        		layout:"form",
				        		border:false,
				        		labelWidth:70,
				        		items: [cmbtipoperacion]
			        			}]
				        },			
				        {
			        	style:'position:absolute;left:818px;top:110px',
			        	layout:"column",
			        	border:false,
			        	items: [{
				        		layout:"form",
				        		border:false,
				        		items: [{
					        			xtype:"button",
					        			text:'Buscar',
					        			id:'btnBuscarMB',
					        			iconCls:'menubuscar',
					        			handler: function()
					        			{
						        			if (Ext.getCmp('ctaban').getValue() == '')
						        			{
							        			Ext.Msg.show({
					        					title:'Mensaje',
					        					msg:'Debe seleccionar un Banco y una Cuenta',
					        					buttons: Ext.Msg.OK,
					        					icon: Ext.MessageBox.INFO
							        			});
						        			}
						        			else
						        			{
						        				obtenerMensaje('procesar','','Buscando Datos');
			
						        				codban2 = Ext.getCmp('codban').getValue();
						        				ctaban2 = Ext.getCmp('ctaban').getValue();
						        				var fecdes2 = Ext.getCmp('fecdes').getValue();
						        				var fechas2 = Ext.getCmp('fechas').getValue();
						        				var operac2 = '';
		
						        				if(Ext.getCmp('operac').getValue() == 'EF')
						        				{
						        					operac2 = 'S';
						        				}
						        				else if(Ext.getCmp('operac').getValue() == 'EC')
						        				{
						        					operac2 = 'F';
						        				}
						        				else if(Ext.getCmp('operac').getValue() == 'DF')
						        				{
						        					operac2 = 'F';
						        				}
						        				else if(Ext.getCmp('operac').getValue() == 'DC')
						        				{
						        					operac2 = 'C';
						        				}

						        				fecdes2 = fecdes2.format(Date.patterns.fechacorta);
						        				fechas2 = fechas2.format(Date.patterns.fechacorta);
						        				compara = ue_comparar_intervalo(fecdes2, fechas2);
			
						        				if (compara)
						        				{
			
						        					var JSONObject = {
						        							'operacion' : 'cargar_datos',
						        							'codban' : codban2,
						        							'ctaban' : ctaban2,
						        							'fecdes' : fecdes2,
						        							'fechas' : fechas2,
						        							'operac' : operac2
						        					}
						        					var ObjSon = JSON.stringify(JSONObject);
						        					var parametros = 'ObjSon='+ObjSon; 
						        					Ext.Ajax.request({
						        						url : ruta,
						        						params : parametros,
						        						method: 'POST',
						        						success: function (resultado, request)
						        						{
							        						Ext.Msg.hide();
							        						var datos = resultado.responseText;
							        						var objetoDatosGrid = eval('(' + datos + ')');
							        						if(objetoDatosGrid!='')
							        						{
							        							gridSolicitudProg.store.loadData(objetoDatosGrid);
							        						}
						        						}	
						        					});
						        				}
						        				else
						        				{
						        					Ext.Msg.show({
						        						title:'Mensaje',
						        						msg:'Fecha Desde debe ser menor que Fecha Hasta',
						        						buttons: Ext.Msg.OK,
						        						icon: Ext.MessageBox.INFO
						        					});
						        				}
						        			}
					        			}
				        			}]
			        		}]
			        }]
			},gridSolicitudProg]
	});			
});
//----------------------------------------------------------------------------------------------------------------------------------
//**********************************************************************************************************************************	
//                                  INICIO DE FUNCIONES PARA LOS CATALOGOS DE BUSQUEDA Y VALIDACIONES 
//**********************************************************************************************************************************
//funcion para validar si dentro del catalogo de banco se ha seleccionado alguna entidad bancaria
	function validarCatalogoBanco()
	{
		var unidadOk = true;
		if(Ext.getCmp('codban').getValue()=='')
		{
			unidadOk = false;
		}
		
		return unidadOk;
	}
//----------------------------------------------------------------------------------------------------------------------------------
function irCancelar()
{
	limpiarFormulario(frmControlDoc);
	gridSolicitudProg.store.removeAll();
}

function irNuevo()
{
	limpiarFormulario(frmControlDoc);
}

function irGuardar()
{
	var estpro = '';
	if ((Ext.getCmp('operac').getValue() != '') && (Ext.getCmp('ctaban').getValue() != '')) 
	{
		codban2 = Ext.getCmp('codban').getValue();
		ctaban2 = Ext.getCmp('ctaban').getValue();
		
		if (Ext.getCmp('operac').getValue() == 'EF')
		{
			estpro = 'F';	
		}
		else if (Ext.getCmp('operac').getValue() == 'EC')
		{
			estpro = 'C';	
		}
		else if (Ext.getCmp('operac').getValue() == 'DF')
		{
			estpro = 'S';	
		}
		else if (Ext.getCmp('operac').getValue() == 'DC')
		{
			estpro = 'F';	
		}

			arrDocumentos = gridSolicitudProg.getSelectionModel().getSelections();
			total = arrDocumentos.length;
		
		if (total > 0)
		{
			for (i=0; i < total; i++)
			{
				obtenerMensaje('procesar','','Procesando Datos');
				var JSONObject = {
						'operacion' : 'guardar_datos',
						'codban'	: codban2,				
						'ctaban' 	: ctaban2,
						'numdoc'    : arrDocumentos[i].get('numdoc'),
						'codope' 	: arrDocumentos[i].get('codope'),
						'estmov'	: arrDocumentos[i].get('estmov'),			
						'estado' 	: estpro
					}
				objdata=JSON.stringify(JSONObject);
				var parametros = 'ObjSon='+objdata; 
				Ext.Ajax.request({
					url : ruta,
					params : parametros,
					method: 'POST',
					success: function (resultado, request)
					{ 
						datos = resultado.responseText;
						Ext.Msg.hide();
						if (datos==1)
						{	
							Ext.MessageBox.alert('Mensaje', 'Se ha actualizado el estado del documento exitosamente');
							gridSolicitudProg.store.removeAll();
						}
						else
						{
							Ext.MessageBox.alert('Error', 'Ocurrio un error al registrar la entrega');
						}
					},
					failure: function (result,request) 
					{ 
						Ext.Msg.hide();
						Ext.MessageBox.alert('Error', 'Error al procesar la Informacion'); 
					}					
				});
			}
		}
		else
		{
			Ext.Msg.show({
			title:'Mensaje',
			msg:'Debe selecionar un registro',
			buttons: Ext.Msg.OK,
			icon: Ext.MessageBox.INFO
			});
		}
	}
	else
	{
		Ext.Msg.show({
		title:'Mensaje',
		msg:'Debe completar los datos',
		buttons: Ext.Msg.OK,
		icon: Ext.MessageBox.INFO
		});
	}
}