///**//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// * @FECHA DE CREACION: 21-12-2012
// * @DESARROLLADOR: ING. DOMINGO CALICCHIO
// * @DESCRIPCION: js correspondiente a la vista de conciliacion bancaria
///**//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

var frmConciliacionBancaria = null;  //instancia del formulario de conciliacion bancaria

barraherramienta = true;
Ext.onReady(function() 
{
	Ext.QuickTips.init();
	Ext.BLANK_IMAGE_URL = '../../base/librerias/js/ext/resources/images/default/s.gif';
//--------------------------------------------------------------------------------------------------------------------------------	
//**********************************************************************************************************************************	
//                                     INICIO DEL FORMULARIO DETALLES DE LA CONCILIACION	
//**********************************************************************************************************************************
	//creacion del formulario de datos del documento de respaldo
	var frmDetaConciliacion = new Ext.form.FieldSet({
		title:'Detalles de la Conciliaci&#243;n',
		style: 'position:absolute;left:10px;top:463px',
		border:true,
		width: 900,
		cls :'fondo',
		height: 160,
		items: [{
				style:'position:absolute;left:15px;top:20px',
				layout:"column",
				border:false,
				items: [{
						layout:"form",
						border:false,
						labelWidth:220,
						items: [{
								xtype:'textfield',
								labelSeparator:'',
								fieldLabel:'Saldo seg&#250;n Banco',
								id:'salsegbco',									
								width: 150,
								autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '100', onkeypress: "return keyRestrict(event,'0123456789.,');"},
								listeners: {
									'blur': function() {
									var formatonumero = formatoNumericoMostrar(this.getValue(),2,'.',',','','','-','');
									this.setValue(formatonumero);
								}
								}
						}]
				}]
			},
			{
			style:'position:absolute;left:500px;top:20px',
			layout:"column",
			border:false,
			items: [{
					layout:"form",
					border:false,
					labelWidth:220,
					items: [{
							xtype:'textfield',
							labelSeparator:'',
							fieldLabel:'Saldo seg&#250;n Libro',
							id:'salseglib',								
							width: 150,
							readOnly:true,
							autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '100', onkeypress: "return keyRestrict(event,'0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ');"}
						}]
					}]
			},				
			{
			style:'position:absolute;left:15px;top:50px',
			layout:"column",
			border:false,
			items: [{
					layout:"form",
					border:false,
					labelWidth:220,
					items: [{
							xtype:'textfield',
							labelSeparator:'',
							fieldLabel:'Transacciones no Registradas en Banco',
							id:'transnoregban',											
							width: 150,
							readOnly:true,
							autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '100', onkeypress: "return keyRestrict(event,'0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ');"}
					}]
				}]
			},
			{
			style:'position:absolute;left:500px;top:50px',
			layout:"column",
			border:false,
			items: [{
					layout:"form",
					border:false,
					labelWidth:220,
					items: [{
							xtype:'textfield',
							labelSeparator:'',
							fieldLabel:'Transacciones no Registradas en Libro',
							id:'transnoreglib',											
							width: 150,
							readOnly:true,
							autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '100', onkeypress: "return keyRestrict(event,'0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ');"}
							}]
				}]
			},
			{
			style:'position:absolute;left:15px;top:80px',
			layout:"column",
			border:false,
			items: [{
					layout:"form",
					border:false,
					labelWidth:220,
					items: [{
							xtype:'textfield',
							labelSeparator:'',
							fieldLabel:'Error en Banco',
							id:'errorbco',										
							width: 150,
							readOnly:true,
							autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '100', onkeypress: "return keyRestrict(event,'0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ');"}
						}]
					}]
			},
			{
			style:'position:absolute;left:15px;top:110px',
			layout:"column",
			border:false,
			items: [{
					layout:"form",
					border:false,
					labelWidth:220,
					items: [{
							xtype:'textfield',
							labelSeparator:'',
							fieldLabel:'Saldo Movimientos Conciliados',
							id:'conciliacion',											
							width: 150,
							readOnly:true,
							autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '100', onkeypress: "return keyRestrict(event,'0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ');"}
					}]
				}]
			},	
			{
			style:'position:absolute;left:500px;top:110px',
			layout:"column",
			border:false,
			items: [{
					layout:"form",
					border:false,
					labelWidth:220,
					items: [{
							xtype:'textfield',
							labelSeparator:'',
							fieldLabel:'Diferencia',
							id:'diferencia',											
							width: 150,
							readOnly:true,
							autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '100', onkeypress: "return keyRestrict(event,'0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ');"}
					}]
				}]
				},{
					xtype: 'hidden',
					id: 'errorlib'
				},{
					xtype: 'hidden',
					id: 'botonprocesar'
				}]
	});
//----------------------------------------------------------------------------------------------------------------------------------
	function calcularConciliado(){
		var stMovimientos = gridMovimientos.getStore();
		var smMovimientos = gridMovimientos.getSelectionModel();
		var tranoregban = 0;
		var tranoregbanNeg = 0;
		var saldoConciliado = 0;
		var saldoConciliadoNeg = 0;
		stMovimientos.each(function (reMovimiento){
			var conciliado = smMovimientos.isSelected(reMovimiento);  
			var estreglib = reMovimiento.get('estreglib');
			var estmov = reMovimiento.get('estmov');
			var codope = reMovimiento.get('codope');
			var monto = parseFloat(reMovimiento.get('monto'));
			
			if((!conciliado) && (estreglib != 'B')) {
				if(estmov != 'A'){
					if((codope=='DP')||(codope=='NC')){
						tranoregban = tranoregban + monto;
					}
					else {
						tranoregban = tranoregban - monto;
					}
				}
				else {
					if((codope=='DP')||(codope=='NC')){
						tranoregbanNeg = tranoregbanNeg + monto;
					}
					else {
						tranoregbanNeg = tranoregbanNeg - monto;
					}
				}
			}
			
			if((conciliado) && (estreglib != 'B')) {
				if(estmov != 'A'){
					if((codope=='DP')||(codope=='NC')){
						saldoConciliado = saldoConciliado + monto;
					}
					else {
						saldoConciliado = saldoConciliado - monto;
					}
				}
				else {
					if((codope=='DP')||(codope=='NC')){
						saldoConciliadoNeg = saldoConciliadoNeg + monto;
					}
					else {
						saldoConciliadoNeg = saldoConciliadoNeg - monto;
					}
				}
			}
		});errorbco
		tranoregban = tranoregban - tranoregbanNeg;
		saldoConciliado = saldoConciliado - saldoConciliadoNeg;
		var diferencia = parseFloat(formatoNumericoEdicion(Ext.getCmp('salsegbco').getValue())) + 
		                 parseFloat(formatoNumericoEdicion(Ext.getCmp('errorbco').getValue())) + 
		                 tranoregban -  
		                 parseFloat(formatoNumericoEdicion(Ext.getCmp('salseglib').getValue())) - 
		                 parseFloat(Ext.getCmp('errorlib').getValue()) - 
		                 parseFloat(formatoNumericoEdicion(Ext.getCmp('transnoreglib').getValue()));
		
		Ext.getCmp('transnoregban').setValue(formatoNumericoMostrar(tranoregban,2,'.',',','','','-',''));
		Ext.getCmp('conciliacion').setValue(formatoNumericoMostrar(saldoConciliado,2,'.',',','','','-',''));
		Ext.getCmp('diferencia').setValue(formatoNumericoMostrar(diferencia,2,'.',',','','','-',''));
	}
	
//**********************************************************************************************************************************	
//                                 			INICIO DEL FORMULARIO CONCILIACION BANCARIA
//**********************************************************************************************************************************
	var year = new Date().format('Y');
	//creando arreglo data para el combo fecha
	var fecha = [
		['ENERO','01'],
		['FEBRERO','02'], 
		['MARZO','03'],
		['ABRIL','04'],
		['MAYO','05'],
		['JUNIO','06'],
		['JULIO','07'],
		['AGOSTO','08'],
		['SEPTIEMBRE','09'],
		['OCTUBRE','10'],
		['NOVIEMBRE','11'],
		['DICIEMBRE','12']
	];
	
	//fin creando store para el combo fecha
	var stfecha = new Ext.data.SimpleStore({
		fields : ['etiqueta','valor'],
		data : fecha
	});

	//creando objeto combo tipo concepto
	var cmbFecha = new Ext.form.ComboBox({
		store : stfecha,
		fieldLabel : 'Mes/Ao',
		labelSeparator : '',
		editable : false,
		emptyText:'- Seleccione -',
		displayField : 'etiqueta',
		valueField : 'valor',
		id : 'fecha',
		width : 100,
		typeAhead : true,
		triggerAction : 'all',
		forceselection : true,
		binding : true,
		mode : 'local',
		listeners: {
			'select': function(){
				if(this.getValue()=='01') {
					Ext.getCmp('periodo').setValue('01'+"/"+year);
				}
				if(this.getValue()=='02')
				{	
					Ext.getCmp('periodo').setValue('02'+"/"+year);
				}
				if(this.getValue()=='03')
				{	
					Ext.getCmp('periodo').setValue('03'+"/"+year);
				}
				if(this.getValue()=='04')
				{	
					Ext.getCmp('periodo').setValue('04'+"/"+year);
				}
				if(this.getValue()=='05')
				{	
					Ext.getCmp('periodo').setValue('05'+"/"+year);
				}
				if(this.getValue()=='06')
				{	
					Ext.getCmp('periodo').setValue('06'+"/"+year);
				}
				if(this.getValue()=='07')
				{	
					Ext.getCmp('periodo').setValue('07'+"/"+year);
				}
				if(this.getValue()=='08')
				{	
					Ext.getCmp('periodo').setValue('08'+"/"+year);
				}
				if(this.getValue()=='09')
				{	
					Ext.getCmp('periodo').setValue('09'+"/"+year);
				}
				if(this.getValue()=='10')
				{	
					Ext.getCmp('periodo').setValue('10'+"/"+year);
				}
				if(this.getValue()=='11')
				{	
					Ext.getCmp('periodo').setValue('11'+"/"+year);
				}
				if(this.getValue()=='12')
				{	
					Ext.getCmp('periodo').setValue('12'+"/"+year);
				}
			}
		}
	});
	
	//creando arreglo data para el combo operciones
	var operacion = [
		['Todas','TD'],
		['Notas Dbito','ND'], 
		['Notas Crdito','NC'],
		['Deposito','DP'],
		['Retiro','RE'],
		['Cheques','CH']
	];
	
	//fin creando store para el combo fecha
	var stOperacion = new Ext.data.SimpleStore({
		fields : ['etiqueta','valor'],
		data : operacion
	});

	//creando objeto combo tipo concepto
	var cmbOperacion = new Ext.form.ComboBox({
		store : stOperacion,
		fieldLabel : 'Operacion',
		labelSeparator : '',
		editable : false,
		emptyText:'- Seleccione -',
		displayField : 'etiqueta',
		valueField : 'valor',
		id : 'operacion',
		width : 100,
		typeAhead : true,
		triggerAction : 'all',
		forceselection : true,
		binding : true,
		mode : 'local'
	});
//----------------------------------------------------------------------------------------------------------------------------------
	//funcion para limpiar la grid al seleccionar un banco 
	function limpiarData(){
		Ext.getCmp('ctaban').reset();
		Ext.getCmp('dencta').reset();
		Ext.getCmp('operacion').reset();
		Ext.getCmp('sc_cuenta').reset();
		Ext.getCmp('dispmov').reset();
		Ext.getCmp('estcon').reset();
		limpiarFormulario(frmDetaConciliacion);
		gridMovimientos.getStore().removeAll();
	}
	
	//Creando el campo de banco 
	var banco = Ext.data.Record.create([
		{name: 'codban'},
		{name: 'nomban'}
	]);
	
	var dsbanco = new Ext.data.Store({
		reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},banco)
	});
						
	var cmbanco = new Ext.grid.ColumnModel([
		{header: "<H1 align='center'>C&#243;digo</H1>", width: 20, sortable: true,   dataIndex: 'codban'},
        {header: "<H1 align='center'>Denominaci&#243;n</H1>", width: 40, sortable: true, dataIndex: 'nomban'}
	]);
	//fin creando datastore y columnmodel para el catalogo de bancos 
	
	//componente campocatalogo para el campo banco
	var cmbbanco = new com.sigesp.vista.comCampoCatalogo({
		titvencat: "<H1 align='center'>Cat&#225;logo de Bancos</H1>",
		id: 'catalogobanco',
		anchoformbus: 450,
		altoformbus:100,
		anchogrid: 450,
		altogrid: 400,
		anchoven: 500,
		altoven: 400,
		datosgridcat: dsbanco,
		colmodelocat: cmbanco,
		rutacontrolador:'../../controlador/scb/sigesp_ctr_scb_conciliacion.php',
		parametros: "ObjSon={'operacion': 'catalogo_banco'}",
		arrfiltro:[{etiqueta:'C&#243;digo',id:'codiban',valor:'codban'},
		           {etiqueta:'Nombre',id:'nombban',valor:'nomban'}],
		           posicion:'position:absolute;left:5px;top:32px',
		           tittxt:'Banco',
		           idtxt:'codban',
		           campovalue:'codban',
		           anchoetiquetatext:100,
		           anchotext:150,
		           anchocoltext:0.45,
		           idlabel:'nomban',
		           labelvalue:'nomban',
		           anchocoletiqueta:0.50,
		           anchoetiqueta: 400,
		           tipbus:'L',
		           binding:'C',
		           anchofieldset: 720,
		           hiddenvalue:'',
		           defaultvalue:'',
		           allowblank:true,
		           onAceptar:true,
		           fnOnAceptar: limpiarData
	});
	//fin componente para el campo banco
//----------------------------------------------------------------------------------------------------------------------------------	
	function buscarDisponible() {
		Ext.getCmp('operacion').reset();
		Ext.getCmp('estcon').reset();
		limpiarFormulario(frmDetaConciliacion);
		gridMovimientos.getStore().removeAll();
		var JSONObject = {
				'operacion' : 'obtener_saldo',
				'codban' : Ext.getCmp('codban').getValue(),
				'ctaban' : Ext.getCmp('ctaban').getValue()
		}			
		var ObjSon = JSON.stringify(JSONObject);
		var parametros = 'ObjSon='+ObjSon; 
		Ext.Ajax.request({
			url : '../../controlador/scb/sigesp_ctr_scb_conciliacion.php',
			params : parametros,
			method: 'POST',
			success: function ( resultado, request){
				var saldo = formatoNumericoMostrar(resultado.responseText,2,'.',',','','','-','');
				Ext.getCmp('dispmov').setValue(saldo);
			}	
		});
	}
	
	//Creando el campo de cuentas de bancos 
	var ctabanco = Ext.data.Record.create([
		{name: 'ctaban'},
		{name: 'dencta'},
		{name: 'nomtipcta'},
		{name: 'sc_cuenta'},
		{name: 'ctabanext'},
		{name: 'fecapr'}
	]);
	
	var dsctabanco = new Ext.data.Store({
		reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},ctabanco)
	});
						
	var cmctabanco = new Ext.grid.ColumnModel([
		{header: "<H1 align='center'>C&#243;digo</H1>", width: 30, sortable: true, dataIndex: 'ctaban'},
        {header: "<H1 align='center'>Denominaci&#243;n</H1>", width: 45, sortable: true, dataIndex: 'dencta'},
		{header: "<H1 align='center'>Tipo</H1>", width: 25, sortable: true, dataIndex: 'nomtipcta' },
		{header: "<H1 align='center'>Contable</H1>", width: 35, sortable: true, dataIndex: 'sc_cuenta'},
		{header: "<H1 align='center'>Descripci&#243;n</H1>", width: 40, sortable: true, dataIndex: 'ctabanext'},
		{header: "<H1 align='center'>Apertura</H1>", width: 35, sortable: true, dataIndex: 'fecapr'}
	]);
	//fin creando datastore y columnmodel para el catalogo de cuentas de bancos 
	
	//componente campocatalogo para el campo cuentas de bancos
	var cmbctabanco = new com.sigesp.vista.comCampoCatalogo({
		titvencat: "<H1 align='center'>Cat&#225;logo de Cuentas de Bancos</H1>",
		id:'catalagocuenta',
		anchoformbus: 650,
		altoformbus:130,
		anchogrid: 650,
		altogrid: 400,
		anchoven: 700,
		altoven: 400,
		datosgridcat: dsctabanco,
		colmodelocat: cmctabanco,
		rutacontrolador:'../../controlador/scb/sigesp_ctr_scb_conciliacion.php',
		parametros: "ObjSon={'operacion': 'catalogo_ctabanco'",
		arrfiltro:[{etiqueta:'C&#243;digo',id:'ctasban',valor:'ctaban'},
		           {etiqueta:'Denominaci&#243;n',id:'densban',valor:'dencta'}],
		           posicion:'position:absolute;left:5px;top:59px',
		           tittxt:'Cuenta',
		           idtxt:'ctaban',
		           campovalue:'ctaban',
		           anchoetiquetatext:100,
		           anchotext:200,
		           anchocoltext:0.45,
		           idlabel:'dencta',
		           labelvalue:'dencta',
		           anchocoletiqueta:0.50,
		           anchoetiqueta:350,
		           tipbus:'P',
		           arrtxtfiltro:['codban'],
		           binding:'C',
		           anchofieldset: 720,
		           hiddenvalue:'',
		           defaultvalue:'',
		           allowblank:true,
		           validarMostrar:1,
		           fnValidarMostrar: validarCatalogoBanco,
		           msjValidarMostrar: 'Debe seleccionar el Banco asociado a la Cuenta',
		           datosadicionales: 1,
		           camposoadicionales : [{tipo:'cadena',id:'sc_cuenta'}],
		           onAceptar:true,
		           fnOnAceptar: buscarDisponible,
		           setMensaje:true,
		           nuevoMensaje: 'No existe cuentas registradas, o no tienes cuentas bancarias asignadas'
	});
	//fin componente para el campo cuentas de bancos 
//----------------------------------------------------------------------------------------------------------------------------------	  
	//creando datastore y columnmodel para la grid de gastos
	var reMovimientos = Ext.data.Record.create([
		{name: 'numdoc'},
		{name: 'fecmov'},
		{name: 'conmov'},
		{name: 'monto'},
		{name: 'codope'},
		{name: 'estmov'},
		{name: 'feccon'},
		{name: 'estreglib'},
		{name: 'numcarord'},
		{name: 'estcon'}
	]);
	
	var dsMovimientos =  new Ext.data.Store({
		reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reMovimientos )
	});
						
	var cmMovimientos = new Ext.grid.ColumnModel([new Ext.grid.CheckboxSelectionModel({}),
		{header: "<CENTER>Documento</CENTER>", align: 'center', width: 45, sortable: true, dataIndex: 'numdoc'},
		{header: "<CENTER>Fecha</CENTER>", align: 'center', width: 32, sortable: true, dataIndex: 'fecmov', renderer: formatoFechaGrid},
		{header: "<CENTER>Concepto</CENTER>", align: 'center', width: 40, sortable: true, dataIndex: 'conmov'},
		{header: "<CENTER>Monto</CENTER>", align: 'right', width: 31, sortable: true, dataIndex: 'monto', renderer: formatoMontoGrid},
		{header: "<CENTER>Operaci&#243;n</CENTER>", align: 'center', width: 25, sortable: true, dataIndex: 'codope'},
		{header: "<CENTER>Estatus Mov.</CENTER>", align: 'center', width: 30, sortable: true, dataIndex: 'estmov'},
		{header: "<CENTER>Fecha Conci.</CENTER>", align: 'center', width: 32, sortable: true, dataIndex: 'feccon', renderer: formatoFechaGrid},
		{header: "<CENTER>Registro Libro</CENTER>", align: 'center', width: 30, sortable: true, dataIndex: 'estreglib'},
		{header: "<CENTER>Carta Orden</CENTER>",  align: 'center',width: 45, sortable: true, dataIndex: 'numcarord'}
	]);
								
	//creando grid para los detalles de gastos
	gridMovimientos = new Ext.grid.EditorGridPanel({
		width:900,
		height:200,
		frame:true,
		title:"<H1 align='center'>Movimientos Bancarios a conciliar</H1>",
		style: 'position:absolute;left:10px;top:250px',
		autoScroll:true,
		border:true,
		ds: dsMovimientos,
		cm: cmMovimientos,
		sm:new Ext.grid.CheckboxSelectionModel({singleSelect:false}),
		stripeRows: true,
		viewConfig: {forceFit:true}
	});
	
	var smMovimientos = gridMovimientos.getSelectionModel();
	smMovimientos.on({
		'rowselect': {
			fn: function(sm, numFila, record){
				if(Ext.getCmp('estcon').checked){
					Ext.Msg.show({
 						title:'Mensaje',
						msg:'La conciliaci&#243;n esta cerrada, debe abrirla para modificar los movimientos conciliados',
						buttons: Ext.Msg.OK,
						icon: Ext.MessageBox.INFO
 					});
 					return false;
				}
				else {
					var periodo = Ext.getCmp('periodo').getValue();
					var feccon = periodo.substring(3,7)+"/"+periodo.substring(0,2)+"/01";
					record.set('estcon','1');
					record.set('feccon',feccon);
					calcularConciliado();
				}
			}
		},
		'rowdeselect': {
			fn: function(sm, numFila, record){
				if(Ext.getCmp('estcon').checked){
					Ext.Msg.show({
 						title:'Mensaje',
						msg:'La conciliaci&#243;n esta cerrada, debe abrirla para modificar los movimientos conciliados',
						buttons: Ext.Msg.OK,
						icon: Ext.MessageBox.INFO
 					});
 					return false;
				}
				else {
					record.set('estcon','0');
					record.set('feccon','01/01/1900');
					calcularConciliado();
				}
			}
		}
	});
	
//-----------------------------------------------------------------------------------------------------------------------------------																						

	//Creacion del formulario conciliacion bancaria
	var Xpos = ((screen.width/2)-(475));
	frmConciliacionBancaria = new Ext.FormPanel({
		applyTo: 'formulario',
		width: 950,
		height: 505,
		title: "<H1 align='center'>Conciliaci&#243;n Bancaria</H1>",
		frame: true,
		autoScroll: true,
		style: 'position:absolute;margin-left:'+Xpos+'px;margin-top:15px;',
		items: [{
				xtype:"fieldset", 
				style: 'position:absolute;left:10px;top:5px',
				border:true,
				width: 900,
				cls :'fondo',
				height: 225,
				items: [{
						style:'position:absolute;left:15px;top:15px',
						layout:"column",
						border:false,
						items: [{
								layout:"form",
								border:false,
								labelWidth:100,
								items: [{
										xtype:"textfield",
										labelSeparator:'',
										fieldLabel:'Per&#237;odo',
										id:'periodo',
										width:150,
										binding:true,
										hiddenvalue:'',
										defaultvalue:'',
										allowBlank:true,
										readOnly:true
								}]
						}]
					},
					{
					style:'position:absolute;left:320px;top:15px',
					layout:"column",
					border:false,
					items: [{
							layout:"form",
							border:false,
							labelWidth:50,
							items: [cmbFecha]
							}]
					},
					{
					style:'position:absolute;left:470px;top:15px',
					layout:"column",
					border:false,
					items: [{
							layout:"form",
							border:false,
							labelWidth:10,
							items: [{
									xtype:"textfield",
									labelSeparator:'',
									name:'ao',
									id:'ao',			//ID INCORRECTO
									value: new Date().format('Y'),
									width:100,
									binding:true,
									hiddenvalue:'',
									defaultvalue:'',
									allowBlank:true,
									readOnly:true
							}]
						}]
					},
					cmbbanco.fieldsetCatalogo,
					cmbctabanco.fieldsetCatalogo,
					{
					style:'position:absolute;left:15px;top:96px',
					layout:"column",
					border:false,
					items: [{
							layout:"form",
							border:false,
							labelWidth:100,
							items: [{
									xtype:"textfield",
									labelSeparator:'',
									fieldLabel:'Cuenta Contable',
									id:'sc_cuenta',
									width:150,
									binding:true,
									hiddenvalue:'',
									defaultvalue:'',
									allowBlank:false,
									autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '100', onkeypress: "return keyRestrict(event,'0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ');"}
							}]
						}]
					},
					{
					style:'position:absolute;left:600px;top:96px',
					layout:"column",
					border:false,
					items: [{
							layout:"form",
							border:false,
							labelWidth:70,
							items: [{
									xtype:"textfield",
									labelSeparator:'',
									fieldLabel:'Disponible',
									id:'dispmov', 		
									width:150,
									binding:true,
									hiddenvalue:'',
									defaultvalue:'',
									allowBlank:true,
									autoCreate:{tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789/');"},
									readOnly:true
								}]
							}]
					},
					{
					style:'position:absolute;left:15px;top:123px',
					layout:"column",
					border:false,
					items: [{
							layout:"form",
							border:false,
							labelWidth:100,
							items: [cmbOperacion]
						}]
					},
					{
					style:'position:absolute;left:15px;top:150px',
					layout:"column",
					border:false,
					items: [{
							layout:"form",
							border:false,
							labelWidth:100,
							items: [{
									xtype:"checkbox",
									fieldLabel:'Cerrar Conciliaci&#243;n',
									labelSeparator:'',
									id: 'estcon', 
									inputValue:1,
									listeners: {
										'check': function(objchk,checkeado) {
											var sm = gridMovimientos.getSelectionModel();
											if(checkeado) {
												function confirmarCerrar(btn){
													if(btn=='yes'){
														sm.lock();
													}
													else {
														objchk.setValue(false);
													}
												}
												if(!sm.isLocked()){
													Ext.MessageBox.confirm('Confirmar', 'Realmente desea cerrar la conciliaci&#243;n', confirmarCerrar);
												}
											}
											else {
												function confirmarAbrir(btn){
													if(btn=='yes'){
														sm.lock();
														var JSONObject = {
						 									'operacion' : 'abrir_conciliacion',
						 									'codban' : Ext.getCmp('codban').getValue(),
						 									'ctaban' : Ext.getCmp('ctaban').getValue(),
						 									'periodo' : Ext.getCmp('periodo').getValue()
						 								}			
						 								var ObjSon = JSON.stringify(JSONObject);
						 								var parametros = 'ObjSon='+ObjSon; 
						 								Ext.Ajax.request({
						 									url : '../../controlador/scb/sigesp_ctr_scb_conciliacion.php',
						 									params : parametros,
						 									method: 'POST',
						 									success: function ( resultado, request){
						 										var repuesta = resultado.responseText;
						 										if(repuesta=='1') {
						 											Ext.Msg.show({
				 														title:'Mensaje',
																		msg:'Se abri&#243; la conciliaci&#243;n exitosamete',
																		buttons: Ext.Msg.OK,
																		icon: Ext.MessageBox.INFO
						 											});
						 											sm.unlock();
						 										}
						 										else {
					 											Ext.Msg.show({
			 														title:'Mensaje',
																	msg:'Ocurri&#243; un error al abrir la conciliaci&#243;n',
																	buttons: Ext.Msg.OK,
																	icon: Ext.MessageBox.ERROR	
			 													});
						 										}
						 									}	
						 								});
													}
													else {
														objchk.setValue(true);
													}
												}
									
												if(gridMovimientos.getStore().getCount()>0){
													Ext.MessageBox.confirm('Confirmar', 'Realmente desea abrir la conciliaci&#243;n', confirmarAbrir);
												}
												else {
													if (!validarBancoCuentaPeriodo()){
														Ext.Msg.show({
				 										title:'Mensaje',
														msg:'Debe cargar los movimiento de la conciliaci&#243;n',
														buttons: Ext.Msg.OK,
														icon: Ext.MessageBox.INFO
														});
													}
												}
											}
										}
									}
								}]
							}]
					},
					{
					style:'position:absolute;left:15px;top:185px',
					layout:"column",
					border:false,
					items: [{
							layout:"form",
							border:false,
							items: [{
							xtype:"button",
							text:'Cargar Movimientos',
							id:'btnaceptar',
							tooltip: 'Carga los movimiento y saldos de un periodo a conciliar',
							iconCls:'bmenuaceptar',
							handler: function(){
								if(validarBancoCuentaPeriodo()) {
	 								Ext.Msg.show({
	 									title:'Mensaje',
										msg:'Complete los Datos de la Conciliaci&#243;n (Banco, Cuenta, Per&#237;odo)',
										buttons: Ext.Msg.OK,
										icon: Ext.MessageBox.INFO
	 								});
								} 
								else {
	 								if(Ext.getCmp('operacion').getValue()=='') {
	 									Ext.Msg.show({
	 										title:'Mensaje',
											msg:'Debe indicar el tipo de operaci&#243;n de los movimientos a conciliar',
											buttons: Ext.Msg.OK,
											icon: Ext.MessageBox.INFO
	 									});
	 								}
	 								else {
	 									if(gridMovimientos.getStore().getCount()>0){
	 										function confirmarOpcion(btn){
	 												if(btn=='yes'){
														var JSONObject = {
						 									'operacion' : 'movimiento_conciliar',
						 									'codban' : Ext.getCmp('codban').getValue(),
						 									'ctaban' : Ext.getCmp('ctaban').getValue(),
						 									'periodo' : Ext.getCmp('periodo').getValue(),
						 									'codope' : Ext.getCmp('operacion').getValue()
						 								}			
						 								var ObjSon = JSON.stringify(JSONObject);
						 								var parametros = 'ObjSon='+ObjSon; 
						 								Ext.Ajax.request({
						 									url : '../../controlador/scb/sigesp_ctr_scb_conciliacion.php',
						 									params : parametros,
						 									method: 'POST',
						 									success: function ( resultado, request){
							 									Ext.getCmp('estcon').setValue(false);
						 										var numFila = 0;
						 										var repuesta = resultado.responseText;
						 										var arrRespuesta = repuesta.split("|");
						 										//Cargando Saldos
						 										var estConciliacion = arrRespuesta[0];
						 										Ext.getCmp('salsegbco').setValue(arrRespuesta[1]);
						 										Ext.getCmp('salseglib').setValue(arrRespuesta[2]);
						 										Ext.getCmp('conciliacion').setValue(arrRespuesta[3]);
						 										Ext.getCmp('transnoreglib').setValue(arrRespuesta[4]);
						 										Ext.getCmp('errorbco').setValue(arrRespuesta[5]);
						 										Ext.getCmp('errorlib').setValue(arrRespuesta[6]);
						 										
						 										//Cargando datos de movimientos en la grid
						 										var objetodata = eval('(' + arrRespuesta[7] + ')');
						 										var stMovimientos = gridMovimientos.getStore();
						 										var smMovimientos = gridMovimientos.getSelectionModel();
						 										stMovimientos.loadData(objetodata);
						 										stMovimientos.each(function (registrostore){
						 											if(registrostore.get('estcon')=='1'){
						 												smMovimientos.selectRow(numFila, true);
						 											}
						 											numFila++;
									 							});
						 										
						 										if(estConciliacion=='1') {
						 											smMovimientos.lock();
						 											Ext.getCmp('estcon').setValue(true);
						 										}
					 										}	
						 								});
	 												}	
	 										}
	 											Ext.MessageBox.confirm('Confirmar', 'Recuerde guardar los movimientos conciliados antes de recargar los datos presione si para continuar, si ya guardo los movimientos conciliados', confirmarOpcion);
	 									}
	 									else {
				 								var JSONObject = {
				 									'operacion' : 'movimiento_conciliar',
				 									'codban' : Ext.getCmp('codban').getValue(),
				 									'ctaban' : Ext.getCmp('ctaban').getValue(),
				 									'periodo' : Ext.getCmp('periodo').getValue(),
				 									'codope' : Ext.getCmp('operacion').getValue()
				 								}			
				 								var ObjSon = JSON.stringify(JSONObject);
				 								var parametros = 'ObjSon='+ObjSon; 
				 								Ext.Ajax.request({
				 									url : '../../controlador/scb/sigesp_ctr_scb_conciliacion.php',
				 									params : parametros,
				 									method: 'POST',
				 									success: function ( resultado, request){
					 									Ext.getCmp('estcon').setValue(false);
				 										var numFila = 0;
				 										var repuesta = resultado.responseText;
				 										var arrRespuesta = repuesta.split("|");
				 										//Cargando Saldo segun libro
				 										var estConciliacion = arrRespuesta[0];
				 										Ext.getCmp('salsegbco').setValue(arrRespuesta[1]);
				 										Ext.getCmp('salseglib').setValue(arrRespuesta[2]);
				 										Ext.getCmp('conciliacion').setValue(arrRespuesta[3]);
				 										Ext.getCmp('transnoreglib').setValue(arrRespuesta[4]);
				 										Ext.getCmp('errorbco').setValue(arrRespuesta[5]);
				 										Ext.getCmp('errorlib').setValue(arrRespuesta[6]);
	 										
				 										//Cargando datos de movimientos en la grid
				 										var objetodata = eval('(' + arrRespuesta[7] + ')');
				 										var stMovimientos = gridMovimientos.getStore();
				 										var smMovimientos = gridMovimientos.getSelectionModel();
				 										stMovimientos.loadData(objetodata);
				 										stMovimientos.each(function (registrostore){
				 											if(registrostore.get('estcon')=='1'){
				 												smMovimientos.selectRow(numFila, true);
				 											}
				 											numFila++;
				 										});
	 										
				 										if(estConciliacion=='1') {
						 									smMovimientos.lock();
						 									Ext.getCmp('estcon').setValue(true);
						 								}
				 									}	
				 								});
	 									}
	 								}
								}
 						 	}
						}]
					}]
			},
			{
			style:'position:absolute;left:0px;top:455px',
			layout:"column",
			border:false,
			items: [{
					layout:"form",
					border:false,
					items: [{
							xtype:"button",
							text:'Procesar Movimientos Conciliados',
							id:'btnaceptar',
							tooltip: 'Recalcula los saldos segun lo movimiento tildados como conciliados',
							iconCls:'bmenuaceptar',
							listeners: {
								'click': function () {
									var arrSelect = gridMovimientos.getSelectionModel().getSelections();
									if(arrSelect.length > 0) {
										if(Ext.getCmp('botonprocesar').getValue()=='1'){
											Ext.Msg.show({
						 						title:'Mensaje',
												msg:'Los movimientos conciliados ya fueron procesados',
												buttons: Ext.Msg.OK,
												icon: Ext.MessageBox.INFO
						 					});
										}
										else {
											function confirmarProcesar(btn){
												if(btn=='yes'){
													Ext.getCmp('botonprocesar').setValue('1');
													calcularConciliado();
													var smMovimientos = gridMovimientos.getSelectionModel();
													smMovimientos.lock();
												}
											}
											Ext.MessageBox.confirm('Confirmar', 'Desea procesar los movimientos conciliados?, si los procesa no los podra modificar!', confirmarProcesar);
										}
									}
									else {
										Ext.Msg.show({
										title:'Mensaje',
										msg:'Debe marcar como conciliado al menos un movimiento',
										buttons: Ext.Msg.OK,
										icon: Ext.MessageBox.INFO
										});
									}
								}
							}
						}] 
					}]
				}]	
	 			},
	 			gridMovimientos,
				frmDetaConciliacion]
	});		
});
//----------------------------------------------------------------------------------------------------------------------------------
//**********************************************************************************************************************************	
//                                  INICIO DE FUNCIONES PARA LOS CATALOGOS DE BUSQUEDA Y VALIDACIONES 
//**********************************************************************************************************************************

//funcion para validar si dentro del catalogo de banco se ha seleccionado alguna entidad bancaria
function validarCatalogoBanco(){
	var bancoOk = true;
	if(Ext.getCmp('codban').getValue()=='') {
		bancoOk = false;
	}
		
	return bancoOk;
}

//funcion para validar si dentro del catalogo de banco se ha seleccionado alguna entidad bancaria
function validarBancoCuentaPeriodo(){
	okBcoCtaPer = false;
	if(Ext.getCmp('periodo').getValue()== ''){
		return true;
	}
	
	if(Ext.getCmp('codban').getValue() == ''){
		return true;
	}
	
	if(Ext.getCmp('ctaban').getValue() == ''){
		return true;
	}
 	
	return okBcoCtaPer;
}

	

function irCancelar(){
	limpiarFormulario(frmConciliacionBancaria);
}

function irNuevo(){
	limpiarFormulario(frmConciliacionBancaria);
	//Ext.getCmp('codope').setValue('NC');
}

function irBuscar(){
	//por implementar...  
}

function validarGuardar() {
	//validar todo antes de guardar la conciliacion
	$okGuardar = true;
	var arrSelect = gridMovimientos.getSelectionModel().getSelections();
	if(Ext.getCmp('periodo').getValue()==''){
		Ext.Msg.show({
			title:'Mensaje',
			msg:'Debe indicar la per&#237;odo que desea conciliar',
			buttons: Ext.Msg.OK,
			icon: Ext.MessageBox.INFO
		});
		return false
	}
	else if(Ext.getCmp('codban').getValue()==''){
		Ext.Msg.show({
			title:'Mensaje',
			msg:'Debe indicar el banco el cual desea conciliar',
			buttons: Ext.Msg.OK,
			icon: Ext.MessageBox.INFO
		});
		return false
	}
	else if(Ext.getCmp('ctaban').getValue()==''){
		Ext.Msg.show({
			title:'Mensaje',
			msg:'Debe indicar la cuenta bancaria que desea conciliar',
			buttons: Ext.Msg.OK,
			icon: Ext.MessageBox.INFO
		});
		return false
	}
	else if(arrSelect.length == 0) {
		Ext.Msg.show({
			title:'Mensaje',
			msg:'Debe marcar como conciliado al menos un movimiento',
			buttons: Ext.Msg.OK,
			icon: Ext.MessageBox.INFO
		});
		return false
	}
	else if(Ext.getCmp('botonprocesar').getValue()!='1'){
		Ext.Msg.show({
			title:'Mensaje',
			msg:'Debe procesar los movimiento conciliados, use el boton procesar movimientos conciliados',
			buttons: Ext.Msg.OK,
			icon: Ext.MessageBox.INFO
		});
		return false
	}
	
	return $okGuardar;
}

function irGuardar(){
	if(validarGuardar()){
		var estcon = '0';
		if(Ext.getCmp('estcon').checked){
			estcon = '1';
		}
		var cadjson = "{'operacion':'guardar_conciliacion'," +
					  " 'codban':'"+Ext.getCmp('codban').getValue()+"'," +
					  " 'ctaban':'"+Ext.getCmp('ctaban').getValue()+"'," +
					  " 'mesano':'"+Ext.getCmp('periodo').getValue()+"'," +
					  " 'salsegbco':'"+Ext.getCmp('salsegbco').getValue()+"'," +
					  " 'salseglib':'"+Ext.getCmp('salseglib').getValue()+"'," +
					  " 'conciliacion':'"+Ext.getCmp('conciliacion').getValue()+"'," +
					  " 'estcon':'"+estcon+"','arrMovimientos':[";
		var stMovimientos = gridMovimientos.getStore();
		var flagFirst = true;
		stMovimientos.each(function (reMovimientos){
			if(flagFirst){
				flagFirst = false;
				cadjson += "{'numdoc':'"+reMovimientos.get('numdoc')+"','codope':'"+reMovimientos.get('codope')+"'," +
						   " 'estcon':'"+reMovimientos.get('estcon')+"','feccon':'"+reMovimientos.get('feccon')+"'}";
			}
			else {
				cadjson += ",{'numdoc':'"+reMovimientos.get('numdoc')+"','codope':'"+reMovimientos.get('codope')+"'," +
						   " 'estcon':'"+reMovimientos.get('estcon')+"','feccon':'"+reMovimientos.get('feccon')+"'}";
			}
		});
		cadjson += "]}";			  
		try {
			var objjson = Ext.util.JSON.decode(cadjson);
			if (typeof(objjson) == 'object') {
				var parametros = 'ObjSon=' + cadjson;
				Ext.Ajax.request({ 
					url : '../../controlador/scb/sigesp_ctr_scb_conciliacion.php',
					params : parametros,
					method: 'POST',
					success: function ( result, request){
						var codigo = result.responseText;
						if(String.trim(codigo) == '1'){
							Ext.Msg.show({
								title:'Mensaje',
								msg: exitoguardar,
								buttons: Ext.Msg.OK,
								icon: Ext.MessageBox.INFO
							    });
							gridMovimientos.getStore().removeAll();
							limpiarFormulario(frmConciliacionBancaria);
						}
						else
						{
							Ext.Msg.show({
							title:'Mensaje',
							msg: errorguardar,
							buttons: Ext.Msg.OK,
							icon: Ext.MessageBox.ERROR
							});
						}
					}	
				});
			}
		}	
		catch(e){
				//alert('Verifique los datos, esta insertando caracteres invalidos '+e);
		}
	}
}

function irEliminar(){
}

function irImprimir(){
}


