<?php
    session_start();   
	header("Pragma: public");
	header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
	header("Cache-Control: private",false);
	if(!array_key_exists("la_logusr",$_SESSION))
	{
		print "<script language=JavaScript>";
		print "close();";
		print "</script>";		
	}
	ini_set('memory_limit','512M');
	ini_set('max_execution_time ','0');

	//--------------------------------------------------------------------------------------------------------------------------------
	function uf_print_encabezado_pagina($as_titulo,$io_pdf)
	{
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_encabezadopagina
		//		   Access: private 
		//	    Arguments: as_titulo // Ttulo del Reporte
		//	    		   io_pdf // Instancia de objeto pdf
		//    Description: funcion que imprime los encabezados por pgina
		//	   Creado Por: Ing. Yesenia Moreno
		// Fecha Creacion: 21/04/2006 
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$io_encabezado=$io_pdf->openObject();
		$io_pdf->saveState();
		$io_pdf->line(20,40,578,40);
		$io_pdf->setStrokeColor(0,0,0);
		$io_pdf->rectangle(140,710,415,40);
		$io_pdf->line(400,750,400,710);
		$io_pdf->line(400,730,555,730);
		$io_pdf->addJpegFromFile('../../shared/imagebank/'.$_SESSION["ls_logo"],35,710,$_SESSION["ls_width"],$_SESSION["ls_height"]); // Agregar Logo
		$li_tm=$io_pdf->getTextWidth(11,$as_titulo);
		$io_pdf->addText(220,730,11,$as_titulo); // Agregar el ttulo
		$io_pdf->addText(430,735,10,"Fecha: ".date("d/m/Y")); // Agregar la Fecha
		$io_pdf->addText(430,715,10,"Hora: ".date("h:i a")); // Agregar la hora
		$io_pdf->restoreState();
		$io_pdf->closeObject();
		$io_pdf->addObject($io_encabezado,'all');
		return $io_pdf;
	}// end function uf_print_encabezadopagina
	//--------------------------------------------------------------------------------------------------------------------------------


//--------------------------------------------------------------------------------------------------------------------------------
function uf_print_cabecera_detalle($io_pdf)
{
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//       Function: uf_print_cabecera_detalle
//		   Access: private 
//	    Arguments: la_data // arreglo de informacion
//	   			   io_pdf // Objeto PDF
//    Description: funcion que imprime el detalle
//	   Creado Por: Ing. Yesenia Moreno
// Fecha Creacion: 21/04/2006 
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$io_encabezado=$io_pdf->openObject();
	$io_pdf->saveState();
	$io_pdf->ezSetY(700);
	$la_data   =array(array('cedula'=>'<b>Cedula</b>','nombre'=>'<b>Nombre</b>','apellido'=>'<b>Apellido</b>','cuenta'=>'<b>Cuenta</b>'));
	
	$la_config=array('showHeadings'=>0, // Mostrar encabezados
					 'titleFontSize' =>10,  // Tamao de Letras de los ttulos
					 'showLines'=>1, // Mostrar Lneas
					 'shaded'=>0,
					 'shadeCol2'=>array(0.86,0.86,0.86),
					 'colGap'=>1,
					 'width'=>520, // Ancho de la tabla
					 'maxWidth'=>520, // Ancho Mximo de la tabla
					 'xPos'=>296, // Orientacion de la tabla
					 'cols'=>array('cedula'=>array('justification'=>'center','width'=>70),
								   'nombre'=>array('justification'=>'center','width'=>180), // Justificacion y ancho de la columna
								   'apellido'=>array('justification'=>'center','width'=>180), // Justificacion y ancho de la columna
								   'cuenta'=>array('justification'=>'center','width'=>90))); // Justificacion y ancho de la columna
	$io_pdf->ezTable($la_data,'','',$la_config);
	$io_pdf->restoreState();
	$io_pdf->closeObject();
	$io_pdf->addObject($io_encabezado,'all');
	unset($la_data);
	unset($la_config);
		return $io_pdf;	
}// end function uf_print_cabecera_detalle
//------------------------------------------------------------------------------------------------------------------------------

//--------------------------------------------------------------------------------------------------------------------------------
	function uf_print_detalle($la_data,$io_pdf)
	{
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_detalle
		//		   Access: private 
		//	    Arguments: la_data // arreglo de informacion
		//	   			   io_pdf // Objeto PDF
		//    Description: funcion que imprime el detalle
		//	   Creado Por: Ing. Yesenia Moreno
		// Fecha Creacion: 21/04/2006 
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 9, // Tamao de Letras
						 'titleFontSize' => 9,  // Tamao de Letras de los ttulos
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>520, // Ancho de la tabla
						 'maxWidth'=>520, // Ancho Mximo de la tabla
						 'xPos'=>300, // Orientacion de la tabla
						 'cols'=>array('cedula'=>array('justification'=>'center','width'=>70), // Justificacion y ancho de la columna
						 			   'nombre'=>array('justification'=>'left','width'=>180), // Justificacion y ancho de la columna
						 			   'apellido'=>array('justification'=>'left','width'=>180), // Justificacion y ancho de la columna
						 			   'cuenta'=>array('justification'=>'center','width'=>90))); // Justificacion y ancho de la columna
		$io_pdf->ezTable($la_data,'','',$la_config);
		unset($la_data);
		unset($la_config);
		return $io_pdf;		
	}// end function uf_print_detalle
	//--------------------------------------------------------------------------------------------------------------------------------
	
	//-----------------------------------------------------  Instancia de las clases  ------------------------------------------------
	require_once("../../../shared/ezpdf/class.ezpdf.php");
	require_once("../../../shared/class_folder/sigesp_include.php");
	$io_in=new sigesp_include();
	$con=$io_in->uf_conectar();	
	require_once("../../../modelo/servicio/rpc/reportes/sigesp_rpc_class_report.php");
	$io_report = new sigesp_rpc_class_report($con);
	require_once("../../../shared/class_folder/class_sql.php");
	$io_sql = new class_sql($con);
	//----------------------------------------------------  Parmetros del encabezado  -----------------------------------------------
	$ls_titulo="<b>Listado de Beneficiarios</b>";
	//--------------------------------------------------  Parmetros para Filtar el Reporte  -----------------------------------------
	if (array_key_exists("hidorden",$_POST))
	   {
		 $li_orden=$_POST["hidorden"];
	   }
	else
	   {
		 $li_orden=$_GET["hidorden"];
	   }
	if (array_key_exists("hidcedula1",$_POST))
	   {
		 $ls_cedula1=$_POST["hidcedula1"];
	   }
	else
	   {
		 $ls_cedula1=$_GET["hidcedula1"];
	   }
	if (array_key_exists("hidcedula2",$_POST))
	   {
		 $ls_cedula2=$_POST["hidcedula2"];
	   }
	else
	   {
		 $ls_cedula2=$_GET["hidcedula2"];
	   }
	$lb_valido=true;
	$arrResultado=$io_report->uf_select_beneficiario($li_orden,$ls_cedula1,$ls_cedula2,$lb_valido);
	$rs_beneficiario=$arrResultado["rs_data"];
	$lb_valido = $arrResultado["lb_valido"];			
	if ($lb_valido)
	   {
		error_reporting(E_ALL);
		set_time_limit(1800);
		$io_pdf=new Cezpdf('LETTER','portrait'); // Instancia de la clase PDF
		$io_pdf->selectFont('../../../shared/ezpdf/fonts/Helvetica.afm'); // Seleccionamos el tipo de letra
		$io_pdf->ezSetCmMargins(3.8,3,3,3); // Configuracion de los margenes en centmetros
		$io_pdf = uf_print_encabezado_pagina($ls_titulo,$io_pdf); // Imprimimos el encabezado de la pgina
		$io_pdf->ezStartPageNumbers(550,50,10,'','',1); // Insertar el nmero de pgina
		$z=1;
		while (!$rs_beneficiario->EOF)
			{//1
			  $ls_cedbene =$rs_beneficiario->fields["ced_bene"];
			  $ls_nombene =$rs_beneficiario->fields["nombene"];
			  $ls_apebene =$rs_beneficiario->fields["apebene"];
			  $ls_cuenta  =$rs_beneficiario->fields["sc_cuenta"];
  			  $la_data[$z]=array('cedula'=>$ls_cedbene,'nombre'=>$ls_nombene,'apellido'=>$ls_apebene,'cuenta'=>$ls_cuenta);
			  $z++;
			  $rs_beneficiario->MoveNext();
			}//4
		$io_pdf = uf_print_cabecera_detalle($io_pdf);
		$io_pdf = uf_print_detalle($la_data,$io_pdf); // Imprimimos el detalle 
		unset($la_data);
		if($lb_valido) // Si no ocurrio ningn error
		{
			$io_pdf->ezStopPageNumbers(1,1); // Detenemos la impresion de los nmeros de pgina
			$io_pdf->ezStream(); // Mostramos el reporte
		}
		else  // Si hubo algn error
		{
			print("<script language=JavaScript>");
			print(" alert('Ocurrio un error al generar el reporte. Intente de Nuevo');"); 
			print(" close();");
			print("</script>");		
		}
		unset($io_pdf);			
	}//1
	else
	 {
		print("<script language=JavaScript>");
		print(" alert('No hay nada que Reportar');"); 
		print(" close();");
		print("</script>");
	 }
?> 
