/**
 * 
 */
var formulario = null //varibale para almacenar la instacia de objeto de formulario 
barraherramienta = true;
var grid = null;

Ext.onReady(function() {
	Ext.BLANK_IMAGE_URL = '../../base/librerias/js/ext/resources/images/default/s.gif';
	
	//Datos del combo operacion
	var operacion = [ [ 'Anulacion', 'E' ], 
	                  [ 'Reversar de Anulacion', 'N' ] ];
	
	var stoperacion = new Ext.data.SimpleStore({
		fields : [ 'col', 'tipo' ],
		data : operacion
	});
	
	//-----------------------------------------------------------------------------------------------
	
	//componente catalogo de proveedores
	var reCatProveedor = Ext.data.Record.create([
	    {name: 'cod_pro'}, //campo obligatorio                             
	    {name: 'nompro'},  //campo obligatorio
	    {name: 'dirpro'},  //campo obligatorio
	    {name: 'rifpro'},   //campo obligatorio
	    {name: 'sc_cuenta'}//campo obligatorio
	]);

	var comcampocatproveedor = new com.sigesp.vista.comCatalogoProveedor({
		idComponente:'cxpprouno',
		reCatalogo: reCatProveedor,
		rutacontrolador:'../../controlador/rpc/sigesp_ctr_rpc_comcatproveedor.php',
		parametros: "ObjSon={'operacion': 'buscarProveedores'",
		soloCatalogo: true,
		arrSetCampo:[{campo:'codigo',valor:'cod_pro'},
		             {campo:'nombre',valor:'nompro'}],
		numFiltroNoVacio: 1
	});

	//componente catalogo de beneficiarios
	var reCatBeneficiario = Ext.data.Record.create([
	    {name: 'ced_bene'}, //campo obligatorio                             
	    {name: 'nombene'},  //campo obligatorio
	    {name: 'apebene'},  //campo obligatorio
	    {name: 'dirbene'},  //campo obligatorio
	    {name: 'rifben'},   //campo obligatorio
	    {name: 'sc_cuenta'}//campo obligatorio
	]);

	var comcampocatbeneficiario = new com.sigesp.vista.comCatalogoBeneficiario({
		idComponente:'cxpbenuno',
		reCatalogo: reCatBeneficiario,
		rutacontrolador:'../../controlador/rpc/sigesp_ctr_rpc_comcatbeneficiario.php',
		parametros: "ObjSon={'operacion': 'buscarBeneficiarios'",
		soloCatalogo: true,
		arrSetCampo:[{campo:'codigo',valor:'ced_bene'},
		             {campo:'nombre',valor:'nombene'}],
		numFiltroNoVacio: 1
	});

	//creando store para el combo destino
	var destino = [
	               ['Proveedor','P'],
	               ['Beneficiario','B'],
	               ['Ninguno','']
	               ]; 

	var stdestino = new Ext.data.SimpleStore({
		fields : [ 'etiqueta', 'valor' ],
		data : destino
	});
	//fin creando store para el combo destino 

	//creando objeto combo destino
	var cmbdestino = new Ext.form.ComboBox({
		store : stdestino,
		fieldLabel : 'Destino',
		labelSeparator : '',
		editable : false,
		displayField : 'etiqueta',
		valueField : 'valor',
		id : 'tipo_destino',
		width:130,
		typeAhead: true,
		emptyText:'Seleccione',
		triggerAction:'all',
		forceselection:true,
		mode:'local',
		listeners: {
			'select': function(valor){
				if(valor.getValue()=="P") {
					comcampocatproveedor.mostrarVentana();
				}
				else if(valor.getValue()=="B"){
					comcampocatbeneficiario.mostrarVentana();
				}
				else{
					Ext.getCmp('cod_pro').setValue('----------');
				}
					
			}
		}
	});

	//-------------------------------------------------------------------------------------------------------------------------	

	//Creando el campo de orden de compra
	var reVentana = Ext.data.Record.create([
          {name: 'numsol'}, 
          {name: 'fecemisol'},
          {name: 'cod_pro'},
          {name: 'ced_bene'},
          {name: 'nombre'},
		  {name: 'estaprosol'},
		  {name: 'monsol'},
		  {name: 'tipproben'}
	]);
	                                        	
	var dsVentana =  new Ext.data.Store({
           reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reVentana)
	});
	                                						
	 var cmVentana = new Ext.grid.ColumnModel([
           new Ext.grid.CheckboxSelectionModel(),
           {header: "<H1 align='center'>Nmero de <br> Solicitud</H1>", width: 50, sortable: true, dataIndex: 'numsol'},
           {header: "<H1 align='center'>Fecha <br>Emision</H1>", width: 40, sortable: true, dataIndex: 'fecemisol'},
           {header: "<H1 align='center'>Proveedor / Beneficiario</H1>", width: 70, sortable: true, dataIndex: 'nombre'},
           {header: "<H1 align='center'>Estatus de <br> Aprobacion</H1>", width: 50, sortable: true, dataIndex: 'estaprosol', renderer: MostrarEstatus},
           {header: "<H1 align='center'>Monto</H1>", width: 50, sortable: true, dataIndex: 'monsol'}
	]);
	//fin creando datastore y columnmodel para el catalogo de orden de compra
	 
	 grid = new Ext.grid.GridPanel({
	 		width:650,
	 		height:250,
			frame:true,
			title: "<H1 align='center'>Solicitudes de Ordenes de Pago</H1>",
			style: 'position:absolute;left:10px;top:200px',
			autoScroll:true,
			border:true,
			ds: dsVentana,
    		cm: cmVentana,
			sm: new Ext.grid.CheckboxSelectionModel(),
    		stripeRows: true,
    		viewConfig: {forceFit:true}
	});
	
	//-------------------------------------------------------------------------------------------------------------------------		 
	
	//creando formulario principal 
	var Xpos = ((screen.width/2)-(375)); 
	var Ypos = ((screen.height/2)-(650/2));
	formulario = new Ext.FormPanel({
		title: "<H1 align='center'>Anulacion de Solicitud de Pago</H1>",
		applyTo: 'formulario',
		width: 685,
		height: 490,
		style: 'position:absolute;top:'+Ypos+'px;left:'+Xpos+'px', // 'position:absolute;margin-left:'+Xpos+'px;margin-top:45px;',
		frame: true,
		autoScroll:false,
		items: [{  // fromDatos, fromDatOrdCom, 
			xtype:"fieldset", 
    		title:'Datos de la Solicitud',
    		style: 'position:absolute;left:10px;top:5px',
    		border:true,
    		width: 650,
    		cls : 'fondo',
    		height: 190,
    		items:[{
    			layout: "column",
    			defaults: {border: false},
    			style: 'position:absolute;left:15px;top:10px',
    			items: [{
    				layout: "form",
    				border: false,
    				labelWidth: 150,
    				items: [{
    					xtype: 'combo',
    					fieldLabel: 'Tipo de Operacion',
    					labelSeparator :'',
    					id: 'tipope',
    					store : stoperacion,
    					editable : false,
    					displayField : 'col',
    					valueField : 'tipo',
    					typeAhead : true,
    					triggerAction : 'all',
    					mode : 'local',
    					emptyText:'----Seleccione----',
    					listWidth:150,
    					width:150
    				}]			
    			}]
    		},
    		{
    			layout: "column",
    			defaults: {border: false},
    			style: 'position:absolute;left:15px;top:40px',
    			items: [{
    				layout: "form",
    				border: false,
    				labelWidth: 150,
    				items: [{
    					xtype: 'textfield',
						fieldLabel: 'Solicitud',
						labelSeparator :'',
						id: 'numsol',
						width: 150,
						autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '15', onkeypress: "return keyRestrict(event,'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789');"},
						changeCheck: function(){
    						var textvalor = this.getValue();
    						dsVentana.filter('numsol',textvalor,true);
    						if(String(textvalor) !== String(this.startValue)){
    							this.fireEvent('change', this, textvalor, this.startValue);
    						} 
    					}, 
    					initEvents: function(){
    						AgregarKeyPress(this);
    					},
    				}]			
    			}]
    		},
    		{
    			layout:"column",
    			defaults: {border: false},
    			style: 'position:absolute;left:460px;top:10px',
    			border:false,
    			items:[{
    				layout:"form",
    				border:false,
    				labelWidth:50,
    				items:[{
    					xtype:"datefield",
    					labelSeparator :'',
    					fieldLabel:"Fecha",
    					name:"fecha",
    					id: 'fecha',
    					allowBlank:true,
    					value: obtenerFechaActual(),
    					autoCreate: {tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789/');"}
    				}]
    			}]
    		},
    		{
    			layout:"column",
    			defaults: {border: false},
    			style: 'position:absolute;left:15px;top:70px',
    			border:false,
    			items:[{
    				layout:"form",
    				border:false,
    				labelWidth:150,
    				items:[{
    					xtype:"datefield",
    					labelSeparator :'',
    					fieldLabel:"Fecha de Registro Desde",
    					name:"fecregdocdes",
    					id: 'fecregdocdes',
    					allowBlank:true,
    					changeCheck: function(){
    						var textvalor = this.getValue();
    						dsVentana.filter('fecregdoc',textvalor,true);
    						if(String(textvalor) !== String(this.startValue)){
    							this.fireEvent('change', this, textvalor, this.startValue);
    						} 
    					}, 
    					initEvents: function(){
    						AgregarKeyPress(this);
    					},
    					value: new Date().format('01/m/Y'),
    					autoCreate: {tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789/');"}
    				}]
    			}]
    		},
    		{
    			layout:"column",
    			defaults: {border: false},
    			style: 'position:absolute;left:280px;top:70px',
    			border:false,
    			items:[{
    				layout:"form",
    				border:false,
    				labelWidth:40,
    				items:[{
    					xtype:"datefield",
    					labelSeparator :'',
    					fieldLabel:"Hasta",
    					name:"fecregdochas",
    					id: 'fecregdochas',
    					allowBlank:true,
    					changeCheck: function(){
    						var textvalor = this.getValue();
    						dsVentana.filter('fecregdoc',textvalor,true);
    						if(String(textvalor) !== String(this.startValue)){
    							this.fireEvent('change', this, textvalor, this.startValue);
    						} 
    					}, 
    					initEvents: function(){
    						AgregarKeyPress(this);
    					},
    					value: obtenerFechaActual(),
    					autoCreate: {tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789/');"}
    				}]
    			}]
    		},{
				layout:"column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:100px',
				border:false,
				items:[{
					layout:"form",
					border:false,
					labelWidth:50, //130
					items:[cmbdestino]
				},{
					layout: "form",
					border: false,
					labelWidth: 5,
					items: [{
						xtype: 'textfield',
						fieldLabel: '',
						labelSeparator :'',
						id: 'codigo',
						disabled:true,
						binding:true,
						hiddenvalue:'',
						defaultvalue:'----------',
						allowBlank:true,
						width: 110
					}]
				},{
					layout: "form",
					border: false,
					labelWidth: 5,
					items: [{
						xtype: 'textfield',
						fieldLabel: '',
						labelSeparator :'',
						id: 'nombre',
						disabled:true,
						binding:true,
						hiddenvalue:'',
						defaultvalue:'Ninguno',
						allowBlank:true,
						width: 250
					}]
				}]
			}]
		},
		{
			layout: "column",
			defaults: {border: false},
			style: 'position:absolute;left:25px;top:150px',
			items: [{
				layout: "form",
				border: false,
				labelWidth: 160,
				items: [{
					xtype: 'checkbox',
					labelSeparator :'',
					fieldLabel: 'Recepcion de Documentos Contables',
					id: 'emitidaapro',
					inputValue:1,
				}]
			}]
		},grid]
	});
	//fin creando formulario principal con parametros de busqueda y grid de modificaciones
});

	//-------------------------------------------------------------------------------------------------------------------------		 

	function irBuscar()
	{
		if(Ext.getCmp('tipope').getValue()!='')
		{
			obtenerMensaje('procesar','','Buscando Datos');
			var fechadesde = Ext.getCmp('fecregdocdes').getValue();
			var fechahasta = Ext.getCmp('fecregdochas').getValue();
			var repcon = "0";
			if(fechadesde!=''){
				fechadesde = Ext.getCmp('fecregdocdes').getValue().format('d/m/Y');
			}
			if(fechahasta!=''){
				fechahasta = Ext.getCmp('fecregdochas').getValue().format('d/m/Y');
			}
			if(Ext.getCmp('emitidaapro').checked){ //Estatus Enulada
				repcon = "1";
			}
			//buscar modificaciones a orden de compra
			var JSONObject = {
					'operacion'    : 'buscar_solicitud',
					'numsol'       : Ext.getCmp('numsol').getValue(),
					'proben'       : Ext.getCmp('codigo').getValue(),
					'tipo'         : Ext.getCmp('tipo_destino').getValue(),
					'fecsoldes'    : fechadesde,
					'fecsolhas'    : fechahasta,
					'tipooperacion': Ext.getCmp('tipope').getValue(),
					'repcon'       : repcon,
					'catalogo'     : 'Anulacion'
	        }
			var ObjSon = JSON.stringify(JSONObject);
			var parametros = 'ObjSon='+ObjSon; 
			Ext.Ajax.request({
				url : '../../controlador/cxp/sigesp_ctr_cxp_solicitudpago.php',
				params : parametros,
				method: 'POST',
				success: function ( resultado, request){
					Ext.Msg.hide();
					var datos = resultado.responseText;
					var objetoMovbco = eval('(' + datos + ')');
					if(objetoMovbco.raiz == null || objetoMovbco.raiz ==''){
						grid.store.removeAll();
						Ext.MessageBox.show({
							title:'Advertencia',
							msg:'No existen datos para mostrar',
							buttons: Ext.Msg.OK,
							icon: Ext.MessageBox.WARNING
						});
					}
					else{
						grid.store.loadData(objetoMovbco);
					}
				}	
			});
		}
		else{
			alert('Debe seleccionar la Operacion a ejecutar..!!');
		}
	}

	function irCancelar(){
		limpiarFormulario(formulario);
		grid.store.removeAll();
	}
	
	function irProcesar(){
		var fecha = Ext.getCmp('fecha').getValue().format('Y/m/d');
		var cadenajson = "{'operacion':'actualizar_estatus','codsis':'CXP','nomven':'sigesp_vis_cxp_anulacionsolicitudpago.html','estatus':'"+Ext.getCmp('tipope').getValue()+"','fecha':'"+fecha+"','arrRecepciones':[";
		var arrRegistro = grid.getSelectionModel().getSelections();  
		if(arrRegistro.length>0){
			for( var int = 0; int < arrRegistro.length; int++) {
				var datos = arrRegistro[int];
				if(int==0){
					cadenajson = cadenajson +"{'numsol':'"+datos.get('numsol')+"','fecemisol':'"+datos.get('fecemisol')+"'," +
							                 "'cod_pro':'"+datos.get('cod_pro')+"','ced_bene':'"+datos.get('ced_bene')+"'," +
							                 "'tipproben':'"+datos.get('tipproben')+"','estaprosol':'"+datos.get('estaprosol')+"'}";
				}
				else{
					cadenajson = cadenajson +",{'numsol':'"+datos.get('numsol')+"','fecemisol':'"+datos.get('fecemisol')+"'," +
							                 "'cod_pro':'"+datos.get('cod_pro')+"','ced_bene':'"+datos.get('ced_bene')+"'," +
							                 "'tipproben':'"+datos.get('tipproben')+"','estaprosol':'"+datos.get('estaprosol')+"'}";
				}
			}
			cadenajson = cadenajson +"]}";	
			var parametros = 'ObjSon='+cadenajson;
			Ext.Ajax.request({
				url : '../../controlador/cxp/sigesp_ctr_cxp_anulacionsolicitudpago.php',
				params : parametros,
				method: 'POST',
				success: function (resultado, request)
				{ 
					var resultado = resultado.responseText;
					var arrResultado = resultado.split("|");
					Ext.Msg.hide();
					//creando componente detalle comprobante
					var comResultado = new com.sigesp.vista.comResultadoIntegrador({
						tituloVentana: 'Resultado de las Recepcionnes Anuladas',
						anchoLabel: 200,
						labelTotal:'Total registros procesados',
						valorTotal: arrResultado[0],
						labelProcesada:'Total registros modificados',
						valorProcesada:arrResultado[1],
						labelError:'Total registros con error',
						valorError:arrResultado[2],
						tituloGrid:'Detalle de Resultados',
						dataDetalle:arrResultado[3]
					});
					//fin creando componente detalle comprobante
					comResultado.mostrarVentana();
					irCancelar();
				},
				failure: function (result,request) 
				{ 
					Ext.Msg.hide();
					Ext.MessageBox.alert('Error', 'Error al procesar la Informacion'); 
				}	
			});
		}
		else{
			Ext.MessageBox.show({
				title:'Mensaje',
				msg:'Debe seleccionar al menos un documento a procesar..!!',
				buttons: Ext.Msg.OK,
				icon: Ext.MessageBox.INFO
			});
		}
	}
	
	function MostrarEstatus(valor){
		if(valor=='1'){
			return 'Aprobada';
		}
		else {
			return 'No Aprobada';
		}
	}