//Funcion que completa el comprbante con ceros para alcanzar la longitud maxima
function CatalogoRecepcion(acum,tipo,codigo,nombre,catalogo,numordpagmin,codtipfon,repcajchi)
{
	
	//componente catalogo de proveedores
	var reCatProv = Ext.data.Record.create([
	    {name: 'cod_pro'}, //campo obligatorio                             
	    {name: 'nompro'},  //campo obligatorio
	    {name: 'dirpro'},  //campo obligatorio
	    {name: 'rifpro'}   //campo obligatorio
	]);

	var comcampocatprov = new com.sigesp.vista.comCatalogoProveedor({
		idComponente:'spiprodos'+acum,
		reCatalogo: reCatProv,
		rutacontrolador:'../../controlador/rpc/sigesp_ctr_rpc_comcatproveedor.php',
		parametros: "ObjSon={'operacion': 'buscarProveedores'",
		soloCatalogo: true,
		arrSetCampo:[{campo:'catcodpro',valor:'cod_pro'}],
		             numFiltroNoVacio: 1
	});

	//componente catalogo de beneficiarios
	var reCatBene = Ext.data.Record.create([
	    {name: 'ced_bene'}, //campo obligatorio                             
	    {name: 'nombene'},  //campo obligatorio
	    {name: 'apebene'},  //campo obligatorio
	    {name: 'dirbene'}   //campo obligatorio
	]);

	var comcampocatbene = new com.sigesp.vista.comCatalogoBeneficiario({
		idComponente:'spibendos'+acum,
		reCatalogo: reCatBene,
		rutacontrolador:'../../controlador/rpc/sigesp_ctr_rpc_comcatbeneficiario.php',
		parametros: "ObjSon={'operacion': 'buscarBeneficiarios'",
		soloCatalogo: true,
		arrSetCampo:[{campo:'catcodpro',valor:'ced_bene'}],
		             numFiltroNoVacio: 1
	});

	//creando store para el combo destino
	var destinoProBen = [['Proveedor','P'],
	                     ['Beneficiario','B']]; 

	var stdestinoProBen = new Ext.data.SimpleStore({
		fields : [ 'etiqueta', 'valor' ],
		data : destinoProBen
	});
	//fin creando store para el combo destino 

	//creando objeto combo destino
	var cmbdestinoProBen = new Ext.form.ComboBox({
		store : stdestinoProBen,
		fieldLabel : 'Tipo ',
		labelSeparator : '',
		editable : false,
		displayField : 'etiqueta',
		valueField : 'valor',
		id : 'combodestino',
		binding:true,
		hiddenvalue:'',
		defaultvalue:'-',
		allowBlank:false,
		width:130,
		typeAhead: true,
		emptyText:'Seleccione',
		triggerAction:'all',
		forceselection:true,
		binding:true,
		mode:'local',
		listeners: {
			'select': function(valor){
				if(valor.getValue()=="P") {
					comcampocatprov.mostrarVentana();
				}
				else{
					comcampocatbene.mostrarVentana();
				}
			}
		}
	});
	
	if(tipo!=''){
		Ext.getCmp('combodestino').setValue(tipo);
//		Ext.getCmp('catcodpro').setValue(codigo);
		Ext.getCmp('combodestino').disable();
	}
	
	//Creacion del combo clasificacion de concepto
	var reConcepto = Ext.data.Record.create([
		{name:'codcla'},
		{name:'dencla'}           
	]);

	var	stConcepto =  new Ext.data.Store({
		reader: new Ext.data.JsonReader({root: 'raiz', id: "id"},reConcepto)
	});
		
	var myJSONObject = {
		"operacion": 'buscarClasificacionConcepto'
	};	
	
	var ObjSon = JSON.stringify(myJSONObject);
	var parametros = 'ObjSon='+ObjSon; 
	Ext.Ajax.request({
		url : '../../controlador/cxp/sigesp_ctr_cxp_recepcioncontable.php',
		params : parametros,
		method: 'POST',
		success: function (resultado, request) { 
			var datos = resultado.responseText;  
			if(datos!=''){
				var DatosNuevo = eval('(' + datos + ')');
				stConcepto.loadData(DatosNuevo);
			}
		}//fin de success
	});//fin de ajax request
	
	//creando store para el combo estatus
	var reEstatus = [['Recibidas','R'],
	                 ['Emitidas','E'],
	                 ['Contabilizadas','C'],
	                 ['Anuladas','A'],]; 

	var stEstatus = new Ext.data.SimpleStore({
		fields : [ 'etiqueta', 'valor' ],
		data : reEstatus
	});
	//fin creando store para el combo estatus
	
	//creando objeto combo estatus
	var cmbestatus = new Ext.form.ComboBox({
		store : stEstatus,
		fieldLabel : 'Estatus ',
		labelSeparator : '',
		editable : false,
		displayField : 'etiqueta',
		valueField : 'valor',
		id : 'comboestatus',
		binding:true,
		hiddenvalue:'',
		defaultvalue:'-',
		allowBlank:false,
		width:130,
		typeAhead: true,
		emptyText:'Seleccione',
		triggerAction:'all',
		forceselection:true,
		binding:true,
		mode:'local'
	});

	//Creacion del combo procedencia
	var reProcedencia = Ext.data.Record.create([
	    {name: 'procede'},
	    {name: 'desproc'}
	]);

	dsProcedencia =  new Ext.data.Store({
		reader: new Ext.data.JsonReader({root: 'raiz',id: "procede"},reProcedencia)			
	});

	CmbProcedencia = new Ext.form.ComboBox({
		store: dsProcedencia,
		labelSeparator :'',
		fieldLabel:'Procedencia',
		displayField:'desproc',
		valueField:'procede',
		name: 'procedencia',
		width:350,
		listWidth: 350, 
		id:'procedencia',
		typeAhead: true,
		binding:true,
		defaultvalue:'---',
		emptyText:'----Seleccione----',
		allowBlank:true,
		selectOnFocus:true,
		mode:'local',
		triggerAction:'all',
		valor:''
	});
	//Fin combo procedencia

	//creando datastore y columnmodel para la grid de los comprobantes contables
	var reComprobante = Ext.data.Record.create([
	    {name: 'nombre'},
	    {name: 'rif'},
	    {name: 'numrecdoc'},
	    {name: 'codtipdoc'},
	    {name: 'ced_bene'},
	    {name: 'cod_pro'},
	    {name: 'codcla'},
	    {name: 'dencondoc'},
	    {name: 'fecemidoc'},
	    {name: 'fecregdoc'},
	    {name: 'fecvendoc'},
	    {name: 'montotdoc'},
	    {name: 'mondeddoc'},
	    {name: 'moncardoc'},
	    {name: 'tipproben'},
	    {name: 'numref'},
	    {name: 'estprodoc'},
	    {name: 'procede'},
	    {name: 'estlibcom'},
	    {name: 'estaprord'},
	    {name: 'fecaprord'},
	    {name: 'usuaprord'},
	    {name: 'numpolcon'},
	    {name: 'estimpmun'},
	    {name: 'montot'},
	    {name: 'codfuefin'},
	    {name: 'codrecdoc'},
	    {name: 'fechaconta'},
	    {name: 'fechaanula'},
	    {name: 'coduniadm'},
	    {name: 'codestpro1'},
	    {name: 'codestpro2'},
	    {name: 'codestpro3'},
	    {name: 'codestpro4'},
	    {name: 'codestpro5'},
	    {name: 'estcla'},
	    {name: 'estact'},
	    {name: 'numordpagmin'},
	    {name: 'codtipfon'},
	    {name: 'repcajchi'},
	    {name: 'codproalt'},
	    {name: 'conanurd'},
	    {name: 'tipdoctesnac'},
	    {name: 'numexprel'},
	    {name: 'estpre'},
	    {name: 'estcon'},
	    {name: 'dentipdoc'},
	]);	
	
	var dsComprobante =  new Ext.data.Store({
		reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reComprobante)
	});

	var cmComprobante = new Ext.grid.ColumnModel([
	     new Ext.grid.CheckboxSelectionModel(),
	    {header: "<CENTER>Nro. Recepcion</CENTER>", width: 60, align: 'center', sortable: true, dataIndex: 'numrecdoc'},
	    {header: "<CENTER>Proveedor / Beneficiario</CENTER>", width: 60, sortable: true, dataIndex: 'nombre'},
	    {header: "<CENTER>Fecha Registro</CENTER>", width: 30, sortable: true, dataIndex: 'fecha', align: 'fecregdoc'},
	    {header: "<CENTER>Estatus</CENTER>", type: 'float', width: 40, align: 'center', sortable: true, dataIndex: 'estaprord', renderer: MostrarEstatus},
	    {header: "<CENTER>Monto Total</CENTER>", type: 'float', width: 40, align: 'right', sortable: true, dataIndex: 'montotdoc'},
	]);
	//fin del datastore y columnmodel para la grid de bienes

	//creando grid para los detalles de bienes
	gridComprobante = new Ext.grid.GridPanel({
		width:780,
		height:240,
		frame:true,
		title:"",
		style: 'position:absolute;left:15px;top:180px',
		autoScroll:true,
		border:true,
		ds: dsComprobante,
		cm: cmComprobante,
		stripeRows: true,
		sm:new Ext.grid.CheckboxSelectionModel(),
		viewConfig: {forceFit:true}
	});

	var	formVentanaCatalogo = new Ext.FormPanel({
		width: 830,
		height: 440,
		style: 'position:absolute;left:5px;top:10px',
		frame: true,
		autoScroll:false,
		items: [{
			xtype:"fieldset", 
			title:'Datos de la Recepcion',
			style: 'position:absolute;left:15px;top:5px',
			border:true,
			cls: 'fondo',
			width: 780,
			height: 170,
			items:[{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:10px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 110,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Nro. de Recepcion',
						id: 'numerorec',									
						width: 170,
						autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '15', onkeypress: "return keyRestrict(event,'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789');"},
						changeCheck: function(){
							var textvalor = this.getValue();
							dsComprobante.filter('numrecdoc',textvalor,true);
							if(String(textvalor) !== String(this.startValue)){
								this.fireEvent('change', this, textvalor, this.startValue);
							} 
						}, 
						initEvents: function(){
							AgregarKeyPress(this);
						}
					}]
				}]
			},
			{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:40px',
				items: [{
					layout: "form",
					border: true,
					labelWidth: 110,
					items: [cmbestatus]
				}]
			},
			{
     			layout: "column",
				border: false,
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:70px',
				items: [{
					layout: "form",
 					border: false,
 					labelWidth: 110,			
 					items: [{
 						xtype:"combo",
 			        	store: stConcepto,
 			        	labelSeparator :'',
 			        	valueField: 'codcla',
 			        	displayField: 'dencla', 
 			        	id:"concepto",
 			        	typeAhead: true,
 			        	mode: 'local',
				        triggerAction: 'all',
				        fieldLabel:'Concepto',
				   	    listWidth:200,
				   	    editable:false,
				        width:200
 		    		}]
         		}]
       		},
			{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:100px',
				items: [{
					layout: "form",
					border: true,
					labelWidth: 110,
					items: [cmbdestinoProBen]

				},{
					layout: "form",
					border: false,
					labelWidth: 10,
					items: [{
						xtype: 'textfield',
						fieldLabel: '',
						labelSeparator :'',
						id: 'catcodpro',
						disabled:true,
						binding:true,
						hiddenvalue:'',
						defaultvalue:'----------',
						allowBlank:true,
						width: 130,
						value: codigo
					}]
				},{
	 				layout: "form",
	 				border: false,
	 				labelWidth: 50,
	 				items: [{	
	 					xtype: 'label',
						style:'font-weight: bold;', 
						text: nombre,
						id: 'artser',
						width: 100
	 				}]
		 		}]
			},
			{
				layout:"column",
				defaults: {border: false},
				style: 'position:absolute;left:480px;top:10px',  //520/20
				border:false,
				items:[{
					layout:"form",
					border:false,
					labelWidth:80,
					items:[{
						xtype:"datefield",
						labelSeparator :'',
						fieldLabel:"Fecha Desde",
						name:'Fecha',
						id:'fecdesde',
						allowBlank:false,
						width:130,
						binding:true,
						defaultvalue:'1900-01-01',
						hiddenvalue:'',
						value: new Date().format('01-m-Y'),
						autoCreate: {tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789/');"}
					}]
				}]
			},
			{
				layout:"column",
				defaults: {border: false},
				style: 'position:absolute;left:480px;top:40px', //520/50
				border:false,
				items:[{
					layout:"form",
					border:false,
					labelWidth:80,
					items:[{
						xtype:"datefield",
						labelSeparator :'',
						fieldLabel:"Hasta",
						name:'Fecha',
						id:'fechasta',
						allowBlank:false,
						width:130,
						binding:true,
						defaultvalue:'1900-01-01',
						hiddenvalue:'',
						value: new Date().format('d-m-Y'),
						autoCreate: {tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789/');"}
					}]
				}]
			},
			{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:380px;top:70px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 250,
					items: [{
						xtype: 'checkbox',
						labelSeparator :'',
						fieldLabel: 'Buscar Recepcion de Documentos Contables',
						id: 'emitidaapro',
						inputValue:1,
						allowBlank:true
					}]
				}]
			},
			{
				layout:"column",
				defaults: {border: false},
				style: 'position:absolute;left:670px;top:120px', 
				border:false,
				items:[{
					layout:"form",
					border:false,
					items:[{
						xtype: 'button',
						fieldLabel: '',
						id: 'btagregar',
						text: 'Buscar',
						iconCls: 'menubuscar',
						handler: function(){
							if(Ext.getCmp('fecdesde').getValue().format('Y-m-d')<=Ext.getCmp('fechasta').getValue().format('Y-m-d')){
								obtenerMensaje('procesar','','Buscando Datos');
								var repcon = "0";
								if(Ext.getCmp('emitidaapro').checked){ //Estatus Enulada
									repcon = "1";
								}
								//Buscar ordenes de compra
								var JSONObject = {
										'operacion'   : 'buscar_recepcion',
										'numsol'       : Ext.getCmp('numerorec').getValue(),
										'proben'       : Ext.getCmp('catcodpro').getValue(),
										'tipo'         : Ext.getCmp('combodestino').getValue(),
										'fecregdes'    : Ext.getCmp('fecdesde').getValue().format('Y-m-d'),
										'fecreghas'    : Ext.getCmp('fechasta').getValue().format('Y-m-d'),
										'tipooperacion': '',
										'repcon'       : repcon,
										'catalogo'     : catalogo,
										'numordpagmin' : numordpagmin,
										'codtipfon'    : codtipfon,
										'repcajchi'    : repcajchi,
								}

								var ObjSon = JSON.stringify(JSONObject);
								var parametros = 'ObjSon='+ObjSon; 
								Ext.Ajax.request({
									url : '../../controlador/cxp/sigesp_ctr_cxp_recepcioncontable.php',
									params : parametros,
									method: 'POST',
									success: function ( resultado, request){
										Ext.Msg.hide();
										var datos = resultado.responseText;
										var objCmp = eval('(' + datos + ')');
										if(objCmp!=''){
											if(objCmp!='0'){
												if(objCmp.raiz == null || objCmp.raiz ==''){
													Ext.MessageBox.show({
														title:'Advertencia',
														msg:'No existen datos para mostrar',
														buttons: Ext.Msg.OK,
														icon: Ext.MessageBox.WARNING
													});
													gridComprobante.store.removeAll();
												}
												else{
													gridComprobante.store.loadData(objCmp);
												}
											}
											else{
												Ext.MessageBox.show({
													title:'Advertencia',
													msg:'',
													buttons: Ext.Msg.OK,
													icon: Ext.MessageBox.WARNING
												});
											}
										}
									}//fin del success	
								});//fin del ajax request
							}
							else{
								Ext.MessageBox.show({
									title:'Mensaje',
									msg:'El rango de fechas no es correcto !!!',
									buttons: Ext.Msg.OK,
									icon: Ext.MessageBox.WARNING
								});
							}
						}
					}]
				}]
			}]
		},gridComprobante]
	});

	var ventanaEstructura = new Ext.Window({
		width:850, 
		height:520,
		closable:false,
		border:false,
		modal: true,
		frame:true,
		title:"<H1 align='center'>Cat&#225;logo de Recepciones de Documentos</H1>",
		items:[formVentanaCatalogo],
		buttons: [{
			text:'Aceptar',  
			handler: function(){
				var registro = gridComprobante.getSelectionModel().getSelections();
				if(catalogo == 'Ubicacion-Recepcion')
				{
					Ext.getCmp('nrorecepcion').setValue(registro[0].get('numrecdoc'));
					gridComprobante.destroy();
					ventanaEstructura.destroy();
				}else if(catalogo ==  'SolicitudPago'){
					Aceptar_Solicitud(registro);
					gridComprobante.destroy();
					ventanaEstructura.destroy();	
				}
				else{
					if(registro.length==1){
						Aceptar_Recepcion(registro[0]);
						gridComprobante.destroy();
						ventanaEstructura.destroy();
					}
					else{
						alert('Debe Seleccionar solo un registro..!!');
					}
				}
			}
		},{
	   		text: 'Salir',
   			handler:function(){
				ventanaEstructura.destroy();
   		    }
   		}]
	});

	ventanaEstructura.show();
	


	//Buscar datos para el tipo de documento
	function llenarComboTipoDocumento(valor)
	{
		var myJSONObject ={
				"operacion": 'buscar_tipodocumento'
		};	
		var ObjSon=JSON.stringify(myJSONObject);
		var parametros = 'ObjSon='+ObjSon; 
		Ext.Ajax.request({
			url : '../../controlador/cxp/sigesp_ctr_cxp_recepcioncontable.php',
			params : parametros,
			method: 'POST',
			success: function (resultado, request) { 
				var datosm = resultado.responseText;
				if(datosm!='')
				{
					var Datos = eval('(' + datosm + ')');
					dsTipoDocumento.loadData(Datos);
					Ext.getCmp('codtipdoc').setValue(valor);
				}
			}//fin del success
		});//fin del ajax request
	}

	//function que setea los datos en el formulario principal
	function Aceptar_Recepcion(registro)
	{
		Actualizar=true;
		limpiarFormulario(fromRecepcionDocumento);
		setDataFrom(fromRecepcionDocumento,registro);
		var estope='C';
		if(registro.get('estpre')=='2'){
			estope='P';
		}
		else if(registro.get('estpre')=='3'){
			estope='N';
		}
		else if(registro.get('estpre')=='4'){
			estope='S';
		}
		llenarComboTipoDocumento((registro.get('codtipdoc'))+estope+(registro.get('estpre'))+(registro.get('estcon')));
		if(registro.get('estprodoc')=='R'){
			Ext.getCmp('estlabel').setValue('Recibido');
		}
		else if(registro.get('estprodoc')=='E'){
			Ext.getCmp('estlabel').setValue('Emitido');
		}
		else if(registro.get('estprodoc')=='C'){
			Ext.getCmp('estlabel').setValue('Contabilizado');
		}
		else if(registro.get('estprodoc')=='A'){
			Ext.getCmp('estlabel').setValue('Anulado');
		}
		Ext.getCmp('nompro').setValue(registro.get('nombre'));
		Ext.getCmp('rifpro').setValue(registro.get('rif'));
		buscar_spg(registro.get('numrecdoc'),registro.get('codtipdoc'),registro.get('cod_pro'),registro.get('ced_bene'));
		buscar_scg(registro.get('numrecdoc'),registro.get('codtipdoc'),registro.get('cod_pro'),registro.get('ced_bene'));
		fromRecepcionDocumento.add(botCerrarAsi);
		fromRecepcionDocumento.add(fromTotales);
		fromRecepcionDocumento.add(fromTotalDebHab);
		fromTotalDebHab.show();
		fromTotales.show();
		fromRecepcionDocumento.doLayout();
		AcumularTotalesContables();

	}

	function buscar_spg(numrecdoc,codtipdoc,codpro,cedbene)
	{
		var reDetSpg = Ext.data.Record.create([
		    {name: 'spg_cuenta'},
		    {name: 'numdoccom'},
		    {name: 'codestpro'},
		    {name: 'monto'},
		    {name: 'sc_cuenta'},
		    {name: 'procede_doc'},
		    {name: 'codfuefin'},
		    {name: 'estcla'},
		    {name: 'cargo'}
		]);
		
		obtenerMensaje('procesar','','Buscando Datos');
		//Buscar ordenes de compra
		var JSONObject = {
				'operacion'   : 'buscar_cuenta_presupuestaria',
				'numrecdoc'   : numrecdoc,  
				'codtipdoc'   : codtipdoc,
				'codpro'      : codpro,
				'cedbene'     : cedbene,
		}

		var ObjSon = JSON.stringify(JSONObject);
		var parametros = 'ObjSon='+ObjSon; 
		Ext.Ajax.request({
			url : '../../controlador/cxp/sigesp_ctr_cxp_recepcioncontable.php',
			params : parametros,
			method: 'POST',
			success: function ( resultado, request){
				Ext.Msg.hide();
				var resultado = resultado.responseText;
		  		var objDatos = eval('(' + resultado + ')');
		  		var datos = objDatos.raiz;
		  		if (objDatos != ""){
		  			var valor = Ext.util.Format.substr(Ext.getCmp('codtipdoc').getValue(),5,1);
					if(valor=='P' || valor=='N' || valor=='S'){
						fromRecepcionDocumento.add(gridDetPresupuestario);
						gridDetPresupuestario.show();
						fromRecepcionDocumento.doLayout();
						for(var j = 0; j < datos.length; j++){
			  				var detspgInt = new reDetSpg({
								'spg_cuenta' : datos[j].spg_cuenta,
						    	'numdoccom'  : datos[j].numdoccom,
						    	'codestpro'  : datos[j].codestpro,
						    	'monto'      : datos[j].monto,
						    	'sc_cuenta'  : datos[j].sc_cuenta,
						    	'procede_doc': datos[j].procede_doc,
						    	'codfuefin'  : datos[j].codfuefin,
						    	'estcla'     : datos[j].estcla,
						    	'cargo'      : datos[j].cargo,
							});	
							gridDetPresupuestario.store.insert(0,detspgInt);
						}
					}
					else{
						fromRecepcionDocumento.add(gridDetPresCompAmort);
						gridDetPresCompAmort.show();
						fromRecepcionDocumento.doLayout();
						for(var j = 0; j < datos.length; j++){
			  				var detspgInt = new reDetSpg({
								'spg_cuenta' : datos[j].spg_cuenta,
						    	'numdoccom'  : datos[j].numdoccom,
						    	'codestpro'  : datos[j].codestpro,
						    	'monto'      : datos[j].monto,
						    	'sc_cuenta'  : datos[j].sc_cuenta,
						    	'procede_doc': datos[j].procede_doc,
						    	'codfuefin'  : datos[j].codfuefin,
						    	'estcla'     : datos[j].estcla,
						    	'cargo'      : datos[j].cargo,
							});	
							gridDetPresCompAmort.store.insert(0,detspgInt);
						}
					}  
				}
			},
			failure: function ( result, request){ 
				Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
			}//fin del success
		});//fin del ajax request
	}

	function buscar_scg(numrecdoc,codtipdoc,codpro,cedbene)
	{
		var reDetScg = Ext.data.Record.create([
		    {name: 'numdoccom'},
		    {name: 'debhab'},
		    {name: 'sc_cuenta'},
		    {name: 'estatus'},
		    {name: 'procede_doc'},
		    {name: 'monto'}
		]);  
		
		obtenerMensaje('procesar','','Buscando Datos');
		//Buscar ordenes de compra
		var JSONObject = {
				'operacion'   : 'buscar_cuenta_contable',
				'numrecdoc'   : numrecdoc,  
				'codtipdoc'   : codtipdoc,
				'codpro'      : codpro,
				'cedbene'     : cedbene,
		}

		var ObjSon = JSON.stringify(JSONObject);
		var parametros = 'ObjSon='+ObjSon; 
		Ext.Ajax.request({
			url : '../../controlador/cxp/sigesp_ctr_cxp_recepcioncontable.php',
			params : parametros,
			method: 'POST',
			success: function ( resultado, request){
				Ext.Msg.hide();
				var resultado = resultado.responseText;
		  		var objDatos = eval('(' + resultado + ')');
		  		var datos = objDatos.raiz;
		  		if (objDatos != ""){
		  			for(var j = 0; j < datos.length; j++){
		  				var montoD='0,00';
		  				var montoH='0,00';
		  				if(datos[j].debhab=='D'){
		  					montoD=datos[j].monto;
		  				}
		  				else if(datos[j].debhab=='H'){
		  					montoH=datos[j].monto;
		  				}
		  				var detscgInt = new reDetScg({
					    	'numdoccom'  : datos[j].numdoccom,
					    	'debhab'     : datos[j].debhab,
					    	'montoD'     : montoD,
					    	'montoH'     : montoH,
					    	'sc_cuenta'  : datos[j].sc_cuenta,
					    	'procede_doc': datos[j].procede_doc,
					    	'estatus'    : datos[j].estatus,
						});	
		  				fromRecepcionDocumento.add(gridDetContables);
			  			gridDetContables.show();
						fromRecepcionDocumento.doLayout();
						gridDetContables.store.insert(0,detscgInt);
					}
				}
			},failure: function ( result, request){ 
				Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
			}//fin del success	
		});//fin del ajax request
	}
	
	function Aceptar_Solicitud(registro){
		var monto = 0;
		var reRecepcion = Ext.data.Record.create([
			{name: 'numrecdoc'},
			{name: 'codtipdoc'},
			{name: 'ced_bene'},
			{name: 'cod_pro'},
			{name: 'codcla'},
			{name: 'dencondoc'},
			{name: 'fecemidoc'},
			{name: 'fecregdoc'},
			{name: 'fecvendoc'},
			{name: 'montotdoc'},
			{name: 'numexprel'},
			{name: 'dentipdoc'},
		]); 
		for ( var int = 0; int < registro.length; int++) {
			var detalle = registro[int];
			monto+=parseFloat(ue_formato_operaciones(detalle.get('montotdoc')));
			if(validarExistenciaRegistroGrid(detalle,grid,'numrecdoc','numrecdoc',true)){
				var detRecepcion = new reRecepcion({
			    	'numrecdoc'  : detalle.get('numrecdoc'),
			    	'numexprel'  : detalle.get('numexprel'),
			    	'codtipdoc'  : detalle.get('codtipdoc'),
			    	'dentipdoc'  : detalle.get('dentipdoc'),
			    	'montotdoc'  : detalle.get('montotdoc')
				});
				grid.store.insert(0,detRecepcion);
			}
		}
		Ext.getCmp('monsol').setValue(formatoNumericoMostrar(monto,2,'.',',','','','-',''));

	}
	
	function MostrarEstatus(valor){
		if(valor=='0'){
			return 'No Aprobada';
		}
		else {
			return 'Aprobada';
		}
	}


}
