function Catalogoncnd(acum,catalogo)
{
	
	//componente catalogo de proveedores
	var reCatProv = Ext.data.Record.create([
	    {name: 'cod_pro'}, //campo obligatorio                             
	    {name: 'nompro'},  //campo obligatorio
	    {name: 'dirpro'},  //campo obligatorio
	    {name: 'rifpro'}   //campo obligatorio
	]);

	var comcampocatprov = new com.sigesp.vista.comCatalogoProveedor({
		idComponente:'spiprodos'+acum,
		reCatalogo: reCatProv,
		rutacontrolador:'../../controlador/rpc/sigesp_ctr_rpc_comcatproveedor.php',
		parametros: "ObjSon={'operacion': 'buscarProveedores'",
		soloCatalogo: true,
		arrSetCampo:[{campo:'catcodpro',valor:'cod_pro'},
		             {campo:'nombre',valor:'nompro'}],
		             numFiltroNoVacio: 1
	});

	//componente catalogo de beneficiarios
	var reCatBene = Ext.data.Record.create([
	    {name: 'ced_bene'}, //campo obligatorio                             
	    {name: 'nombene'},  //campo obligatorio
	    {name: 'apebene'},  //campo obligatorio
	    {name: 'dirbene'}   //campo obligatorio
	]);

	var comcampocatbene = new com.sigesp.vista.comCatalogoBeneficiario({
		idComponente:'spibendos'+acum,
		reCatalogo: reCatBene,
		rutacontrolador:'../../controlador/rpc/sigesp_ctr_rpc_comcatbeneficiario.php',
		parametros: "ObjSon={'operacion': 'buscarBeneficiarios'",
		soloCatalogo: true,
		arrSetCampo:[{campo:'catcodpro',valor:'ced_bene'},
		             {campo:'nombre',valor:'nombene'}],
		             numFiltroNoVacio: 1
	});

	//creando store para el combo destino
	var destinoProBen = [['Proveedor','P'],
	                     ['Beneficiario','B']]; 

	var stdestinoProBen = new Ext.data.SimpleStore({
		fields : [ 'etiqueta', 'valor' ],
		data : destinoProBen
	});
	//fin creando store para el combo destino 

	//creando objeto combo destino
	var cmbdestinoProBen = new Ext.form.ComboBox({
		store : stdestinoProBen,
		fieldLabel : 'Tipo ',
		labelSeparator : '',
		editable : false,
		displayField : 'etiqueta',
		valueField : 'valor',
		id : 'combodestino',
		binding:true,
		hiddenvalue:'',
		defaultvalue:'-',
		allowBlank:false,
		width:130,
		typeAhead: true,
		emptyText:'Seleccione',
		triggerAction:'all',
		forceselection:true,
		binding:true,
		mode:'local',
		listeners: {
			'select': function(valor){
				if(valor.getValue()=="P") {
					comcampocatprov.mostrarVentana();
				}
				else{
					comcampocatbene.mostrarVentana();
				}
			}
		}
	});

	//creando datastore y columnmodel para la grid de las solicitudes de pago
	var reSolicitud = Ext.data.Record.create([
	    {name: 'codemp'},
	    {name: 'numsol'},
	    {name: 'numrecdoc'},
	    {name: 'codtipdoc'},
	    {name: 'ced_bene'},
	    {name: 'cod_pro'},
	    {name: 'codope'},
	    {name: 'numdc'},
	    {name: 'desope'},
	    {name: 'fecope'},
	    {name: 'monto'},
	    {name: 'estnotadc'},
	    {name: 'estafe'},
	    {name: 'estapr'},
	    {name: 'codusuapr'},
	    {name: 'fecaprnc'},
	    {name: 'nombre'},
	]);

	
	var dsSolicitud =  new Ext.data.Store({
		reader: new Ext.data.JsonReader({root: 'raiz',id: "id"},reSolicitud)
	});

	var cmSolicitud = new Ext.grid.ColumnModel([
	     new Ext.grid.CheckboxSelectionModel(),
	    {header: "<CENTER>Nro. Nota</CENTER>", width: 60, align: 'center', sortable: true, dataIndex: 'numdc'},
	    {header: "<CENTER>Nro Orden <br> de Pago</CENTER>", width: 70, sortable: true, dataIndex: 'numsol'},
	    {header: "<CENTER>Nro de <br> Recepcion</CENTER>", width: 40, sortable: true, dataIndex: 'numrecdoc', align: 'center'},
	    {header: "<CENTER>Fecha</CENTER>", width: 40, align: 'right', sortable: true, dataIndex: 'fecope'},
		{header: "<CENTER>Proveedor</CENTER>", width: 40, align: 'right', sortable: true, dataIndex: 'cod_pro'},
		{header: "<CENTER>Beneficiario</CENTER>", width: 40, align: 'right', sortable: true, dataIndex: 'ced_bene'},
		{header: "<CENTER>Nombre</CENTER>", width: 40, align: 'right', sortable: true, dataIndex: 'nombre'},
		{header: "<CENTER>Tipo de <br> Nota</CENTER>", width: 40, align: 'right', sortable: true, dataIndex: 'codtipdoc'},
		{header: "<CENTER>Monto</CENTER>", type: 'float', width: 40, align: 'right', sortable: true, dataIndex: 'monto'},
		{header: "<CENTER>Descripcion</CENTER>", width: 40, align: 'right', sortable: true, dataIndex: 'desope'},
	]);
	//fin del datastore y columnmodel para la grid de solicitude de pago

	//creando grid para los detalles de solicitude de pago
	gridSolicitud = new Ext.grid.GridPanel({
		width:780,
		height:260,
		frame:true,
		title:"",
		style: 'position:absolute;left:15px;top:160px',
		autoScroll:true,
		border:true,
		ds: dsSolicitud,
		cm: cmSolicitud,
		stripeRows: true,
		sm:new Ext.grid.CheckboxSelectionModel(),
		viewConfig: {forceFit:true}
	});

	var	formVentanaCatalogo = new Ext.FormPanel({
		width: 830,
		height: 440,
		style: 'position:absolute;left:5px;top:10px',
		frame: true,
		autoScroll:false,
		items: [{
			xtype:"fieldset", 
			title:'Datos de la Solicitud',
			style: 'position:absolute;left:15px;top:5px',
			border:true,
			cls: 'fondo',
			width: 780,
			height: 150,
			items:[{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:10px',
				items: [{
					layout: "form",
					border: false,
					labelWidth: 110,
					items: [{
						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Nro. de Nota',
						id: 'numnota',									
						width: 170,
						autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '15', onkeypress: "return keyRestrict(event,'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789');"},
						changeCheck: function(){
							var textvalor = this.getValue();
							dsComprobante.filter('numsol',textvalor,true);
							if(String(textvalor) !== String(this.startValue)){
								this.fireEvent('change', this, textvalor, this.startValue);
							} 
						}, 
						initEvents: function(){
							AgregarKeyPress(this);
						}
					}]
				}]
			},
			{
     			layout: "column",
				border: false,
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:40px',
				items: [{
					layout: "form",
 					border: false,
 					labelWidth: 110,			
 					items: [{
 						xtype: 'textfield',
						labelSeparator :'',
						fieldLabel: 'Denominacion',
						id: 'denominacion',									
						width: 170,
						autoCreate: {tag: 'input', type: 'text', size: '100', autocomplete: 'off', maxlength: '15', onkeypress: "return keyRestrict(event,'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789');"},
						changeCheck: function(){
							var textvalor = this.getValue();
							dsComprobante.filter('numrecdoc',textvalor,true);
							if(String(textvalor) !== String(this.startValue)){
								this.fireEvent('change', this, textvalor, this.startValue);
							} 
						}, 
						initEvents: function(){
							AgregarKeyPress(this);
						}
 		    		}]
         		}]
       		},
			{
				layout: "column",
				defaults: {border: false},
				style: 'position:absolute;left:15px;top:70px',
				items: [{
					layout: "form",
					border: true,
					labelWidth: 110,
					items: [cmbdestinoProBen]

				},{
					layout: "form",
					border: false,
					labelWidth: 10,
					items: [{
						xtype: 'textfield',
						fieldLabel: '',
						labelSeparator :'',
						id: 'catcodpro',
						disabled:true,
						binding:true,
						hiddenvalue:'',
						defaultvalue:'----------',
						allowBlank:true,
						width: 130
					}]
				},{
	 				layout: "form",
	 				border: false,
	 				labelWidth: 10,
	 				items: [{	
	 					xtype: 'textfield',
						fieldLabel: '',
						labelSeparator :'',
						id: 'nombre',
						disabled:true,
						binding:true,
						hiddenvalue:'',
						defaultvalue:'----------',
						allowBlank:true,
						width: 300,
	 				}]
		 		}]
			},
			{
				layout:"column",
				defaults: {border: false},
				style: 'position:absolute;left:480px;top:10px',  //520/20
				border:false,
				items:[{
					layout:"form",
					border:false,
					labelWidth:80,
					items:[{
						xtype:"datefield",
						labelSeparator :'',
						fieldLabel:"Fecha Desde",
						name:'Fecha',
						id:'fecdesde',
						allowBlank:false,
						width:130,
						binding:true,
						defaultvalue:'1900-01-01',
						hiddenvalue:'',
						value: new Date().format('01-m-Y'),
						autoCreate: {tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789/');"}
					}]
				}]
			},
			{
				layout:"column",
				defaults: {border: false},
				style: 'position:absolute;left:480px;top:40px', //520/50
				border:false,
				items:[{
					layout:"form",
					border:false,
					labelWidth:80,
					items:[{
						xtype:"datefield",
						labelSeparator :'',
						fieldLabel:"Hasta",
						name:'Fecha',
						id:'fechasta',
						allowBlank:false,
						width:130,
						binding:true,
						defaultvalue:'1900-01-01',
						hiddenvalue:'',
						value: new Date().format('d-m-Y'),
						autoCreate: {tag: 'input', type: 'text', size: '10', autocomplete: 'off', maxlength: '10', onkeypress: "return keyRestrict(event,'0123456789/');"}
					}]
				}]
			},
			{
				layout:"column",
				defaults: {border: false},
				style: 'position:absolute;left:670px;top:100px', 
				border:false,
				items:[{
					layout:"form",
					border:false,
					items:[{
						xtype: 'button',
						fieldLabel: '',
						id: 'btagregar',
						text: 'Buscar',
						iconCls: 'menubuscar',
						handler: function(){
							if(Ext.getCmp('fecdesde').getValue().format('Y-m-d')<=Ext.getCmp('fechasta').getValue().format('Y-m-d')){
								obtenerMensaje('procesar','','Buscando Datos');
								//Buscar ordenes de compra
								var JSONObject = {
										'tipooperacion'    : 'buscar_ncnd',
										'numdc'       : Ext.getCmp('numnota').getValue(),
										'denominacion'       : Ext.getCmp('denominacion').getValue(),
										'tipo'         : Ext.getCmp('combodestino').getValue(),
										'codigodestino': Ext.getCmp('catcodpro').getValue(),
										'fecsoldes'    : Ext.getCmp('fecdesde').getValue().format('Y-m-d'),
										'fecsolhas'    : Ext.getCmp('fechasta').getValue().format('Y-m-d')
								}

								var ObjSon = JSON.stringify(JSONObject);
								var parametros = 'ObjSon='+ObjSon; 
								Ext.Ajax.request({
									url : '../../controlador/cxp/sigesp_ctr_cxp_ncnd.php',
									params : parametros,
									method: 'POST',
									success: function ( resultado, request){
										Ext.Msg.hide();
										var datos = resultado.responseText;
										var objCmp = eval('(' + datos + ')');
										if(objCmp!=''){
											if(objCmp!='0'){
												if(objCmp.raiz == null || objCmp.raiz ==''){
													Ext.MessageBox.show({
														title:'Advertencia',
														msg:'No existen datos para mostrar',
														buttons: Ext.Msg.OK,
														icon: Ext.MessageBox.WARNING
													});
													gridSolicitud.store.removeAll();
												}
												else{
													gridSolicitud.store.loadData(objCmp);
												}
											}
											else{
												Ext.MessageBox.show({
													title:'Advertencia',
													msg:'',
													buttons: Ext.Msg.OK,
													icon: Ext.MessageBox.WARNING
												});
											}
										}
									}//fin del success	
								});//fin del ajax request
							}
							else{
								Ext.MessageBox.show({
									title:'Mensaje',
									msg:'El rango de fechas no es correcto !!!',
									buttons: Ext.Msg.OK,
									icon: Ext.MessageBox.WARNING
								});
							}
						}
					}]
				}]
			}]
		},gridSolicitud]
	});

	var ventanaEstructura = new Ext.Window({
		width:850, 
		height:520,
		closable:false,
		border:false,
		modal: true,
		frame:true,
		title:"<H1 align='center'>Cat&#225;logo de Nota de Debito/Credito</H1>",
		items:[formVentanaCatalogo],
		buttons: [{
			text:'Aceptar',  
			handler: function(){
			var registro = gridSolicitud.getSelectionModel().getSelections();
			if (catalogo == 'reprelacionndnchas')
			{
				Ext.getCmp('solpagohas').setValue(registro[0].get('numsol'));
				gridSolicitud.destroy();
				ventanaEstructura.destroy();
			} else if (catalogo == 'reprelacionndncdes') {
				Ext.getCmp('solpagodes').setValue(registro[0].get('numsol'));
				gridSolicitud.destroy();
				ventanaEstructura.destroy();
			}else if (catalogo ==  'ncndhasta')
			{
				Ext.getCmp('ncndhasta').setValue(registro[0].get('numdc'));
				gridSolicitud.destroy();
				ventanaEstructura.destroy();
			}else if (catalogo == 'ncnddeste')
			{
				Ext.getCmp('ncnddesde').setValue(registro[0].get('numdc'));
				gridSolicitud.destroy();
				ventanaEstructura.destroy();
			}else{

				if(catalogo!=''){
//					
				}
				else{
					if(registro.length==1){
						Aceptar_Solicitud(registro[0]);
						gridSolicitud.destroy();
						ventanaEstructura.destroy();
					}
					else{
						alert('Debe Seleccionar solo un registro..!!');
					}
				}
			}
			}
		},{
	   		text: 'Salir',
   			handler:function(){
				ventanaEstructura.destroy();
   		    }
   		}]
	});

	ventanaEstructura.show();

	//function que setea los datos en el formulario principal
	function Aceptar_Solicitud(registro)
	{

				Actualizar=true;
				limpiarFormulario(formularioSolicitud);
				setDataFrom(formularioSolicitud,registro);
				if(registro.get('tipproben')=='B'){
					Ext.getCmp('cod_pro').setValue(registro.get('ced_bene'));
				}else
				{
				Ext.getCmp('nompro').setValue(registro.get('nombre'));
				buscar_recepciones(registro.get('numsol'));
				}
		
	}
	
	function buscar_recepciones(numsol)
	{
		var reRecepcion = Ext.data.Record.create([
		    {name: 'numdc'},
		    {name: 'numsol'},
		    {name: 'numrecdoc'},
		    {name: 'fecope'},
		    {name: 'ced_bene'},
		    {name: 'cod_pro'},
		    {name: 'codtipdoc'},
		    {name: 'monto'},
		    {name: 'desope'},
		]); 
		
		obtenerMensaje('procesar','','Buscando Datos');
		//Buscar ordenes de compra
		var JSONObject = {
				'operacion': 'buscar_recepciones',
				'numsol'   : numsol
		}

		var ObjSon = JSON.stringify(JSONObject);
		var parametros = 'ObjSon='+ObjSon; 
		Ext.Ajax.request({
			url : '../../controlador/cxp/sigesp_ctr_cxp_ncnd.php',
			params : parametros,
			method: 'POST',
			success: function ( resultado, request){
				Ext.Msg.hide();
				var resultado = resultado.responseText;
		  		var objDatos = eval('(' + resultado + ')');
		  		var datos = objDatos.raiz;
		  		if (objDatos != ""){
		  			if(typeof(grid) == 'object' && grid != null && typeof(txtTotal) == 'object' && txtTotal != null){
		  				formularioSolicitud.add(grid); 
			  			formularioSolicitud.add(txtTotal);
			  			grid.show();
			  			txtTotal.show();
						formularioSolicitud.doLayout();
		  			}
					var monto = 0;
					for(var j = 0; j < datos.length; j++){
						var detRecepcion = new reRecepcion({
					    	'numrecdoc'  : datos[j].numrecdoc,
					    	'numexprel'  : datos[j].numexprel,
					    	'codtipdoc'  : datos[j].codtipdoc,
					    	'dentipdoc'  : datos[j].dentipdoc,
					    	'montotdoc'  : datos[j].monto
						});
						if(validarExistenciaRegistroGrid(detRecepcion,grid,'numrecdoc','numrecdoc',true)){
							monto+=parseFloat(ue_formato_operaciones(datos[j].monto));
							grid.store.insert(0,detRecepcion);
						}
					}
					Ext.getCmp('monsol').setValue(formatoNumericoMostrar(monto,2,'.',',','','','-',''));
				}
			},
			failure: function ( result, request){ 
				Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
			}//fin del success
		});//fin del ajax request
	}
	
	function buscar_scg(numrecdoc,codtipdoc,codpro,cedbene)
	{
		var reDetScg = Ext.data.Record.create([
		    {name: 'numdoccom'},
		    {name: 'debhab'},
		    {name: 'sc_cuenta'},
		    {name: 'estatus'},
		    {name: 'procede_doc'},
		    {name: 'monto'}
		]);  
		
		obtenerMensaje('procesar','','Buscando Datos');
		//Buscar ordenes de compra
		var JSONObject = {
				'operacion'   : 'buscar_cuenta_contable',
				'numrecdoc'   : numrecdoc,  
				'codtipdoc'   : codtipdoc,
				'codpro'      : codpro,
				'cedbene'     : cedbene,
		}

		var ObjSon = JSON.stringify(JSONObject);
		var parametros = 'ObjSon='+ObjSon; 
		Ext.Ajax.request({
			url : '../../controlador/cxp/sigesp_ctr_cxp_recepcioncontable.php',
			params : parametros,
			method: 'POST',
			success: function ( resultado, request){
				Ext.Msg.hide();
				var resultado = resultado.responseText;
		  		var objDatos = eval('(' + resultado + ')');
		  		var datos = objDatos.raiz;
		  		if (objDatos != ""){
		  			for(var j = 0; j < datos.length; j++){
		  				var montoD='0,00';
		  				var montoH='0,00';
		  				if(datos[j].debhab=='D'){
		  					montoD=datos[j].monto;
		  				}
		  				else if(datos[j].debhab=='H'){
		  					montoH=datos[j].monto;
		  				}
		  				var detscgInt = new reDetScg({
					    	'numdoccom'  : datos[j].numdoccom,
					    	'debhab'     : datos[j].debhab,
					    	'montoD'     : montoD,
					    	'montoH'     : montoH,
					    	'sc_cuenta'  : datos[j].sc_cuenta,
					    	'procede_doc': datos[j].procede_doc,
					    	'estatus'    : datos[j].estatus,
						});	
		  				fromRecepcionDocumento.add(gridDetContables);
			  			gridDetContables.show();
						fromRecepcionDocumento.doLayout();
						gridDetContables.store.insert(0,detscgInt);
					}
				}
			},failure: function ( result, request){ 
				Ext.MessageBox.alert('Error', 'El Registro no pudo ser '+mensaje); 
			}//fin del success	
		});//fin del ajax request
	}
	
	function MostrarEstatus(valor){
		if(valor=='0'){
			return 'No Aprobada';
		}
		else {
			return 'Aprobada';
		}
	}
}