<?php
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//    REPORTE: Listado de Documentos
//  ORGANISMO: Ninguno en particular
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	session_start();   
	header("Pragma: public");
	header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
	header("Cache-Control: private",false);
	if(!array_key_exists("la_logusr",$_SESSION))
	{
		print "<script language=JavaScript>";
		print "close();";
		print "opener.document.form1.submit();";		
		print "</script>";		
	}

	//-----------------------------------------------------------------------------------------------------------------------------------
	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_print_encabezado_pagina($as_titulo,$io_pdf)
	{
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_encabezado_pagina
		//		   Access: private 
		//	    Arguments: as_titulo // Ttulo del Reporte
		//	    		   io_pdf // Instancia de objeto pdf
		//    Description: Funcion que imprime los encabezados por pgina
		//	   Creado Por: Ing. Yesenia Moreno / Ing. Luis Lang
		// Fecha Creacion: 11/03/2007
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
		$io_encabezado=$io_pdf->openObject();
		$io_pdf->saveState();
		$io_pdf->line(15,40,585,40);
        $io_pdf->Rectangle(15,700,570,60);
		$li_tm=$io_pdf->getTextWidth(11,$as_titulo);
		$tm=306-($li_tm/2);
		$io_pdf->addText($tm,730,11,$as_titulo); // Agregar el ttulo
		$io_pdf->addText(540,770,7,date("d/m/Y")); // Agregar la Fecha
		$io_pdf->addText(546,764,6,date("h:i a")); // Agregar la Hora
		// cuadro inferior
		$io_pdf->restoreState();
		$io_pdf->closeObject();
		$io_pdf->addObject($io_encabezado,'all');
	}// end function uf_print_encabezado_pagina
	//-----------------------------------------------------------------------------------------------------------------------------------

	//-----------------------------------------------------------------------------------------------------------------------------------
			
	function uf_print_detalle($la_data,$ai_i,$io_pdf)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_detalle
		//		   Access: private 
		//	    Arguments: la_data // arreglo de informacion
		//				   as_titcuentas // titulo de estructura presupuestaria
		//				   ai_i // total de registros
		//	    		   io_pdf // Instancia de objeto pdf
		//    Description: Funcion que imprime el detalle del reporte
		//	   Creado Por: Ing. Yesenia Moreno / Ing. Luis Lang
		// Fecha Creacion: 10/06/2007 
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
		$io_pdf->ezSetDy(-2);
		$la_datatit[1]=array('sig_cuenta'=>'<b>Cuenta Presupuestaria</b>','spgdenominacion'=>'<b>Denominacion</b>','sc_cuenta'=>'<b>Cuenta Contable</b>',
							  'scgdenominacion'=>'<b>Denominacion</b>');
		$la_columnas=array('sig_cuenta'=>'',
						   'spgdenominacion'=>'',
						   'sc_cuenta'=>'',
						   'scgdenominacion'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 9, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>1, // Mostrar Lneas
						 'shaded'=>2, // Sombra entre lneas
						 'width'=>540, // Ancho de la tabla
						 'maxWidth'=>540, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
				         'outerLineThickness'=>0.5,
						 'innerLineThickness' =>0.5,
						 'cols'=>array('sig_cuenta'=>array('justification'=>'center','width'=>100), // Justificacion y ancho de la columna
						 			   'spgdenominacion'=>array('justification'=>'center','width'=>185), // Justificacion y ancho de la columna
						 			   'sc_cuenta'=>array('justification'=>'center','width'=>100), // Justificacion y ancho de la columna
						 			   'scgdenominacion'=>array('justification'=>'center','width'=>185))); // Justificacion y ancho de la columna
		$io_pdf->ezTable($la_datatit,$la_columnas,'',$la_config);

		$la_columnas=array('sig_cuenta'=>'',
						   'spgdenominacion'=>'',
						   'sc_cuenta'=>'',
						   'scgdenominacion'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 9, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>1, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>540, // Ancho de la tabla
						 'maxWidth'=>540, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
				         'outerLineThickness'=>0.5,
						 'innerLineThickness' =>0.5,
						 'cols'=>array('sig_cuenta'=>array('justification'=>'left','width'=>100), // Justificacion y ancho de la columna
						 			   'spgdenominacion'=>array('justification'=>'left','width'=>185), // Justificacion y ancho de la columna
						 			   'sc_cuenta'=>array('justification'=>'left','width'=>100), // Justificacion y ancho de la columna
						 			   'scgdenominacion'=>array('justification'=>'left','width'=>185))); // Justificacion y ancho de la columna
		$io_pdf->ezTable($la_data,$la_columnas,'',$la_config);
		$la_datatot[1]=array('titulo'=>'<b>Total de Registros: </b>','total'=>$ai_i);
		$la_columnas=array('titulo'=>'<b>Factura</b>',
						   'total'=>'<b>Total</b>');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 9, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>1, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>540, // Ancho de la tabla
						 'maxWidth'=>540, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
				         'outerLineThickness'=>0.5,
						 'innerLineThickness' =>0.5,
						 'cols'=>array('titulo'=>array('justification'=>'right','width'=>385), // Justificacion y ancho de la columna
						 			   'total'=>array('justification'=>'left','width'=>185))); // Justificacion y ancho de la columna
		$io_pdf->ezTable($la_datatot,$la_columnas,'',$la_config);
	}// end function uf_print_detalle
	//-----------------------------------------------------------------------------------------------------------------------------------

	require_once("../../../base/librerias/php/ezpdf/class.ezpdf.php");
	require_once("sigesp_spg_class_report.php");
	$io_report=new sigesp_spg_class_report();   
	//----------------------------------------------------  Parmetros del encabezado  -----------------------------------------------
	$ls_titulo="<b>LISTADO DE CASAMIENTO PRESUPUESTARIO</b>";
	//--------------------------------------------------------------------------------------------------------------------------------
		$lb_valido=$io_report->uf_select_casamientos(); // Cargar el DS con los datos del reporte
		if($lb_valido==false) // Existe algn error o no hay registros
		{
			print("<script language=JavaScript>");
			print(" alert('No hay nada que Reportar');"); 
			print(" close();");
			print("</script>");
		}
		else  // Imprimimos el reporte
		{
			error_reporting(E_ALL);
			set_time_limit(1800);
			$io_pdf=new Cezpdf('LETTER','portrait'); // Instancia de la clase PDF
			$io_pdf->selectFont('../../../base/librerias/php/ezpdf/fonts/Helvetica.afm'); // Seleccionamos el tipo de letra
			$io_pdf->ezSetCmMargins(3.6,4.5,3,3); // Configuracion de los margenes en centmetros
			$io_pdf->ezStartPageNumbers(570,47,8,'','',1); // Insertar el nmero de pgina
			$li_totrow=$io_report->DS->getRowCount("sig_cuenta");
			for($li_i=1;$li_i<=$li_totrow;$li_i++)
			{
				$ls_spgcuenta=trim($io_report->DS->data["sig_cuenta"][$li_i]);
				$ls_spgdenominacion=$io_report->DS->data["spgdenominacion"][$li_i];
				$ls_scgcuenta=trim($io_report->DS->data["sc_cuenta"][$li_i]);
				$ls_scgdenominacion=$io_report->DS->data["scgdenominacion"][$li_i];
				$la_data[$li_i]=array('sig_cuenta'=>$ls_spgcuenta,'spgdenominacion'=>$ls_spgdenominacion,'sc_cuenta'=>$ls_scgcuenta,
									  'scgdenominacion'=>$ls_scgdenominacion);
			}
			uf_print_encabezado_pagina($ls_titulo,$io_pdf);
			uf_print_detalle($la_data,$li_totrow,$io_pdf);
		}
		if($lb_valido) // Si no ocurrio ningn error
		{
			$io_pdf->ezStopPageNumbers(1,1); // Detenemos la impresion de los nmeros de pgina
			$io_pdf->ezStream(); // Mostramos el reporte
		}
		else // Si hubo algn error
		{
			print("<script language=JavaScript>");
			print(" alert('Ocurrio un error al generar el reporte. Por favor intente de Nuevo');"); 
		    print(" close();");
			print("</script>");		
		}
?>