<?php
    session_start();   
	header("Pragma: public");
	header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
	header("Cache-Control: private",false);
	if(!array_key_exists("la_logusr",$_SESSION))
	{
		print "<script language=JavaScript>";
		print "close();";
		print "opener.document.form1.submit();";		
		print "</script>";		
	}
	//--------------------------------------------------------------------------------------------------------------------------------
	function uf_print_encabezado_pagina($as_titulo,$io_pdf)
	{
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_encabezadopagina
		//		   Access: private 
		//	    Arguments: as_titulo // Ttulo del Reporte
		//	    		   as_desnom // Descripcion de la nomina
		//	    		   as_periodo // Descripcion del Periodo
		//	    		   io_pdf // Instancia de objeto pdf
		//    Description: funcion que imprime los encabezados por pgina
		//	   Creado Por: Ing. Yozelin Barragan
		// Fecha Creacion: 16/07/2007 
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////		
		global $io_pdf;
		
		$io_encabezado=$io_pdf->openObject();		
		$io_pdf->saveState();		
		$io_pdf->addJpegFromFile('../../shared/imagebank/'.$_SESSION["ls_logo"],25,720,$_SESSION["ls_width"],$_SESSION["ls_height"]); // Agregar Logo
		$li_tm=$io_pdf->getTextWidth(10,$as_titulo);
		$tm=280-($li_tm/2);
		$io_pdf->addText($tm,730,12,"<b>".$as_titulo."</b>"); // Agregar el ttulo
		$io_pdf->addText(507,735,9,"Fecha: ".date("d/m/Y")); // Agregar la Fecha
		$io_pdf->addText(514,725,9,"Hora: ".date("h:i a")); // Agregar la hora
		$io_pdf->restoreState();
		$io_pdf->closeObject();
		$io_pdf->addObject($io_encabezado,'all');
	}// end function uf_print_encabezadopagina
	//--------------------------------------------------------------------------------------------------------------------------------	
	
	//--------------------------------------------------------------------------------------------------------------------------------
	function uf_print_listado($la_data,$io_pdf)
	{	 
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_detalle
		//		   Access: private 
		//	    Arguments: la_data // arreglo de informacion
		//	   			   io_pdf // Objeto PDF
		//    Description: funcion que imprime el detalle
		//	   Creado Por: Ing. Yozelin Barragan
		// Fecha Creacion: 16/07/2007 
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////				
		global $ls_bolivares;
		global $io_pdf;
		
		$la_columna=array('codigo'=>'<b>Codigo</b>',
						  'nombre'=>'<b>Nombre</b>',
						  'rifpro'=>'<b>R.I.F.</b>',
						  'telpro'=>'<b>Telefono</b>',
						  'monto'=>'<b>Monto Acumulado</b>',
						  'cantidad'=>'<b>Cantidad de Ordenes</b>');
						  
		$la_config=array('showHeadings'=>1, // Mostrar encabezados
						 'fontSize' => 8, // Tamao de Letras
						 'titleFontSize' => 10,  // Tamao de Letras de los ttulos
						 'showLines'=>1, // Mostrar Lneas						 
						 'width'=>700, // Ancho de la tabla
						 'maxWidth'=>700, // Ancho Mximo de la tabla
						 'xPos'=>310, // Orientacion de la tabla
						 'shaded'=>0, // Sombra entre lneas
						 'shadeCol2'=>array(0.9,0.9,0.9), // Color de la sombra
						 'cols'=>array('codigo'=>array('justification'=>'left','width'=>60), // Justificacion y ancho de la columna
						 			   'nombre'=>array('justification'=>'left','width'=>170), // Justificacion y ancho de la columna
									   'rifpro'=>array('justification'=>'left','width'=>75), // Justificacion y ancho de la columna
						 			   'telpro'=>array('justification'=>'left','width'=>100), // Justificacion y ancho de la columna
						 			   'monto'=>array('justification'=>'right','width'=>80),
   						 			   'cantidad'=>array('justification'=>'right','width'=>60))); // Justificacion y ancho de la columna
		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);
	}// end function uf_print_detalle
	//--------------------------------------------------------------------------------------------------------------------------------

	//--------------------------------------------------------------------------------------------------------------------------------
	function uf_print_pie_cabecera($ad_numreg,$ad_totmon,$io_pdf)
	{
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_cabecera
		//		   Access: private 
		//	    Arguments: as_codper // total de registros que va a tener el reporte
		//	    		   as_nomper // total de registros que va a tener el reporte
		//	    		   io_pdf // total de registros que va a tener el reporte
		//    Description: funcion que imprime la cabecera de cada pgina
		//	   Creado Por: Ing. Yozelin Barragan
		// Fecha Creacion: 16/07/2007 
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $ls_bolivares;
		global $io_pdf;
		
	    $io_pdf->ezSetDy(-10);
		$la_data=array(array('name'=>'<b>N de Registros:</b>'.$ad_numreg,
		                     'name1'=>'<b>Total '.$ls_bolivares.':</b> '.$ad_totmon));				
		$la_columna=array('name'=>'','name1'=>'');		
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 10, // Tamao de Letras
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'shadeCol2'=>array(0.9,0.9,0.9), // Color de la sombra
						 'xPos'=>310, // Orientacion de la tabla
						 'width'=>750, // Ancho de la tabla						 
						 'maxWidth'=>750, // Orientaci? de la tabla
						 'cols'=>array('name'=>array('justification'=>'left','width'=>250),      // Justificaci? y ancho de la columna
						 			   'name1'=>array('justification'=>'right','width'=>335))); // Ancho Mximo de la tabla
		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);	
	}// end function uf_print_cabecera
	//--------------------------------------------------------------------------------------------------------------------------------


	//-----------------------------------------------------  Instancia de las clases  ------------------------------------------------
	require_once("../../shared/class_folder/sigesp_include.php");
	require_once("../../shared/class_folder/class_sql.php");	
	require_once("../../shared/ezpdf/class.ezpdf.php");
	require_once("../../shared/class_folder/class_funciones.php");
	require_once("sigesp_soc_class_report.php");	
	require_once("../class_folder/class_funciones_soc.php");
	$in           = new sigesp_include();
	$con          = $in->uf_conectar();
	$io_sql       = new class_sql($con);	
	$io_funciones = new class_funciones();	
	$io_fun_soc   = new class_funciones_soc();
	$io_report    = new sigesp_soc_class_report($con);
	$ls_tiporeporte=$io_fun_soc->uf_obtenervalor_get("tiporeporte",0);
	$ls_bolivares="Bs.";
	if($ls_tiporeporte==1)
	{
		require_once("sigesp_soc_class_reportbsf.php");
		$io_report=new sigesp_soc_class_reportbsf();
		$ls_bolivares="Bs.F.";
	}
		
	//----------------------------------------------------  Inicializacion de variables  -----------------------------------------------
	$lb_valido=true;
	//----------------------------------------------------  Parmetros del encabezado    -----------------------------------------------
	$ls_titulo ="LISTADO DE LAS ORDENES DE COMPRAS";	
	//--------------------------------------------------  Parmetros para Filtar el Reporte  -----------------------------------------
	
	$ls_codprodes=$io_fun_soc->uf_obtenervalor_get("codprodes","");
	$ls_codprohas=$io_fun_soc->uf_obtenervalor_get("codprohas","");
	$ls_fecordcomdes=$io_fun_soc->uf_obtenervalor_get("fecordcomdes","");
	$ls_fecordcomhas=$io_fun_soc->uf_obtenervalor_get("fecordcomhas","");
	$ls_montot=$io_fun_soc->uf_obtenervalor_get("montot",0);

	$ls_codesp=$io_fun_soc->uf_obtenervalor_get("hidcodesp","");
	$ls_unitri=$io_fun_soc->uf_obtenervalor_get("unitri","");
	$ls_orden=$io_fun_soc->uf_obtenervalor_get("orden","");

	//--------------------------------------------------------------------------------------------------------------------------------
	$arrResultado = $io_report->uf_select_listado_orden_compra_proveedor($ls_codprodes,$ls_codprohas,$ls_fecordcomdes,$ls_fecordcomhas,
															$ls_montot,$ls_codesp,$ls_unitri,$ls_orden,$lb_valido);
	$rs_data = $arrResultado['rs_data'];
	$lb_valido = $arrResultado['lb_valido'];
	if($lb_valido==false) // Existe algn error o no hay registros
	{
		print("<script language=JavaScript>");
		print(" alert('No hay nada que Reportar');"); 
		print(" close();");
		print("</script>");
	}
	else // Imprimimos el reporte
	{
		$ls_descripcion="Genero el Reporte de Listado de Orden de Compra";
		$lb_valido=$io_fun_soc->uf_load_seguridad_reporte("SOC","sigesp_soc_r_orden_compra.php",$ls_descripcion);
		if($lb_valido)
		{
			$li_valoruni = 0;
			$li_valoruni = $io_report->uf_select_unidadtributaria($li_valoruni);
		}
		if($lb_valido)	
		{
			error_reporting(E_ALL);
			set_time_limit(1800);
			$io_pdf=new Cezpdf('LETTER','portrait'); // Instancia de la clase PDF
			$io_pdf->selectFont('../../shared/ezpdf/fonts/Helvetica.afm'); // Seleccionamos el tipo de letra
			$io_pdf->ezSetCmMargins(3.5,3,3,3); // Configuracion de los margenes en centmetros
			uf_print_encabezado_pagina($ls_titulo,$io_pdf); // Imprimimos el encabezado de la pgina
			$io_pdf->ezStartPageNumbers(578,47,9,'','',1); // Insertar el nmero de pgina
			$ldec_monto=0;
			$li_i=0;
			$li_valoruni=($li_valoruni*2500);
			$ls_montot = str_replace(".","",$ls_montot);
			$ls_montot = str_replace(",",".",$ls_montot);	
			$la_data="";
			while($row=$io_sql->fetch_row($rs_data))
			{
				$ls_codpro  = $row["cod_pro"];
				$ls_nompro  = $row["nompro"];
				$ls_rifpro  = $row["rifpro"];
				$ls_telpro  = $row["telpro"];
				$ls_montotal = $row["montot"];
				$ls_cantidad = $row["cantidad"];
				if($ls_montotal>=$ls_montot)
				{
					if($ls_unitri==1)
					{
						if($ls_montotal>=$li_valoruni)
						{
							$ldec_monto=$ldec_monto+$ls_montotal;
							$ls_montotal   = number_format($ls_montotal,2,",",".");	
							$ls_cantidad   = number_format($ls_cantidad,2,",",".");	
							$li_i=$li_i+1;
							$la_data[$li_i]= array('codigo'=>$ls_codpro,'nombre'=>$ls_nompro,'rifpro'=>$ls_rifpro,
													'telpro'=>$ls_telpro,'monto'=>$ls_montotal,'cantidad'=>$ls_cantidad);
						}
					}
					else
					{
						$ldec_monto=$ldec_monto+$ls_montotal;
						$ls_montotal   = number_format($ls_montotal,2,",",".");	
						$ls_cantidad   = number_format($ls_cantidad,2,",",".");	
						$li_i=$li_i+1;
						$la_data[$li_i]= array('codigo'=>$ls_codpro,'nombre'=>$ls_nompro,'rifpro'=>$ls_rifpro,
												'telpro'=>$ls_telpro,'monto'=>$ls_montotal,'cantidad'=>$ls_cantidad);
					}
				}
			
			}
			 if($la_data!="")
			 {
			    uf_print_listado($la_data,$io_pdf); // Imprimimos el detalle 		
				$ldec_monto  = number_format($ldec_monto,2,",",".");	
				uf_print_pie_cabecera($li_i,$ldec_monto,$io_pdf);		
				if($lb_valido) // Si no ocurrio ningn error
				{
					$io_pdf->ezStopPageNumbers(1,1); // Detenemos la impresion de los nmeros de pgina
					$io_pdf->ezStream(); // Mostramos el reporte
				}
				else  // Si hubo algn error
				{
					print("<script language=JavaScript>");
					print("alert('Ocurrio un error al generar el reporte. Intente de Nuevo');"); 
					print("close();");
					print("</script>");		
				}
				unset($io_pdf);
			}
			else
			{
				print("<script language=JavaScript>");
				print("alert('No hay nada que reportar');"); 
				print("close();");
				print("</script>");		
			}
			}
			else
			{
				print("<script language=JavaScript>");
				print("alert('No hay nada que reportar');"); 
				print("close();");
				print("</script>");		
			}				
		}	
		unset($io_report);
		unset($io_funciones);
?> 