<?php
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//    REPORTE: Formato de salida  de la Orden de Compra
//  ORGANISMO: Ninguno en particular
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    session_start();   
	header("Pragma: public");
	header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
	header("Cache-Control: private",false);
	if(!array_key_exists("la_logusr",$_SESSION))
	{
		print "<script language=JavaScript>";
		print "close();";
		print "opener.document.form1.submit();";		
		print "</script>";		
	}
	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_print_encabezado_pagina($as_estcondat,$as_numordcom,$ad_fecordcom,$as_coduniadm,$as_denuniadm, $as_codfuefin,
	                                   $as_denfuefin,$as_codigo,$as_nombre,$as_conordcom,$as_rifpro,$as_diaplacom,$as_dirpro,
									   $ls_forpagcom,$ld_perentdesde,$ld_perenthasta,$as_estcom,$io_pdf)
	{
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_encabezado_pagina
		//		   Access: private 
		//	    Arguments: as_estcondat  ---> tipo de la orden de compra
		//	    		   as_numordcom ---> numero de la orden de compra
		//	    		   ad_fecordcom ---> fecha de registro de la orden de compra
		//	    		   io_pdf // Instancia de objeto pdf
		//    Description: Funcion que imprime los encabezados por pgina
		//	   Creado Por: Ing. Yozelin Barragan
		// Fecha Creacion: 21/06/2007
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
		
		$io_encabezado=$io_pdf->openObject();
		$io_pdf->saveState();
		$io_pdf->setStrokeColor(0,0,0);
		$io_pdf->line(480,700,480,770);
		$io_pdf->line(480,735,585,735);
        $io_pdf->Rectangle(15,700,570,70);
		$io_pdf->addJpegFromFile('../../shared/imagebank/'.$_SESSION["ls_logo"],25,705,$_SESSION["ls_width"],$_SESSION["ls_height"]); // Agregar Logo

		$io_pdf->addText(485,740,8," <b>No. </b>".$as_numordcom); // Agregar el ttulo
		$io_pdf->addText(485,710,8,"<b>Fecha </b>".$ad_fecordcom); // Agregar el ttulo

		$io_pdf->restoreState();
		$io_pdf->closeObject();
		$io_pdf->addObject($io_encabezado,'all');
	}// end function uf_print_encabezado_pagina
	//-----------------------------------------------------------------------------------------------------------------------------------

	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_print_detalle($la_data,$la_dataoc,$io_pdf)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_detalle
		//		   Access: private 
		//	    Arguments: la_data ---> arreglo de informacion
		//	    		   io_pdf ---> Instancia de objeto pdf
		//    Description: funcion que imprime el detalle 
		//	   Creado Por: Ing. Yozelin Barragan
		// Fecha Creacion: 21/06/2007
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $ls_estmodest, $ls_bolivares;
		global $io_pdf;
		
		switch ($la_dataoc["estcom"])
			{
			case "0": // Deberian ir en letras(R) como estan en la sep y en cxp 
				$ls_estatus="REGISTRO";
				break;
				
			case "1":  //   Deberia ir  E
				if($ls_estapro==1)
				{
				$ls_estatus="EMITIDA (APROBADA)";
				}
				else
				{
					$ls_estatus="EMITIDA";
				}
				break;
						
			case "2": // DEBERIA IR P
				$ls_estatus="COMPROMETIDA(PROCESADA)";
				break;
					
			case "3": //DEBERIA IR A
				$ls_estatus="ANULADA";
				break;
				
			case "4": //DEBERIA IR ????
				$ls_estatus="ENTRADA COMPRA";
				break;
						
			case "5": //DEBERIA IR ????
				$ls_estatus="PRE-COMPROMETIDA";
				break;
					
			case "6": //DEBERIA IR ????
				$ls_estatus="PRE-COMPROMETIDA ANULADA";
				break;
				
			case "7": //DEBERIA IR ????
				$ls_estatus="SERVICIO RECIBIDO";
				break;

			}
		if($la_dataoc["estcondat"]=="B") 
		{
           	  $ls_titulo="Orden de Compra";	
		  $ls_titulo_grid="Bienes";
       		}
       		else
       		{
             	  $ls_titulo="Orden de Servicio";
		  $ls_titulo_grid="Servicios";
       		}
		
		$li_tm=$io_pdf->getTextWidth(14,$ls_titulo);
		$tm=296-($li_tm/2);
		$io_pdf->addText($tm,730,12,$ls_titulo); // Agregar el ttulo
		$io_pdf->addText($tm,710,9," <b>ESTATUS: </b>".$ls_estatus); // Agregar 

		$io_pdf->ezSetY(695);
		$la_datadet[1]=array('columna1'=>'<b>Proveedor</b>  '.$la_dataoc["nompro"].'<b>             Rif</b> '.$la_dataoc["rifpro"],
		                 'columna2'=>'<b>Direccion</b> '.$la_dataoc["dirpro"].'');
		$la_columna=array('columna1'=>'','columna2'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 8, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>1, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('columna1'=>array('justification'=>'left','width'=>250), // Justificacion y ancho de la columna
						 			   'columna2'=>array('justification'=>'left','width'=>320))); // Justificacion y ancho de la columna
		$io_pdf->ezTable($la_datadet,$la_columna,'',$la_config);
		unset($la_datadet);
		unset($la_columna);
		unset($la_config);
		
		$ls_uniadm=$la_dataoc["coduniadm"]."  -  ".$la_dataoc["denuniadm"];
		$la_datadet[1]=array('columna1'=>'<b>Unidad Ejecutora</b>    '.$ls_uniadm,'columna2'=>'<b>Forma de Pago</b>    '.$la_dataoc["forpagcom"]);
		$la_columnas=array('columna1'=>'','columna2'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 8, // Tamao de Letras
						 'titleFontSize' => 8,  // Tamao de Letras de los ttulos
						 'showLines'=>1, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('columna1'=>array('justification'=>'left','width'=>300), // Justificacion y ancho de la columna
						 			   'columna2'=>array('justification'=>'left','width'=>270))); // Justificacion y ancho de la columna
		$io_pdf->ezTable($la_datadet,$la_columnas,'',$la_config);
		unset($la_datadet);
		unset($la_columnas);
		unset($la_config);

		$ls_fuefin=$la_dataoc["codfuefin"]."  -  ".$la_dataoc["denfuefin"];
		$la_datadet[1]=array('columna1'=>'<b>Fuente Financiamiento</b>   '.$ls_fuefin,'columna2'=>'<b> Plazo de Entrega</b>    '.$la_dataoc["diaplacom"]);
		$la_columnas=array('columna1'=>'','columna2'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 8, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>1, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('columna1'=>array('justification'=>'left','width'=>300), // Justificacion y ancho de la columna
						 			   'columna2'=>array('justification'=>'left','width'=>270))); // Justificacion y ancho de la columna
		$io_pdf->ezTable($la_datadet,$la_columnas,'',$la_config);
		unset($la_datadet);
		unset($la_columnas);
		unset($la_config);
		
		$la_datadet[1]=array('columna1'=>'<b>Periodo de Entrega    Desde:</b> '.$la_dataoc["perentdesde"].'    <b>Hasta:</b> '.$la_dataoc["perenthasta"].'');
		$la_columnas=array('columna1'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 8, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>1, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('columna1'=>array('justification'=>'left','width'=>570))); // Justificacion y ancho de la columna
		$io_pdf->ezTable($la_datadet,$la_columnas,'',$la_config);
		unset($la_datadet);
		unset($la_columnas);
		unset($la_config);

		$la_datadet[1]=array('columna1'=>'<b>Concepto</b>         '.$la_dataoc["obscom"]);
		$la_columnas=array('columna1'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 8, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>1, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('columna1'=>array('justification'=>'left','width'=>570))); // Justificacion y ancho de la columna
		$io_pdf->ezTable($la_datadet,$la_columnas,'',$la_config);
		unset($la_datadet);
		unset($la_columnas);
		unset($la_config);
		if($ls_estmodest==1)
		{
			$ls_titulo_grid="Bienes";
		}
		else
		{
			$ls_titulo_grid="Servicios";
		}
		$io_pdf->ezSetDy(-10);
		$la_datatitulo[1]=array('columna1'=>'<b> Detalle de '.$ls_titulo_grid.'</b>');
		$la_columnas=array('columna1'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 8, // Tamao de Letras
						 'titleFontSize' => 8,  // Tamao de Letras de los ttulos
						 'showLines'=>1, // Mostrar Lneas
						 'shaded'=>2, // Sombra entre lneas
						 'width'=>575, // Ancho de la tabla
						 'maxWidth'=>575, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('columna1'=>array('justification'=>'center','width'=>570))); // Justificacion y ancho de la columna
		$io_pdf->ezTable($la_datatitulo,$la_columnas,'',$la_config);
		unset($la_datatitulo);
		unset($la_columnas);
		unset($la_config);
		$io_pdf->ezSetDy(-2);
		$la_columnas=array('codigo'=>'<b>Codigo</b>',
						   'denominacion'=>'<b>Denominacion</b>',
						   'cantidad'=>'<b>Cantidad</b>',
						   'unidad'=>'<b>Unidad</b>',
						   'cosuni'=>'<b>Costo '.$ls_bolivares.'</b>',
						   'baseimp'=>'<b>Sub-Total '.$ls_bolivares.'</b>',
						   'cargo'=>'<b>Cargo '.$ls_bolivares.'</b>',
						   'montot'=>'<b>Total '.$ls_bolivares.'</b>');
		$la_config=array('showHeadings'=>1, // Mostrar encabezados
						 'fontSize' => 6, // Tamao de Letras
						 'titleFontSize' => 6,  // Tamao de Letras de los ttulos
						 'showLines'=>1, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('codigo'=>array('justification'=>'center','width'=>97), // Justificacion y ancho de la columna
						 			   'denominacion'=>array('justification'=>'left','width'=>140), // Justificacion y ancho de la columna
						 			   'cantidad'=>array('justification'=>'right','width'=>50), // Justificacion y ancho de la columna
						 			   'unidad'=>array('justification'=>'center','width'=>50), // Justificacion y ancho de la columna
						 			   'cosuni'=>array('justification'=>'right','width'=>55), // Justificacion y ancho de la columna
						 			   'baseimp'=>array('justification'=>'right','width'=>65), // Justificacion y ancho de la columna
						 			   'cargo'=>array('justification'=>'right','width'=>50), // Justificacion y ancho de la columna
						 			   'montot'=>array('justification'=>'right','width'=>63))); // Justificacion y ancho de la columna
		$io_pdf->ezTable($la_data,$la_columnas,'',$la_config);
	}// end function uf_print_detalle
	//-----------------------------------------------------------------------------------------------------------------------------------

	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_print_detalle_cuentas($la_data,$io_pdf)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_detalle_cuentas
		//		   Access: private 
		//	    Arguments: la_data ---> arreglo de informacion
		//	    		   io_pdf ---> Instancia de objeto pdf
		//    Description: funcion que imprime el detalle por concepto
		//	   Creado Por: Ing. Yozelin Barragan
		// Fecha Creacion: 21/06/2007
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $ls_estmodest, $ls_bolivares;
		global $io_pdf;
		
		$io_pdf->ezSetDy(-5);
		if($ls_estmodest==1)
		{
			$ls_titulo="Estructura Presupuestaria";
		}
		else
		{
			$ls_titulo="Estructura Programatica";
		}
		$la_datatit[1]=array('titulo'=>'<b> Detalle de Presupuesto </b>');
		$la_columnas=array('titulo'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' =>8, // Tamao de Letras
						 'titleFontSize' => 8,  // Tamao de Letras de los ttulos
						 'showLines'=>1, // Mostrar Lneas
						 'shaded'=>2, // Sombra entre lneas
						 'width'=>540, // Ancho de la tabla
						 'maxWidth'=>540, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('titulo'=>array('justification'=>'center','width'=>570))); // Justificacion y ancho de la columna
		$io_pdf->ezTable($la_datatit,$la_columnas,'',$la_config);
		unset($la_datatit);
		unset($la_columnas);
		unset($la_config);
		$io_pdf->ezSetDy(-2);
		$la_columnas=array('codestpro'=>'<b>'.$ls_titulo.'</b>',
						   'cuenta'=>'<b>Cuenta</b>',
						   'denominacion'=>'<b>Denominacion</b>',
						   'monto'=>'<b>Total '.$ls_bolivares.'</b>');
		$la_config=array('showHeadings'=>1, // Mostrar encabezados
						 'fontSize' => 6, // Tamao de Letras
						 'titleFontSize' => 6,  // Tamao de Letras de los ttulos
						 'showLines'=>1, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('codestpro'=>array('justification'=>'center','width'=>170), // Justificacion y ancho de la columna
						 			   'cuenta'=>array('justification'=>'center','width'=>100), // Justificacion y ancho de la columna
						 			   'denominacio'=>array('justification'=>'center','width'=>200), // Justificacion y ancho de la columna
									   'monto'=>array('justification'=>'right','width'=>100))); // Justificacion y ancho de la columna
		$io_pdf->ezTable($la_data,$la_columnas,'',$la_config);
	}// end function uf_print_detalle
	//-----------------------------------------------------------------------------------------------------------------------------------
	
	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_print_piecabecera($li_subtot,$li_totcar,$li_montot,$ls_monlet,$io_pdf)
	{
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_piecabecera
		//		    Acess: private 
		//	    Arguments: li_subtot ---> Subtotal del articulo
		//	    		   li_totcar -->  Total cargos
		//	    		   li_montot  --> Monto total
		//	    		   ls_monlet   //Monto en letras
		//				   io_pdf   : Instancia de objeto pdf
		//    Description: funcion que imprime los totales
		//	   Creado Por: Ing. Yozelin Barragan
		// Fecha Creacion: 21/06/2007
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $ls_bolivares;
		global $io_pdf;
		
		$la_data[1]=array('titulo'=>'<b>Sub Total '.$ls_bolivares.'</b>','contenido'=>$li_subtot,);
		$la_columnas=array('titulo'=>'',
						   'contenido'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 8, // Tamao de Letras
						 'titleFontSize' => 8,  // Tamao de Letras de los ttulos
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'shadeCol'=>array((249/255),(249/255),(249/255)), // Color de la sombra
						 'shadeCol2'=>array((249/255),(249/255),(249/255)), // Color de la sombra
						 'width'=>540, // Ancho de la tabla
						 'maxWidth'=>540, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('titulo'=>array('justification'=>'right','width'=>450), // Justificacion y ancho de la columna
						 			   'contenido'=>array('justification'=>'right','width'=>120))); // Justificacion y ancho de la columna
		$io_pdf->ezTable($la_data,$la_columnas,'',$la_config);
		unset($la_data);
		unset($la_columnas);
		unset($la_config);
		$la_data[1]=array('titulo'=>'<b>Cargos '.$ls_bolivares.'</b>','contenido'=>$li_totcar,);
		$la_columnas=array('titulo'=>'',
						   'contenido'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 8, // Tamao de Letras
						 'titleFontSize' => 8,  // Tamao de Letras de los ttulos
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'shadeCol'=>array((249/255),(249/255),(249/255)), // Color de la sombra
						 'shadeCol2'=>array((249/255),(249/255),(249/255)), // Color de la sombra
						 'width'=>540, // Ancho de la tabla
						 'maxWidth'=>540, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('titulo'=>array('justification'=>'right','width'=>450), // Justificacion y ancho de la columna
						 			   'contenido'=>array('justification'=>'right','width'=>120))); // Justificacion y ancho de la columna
		$io_pdf->ezTable($la_data,$la_columnas,'',$la_config);
		unset($la_data);
		unset($la_columnas);
		unset($la_config);
		$la_data[1]=array('titulo'=>'<b>Total '.$ls_bolivares.'</b>','contenido'=>$li_montot,);
		$la_columnas=array('titulo'=>'',
						   'contenido'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 8, // Tamao de Letras
						 'titleFontSize' => 8,  // Tamao de Letras de los ttulos
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>540, // Ancho de la tabla
						 'maxWidth'=>540, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('titulo'=>array('justification'=>'right','width'=>450), // Justificacion y ancho de la columna
						 			   'contenido'=>array('justification'=>'right','width'=>120))); // Justificacion y ancho de la columna
		$io_pdf->ezTable($la_data,$la_columnas,'',$la_config);
		unset($la_data);
		unset($la_columnas);
		unset($la_config);
		$io_pdf->ezSetDy(-5);
		$la_data[1]=array('titulo'=>'<b> Son: '.$ls_monlet.'</b>');
		$la_columnas=array('titulo'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 8, // Tamao de Letras
						 'titleFontSize' => 8,  // Tamao de Letras de los ttulos
						 'showLines'=>1, // Mostrar Lneas
						 'shaded'=>1, // Sombra entre lneas
						 'width'=>540, // Ancho de la tabla
						 'maxWidth'=>540, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('titulo'=>array('justification'=>'center','width'=>570))); // Justificacion y ancho de la columna
		$io_pdf->ezTable($la_data,$la_columnas,'',$la_config);
		unset($la_data);
		unset($la_columnas);
		unset($la_config);


		// cuadro inferior
		// cuadro inferior
        	$io_pdf->Rectangle(15,63,570,90);
		$io_pdf->line(15,127,585,127); //HORIZONTAL	
		$io_pdf->line(15,100,585,100); //HORIZONTAL		
		$io_pdf->line(129,63,129,153);		
		$io_pdf->line(243,63,243,153);		
		$io_pdf->line(357,63,357,153);		
		$io_pdf->line(471,63,471,153);		
       	
		
		$io_pdf->addText(20,140,8,"REVISADO POR"); // Agregar el ttulo
		$io_pdf->addText(134,140,8,"AUTORIZADO POR"); // Agregar el ttulo
		$io_pdf->addText(248,140,8,"APROBADO POR"); // Agregar el ttulo
		$io_pdf->addText(362,140,8,"APROBADO POR"); // Agregar el ttulo
		$io_pdf->addText(476,140,8,"PROVEEDOR"); // Agregar el ttulo
		$io_pdf->addText(20,90,7,"Firma y Sello"); // Agregar el ttulo
		$io_pdf->addText(20,80,7,"Jefe de Division de Compras"); // Agregar el ttulo

		$io_pdf->addText(134,90,7,"Firma y Sello"); // Agregar el ttulo
		$io_pdf->addText(134,80,7,"Director(a) de Administracion"); // Agregar el ttulo

		$io_pdf->addText(248,90,7,"Firma y Sello"); // Agregar el ttulo
		$io_pdf->addText(248,80,7,"Director(a) General de"); // Agregar el ttulo
		$io_pdf->addText(248,70,7,"Planificacion y Presupuesto"); // Agregar el ttulo

		$io_pdf->addText(362,90,7,"Firma y Sello"); // Agregar el ttulo
		$io_pdf->addText(362,80,7,"Director(a) General de"); // Agregar el ttulo
		$io_pdf->addText(362,70,7,"Gestion Administrativa"); // Agregar el ttulo

		$io_pdf->addText(476,90,7,"Firma y Sello"); // Agregar el ttulo
		$io_pdf->addText(476,80,7,"Fecha"); // Agregar el ttulo
		$io_pdf->addText(15,50,7,"Fecha Impresion:"); // Agregar el ttulo
		$io_pdf->addText(70,50,7,date("d/m/Y")); // Agregar la Fecha
		$io_pdf->addText(107,50,7,date("h:i a")); // Agregar la Hora
	}
	//-----------------------------------------------------------------------------------------------------------------------------------
	
	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_print_piecabeceramonto_bsf($li_montotaux,$io_pdf)
	{
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_piecabecera
		//		    Acess: private 
		//	    Arguments: li_montotaux ---> Total de la Orden Bs.F.
		//				   io_pdf   : Instancia de objeto pdf
		//    Description: Funcion que imprime el total de la Orden de Compra en Bolivares Fuertes.
		//	   Creado Por: Ing. Luis Anibal Lang
		// Fecha Creacion: 25/09/2007
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
		
		$la_data[1]=array('titulo'=>'<b>Monto Bs.F.</b>','contenido'=>$li_montotaux,);
		$la_columnas=array('titulo'=>'',
						   'contenido'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 8, // Tamao de Letras
						 'titleFontSize' => 8,  // Tamao de Letras de los ttulos
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'shadeCol'=>array((249/255),(249/255),(249/255)), // Color de la sombra
						 'shadeCol2'=>array((249/255),(249/255),(249/255)), // Color de la sombra
						 'width'=>540, // Ancho de la tabla
						 'maxWidth'=>540, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('titulo'=>array('justification'=>'right','width'=>450), // Justificacion y ancho de la columna
						 			   'contenido'=>array('justification'=>'right','width'=>120))); // Justificacion y ancho de la columna
		$io_pdf->ezTable($la_data,$la_columnas,'',$la_config);
		unset($la_data);
		unset($la_columnas);
		unset($la_config);
	}
	//-----------------------------------------------------------------------------------------------------------------------------------
	//-----------------------------------------------------  Instancia de las clases  ------------------------------------------------
	require_once("../../shared/class_folder/sigesp_include.php");
	require_once("../../shared/class_folder/class_sql.php");	
	require_once("../../shared/ezpdf/class.ezpdf.php");
	require_once("../../shared/class_folder/class_funciones.php");
	require_once("sigesp_soc_class_report.php");	
	require_once("../class_folder/class_funciones_soc.php");
	$in           = new sigesp_include();
	$con          = $in->uf_conectar();
	$io_sql       = new class_sql($con);	
	$io_funciones = new class_funciones();	
	$io_fun_soc   = new class_funciones_soc();
	$io_report    = new sigesp_soc_class_report($con);
	$ls_estmodest = $_SESSION["la_empresa"]["estmodest"];

	//Instancio a la clase de conversion de numeros a letras.
	include("../../shared/class_folder/class_numero_a_letra.php");
	$numalet= new class_numero_a_letra();
	//imprime numero con los valore por defecto
	//cambia a minusculas
	$numalet->setMayusculas(1);
	//cambia a femenino
	$numalet->setGenero(1);
	//cambia moneda
	$numalet->setMoneda("Bolivares");
	//cambia prefijo
	$numalet->setPrefijo("***");
	//cambia sufijo
	$numalet->setSufijo("***");
	$ls_tiporeporte=$io_fun_soc->uf_obtenervalor_get("tiporeporte",1);
	$ls_bolivares="Bs.";
	if($ls_tiporeporte==1)
	{
		require_once("sigesp_soc_class_reportbsf.php");
		$io_report=new sigesp_soc_class_reportbsf();
		$ls_bolivares="Bs.F.";
		$numalet->setMoneda("Bolivares Fuerte");
	}
		
	//--------------------------------------------------  Parmetros para Filtar el Reporte  -----------------------------------------
	$ls_numordcom=$io_fun_soc->uf_obtenervalor_get("numordcom","");
	$ls_estcondat=$io_fun_soc->uf_obtenervalor_get("tipord","");
	//--------------------------------------------------------------------------------------------------------------------------------
	$lb_valido=true;
	$arrResultado= $io_report->uf_select_orden_imprimir($ls_numordcom,$ls_estcondat,$lb_valido); // Cargar los datos del reporte
	$rs_data= $arrResultado['rs_data'];
	$lb_valido = $arrResultado['lb_valido'];
	if($lb_valido==false) // Existe algn error o no hay registros
	{
		print("<script language=JavaScript>");
		print(" alert('No hay nada que Reportar');"); 
		print(" close();");
		print("</script>");
	}
	else  // Imprimimos el reporte
	{
		$ls_descripcion="Genero el Reporte de Orden de Compra";
		$lb_valido=$io_fun_soc->uf_load_seguridad_reporte("SOC","sigesp_soc_p_registro_orden_compra.php",$ls_descripcion);
		if($lb_valido)	
		{
			error_reporting(E_ALL);
			set_time_limit(1800);
			$io_pdf=new Cezpdf('LETTER','portrait'); // Instancia de la clase PDF
			$io_pdf->selectFont('../../shared/ezpdf/fonts/Helvetica.afm'); // Seleccionamos el tipo de letra
			$io_pdf->ezSetCmMargins(8.5,6,3,3); // Configuracion de los margenes en centmetros
			$io_pdf->ezStartPageNumbers(570,47,5,'','',1); // Insertar el nmero de pgina
			if ($row=$io_sql->fetch_row($rs_data))
			{
				$ls_numordcom=$row["numordcom"];
				$ls_estcondat=$row["estcondat"];
				$ls_coduniadm=$row["coduniadm"];
				$ls_denuniadm=$row["denuniadm"];
				$ls_codfuefin=$row["codfuefin"];
				$ls_denfuefin=$row["denfuefin"];
				$ls_diaplacom=$row["diaplacom"];
				$ls_forpagcom=$row["forpagcom"];
				$ls_codpro=$row["cod_pro"];
				$ls_nompro=$row["nompro"];
				$ls_rifpro=$row["rifpro"];
				$ls_dirpro=$row["dirpro"];
				$ld_fecordcom=$row["fecordcom"];
				$ls_obscom=$row["obscom"];
				$ld_monsubtot=$row["monsubtot"];
				$ld_monimp=$row["monimp"];
				$ld_montot=$row["montot"];
				$ld_perentdesde=$row["fechentdesde"];
				$ld_perenthasta=$row["fechenthasta"];
				$ls_estcom=$row["estcom"];
				$ld_perentdesde=$io_funciones->uf_convertirfecmostrar($ld_perentdesde);
				$ld_perenthasta=$io_funciones->uf_convertirfecmostrar($ld_perenthasta);
				if($ls_tiporeporte==0)
				{
					$ld_montotaux=$row["montotaux"];
					$ld_montotaux=number_format($ld_montotaux,2,",",".");
				}
				$numalet->setNumero($ld_montot);
				$ls_monto= $numalet->letra();
				$ld_montot=number_format($ld_montot,2,",",".");
				$ld_monsubtot=number_format($ld_monsubtot,2,",",".");
				$ld_monimp=number_format($ld_monimp,2,",",".");
				$ld_fecordcom=$io_funciones->uf_convertirfecmostrar($ld_fecordcom);
		 
				uf_print_encabezado_pagina($ls_estcondat,$ls_numordcom,$ld_fecordcom,$ls_coduniadm,$ls_denuniadm,
				                           $ls_codfuefin,$ls_denfuefin,$ls_codpro,$ls_nompro,$ls_obscom,$ls_rifpro,
										   $ls_diaplacom,$ls_dirpro,$ls_forpagcom,$ld_perentdesde,$ld_perenthasta,$ls_estcom,$io_pdf);
				$la_dataoc=array('coduniadm'=>$ls_coduniadm,'denuniadm'=>$ls_denuniadm,'codfuefin'=>$ls_codfuefin,'denfuefin'=>$ls_denfuefin,'codpro'=>$ls_codpro,'nompro'=>$ls_nompro,'obscom'=>$ls_obscom,'rifpro'=>$ls_rifpro,'diaplacom'=>$ls_diaplacom,'dirpro'=>$ls_dirpro,'forpagcom'=>$ls_forpagcom,'perentdesde'=>$ld_perentdesde,'perenthasta'=>$ld_perenthasta,'estcom'=>$ls_estcom,'estcondat'=>$ls_estcondat);
				/////DETALLE  DE  LA ORDEN DE COMPRA
			   $arrResultado = $io_report->uf_select_detalle_orden_imprimir($ls_numordcom,$ls_estcondat,$lb_valido);
			   $rs_datos = $arrResultado['rs_data'];
			   $lb_valido = $arrResultado['lb_valido'];
			   if ($lb_valido)
			   {
		     	 $li_totrows = $io_sql->num_rows($rs_datos);
				 if ($li_totrows>0)
				 {
				    $li_i = 0;
				    while($row=$io_sql->fetch_row($rs_datos))
					{
						$li_i=$li_i+1;
						$ls_codartser=$row["codartser"];
						$ls_denartser=$row["denartser"];
						if($ls_estcondat=="B")
						{
							$ls_unidad=$row["unidad"];
						}
						else
						{
							$ls_unidad="";
						}
						if($ls_unidad=="D")
						{
						   $ls_unidad="Detal";
						}
						elseif($ls_unidad=="M")
						{
						   $ls_unidad="Mayor";
						}
						$li_cantartser=$row["cantartser"];
						$ld_preartser=$row["preartser"];
						$ld_subtotartser=$row["montsubartser"];
						$ld_totartser=$row["monttotartser"];
						$ld_porimp=$row["porimp"];
						$ld_carartser=$ld_subtotartser*($ld_porimp/100);
						
						
						
						$li_cantartser=number_format($li_cantartser,2,",",".");
						$ld_preartser=number_format($ld_preartser,2,",",".");
						$ld_subtotartser=number_format($ld_subtotartser,2,",",".");
						$ld_totartser=number_format($ld_totartser,2,",",".");
						$ld_carartser=number_format($ld_carartser,2,",",".");
						$la_data[$li_i]=array('codigo'=>$ls_codartser,'denominacion'=>$ls_denartser,'cantidad'=>$li_cantartser,
											  'unidad'=>$ls_unidad,'cosuni'=>$ld_preartser,'baseimp'=>$ld_subtotartser,
											  'cargo'=>$ld_carartser,'montot'=>$ld_totartser);
					}
					uf_print_detalle($la_data,$la_dataoc,$io_pdf);
					unset($la_data);
				    /////DETALLE  DE  LAS  CUENTAS DE GASTOS DE LA ORDEN DE COMPRA
					$arrResultado=$io_report->uf_select_cuenta_gasto($ls_numordcom,$ls_estcondat,$lb_valido); 
					$rs_datos_cuenta = $arrResultado['rs_data'];
					$lb_valido = $arrResultado['lb_valido'];
					if($lb_valido)
					{
						 $li_totrows = $io_sql->num_rows($rs_datos_cuenta);
						 if ($li_totrows>0)
						 {
							$li_s = 0;
							while($row=$io_sql->fetch_row($rs_datos_cuenta))
							{
								$li_s=$li_s+1;
								$ls_codestpro1=trim($row["codestpro1"]);
								$ls_codestpro2=trim($row["codestpro2"]);
								$ls_codestpro3=trim($row["codestpro3"]);
								$ls_codestpro4=trim($row["codestpro4"]);
								$ls_codestpro5=trim($row["codestpro5"]);
								$ls_codestpro1 = substr($ls_codestpro1,-$_SESSION["la_empresa"]["loncodestpro1"]);
								$ls_codestpro2 = substr($ls_codestpro2,-$_SESSION["la_empresa"]["loncodestpro2"]);
								$ls_codestpro3 = substr($ls_codestpro3,-$_SESSION["la_empresa"]["loncodestpro3"]);
								$ls_codestpro4 = substr($ls_codestpro4,-$_SESSION["la_empresa"]["loncodestpro4"]);
								$ls_codestpro5 = substr($ls_codestpro5,-$_SESSION["la_empresa"]["loncodestpro5"]);
								$ls_spg_cuenta=$row["spg_cuenta"];
								$ld_monto=$row["monto"];
								$ld_monto=number_format($ld_monto,2,",",".");
								$ls_dencuenta="";
								$arrResultado = $io_report->uf_select_denominacionspg($ls_spg_cuenta,$ls_dencuenta);																																						
								$ls_dencuenta = $arrResultado['as_denominacion'];
								$lb_valido = $arrResultado['lb_valido'];
								if($ls_estmodest==1)
								{
									$ls_codestpro  = $ls_codestpro1.'-'.$ls_codestpro2.'-'.$ls_codestpro3;
								}
								else
								{
									$ls_codestpro = $ls_codestpro1.'-'.$ls_codestpro2.'-'.$ls_codestpro3.'-'.$ls_codestpro4.'-'.$ls_codestpro5;
								}
								$la_data[$li_s]=array('codestpro'=>$ls_codestpro,'denominacion'=>$ls_dencuenta,
													  'cuenta'=>$ls_spg_cuenta,'monto'=>$ld_monto);
							}	
							uf_print_detalle_cuentas($la_data,$io_pdf);
							unset($la_data);
						}
				     }
			      }
		       }
	     	}
		}
		uf_print_piecabecera($ld_monsubtot,$ld_monimp,$ld_montot,$ls_monto,$io_pdf);
	} 	  	 
	if($lb_valido) // Si no ocurrio ningn error
	{
		$io_pdf->ezStopPageNumbers(1,1); // Detenemos la impresion de los nmeros de pgina
		$io_pdf->ezNewPage();
		$io_pdf->ezSetCmMargins(8.5,1,3,3); // Configuracion de los margenes en centmetros
		if($ls_estcondat=="B") 
			{
			$ls_titulo="<b>CONDICIONES ORDEN DE COMPRA</b>";
		$condiciones=array('uno'=>'1.','c1'=>'Las partes intervinientes en la presente Orden de Compra son a) <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>, b) <b>EL PROVEEDOR</b>. Identificado al final del presente documento.',
		'dos'=>'2.',
		'c2'=>'<b>PERFECCIONAMIENTO DE LA ORDEN DE COMPRA:</b> Sin perjuicio de lo estipulado en las dems clusulas de este documento, se entiende que este se perfecciona por aceptacin expresa de <b>EL PROVEEDOR</b>. Se considera que la aceptacin expresa opera cuando: a) <b>EL PROVEEDOR</b>, el representante legal de <b>EL PROVEEDOR</b>, o uno de sus empleados, facultado para ello, firman una de las copias de esta Orden de Compra; b) </b>EL PROVEEDOR</b> as lo comunica por escrito al <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>,',
		'tres'=>'3.',
		'c3'=>'<b>MODIFICACIONES:</b> Las estipulaciones y especificaciones de esta Orden de Compra no podrn ser modificadas por <b>EL PROVEEDOR</b>, sin previo acuerdo escrito entre "Las Partes", en el cual se haga expresa referencia a esta orden y se especifiquen claramente los trminos de la modificacin <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>, en cualquier momento podr, mediante orden escrita, introducir modificaciones a este pedido. Si estos cambios hechos por el <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>, causan un aumento o disminucin de esta Orden de Compra, o en el tiempo requerido para cumplirla, se efectuar de mutuo acuerdo el ajuste proporcional y equitativo, segn sea el caso. A tales efectos el <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>, remitir por este concepto, comunicacin escrita al Proveedor en donde se expresen las modificaciones y el ajuste. Si dentro de los dos (2) das hbiles bancarios continuos siguientes a la recepcin de dicha comunicacin <b>EL PROVEEDOR</b> no realizara objeciones u observaciones a la misma, se entendiera que ha aceptado tcitamente las modificaciones y el reajuste establecido.',
		'cuatro'=>'4.',
		'c4'=>'<b>CONDICION RESOLUTORIA:</b> En caso de incumplimiento de alguna de las obligaciones asumidas en esta Orden de Compra por parte de <b>EL PROVEEDOR</b>, el <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b> tendr el derecho a optar por exigir el cumplimiento inmediato o la resolucin del mismo, sin necesidad de declaracin o modificacin judicial alguna, obligndose solo a comunicarlo a <b>EL PROVEEDOR</b> de manera inmediata. En el caso que el incumplimiento alegado se deba a causa extraa no imputable a <b>EL PROVEEDOR</b>, este deber probarlo suficientemente. El <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b> estar en libertad de considerar o no los argumentos presentados por <b>EL PROVEEDOR</b> y podr optar por la contratacin de otro proveedor si as lo desea.',
		'cinco'=>'5.',
		'c5'=>'<b>PRORROGA:</b> Si el Proveedor no cumple con su obligacin de entregar los bienes en la fecha estipulada, libera a el <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b> de sus obligaciones correlativas. En tal caso el <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b> estar en libertad de prorrogar o no la presente Orden de Compra y de recibir o devolver los bienes, siendo a cargo del Proveedor los costos de la devolucin. Toda solicitud de prrroga del presente documento deber constar por escrito con la firma de Las Partes y la misma deber realizarse previo al vencimiento de la presente Orden. Asimismo, si los bienes indicados en esta no son entregados en la fecha prevista y a satisfaccin del <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>, este ltimo queda en libertad de contratar con otro proveedor si as lo desea.',
		'seis'=>'6.',
		'c6'=>'<b>GARANTIAS DE PRODUCTOS:</b> si por efecto de la ejecucin de esta Orden de Compra a <b>EL PROVEEDOR</b> le corresponde suministrar bienes de distinta naturaleza, este garantiza que dichas mercancas son de buena calidad, nuevos, libres de defectos en cuanto a diseo, confeccin, y se encuentran en perfectas condiciones de uso y que el material y proceso de fabricacin se han cumplido las condiciones de idoneidad en consideracin a los fines que cumplirn dichos artculos, segn las exigencias de calidad y especificaciones establecidas por el <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>. Asimismo, la prestacin del servicio deber cumplir segn las exigencias de calidad y especificaciones establecidas por el <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>.',
		'seisa'=>'',
		'c6a'=>'Si se comprueba que es defectuoso en cuanto al material empleado, al montaje o a la confeccin bajo condiciones de uso normal previsto, <b>EL PROVEEDOR</b>, har los arreglos necesarios',
		'seisb'=>'',
		'c6b'=>'para reemplazar el material defectuoso por uno nuevo, asumiendo <b>EL PROVEEDOR</b> los costos de dicho reemplazo. Asimismo, cuando a juicio del <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b> cualquier artculo que contenga materiales o confeccin defectuosa podr ser rechazado. En tal caso, todos los costos de transporte de ida y regreso, y los riesgos del mismo sern por cuenta y cargo de <b>EL PROVEEDOR</b>, para este efecto el <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b> formulara el reclamo a ms tardar dentro de los diez (10) das continuos siguiente a la entrega.',
		'seisc'=>'                             7.                                            8.',
		'c6c'=>'<b>PARRAFO UNICO:</b> La garanta y responsabilidad a que se refiere la presente clausula tendr una duracin de   90 dias  , expedida por los fabricantes del material contra defectos de fabricacin y mano de obra, la cual se har efectiva a partir de la entrega de los bienes.                                                                                                                   <b>TITULO DE PROPIEDAD Y POSESIN: EL PROVEEDOR</b> garantiza plenamente que tiene derecho legtimo de propiedad y posesin sobre los bienes que suministra por concepto de esta Orden de Compra y por lo tanto tiene pleno derecho a venderlos, garantiza, adems, que sobre ellos no existe gravamen alguno, embrago o secuestro ni reclamaciones legales y que saldr el saneamiento conforme a la Ley.
                                                                                                              <b>EMBARQUE - EMPAQUES:</b> El embarque y traslado de los bienes a ser suministrado deber hacerse en los trminos convenidos entre "Las Partes". <b>EL PROVEEDOR</b> se compromete a emplear empaques y/o embalajes adecuados y de buena calidad, en consideracin a la clase del bien, a fin de garantizar su llegada a',
		'siete'=>'                         9.',
		'c7'=>'destino en perfectas condiciones y asumiendo la responsabilidad por cualquier deterioro que tenga por causa de un empaque defectuoso o traslado inadecuado.                                                                                                                                                      <b>PRECIOS, PATENTES, NORMAS DE SEGURIDAD: EL PROVEEDOR</b> garantiza: a) que los precios que figuran en esta Orden de Compra son los comerciantes suministrados por <b>EL PROVEEDOR</b> y que no violan ninguna regulacin sobre precios mximos y que estos precios no sern aumentados en ninguna forma, ni agregados recargos y otras sumas de ninguna clase; b) que los bienes comprados no violan ningn derecho de propiedad industrial de terceros y que ampara completamente  al <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b> en relacin con cualquier reclamo',
		'ocho'=>'                      10.',
		'c8'=>'que pudiere sufrir este como resultado de una posible violacin en este sentido; c) que los bienes cumplen a cabalidad las normas de seguridad prescritas oficialmente.                                                                                                                                                                  <b>CONDICIONES DE PAGO:</b> Entre las partes, se pondr convenir entregas parciales o totales de los bienes adquiridos a travs de esta Orden de Compra, y el <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b> podr efectuar los pagos correspondientes a ellos, previa presentacin de la conformacin de recepcin de dichos bienes a satisfaccin del <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>. Sin embargo con el consentimiento expreso del <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b> se pondrn estipular anticipos siempre que <b>EL PROVEEDOR</b> consigne un Fianza de Anticipo a favor del',
		'nueve'=>'',
		'c9'=>'<b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b> por el ciento por ciento 100% del monto entregado por concepto de anticipo, incluyendo el Impuesto al Valor Agregado (I.V.A), otorgada por una Institucin Financiera o empresa aseguradora domiciliada en el pas debidamente autorizada por la Superintendencia de las Instituciones del Sector Bancario o la Superintendencia de la Actividad Aseguradora, la cual debe contener las condiciones generales del contrato de fianza con Organismos del Estado, de conformidad con la Providencia N FSAA-001618 del 30 de mayo de 2012.                                                                                                                                                                                                                   Para una oportuna tramitacin del pago, se deber entregar al <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b> factura original,',
		'diez'=>'',
		'c10'=>'la cual debe cumplir con todos y cada uno de los requisitos y normas que al efecto establezca el Servicio Nacional Integrado de Administracin Aduanera y Tributaria (SENIAT) a los fines de su aceptacin. Que expresamente entendido por <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>, y <b>EL PROVEEDOR</b>, que la omisin de alguno de los requisitos ser motivo de devolucin de la factura, sin que ello genere ningn tipo de retardo o mora en el pago en contra del <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>.',
		'once'=>'11.',
		'c11'=>'<b>INDEMNIZACIONES:</b> Cualquier indemnizacin y/o reembolso que deba <b>EL PROVEEDOR</b> al <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b> segn esta Orden de Compra, podrn ser deducidas del monto que el <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b> adeude a <b>EL PROVEEDOR</b> por cualquier concepto y sin prejuicio del derecho de ejercer las acciones legales correspondientes a su sola discrecin. 

Si para la fecha prevista no se ha dado cumplimiento al objeto de la presente Orden de Compra, <b>EL PROVEEDOR</b> pagara como indemnizacin convencional por los daos y perjuicios que la demora cause, el diez por ciento (10%) del monto total de la presente orden, cuando el retraso sea menor a quince (15) das continuos, y si es mayor una penalidad equivalente al veinticinco por ciento (25%) del monto total de la presente Orden. Lo adecuado por la indemnizacin antes descrita, ser compensado de lo que el <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b> adeude a <b>EL PROVEEDOR</b> por la presente Orden de Compra.',
		'doce'=>'12.',
		'c12'=>'<b>INCUMPLIMIENTO DE PAGO:</b> En caso de incumplimiento de pago por parte del <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>, <b>EL PROVEEDOR</b> podr exigir adems de las cantidades adeudas, los intereses moratorios legales que produzcan hasta la fecha del pago definitivo.',
		'trece'=>'13.',
		'c13'=>'<b>RESCISION UNILATERAL:</b> En caso de rescisin unilateral de la Orden de Compra sin causa justificada por parte del <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>  y antes que el proveedor realice la entrega de los bienes, aquella se obliga a pagar treinta por ciento (30%) del precio no facturado hasta el momento de la resolucin de la presente Orden, bajo ninguna circunstancia el <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>  podr rescindir esta Orden de Compra de forma unilateral una vez que <b>EL PROVEEDOR</b> haya completado la entrega de los bienes en las condiciones establecidas.',
		'catorce'=>'14.',
		'c14'=>'<b>OBRLIGACIONES LABORALES Y ANTE TERCEROS: EL PROVEEDOR</b> se obliga, en su condicin de patrono, a asumir por su exclusiva cuenta y bajo su sola responsabilidad y propias expresas, las obligaciones derivadas de las leyes laborales. As como en sus relaciones con sus dependientes o contratantes. ',
		'quince'=>'15.',
		'c15'=>'<b>CESION Y SUBCONTRATACION: EL PROVEEDOR</b> no podr ceder bajo ninguna circunstancia, los crditos, derechos y obligaciones derivados de la presente Orden de Compra,',
		'dieciseis'=>'16.',
		'c16'=>'<b>FIANZA DEL FIEL CUMPLIMIENTO:</b> en caso de ser exigida por el <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b> para garantizar el fiel y oportuno cumplimiento de todas las obligaciones que asume <b>EL PROVEEDOR</b> por la presente Orden, durante su vigencia y hasta su terminacin, incluyendo sus prorrogas si las hubiere, este, deber presentar fianza de fiel cumplimiento a favor del <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b> y a su satisfaccin, por una cantidad equivalente al veinte por ciento (20%) del total de monto de la Orden de Compra, la cual incluir el Impuesto al Valor Agregado (I.V.A) el cual deber ejecutarse antes del cierre administrativo de este contrato.',
		'diecisiete'=>'17.',
		'c17'=>'<b>COMPROMISO DE RESPONSABILIDAD SOCIAL:</b> Cuando el monto de contratacin supere las Dos Mil Quinientas Unidades Tributarias (2.500UT), <b>EL PROVEEDOR</b> se obliga a cumplir con el compromiso de responsabilidad social de conformidad con lo establecido en los artculos 30 y 31 del Decreto de Rango Valor y Fuerza de Ley de Contrataciones Pblicas, el cual se ejecutara a travs de un proyecto de desarrollo o aporte social equivalente a tres por ciento (3%) del precio total previsto en la presente Orden ',
		'diecisietea'=>'                                18.',
		'c17a'=>'de Compra, sin considerar la cuta correspondiente al Impuesto del Valor Agregado (I.V.A) el cual deber ejecutarse antes del cierre administrativo de este contrato.

		<b>RIESGO:</b> El proveedor asume todos los riesgos que por cualquier causa pudieran afectar los bienes hasta su entrega a satisfaccin del <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>',
		'diecinueve'=>'  19.                            20.',
		'c19'=>'<b>CONFIDENCIALIDAD:</b> El proveedor reconoce expresamente la confidencialidad de la informacin suministrada por el <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b> y se obliga a no divulgarla.

		<b>DOMICILIO:</b> Para todos los efectos y derivados de la presente orden, las partes eligen como domicilio especial a la ciudad de Caracas, a la jurisdiccin de cuyos tribunales declaran someterse.





		___________________________                                                 FIRMA POR LA CONTRATISTA:                                                     NOMBRE Y APELLIDO:                                                                    C.I.:                                                                                                    NOMBRE DE LA EMPRESA:',
		'c20'=>'___________________________                                                 FIRMA POR EL FNSC:                                                     DIRECTOR DE ADMINISTRACION:                                                  C.I.: V-9.483.342',
		'c21'=>'___________________________                                                 FIRMA POR EL FNSC:                                                     DIRECTORA GENERAL OFICINA DE GESTIN ADMINISTRATIVA VIANESSI DEL VALLE HERNANDEZ CABEZA                                C.I.: V-17.464.707');
		$io_pdf->ezSetY(695);
		$li_tm=$io_pdf->getTextWidth(14,$ls_titulo);
		$tm=296-($li_tm/2);
		$io_pdf->addText($tm,730,12,$ls_titulo); // Agregar el ttulo

		$la_data[1]=array('columna1'=>$condiciones["uno"],'columna2'=>$condiciones["c1"],'columna3'=>'','columna4'=>$condiciones["c6a"]);
		$la_columna=array('columna1'=>'','columna2'=>'','columna3'=>'','columna4'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 8, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('columna1'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna2'=>array('justification'=>'left','width'=>255), // Justificacion y ancho de la columna
						 		  'columna3'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna4'=>array('justification'=>'left','width'=>255))); // Justificacion y ancho de la columna
							
		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);
		unset($la_data);
		unset($la_columna);
		unset($la_config);

		$la_data[1]=array('columna1'=>$condiciones["dos"],'columna2'=>$condiciones["c2"],'columna3'=>'','columna4'=>$condiciones["c6b"]);
		$la_columna=array('columna1'=>'','columna2'=>'','columna3'=>'','columna4'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 8, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('columna1'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna2'=>array('justification'=>'left','width'=>255), // Justificacion y ancho de la columna
						 		  'columna3'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna4'=>array('justification'=>'left','width'=>255))); // Justificacion y ancho de la columna
							
		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);
		unset($la_data);
		unset($la_columna);
		unset($la_config);

		$la_data[1]=array('columna1'=>$condiciones["tres"],'columna2'=>$condiciones["c3"],'columna3'=>$condiciones["seisc"],'columna4'=>$condiciones["c6c"]);
		$la_columna=array('columna1'=>'','columna2'=>'','columna3'=>'','columna4'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 8, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('columna1'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna2'=>array('justification'=>'left','width'=>255), // Justificacion y ancho de la columna
						 		  'columna3'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna4'=>array('justification'=>'left','width'=>255))); // Justificacion y ancho de la columna
							
		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);
		unset($la_data);
		unset($la_columna);
		unset($la_config);

		$la_data[1]=array('columna1'=>$condiciones["cuatro"],'columna2'=>$condiciones["c4"],'columna3'=>$condiciones["siete"],'columna4'=>$condiciones["c7"]);
		$la_columna=array('columna1'=>'','columna2'=>'','columna3'=>'','columna4'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 8, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('columna1'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna2'=>array('justification'=>'left','width'=>255), // Justificacion y ancho de la columna
						 		  'columna3'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna4'=>array('justification'=>'left','width'=>255))); // Justificacion y ancho de la columna
							
		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);
		unset($la_data);
		unset($la_columna);
		unset($la_config);

		$la_data[1]=array('columna1'=>$condiciones["cinco"],'columna2'=>$condiciones["c5"],'columna3'=>$condiciones["ocho"],'columna4'=>$condiciones["c8"]);
		$la_columna=array('columna1'=>'','columna2'=>'','columna3'=>'','columna4'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 8, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('columna1'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna2'=>array('justification'=>'left','width'=>255), // Justificacion y ancho de la columna
						 		  'columna3'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna4'=>array('justification'=>'left','width'=>255))); // Justificacion y ancho de la columna
							
		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);
		unset($la_data);
		unset($la_columna);
		unset($la_config);

		$la_data[1]=array('columna1'=>$condiciones["seis"],'columna2'=>$condiciones["c6"],'columna3'=>'','columna4'=>$condiciones["c9"]);
		$la_columna=array('columna1'=>'','columna2'=>'','columna3'=>'','columna4'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 8, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('columna1'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna2'=>array('justification'=>'left','width'=>255), // Justificacion y ancho de la columna
						 		  'columna3'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna4'=>array('justification'=>'left','width'=>255))); // Justificacion y ancho de la columna
							
		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);
		unset($la_data);
		unset($la_columna);
		unset($la_config);

		$io_pdf->ezNewPage();
		$io_pdf->ezSetCmMargins(8.5,1,3,3); // Configuracion de los margenes en centmetros
		$io_pdf->ezSetY(695);
		$li_tm=$io_pdf->getTextWidth(14,$ls_titulo);
		$tm=296-($li_tm/2);
		$io_pdf->addText($tm,730,12,$ls_titulo); // Agregar el ttulo

		$la_data[1]=array('columna1'=>'','columna2'=>$condiciones["c10"],'columna3'=>$condiciones["diecisietea"],'columna4'=>$condiciones["c17a"]);
		$la_columna=array('columna1'=>'','columna2'=>'','columna3'=>'','columna4'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 8, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('columna1'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna2'=>array('justification'=>'left','width'=>255), // Justificacion y ancho de la columna
						 		  'columna3'=>array('justification'=>'right','width'=>30), // Justificacion y ancho de la columna
						 		  'columna4'=>array('justification'=>'left','width'=>250))); // Justificacion y ancho de la columna
							
		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);
		unset($la_data);
		unset($la_columna);
		unset($la_config);

		$la_data[1]=array('columna1'=>$condiciones["once"],'columna2'=>$condiciones["c11"],'columna3'=>$condiciones["diecinueve"],'columna4'=>$condiciones["c19"]);
		$la_columna=array('columna1'=>'','columna2'=>'','columna3'=>'','columna4'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 8, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('columna1'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna2'=>array('justification'=>'left','width'=>255), // Justificacion y ancho de la columna
						 		  'columna3'=>array('justification'=>'right','width'=>30), // Justificacion y ancho de la columna
						 		  'columna4'=>array('justification'=>'left','width'=>250))); // Justificacion y ancho de la columna
							
		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);
		unset($la_data);
		unset($la_columna);
		unset($la_config);

		$la_data[1]=array('columna1'=>$condiciones["doce"],'columna2'=>$condiciones["c12"],'columna3'=>'','columna4'=>'');
		$la_columna=array('columna1'=>'','columna2'=>'','columna3'=>'','columna4'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 8, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('columna1'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna2'=>array('justification'=>'left','width'=>255), // Justificacion y ancho de la columna
						 		  'columna3'=>array('justification'=>'right','width'=>30), // Justificacion y ancho de la columna
						 		  'columna4'=>array('justification'=>'left','width'=>250))); // Justificacion y ancho de la columna
							
		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);
		unset($la_data);
		unset($la_columna);
		unset($la_config);

		$la_data[1]=array('columna1'=>$condiciones["trece"],'columna2'=>$condiciones["c13"],'columna3'=>'','columna4'=>$condiciones["c20"]);
		$la_columna=array('columna1'=>'','columna2'=>'','columna3'=>'','columna4'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 8, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('columna1'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna2'=>array('justification'=>'left','width'=>255), // Justificacion y ancho de la columna
						 		  'columna3'=>array('justification'=>'right','width'=>30), // Justificacion y ancho de la columna
						 		  'columna4'=>array('justification'=>'left','width'=>250))); // Justificacion y ancho de la columna
							
		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);
		unset($la_data);
		unset($la_columna);
		unset($la_config);

		$la_data[1]=array('columna1'=>$condiciones["catorce"],'columna2'=>$condiciones["c14"],'columna3'=>'','columna4'=>$condiciones["c21"]);
		$la_columna=array('columna1'=>'','columna2'=>'','columna3'=>'','columna4'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 8, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('columna1'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna2'=>array('justification'=>'left','width'=>255), // Justificacion y ancho de la columna
						 		  'columna3'=>array('justification'=>'right','width'=>30), // Justificacion y ancho de la columna
						 		  'columna4'=>array('justification'=>'left','width'=>250))); // Justificacion y ancho de la columna
							
		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);
		unset($la_data);
		unset($la_columna);
		unset($la_config);

		$la_data[1]=array('columna1'=>$condiciones["quince"],'columna2'=>$condiciones["c15"],'columna3'=>'','columna4'=>'');
		$la_columna=array('columna1'=>'','columna2'=>'','columna3'=>'','columna4'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 8, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('columna1'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna2'=>array('justification'=>'left','width'=>255), // Justificacion y ancho de la columna
						 		  'columna3'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna4'=>array('justification'=>'left','width'=>255))); // Justificacion y ancho de la columna
							
		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);
		unset($la_data);
		unset($la_columna);
		unset($la_config);

		$la_data[1]=array('columna1'=>$condiciones["dieciseis"],'columna2'=>$condiciones["c16"],'columna3'=>'','columna4'=>'');
		$la_columna=array('columna1'=>'','columna2'=>'','columna3'=>'','columna4'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 8, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('columna1'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna2'=>array('justification'=>'left','width'=>255), // Justificacion y ancho de la columna
						 		  'columna3'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna4'=>array('justification'=>'left','width'=>255))); // Justificacion y ancho de la columna
							
		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);
		unset($la_data);
		unset($la_columna);
		unset($la_config);

		$la_data[1]=array('columna1'=>$condiciones["diecisiete"],'columna2'=>$condiciones["c17"],'columna3'=>'','columna4'=>'');
		$la_columna=array('columna1'=>'','columna2'=>'','columna3'=>'','columna4'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 8, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('columna1'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna2'=>array('justification'=>'left','width'=>255), // Justificacion y ancho de la columna
						 		  'columna3'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna4'=>array('justification'=>'left','width'=>255))); // Justificacion y ancho de la columna
							
		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);
		unset($la_data);
		unset($la_columna);
		unset($la_config);

			}
		else
			{
			$ls_titulo="<b>CONDICIONES ORDEN DE SERVICIO</b>";
		$condiciones=array('intro'=>'Las partes intervinientes en la presente Orden de Servicio son a) <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>, b) <b>EL PROVEEDOR</b>. Identificado al final del presente documento.',
		'uno'=>'1.',
		'c1'=>'<b>PERFECCIONAMIENTO DE LA ORDEN DE SERVICIO:</b> Sin perjuicio de lo estipulado en las dems clusulas de este documento, se entiende que este se perfecciona por aceptacin expresa de <b>EL PROVEEDOR</b>. Se considera que la aceptacin expresa opera cuando: a) <b>EL PROVEEDOR</b>, el representante legal de <b>EL PROVEEDOR</b>, o uno de sus empleados, facultado para ello, firman una de las copias de esta Orden de Servicio; b) </b>EL PROVEEDOR</b> as lo comunica por escrito al <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>,',
		'dos'=>'2.',
		'c2'=>'<b>MODIFICACIONES:</b> Las estipulaciones y especificaciones de esta Orden de Servicio no podrn ser modificadas por <b>EL PROVEEDOR</b>, sin previo acuerdo escrito entre Las Partes, en el cual se haga expresa referencia a esta orden y se especifiquen claramente los trminos de la modificacin <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>,, en cualquier momento podr, mediante orden escrita, introducir modificaciones a este pedido. Si estos cambios hechos por el <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>, causan un aumento o disminucin de esta Orden de Servicio, o en el tiempo requerido para cumplirla, se efectuar de mutuo acuerdo el ajuste proporcional y equitativo, segn sea el caso. A tales efectos el <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>, remitir por este concepto, comunicacin escrita al Proveedor en donde se expresen las modificaciones y el ajuste. Si dentro de los dos (2) das hbiles bancarios continuos siguientes a la recepcin de dicha comunicacin <b>EL PROVEEDOR</b> no realizara objeciones u observaciones a la misma, se entendiera que ha aceptado tcitamente las modificaciones y el reajuste establecido.',
		'tres'=>'3.',
		'c3'=>'<b>CONDICION RESOLUTORIA:</b> En caso de incumplimiento de alguna de las obligaciones asumidas en esta Orden de Servicio por parte de <b>EL PROVEEDOR</b>, el <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>, tendr el derecho a optar por exigir el cumplimiento inmediato o la resolucin del mismo, sin necesidad de declaracin o notificacin judicial alguna, obligndose solo a comunicarlo a <b>EL PROVEEDOR</b> de manera inmediata. En el caso que el incumplimiento alegado se deba a causa extraa no imputable a <b>EL PROVEEDOR</b>, este deber probarlo suficientemente. Si el <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>, opta por la resolucin de esta orden por causa justificada <b>EL PROVEEDOR</b> deber pagarle el equivalente al treinta por ciento (30%) del precio no facturado hasta el momento de la resolucin de esta Orden de Servicio, basado en los montos estipulados en la presente Orden, ms los intereses moratorios legales que produzcan hasta la fecha del pago definitivo.',
		'cuatro'=>'4.',
		'c4'=>'<b>PRORROGA:</b> Si el Proveedor no cumple con su obligacin de cumplir los servicios en la fecha estipulada, libera a el <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>, de sus obligaciones correlativas. En tal caso el <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>, estar en libertad de prorrogar o no la presente Orden, siendo a cargo del Proveedor los costos que se deriven. Toda solicitud de prrroga de la presente Orden de Servicio deber constar por escrito con la firma de Las Partes y la misma deber realizarse previo al vencimiento de la presente Orden. Asimismo, si los servicios indicados en esta no son finalizados en la fecha prevista y a satisfaccin del <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>, este ltimo queda en libertad de contratar con otro proveedor si as lo desea.',
		'cinco'=>'5.',
		'c5'=>'<b>GARANTIAS DE PRODUCTOS:</b> si por efecto de la ejecucin de esta Orden de Servicio a <b>EL PROVEEDOR</b> le corresponde suministrar bienes de distinta naturaleza, este garantiza que dichas mercancas son de buena calidad, nuevos, libres de defectos en cuanto a diseo, confeccin, y se encuentran en perfectas condiciones de uso y que el material y proceso de fabricacin se han cumplido las condiciones de idoneidad en consideracin a los fines que cumplirn dichos artculos, segn las exigencias de calidad y especificaciones establecidas por el <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>,',
		'cincoa'=>'',
		'c5a'=>'Asimismo, la prestacin del servicio deber cumplir segn las exigencias de calidad y especificaciones establecidas por el <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>,',
		'cincob'=>'',
		'c5b'=>'Si se comprueba que es defectuoso en cuanto al material empleado, al montaje o a la confeccin bajo condiciones de uso normal previsto, <b>EL PROVEEDOR</b>, har los arreglos necesarios para reemplazar el material defectuoso por uno nuevo, asumiendo <b>EL PROVEEDOR</b> los costos de dicho reemplazo. Asimismo, cuando a juicio del <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>, cualquier artculo que contenga materiales o confeccin defectuosa podr ser rechazado. En tal caso, todos los costos de transporte de ida y regreso, y los riesgos del mismo sern por cuenta y cargo', 
		'cincoc'=>'                                                     6.',
		'c5c'=>'de <b>EL PROVEEDOR</b>, para este efecto el <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>, formulara el reclamo a ms tardar dentro de los diez (10) das continuos siguiente a la entrega.                                                                                                                                      <b>PARRAFO UNICO:</b> La garanta y responsabilidad a que se refiere la presente clausula tendr una duracin de         , expedida por los fabricantes del material contra defectos de fabricacin y mano de obra, la cual se har efectiva a partir de la entrega de los bienes.
		                                                                                                           <b>CONDICIONES DE PAGO:</b> Entre las partes, se podr convenir entregas parciales o totales de los bienes adquiridos a travs de esta Orden de Servicio, y <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>, podr efectuar los pagos correspondientes a ellos, previa presentacin de la conformacin de recepcin de dichos bienes a satisfaccin de <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>,  Sin embargo con el consentimiento expreso del <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>, se pondrn estipular anticipos siempre que <b>EL PROVEEDOR</b> consigne una Fianza de Anticipo a favor del',
		'seis'=>'6.',
		'c6'=>'<b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>, por el ciento por ciento 100% del monto entregado por concepto de anticipo, incluyendo el impuesto  al Valor Agregado (I.V.A), otorgada por una institucin Financiera o empresa aseguradora domiciliada en el pas debidamente autorizada por la Superintendencia de las Instituciones del Sector Bancario o la Superintendencia de la Actividad Aseguradora, la cual debe contener las condiciones generales del contrato de fianza con Organismos del Estado, de conformidad con la Providencia N FSAA-001618 del 30 de mayo de 2012.
		                                                                                                           Para una oportuna tramitacin del pago, se deber entregar al <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>, factura original, la cual debe cumplir con todos y cada uno de los requisitos y normas que al efecto establezca el Servicio Nacional Integrado de Administracin Aduanera y Tributaria (SENIAT) a los fines de su',
		'siete'=>'                                      7.',
		'c7'=>'aceptacin. Que expresamente entendido por el <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>, y <b>EL PROVEEDOR</b>, que la omisin de alguno de los requisitos ser motivo de devolucin de la factura, sin que ello genere ningn tipo de retardo o mora en el pago en contra del <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>,
		                                                                                                 <b>INDEMNIZACIONES:</b> Cualquier indemnizacin y/o reembolso que deba <b>EL PROVEEDOR</b> al <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>, segn esta Orden de Servicio, podrn ser deducidas del monto que el <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>, adeude a <b>EL PROVEEDOR</b> por cualquier concepto y sin prejuicio del derecho de ejercer las acciones legales correspondientes a su sola discrecin.',
		'sietea'=>'',
		'c7a'=>'Si para la fecha prevista no se ha dado cumplimiento al objeto de la presente Orden de Servicio <b>EL PROVEEDOR</b> pagara como indemnizacin convencional por los daos y perjuicios que la demora cause, el diez por ciento (10%) del monto total de la presente orden, cuando el retraso sea menor a quince (15) das continuos, y si es mayor una penalidad equivalente al veinticinco por ciento (25%) del monto total de la presente Orden. Lo adecuado por la indemnizacin antes descrita, ser compensado de lo que el <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>, adeude a <b>EL PROVEEDOR</b> por la presente Orden de Servicio.',
		'ocho'=>'8.',
		'c8'=>'<b>INCUMPLIMIENTO DE PAGO:</b> En caso de incumplimiento de pago por parte del <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>, <b>EL PROVEEDOR</b> podr exigir adems de las cantidades adeudas, los intereses moratorios legales que produzcan hasta la fecha del pago definitivo.',
		'nueve'=>'9.',
		'c9'=>'<b>OBRLIGACIONES LABORALES Y ANTE TERCEROS:</b> <b>EL PROVEEDOR</b> se obliga, en su condicin de patrono, a asumir por su exclusiva cuenta y bajo su sola responsabilidad y propias expresas, las obligaciones derivadas de las leyes laborales. As como en sus relaciones con sus dependientes o contratantes.',
		'diez'=>'10.',
		'c10'=>'<b>CESION Y SUBCONTRATACION:</b> <b>EL PROVEEDOR</b> no podr ceder bajo ninguna circunstancia, los crditos, derechos y obligaciones derivados de la presente Orden de Servicio,',
		'once'=>'11.',
		'c11'=>'<b>FIANZA DEL DIEL CUMPLIMIENTO:</b> en caso de ser exigida por el <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>, para garantizar el fiel y oportuno cumplimiento de todas las obligaciones que asume <b>EL PROVEEDOR</b> por la presente Orden, durante su vigencia y hasta su terminacin, incluyendo sus prorrogas si las hubiere, este, deber presentar fianza de fiel cumplimiento a favor del <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>,  y a su satisfaccin, por una cantidad equivalente al veinte por ciento (20%) del total de monto de la Orden de Servicio, la cual incluir el Impuesto al Valor Agregado (I.V.A) el cual deber ejecutarse antes del cierre administrativo de este contrato.',
		'doce'=>'12.',
		'c12'=>'<b>COMPROMISO DE RESPONSABILIDAD SOCIAL:</b> Cuando el monto de contratacin supere las Dos Mil Quinientas Unidades Tributarias (2.500UT), <b>EL PROVEEDOR</b> se obliga a cumplir con el compromiso de responsabilidad social de conformidad con lo establecido en los artculos 30 y 31 del Decreto de Rango Valor y Fuerza de Ley de Contrataciones Pblicas, el cual se ejecutara a travs de un proyecto de desarrollo o aporte social equivalente a tres por ciento (3%) del precio total previsto en la presente Orden de Servicio, sin considerar la cuta correspondiente al Impuesto del Valor Agregado (I.V.A) el cual deber ejecutarse antes del cierre administrativo de este contrato.',
		'trece'=>'13.',
		'c13'=>'<b>RIESGO:</b> El proveedor reconoce expresamente la conformidad de la informacin suministrada por el <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>,',
		'catorce'=>'14.',
		'c14'=>'<b>CONFIDENCIALIDAD:</b> El proveedor reconoce expresamente la conformidad de la informacin suministrada por el <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>, y se obliga a no divulgarla, <b>EL PROVEEDOR</b> reconoce que la informacin confidencial que sea revelada por el <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>,  con ocasin de la ejecucin de la Orden de Servicio, ser considerada en todo momento como propiedad del <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>, por tal razn se obliga a mantenerla como confidencial durante un periodo de tres (3) aos contados a partir de la fecha de revelacin, independientemente de la vigencia de la presente Orden de Servicio. Igualmente, deber guardar, manipular y mantener con absoluta discrecin dicha informacin confidencial por el mismo plazo, por lo tanto, no podrn en ningn momento: 1) distribuir o relevar todo o parte de la informacin confidencial por cualquier medio; 2) Permitir a terceros accesos a dicha informacin confidencial; Utilizar la informacin confidencial para cualquier propsito distinto al objeto de la presente Orden de Servicio o a lo acordado previamente por escrito. En caso de que <b>EL PROVEEDOR</b> recibiera una orden emanada de un tribunal, un requerimiento de alguna autoridad competente para revelar todo o parte de la informacin confidencial del <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>, o bien tenga que hacer del conocimiento dicha informacin en cumplimiento de disposiciones legales, deber notificarlo previamente al <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>, por ser esta la propietaria de la informacin. En ningn caso <b>EL PROVEEDOR</b> podr subrogarse en la obligacin de entrega de la informacin que pudiese corresponder al <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>,',
		'catorcea'=>'',
		'c14a'=>'Las obligaciones de conformidad conforme a esta Orden de Servicio aplicaran al <b>FUNDACIN NIO SIMN DE CARACAS (FNSC)</b>, respecto de informacin de naturaleza confidencial de <b>EL PROVEEDOR</b> con ocasin de los servicios prestados.',
		'quince'=>'15.',
		'c15'=>'<b>DOMICILIO:</b> Para todos los efectos y derivados de la presente orden, las partes eligen como domicilio especial a la ciudad de Caracas, a la jurisdiccin de cuyos tribunales declaran someterse.',
		'dieciseis'=>'___________________________                                                 FIRMA POR LA CONTRATISTA:                                                         NOMBRE Y APELLIDO:                                                                      C.I.:                                                                                                    NOMBRE DE LA EMPRESA:                                                              No. DE RIF:                                                                                        FECHA:',
		'diecisiete'=>'___________________________                                                 FIRMA POR EL FNSC:                                                                DIRECTOR DE ADMINISTRACION:                                               C.I.: V- 9.483.342',
		'dieciocho'=>'___________________________                                                 FIRMA POR EL FNSC:                                                     DIRECTORA GENERAL OFICINA DE GESTIN ADMINISTRATIVA VIANESSI DEL VALLE HERNANDEZ CABEZA                                C.I.: V-17.464.707');
		$io_pdf->ezSetY(695);
		$li_tm=$io_pdf->getTextWidth(14,$ls_titulo);
		$tm=296-($li_tm/2);
		$io_pdf->addText($tm,730,12,$ls_titulo); // Agregar el ttulo

		$la_data[1]=array('columna1'=>'','columna2'=>$condiciones["intro"],'columna3'=>'','columna4'=>$condiciones["c5a"]);
		$la_columna=array('columna1'=>'','columna2'=>'','columna3'=>'','columna4'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 8, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('columna1'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna2'=>array('justification'=>'left','width'=>255), // Justificacion y ancho de la columna
						 		  'columna3'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna4'=>array('justification'=>'left','width'=>255))); // Justificacion y ancho de la columna
							
		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);
		unset($la_data);
		unset($la_columna);
		unset($la_config);

		$la_data[1]=array('columna1'=>$condiciones["uno"],'columna2'=>$condiciones["c1"],'columna3'=>'','columna4'=>$condiciones["c5b"]);
		$la_columna=array('columna1'=>'','columna2'=>'','columna3'=>'','columna4'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 8, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('columna1'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna2'=>array('justification'=>'left','width'=>255), // Justificacion y ancho de la columna
						 		  'columna3'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna4'=>array('justification'=>'left','width'=>255))); // Justificacion y ancho de la columna
							
		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);
		unset($la_data);
		unset($la_columna);
		unset($la_config);

		$la_data[1]=array('columna1'=>$condiciones["dos"],'columna2'=>$condiciones["c2"],'columna3'=>$condiciones["cincoc"],'columna4'=>$condiciones["c5c"]);
		$la_columna=array('columna1'=>'','columna2'=>'','columna3'=>'','columna4'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 8, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('columna1'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna2'=>array('justification'=>'left','width'=>255), // Justificacion y ancho de la columna
						 		  'columna3'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna4'=>array('justification'=>'left','width'=>255))); // Justificacion y ancho de la columna
							
		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);
		unset($la_data);
		unset($la_columna);
		unset($la_config);

		$la_data[1]=array('columna1'=>$condiciones["tres"],'columna2'=>$condiciones["c3"],'columna3'=>'','columna4'=>$condiciones["c6"]);
		$la_columna=array('columna1'=>'','columna2'=>'','columna3'=>'','columna4'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 8, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('columna1'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna2'=>array('justification'=>'left','width'=>255), // Justificacion y ancho de la columna
						 		  'columna3'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna4'=>array('justification'=>'left','width'=>255))); // Justificacion y ancho de la columna
							
		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);
		unset($la_data);
		unset($la_columna);
		unset($la_config);

		$la_data[1]=array('columna1'=>$condiciones["cuatro"],'columna2'=>$condiciones["c4"],'columna3'=>$condiciones["siete"],'columna4'=>$condiciones["c7"]);
		$la_columna=array('columna1'=>'','columna2'=>'','columna3'=>'','columna4'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 8, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('columna1'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna2'=>array('justification'=>'left','width'=>255), // Justificacion y ancho de la columna
						 		  'columna3'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna4'=>array('justification'=>'left','width'=>255))); // Justificacion y ancho de la columna
							
		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);
		unset($la_data);
		unset($la_columna);
		unset($la_config);

		$la_data[1]=array('columna1'=>$condiciones["cinco"],'columna2'=>$condiciones["c5"],'columna3'=>'','columna4'=>$condiciones["c7a"]);
		$la_columna=array('columna1'=>'','columna2'=>'','columna3'=>'','columna4'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 8, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('columna1'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna2'=>array('justification'=>'left','width'=>255), // Justificacion y ancho de la columna
						 		  'columna3'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna4'=>array('justification'=>'left','width'=>255))); // Justificacion y ancho de la columna
							
		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);
		unset($la_data);
		unset($la_columna);
		unset($la_config);

		$io_pdf->ezNewPage();
		$io_pdf->ezSetCmMargins(8.5,1,3,3); // Configuracion de los margenes en centmetros
		$io_pdf->ezSetY(695);
		$li_tm=$io_pdf->getTextWidth(14,$ls_titulo);
		$tm=296-($li_tm/2);
		$io_pdf->addText($tm,730,12,$ls_titulo); // Agregar el ttulo

		$la_data[1]=array('columna1'=>$condiciones["ocho"],'columna2'=>$condiciones["c8"],'columna3'=>'','columna4'=>$condiciones["c14a"]);
		$la_columna=array('columna1'=>'','columna2'=>'','columna3'=>'','columna4'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 8, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('columna1'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna2'=>array('justification'=>'left','width'=>255), // Justificacion y ancho de la columna
						 		  'columna3'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna4'=>array('justification'=>'left','width'=>255))); // Justificacion y ancho de la columna
							
		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);
		unset($la_data);
		unset($la_columna);
		unset($la_config);

		$la_data[1]=array('columna1'=>$condiciones["nueve"],'columna2'=>$condiciones["c9"],'columna3'=>$condiciones["quince"],'columna4'=>$condiciones["c15"]);
		$la_columna=array('columna1'=>'','columna2'=>'','columna3'=>'','columna4'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 8, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('columna1'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna2'=>array('justification'=>'left','width'=>255), // Justificacion y ancho de la columna
						 		  'columna3'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna4'=>array('justification'=>'left','width'=>255))); // Justificacion y ancho de la columna
							
		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);
		unset($la_data);
		unset($la_columna);
		unset($la_config);

		$la_data[1]=array('columna1'=>$condiciones["diez"],'columna2'=>$condiciones["c10"],'columna3'=>'','columna4'=>'');
		$la_columna=array('columna1'=>'','columna2'=>'','columna3'=>'','columna4'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 8, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('columna1'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna2'=>array('justification'=>'left','width'=>255), // Justificacion y ancho de la columna
						 		  'columna3'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna4'=>array('justification'=>'left','width'=>255))); // Justificacion y ancho de la columna
							
		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);
		unset($la_data);
		unset($la_columna);
		unset($la_config);

		$la_data[1]=array('columna1'=>$condiciones["once"],'columna2'=>$condiciones["c11"],'columna3'=>'','columna4'=>$condiciones["dieciseis"]);
		$la_columna=array('columna1'=>'','columna2'=>'','columna3'=>'','columna4'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 8, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('columna1'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna2'=>array('justification'=>'left','width'=>255), // Justificacion y ancho de la columna
						 		  'columna3'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna4'=>array('justification'=>'left','width'=>255))); // Justificacion y ancho de la columna
							
		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);
		unset($la_data);
		unset($la_columna);
		unset($la_config);

		$la_data[1]=array('columna1'=>$condiciones["doce"],'columna2'=>$condiciones["c12"],'columna3'=>'','columna4'=>$condiciones["diecisiete"]);
		$la_columna=array('columna1'=>'','columna2'=>'','columna3'=>'','columna4'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 8, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('columna1'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna2'=>array('justification'=>'left','width'=>255), // Justificacion y ancho de la columna
						 		  'columna3'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna4'=>array('justification'=>'left','width'=>255))); // Justificacion y ancho de la columna
							
		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);
		unset($la_data);
		unset($la_columna);
		unset($la_config);

		$la_data[1]=array('columna1'=>$condiciones["trece"],'columna2'=>$condiciones["c13"],'columna3'=>'','columna4'=>$condiciones["dieciocho"]);
		$la_columna=array('columna1'=>'','columna2'=>'','columna3'=>'','columna4'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 8, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('columna1'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna2'=>array('justification'=>'left','width'=>255), // Justificacion y ancho de la columna
						 		  'columna3'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna4'=>array('justification'=>'left','width'=>255))); // Justificacion y ancho de la columna
							
		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);
		unset($la_data);
		unset($la_columna);
		unset($la_config);

		$la_data[1]=array('columna1'=>$condiciones["catorce"],'columna2'=>$condiciones["c14"],'columna3'=>'','columna4'=>'');
		$la_columna=array('columna1'=>'','columna2'=>'','columna3'=>'','columna4'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 8, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('columna1'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna2'=>array('justification'=>'left','width'=>255), // Justificacion y ancho de la columna
						 		  'columna3'=>array('justification'=>'right','width'=>25), // Justificacion y ancho de la columna
						 		  'columna4'=>array('justification'=>'left','width'=>255))); // Justificacion y ancho de la columna
							
		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);
		unset($la_data);
		unset($la_columna);
		unset($la_config);
			}
		$io_pdf->ezStream(); // Mostramos el reporte
	}
	else // Si hubo algn error
	{
		print("<script language=JavaScript>");
		print(" alert('Ocurrio un error al generar el reporte. Intente de Nuevo');"); 
		print(" close();");
		print("</script>");		
	}
	unset($io_report);
	unset($io_funciones);
	unset($io_fun_soc);
?>
