<?php 
    session_start();   
	header("Pragma: public");
	header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
	header("Cache-Control: private",false);
	if(!array_key_exists("la_logusr",$_SESSION))
	{
		print "<script language=JavaScript>";
		print "close();";
		print "opener.document.form1.submit();";		
		print "</script>";		
	}

	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_insert_seguridad($as_titulo)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_insert_seguridad
		//		   Access: private 
		//	    Arguments: as_titulo // Ttulo del reporte
		//    Description: funcion que guarda la seguridad de quien Genero el Reporte
		//	   Creado Por: Ing. Yesenia Moreno/ Ing. Luis Lang
		// Fecha Creacion: 20/05/2009
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_fun_sob;
		
		$ls_descripcion="Genero el Reporte ".$as_titulo;
		$lb_valido=$io_fun_sob->uf_load_seguridad_reporte("SOB","sigesp_sob_d_obra.php",$ls_descripcion);
		return $lb_valido;
	}
	//-----------------------------------------------------------------------------------------------------------------------------------

	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_print_encabezado_pagina($as_titulo,$io_pdf)
	{
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_encabezado_pagina
		//		   Access: private 
		//	    Arguments: as_titulo // Ttulo del Reporte
		//	    		   as_codobr // Cdigo de Obra
		//	    		   ad_feccreobr // Fecha de Registro de Obra
		//	    		   io_pdf // Instancia de objeto pdf
		//    Description: Funcion que imprime los encabezados por pgina
		//	   Creado Por: Ing. Yesenia Moreno / Ing. Luis Lang
		// Fecha Creacion: 20/05/2009
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
		$ls_nomemp=$_SESSION["la_empresa"]["nombre"];
		$ls_sigemp=$_SESSION["la_empresa"]["sigemp"];
		$io_encabezado=$io_pdf->openObject();
		$io_pdf->saveState();
		$io_pdf->addJpegFromFile('../../shared/imagebank/'.$_SESSION["ls_logo"],25,713,$_SESSION["ls_width"],$_SESSION["ls_height"]); // Agregar Logo
		$li_tm=$io_pdf->getTextWidth(11,$as_titulo);
		$tm=296-($li_tm/2);
		$io_pdf->addText($tm,670,11,$as_titulo); // Agregar el ttulo
		$io_pdf->addText(50,700,11,$ls_nomemp); // Agregar el ttulo
		$io_pdf->addText(540,690,9,date("d/m/Y")); // Agregar la Fecha
		$io_pdf->restoreState();
		$io_pdf->closeObject();
		$io_pdf->addObject($io_encabezado,'all');
	}// end function uf_print_encabezado_pagina
	//-----------------------------------------------------------------------------------------------------------------------------------

	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_print_cabecera($as_codobr,$as_desobr,$ai_monto,$as_ubicacion,$as_feciniobr,$as_fecfinobr,$li_porcobrar,$li_anticipos,$li_valuaciones,
							   $li_porejecutar,$li_porvaluar,$li_porcontratar,$li_contrato,$io_pdf)

	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_cabecera
		//		   Access: private 
		//	    Arguments: as_desobr    // Descripcin de la Obra
		//	   			   as_nompro // Organismo Ejecutor
		//	   			   as_resobr // Responsable de la Obra
		//	   			   as_nomsiscon // Sistema Constructivo
		//	   			   as_nomtob    // tipo de Obra
		//	   			   as_nomtipest    // Tipo Estructura
		//	   			   as_consol    // Concepto
		//	    		   io_pdf // Instancia de objeto pdf
		//    Description: funcion que imprime la cabecera por concepto
		//	   Creado Por: Ing. Yesenia Moreno / Ing. Luis Lang
		// Fecha Creacion: 22/05/2009
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
		$la_data[1]=array('titulo'=>'<b> Obra: </b>'.$as_desobr);
		$la_columnas=array('titulo'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 9, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>1, // Mostrar Lneas
						 'shaded'=>2, // Sombra entre lneas
						 'shadeCol'=>array((249/255),(249/255),(249/255)), // Color de la sombra
						 'shadeCol2'=>array((249/255),(249/255),(249/255)), // Color de la sombra
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
				         'outerLineThickness'=>0.5,
						 'innerLineThickness' =>0.5,
						 'cols'=>array('titulo'=>array('justification'=>'left','width'=>550))); // Justificacion y ancho de la columna
		$io_pdf->ezTable($la_data,$la_columnas,'',$la_config);
		unset($la_data);
		unset($la_columnas);
		unset($la_config);

		$la_data[1]=array('1'=>'<b>Fecha Inicio:</b> '.$as_feciniobr,'2'=>'<b>Fecha Fin:</b> '.$as_fecfinobr,'3'=>'<b>Monto:</b> '.$ai_monto,'4'=>'<b>Por Contratar: </b>'.$li_porcontratar);
		$la_columnas=array('1'=>'','2'=>'','3'=>'','4'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 9, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>2, // Mostrar Lneas
						 'shaded'=>2, // Sombra entre lneas
						 'shadeCol'=>array((249/255),(249/255),(249/255)), // Color de la sombra
						 'shadeCol2'=>array((249/255),(249/255),(249/255)), // Color de la sombra
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
				         'outerLineThickness'=>0.5,
						 'innerLineThickness' =>0.5,
						 'cols'=>array('1'=>array('justification'=>'left','width'=>135),
						 			   '2'=>array('justification'=>'left','width'=>145),
									   '3'=>array('justification'=>'left','width'=>135),
									   '4'=>array('justification'=>'left','width'=>135))); // Justificacion y ancho de la columna
		$io_pdf->ezTable($la_data,$la_columnas,'',$la_config);
		unset($la_data);
		unset($la_columnas);
		unset($la_config);
		$la_data[1]=array('titulo'=>'<b> Ubicacion: </b>'.$as_ubicacion);
		$la_columnas=array('titulo'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 9, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>1, // Mostrar Lneas
						 'shaded'=>2, // Sombra entre lneas
						 'shadeCol'=>array((249/255),(249/255),(249/255)), // Color de la sombra
						 'shadeCol2'=>array((249/255),(249/255),(249/255)), // Color de la sombra
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
				         'outerLineThickness'=>0.5,
						 'innerLineThickness' =>0.5,
						 'cols'=>array('titulo'=>array('justification'=>'left','width'=>550))); // Justificacion y ancho de la columna
		$io_pdf->ezTable($la_data,$la_columnas,'',$la_config);
		unset($la_data);
		unset($la_columnas);
		unset($la_config);
		
		$la_data1[1]=array('1'=>'<b>Contratado: </b> '.$li_contrato,'2'=>'<b>Ejecutado: </b> '.$li_valuaciones,'3'=>'<b>Por Ejecutar: </b>'.$li_porejecutar,'4'=>'<b>Por Amortizar:</b>  '.$li_porvaluar);
		$la_columnas=array('1'=>'','2'=>'','3'=>'','4'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 9, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>2, // Mostrar Lneas
						 'shaded'=>2, // Sombra entre lneas
						 'shadeCol'=>array((249/255),(249/255),(249/255)), // Color de la sombra
						 'shadeCol2'=>array((249/255),(249/255),(249/255)), // Color de la sombra
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
				         'outerLineThickness'=>0.5,
						 'innerLineThickness' =>0.5,
						 'cols'=>array('1'=>array('justification'=>'left','width'=>140),
						 			   '2'=>array('justification'=>'left','width'=>140),
						 			   '3'=>array('justification'=>'left','width'=>130),
									   '4'=>array('justification'=>'left','width'=>140))); // Justificacion y ancho de la columna
		$io_pdf->ezTable($la_data1,$la_columnas,'',$la_config);
		unset($la_data);
		unset($la_columnas);
		unset($la_config);
/*		$la_data[1]=array('titulo'=>'<b> Por Ejecutar: </b>'.$li_porcobrar);
		$la_columnas=array('titulo'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 9, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>1, // Mostrar Lneas
						 'shaded'=>2, // Sombra entre lneas
						 'shadeCol'=>array((249/255),(249/255),(249/255)), // Color de la sombra
						 'shadeCol2'=>array((249/255),(249/255),(249/255)), // Color de la sombra
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
				         'outerLineThickness'=>0.5,
						 'innerLineThickness' =>0.5,
						 'cols'=>array('titulo'=>array('justification'=>'left','width'=>550))); // Justificacion y ancho de la columna
		$io_pdf->ezTable($la_data,$la_columnas,'',$la_config);
		unset($la_data);
		unset($la_columnas);
		unset($la_config);

*/
	}// end function uf_print_cabecera
	//-----------------------------------------------------------------------------------------------------------------------------------

	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_print_titulocontrato($io_pdf)

	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_cabecera
		//		   Access: private 
		//	    Arguments: as_desobr    // Descripcin de la Obra
		//	   			   as_nompro // Organismo Ejecutor
		//	   			   as_resobr // Responsable de la Obra
		//	   			   as_nomsiscon // Sistema Constructivo
		//	   			   as_nomtob    // tipo de Obra
		//	   			   as_nomtipest    // Tipo Estructura
		//	   			   as_consol    // Concepto
		//	    		   io_pdf // Instancia de objeto pdf
		//    Description: funcion que imprime la cabecera por concepto
		//	   Creado Por: Ing. Yesenia Moreno / Ing. Luis Lang
		// Fecha Creacion: 22/05/2009
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
		$la_data[1]=array('titulo'=>'<b> CONTRATOS DE LA OBRA </b>');
		$la_columnas=array('titulo'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 9, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>1, // Mostrar Lneas
						 'shaded'=>2, // Sombra entre lneas
						 'shadeCol'=>array((249/255),(249/255),(249/255)), // Color de la sombra
						 'shadeCol2'=>array((249/255),(249/255),(249/255)), // Color de la sombra
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
				         'outerLineThickness'=>0.5,
						 'innerLineThickness' =>0.5,
						 'cols'=>array('titulo'=>array('justification'=>'center','width'=>550))); // Justificacion y ancho de la columna
		$io_pdf->ezTable($la_data,$la_columnas,'',$la_config);
		unset($la_data);
		unset($la_columnas);
		unset($la_config);
	}
	//-----------------------------------------------------------------------------------------------------------------------------------

	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_print_tituloseguimiento($io_pdf)

	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_cabecera
		//		   Access: private 
		//	    Arguments: as_desobr    // Descripcin de la Obra
		//	   			   as_nompro // Organismo Ejecutor
		//	   			   as_resobr // Responsable de la Obra
		//	   			   as_nomsiscon // Sistema Constructivo
		//	   			   as_nomtob    // tipo de Obra
		//	   			   as_nomtipest    // Tipo Estructura
		//	   			   as_consol    // Concepto
		//	    		   io_pdf // Instancia de objeto pdf
		//    Description: funcion que imprime la cabecera por concepto
		//	   Creado Por: Ing. Yesenia Moreno / Ing. Luis Lang
		// Fecha Creacion: 22/05/2009
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
		$la_data[1]=array('titulo'=>'<b> SEGUIMIENTO DEL CONTRATO </b>');
		$la_columnas=array('titulo'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 9, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>1, // Mostrar Lneas
						 'shaded'=>2, // Sombra entre lneas
						 'shadeCol'=>array((249/255),(249/255),(249/255)), // Color de la sombra
						 'shadeCol2'=>array((249/255),(249/255),(249/255)), // Color de la sombra
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
				         'outerLineThickness'=>0.5,
						 'innerLineThickness' =>0.5,
						 'cols'=>array('titulo'=>array('justification'=>'center','width'=>550))); // Justificacion y ancho de la columna
		$io_pdf->ezTable($la_data,$la_columnas,'',$la_config);
		unset($la_data);
		unset($la_columnas);
		unset($la_config);
	}
	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_print_contrato($as_codcon,$ls_nompro,$as_feccon,$as_montocontrato,$as_fecinicon,$as_fecfincon,$ls_codasi,$ls_codpro,
							   $ls_anticipo,$li_amototval,$li_amoresval,$li_porejecutar,$li_montotval,$li_montotvar,$io_pdf)

	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_cabecera
		//		   Access: private 
		//	    Arguments: as_desobr    // Descripcin de la Obra
		//	   			   as_nompro // Organismo Ejecutor
		//	   			   as_resobr // Responsable de la Obra
		//	   			   as_nomsiscon // Sistema Constructivo
		//	   			   as_nomtob    // tipo de Obra
		//	   			   as_nomtipest    // Tipo Estructura
		//	   			   as_consol    // Concepto
		//	    		   io_pdf // Instancia de objeto pdf
		//    Description: funcion que imprime la cabecera por concepto
		//	   Creado Por: Ing. Yesenia Moreno / Ing. Luis Lang
		// Fecha Creacion: 22/05/2009
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
		$la_data[1]=array('1'=>'<b>No. Asignacion:</b> '.$ls_codasi,'2'=>'<b>Contratista:</b> '.$ls_codpro.' - '.$ls_nompro);
		$la_columnas=array('1'=>'','2'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 9, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>2, // Mostrar Lneas
						 'shaded'=>2, // Sombra entre lneas
						 'shadeCol'=>array((249/255),(249/255),(249/255)), // Color de la sombra
						 'shadeCol2'=>array((249/255),(249/255),(249/255)), // Color de la sombra
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
				         'outerLineThickness'=>0.5,
						 'innerLineThickness' =>0.5,
						 'cols'=>array('1'=>array('justification'=>'left','width'=>150),
									   '2'=>array('justification'=>'left','width'=>400))); // Justificacion y ancho de la columna
		$io_pdf->ezTable($la_data,$la_columnas,'',$la_config);
		unset($la_data);
		unset($la_columnas);
		unset($la_config);

		$la_data[1]=array('1'=>'<b>Contrato:</b> '.$as_codcon,'2'=>'<b>Fecha Inicio:</b> '.$as_fecinicon,'3'=>'<b>Fecha Fin:</b> '.$as_fecfincon,'4'=>'<b>Monto: </b>'.$as_montocontrato);
		$la_columnas=array('1'=>'','2'=>'','3'=>'','4'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 9, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>2, // Mostrar Lneas
						 'shaded'=>2, // Sombra entre lneas
						 'shadeCol'=>array((249/255),(249/255),(249/255)), // Color de la sombra
						 'shadeCol2'=>array((249/255),(249/255),(249/255)), // Color de la sombra
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
				         'outerLineThickness'=>0.5,
						 'innerLineThickness' =>0.5,
						 'cols'=>array('1'=>array('justification'=>'left','width'=>135),
						 			   '2'=>array('justification'=>'left','width'=>145),
									   '3'=>array('justification'=>'left','width'=>135),
									   '4'=>array('justification'=>'left','width'=>135))); // Justificacion y ancho de la columna
		$io_pdf->ezTable($la_data,$la_columnas,'',$la_config);
		unset($la_data);
		unset($la_columnas);
		unset($la_config);

		$la_data[1]=array('1'=>'<b>Anticipo:</b> '.$ls_anticipo,'2'=>'<b>Amortizado del Anticipo:</b> '.$li_amototval,'3'=>'<b>Por Amortizar:</b> '.$li_amoresval);
		$la_columnas=array('1'=>'','2'=>'','3'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 9, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>2, // Mostrar Lneas
						 'shaded'=>2, // Sombra entre lneas
						 'shadeCol'=>array((249/255),(249/255),(249/255)), // Color de la sombra
						 'shadeCol2'=>array((249/255),(249/255),(249/255)), // Color de la sombra
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
				         'outerLineThickness'=>0.5,
						 'innerLineThickness' =>0.5,
						 'cols'=>array('1'=>array('justification'=>'left','width'=>183),
						 			   '2'=>array('justification'=>'left','width'=>183),
									   '3'=>array('justification'=>'left','width'=>184))); // Justificacion y ancho de la columna
		$io_pdf->ezTable($la_data,$la_columnas,'',$la_config);
		unset($la_data);
		unset($la_columnas);
		unset($la_config);

		$la_data[1]=array('1'=>'<b>Contratado:</b> '.$as_montocontrato,'2'=>'<b>Ejecutado:</b> '.$li_montotval,'3'=>'<b>Variacion:</b> '.$li_montotvar,'4'=>'<b>Por Ejecutar:</b> '.$li_porejecutar);
		$la_columnas=array('1'=>'','2'=>'','3'=>'','4'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 9, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>2, // Mostrar Lneas
						 'shaded'=>2, // Sombra entre lneas
						 'shadeCol'=>array((249/255),(249/255),(249/255)), // Color de la sombra
						 'shadeCol2'=>array((249/255),(249/255),(249/255)), // Color de la sombra
						 'width'=>570, // Ancho de la tabla
						 'maxWidth'=>570, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
				         'outerLineThickness'=>0.5,
						 'innerLineThickness' =>0.5,
						 'cols'=>array('1'=>array('justification'=>'left','width'=>140),
						 			   '2'=>array('justification'=>'left','width'=>140),
						 			   '3'=>array('justification'=>'left','width'=>130),
									   '4'=>array('justification'=>'left','width'=>140))); // Justificacion y ancho de la columna
		$io_pdf->ezTable($la_data,$la_columnas,'',$la_config);
		unset($la_data);
		unset($la_columnas);
		unset($la_config);




	}// end function uf_print_cabecera
	//-----------------------------------------------------------------------------------------------------------------------------------

	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_print_detalle_contratos($la_data,$li_totalcontratos,$io_pdf)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_detalle_cuentas
		//		   Access: private 
		//	    Arguments: la_data // arreglo de informacion
		//	    		   io_pdf // Instancia de objeto pdf
		//    Description: funcion que imprime el detalle por concepto
		//	   Creado Por: Ing. Yesenia Moreno / Ing. Luis Lang
		// Fecha Creacion: 27/04/2006 
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
		$io_pdf->ezSetDy(-5);
		$la_columnas=array('codcon'=>'<b>No. Contrato</b>',
						   'feccon'=>'<b>Fecha</b>',
						   'monto'=>'<b>Monto</b>');
		$la_config=array('showHeadings'=>1, // Mostrar encabezados
						 'fontSize' => 9, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>560, // Ancho de la tabla
						 'maxWidth'=>560, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
				         'outerLineThickness'=>0.5,
						 'innerLineThickness' =>0.5,
						 'cols'=>array('codcon'=>array('justification'=>'center','width'=>150), // Justificacion y ancho de la columna
						 			   'feccon'=>array('justification'=>'center','width'=>150), // Justificacion y ancho de la columna
						 			   'monto'=>array('justification'=>'right','width'=>150))); // Justificacion y ancho de la columna
		$io_pdf->ezTable($la_data,$la_columnas,'',$la_config);

		unset($la_data);
		unset($la_columnas);
		unset($la_config);
		$la_data[1]=array('codval'=>'TOTAL CONTRATOS.....',
						   'montotval'=>$li_totalcontratos);
		$la_columnas=array('codval'=>'<b></b>',
						   'montotval'=>'<b></b>');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 9, // Tamao de Letras
						 'titleFontSize' => 9,  // Tamao de Letras de los ttulos
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>560, // Ancho de la tabla
						 'maxWidth'=>560, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
				         'outerLineThickness'=>0.5,
						 'innerLineThickness' =>0.5,
						 'cols'=>array('codval'=>array('justification'=>'right','width'=>400), // Justificacion y ancho de la columna
						 			   'montotval'=>array('justification'=>'right','width'=>100))); // Justificacion y ancho de la columna
		$io_pdf->ezTable($la_data,$la_columnas,'',$la_config);
	}// end function uf_print_detalle_cuentas
	//-----------------------------------------------------------------------------------------------------------------------------------

	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_print_detalle_anticipos($la_data,$li_totalanticipos,$io_pdf)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_detalle_cuentas
		//		   Access: private 
		//	    Arguments: la_data // arreglo de informacion
		//	    		   io_pdf // Instancia de objeto pdf
		//    Description: funcion que imprime el detalle por concepto
		//	   Creado Por: Ing. Yesenia Moreno / Ing. Luis Lang
		// Fecha Creacion: 27/04/2006 
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
		$io_pdf->ezSetDy(-5);
		$la_columnas=array('codcon'=>'<b>No. Anticipo</b>',
						   'blanco'=>'<b></b>',
						   'feccon'=>'<b>Fecha</b>',
						   'monto'=>'<b>Monto</b>');
		$la_config=array('showHeadings'=>1, // Mostrar encabezados
						 'fontSize' => 9, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>560, // Ancho de la tabla
						 'maxWidth'=>560, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
				         'outerLineThickness'=>0.5,
						 'innerLineThickness' =>0.5,
						 'cols'=>array('codcon'=>array('justification'=>'center','width'=>150), // Justificacion y ancho de la columna
						 			   'blanco'=>array('justification'=>'center','width'=>150), // Justificacion y ancho de la columna
						 			   'feccon'=>array('justification'=>'center','width'=>150), // Justificacion y ancho de la columna
						 			   'monto'=>array('justification'=>'right','width'=>100))); // Justificacion y ancho de la columna
		$io_pdf->ezTable($la_data,$la_columnas,'',$la_config);
		unset($la_data);
		unset($la_columnas);
		unset($la_config);
		$la_data[1]=array('codval'=>'TOTAL ANTICIPOS.....',
						   'montotval'=>$li_totalanticipos);
		$la_columnas=array('codval'=>'<b></b>',
						   'montotval'=>'<b></b>');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 9, // Tamao de Letras
						 'titleFontSize' => 9,  // Tamao de Letras de los ttulos
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>560, // Ancho de la tabla
						 'maxWidth'=>560, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
				         'outerLineThickness'=>0.5,
						 'innerLineThickness' =>0.5,
						 'cols'=>array('codval'=>array('justification'=>'right','width'=>450), // Justificacion y ancho de la columna
						 			   'montotval'=>array('justification'=>'right','width'=>100))); // Justificacion y ancho de la columna
		$io_pdf->ezTable($la_data,$la_columnas,'',$la_config);
	}// end function uf_print_detalle_cuentas
	//-----------------------------------------------------------------------------------------------------------------------------------

	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_print_detalle_valuacion($la_data,$li_totmontotval,$io_pdf)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_detalle_cuentas
		//		   Access: private 
		//	    Arguments: la_data // arreglo de informacion
		//	    		   io_pdf // Instancia de objeto pdf
		//    Description: funcion que imprime el detalle por concepto
		//	   Creado Por: Ing. Yesenia Moreno / Ing. Luis Lang
		// Fecha Creacion: 27/04/2006 
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
		$io_pdf->ezSetDy(-5);
		$la_columnas=array('codval'=>'<b>No. Valuacion</b>',
						   'numrecdoc'=>'<b>No. Documento</b>',
						   'fecval'=>'<b>Fecha</b>',
						   'montotval'=>'<b>Monto</b>');
		$la_config=array('showHeadings'=>1, // Mostrar encabezados
						 'fontSize' => 9, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>560, // Ancho de la tabla
						 'maxWidth'=>560, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
				         'outerLineThickness'=>0.5,
						 'innerLineThickness' =>0.5,
						 'cols'=>array('codval'=>array('justification'=>'center','width'=>150), // Justificacion y ancho de la columna
						 			   'numrecdoc'=>array('justification'=>'center','width'=>150), // Justificacion y ancho de la columna
						 			   'fecval'=>array('justification'=>'center','width'=>150), // Justificacion y ancho de la columna
						 			   'montotval'=>array('justification'=>'right','width'=>100))); // Justificacion y ancho de la columna
		$io_pdf->ezTable($la_data,$la_columnas,'',$la_config);
		unset($la_data);
		unset($la_columnas);
		unset($la_config);
		$la_data[1]=array('codval'=>'TOTAL VALUACIONES.....',
						   'montotval'=>$li_totmontotval);
		$la_columnas=array('codval'=>'<b></b>',
						   'montotval'=>'<b></b>');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 9, // Tamao de Letras
						 'titleFontSize' => 9,  // Tamao de Letras de los ttulos
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>560, // Ancho de la tabla
						 'maxWidth'=>560, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
				         'outerLineThickness'=>0.5,
						 'innerLineThickness' =>0.5,
						 'cols'=>array('codval'=>array('justification'=>'right','width'=>450), // Justificacion y ancho de la columna
						 			   'montotval'=>array('justification'=>'right','width'=>100))); // Justificacion y ancho de la columna
		$io_pdf->ezTable($la_data,$la_columnas,'',$la_config);
	}// end function uf_print_detalle_cuentas
	//-----------------------------------------------------------------------------------------------------------------------------------

	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_print_detalle_variacion($la_data,$li_totalvariacion,$io_pdf)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_detalle_cuentas
		//		   Access: private 
		//	    Arguments: la_data // arreglo de informacion
		//	    		   io_pdf // Instancia de objeto pdf
		//    Description: funcion que imprime el detalle por concepto
		//	   Creado Por: Ing. Yesenia Moreno / Ing. Luis Lang
		// Fecha Creacion: 27/04/2006 
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
		$io_pdf->ezSetDy(-5);
		$la_columnas=array('codvar'=>'<b>No. Variacion</b>',
						   'blanco'=>'<b></b>',
						   'fecvar'=>'<b>Fecha</b>',
						   'monto'=>'<b>Monto</b>');
		$la_config=array('showHeadings'=>1, // Mostrar encabezados
						 'fontSize' => 9, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>560, // Ancho de la tabla
						 'maxWidth'=>560, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
				         'outerLineThickness'=>0.5,
						 'innerLineThickness' =>0.5,
						 'cols'=>array('codvar'=>array('justification'=>'center','width'=>150), // Justificacion y ancho de la columna
						 			   'blanco'=>array('justification'=>'center','width'=>150), // Justificacion y ancho de la columna
						 			   'fecvar'=>array('justification'=>'center','width'=>150), // Justificacion y ancho de la columna
						 			   'monto'=>array('justification'=>'right','width'=>100))); // Justificacion y ancho de la columna
		$io_pdf->ezTable($la_data,$la_columnas,'',$la_config);
		$la_data2[1]=array('codval'=>'TOTAL VARIACIONES.....',
						   'montotval'=>$li_totalvariacion);
		$la_columnas=array('codval'=>'<b></b>',
						   'montotval'=>'<b></b>');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 9, // Tamao de Letras
						 'titleFontSize' => 9,  // Tamao de Letras de los ttulos
						 'showLines'=>0, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>560, // Ancho de la tabla
						 'maxWidth'=>560, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
				         'outerLineThickness'=>0.5,
						 'innerLineThickness' =>0.5,
						 'cols'=>array('codval'=>array('justification'=>'right','width'=>450), // Justificacion y ancho de la columna
						 			   'montotval'=>array('justification'=>'right','width'=>100))); // Justificacion y ancho de la columna
		$io_pdf->ezTable($la_data2,$la_columnas,'',$la_config);
	}// end function uf_print_detalle_cuentas
	//-----------------------------------------------------------------------------------------------------------------------------------

	//-----------------------------------------------------  Instancia de las clases  ------------------------------------------------
	require_once("../../shared/ezpdf/class.ezpdf.php");
	require_once("../../shared/class_folder/class_funciones.php");
	$io_funciones=new class_funciones();				
	require_once("../class_folder/class_funciones_sob.php");
	$io_fun_sob=new class_funciones_sob();
	$ls_estmodest=$_SESSION["la_empresa"]["estmodest"];
	if($ls_estmodest==1)
	{
		$ls_titcuentas="Estructura Presupuestaria";
	}
	else
	{
		$ls_titcuentas="Estructura Programatica";
	}
	//--------------------------------------------------  Parmetros para Filtar el Reporte  -----------------------------------------
	 $ls_coddes=$io_fun_sob->uf_obtenervalor_get("coddes","");
	 $ls_codhas=$io_fun_sob->uf_obtenervalor_get("codhas","");
	 $ls_fecregdes=$io_fun_sob->uf_obtenervalor_get("fecregdes","");
	 $ls_fecreghas=$io_fun_sob->uf_obtenervalor_get("fecreghas","");
	 $ls_codorgeje=$io_fun_sob->uf_obtenervalor_get("codorgeje","");
	//--------------------------------------------------------------------------------------------------------------------------------
	require_once("sigesp_sob_class_report.php"); 
	$io_report=new sigesp_sob_class_report();
	 //Instancio a la clase de conversion de numeros a letras.
	 include("../../shared/class_folder/class_numero_a_letra.php");
	 $numalet= new class_numero_a_letra();
	 //imprime numero con los valore por defecto
	 //cambia a minusculas
	 $numalet->setMayusculas(1);
	 //cambia a femenino
	 $numalet->setGenero(1);
	 //cambia moneda
	 $numalet->setMoneda("Bolivares");
	 $ls_moneda="EN Bs.";
	 //cambia prefijo
	 $numalet->setPrefijo("***");
	 //cambia sufijo
	 $numalet->setSufijo("***");
	//----------------------------------------------------  Parmetros del encabezado  -----------------------------------------------
	 $ls_titulo='<b>SEGUIMIENTO DE OBRAS</b>';
	//--------------------------------------------------------------------------------------------------------------------------------
	$lb_valido=uf_insert_seguridad($ls_titulo); // Seguridad de Reporte
	if($lb_valido)
	{

		$lb_valido=$io_report->uf_select_listadoobras($ls_coddes,$ls_codhas,$ls_fecregdes,$ls_fecreghas,$ls_codorgeje); // Cargar el DS con los datos del reporte
		if($lb_valido==false) // Existe algn error o no hay registros
		{ 
			print("<script language=JavaScript>");
			print(" alert('No hay nada que Reportar');"); 
			print(" close();"); 
			print("</script>");
		}
		else  // Imprimimos el reporte
		{
			error_reporting(E_ALL);
			set_time_limit(1800); 
			$io_pdf=new Cezpdf('LETTER','portrait'); // Instancia de la clase PDF
			$io_pdf->selectFont('../../shared/ezpdf/fonts/Helvetica.afm'); // Seleccionamos el tipo de letra
			$io_pdf->ezSetCmMargins(5,6,3,3); // Configuracion de los margenes en centmetros
			$io_pdf->ezStartPageNumbers(570,47,8,'','',1); // Insertar el nmero de pgina
			uf_print_encabezado_pagina($ls_titulo,$io_pdf);
			while(!$io_report->rs_data->EOF)
			{			
				$ls_codobr=$io_report->rs_data->fields["codobr"];
				$ls_desobr=$io_report->rs_data->fields["desobr"];
				$li_monto=$io_report->rs_data->fields["monto"];
				$ls_despai=$io_report->rs_data->fields["despai"];
				$ls_desest=$io_report->rs_data->fields["desest"];
				$ls_desmun=$io_report->rs_data->fields["desmun"];
				$ls_despar=$io_report->rs_data->fields["despar"];
				$ls_descom=$io_report->rs_data->fields["descom"];
				$li_anticipos=$io_report->rs_data->fields["anticipo"];
				$li_contrato=$io_report->rs_data->fields["contrato"];
				$li_valuaciones=$io_report->rs_data->fields["valuacion"];
				$li_amortizado=$io_report->rs_data->fields["amortizado"];
				$li_variacion=$io_report->rs_data->fields["variacion"];
				$ls_feciniobr=$io_funciones->uf_convertirfecmostrar($io_report->rs_data->fields["feciniobr"]);
				$ls_fecfinobr=$io_funciones->uf_convertirfecmostrar($io_report->rs_data->fields["fecfinobr"]);
				$li_porcontratar=$li_monto-$li_contrato;  //REVISAR FORMULA
				$li_porcobrar=$li_monto-$li_valuaciones;  //REVISAR FORMULA
				$li_porejecutar=$li_monto-$li_valuaciones;  //REVISAR FORMULA
				$li_porejecutar=number_format($li_porejecutar,2,".","")+number_format($li_variacion,2,".","");
				$li_porvaluar=$li_anticipos-$li_amortizado;  //REVISAR FORMULA
				$li_monto=number_format($li_monto,2,",",".");
				$li_anticipos=number_format($li_anticipos,2,",",".");
				$li_valuaciones=number_format($li_valuaciones,2,",",".");
				$li_porcobrar=number_format($li_porcobrar,2,",",".");
				$li_porejecutar=number_format($li_porejecutar,2,",",".");
				$li_porvaluar=number_format($li_porvaluar,2,",",".");
				$li_porcontratar=number_format($li_porcontratar,2,",",".");
				$li_contrato=number_format($li_contrato,2,",",".");
				$ls_ubicacion=$ls_despai." - ".$ls_desest." - ".$ls_desmun." - ".$ls_despar." - ".$ls_descom;
				uf_print_cabecera($ls_codobr,$ls_desobr,$li_monto,$ls_ubicacion,$ls_feciniobr,$ls_fecfinobr,$li_porcobrar,$li_anticipos,$li_valuaciones,$li_porejecutar,$li_porvaluar,$li_porcontratar,$li_contrato,$io_pdf);
				uf_print_titulocontrato($io_pdf);
				$lb_valido=$io_report->uf_select_contratos_obras($ls_codobr); 
				$li_s=0;
				$li_totalcontrato=0;
				while(!$io_report->rs_contratos->EOF)
				{
					$li_s++;
					$ls_codcon=$io_report->rs_contratos->fields["codcon"];
					$ls_nompro=$io_report->rs_contratos->fields["nompro"];
					$ls_codasi=$io_report->rs_contratos->fields["codasi"];
					$ls_codpro=$io_report->rs_contratos->fields["cod_pro"];
					$ls_feccon=$io_funciones->uf_convertirfecmostrar($io_report->rs_contratos->fields["feccon"]);
					$ls_fecinicon=$io_funciones->uf_convertirfecmostrar($io_report->rs_contratos->fields["fecinicon"]);
					$ls_fecfincon=$io_funciones->uf_convertirfecmostrar($io_report->rs_contratos->fields["fecfincon"]);
					$ls_montocontrato=$io_report->rs_contratos->fields["monto"];
					$ls_anticipo=$io_report->rs_contratos->fields["anticipo"];
					$li_amototval=$io_report->rs_contratos->fields["amototval"];
					$li_amoresval=$io_report->rs_contratos->fields["amoresval"];
					$li_montotval=$io_report->rs_contratos->fields["montotval"];
					$li_montotvar=$io_report->rs_contratos->fields["montotvar"];
					$li_porejecutar=abs($ls_montocontrato-$li_montotval+$li_montotvar);
					$li_totalcontrato=$li_totalcontrato+$ls_montocontrato;
					$ls_montocontrato=number_format($ls_montocontrato,2,",",".");
					$ls_anticipo=number_format($ls_anticipo,2,",",".");
					$li_amototval=number_format($li_amototval,2,",",".");
					$li_amoresval=number_format($li_amoresval,2,",",".");
					$li_porejecutar=number_format($li_porejecutar,2,",",".");
					$li_montotval=number_format($li_montotval,2,",",".");
					$li_montotvar=number_format($li_montotvar,2,",",".");

					uf_print_contrato($ls_codcon,$ls_nompro,$ls_feccon,$ls_montocontrato,$ls_fecinicon,$ls_fecfincon,$ls_codasi,$ls_codpro,$ls_anticipo,
									  $li_amototval,$li_amoresval,$li_porejecutar,$li_montotval,$li_montotvar,$io_pdf);
					uf_print_tituloseguimiento($io_pdf);
					$lb_valido=$io_report->uf_select_anticipos_obras($ls_codobr,$ls_codcon); 
					$li_s=0;
					$li_totalanticipo=0;
					while(!$io_report->rs_anticipos->EOF)
					{
						$li_s++;
						$ls_codant=$io_report->rs_anticipos->fields["codant"];
						$ls_fecant=$io_funciones->uf_convertirfecmostrar($io_report->rs_anticipos->fields["fecant"]);
						$li_montoanticipo=$io_report->rs_anticipos->fields["monto"];
						$li_totalanticipo=$li_totalanticipo+$li_montoanticipo;
						$li_montoanticipo=number_format($li_montoanticipo,2,",",".");
	
						$la_data[$li_s]=array('codcon'=>$ls_codant,'blanco'=>"",'feccon'=>$ls_fecant,'monto'=>$li_montoanticipo);
						$io_report->rs_anticipos->MoveNext();
					}
					if($li_s>0)
					{
						$li_totalanticipo=number_format($li_totalanticipo,2,",",".");
						uf_print_detalle_anticipos($la_data,$li_totalanticipo,$io_pdf);
					}
					unset($la_data);
					$lb_valido=$io_report->uf_select_valuaciones_obras($ls_codobr,$ls_codcon); 
					$li_x=0;
					$li_totmontotval=0;
					while(!$io_report->rs_valuaciones->EOF)
					{
						$li_x++;
						$ls_codval=$io_report->rs_valuaciones->fields["codval"];
						$li_montotval=$io_report->rs_valuaciones->fields["totalvaluacion"];
						$ls_numrecdoc=$io_report->rs_valuaciones->fields["numrecdoc"];
						$ls_fecval=$io_funciones->uf_convertirfecmostrar($io_report->rs_valuaciones->fields["fecha"]);
						$li_totmontotval=$li_totmontotval+$li_montotval;
						$li_montotval=number_format($li_montotval,2,",",".");
						$la_data[$li_x]=array('codval'=>$ls_codval,'numrecdoc'=>$ls_numrecdoc,'fecval'=>$ls_fecval,'montotval'=>$li_montotval);
						
						$io_report->rs_valuaciones->MoveNext();
					}
					if($li_x>0)
					{
						$li_totmontotval=number_format($li_totmontotval,2,",",".");
						uf_print_detalle_valuacion($la_data,$li_totmontotval,$io_pdf);
					}
					unset($la_data);
					$lb_valido=$io_report->uf_select_variaciones_obras($ls_codobr,$ls_codcon); 
					$li_x=0;
					$li_totmontotvar=0;
					while(!$io_report->rs_variaciones->EOF)
					{
						$li_x++;
						$ls_codvar=$io_report->rs_variaciones->fields["codvar"];
						$li_monvar=$io_report->rs_variaciones->fields["montovar"];
						$ls_tipvar=$io_report->rs_variaciones->fields["tipvar"];
						$ls_fecvar=$io_funciones->uf_convertirfecmostrar($io_report->rs_variaciones->fields["fecvar"]);
//						if($ls_tipvar==2)
//						{$li_monvar=$li_monvar*-1;}
						$li_totmontotvar=$li_totmontotvar+$li_monvar;
						$li_monvar=number_format($li_monvar,2,",",".");
						$la_data[$li_s]=array('codvar'=>$ls_codvar,'blanco'=>"",'fecvar'=>$ls_fecvar,'monto'=>$li_monvar);
						
						$io_report->rs_variaciones->MoveNext();
					}
					if($li_x>0)
					{
						$li_totmontotvar=number_format($li_totmontotvar,2,",",".");
						uf_print_detalle_variacion($la_data,$li_totmontotvar,$io_pdf);
					}
					unset($la_data);
					$io_report->rs_contratos->MoveNext();
				}
				/*if($li_s>0)
				{
					$li_totalcontrato=number_format($li_totalcontrato,2,",",".");
					uf_print_detalle_contratos($la_data,$li_totalcontrato,$io_pdf);	
				}*/
				unset($la_data);
				$io_report->rs_data->MoveNext();
				if(!$io_report->rs_data->EOF)
				$io_pdf->ezNewPage();
			}
		}
		if($lb_valido) // Si no ocurrio ningn error
		{
			$io_pdf->ezStopPageNumbers(1,1); // Detenemos la impresion de los nmeros de pgina
			$io_pdf->ezStream(); // Mostramos el reporte
		}
		else // Si hubo algn error
		{
			print("<script language=JavaScript>");
			print(" alert('Ocurrio un error al generar el reporte. Intente de Nuevo');"); 
			print(" close();");
			print("</script>");		
		}
		
	}

?>
