<?php
class sigesp_snorh_c_historicocargos
{
	var $io_sql;
	var $io_mensajes;
	var $io_funciones;
	var $io_seguridad;
	var $io_fun_nomina;
	var $io_fideiconfigurable;
	var $io_personal;
	var $io_sno;
	var $ls_codemp;
	
	//-----------------------------------------------------------------------------------------------------------------------------------
	function sigesp_snorh_c_historicocargos()
	{	
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: sigesp_snorh_c_historicocargos
		//		   Access: public (sigesp_snorh_d_historicocargos)
		//	  Description: Constructor de la Clase
		//	   Creado Por: Ing. Yesenia Moreno
		// Fecha Creacion: 01/03/2018 								Fecha Última Modificacion : 
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		require_once("../shared/class_folder/sigesp_include.php");
		$io_include=new sigesp_include();
		$this->io_conexion=$io_include->uf_conectar();
		require_once("../shared/class_folder/class_sql.php");
		$this->io_sql=new class_sql($this->io_conexion);	
		require_once("../shared/class_folder/class_mensajes.php");
		$this->io_mensajes=new class_mensajes();		
		require_once("../shared/class_folder/class_funciones.php");
		$this->io_funciones=new class_funciones();		
		require_once("../shared/class_folder/sigesp_c_seguridad.php");
		$this->io_seguridad=new sigesp_c_seguridad();
		require_once("class_folder/class_funciones_nomina.php");
		$this->io_fun_nomina=new class_funciones_nomina();
        $this->ls_codemp=$_SESSION["la_empresa"]["codemp"];
	}// end function sigesp_snorh_c_historicocargos
	//-----------------------------------------------------------------------------------------------------------------------------------
	
	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_destructor()
	{	
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_destructor
		//		   Access: public (sigesp_snorh_d_historicocargos)
		//	  Description: Destructor de la Clase
		//	   Creado Por: Ing. Yesenia Moreno
		// Fecha Creacion: 01/03/2018 								Fecha Última Modificacion : 
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		unset($io_include);
		unset($io_conexion);
		unset($this->io_sql);	
		unset($this->io_mensajes);		
		unset($this->io_funciones);		
		unset($this->io_seguridad);
		unset($this->io_fun_nomina);
        unset($this->ls_codemp);
	}// end function uf_destructor
	//-----------------------------------------------------------------------------------------------------------------------------------

	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_select_historicocargos($as_codper,$ad_fecmov,$as_codnom)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_select_historicocargos
		//		   Access: private
		//   	Arguments: as_codper  // Codigo del Personal
		//	      Returns: lb_existe True si existe o False si no existe
		//	  Description: Funcion que verifica si el Sueldo Historico está registrado
		//	   Creado Por: Ing. Yesenia Moreno
		// Fecha Creacion: 01/03/2018 								Fecha Última Modificacion : 
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe=true;
		$ls_sql="SELECT codper ".
				"  FROM sno_historicocargo ".
				" WHERE codemp='".$this->ls_codemp."'".
				"   AND codper='".$as_codper."'".
				"   AND codnom='".$as_codnom."'".
				"   AND fecmov='".$ad_fecmov."'";
		$rs_data=$this->io_sql->select($ls_sql);
		if($rs_data===false)
		{
        	$this->io_mensajes->message("CLASE->Historico Cargos MÉTODO->uf_select_historicocargos ERROR->".$this->io_funciones->uf_convertirmsg($this->io_sql->message)); 
			$lb_existe=false;
		}
		else
		{
			if($rs_data->EOF)
			{
				$lb_existe=false;
			}
			$this->io_sql->free_result($rs_data);
		}
		return $lb_existe;
	}// end function uf_select_historicocargos
	//-----------------------------------------------------------------------------------------------------------------------------------
	
	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_insert_historicocargos($as_codper,$ad_fecmov,$as_codnom,$as_desnom,$as_codcar,$as_descar,$as_codasicar,$as_desasicar,$as_codtab,$as_destab,
	                    			   $as_codpas,$as_codgra,$aa_seguridad)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_insert_historicocargos
		//		   Access: private
		//	    Arguments: as_codper  // Codigo del Personal
		//	      Returns: lb_valido True si se ejecuto el insert o False si hubo error en el insert
		//	  Description: Funcion que inserta en la tabla de Historico Cargos
		//	   Creado Por: Ing. Yesenia Moreno
		// Fecha Creacion: 01/03/2018 								Fecha Última Modificacion : 
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_valido=true;
		$ls_sql="INSERT INTO sno_historicocargo(codemp, fecmov, codnom, codper, codasicar, codtab, codgra, codpas, codcar, desnom, descar, desasicar, destab) ".
				"VALUES ('".$this->ls_codemp."','".$ad_fecmov."','".$as_codnom."','".$as_codper."','".$as_codasicar."','".$as_codtab."','".$as_codgra."',".
				"'".$as_codpas."','".$as_codcar."','".$as_desnom."','".$as_descar."','".$as_desasicar."','".$as_destab."')";
       	$this->io_sql->begin_transaction();
	   	$li_row=$this->io_sql->execute($ls_sql);
		if($li_row===false)
		{
			$lb_valido=false;
        	$this->io_mensajes->message("CLASE->Historico Cargos MÉTODO->uf_insert_historicocargos ERROR->".$this->io_funciones->uf_convertirmsg($this->io_sql->message)); 
			$this->io_sql->rollback();
		}
		else
		{
			/////////////////////////////////         SEGURIDAD               /////////////////////////////		
			$ls_evento="INSERT";
			$ls_descripcion ="Inserto el Historico Cargos ".$as_codfid." asociado al personal ".$as_codper;
			$lb_valido= $this->io_seguridad->uf_sss_insert_eventos_ventana($aa_seguridad["empresa"],
											$aa_seguridad["sistema"],$ls_evento,$aa_seguridad["logusr"],
											$aa_seguridad["ventanas"],$ls_descripcion);
			/////////////////////////////////         SEGURIDAD               /////////////////////////////	
			if($lb_valido)
			{	
				$this->io_mensajes->message("El Historico Cargos fue registrado.");
				$this->io_sql->commit();
			}
			else
			{
				$lb_valido=false;
        		$this->io_mensajes->message("CLASE->Historico Cargos MÉTODO->uf_insert_historicocargos ERROR->".$this->io_funciones->uf_convertirmsg($this->io_sql->message)); 
				$this->io_sql->rollback();
			}
		}
		return $lb_valido;
	}// end function uf_insert_historicocargos
	//-----------------------------------------------------------------------------------------------------------------------------------

	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_update_historicocargos($as_codper,$ad_fecmov,$as_codnom,$as_desnom,$as_codcar,$as_descar,$as_codasicar,$as_desasicar,$as_codtab,$as_destab,
	                    				$as_codpas,$as_codgra,$aa_seguridad)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_update_historicocargos
		//		   Access: private
		//	    Arguments: as_codper  // Codigo del Personal
		//	      Returns: lb_valido True si se ejecuto el update o False si hubo error en el update
		//	  Description: Funcion que actualiza en la tabla de Historico Cargos
		//	   Creado Por: Ing. Yesenia Moreno
		// Fecha Creacion: 01/03/2018 								Fecha Última Modificacion : 		
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_valido=true;
		$ls_sql="UPDATE sno_historicocargo ".
				"   SET codasicar='".$as_codasicar."', ".
				"       codtab='".$as_codtab."', ".
       			"       codgra='".$as_codgra."', ".
				"       codpas='".$as_codpas."', ".
				"       codcar='".$as_codcar."', ".
				"       desnom='".$as_desnom."', ".
				"       descar='".$as_descar."', ".
				"       desasicar='".$as_desasicar."', ".
       			"       destab='".$as_destab."' ". 
				" WHERE codemp='".$this->ls_codemp."'".
				"   AND codper='".$as_codper."'".
				"   AND codnom='".$as_codnom."' ".
				" 	AND fecmov='".$ad_fecmov."'"; 
       	$this->io_sql->begin_transaction();
	   	$li_row=$this->io_sql->execute($ls_sql);
		if($li_row===false)
		{
			$lb_valido=false;
        	$this->io_mensajes->message("CLASE->Historico Cargos MÉTODO->uf_update_historicocargos ERROR->".$this->io_funciones->uf_convertirmsg($this->io_sql->message)); 
			$this->io_sql->rollback();
		}
		else
		{
			/////////////////////////////////         SEGURIDAD               /////////////////////////////		
			$ls_evento="UPDATE";
			$ls_descripcion ="Actualizo el Historico Cargos asociado al personal ".$as_codper;
			$lb_valido= $this->io_seguridad->uf_sss_insert_eventos_ventana($aa_seguridad["empresa"],
											$aa_seguridad["sistema"],$ls_evento,$aa_seguridad["logusr"],
											$aa_seguridad["ventanas"],$ls_descripcion);
			/////////////////////////////////         SEGURIDAD               /////////////////////////////	
			if($lb_valido)
			{	
				$this->io_mensajes->message("El Historico Cargos fue Actualizado.");
				$this->io_sql->commit();
			}
			else
			{
				$lb_valido=false;
        		$this->io_mensajes->message("CLASE->Historico Cargos MÉTODO->uf_update_historicocargos ERROR->".$this->io_funciones->uf_convertirmsg($this->io_sql->message)); 
				$this->io_sql->rollback();
			}
		}
		return $lb_valido;
	}// end function uf_update_historicocargos
	//-----------------------------------------------------------------------------------------------------------------------------------

	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_guardar($as_codper,$ad_fecmov,$as_codnom,$as_desnom,$as_codcar,$as_descar,$as_codasicar,$as_desasicar,$as_codtab,$as_destab,
	                    $as_codpas,$as_codgra,$as_existe,$aa_seguridad)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_guardar
		//		   Access: public ()
		//	    Arguments: as_codper  // Codigo del Personal
		//				   aa_seguridad  // arreglo de las variables de seguridad
		//	      Returns: lb_valido True si se ejecuto el grabar o False si hubo error en el grabar
		//	  Description: Funcion que graba en la tabla de Cargos Historicos
		//	   Creado Por: Ing. Yesenia Moreno
		// Fecha Creacion: 01/03/2018 								Fecha Última Modificacion : 
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_valido=false;		
		$ad_fecmov=$this->io_funciones->uf_convertirdatetobd($ad_fecmov);
		switch ($as_existe)
		{
			case "FALSE":
				if($this->uf_select_historicocargos($as_codper,$ad_fecmov,$as_codnom)===false)
				{
						$lb_valido=$this->uf_insert_historicocargos($as_codper,$ad_fecmov,$as_codnom,$as_desnom,$as_codcar,$as_descar,$as_codasicar,
																	$as_desasicar,$as_codtab,$as_destab,$as_codpas,$as_codgra,$aa_seguridad);
				}
				else
				{
					$this->io_mensajes->message("El Historico del cargo ya existe, no lo puede incluir.");
				}
				break;
							
			case "TRUE":
				if(($this->uf_select_historicocargos($as_codper,$ad_fecmov,$as_codnom)))
				{
					$lb_valido=$this->uf_update_historicocargos($as_codper,$ad_fecmov,$as_codnom,$as_desnom,$as_codcar,$as_descar,$as_codasicar,
																$as_desasicar,$as_codtab,$as_destab,$as_codpas,$as_codgra,$aa_seguridad);
				}
				else
				{
					$this->io_mensajes->message("El Historico del cargo no existe, no lo puede actualizar.");
				}
				break;
		}		
		return $lb_valido;
	}// end function uf_guardar
	//-----------------------------------------------------------------------------------------------------------------------------------

	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_delete_sueldoshistorios($as_codper,$ad_fecmov,$as_codnom,$aa_seguridad)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_delete_sueldoshistorios
		//		   Access: public (sigesp_snorh_d_sueldoshistorios)
		//	    Arguments: as_codper  // Codigo del Personal
		//				   aa_seguridad  // arreglo de las variables de seguridad
		//	      Returns: lb_valido True si se ejecuto el delete o False si hubo error en el delete
		//	  Description: Funcion que elimina en la tabla de Historico Cargos
		//	   Creado Por: Ing. Yesenia Moreno
		// Fecha Creacion: 01/03/2018 								Fecha Última Modificacion : 
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_valido=true;
		$ad_fecmov=$this->io_funciones->uf_convertirdatetobd($ad_fecmov);
		$ls_sql="DELETE ".
				"  FROM sno_historicocargo ".
				" WHERE codemp='".$this->ls_codemp."'".
				"   AND codper='".$as_codper."'".
				"   AND codnom='".$as_codnom."'".
				"   AND fecmov='".$ad_fecmov."'";
		$this->io_sql->begin_transaction();
		$li_row=$this->io_sql->execute($ls_sql);
		if($li_row===false)
		{
			$lb_valido=false;
			$this->io_mensajes->message("CLASE->Historico Cargos MÉTODO->uf_delete_historicocargos ERROR->".$this->io_funciones->uf_convertirmsg($this->io_sql->message)); 
			$this->io_sql->rollback();
		}
		else
		{
			/////////////////////////////////         SEGURIDAD               /////////////////////////////		
			$ls_evento="DELETE";
			$ls_descripcion ="Elimino el Historico Cargos asociado al personal ".$as_codper;
			$lb_valido= $this->io_seguridad->uf_sss_insert_eventos_ventana($aa_seguridad["empresa"],
											$aa_seguridad["sistema"],$ls_evento,$aa_seguridad["logusr"],
											$aa_seguridad["ventanas"],$ls_descripcion);
			/////////////////////////////////         SEGURIDAD               /////////////////////////////	
			if($lb_valido)
			{	
				$this->io_mensajes->message("El Historico Cargos fue Eliminado.");
				$this->io_sql->commit();
			}
			else
			{
				$lb_valido=false;
				$this->io_mensajes->message("CLASE->Historico Cargos MÉTODO->uf_delete_historicocargos ERROR->".$this->io_funciones->uf_convertirmsg($this->io_sql->message)); 
				$this->io_sql->rollback();
			}
		}
		return $lb_valido;
    }// end function uf_delete_sueldoshistorios
	//-----------------------------------------------------------------------------------------------------------------------------------
}
?>