<?php
class sigesp_snorh_c_asignacioncargo
{
	var $io_sql;
	var $io_mensajes;
	var $io_funciones;
	var $io_seguridad;
	var $io_personalnomina;
	var $ls_codemp;
	var $ls_codnom;
	
	//-----------------------------------------------------------------------------------------------------------------------------------
	function sigesp_snorh_c_asignacioncargo()
	{	
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: sigesp_snorh_c_asignacioncargo
		//		   Access: public (sigesp_sno_d_asignacioncargo)
		//	  Description: Constructor de la Clase
		//	   Creado Por: Ing. Yesenia Moreno
		// Fecha Creacion: 01/01/2006 								Fecha Última Modificacion : 
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		require_once("../shared/class_folder/sigesp_include.php");
		$io_include=new sigesp_include();
		$io_conexion=$io_include->uf_conectar();
		require_once("../shared/class_folder/class_sql.php");
		$this->io_sql=new class_sql($io_conexion);	
		require_once("../shared/class_folder/class_mensajes.php");
		$this->io_mensajes=new class_mensajes();		
		require_once("../shared/class_folder/class_funciones.php");
		$this->io_funciones=new class_funciones();		
		require_once("../shared/class_folder/sigesp_c_seguridad.php");
		$this->io_seguridad= new sigesp_c_seguridad();
		require_once("sigesp_sno_c_personalnomina.php");
		$this->io_personalnomina=new sigesp_sno_c_personalnomina();
        $this->ls_codemp=$_SESSION["la_empresa"]["codemp"];
		if(array_key_exists("la_nomina",$_SESSION))
		{
        	$this->ls_codnom=$_SESSION["la_nomina"]["codnom"];
		}
		else
		{
			$this->ls_codnom="0000";
		}
	}// end function sigesp_snorh_c_asignacioncargo
	//-----------------------------------------------------------------------------------------------------------------------------------
	
	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_destructor()
	{	
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_destructor
		//		   Access: public (sigesp_sno_d_asignacioncargo)
		//	  Description: Destructor de la Clase
		//	   Creado Por: Ing. Yesenia Moreno
		// Fecha Creacion: 01/01/2006 								Fecha Última Modificacion : 
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		unset($io_include);
		unset($io_conexion);
		unset($this->io_sql);	
		unset($this->io_mensajes);		
		unset($this->io_funciones);		
		unset($this->io_seguridad);
		unset($this->io_personalnomina);
        unset($this->ls_codemp);
        unset($this->ls_codnom);
	}// end function uf_destructor
	//-----------------------------------------------------------------------------------------------------------------------------------

	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_select_asignacioncargo($as_campo,$as_valor,$as_tipo)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_select_asignacioncargo
		//		   Access: public (sigesp_snorh_c_dedicacion)
		//	    Arguments: as_campo  // campo por el cual se quiere filtrar
		//	               as_valor  // valor del campo
		//	               as_tipo  // tipo de llamado si requiere que filtre por la nomina o no
		//	      Returns: lb_existe True si existe o False si no existe
		//	  Description: Funcion que verifica si la asignacion de cargo está registrada
		//	   Creado Por: Ing. Yesenia Moreno
		// Fecha Creacion: 01/01/2006 								Fecha Última Modificacion : 
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe=true;
		$ls_sql="SELECT ".$as_campo." ".
				"  FROM sno_asignacioncargo ".
				" WHERE codemp='".$this->ls_codemp."' ".
				"   AND ".$as_campo."='".$as_valor."' ";
		if($as_tipo=="1")// Requiere que se filtre por la nomina
		{
			$ls_sql=$ls_sql."   AND codnom='".$this->ls_codnom."'";
		}		
		$rs_data=$this->io_sql->select($ls_sql);
		if($rs_data===false)
		{
			$this->io_mensajes->message("CLASE->Asignacion Cargo MÉTODO->uf_select_asignacioncargo ERROR->".$this->io_funciones->uf_convertirmsg($this->io_sql->message)); 
			$lb_existe=false;
		}
		else
		{
			if($rs_data->EOF)
			{
				$lb_existe=false;
			}
			$this->io_sql->free_result($rs_data);		
		}
		return $lb_existe;
	}// end function uf_select_asignacioncargo
	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_select_grado($as_codnom,$as_codgra)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_select_grado
		//		   Access: public (sigesp_snorh_c_dedicacion)
		//	    Arguments: as_campo  // campo por el cual se quiere filtrar
		//	               as_valor  // valor del campo
		//	               as_tipo  // tipo de llamado si requiere que filtre por la nomina o no
		//	      Returns: lb_existe True si existe o False si no existe
		//	  Description: Funcion que verifica si la asignacion de cargo está registrada
		//	   Creado Por: Ing. Yesenia Moreno
		// Fecha Creacion: 01/01/2006 								Fecha Última Modificacion : 
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe=true;
		$ls_sql="SELECT codnom ".
				"  FROM sno_grado ".
				" WHERE codemp='".$this->ls_codemp."' ".
				" AND codnom='".$as_codnom."' ".
				" AND codgra='".$as_codgra."' ";
		$rs_data=$this->io_sql->select($ls_sql);
		if($rs_data===false)
		{
			$this->io_mensajes->message("CLASE->Asignacion Cargo MÉTODO->uf_select_grado ERROR->".$this->io_funciones->uf_convertirmsg($this->io_sql->message)); 
			$lb_existe=false;
		}
		else
		{
			if($rs_data->EOF)
			{
				$lb_existe=false;
			}
			$this->io_sql->free_result($rs_data);		
		}
		return $lb_existe;
	}// end function uf_select_grado
	//-----------------------------------------------------------------------------------------------------------------------------------

	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_insert_asignacioncargo($as_codasicar,$as_denasicar,$as_coduniadm,$as_claasicar,$as_codtab,$as_codpas,$as_codgra,
									   $as_codded,$as_codtipper,$ai_numvacasicar,$ai_numocuasicar,$as_codestpro1,$as_codestpro2,
									   $as_codestpro3,$as_codestpro4,$as_codestpro5,$as_estcla,$as_codgraobrero,$aa_seguridad)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_insert_asignacioncargo
		//		   Access: private
		//	    Arguments: as_codasicar  // Codigo de la asignacion de cargo
		//				   as_denasicar  // Denominacion 
		//				   as_coduniadm  // Codigo de la unidad administrativa
		//				   as_claasicar  // clase
		//				   as_codtab  // Codigo de Tabla
		//				   as_codpas  // Codigo de Paso
		//				   as_codgra  // Codigo de Grado
		//				   as_codded  // Codigo de Dedicacion del personal
		//				   as_codtipper  // Codigo de Tipo de Personal
		//				   ai_numvacasicar  // Número de Vacantes
		//				   ai_numocuasicar  // Número de puestos ocupado
		//				   as_codproasicar  // Codigo Programático
		//				   as_codgraobrero // grado del obrero
		//				   aa_seguridad  // arreglo de seguridad
		//	      Returns: lb_valido True si se ejecuto el insert o False si hubo error en el insert
		//	  Description: Funcion que inserta la asignacion de cargo
		//	   Creado Por: Ing. Yesenia Moreno
		// Fecha Creacion: 01/01/2006 								Fecha Última Modificacion : 
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_valido=true;
		$ls_minorguniadm=substr($as_coduniadm,0,4);
		$ls_ofiuniadm=substr($as_coduniadm,5,2);
		$ls_uniuniadm=substr($as_coduniadm,8,2);
		$ls_depuniadm=substr($as_coduniadm,11,2);
		$ls_prouniadm=substr($as_coduniadm,14,2);
		if ($this->uf_select_grado($this->ls_codnom,$as_codgra))
		{
			$ls_sql="INSERT INTO sno_asignacioncargo (codemp,codnom,codasicar,denasicar,minorguniadm,ofiuniadm,uniuniadm,depuniadm, ".
					"prouniadm,claasicar,codtab,codpas,codgra,codded,codtipper,numvacasicar,numocuasicar,codestpro1,codestpro2,codestpro3,".
					"codestpro4,codestpro5,estcla, grado) VALUES ".
					"('".$this->ls_codemp."','".$this->ls_codnom."','".$as_codasicar."','".$as_denasicar."','".$ls_minorguniadm."',".
					"'".$ls_ofiuniadm."','".$ls_uniuniadm."','".$ls_depuniadm."','".$ls_prouniadm."','".$as_claasicar."','".$as_codtab."',".
					"'".$as_codpas."','".$as_codgra."','".$as_codded."','".$as_codtipper."',".$ai_numvacasicar.",".$ai_numocuasicar.",".
					"'".$as_codestpro1."','".$as_codestpro2."','".$as_codestpro3."','".$as_codestpro4."','".$as_codestpro5."','".$as_estcla."',".
					"'".$as_codgraobrero."')"; 
			$this->io_sql->begin_transaction();
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{
				$lb_valido=false;
				$this->io_mensajes->message("CLASE->Asignacion Cargo MÉTODO->uf_insert_asignacioncargo ERROR->".$this->io_funciones->uf_convertirmsg($this->io_sql->message));
				$this->io_sql->rollback();
			}
			else
			{
				/////////////////////////////////         SEGURIDAD               /////////////////////////////		
				$ls_evento="INSERT";
				$ls_descripcion ="Inserto la Asignacion de Cargo ".$as_codasicar." asociada a la nomina ".$this->ls_codnom;
				$lb_valido= $this->io_seguridad->uf_sss_insert_eventos_ventana($aa_seguridad["empresa"],
												$aa_seguridad["sistema"],$ls_evento,$aa_seguridad["logusr"],
												$aa_seguridad["ventanas"],$ls_descripcion);
				/////////////////////////////////         SEGURIDAD               /////////////////////////////		
				if($lb_valido)
				{	
					$this->io_mensajes->message("La Asignacion de Cargo fue registrada.");
					$this->io_sql->commit();
				}
				else
				{
					$lb_valido=false;
					$this->io_mensajes->message("CLASE->Asignacion Cargo MÉTODO->uf_insert_asignacioncargo ERROR->".$this->io_funciones->uf_convertirmsg($this->io_sql->message));
					$this->io_sql->rollback();
				}
			}
		}
		else
		{
			$lb_valido=false;
			$this->io_mensajes->message("El grado asociado para esta asignacion de cargo no existe para dicha nomina");
		}
		
		return $lb_valido;
	}// end function uf_insert_asignacioncargo
	//-----------------------------------------------------------------------------------------------------------------------------------

	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_update_asignacioncargo($as_codasicar,$as_denasicar,$as_coduniadm,$as_claasicar,$as_codtab,$as_codpas,$as_codgra,
									   $as_codded,$as_codtipper,$ai_numvacasicar,$ai_numocuasicar,$as_codestpro1,$as_codestpro2,
									   $as_codestpro3,$as_codestpro4,$as_codestpro5,$as_coduniadmant,$as_codpasant,$as_codgraant,
									   $as_codtabant,$ai_monsalgra,$as_estcla,$as_codgraobrero,$aa_seguridad)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_update_asignacioncargo
		//		   Access: private
		//	    Arguments: as_codasicar  // Codigo de la asignacion de cargo
		//				   as_denasicar  // Denominacion 
		//				   as_coduniadm  // Codigo de la unidad administrativa
		//				   as_claasicar  // clase
		//				   as_codtab  // Codigo de Tabla
		//				   as_codpas  // Codigo de Paso
		//				   as_codgra  // Codigo de Grado
		//				   as_codded  // Codigo de Dedicacion del personal
		//				   as_codtipper  // Codigo de Tipo de Personal
		//				   ai_numvacasicar  // Número de Vacantes
		//				   ai_numocuasicar  // Número de puestos ocupado
		//				   as_codproasicar  // Codigo Programático
		//				   as_coduniadmant  // Codigo de unidad administrativa anterior
		//				   as_codpasant  // Codigo de Paso anterior
		//				   as_codgraant  // Codigo de Grado anterior
		//				   as_codtabant  // Codigo de Tabulador anterior
		//				   ai_monsalgra  // Codigo del Salario del tabulador
		//				   $as_codgraobrero // grado del obrero
		//				   aa_seguridad  // arreglo de seguridad
		//	      Returns: lb_valido True si se ejecuto el update o False si hubo error en el update
		//	  Description: Funcion que actualiza la asignacion de cargo
		//	   Creado Por: Ing. Yesenia Moreno
		// Fecha Creacion: 01/01/2006 								Fecha Última Modificacion : 
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_valido=true;
		$ls_minorguniadm=substr($as_coduniadm,0,4);
		$ls_ofiuniadm=substr($as_coduniadm,5,2);
		$ls_uniuniadm=substr($as_coduniadm,8,2);
		$ls_depuniadm=substr($as_coduniadm,11,2);
		$ls_prouniadm=substr($as_coduniadm,14,2);
		$ls_sql="UPDATE sno_asignacioncargo ".
				"	SET denasicar = '".$as_denasicar."', ".
				"		minorguniadm = '".$ls_minorguniadm."', ".
				"		ofiuniadm = '".$ls_ofiuniadm."', ".
				"		uniuniadm = '".$ls_uniuniadm."', ".
				"		depuniadm = '".$ls_depuniadm."', ".
				"		prouniadm = '".$ls_prouniadm."', ".
				"		claasicar = '".$as_claasicar."', ".
				"		codtab = '".$as_codtab."', ".
				"		codpas = '".$as_codpas."', ".
				"		codgra = '".$as_codgra."', ".
				"		codded = '".$as_codded."', ".
				"		codtipper = '".$as_codtipper."', ".
				"		codestpro1 = '".$as_codestpro1."', ".
				"		codestpro2 = '".$as_codestpro2."', ".
				"		codestpro3 = '".$as_codestpro3."', ".
				"		codestpro4 = '".$as_codestpro4."', ".
				"		codestpro5 = '".$as_codestpro5."', ".
				"		numvacasicar = ".$ai_numvacasicar.", ".
				"		numocuasicar = ".$ai_numocuasicar.", ".
				"       estcla       = '".$as_estcla."', ".
				"       grado       = '".$as_codgraobrero."' ".
				" WHERE codemp='".$this->ls_codemp."' ".
				"   AND codnom='".$this->ls_codnom."' ".
				"   AND codasicar = '".$as_codasicar."' "; 
		$this->io_sql->begin_transaction()	;
		$li_row=$this->io_sql->execute($ls_sql);
		if($li_row===false)
		{
			$lb_valido=false;
			$this->io_mensajes->message("CLASE->Asignacion Cargo MÉTODO->uf_update_asignacioncargo ERROR->".$this->io_funciones->uf_convertirmsg($this->io_sql->message));
			$this->io_sql->rollback();
		}
		else
		{
			/////////////////////////////////         SEGURIDAD               /////////////////////////////		
			$ls_evento="UPDATE";
			$ls_descripcion ="Actualizo la Asignacion de Cargo ".$as_codasicar." asociada a la nomina ".$this->ls_codnom;
			$lb_valido=$this->io_seguridad->uf_sss_insert_eventos_ventana($aa_seguridad["empresa"],
											$aa_seguridad["sistema"],$ls_evento,$aa_seguridad["logusr"],
											$aa_seguridad["ventanas"],$ls_descripcion);
			/////////////////////////////////         SEGURIDAD               /////////////////////////////		
			if($lb_valido)
			{
				$lb_valido=$this->uf_update_personalnomina($as_codasicar,$as_coduniadm,$as_codtab,$as_codpas,$as_codgra,
														   $as_codded,$as_codtipper,$as_coduniadmant,$as_codpasant,
														   $as_codgraant,$as_codtabant,$ai_monsalgra,$aa_seguridad);
			}
			if($lb_valido)
			{	
				$this->io_mensajes->message("La Asignacion de Cargo fue actualizada.");
				$this->io_sql->commit();
			}
			else
			{
				$lb_valido=false;
				$this->io_mensajes->message("CLASE->Asignacion Cargo MÉTODO->uf_update_asignacioncargo ERROR->".$this->io_funciones->uf_convertirmsg($this->io_sql->message));				$this->io_sql->rollback();
			}
		}
		return $lb_valido;
	}// end function uf_update_asignacioncargo
	//-----------------------------------------------------------------------------------------------------------------------------------

	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_update_personalnomina($as_codasicar,$as_coduniadm,$as_codtab,$as_codpas,$as_codgra,$as_codded,$as_codtipper,
	 								  $as_coduniadmant,$as_codpasant,$as_codgraant,$as_codtabant,$ai_monsalgra,$aa_seguridad)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_update_personalnomina
		//		   Access: private
		//	    Arguments: as_codasicar  // Codigo de Asignacion de cargo
		//				   as_coduniadm  // Codigo de Unidad Administrativa
		//				   as_codtab  // Codigo de Tabulador
		//				   as_codpas  // Codigo de Paso
		//				   as_codgra  // Codigo de Grado
		//				   as_codded  // Codigo de Dedicacion
		//				   as_codtipper  // Codigo de Tipo de Personal
		//				   as_coduniadmant // Codigo de la unidad administrativa Anterior
		//				   as_codpasant  // Codigo de Paso anterior
		//				   as_codgraant  // Codigo de Grado anterior
		//				   as_codtabant  // Codigo de Tabulador anterior
		//				   ai_monsalgra  // Codigo del Salario del tabulador
		//				   aa_seguridad  // arreglo de las variables de seguridad
		//	      Returns: lb_valido True si se ejecuto el update o False si hubo error en el update
		//	  Description: Funcion que actualiza el sueldo en personal nomina a todo personal que tenga asociada esa tabla, paso y grado
		//	   Creado Por: Ing. Yesenia Moreno
		// Fecha Creacion: 01/01/2006 								Fecha Última Modificacion : 
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_valido=true;
		$ls_minorguniadm=substr($as_coduniadm,0,4);
		$ls_ofiuniadm=substr($as_coduniadm,5,2);
		$ls_uniuniadm=substr($as_coduniadm,8,2);
		$ls_depuniadm=substr($as_coduniadm,11,2);
		$ls_prouniadm=substr($as_coduniadm,14,2);
		$ls_minorguniadmant=substr($as_coduniadmant,0,4);
		$ls_ofiuniadmant=substr($as_coduniadmant,5,2);
		$ls_uniuniadmant=substr($as_coduniadmant,8,2);
		$ls_depuniadmant=substr($as_coduniadmant,11,2);
		$ls_prouniadmant=substr($as_coduniadmant,14,2);
		$lb_actualizar=false;
		if($as_codtabant!=$as_codtab)
		{
			$ls_sql="UPDATE sno_personalnomina ".
					"	SET codtab = '".$as_codtab."', ".
					"		codpas = '".$as_codpas."', ".
					"		codgra = '".$as_codgra."', ".
					"		codded = '".$as_codded."', ".
					"		codtipper = '".$as_codtipper."', ".
					"		sueper = ".$ai_monsalgra." ".
					" WHERE codemp = '".$this->ls_codemp."' ".
					"   AND codnom = '".$this->ls_codnom."' ".
					"   AND codasicar = '".$as_codasicar."' ";
		}
		else
		{
			$lb_actualizar=true;
			$ls_sql="UPDATE sno_personalnomina ".
					"	SET codtab = '".$as_codtab."', ".
					"		codded = '".$as_codded."', ".
					"		codtipper = '".$as_codtipper."' ".
					" WHERE codemp = '".$this->ls_codemp."' ".
					"   AND codnom = '".$this->ls_codnom."' ".
					"   AND codasicar = '".$as_codasicar."' ";
		}
		$li_row=$this->io_sql->execute($ls_sql);
		if($li_row===false)
		{
			$lb_valido=false;
			$this->io_mensajes->message("CLASE->Asignacion Cargo MÉTODO->uf_update_personalnomina ERROR->".$this->io_funciones->uf_convertirmsg($this->io_sql->message)); 
		} 		
		if($lb_valido)
		{
			$ls_sql="UPDATE sno_personalnomina ".
					"	SET minorguniadm = '".$ls_minorguniadm."', ".
					"		ofiuniadm = '".$ls_ofiuniadm."', ".
					"		uniuniadm = '".$ls_uniuniadm."', ".
					"		depuniadm = '".$ls_depuniadm."', ".
					"		prouniadm = '".$ls_prouniadm."' ".
					" WHERE codemp='".$this->ls_codemp."' ".
					"   AND codnom='".$this->ls_codnom."' ".
					"   AND codasicar='".$as_codasicar."' ".
					"	AND minorguniadm = '".$ls_minorguniadmant."' ".
					"	AND	ofiuniadm = '".$ls_ofiuniadmant."' ".
					"	AND	uniuniadm = '".$ls_uniuniadmant."' ".
					"	AND	depuniadm = '".$ls_depuniadmant."' ".
					"	AND	prouniadm = '".$ls_prouniadmant."' ";
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{
				$lb_valido=false;
				$this->io_mensajes->message("CLASE->Asignacion Cargo MÉTODO->uf_update_personalnomina ERROR->".$this->io_funciones->uf_convertirmsg($this->io_sql->message)); 
			} 		
		}
		if(($lb_valido)&&($lb_actualizar))
		{
			$ls_sql="UPDATE sno_personalnomina ".
					"	SET codpas = '".$as_codpas."', ".
					"		codgra = '".$as_codgra."', ".
					"		sueper = ".$ai_monsalgra." ".
					" WHERE codemp = '".$this->ls_codemp."' ".
					"   AND codnom = '".$this->ls_codnom."' ".
					"   AND codasicar = '".$as_codasicar."' ".
					"   AND codtab = '".$as_codtab."' ".
					"	AND codpas = '".$as_codpasant."' ".
					"	AND	codgra = '".$as_codgraant."' ";
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{
				$lb_valido=false;
				$this->io_mensajes->message("CLASE->Asignacion Cargo MÉTODO->uf_update_personalnomina ERROR->".$this->io_funciones->uf_convertirmsg($this->io_sql->message)); 
			} 		
		}
		if($lb_valido)
		{
			/////////////////////////////////         SEGURIDAD               /////////////////////////////		
			$ls_evento="UPDATE";
			$ls_descripcion ="Actualizo Unidad administrativa, Tabla, Paso, Grado, Dedicacion y Tipo Personal ".
							 " del personal nomina que esté asociado a la unidad administrativa ".$as_coduniadm.", nomina ".$this->ls_codnom;
			$lb_valido= $this->io_seguridad->uf_sss_insert_eventos_ventana($aa_seguridad["empresa"],
											$aa_seguridad["sistema"],$ls_evento,$aa_seguridad["logusr"],
											$aa_seguridad["ventanas"],$ls_descripcion);
			/////////////////////////////////         SEGURIDAD               /////////////////////////////		
		}
		return $lb_valido;
	}// end function uf_update_personalnomina
	//-----------------------------------------------------------------------------------------------------------------------------------

	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_guardar($as_existe,$as_codasicar,$as_denasicar,$as_coduniadm,$as_claasicar,$as_codtab,$as_codpas,$as_codgra,$as_codded,
						$as_codtipper,$ai_numvacasicar,$ai_numocuasicar,$as_codestpro1,$as_codestpro2,$as_codestpro3,$as_codestpro4,$as_codestpro5,
						$as_coduniadmant,$as_codpasant,$as_codgraant,$as_codtabant,$ai_monsalgra,$as_estcla,$as_codnom,$as_codgraobrero,$aa_seguridad)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_guardar
		//		   Access: public (sigesp_sno_d_asignacioncargo)
		//	    Arguments: as_codasicar  // Codigo de la asignacion de cargo
		//				   as_denasicar  // Denominacion 
		//				   as_coduniadm  // Codigo de la unidad administrativa
		//				   as_claasicar  // clase
		//				   as_codtab  // Codigo de Tabla
		//				   as_codpas  // Codigo de Paso
		//				   as_codgra  // Codigo de Grado
		//				   as_codded  // Codigo de Dedicacion del personal
		//				   as_codtipper  // Codigo de Tipo de Personal
		//				   ai_numvacasicar  // Número de Vacantes
		//				   ai_numocuasicar  // Número de puestos ocupado
		//				   as_codproasicar  // Codigo Programático
		//				   as_coduniadmant  // Codigo de la unidad administrativa anterior
		//				   as_codpasant  // Codigo de Paso anterior
		//				   as_codgraant  // Codigo de Grado anterior
		//				   as_codtabant  // Codigo de Tabulador anterior
		//				   ai_monsalgra  // Codigo del Salario del tabulador,
		//				   as_codgraobrero // grado del obrero
		//				   aa_seguridad  // arreglo de seguridad
		//	      Returns: lb_valido True si se ejecuto el guardar o False si hubo error en el guardar
		//	  Description: Funcion que guarda la asignacion de cargo
		//	   Creado Por: Ing. Yesenia Moreno
		// Fecha Creacion: 01/01/2006 								Fecha Última Modificacion : 
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_valido=false;		
		$ai_monsalgra=str_replace(".","",$ai_monsalgra);
		$ai_monsalgra=str_replace(",",".",$ai_monsalgra);
		$this->ls_codnom=$as_codnom;
		switch ($as_existe)
		{
			case "FALSE":
				if(!($this->uf_select_asignacioncargo("codasicar",$as_codasicar,"1")))
				{
					$lb_valido=$this->uf_insert_asignacioncargo($as_codasicar,$as_denasicar,$as_coduniadm,$as_claasicar,$as_codtab,
																$as_codpas,$as_codgra,$as_codded,$as_codtipper,$ai_numvacasicar,
																$ai_numocuasicar,$as_codestpro1,$as_codestpro2,$as_codestpro3,$as_codestpro4,
																$as_codestpro5,$as_estcla,$as_codgraobrero,$aa_seguridad);
				}
				else
				{
					$this->io_mensajes->message("La Asignacion de Cargo ya existe, no la puede incluir");
				}
				break;
				
			case "TRUE":
				if(($this->uf_select_asignacioncargo("codasicar",$as_codasicar,"1")))
				{   
					$lb_valido=$this->uf_update_asignacioncargo($as_codasicar,$as_denasicar,$as_coduniadm,$as_claasicar,$as_codtab,
																$as_codpas,$as_codgra,$as_codded,$as_codtipper,$ai_numvacasicar,
																$ai_numocuasicar,$as_codestpro1,$as_codestpro2,$as_codestpro3,$as_codestpro4,
																$as_codestpro5,$as_coduniadmant,$as_codpasant,$as_codgraant,$as_codtabant,
																$ai_monsalgra,$as_estcla,$as_codgraobrero,$aa_seguridad);
				}
				else
				{
					$this->io_mensajes->message("La Asignacion de Cargo no existe, no la puede actualizar");
				}
				break;
		}
		return $lb_valido;
	}// end function uf_guardar
	//-----------------------------------------------------------------------------------------------------------------------------------

	//-----------------------------------------------------------------------------------------------------------------------------------
    function uf_delete_asignacioncargo($as_codasicar,$as_codnom,$aa_seguridad)
    {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_delete_asignacioncargo
		//		   Access: public (sigesp_sno_d_asignacioncargo)
		//	    Arguments: as_codasicar  // Codigo de la asignacion de cargo
		//				   aa_seguridad  // arreglo de las variables de seguridad
		//	      Returns: lb_valido True si se ejecuto el delete o False si hubo error en el delete
		//	  Description: Funcion que elimina la asignacion de cargo
		//	   Creado Por: Ing. Yesenia Moreno
		// Fecha Creacion: 01/01/2006 								Fecha Última Modificacion : 
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_valido=true;
		$this->ls_codnom=$as_codnom;
		$_SESSION["la_nomina"]["codnom"]=$as_codnom;
		$_SESSION["la_nomina"]["anocurnom"]="1";
		$_SESSION["la_nomina"]["peractnom"]="1";
        if (($this->io_personalnomina->uf_select_personalnomina("codasicar",$as_codasicar,"1")===false)&&
		    ($this->uf_select_codigo_unico_rac_eliminar("codasicar",$as_codasicar,"sno_codigounicorac")===false))   
		{
			$ls_sql="DELETE ".
					"  FROM sno_asignacioncargo ".
					" WHERE codemp='".$this->ls_codemp."' ".
					"   AND codnom='".$this->ls_codnom."' ".
					"   AND codasicar='".$as_codasicar."' ";
					
        	$this->io_sql->begin_transaction();
		   	$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{
				$lb_valido=false;
				$this->io_mensajes->message("CLASE->Asignacion Cargo MÉTODO->uf_delete_asignacioncargo ERROR->".$this->io_funciones->uf_convertirmsg($this->io_sql->message));				
				$this->io_sql->rollback();
			}
			else
			{
				/////////////////////////////////         SEGURIDAD               /////////////////////////////		
				$ls_evento="DELETE";
				$ls_descripcion ="Elimino la Asignacion de Cargo ".$as_codasicar." asociada a la nomina ".$this->ls_codnom;
				$lb_valido= $this->io_seguridad->uf_sss_insert_eventos_ventana($aa_seguridad["empresa"],
												$aa_seguridad["sistema"],$ls_evento,$aa_seguridad["logusr"],
												$aa_seguridad["ventanas"],$ls_descripcion);
				/////////////////////////////////         SEGURIDAD               /////////////////////////////		
				if($lb_valido)
				{	
					$this->io_mensajes->message("La Asignacion de Cargo fue Eliminada.");
					$this->io_sql->commit();
				}
				else
				{
					$lb_valido=false;
					$this->io_mensajes->message("CLASE->Asignacion Cargo MÉTODO->uf_delete_asignacioncargo ERROR->".$this->io_funciones->uf_convertirmsg($this->io_sql->message));
					$this->io_sql->rollback();
				}
			}
		} 
		else
		{
			$this->io_mensajes->message("No se puede eliminar la Asignacion de Cargo, existe personal o Codigos únicos de rac asociados a ella.");
		}       
		unset($_SESSION["la_nomina"]);
		return $lb_valido;
    }// end function uf_delete_asignacioncargo
	//-----------------------------------------------------------------------------------------------------------------------------------

	//--------------------------------------------------------------
	function uf_cargarnomina($as_codnom)
	{
		//////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_cargarnomina
		//		   Access: private
		//	  Description: Funcion que obtiene todas las nominas y las carga en un 
		//				   combo para seleccionarlas
		//	   Creado Por: Ing. Yesenia Moreno
		// Fecha Creacion: 15/02/2008 								Fecha Última Modificacion : 
		//////////////////////////////////////////////////////////////////////////////
		switch($as_codnom)
		{
			case "":
				$ls_selected="selected";
				$ls_disabled="";
				break;
			default:
				$ls_selected="";
				$ls_disabled="disabled";
				break;
		}
		$ls_sql="SELECT sno_nomina.codnom, MAX(sno_nomina.desnom) AS desnom, MAX(sno_nomina.tipnom) AS tipnom, MAX(sno_nomina.racnom) AS racnom, MAX(sno_nomina.racobrnom) AS racobrnom  ".
				"  FROM sno_nomina, sss_permisos_internos ".
				" WHERE sno_nomina.codemp='".$this->ls_codemp."'".
				"   AND sss_permisos_internos.codsis='SNO'".
				"   AND sss_permisos_internos.enabled=1".
				"   AND sss_permisos_internos.codusu='".$_SESSION["la_logusr"]."'".
				"   AND sno_nomina.codemp = sss_permisos_internos.codemp ".
				"   AND sno_nomina.codnom = sss_permisos_internos.codintper ".
				" GROUP BY sno_nomina.codnom   ".
				" ORDER BY sno_nomina.codnom  "; 
		$rs_data=$this->io_sql->select($ls_sql);
		print "<select name='cmbnomina' id='cmbnomina' style='width:380px' ".$ls_disabled.">";
		print " <option value='' ".$ls_selected.">--Seleccione Una--</option>";
		if($rs_data===false)
		{
			$io_mensajes->message("Clase->Seleccionar Nomina Método->uf_cargarnomina Error->".$io_funciones->uf_convertirmsg($this->io_sql->message)); 
		}
		else
		{
			while(!$rs_data->EOF)
			{
				$ls_codnom=$rs_data->fields["codnom"];
				$ls_desnom=$rs_data->fields["desnom"];
				$as_tipnom=$rs_data->fields["tipnom"]; 
				$as_racnom=$rs_data->fields["racnom"]; 
				$as_racobrnom=$rs_data->fields["racobrnom"]; 
				$ls_selected="";
				if($as_codnom==$ls_codnom)
				{
					$ls_selected="selected";
				}
				print "<option value='".$ls_codnom."' ".$ls_selected." onClick=javascript:ue_select_nom('$as_tipnom','$as_racnom','$as_racobrnom') >".$ls_codnom."-".$ls_desnom."</option>";				
				$rs_data->MoveNext();
			}
			$this->io_sql->free_result($rs_data);
		}
		print "</select>";
		print "<input name='txtcodnom' type='hidden' id='txtcodnom' value='".$as_codnom."'>";
	}
	//-----------------------------------------------------------------------------------------------------------------------------------
	
	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_load_codigo_unico_rac($as_codasicar,$as_codnom,$ai_totrows,$ao_object)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_load_codigo_unico_rac
		//	    Arguments: as_codasicar  // Codigo de la asignacion de cargo
		//                 as_codnom    //  Codigo de la nomina
		//				   ai_totrows  // total de fila
		//				   ao_object  // arreglo de objetos
		//	      Returns: lb_valido True si se encontro o False si no se encontro
		//	  Description: Funcion que obtiene todas las Codigos únicos de rac de la asignacion de cargo seleccionada
		//	   Creado Por: Ing. María Beatriz Unda
		// Fecha Creacion: 03/11/2008 								Fecha Última Modificacion : 
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_valido=true;
		$this->ls_codnom=$as_codnom;
		$ls_sql="SELECT * ".
				"  FROM sno_codigounicorac ".
				" WHERE codemp='".$this->ls_codemp."'".
				"   AND codnom='".$as_codnom."'".
				"   AND codasicar='".$as_codasicar."'";				
				
		$rs_data=$this->io_sql->select($ls_sql);
		if($rs_data===false)
		{
			$lb_valido=false;
			$this->io_mensajes->message("CLASE->Asignacion Cargo MÉTODO->uf_load_codigo_unico_rac ERROR->".$this->io_funciones->uf_convertirmsg($this->io_sql->message)); 
		}
		else
		{
			$ai_totrows=0;
			while(!$rs_data->EOF)
			{
				$ai_totrows=$ai_totrows+1;
				$ls_codunirac=$rs_data->fields["codunirac"];				
				if ($rs_data->fields["estcodunirac"]=='1')
				{
					$ls_estcodunirac="OCUPADO";
				}
				else
				{
					$ls_estcodunirac="DISPONIBLE";
				}
				
				$ao_object[$ai_totrows][1]="<input name=txtcodunirac".$ai_totrows." type=text id=txtcodunirac".$ai_totrows." class=sin-borde size=10 maxlength=10 onKeyUp='javascript: ue_validarnumero(this);' value='".$ls_codunirac."' readOnly>";
				$ao_object[$ai_totrows][2]="<input name=txtestcod".$ai_totrows." type=text id=txtestcod".$ai_totrows." class=sin-borde size=10 maxlength=20 value='".$ls_estcodunirac."' readOnly>";
				$ao_object[$ai_totrows][3]="<a href=javascript:uf_agregar_dt(".$ai_totrows.");><img src=../shared/imagebank/tools15/aprobado.gif alt=Aceptar width=15 height=15 border=0></a>";
				$ao_object[$ai_totrows][4]="<a href=javascript:uf_delete_dt(".$ai_totrows.");><img src=../shared/imagebank/tools15/deshacer.gif alt=Deshacer width=15 height=15 border=0></a>";			
				$rs_data->MoveNext();
			}
			$ai_totrows=$ai_totrows+1;
			$ao_object[$ai_totrows][1]="<input name=txtcodunirac".$ai_totrows." type=text id=txtcodunirac".$ai_totrows." class=sin-borde size=10 maxlength=10 onKeyUp='javascript: ue_validarnumero(this);'>";
			$ao_object[$ai_totrows][2]="<input name=txtestcod".$ai_totrows." type=text id=txtestcod".$ai_totrows." class=sin-borde size=10 maxlength=20 readOnly>";
			$ao_object[$ai_totrows][3]="<a href=javascript:uf_agregar_dt(".$ai_totrows.");><img src=../shared/imagebank/tools15/aprobado.gif alt=Aceptar width=15 height=15 border=0></a>";
			$ao_object[$ai_totrows][4]="<a href=javascript:uf_delete_dt(".$ai_totrows.");><img src=../shared/imagebank/tools15/deshacer.gif alt=Deshacer width=15 height=15 border=0></a>";			
			$this->io_sql->free_result($rs_data);	
		}
		$arrResultado['ai_totrows']=$ai_totrows;
		$arrResultado['ao_object']=$ao_object;
		$arrResultado['lb_valido']=$lb_valido;
		return $arrResultado;						
	}// end function uf_load_codigo_unico_rac
	//-----------------------------------------------------------------------------------------------------------------------------------

	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_select_codigo_unico_rac($as_codasicar,$as_codunirac)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_select_codigo_unico_rac
		//		   Access: private
		//	    Arguments: as_codnom // Codigo de la nomina
		//				   as_codasicar  // Codigo de la asignacion de cargo
		//				   as_codunirac  // Codigo de único de rac
		//	      Returns: lb_existe True si se encontro o False si no se encontro
		//	  Description: Funcion que verifica si el Codigo único de rac está registrado
		//	   Creado Por: Ing. María Beatriz Unda
		// Fecha Creacion: 03/11/2008 								Fecha Última Modificacion : 		
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe=true;	
		$as_codasicar="";
		$ls_sql="SELECT codunirac,codasicar ".
				"  FROM sno_codigounicorac ".
				" WHERE codemp='".$this->ls_codemp."'".				
				"   AND codunirac='".$as_codunirac."'";
		$rs_data=$this->io_sql->select($ls_sql);
		if($rs_data===false)
		{
			$this->io_mensajes->message("CLASE->Asignacion Cargo MÉTODO->uf_select_codigo_unico_rac ERROR->".$this->io_funciones->uf_convertirmsg($this->io_sql->message)); 
			$lb_existe=false;
		}
		else
		{
			if(!$rs_data->EOF)
			{
				$as_codasicar=$row["codasicar"];
				
			}
			else
			{
				$lb_existe=false;
			}
			$this->io_sql->free_result($rs_data);	
		}
		$arrResultado['as_codasicar']=$as_codasicar;
		$arrResultado['lb_existe']=$lb_existe;
		return $arrResultado;						
	}// end function uf_select_codigo_unico_rac
	//-----------------------------------------------------------------------------------------------------------------------------------	
	
	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_insert_codigo_unico_rac($as_codnom,$as_codasicar,$as_codunirac,$aa_seguridad)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_insert_codigo_unico_rac
		//		   Access: private
		//	    Arguments: as_codnom // Codigo de la nomina
		//				   as_codasicar  // Codigo de la asignacion de cargo
		//				   as_codunirac  // Codigo de único de rac
		//				   aa_seguridad  // arreglo de las variables de seguridad
		//	      Returns: lb_valido True si se ejecuto el insert o False si hubo error en el insert
		//	  Description: Funcion que inserta en la tabla de sno_codigounicorac
		//	   Creado Por: Ing. María Beatriz Unda
		// Fecha Creacion: 03/11/2008 								Fecha Última Modificacion : 		
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_valido=true;
		$ls_sql="INSERT INTO sno_codigounicorac (codemp,codnom,codasicar,codunirac,estcodunirac)VALUES".
				"('".$this->ls_codemp."','".$as_codnom."','".$as_codasicar."','".$as_codunirac."','0')";
		$li_row=$this->io_sql->execute($ls_sql);
		if($li_row===false)
		{
 			$lb_valido=false;
			$this->io_mensajes->message("CLASE->Asignacion Cargo MÉTODO->uf_insert_codigo_unico_rac ERROR->".$this->io_funciones->uf_convertirmsg($this->io_sql->message)); 
		}
		else
		{
			/////////////////////////////////         SEGURIDAD               /////////////////////////////		
			$ls_evento="INSERT";
			$ls_descripcion ="Inserto el codigo unico de rac ".$as_codunirac." de la asignacion de cardo ".$as_codasicar."  ".
			                  " asociado a la nomina ".$as_codnom;
			$lb_valido= $this->io_seguridad->uf_sss_insert_eventos_ventana($aa_seguridad["empresa"],
											$aa_seguridad["sistema"],$ls_evento,$aa_seguridad["logusr"],
											$aa_seguridad["ventanas"],$ls_descripcion);
			/////////////////////////////////         SEGURIDAD               /////////////////////////////		
		}
		return $lb_valido;
	}// end function uf_insert_codigo_unico_rac
	//-----------------------------------------------------------------------------------------------------------------------------------

	//-----------------------------------------------------------------------------------------------------------------------------------
    function uf_delete_codigo_unico_rac($as_codnom,$as_codasicar,$as_codunirac,$aa_seguridad)
    {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_delete_codigo_unico_rac
		//		   Access: private
		//	    Arguments: as_codnom // Codigo de la nomina
		//				   as_codasicar  // Codigo de la asignacion de cargo
		//				   as_codunirac  // Codigo de único de rac
		//				   aa_seguridad  // arreglo de las variables de seguridad
		//	      Returns: lb_valido True si se ejecuto el delete o False si hubo error en el delete
		//	  Description: Funcion que elimina los Codigos únicos de rac de la tabla sno_codigounicorac
		//	   Creado Por: Ing. María Beatriz Unda
		// Fecha Creacion: 03/11/2008 								Fecha Última Modificacion : 		
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_valido=false;
		 if ($this->uf_select_codigo_unico_rac_eliminar("codunirac",$as_codunirac,"sno_personalnomina")===false)   
		{
			$this->ls_codnom=$as_codnom;
			$ls_sql="DELETE ".
					"  FROM sno_codigounicorac ".
					" WHERE codemp='".$this->ls_codemp."'".
					"   AND codnom='".$as_codnom."'".
					"   AND codasicar='".$as_codasicar."'".
					"   AND codunirac='".$as_codunirac."'";
			$this->io_sql->begin_transaction();
			$li_row=$this->io_sql->execute($ls_sql);
			if($li_row===false)
			{
				$lb_valido=false;
				$this->io_mensajes->message("CLASE->Asignacion Cargo MÉTODO->uf_delete_codigo_unico_rac ERROR->".$this->io_funciones->uf_convertirmsg($this->io_sql->message)); 
				$this->io_sql->rollback();
			}
			else
			{
				/////////////////////////////////         SEGURIDAD               /////////////////////////////		
				$ls_evento="DELETE";
				$ls_descripcion ="Elimino el codigo unico de rac ".$as_codunirac." de la asignacion de cardo ".$as_codasicar."  ".
								  " asociado a la nomina ".$as_codnom;
				$lb_valido= $this->io_seguridad->uf_sss_insert_eventos_ventana($aa_seguridad["empresa"],
												$aa_seguridad["sistema"],$ls_evento,$aa_seguridad["logusr"],
												$aa_seguridad["ventanas"],$ls_descripcion);
				/////////////////////////////////         SEGURIDAD               /////////////////////////////		
				if($lb_valido)
				{	
					$this->io_mensajes->message("El Codigo Único fue Eliminado.");
					$this->io_sql->commit();
				}
				else
				{
					$lb_valido=false;
					$this->io_mensajes->message("CLASE->Asignacion Cargo MÉTODO->uf_delete_codigo_unico_rac ERROR->".$this->io_funciones->uf_convertirmsg($this->io_sql->message)); 
					$this->io_sql->rollback();
				}
			}			
		}
		else
		{
			$this->io_mensajes->message("El Codigo Único no se puede eliminar porque está asociado a un personal.");
			$lb_valido=false;
		}
		return $lb_valido;
	}// end function uf_delete_codigo_unico_rac
	//-----------------------------------------------------------------------------------------------------------------------------------	

	//-----------------------------------------------------------------------------------------------------------------------------------	
    function uf_update_estatus_codigo_unico_rac($as_codper,$as_valor,$aa_seguridad)
    {
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_update_estatus_codigo_unico_rac
		//		   Access: private
		//	    Arguments: as_codper // Codigo del personal
		//                 as_valor  // valor para actualizar
		//	      Returns: lb_valido True si se ejecuto el delete o False si hubo error en el delete
		//	  Description: Funcion que actualiza el estatus de  los Codigos únicos de rac de la tabla sno_codigounicorac
		//                 al egeresar un personal      
		//	   Creado Por: Ing. María Beatriz Unda
		// Fecha Creacion: 03/11/2008 								Fecha Última Modificacion : 		
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_valido=true;
		$ls_sql="UPDATE sno_codigounicorac ".
				"   SET estcodunirac='".$as_valor."' ".
				" WHERE codemp='".$this->ls_codemp."' ".								
				"   AND codunirac IN (SELECT sno_personalnomina.codunirac ".
				"					   FROM sno_personalnomina ".
				" 						WHERE sno_personalnomina.codemp='".$this->ls_codemp."' ".
				"                         AND sno_personalnomina.codper='".$as_codper."' ".
				"                         AND sno_personalnomina.codemp=sno_codigounicorac.codemp ".
				"                         AND sno_personalnomina.codnom=sno_codigounicorac.codnom ".
				"                         AND sno_personalnomina.codasicar=sno_codigounicorac.codasicar ".
				"                         AND sno_personalnomina.codunirac=sno_codigounicorac.codunirac)";
					
		$li_row=$this->io_sql->execute($ls_sql);
		if($li_row===false)
		{
			$lb_valido=false;
			$this->io_mensajes->message("CLASE->Asignacion Cargo MÉTODO->uf_update_estcodunirac ERROR->".$this->io_funciones->uf_convertirmsg($this->io_sql->message));
		}
		else
		{
			
				/////////////////////////////////         SEGURIDAD               /////////////////////////////		
				$ls_evento="UPDATE";
				$ls_descripcion ="Actualizo el estado de los Codigos único de RAC asociados a la asignacion de cargo asociado a la nomina ".$this->ls_codnom;
				$lb_valido= $this->io_seguridad->uf_sss_insert_eventos_ventana($aa_seguridad["empresa"],
												$aa_seguridad["sistema"],$ls_evento,$aa_seguridad["logusr"],
												$aa_seguridad["ventanas"],$ls_descripcion);
				/////////////////////////////////         SEGURIDAD               /////////////////////////////		
			
		}
		return $lb_valido;
	}// end function uf_update_estatus_codigo_unico_rac
	//-----------------------------------------------------------------------------------------------------------------------------------	

	//-----------------------------------------------------------------------------------------------------------------------------------	
	function uf_select_estatus_codigo_unico_rac($as_codunirac)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_select_estatus_codigo_unico_rac
		//		   Access: private
		//	    Arguments: as_codnom // Codigo de la nomina
		//				   as_codasicar  // Codigo de la asignacion de cargo
		//				   as_codunirac  // Codigo de único de rac
		//	      Returns: lb_existe True si se encontro o False si no se encontro
		//	  Description: Funcion que verifica si el estado del Codigo único de rac
		//	   Creado Por: Ing. María Beatriz Unda
		// Fecha Creacion: 03/11/2008 								Fecha Última Modificacion : 		
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe=true;	
		$ls_estcodunirac="";
		$ls_sql="SELECT estcodunirac ".
				"  FROM sno_codigounicorac ".
				" WHERE codemp='".$this->ls_codemp."'".				
				"   AND codunirac='".$as_codunirac."'";

		$rs_data=$this->io_sql->select($ls_sql);
		if($rs_data===false)
		{
			$this->io_mensajes->message("CLASE->Asignacion Cargo MÉTODO->uf_select_estatus_codigo_unico_rac ERROR->".$this->io_funciones->uf_convertirmsg($this->io_sql->message)); 
			$lb_existe=false;
		}
		else
		{
			if(!$rs_data->EOF)
			{
				$ls_estcodunirac=$row["estcodunirac"];
				
			}
			else
			{
				$lb_existe=false;
			}
			$this->io_sql->free_result($rs_data);	
		}
		return $ls_estcodunirac;
	}// end function uf_select_estatus_codigo_unico_rac
	//-----------------------------------------------------------------------------------------------------------------------------------		

	//-----------------------------------------------------------------------------------------------------------------------------------		
	function uf_select_codigo_unico_rac_eliminar($as_campo,$as_valor,$as_tabla)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_select_codigo_unico_rac_eliminar
		//		   Access: private
		//	    Arguments: as_campo // campo con el cual se va a seleccionar el codunirac
		//				   as_valor  // valor con el cual se va a comparar el campo
		//                 as_tabla // tabla donde se va a buscar el codunirac
		//	      Returns: lb_existe True si se encontro o False si no se encontro
		//	  Description: Funcion que verifica si el Codigo único de rac está registrado
		//	   Creado Por: Ing. María Beatriz Unda
		// Fecha Creacion: 03/11/2008 								Fecha Última Modificacion : 		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_existe=true;	
		$as_codasicar="";
		$ls_sql="SELECT ".$as_campo." ".
				"  FROM ".$as_tabla." ".
				" WHERE codemp='".$this->ls_codemp."'".				
				"   AND ".$as_campo."='".$as_valor."'";
		$rs_data=$this->io_sql->select($ls_sql);
		if($rs_data===false)
		{
			$this->io_mensajes->message("CLASE->Asignacion Cargo MÉTODO->uf_select_codigo_unico_rac_eliminar ERROR->".$this->io_funciones->uf_convertirmsg($this->io_sql->message)); 
			$lb_existe=false;
		}
		else
		{
			if(!$rs_data->EOF)
			{
				$as_codasicar=$row["codasicar"];
				
			}
			else
			{
				$lb_existe=false;
			}
			$this->io_sql->free_result($rs_data);	
		}
		return $lb_existe;
	}// end function uf_select_codigo_unico_rac_eliminar
	//-----------------------------------------------------------------------------------------------------------------------------------	


	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_actualizarocupados($as_codasicar,$as_codnom,$aa_seguridad)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//	     Function: uf_actualizarocupados
		//		   Access: private
		//	    Arguments: as_codasicar  // Codigo de la asignacion de cargo
		//				   as_codnom  // Codigo de Nomina
		//				   aa_seguridad  // arreglo de seguridad
		//	      Returns: lb_valido True si se ejecuto el update o False si hubo error en el update
		//	  Description: Funcion que actualiza la asignacion de cargo
		//	   Creado Por: Ing. Yesenia Moreno
		// Fecha Creacion: 01/01/2006 								Fecha Última Modificacion : 
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$lb_valido=true;
		$ls_sql="UPDATE sno_asignacioncargo ".
				"	SET numocuasicar =  (SELECT COUNT(codasicar) ".
				"                          FROM sno_personalnomina ".
				"                         WHERE codemp='".$this->ls_codemp."' ".
				"                           AND codnom='".$as_codnom."' ".
				"                           AND codasicar = '".$as_codasicar."') ".
				" WHERE codemp='".$this->ls_codemp."' ".
				"   AND codnom='".$as_codnom."' ".
				"   AND codasicar = '".$as_codasicar."' "; 
		$this->io_sql->begin_transaction()	;
		$li_row=$this->io_sql->execute($ls_sql);
		if($li_row===false)
		{
			$lb_valido=false;
			$this->io_mensajes->message("CLASE->Asignacion Cargo MÉTODO->uf_actualizarocupados ERROR->".$this->io_funciones->uf_convertirmsg($this->io_sql->message));
			$this->io_sql->rollback();
		}
		else
		{
			/////////////////////////////////         SEGURIDAD               /////////////////////////////		
			$ls_evento="UPDATE";
			$ls_descripcion ="Actualizo el nro de ocupados de  la Asignacion de Cargo ".$as_codasicar." asociada a la nomina ".$as_codnom;
			$lb_valido=$this->io_seguridad->uf_sss_insert_eventos_ventana($aa_seguridad["empresa"],
											$aa_seguridad["sistema"],$ls_evento,$aa_seguridad["logusr"],
											$aa_seguridad["ventanas"],$ls_descripcion);
			/////////////////////////////////         SEGURIDAD               /////////////////////////////		
			if($lb_valido)
			{	
				$this->io_mensajes->message("El nro de ocupados de la Asignacion de Cargo fue actualizada.");
				$this->io_sql->commit();
			}
			else
			{
				$lb_valido=false;
				$this->io_mensajes->message("CLASE->Asignacion Cargo MÉTODO->uf_actualizarocupados ERROR->".$this->io_funciones->uf_convertirmsg($this->io_sql->message));				$this->io_sql->rollback();
			}
		}
		return $lb_valido;
	}// end function uf_actualizarocupados
	//-----------------------------------------------------------------------------------------------------------------------------------

}//fin de la clase sigesp_snorh_c_asignacioncargo
?>