<?php
    session_start();   
	header("Pragma: public");
	header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
	header("Cache-Control: private",false);
	if(!array_key_exists("la_logusr",$_SESSION))
	{
		print "<script language=JavaScript>";
		print "close();";
		print "opener.document.form1.submit();";		
		print "</script>";		
	}
	
	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_insert_seguridad($as_titulo,$as_rango)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_insert_seguridad
		//		   Access: private 
		//	    Arguments: as_titulo // Ttulo del reporte
		//	    		   as_desnom // descripcion de la nomina
		//	    		   as_periodo // Periodo actual de la nomina
		//    Description: funcion que guarda la seguridad de quien Genero el Reporte
		//	   Creado Por: Ing. Yesenia Moreno
		// Fecha Creacion: 27/04/2006 
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_fun_nomina;
		$ls_descripcion="Genero el Reporte ".$as_titulo.". Para ".$as_rango." ";
		$lb_valido=$io_fun_nomina->uf_load_seguridad_reporte("SNR","sigesp_snorh_r_resumennomina.php",$ls_descripcion);
		return $lb_valido;
	}
	//-----------------------------------------------------------------------------------------------------------------------------------

	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_print_encabezado_pagina($as_titulo,$as_rango,$io_pdf)
	{
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_encabezado_pagina
		//		   Access: private 
		//	    Arguments: as_titulo // Ttulo del Reporte
		//	    		   as_desnom // Descripcion de la nomina
		//	    		   as_periodo // Descripcion del Periodo
		//	    		   io_pdf // Instancia de objeto pdf
		//    Description: funcion que imprime los encabezados por pgina
		//	   Creado Por: Ing. Yesenia Moreno
		// Fecha Creacion: 27/04/2006 
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
		$io_encabezado=$io_pdf->openObject();
		$io_pdf->saveState();
		$io_pdf->line(50,40,555,40);
		$io_pdf->addJpegFromFile('../../shared/imagebank/'.$_SESSION["ls_logo"],50,720,$_SESSION["ls_width"],$_SESSION["ls_height"]); // Agregar Logo
		$li_tm=$io_pdf->getTextWidth(11,$as_titulo);
		$tm=306-($li_tm/2);
		$io_pdf->addText($tm,730,11,$as_titulo); // Agregar el ttulo
		$li_tm=$io_pdf->getTextWidth(11,$as_rango);
		$tm=306-($li_tm/2);
		$io_pdf->addText($tm,720,11,$as_rango); // Agregar el ttulo
		$io_pdf->addText(512,750,8,date("d/m/Y")); // Agregar la Fecha
		$io_pdf->addText(518,743,7,date("h:i a")); // Agregar la Hora
		$io_pdf->restoreState();
		$io_pdf->closeObject();
		$io_pdf->addObject($io_encabezado,'all');
	}// end function uf_print_encabezado_pagina
	//-----------------------------------------------------------------------------------------------------------------------------------
	
	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_print_cabecera($as_codnom,$as_desnom,$io_pdf)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_cabecera
		//		   Access: private 
		//	    Arguments: as_codconc // Codigo de Concepto
		//	   			   as_nomcon // Nombre de Concepto
		//	    		   io_pdf // Instancia de objeto pdf
		//    Description: funcion que imprime la cabecera por concepto
		//	   Creado Por: Ing. Yesenia Moreno
		// Fecha Creacion: 27/04/2006 
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf, $io_cabecera;
		$io_pdf->saveState();
        $io_pdf->setColor(0.9,0.9,0.9);
        $io_pdf->filledRectangle(50,690,501.5,$io_pdf->getFontHeight(14));
        $io_pdf->setColor(0,0,0);
		$io_pdf->addText(55,695,11,'<b>Nomina</b>  '.$as_codnom.' - '.$as_desnom.''); // Agregar el ttulo
		$io_pdf->restoreState();
		$io_pdf->closeObject();
		$io_pdf->addObject($io_cabecera,'all');
	}// end function uf_print_cabecera
	//-----------------------------------------------------------------------------------------------------------------------------------

	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_print_detalle($la_data,$io_pdf)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_detalle
		//		   Access: private 
		//	    Arguments: la_data // arreglo de informacion
		//	    		   io_pdf // Instancia de objeto pdf
		//    Description: funcion que imprime el detalle por concepto
		//	   Creado Por: Ing. Yesenia Moreno
		// Fecha Creacion: 27/04/2006 
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
		$io_pdf->ezSety(688);
		$la_columnas=array('periodo'=>'<b>Periodo</b>',
						   'desde'=>'<b>Fecha Desde</b>',
						   'hasta'=>'<b>Fecha Hasta</b>',
						   'cerrada'=>'<b>Cerrada</b>',
						   'nomina'=>'<b>Nomina Contabilizada</b>',
						   'aporte'=>'<b>Aporte Contabilizado</b>',
						   'monto'=>'<b>Total         </b>');
		$la_config=array('showHeadings'=>1, // Mostrar encabezados
						 'fontSize' => 9, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>1, // Mostrar Lneas
						 'shaded'=>0, // Sombra entre lneas
						 'width'=>500, // Ancho de la tabla
						 'maxWidth'=>500, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
				         'outerLineThickness'=>0.5,
						 'innerLineThickness' =>0.5,
						 'cols'=>array('periodo'=>array('justification'=>'center','width'=>60), // Justificacion y ancho de la columna
						 			   'desde'=>array('justification'=>'center','width'=>80), // Justificacion y ancho de la columna
						 			   'hasta'=>array('justification'=>'center','width'=>80), // Justificacion y ancho de la columna
						 			   'cerrada'=>array('justification'=>'center','width'=>60), // Justificacion y ancho de la columna
						 			   'nomina'=>array('justification'=>'center','width'=>70), // Justificacion y ancho de la columna
						 			   'aporte'=>array('justification'=>'center','width'=>70), // Justificacion y ancho de la columna
						 			   'monto'=>array('justification'=>'right','width'=>80))); // Justificacion y ancho de la columna
		$io_pdf->ezTable($la_data,$la_columnas,'',$la_config);
	}// end function uf_print_detalle
	//-----------------------------------------------------------------------------------------------------------------------------------

	//-----------------------------------------------------------------------------------------------------------------------------------
	function uf_print_piecabecera($ai_total,$io_pdf)
	{
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_piecabecera
		//		   Access: private 
		//	    Arguments: ai_personal // Total por personal
		//	   			   ai_patron // Total por patron
		//	   			   ai_total // Total 
		//	    		   io_pdf // Instancia de objeto pdf
		//    Description: funcion que imprime el fin de la cabecera por concepto
		//	   Creado Por: Ing. Yesenia Moreno
		// Fecha Creacion: 27/04/2006 
		/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
		global $ls_bolivares;
		$la_data=array(array('name'=>'<b>Monto Total de la Nomina '.$ls_bolivares.'</b>','total'=>$ai_total));
		$la_columna=array('name'=>'','total'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 9, // Tamao de Letras
						 'titleFontSize' => 12,  // Tamao de Letras de los ttulos
						 'showLines'=>1, // Mostrar Lneas
						 'shaded'=>2, // Sombra entre lneas
						 'shadeCol'=>array((249/255),(249/255),(249/255)), // Color de la sombra
						 'shadeCol2'=>array((249/255),(249/255),(249/255)), // Color de la sombra
				         'outerLineThickness'=>0.5,
						 'innerLineThickness' =>0.5,
						 'width'=>500, // Ancho de la tabla
						 'maxWidth'=>500, // Ancho Mximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('name'=>array('justification'=>'right','width'=>420), // Justificacion y ancho de la columna
						 			   'total'=>array('justification'=>'right','width'=>80))); // Justificacion y ancho de la columna
		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);
        $io_pdf->setColor(0,0,0);
	}
	//-----------------------------------------------------------------------------------------------------------------------------------

	//-----------------------------------------------------  Instancia de las clases  ------------------------------------------------
	require_once("../../shared/ezpdf/class.ezpdf.php");
	require_once("sigesp_snorh_class_report.php");
	$io_report=new sigesp_snorh_class_report();
	require_once("../../shared/class_folder/class_funciones.php");
	$io_funciones=new class_funciones();				
	require_once("../class_folder/class_funciones_nomina.php");
	$io_fun_nomina=new class_funciones_nomina();
	require_once("../../shared/class_folder/class_fecha.php");
	$io_fecha=new class_fecha();
	//----------------------------------------------------  Parmetros del encabezado  -----------------------------------------------
	$ls_titulo="<b>Resumen de Nomina</b>";
	//--------------------------------------------------  Parmetros para Filtar el Reporte  -----------------------------------------
	$ls_codnomdes=$io_fun_nomina->uf_obtenervalor_get("codnomdes","");
	$ls_codnomhas=$io_fun_nomina->uf_obtenervalor_get("codnomhas","");
	$ls_rango= "Nomina Desde: ".$ls_codnomdes." Nomina Hasta: ".$ls_codnomhas;
	//--------------------------------------------------------------------------------------------------------------------------------
	$lb_valido=uf_insert_seguridad($ls_titulo,$ls_rango); // Seguridad de Reporte
	if($lb_valido)
	{
		$lb_valido=$io_report->uf_resumennomina($ls_codnomdes,$ls_codnomhas); // Cargar el DS con los datos del reporte
	}
	if($lb_valido==false) // Existe algn error o no hay registros
	{
		print("<script language=JavaScript>");
		print(" alert('No hay nada que Reportar');"); 
		print(" close();");
		print("</script>");
	}
	else  // Imprimimos el reporte
	{
		set_time_limit(1800);
		$io_pdf=new Cezpdf('LETTER','portrait'); // Instancia de la clase PDF
		$io_pdf->selectFont('../../shared/ezpdf/fonts/Helvetica.afm'); // Seleccionamos el tipo de letra
		$io_pdf->ezSetCmMargins(3.60,2.5,3,3); // Configuracion de los margenes en centmetros
		uf_print_encabezado_pagina($ls_titulo,$ls_rango,$io_pdf); // Imprimimos el encabezado de la pgina
		$io_pdf->ezStartPageNumbers(550,50,10,'','',1); // Insertar el nmero de pgina
		$ls_codnomant='';
		while((!$io_report->rs_data->EOF)&&($lb_valido))
		{
			$ls_cerper=$io_report->rs_data->fields["cerper"];
			if ($ls_cerper==1)
			{
				$ls_cerper="X";
			}
			else
			{
				$ls_cerper="";			
			}
			$ls_conper=$io_report->rs_data->fields["conper"];
			if ($ls_conper==1)
			{
				$ls_conper="X";
			}
			else
			{
				$ls_conper="";			
			}
			$ls_apoconper=$io_report->rs_data->fields["apoconper"];
			if ($ls_apoconper==1)
			{
				$ls_apoconper="X";
			}
			else
			{
				$ls_apoconper="";			
			}
			$ls_codnom=$io_report->rs_data->fields["codnom"];
			$ls_desnom=$io_report->rs_data->fields["desnom"];
			$li_totper=$io_report->rs_data->fields["totper"];
			$ls_codperi=$io_report->rs_data->fields["codperi"];
			$ld_fecdesper=$io_report->rs_data->fields["fecdesper"];
			$ld_fechasper=$io_report->rs_data->fields["fechasper"];
			if($ls_codnomant<>$ls_codnom)
			{
				if ($ls_codnomant<>'')
				{
					uf_print_detalle($la_data,$io_pdf); // Imprimimos el detalle 
					uf_print_piecabecera($io_fun_nomina->uf_formatonumerico(abs($li_montoacumulado)),$io_pdf); // Imprimimos el pie de la cabecera
					$io_pdf->stopObject($io_cabecera); // Detener el objeto cabecera
					$io_pdf->ezNewPage(); // Insertar una nueva pgina
					unset($io_cabecera);
					unset($la_data);
				}
				$li_s=0;
				$li_montoacumulado=0;
				$io_cabecera=$io_pdf->openObject(); // Creamos el objeto cabecera
				uf_print_cabecera($ls_codnom,$ls_desnom,$io_pdf); // Imprimimos la cabecera del registro
				$la_data[$li_s]=array('periodo'=>$ls_codperi,'desde'=>$ld_fecdesper,'hasta'=>$ld_fechasper,'cerrada'=>$ls_cerper,
				                      'nomina'=>$ls_conper,'aporte'=>$ls_apoconper,'monto'=>$io_fun_nomina->uf_formatonumerico(abs($li_totper)));					
				$li_s++;
				$li_montoacumulado=$li_montoacumulado+$li_totper;
				$ls_codnomant=$ls_codnom;
			}
			else
			{
				$la_data[$li_s]=array('periodo'=>$ls_codperi,'desde'=>$ld_fecdesper,'hasta'=>$ld_fechasper,'cerrada'=>$ls_cerper,
				                      'nomina'=>$ls_conper,'aporte'=>$ls_apoconper,'monto'=>$io_fun_nomina->uf_formatonumerico(abs($li_totper)));					
				$li_s++;
				$li_montoacumulado=$li_montoacumulado+$li_totper;
			}
			$io_report->rs_data->MoveNext();	
		}		
		if($lb_valido) // Si no ocurrio ningn error
		{
			uf_print_detalle($la_data,$io_pdf); // Imprimimos el detalle 
			uf_print_piecabecera($io_fun_nomina->uf_formatonumerico(abs($li_montoacumulado)),$io_pdf); // Imprimimos el pie de la cabecera
			$io_pdf->stopObject($io_cabecera); // Detener el objeto cabecera
			unset($io_cabecera);
			unset($la_data);
			$io_pdf->ezStopPageNumbers(1,1); // Detenemos la impresion de los nmeros de pgina
			$io_pdf->ezStream(); // Mostramos el reporte
		}
		else // Si hubo algn error
		{
			print("<script language=JavaScript>");
			print(" alert('Ocurrio un error al generar el reporte. Intente de Nuevo');"); 
			print(" close();");
			print("</script>");		
		}
		unset($io_pdf);
	}
	unset($io_report);
	unset($io_funciones);
	unset($io_fun_nomina);
?> 
