<?php
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//  ESTE FORMATO SE IMPRIME EN Bs Y EN BsF. SEGUN LO SELECCIONADO POR EL USUARIO
	//  MODIFICADO POR: ING.YOZELIN BARRAGAN         FECHA DE MODIFICACION : 03/09/2007
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	session_start();   
	header("Pragma: public");
	header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
	header("Cache-Control: private",false);
	if(!array_key_exists("la_logusr",$_SESSION))
	{
		print "<script language=JavaScript>";
		print "close();";
		print "</script>";		
	}
	//--------------------------------------------------------------------------------------------------------------------------------
	function uf_print_encabezado_pagina($as_titulo,$as_fecha,$io_pdf)
	{
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_encabezadopagina
		//		   Access: private 
		//	    Arguments: as_titulo // Título del Reporte
		//	    		   as_desnom // Descripcion de la nomina
		//	    		   as_fecha // Fecha 
		//	    		   io_pdf // Instancia de objeto pdf
		//    Description: funcion que imprime los encabezados por página
		//	   Creado Por: Ing. Luis Anibal Lang
		// Fecha Creacion: 26/04/2006 
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
		$io_encabezado=$io_pdf->openObject();
		$io_pdf->saveState();
		$io_pdf->setStrokeColor(0,0,0);
		$io_pdf->line(10,40,775,40);
		$io_pdf->addJpegFromFile('../../shared/imagebank/'.$_SESSION["ls_logo"],9,530,$_SESSION["ls_width"],$_SESSION["ls_height"]); // Agregar Logo
		$li_tm=$io_pdf->getTextWidth(11,$as_titulo);
		$tm=396-($li_tm/2);
		$io_pdf->addText($tm,550,11,$as_titulo); // Agregar el título
		$li_tm=$io_pdf->getTextWidth(11,$as_fecha);
		$tm=396-($li_tm/2);
		$io_pdf->addText($tm,535,11,$as_fecha); // Agregar el título
		$io_pdf->addText(730,565,8,date("d/m/Y")); // Agregar la Fecha
		$io_pdf->addText(735,558,7,date("h:i a")); // Agregar la Hora
		$io_pdf->restoreState();
		$io_pdf->closeObject();
		$io_pdf->addObject($io_encabezado,'all');
	}// end function uf_print_encabezadopagina
	//--------------------------------------------------------------------------------------------------------------------------------
	
	//--------------------------------------------------------------------------------------------------------------------------------
	function uf_print_cabecera($as_nomemp,$io_pdf)
	{
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_cabecera
		//		   Access: private 
		//	    Arguments: as_nomemp    // nombre de la empresa
		//	    		   io_pdf       // total de registros que va a tener el reporte
		//    Description: funcion que imprime la cabecera de cada página
		//	   Creado Por: Ing. Yesenia Moreno
		// Fecha Creacion: 21/04/2006 
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
		$la_data=array(array('name'=>''));
		$la_columna=array('name'=>'');
		$la_config=array('showHeadings'=>1, // Mostrar encabezados
						 'fontSize' => 11, // Tamaño de Letras
						 'showLines'=>0, // Mostrar Líneas
						 'shaded'=>0	, // Sombra entre líneas
						 'shadeCol'=>array(0.9,0.9,0.9), // Color de la sombra
						 'shadeCol2'=>array(0.9,0.9,0.9), // Color de la sombra
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'width'=>730, // Ancho de la tabla
						 'maxWidth'=>730); // Ancho Máximo de la tabla
		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);	
	}// end function uf_print_cabecera
	//--------------------------------------------------------------------------------------------------------------------------------

	//--------------------------------------------------------------------------------------------------------------------------------
	function uf_print_detalle($la_data,$io_pdf)
	{
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_detalle
		//		   Access: private 
		//	    Arguments: la_data // arreglo de informacion
		//	   			   io_pdf // Objeto PDF
		//    Description: funcion que imprime el detalle
		//	   Creado Por: Ing. Yesenia Moreno
		// Fecha Creacion: 21/04/2006 
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
		global $ls_tipoformato;
		if($ls_tipoformato==0)
		{
		  $ls_titulo="Bs.";
		}
		elseif($ls_tipoformato==1)
		{
		  $ls_titulo="Bs.F.";
		}
		$la_columna=array('codigo'=>'<b>Codigo</b>',
						  'articulo'=>'<b>Artículo</b>',
						  'unidad'=>'<b>Unidad</b>',
						  'existencia'=>'<b>Existencia</b>',
						  'cospro'=>'<b>Costo Promedio '.$ls_titulo.'</b>',
						  'totcospro'=>'<b>Total a Costo Promedio '.$ls_titulo.'</b>',
						  'ultcosart'=>'<b>Último Costo '.$ls_titulo.'</b>',
						  'totultcos'=>'<b>Total a Último Costo '.$ls_titulo.'</b>');
		$la_config=array('showHeadings'=>1, // Mostrar encabezados
						 'fontSize' => 8, // Tamaño de Letras
						 'titleFontSize' => 9,  // Tamaño de Letras de los títulos
						 'showLines'=>1, // Mostrar Líneas
						 'shaded'=>0, // Sombra entre líneas
						 'width'=>900, // Ancho de la tabla
						 'maxWidth'=>900, // Ancho Máximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('codigo'=>array('justification'=>'left','width'=>110), // Justificacion y ancho de la columna
						 			   'articulo'=>array('justification'=>'left','width'=>178), // Justificacion y ancho de la columna
						 			   'unidad'=>array('justification'=>'left','width'=>70), // Justificacion y ancho de la columna
						 			   'existencia'=>array('justification'=>'right','width'=>75), // Justificacion y ancho de la columna
						 			   'cospro'=>array('justification'=>'right','width'=>80), // Justificacion y ancho de la columna
						 			   'totcospro'=>array('justification'=>'right','width'=>85), // Justificacion y ancho de la columna
						 			   'ultcosart'=>array('justification'=>'right','width'=>80), // Justificacion y ancho de la columna
						 			   'totultcos'=>array('justification'=>'right','width'=>85))); // Justificacion y ancho de la columna
		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);
	}// end function uf_print_detalle
	//--------------------------------------------------------------------------------------------------------------------------------

	//--------------------------------------------------------------------------------------------------------------------------------
	function uf_print_totales($la_data,$io_pdf)
	{
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//       Function: uf_print_totales
		//		   Access: private 
		//	    Arguments: la_data // arreglo de informacion
		//	   			   io_pdf // Instancia de objeto pdf
		//    Description: funcion que imprime el detalle por personal
		//	   Creado Por: Ing. Yesenia Moreno
		// Fecha Creacion: 06/07/2006 
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		global $io_pdf;
		$la_columna=array('total'=>'',
						  'existencia'=>'',
						  'cospro'=>'',
						  'totcospro'=>'',
						  'ultcosart'=>'',
						  'totultcos'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'fontSize' => 8, // Tamaño de Letras
						 'titleFontSize' => 11,  // Tamaño de Letras de los títulos
						 'showLines'=>1, // Mostrar Líneas
						 'shaded'=>0, // Sombra entre líneas
						 'width'=>670, // Ancho de la tabla
						 'maxWidth'=>670, // Ancho Máximo de la tabla
						 'xOrientation'=>'center', // Orientacion de la tabla
						 'cols'=>array('total'=>array('justification'=>'right','width'=>358), // Justificacion y ancho de la columna
						 			   'existencia'=>array('justification'=>'right','width'=>75), // Justificacion y ancho de la columna
						 			   'cospro'=>array('justification'=>'right','width'=>80), // Justificacion y ancho de la columna
						 			   'totcospro'=>array('justification'=>'right','width'=>85), // Justificacion y ancho de la columna
						 			   'ultcosart'=>array('justification'=>'right','width'=>80), // Justificacion y ancho de la columna
						 			   'totultcos'=>array('justification'=>'right','width'=>85))); // Justificacion y ancho de la columna
		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);
		$la_data=array(array('name'=>''));
		$la_columna=array('name'=>'');
		$la_config=array('showHeadings'=>0, // Mostrar encabezados
						 'showLines'=>0, // Mostrar Líneas
						 'shaded'=>0, // Sombra entre líneas
						 'width'=>660, // Ancho Máximo de la tabla
						 'xOrientation'=>'center'); // Orientacion de la tabla
		$io_pdf->ezTable($la_data,$la_columna,'',$la_config);
	}// end function uf_print_totales
	//--------------------------------------------------------------------------------------------------------------------------------

	//-----------------------------------------------------  Instancia de las clases  ------------------------------------------------
	require_once("../../shared/ezpdf/class.ezpdf.php");
	require_once("../../shared/class_folder/class_funciones.php");
	$io_funciones=new class_funciones();				
	require_once("../class_funciones_inventario.php");
	$io_fun_inventario=new class_funciones_inventario();
	$ls_tipoformato=$io_fun_inventario->uf_obtenervalor_get("tipoformato",0);
	global $ls_tipoformato;
	if($ls_tipoformato==1)
	{
		require_once("sigesp_siv_class_reportbsf.php");
		$io_report=new sigesp_siv_class_reportbsf();
		$ls_titulo_report="Bs.F.";
	}
	else
	{
		require_once("sigesp_siv_class_report.php");
		$io_report=new sigesp_siv_class_report();
		$ls_titulo_report="Bs.";
	}	
	//----------------------------------------------------  Parámetros del encabezado  -----------------------------------------------
	$ld_desde=$io_fun_inventario->uf_obtenervalor_get("desde","");
	$ld_hasta=$io_fun_inventario->uf_obtenervalor_get("hasta","");

	$ls_titulo="<b> Valoracion de Inventario ".$ls_titulo_report."</b>";
	if($ld_desde!="")
	{$ls_fecha="<b> Periodo ".$ld_desde." - ".$ld_hasta."</b>";}
	else
	{$ls_fecha="";}
	//--------------------------------------------------  Parámetros para Filtar el Reporte  -----------------------------------------
	$ls_codemp=$_SESSION["la_empresa"]["codemp"];
	$ls_nomemp=$_SESSION["la_empresa"]["nombre"];
	$ls_coddesde=$io_fun_inventario->uf_obtenervalor_get("coddesde","");
	$ls_codhasta=$io_fun_inventario->uf_obtenervalor_get("codhasta","");
	$li_ordenart=$io_fun_inventario->uf_obtenervalor_get("ordenart","");
	//--------------------------------------------------------------------------------------------------------------------------------
	$lb_valido=$io_report->uf_select_articulosmovimientos($ls_codemp,$ls_coddesde,$ls_codhasta,$ld_desde,$ld_hasta,$li_ordenart); // Cargar el DS con los datos de la cabecera del reporte
	if($lb_valido==false) // Existe algún error o no hay registros
	{
		print("<script language=JavaScript>");
		print(" alert('No hay nada que Reportar');"); 
		print(" close();");
		print("</script>");
	}
	else // Imprimimos el reporte
	{
		/////////////////////////////////         SEGURIDAD               ////////////////////////////////////////////////////////////////////////////////////////////////////
		$ls_desc_event="Genero el Reporte Valoracion de Inventario Desde el articulo ".$ls_coddesde." hasta ".$ls_codhasta." Periodo  de fechas ".$ld_desde." - ".$ld_hasta;
		$io_fun_inventario->uf_load_seguridad_reporte("SIV","sigesp_siv_r_valinventario.php",$ls_desc_event);
		////////////////////////////////         SEGURIDAD               /////////////////////////////////////////////////////////////////////////////////////////////////////
		error_reporting(E_ALL);
		set_time_limit(1800);
		$io_pdf=new Cezpdf('LETTER','landscape'); // Instancia de la clase PDF
		$io_pdf->selectFont('../../shared/ezpdf/fonts/Helvetica.afm'); // Seleccionamos el tipo de letra
		$io_pdf->ezSetCmMargins(3.5,3,3,3); // Configuracion de los margenes en centímetros
		uf_print_encabezado_pagina($ls_titulo,$ls_fecha,$io_pdf); // Imprimimos el encabezado de la página
		$io_pdf->ezStartPageNumbers(760,50,10,'','',1); // Insertar el número de página
		$li_totrow=$io_report->ds->getRowCount("codart");
		uf_print_cabecera($ls_nomemp,$io_pdf); // Imprimimos la cabecera del registro
		$li_totalexi=0;
		$li_totalpro=0;
		$li_totalult=0;
		for($li_i=1;$li_i<=$li_totrow;$li_i++)
		{
		   // $io_pdf->transaction('start'); // Iniciamos la transaccion
			$li_numpag=$io_pdf->ezPageCount; // Número de página
			$li_totent=0;
			$li_totsal=0;
			$ls_codart=$io_report->ds->data["codart"][$li_i];
			$li_cospro=0;
			$li_ultcos=0;
			$arrResultado=$io_report->uf_select_promedio($ls_codemp,$ls_codart,$ld_desde,$ld_hasta,$li_cospro); // Obtenemos el detalle del reporte
			$li_cospro = $arrResultado['li_cosprom'];
			$lb_valido = $arrResultado['lb_valido'];
			if($lb_valido)
			{
				$li_totrow_det=$io_report->ds->getRowCount("codart");
			//	$ls_codart= $io_report->ds_detalle->data["codart"][1];
				$ls_denart= $io_report->ds_detalle->data["denart"][1];
				$ls_denunimed= $io_report->ds_detalle->data["denunimed"][1];
				$li_exiart= $io_report->ds_detalle->data["exiart"][1];
				$li_ultcos= $io_report->ds_detalle->data["ultimo"][1];
				if(($li_cospro==0)&&($li_exiart==0))
				{
					$li_ultcos=0;
				}
				$li_totcospro= ($li_exiart * $li_cospro);
				$li_totultcos= ($li_exiart * $li_ultcos);
				$li_totalexi=$li_totalexi + $li_exiart;
				$li_totalpro=$li_totalpro + $li_totcospro;
				$li_totalult=$li_totalult + $li_totultcos;
				
				$li_cospro=number_format($li_cospro,2,",",".");
				$li_exiart=number_format($li_exiart,2,",",".");
				$li_ultcos=number_format($li_ultcos,2,",",".");
				$li_totcospro=number_format($li_totcospro,2,",",".");
				$li_totultcos=number_format($li_totultcos,2,",",".");
				
				$la_data[$li_i]=array('codigo'=>$ls_codart,'articulo'=>$ls_denart,'unidad'=>$ls_denunimed,
									  'existencia'=>$li_exiart,'cospro'=>$li_cospro,'totcospro'=>$li_totcospro,
									  'ultcosart'=>$li_ultcos,'totultcos'=>$li_totultcos);
			}
		}
		$li_totalexi=number_format($li_totalexi,2,",",".");
		$li_totalpro=number_format($li_totalpro,2,",",".");
		$li_totalult=number_format($li_totalult,2,",",".");
		$la_datat[1]=array('total'=>"Total",'existencia'=>$li_totalexi,'cospro'=>"--",'totcospro'=>$li_totalpro,
						   'ultcosart'=>"--",'totultcos'=>$li_totalult);
		uf_print_detalle($la_data,$io_pdf); // Imprimimos el detalle 
		uf_print_totales($la_datat,$io_pdf); // Imprimimos el detalle 
		unset($la_data);			
		/*if($lb_valido)
		{*/
			$io_pdf->ezStopPageNumbers(1,1);
			$io_pdf->ezStream();
		//}
		unset($io_pdf);
	}
	unset($io_report);
	unset($io_funciones);
	unset($io_fun_nomina);
?> 